# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['mrxcavator']
install_requires = \
['PyInquirer==1.0.3',
 'asciichartpy==1.5.21',
 'requests>=2.24.0,<3.0.0',
 'termtables>=0.2.2,<0.3.0',
 'tqdm>=4.48.0,<5.0.0',
 'validators>=0.16.0,<0.17.0']

entry_points = \
{'console_scripts': ['mrxcavator = mrxcavator:main']}

setup_kwargs = {
    'name': 'mrxcavator',
    'version': '0.6.2',
    'description': 'CLI client for CRXcavator.io',
    'long_description': '# mrxcavator\n\nmrxcavator is a CLI client implementation for the service [CRXcavator.io](https://crxcavator.io).\n\n## Overview\n\nThe following overview was taken from the service\'s [about](https://crxcavator.io/docs#/README) page:\n> CRXcavator automatically scans the entire Chrome Web Store every 3 hours and produces a quantified risk score for each Chrome Extension based on several factors. These factors include permissions, inclusion of vulnerable third party javascript libraries, weak content security policies, missing details from the Chrome Web Store description, and more. Organizations can use this tool to assess the Chrome Extensions they have installed and to move towards implementing explicit allow (whitelisting) for their organization.\n\n## Using mrxcavator\n\n### Installation\n**Python >=3.6.1 is required for application compatibility.**\n\n#### PyPI\n* Execute `pip3 install mrxcavator`\n* Execute `mrxcavator`\n\n#### Git\n* Execute `git clone https://github.com/mstanislav/mrxcavator.git` to download the repository\n* Execute `cd mrxcavator` to enter the application\'s root folder\n* Execute `pip3 install -r requirements.txt` to install Python dependencies\n* Execute `python3 mrxcavator.py`\n\n### Help Output\n```\n➜  mrxcavator -h\nusage: mrxcavator    [-c filename] [--extension_path path]\n                     [--crxcavator_key key] [--crxcavator_uri uri]\n                     [--virustotal_key key] [--test_crxcavator_key]\n                     [--test_crxcavator_uri] [--test_virustotal_key] [-s [id]]\n                     [--submit_all] [-r [id]] [--report_all]\n                     [--report_all_table] [--export [filename]]\n                     [--input [filename]] [-e] [-g [id]] [-vt [id]] [-v] [-h]\n\nFeatures:\n  -s [id], --submit [id]\n                        submit an extension\n  --submit_all          submit all installed extensions\n  -r [id], --report [id]\n                        get an extension\'s report\n  --report_all          retrieve a report for all installed extensions\n  --report_all_table    retrieve a table of details for installed extensions\n  --export [filename]   export a report to a specific filename\n  --input [filename]    load a specific filename for extension identifiers\n  -e, --extensions      list installed extensions\n  -g [id], --graph [id]\n                        get a graph of an extension\'s risk\n  -vt [id], --virustotal [id]\n                        get VirusTotal data for an extension\'s external calls\n\nSet Configuration:\n  -c filename, --config filename\n                        specify a configuration filename\n  --extension_path path\n                        set path to local Chrome extensions\n  --crxcavator_key key  set CRXcavator API key\n  --crxcavator_uri uri  set CRXcavator API URI\n  --virustotal_key key  set VirusTotal API key\n\nTest Configuration:\n  --test_crxcavator_key\n                        test CRXcavator API key\n  --test_crxcavator_uri\n                        test CRXcavator API URI\n  --test_virustotal_key\n                        test VirusTotal API key\n\nMiscellaneous:\n  -v, --version         show program\'s version number and exit\n  -h, --help            show program\'s help information and exit\n```\n\n### Submit an Extension\nIf no extension identifier is passed to the flag, a list of locally installed extensions will be given to select from.\n```\n➜  mrxcavator -s hdokiejnpimakedhajhdlcegeplioahd\n\n\tYou\'ve successfully submitted hdokiejnpimakedhajhdlcegeplioahd.\n```\n\n### Submit All Locally Installed Extensions\nThis feature supports `--input [filename]` to load extension identifiers from a text file.\n```\n➜  mrxcavator --submit_all\n\nSubmitting extensions found in ~/Library/Application Support/Google/Chrome/Default/Extensions/\n\n100%|████████████████████████████████████████████████████████████████████████\n\nSuccessful:\n  > Application Launcher for Drive (by Google)\n  > Bitwarden - Free Password Manager\n  > Cisco Webex Extension\n  > Gmail\n  > Google Docs Offline\n  > Google Drive\n  > Google Keep Chrome Extension\n  > Honey\n  > Save to Google Drive\n  > Save to Pocket\n  > YouTube\n  > Zoom\n```\n\n### Get an Extension\'s Report\nIf no extension identifier is passed to the flag, a list of locally installed extensions will be given to select from.\n```\n➜  mrxcavator -r bmnlcjabgnpnenekpadlanbbkooimhnj\n\nExtension Overview\n============================================================\n  Extension Name:       Honey\n  Extension ID:         bmnlcjabgnpnenekpadlanbbkooimhnj\n  Web Site:             https://www.joinhoney.com\n\n  Newest Version:       12.4.0 (2020-07-23)\n  Versions Known:       45\n  Store Rating:         4.84 stars\n\n  Total Risk Score:     604\n\n\nContent Security Policy\n============================================================\n  386   Total\n------------------------------------------------------------\n  25    child-src\n  25    connect-src\n  25    font-src\n  25    form-action\n  25    frame-ancestors\n  25    frame-src\n  25    img-src\n  25    manifest-src\n  25    media-src\n  1     object-src\n  25    plugin-types\n  25    sandbox\n  10    script-src\n  25    strict-dynamic\n  25    style-src\n  25    upgrade-insecure-requests\n  25    worker-src\n\n\nRetireJS\n============================================================\n  80    Total\n------------------------------------------------------------\n  0     Low\n  80    Medium\n  0     High\n  0     Critical\n\n\nPermissions\n============================================================\n  135   Total\n------------------------------------------------------------\n  135   Required\n  0     Optional\n```\n\n### Save an Extension\'s Report to a File\nIf no extension identifier is passed to the flag, a list of locally installed extensions will be given to select from.\n```\n➜  mrxcavator -r hdokiejnpimakedhajhdlcegeplioahd --export lastpass.txt\n\nExtension Overview\n============================================================\n  Extension Name:       LastPass: Free Password Manager\n  Extension ID:         hdokiejnpimakedhajhdlcegeplioahd\n  Web Site:             https://www.lastpass.com/\n\n  Newest Version:       4.53.0.2 (2020-07-29)\n  Versions Known:       45\n  Store Rating:         4.54 stars\n\n  Total Risk Score:     395\n\n\nContent Security Policy\n============================================================\n  70    Total\n------------------------------------------------------------\n  1     child-src\n  37    connect-src\n  1     font-src\n  1     form-action\n  1     frame-ancestors\n  8     frame-src\n  5     img-src\n  1     manifest-src\n  1     media-src\n  1     object-src\n  1     plugin-types\n  1     sandbox\n  1     script-src\n  1     strict-dynamic\n  7     style-src\n  1     upgrade-insecure-requests\n  1     worker-src\n\n\nRetireJS\n============================================================\n  190   Total\n------------------------------------------------------------\n  20    Low\n  80    Medium\n  90    High\n  0     Critical\n\n\nPermissions\n============================================================\n  135   Total\n------------------------------------------------------------\n  110   Required\n  25    Optional\n\n\nExternal Calls\n============================================================\n  - https://www.dropbox.com/logout\n  - https://www.netflix.com/Login\n  - https://blog.lastpass.com/2019/03/new-improved-look-lastpass.html/\n  - http://nowhere.co\n  - https://lastpass.com/?securitychallenge=1\n  - https://lastpass.com/\n  - https://mint.intuit.com/login.event?task=S\n  - https://accounts.lastpass.com/federated/oidcredirect.html\n  - https://lastpass.com/forgot.php\n  - https://www.logmeininc.com/legal/privacy?fromwebsite=1\n  - https://lastpass.com/safariAppExtension.php?source=dropdown\n  - https://lastpass.com/?ac=1\n  - https://graph.microsoft.com/v1.0/me?$select=id,displayName,mail&$expand=extensions\n  - https://lastpass.com/experience-update\n  - https://lastpass.com/fake/fake.php\n  - https://support.logmeininc.com/lastpass/help/lastpass-authenticator-lp030014\n  - https://lastpass.com/features_joinpremium4.php?a=1\n  - https://www.lastpass.com/families/\n  - https://www.lastpass.com/families\n  - https://lastpass.eu/\n  - http://link.lastpass.com/InpUsrLpEmb\n\n\n>> Report saved in /Users/mstanislav/.mrxcavator/reports/lastpass.txt <<\n```\n\n### Get Reports For All Locally Installed Extensions\nThis feature supports `--input [filename]` to load extension identifiers from a text file.\n```\n➜  mrxcavator --report_all\n\nExtension Overview\n============================================================\n  Extension Name:       Honey\n  Extension ID:         bmnlcjabgnpnenekpadlanbbkooimhnj\n  Web Site:             https://www.joinhoney.com\n\n  Newest Version:       12.4.0 (2020-07-23)\n  Versions Known:       45\n  Store Rating:         4.84 stars\n\n  Total Risk Score:     604\n\n\nContent Security Policy\n============================================================\n  386   Total\n------------------------------------------------------------\n  25    child-src\n  25    connect-src\n  25    font-src\n  25    form-action\n  25    frame-ancestors\n  25    frame-src\n  25    img-src\n  25    manifest-src\n  25    media-src\n  1     object-src\n  25    plugin-types\n  25    sandbox\n  10    script-src\n  25    strict-dynamic\n  25    style-src\n  25    upgrade-insecure-requests\n  25    worker-src\n\n\nRetireJS\n============================================================\n  80    Total\n------------------------------------------------------------\n  0     Low\n  80    Medium\n  0     High\n  0     Critical\n\n\nPermissions\n============================================================\n  135   Total\n------------------------------------------------------------\n  135   Required\n  0     Optional\n\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\nExtension Overview\n============================================================\n  Extension Name:       Zoom\n  Extension ID:         hmbjbjdpkobdjplfobhljndfdfdipjhg\n\n  Newest Version:       5.0.4169.0628 (2020-06-30)\n  Versions Known:       26\n  Store Rating:         2.76 stars\n\n  Total Risk Score:     251\n\n\nRetireJS\n============================================================\n  180   Total\n------------------------------------------------------------\n  10    Low\n  140   Medium\n  30    High\n  0     Critical\n\n\nWeb Store\n============================================================\n  6     Total\n------------------------------------------------------------\n  1     Address\n  1     Last Updated\n  2     Rating\n  1     Rating Users\n  1     Website\n\n\nPermissions\n============================================================\n  65    Total\n------------------------------------------------------------\n  65    Required\n  0     Optional\n\n\nExternal Calls\n============================================================\n  - https://www.google.com/accounts/Logout\n  - http://www.w3.org/1998/Math/MathML\n  - https://www.zoom.us\n\n[...snip...]\n```\n\n### Get a Report Summary Table for All Locally Installed Extensions\nThis feature supports `--input [filename]` to load extension identifiers from a text file.\n```\n➜  mrxcavator --report_all_table\n┌────────────────────────────────────────────┬───────────────┬────────────┬────────┬──────┐\n│ Name                                       │ Version       │ Updated    │ Rating │ Risk │\n╞════════════════════════════════════════════╪═══════════════╪════════════╪════════╪══════╡\n│ Google Docs Offline                        │ 1.9.1         │ 2020-03-04 │ 2.87   │ 423  │\n├────────────────────────────────────────────┼───────────────┼────────────┼────────┼──────┤\n│ Honey                                      │ 12.3.2        │ 2020-07-13 │ 4.84   │ 657  │\n├────────────────────────────────────────────┼───────────────┼────────────┼────────┼──────┤\n│ Gmail                                      │ 8.2           │ 2019-03-26 │ 4.53   │ 15   │\n├────────────────────────────────────────────┼───────────────┼────────────┼────────┼──────┤\n│ Bitwarden - Free Password Manager          │ 1.45.0        │ 2020-06-30 │ 4.84   │ 508  │\n├────────────────────────────────────────────┼───────────────┼────────────┼────────┼──────┤\n│ Google Drive                               │ 14.2          │ 2018-10-16 │ 4.43   │ 41   │\n├────────────────────────────────────────────┼───────────────┼────────────┼────────┼──────┤\n│ Application Launcher for Drive (by Google) │ 3.2           │ 2014-11-10 │ 2.95   │ 399  │\n├────────────────────────────────────────────┼───────────────┼────────────┼────────┼──────┤\n│ Cisco Webex Extension                      │ 1.9.0         │ 2020-06-15 │ 2.4    │ 392  │\n├────────────────────────────────────────────┼───────────────┼────────────┼────────┼──────┤\n│ Google Keep Chrome Extension               │ 4.20282.540.1 │ 2020-07-13 │ 4.2    │ 497  │\n├────────────────────────────────────────────┼───────────────┼────────────┼────────┼──────┤\n│ Zoom                                       │ 5.0.4169.0628 │ 2020-06-30 │ 2.76   │ 230  │\n├────────────────────────────────────────────┼───────────────┼────────────┼────────┼──────┤\n│ Save to Pocket                             │ 3.0.6.8       │ 2019-07-24 │ 4.29   │ 478  │\n├────────────────────────────────────────────┼───────────────┼────────────┼────────┼──────┤\n│ Save to Google Drive                       │ 2.1.1         │ 2014-06-16 │ 4.06   │ 525  │\n├────────────────────────────────────────────┼───────────────┼────────────┼────────┼──────┤\n│ YouTube                                    │ 4.2.8         │ 2015-09-24 │ 4.52   │ 11   │\n└────────────────────────────────────────────┴───────────────┴────────────┴────────┴──────┘\n```\n\n### List Locally Installed Extensions\n```\n➜  mrxcavator -e\n\nExtensions Found in ~/Library/Application Support/Google/Chrome/Default/Extensions/\n┌────────────────────────────────────────────┬───────────────┬──────────────────────────────────┐\n│ Name                                       │ Version       │ Identifier                       │\n╞════════════════════════════════════════════╪═══════════════╪══════════════════════════════════╡\n│ Google Docs Offline                        │ 1.11.0        │ ghbmnnjooekpmoecnnnilnnbdlolhkhi │\n├────────────────────────────────────────────┼───────────────┼──────────────────────────────────┤\n│ Honey                                      │ 12.3.2        │ bmnlcjabgnpnenekpadlanbbkooimhnj │\n├────────────────────────────────────────────┼───────────────┼──────────────────────────────────┤\n│ Gmail                                      │ 8.2           │ pjkljhegncpnkpknbcohdijeoejaedia │\n├────────────────────────────────────────────┼───────────────┼──────────────────────────────────┤\n│ Bitwarden - Free Password Manager          │ 1.45.0        │ nngceckbapebfimnlniiiahkandclblb │\n├────────────────────────────────────────────┼───────────────┼──────────────────────────────────┤\n│ Google Drive                               │ 14.2          │ apdfllckaahabafndbhieahigkjlhalf │\n├────────────────────────────────────────────┼───────────────┼──────────────────────────────────┤\n│ Application Launcher for Drive (by Google) │ 3.2           │ lmjegmlicamnimmfhcmpkclmigmmcbeh │\n├────────────────────────────────────────────┼───────────────┼──────────────────────────────────┤\n│ Cisco Webex Extension                      │ 1.9.0         │ jlhmfgmfgeifomenelglieieghnjghma │\n├────────────────────────────────────────────┼───────────────┼──────────────────────────────────┤\n│ Google Keep Chrome Extension               │ 4.20282.540.1 │ lpcaedmchfhocbbapmcbpinfpgnhiddi │\n├────────────────────────────────────────────┼───────────────┼──────────────────────────────────┤\n│ Zoom                                       │ 5.0.4169.628  │ hmbjbjdpkobdjplfobhljndfdfdipjhg │\n├────────────────────────────────────────────┼───────────────┼──────────────────────────────────┤\n│ Save to Pocket                             │ 3.0.6.8       │ niloccemoadcdkdjlinkgdfekeahmflj │\n├────────────────────────────────────────────┼───────────────┼──────────────────────────────────┤\n│ Save to Google Drive                       │ 2.1.1         │ gmbmikajjgmnabiglmofipeabaddhgne │\n├────────────────────────────────────────────┼───────────────┼──────────────────────────────────┤\n│ YouTube                                    │ 4.2.8         │ blpcfgokakmgnkcojhhkbfbldkacnbeo │\n└────────────────────────────────────────────┴───────────────┴──────────────────────────────────┘\n```\n\n### Show a Graph of an Extension\'s Risk Score Over Time\nIf no extension identifier is passed to the flag, a list of locally installed extensions will be given to select from.\n```\n➜  mrxcavator -g bmnlcjabgnpnenekpadlanbbkooimhnj\n\n674 ┤\n668 ┤                                     ╭╮\n662 ┤                                     ││\n656 ┤                                     │╰────\n650 ┤                                     │\n644 ┤                 ╭╮                  │\n638 ┤                 ││                  │\n631 ┤                 ││               ╭──╯\n625 ┤                 ││               │\n619 ┤                 ││               │\n613 ┤     ╭─╮         ││        ╭──────╯\n607 ┤     │ │╭─╮      ││        │\n601 ┤     │ ││ │      ││        │\n595 ┤     │ ││ │      ││        │\n589 ┤     │ ││ │      ││        │\n583 ┤     │ ││ │      │╰─╮      │\n577 ┤     │ ││ │      │  │      │\n571 ┤     │ ││ │      │  │      │\n565 ┤     │ ││ │      │  │      │\n559 ┤     │ ││ │      │  │      │\n552 ┤     │ ││ │      │  │      │\n546 ┤     │ ││ │      │  │      │\n540 ┤     │ ││ │      │  │      │\n534 ┤     │ ││ │      │  │      │\n528 ┼─────╯ ╰╯ ╰──────╯  ╰╮     │\n522 ┤                     ╰─────╯\n516 ┤\n```\n\n### Retrieve VirusTotal Results for an Extension\'s "External Call" Hostnames\nIf no extension identifier is passed to the flag, a list of locally installed extensions will be given to select from.\n```\n➜  mrxcavator -vt hmbjbjdpkobdjplfobhljndfdfdipjhg\n\n** This API requires throttling. This extension will take approximately 0:01:05 to complete. **\n\nProcessing 3 hosts...\n * www.google.com, www.w3.org, www.zoom.us\n┌────────────────┬───────────┬───────┐\n│ Hostname       │ Positives │ Total │\n╞════════════════╪═══════════╪═══════╡\n│ www.google.com │ 0         │ 79    │\n├────────────────┼───────────┼───────┤\n│ www.w3.org     │ 1         │ 79    │\n├────────────────┼───────────┼───────┤\n│ www.zoom.us    │ 0         │ 79    │\n└────────────────┴───────────┴───────┘\n```\n\n### Set the CRXcavator API URI Value\n```\n➜  mrxcavator --crxcavator_uri https://api.crxcavator.io/v1\n\n\tThe CRXcavator API URI was set successfully!\n```\n\n### Set the CRXcavator API Key Value\n```\n➜  mrxcavator --crxcavator_key DEnDIwspwQkiMYZzuFbHOHUqDOpSaDIw\n\n\tThe CRXcavator API key was set successfully!\n```\n\n### Set the VirusTotal API Key Value\n```\n➜  mrxcavator --virustotal_key d42d8fb60105539a632d209ed35a42515722a79be2c39f5635d3790b25433acc\n\n\tThe VirusTotal API key was set successfully!\n```\n\n### Test Current CRXcavator API Base URI Setting\n```\n➜  mrxcavator --test_crxcavator_uri\n\n\tThe CRXcavator API URI was successfully tested!\n```\n\n### Test Current CRXcavator API Key Setting\n```\n➜  mrxcavator --test_crxcavator_key\n\n\tThe CRXcavator API key was successfully tested!\n```\n\n### Test Current VirusTotal API Key Setting\n```\n➜  mrxcavator --test_virustotal_key\n\n\tThe VirusTotal API key was successfully tested!\n```\n\n### Use a Custom Configuration File\n```\n➜  mrxcavator -c testing.ini\n\n\t/Users/mstanislav/.mrxcavator/testing.ini does not exist, or is corrupted. Creating it...\n\n➜  cat /Users/mstanislav/.mrxcavator/testing.ini\n[DEFAULT]\ncrxcavator_api_uri = https://api.crxcavator.io/v1\ncrxcavator_api_key =\nvirustotal_api_key =\nextension_path = ~/Library/Application Support/Google/Chrome/Default/Extensions/\n\n[custom]\n```\n\n### Get mrxcavator\'s Version\n```\n➜  mrxcavator -v\nv0.6.2\n```\n\n### Example `config.ini` Contents\n```\n➜  cat /Users/mstanislav/.mrxcavator/config.ini\n[DEFAULT]\ncrxcavator_api_uri = https://api.crxcavator.io/v1\ncrxcavator_api_key =\nvirustotal_api_key =\nextension_path = ~/Library/Application Support/Google/Chrome/Default/Extensions/\n\n[custom]\n```\n\n## Engineering Approach\n\n### [flake8](https://gitlab.com/pycqa/flake8)\n>`flake8` is a command-line utility for enforcing style consistency across Python projects. By default it includes lint checks provided by the PyFlakes project, PEP-0008 inspired style checks provided by the PyCodeStyle project, and McCabe complexity checking provided by the McCabe project.\n\n### [mypy](https://github.com/python/mypy)\n> `mypy` is an optional static type checker for Python. You can add type hints (PEP 484) to your Python programs, and use mypy to type check them statically. Find bugs in your programs without even running them!\n\n### [pdoc](https://github.com/pdoc3/pdoc)\n> `pdoc` the perfect documentation generator for small-to-medium-sized, tidy Python projects. It generates documentation simply from your project\'s already-existing public modules\' and objects\' docstrings, like sphinx-apidoc or sphinx.ext.autodoc, but without the hassle of these tools.\n\n### [black](https://github.com/psf/black)\n> `black` is the uncompromising Python code formatter. By using it, you agree to cede control over minutiae of hand-formatting. In return, Black gives you speed, determinism, and freedom from pycodestyle nagging about formatting. You will save time and mental energy for more important matters.\n\n### [PEP 484](https://www.python.org/dev/peps/pep-0484/)\n> PEP 3107 introduced syntax for function annotations, but the semantics were deliberately left undefined.  There has now been enough 3rd party usage for static type analysis that the community would benefit from a standard vocabulary and baseline tools within the standard library. This PEP introduces a provisional module to provide these standard definitions and tools, along with some conventions for situations where annotations are not available.\n\n### [Google\'s Python Style Guide](http://google.github.io/styleguide/pyguide.html)\n> Python is the main dynamic language used at Google. This style guide is a list of dos and don’ts for Python programs.\n\n**Note:** The use of this guide is primarily for [docstring formatting](http://google.github.io/styleguide/pyguide.html#38-comments-and-docstrings), which complements type hints nicely.\n\n### [argparse](https://docs.python.org/3.6/library/argparse.html)\n> The argparse module makes it easy to write user-friendly command-line interfaces. The program defines what arguments it requires, and argparse will figure out how to parse those out of sys.argv. The argparse module also automatically generates help and usage messages and issues errors when users give the program invalid arguments.\n',
    'author': 'Mark Stanislav',
    'author_email': 'mark.stanislav@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/mstanislav/mrxcavator',
    'py_modules': modules,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
