# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/13_cell.ipynb.

# %% auto 0
__all__ = ['magic_handler', 'Cell']

# %% ../nbs/13_cell.ipynb 3
from .stata_session import StataSession
from .magics import StataMagics
from fastcore.basics import patch_to

# %% ../nbs/13_cell.ipynb 4
magic_handler = StataMagics()

# %% ../nbs/13_cell.ipynb 5
class Cell:
    """A class for managing execution of a single code cell"""                  
    def __init__(self, kernel, code_w_magics, silent=False):
        self.noecho = kernel.nbstata_config.noecho
        self.echo = kernel.nbstata_config.echo
        self.quietly = silent
        self.stata_session = kernel.stata_session
        self.code = magic_handler.magic(code_w_magics, kernel, self)
       
    def run(self):
        if not self.code:
            return
        self.stata_session.dispatch_run(self.code, 
            quietly=self.quietly, echo=self.echo, noecho=self.noecho)
