import pickle

from nose.tools import eq_

from .. import tamil
from .util import compare_extraction

BAD = [
    "பூல்",
    "பூலு",
    "கூதி",
    "தேவுடியாள்",
    "தேவடியாள்",
    "ஓத்த",
    "ஓத்தா",
    "சுன்னி",
    "சுண்ணி",
    "ஓல்",
    "ஓழ்",
    "ஓலு",
    "ஓழு",
    "ஓழி",
    "ஒம்மால",
    "சூத்து",
    "முண்ட",
    "முண்டை",
    "புண்ட",
    "புண்டை",
    "தாயோளி",
    "ஓல்மாரி",
    "ஓழ்மாரி",
    "புழுத்தி"
]

INFORMAL = [
    "பொட்டை"
]

OTHER = [
    """
    இந்தோனேசிய ரூபாய் அல்லது ரூபியா (rupiah, Rp)
    இந்தோனேசியாவின் அலுவல்முறை நாணயம் ஆகும். இந்தோனேசிய
    வங்கியால் வெளியிடப்பட்டு கட்டுப்படுத்தப்படும் இதன் ஐ.எசு.ஓ 4217
    நாணயக் குறியீடு (ஐடிஆர்) IDR ஆகும். "ரூபியா" என்ற பெயர்
    இந்துத்தானிய சொல்லான ரூப்யா (روپیہ),(रुपया), மற்றும் சமசுகிருத
    வேரிலிருந்து (रूप्य; வார்ப்பு வெள்ளி) வந்துள்ளது. பேச்சு வழக்கில்
    இந்தோனேசியர்கள் வெள்ளி என்பதற்கான இந்தோனேசியச்
    சொல்லான "பெராக்" என்பதையும் பயன்படுத்துகின்றனர். ஒவ்வொரு
    ரூபியாவும் 100 சென்களாக பிரிக்கப்பட்டுள்ளது; பணவீக்கத்தால்
    சென் நாணயங்களும் வங்கித்தாள்களும் புழக்கத்திலிருந்து மறைந்து
    விட்டன.

    ரியாயு தீவுகளும் நியூ கினியின் இந்தோனேசியப் பகுதியும் முன்பு
    தங்களுக்கேயான ரூபியாவை பயன்படுத்தி வந்தன; ஆனால் முறையே
    1964, 1971ஆம் ஆண்டுகளில் இருந்து இங்கும் தேசிய ரூபியாவே
    செயலாக்கப்பட்டது.
    """
]


def test_badwords():
    compare_extraction(tamil.badwords.revision.datasources.matches,
                       BAD, OTHER)

    eq_(tamil.badwords, pickle.loads(pickle.dumps(tamil.badwords)))


def test_informals():
    compare_extraction(tamil.informals.revision.datasources.matches,
                       INFORMAL, OTHER)

    eq_(tamil.informals, pickle.loads(pickle.dumps(tamil.informals)))
