from .features import Dictionary, RegexMatches, Stopwords

name = "norwegian"

try:
    import enchant
    dictionary = enchant.Dict("nb")
except enchant.errors.DictNotFoundError:
    raise ImportError("No enchant-compatible dictionary found for 'nb'.  " +
                      "Consider installing 'myspell-nb'.")

dictionary = Dictionary(name + ".dictionary", dictionary.check)
"""
:class:`~revscoring.languages.features.Dictionary` features via
:class:`enchant.Dict` "nb".  Provided by `myspell-nb`
"""

stopwords = [
    r"alle",
    r"alt",
    r"and",
    r"andre",
    r"annen",
    r"annet",
    r"april",
    r"august",
    r"autoritetsdata",
    r"bare",
    r"begge",
    r"begynte",
    r"består",
    r"bilde",
    r"bildetekst",
    r"biografi",
    r"blant",
    r"ble",
    r"bli",
    r"blir",
    r"blitt",
    r"bruk",
    r"brukes",
    r"brukt",
    r"både",
    r"com",
    r"commons",
    r"dag",
    r"dato",
    r"defaultsort",
    r"del",
    r"deler",
    r"dem",
    r"den",
    r"denne",
    r"der",
    r"deres",
    r"derfor",
    r"dermed",
    r"desember",
    r"det",
    r"dette",
    r"disse",
    r"død",
    r"dødsfall",
    r"egen",
    r"eksempel",
    r"eksterne",
    r"eller",
    r"ene",
    r"eneste",
    r"engelsk",
    r"enn",
    r"ett",
    r"etter",
    r"europa",
    r"februar",
    r"fikk",
    r"fil",
    r"finnes",
    r"fire",
    r"flagg",
    r"flere",
    r"fleste",
    r"for",
    r"fordi",
    r"forfatter",
    r"forskjellige",
    r"fra",
    r"fram",
    r"frem",
    r"fått",
    r"fødsler",
    r"født",
    r"før",
    r"først",
    r"første",
    r"gamle",
    r"gang",
    r"ganger",
    r"geografi",
    r"gikk",
    r"gjennom",
    r"gjorde",
    r"grunn",
    r"går",
    r"hadde",
    r"han",
    r"hans",
    r"har",
    r"hele",
    r"helt",
    r"her",
    r"historie",
    r"hos",
    r"hva",
    r"hver",
    r"hvert",
    r"hvor",
    r"igjen",
    r"ikke",
    r"image",
    r"imidlertid",
    r"infoboks",
    r"ingen",
    r"inn",
    r"innen",
    r"isbn",
    r"januar",
    r"juli",
    r"juni",
    r"kalt",
    r"kan",
    r"kart",
    r"kategori",
    r"kilde",
    r"kildeløs",
    r"kilder",
    r"kjent",
    r"kjente",
    r"kom",
    r"kommer",
    r"kun",
    r"kunne",
    r"land",
    r"left",
    r"lenker",
    r"ligger",
    r"like",
    r"link",
    r"liste",
    r"litteratur",
    r"mai",
    r"man",
    r"mange",
    r"mars",
    r"med",
    r"mellom",
    r"men",
    r"mens",
    r"mer",
    r"mest",
    r"mindre",
    r"mot",
    r"mye",
    r"name",
    r"navn",
    r"navnet",
    r"nbsp",
    r"ned",
    r"noe",
    r"noen",
    r"nord",
    r"norge",
    r"norges",
    r"norsk",
    r"norske",
    r"november",
    r"nye",
    r"når",
    r"offisielt",
    r"ofte",
    r"også",
    r"okt",
    r"oktober",
    r"old",
    r"omdirigering",
    r"opp",
    r"org",
    r"oslo",
    r"over",
    r"per",
    r"personer",
    r"rekke",
    r"rundt",
    r"samme",
    r"sammen",
    r"samt",
    r"samtidig",
    r"satt",
    r"seg",
    r"selv",
    r"senere",
    r"september",
    r"sett",
    r"side",
    r"siden",
    r"sin",
    r"sine",
    r"siste",
    r"sitt",
    r"skal",
    r"skulle",
    r"slik",
    r"som",
    r"spesielt",
    r"språk",
    r"stor",
    r"store",
    r"stort",
    r"større",
    r"største",
    r"svg",
    r"svært",
    r"særlig",
    r"sør",
    r"tallet",
    r"tatt",
    r"the",
    r"thumb",
    r"tid",
    r"tiden",
    r"tidligere",
    r"til",
    r"tilbake",
    r"tillegg",
    r"tittel",
    r"tok",
    r"tre",
    r"type",
    r"ulike",
    r"under",
    r"url",
    r"usa",
    r"uten",
    r"var",
    r"ved",
    r"verden",
    r"vest",
    r"videre",
    r"viktig",
    r"vil",
    r"ville",
    r"vis",
    r"være",
    r"vært",
    r"årene",
    r"året"
]

stopwords = Stopwords(name + ".stopwords", stopwords)
"""
:class:`~revscoring.languages.features.Stopwords` features copied from
"common words" in https://meta.wikimedia.org/wiki/?oldid=15668766
"""

badword_regexes = [
    r"b1tch",
    r"bitch",
    r"blabla",
    r"boobs",
    r"bullshit",
    r"bæsj",
    r"bæsje",
    r"bæsjen",
    r"bæsjer",
    r"cool",
    r"cunt",
    r"drit",
    r"dritt",
    r"fack",
    r"faen",
    r"fitta",
    r"fitte",
    r"fuck",
    r"fucka",
    r"homo",
    r"homoseksuell",
    r"homse",
    r"hore",
    r"jævla",
    r"jævlig",
    r"knull",
    r"knulle",
    r"kuk",
    r"kukk",
    r"kåt",
    r"kødd",
    r"ludder",
    r"mordi",
    r"motherfucker",
    r"niggah",
    r"nigger",
    r"p0rn",
    r"p3nis",
    r"p3n1s",
    r"pen1s",
    r"pikk",
    r"porn",
    r"pr0n",
    r"pule",
    r"pulte",
    r"pupper",
    r"pussy",
    r"rompa",
    r"rompe",
    r"ræva",
    r"stupid",
    r"teit",
    r"tissemann",
    r"tits",
    r"twat",
    r"wanker",
    r"weed",
    r"whore"
]

badwords = RegexMatches(name + ".badwords", badword_regexes)
"""
:class:`~revscoring.languages.features.RegexMatches` features via a list of
badword detecting regexes.
"""

informal_regexes = [
    r"haha",
    r"hallo",
    r"hehe",
    r"hei",
    r"heisann",
    r"hey",
    r"heya",
    r"hihi",
    r"lmao",
    r"lol",
    r"omg",
    r"rofl",
    r"yea",
    r"yeah"
]

informals = RegexMatches(name + ".informals", informal_regexes)
"""
:class:`~revscoring.languages.features.RegexMatches` features via a list of
informal word detecting regexes.
"""
