from .features import Dictionary, RegexMatches, Stopwords

name = "czech"

try:
    import enchant
    dictionary = enchant.Dict("cs")
except enchant.errors.DictNotFoundError:
    raise ImportError("No enchant-compatible dictionary found for 'cs'.  " +
                      "Consider installing 'myspell-cs'.")

dictionary = Dictionary(name + ".dictionary", dictionary.check)
"""
:class:`~revscoring.languages.features.Dictionary` features via
:class:`enchant.Dict` "cs".  Provided by `myspell-cs`
"""

stopwords = [
    r"aby",
    r"ale",
    r"americké",
    r"and",
    r"ani",
    r"asi",
    r"autora",
    r"bez",
    r"byl",
    r"byla",
    r"byli",
    r"bylo",
    r"byly",
    r"být",
    r"během",
    r"category",
    r"celé",
    r"center",
    r"citace",
    r"com",
    r"commons",
    r"commonscat",
    r"což",
    r"další",
    r"datum",
    r"dne",
    r"dnes",
    r"doby",
    r"době",
    r"došlo",
    r"druhá",
    r"druhé",
    r"druhý",
    r"dva",
    r"dvou",
    r"dvě",
    r"dále",
    r"délka",
    r"díky",
    r"elektronické",
    r"externí",
    r"file",
    r"float",
    r"heslo",
    r"historie",
    r"hlavní",
    r"htm",
    r"html",
    r"http",
    r"image",
    r"index",
    r"infobox",
    r"isbn",
    r"jak",
    r"jako",
    r"jan",
    r"jazyk",
    r"jeden",
    r"jedná",
    r"jeho",
    r"jehož",
    r"jej",
    r"její",
    r"jen",
    r"ještě",
    r"jiné",
    r"již",
    r"jméno",
    r"jpg",
    r"jsou",
    r"kategorie",
    r"kde",
    r"kdy",
    r"když",
    r"kolem",
    r"kromě",
    r"království",
    r"kterou",
    r"která",
    r"které",
    r"který",
    r"kteří",
    r"lat",
    r"left",
    r"let",
    r"lidé",
    r"link",
    r"literatura",
    r"lze",
    r"mají",
    r"map",
    r"mezi",
    r"mimo",
    r"mnoho",
    r"monografie",
    r"muži",
    r"místo",
    r"měl",
    r"města",
    r"město",
    r"může",
    r"nad",
    r"name",
    r"např",
    r"například",
    r"narození",
    r"nbsp",
    r"nebo",
    r"největší",
    r"není",
    r"než",
    r"nové",
    r"název",
    r"někdy",
    r"několik",
    r"několika",
    r"některé",
    r"období",
    r"oblasti",
    r"obrázek",
    r"obrázku",
    r"odkaz",
    r"odkazy",
    r"old",
    r"org",
    r"ovšem",
    r"pahýl",
    r"pak",
    r"patří",
    r"pdf",
    r"php",
    r"png",
    r"pod",
    r"podle",
    r"pokud",
    r"popis",
    r"popisek",
    r"portál",
    r"portály",
    r"poslední",
    r"poté",
    r"pouze",
    r"později",
    r"počet",
    r"praha",
    r"pro",
    r"proti",
    r"proto",
    r"protože",
    r"první",
    r"před",
    r"především",
    r"přes",
    r"při",
    r"příjmení",
    r"přístupu",
    r"původně",
    r"ref",
    r"reference",
    r"references",
    r"republika",
    r"republiky",
    r"right",
    r"roce",
    r"rok",
    r"roku",
    r"různé",
    r"seznam",
    r"soubor",
    r"související",
    r"součástí",
    r"spojené",
    r"spolu",
    r"stal",
    r"století",
    r"stran",
    r"strany",
    r"stránky",
    r"stále",
    r"stát",
    r"státy",
    r"svg",
    r"svou",
    r"své",
    r"svého",
    r"světa",
    r"tak",
    r"také",
    r"tato",
    r"tedy",
    r"tento",
    r"text",
    r"the",
    r"thumb",
    r"titul",
    r"toho",
    r"tohoto",
    r"tomto",
    r"tomu",
    r"toto",
    r"typ",
    r"tyto",
    r"tzv",
    r"téměř",
    r"této",
    r"též",
    r"tím",
    r"tři",
    r"upravit",
    r"url",
    r"velikost",
    r"velká",
    r"velké",
    r"velmi",
    r"viz",
    r"vlajka",
    r"vlastní",
    r"vydavatel",
    r"vydání",
    r"více",
    r"výška",
    r"včetně",
    r"větší",
    r"však",
    r"web",
    r"www",
    r"zde",
    r"zdroj",
    r"zejména",
    r"země",
    r"zeměpisná",
    r"základní",
    r"září",
    r"území",
    r"často",
    r"česko",
    r"česku",
    r"česky",
    r"česká",
    r"české",
    r"český",
    r"článek",
    r"články",
    r"část",
    r"části",
    r"částí",
    r"číslo",
    r"říše",
    r"šířka",
    r"život"
]

stopwords = Stopwords(name + ".stopwords", stopwords)
"""
:class:`~revscoring.languages.features.Stopwords` features copied from
"common words" in https://meta.wikimedia.org/wiki/?oldid=15668766
"""

badword_regexes = [
    r"arnulfo",
    r"blb",
    r"blbá",
    r"blbec",
    r"blbej",
    r"blbost",
    r"blbosti",
    r"buzerant",
    r"buzeranti",
    r"buzik",
    r"buzna",
    r"buzny",
    r"curaci",
    r"curak",
    r"čumíš",
    r"čuráci",
    r"čůráci",
    r"čurak",
    r"čurák",
    r"čůrák",
    r"čuráka",
    r"ddd",
    r"dddd",
    r"ddddd",
    r"debil",
    r"debile",
    r"debilní",
    r"debilové",
    r"debilů",
    r"dementi",
    r"děvka",
    r"ekrimi",
    r"eskader",
    r"exkrementu",
    r"fekaliemi",
    r"fekalni",
    r"freeforfun",
    r"fuck",
    r"fuj",
    r"gay",
    r"gej",
    r"gportal",
    r"hnusná",
    r"hovada",
    r"hovadina",
    r"hoven",
    r"hovna",
    r"hovno",
    r"hovnu",
    r"howno",
    r"idiot",
    r"kastrováni",
    r"keci",
    r"kokot",
    r"kokota",
    r"kokote",
    r"kokoti",
    r"kokotina",
    r"kravina",
    r"kreten",
    r"kretén",
    r"kreteni",
    r"kreténi",
    r"kunda",
    r"kundo",
    r"kundy",
    r"kurva",
    r"kurvy",
    r"kuzdasová",
    r"magor",
    r"mrdá",
    r"mrdal",
    r"mrdání",
    r"mrdat",
    r"mrdka",
    r"mrdky",
    r"nasrat",
    r"necum",
    r"nečum",
    r"neser",
    r"nesmrděli",
    r"penis",
    r"penisu",
    r"péra",
    r"péro",
    r"pica",
    r"pice",
    r"pici",
    r"pico",
    r"picovina",
    r"picu",
    r"piča",
    r"píča",
    r"piče",
    r"píče",
    r"piči",
    r"píči",
    r"pičo",
    r"píčo",
    r"pičovina",
    r"píčovina",
    r"píčoviny",
    r"piču",
    r"píču",
    r"pičus",
    r"píčus",
    r"polib",
    r"polibte",
    r"posral",
    r"posrávání",
    r"prd",
    r"prdel",
    r"prdele",
    r"prdeli",
    r"prdy",
    r"sex",
    r"sexy",
    r"slovackatiskovakancelar",
    r"smrad",
    r"smrděl",
    r"smrdi",
    r"smrdí",
    r"smrdis",
    r"smrdíš",
    r"smrdite",
    r"smrdíte",
    r"sracka",
    r"sraček",
    r"sračka",
    r"sračky",
    r"sraní",
    r"svině",
    r"šuká",
    r"šukal",
    r"šukání",
    r"šukat",
    r"teplej",
    r"vole",
    r"všiví",
    r"vycucali",
    r"vykaly",
    r"zasranej",
    r"zasraný",
    r"zkurvenýho",
    r"zmrd",
    r"zmrde",
    r"zmrdi"
]

badwords = RegexMatches(name + ".badwords", badword_regexes)
"""
:class:`~revscoring.languages.features.RegexMatches` features via a list of
badword detecting regexes.
"""

informal_regexes = [
    r"ahoj",
    r"ahojky",
    r"balustrada",
    r"bla",
    r"blablabla",
    r"borec",
    r"bydlí",
    r"cau",
    r"čau",
    r"čus",
    r"děkuji",
    r"dete",
    r"děte",
    r"editovat",
    r"furt",
    r"haha",
    r"hahaha",
    r"hahahaha",
    r"hodne",
    r"jeto",
    r"jjj",
    r"jste",
    r"julieta",
    r"juliin",
    r"kapuletů",
    r"kolínšti",
    r"kterej",
    r"kurzíva",
    r"lol",
    r"mam",
    r"mám",
    r"mate",
    r"máte",
    r"média",
    r"miluju",
    r"moje",
    r"montekové",
    r"monteků",
    r"mucednici",
    r"nadpisu",
    r"neformátovaný",
    r"neni",
    r"neprůstřelné",
    r"nepřestanete",
    r"nevim",
    r"nuda",
    r"odkazu",
    r"omg",
    r"omluvného",
    r"patláním",
    r"pekna",
    r"pěkně",
    r"pepa",
    r"plnýho",
    r"podžezali",
    r"porno",
    r"prografika",
    r"proste",
    r"prostě",
    r"protoze",
    r"přeškrtnutý",
    r"příklad",
    r"příspěvky",
    r"rád",
    r"roméo",
    r"romerovi",
    r"romeus",
    r"salvadorský",
    r"salvadorští",
    r"sem",
    r"smazat",
    r"sou",
    r"ste",
    r"strašně",
    r"tady",
    r"taky",
    r"tipynavylety",
    r"tučný",
    r"tybalt",
    r"tybalta",
    r"uklizečky",
    r"ukradnou",
    r"vam",
    r"vám",
    r"vás",
    r"velkej",
    r"velky",
    r"vložit",
    r"vložte",
    r"vytrznik",
    r"zdar",
    r"znecistuje",
    r"znečistil"
]

informals = RegexMatches(name + ".informals", informal_regexes)
"""
:class:`~revscoring.languages.features.RegexMatches` features via a list of
informal word detecting regexes.
"""
