"""
This module implements a set of languages as collections of features that are
language specific.

feature collections
+++++++++++++++++++
Languages implement a subset of feature collections (e.g.
:class:`~revscoring.languages.features.Dictionary`,
:class:`~revscoring.languages.features.Stopwords`,
:class:`~revscoring.languages.features.Stemmed` and
:class:`~revscoring.languages.features.RegexMatches`) based on what
language assets are available. See :mod:`revscoring.languages.features`.

dutch
+++++
.. automodule:: revscoring.languages.arabic
    :members:

dutch
+++++
.. automodule:: revscoring.languages.dutch
    :members:

english
+++++++
.. automodule:: revscoring.languages.english
    :members:

estonian
++++++++
.. automodule:: revscoring.languages.estonian
    :members:

french
++++++
.. automodule:: revscoring.languages.french
    :members:

german
++++++
.. automodule:: revscoring.languages.german
    :members:

hebrew
++++++
.. automodule:: revscoring.languages.hebrew
    :members:

indonesian
++++++++++
.. automodule:: revscoring.languages.indonesian
    :members:

italian
+++++++
.. automodule:: revscoring.languages.italian
    :members:

japanese
+++++++
.. automodule:: revscoring.languages.japanese
    :members:

persian
+++++++
.. automodule:: revscoring.languages.persian
    :members:

portuguese
++++++++++
.. automodule:: revscoring.languages.portuguese
    :members:

spanish
+++++++
.. automodule:: revscoring.languages.spanish
    :members:

turkish
+++++++
.. automodule:: revscoring.languages.turkish
    :members:

ukrainian
+++++++++
.. automodule:: revscoring.languages.ukrainian
    :members:

vietnamese
++++++++++
.. automodule:: revscoring.languages.vietnamese
    :members:

"""
