# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseInstanceArgs', 'DatabaseInstance']

@pulumi.input_type
class DatabaseInstanceArgs:
    def __init__(__self__, *,
                 engine: pulumi.Input[str],
                 node_type: pulumi.Input[str],
                 backup_same_region: Optional[pulumi.Input[bool]] = None,
                 backup_schedule_frequency: Optional[pulumi.Input[int]] = None,
                 backup_schedule_retention: Optional[pulumi.Input[int]] = None,
                 disable_backup: Optional[pulumi.Input[bool]] = None,
                 is_ha_cluster: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 private_network: Optional[pulumi.Input['DatabaseInstancePrivateNetworkArgs']] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 volume_size_in_gb: Optional[pulumi.Input[int]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DatabaseInstance resource.
        :param pulumi.Input[str] engine: Database Instance's engine version (e.g. `PostgreSQL-11`).
        :param pulumi.Input[str] node_type: The type of database instance you want to create (e.g. `db-dev-s`).
        :param pulumi.Input[bool] backup_same_region: Boolean to store logical backups in the same region as the database instance.
        :param pulumi.Input[int] backup_schedule_frequency: Backup schedule frequency in hours.
        :param pulumi.Input[int] backup_schedule_retention: Backup schedule retention in days.
        :param pulumi.Input[bool] disable_backup: Disable automated backup for the database instance.
        :param pulumi.Input[bool] is_ha_cluster: Enable or disable high availability for the database instance.
        :param pulumi.Input[str] name: The name of the Database Instance.
        :param pulumi.Input[str] password: Password for the first user of the database instance.
        :param pulumi.Input['DatabaseInstancePrivateNetworkArgs'] private_network: List of private networks endpoints of the database instance.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the Database Instance is associated with.
        :param pulumi.Input[str] region: `region`) The region in which the Database Instance should be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Map of engine settings to be set. Using this option will override default config. Available settings for your engine can be found on scaleway console or fetched using [rdb engine list route](https://developers.scaleway.com/en/products/rdb/api/#get-1eafb7)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the Database Instance.
        :param pulumi.Input[str] user_name: Identifier for the first user of the database instance.
        :param pulumi.Input[int] volume_size_in_gb: Volume size (in GB) when `volume_type` is set to `bssd`. Must be a multiple of 5000000000.
        :param pulumi.Input[str] volume_type: Type of volume where data are stored (`bssd` or `lssd`).
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "node_type", node_type)
        if backup_same_region is not None:
            pulumi.set(__self__, "backup_same_region", backup_same_region)
        if backup_schedule_frequency is not None:
            pulumi.set(__self__, "backup_schedule_frequency", backup_schedule_frequency)
        if backup_schedule_retention is not None:
            pulumi.set(__self__, "backup_schedule_retention", backup_schedule_retention)
        if disable_backup is not None:
            pulumi.set(__self__, "disable_backup", disable_backup)
        if is_ha_cluster is not None:
            pulumi.set(__self__, "is_ha_cluster", is_ha_cluster)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if volume_size_in_gb is not None:
            pulumi.set(__self__, "volume_size_in_gb", volume_size_in_gb)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Input[str]:
        """
        Database Instance's engine version (e.g. `PostgreSQL-11`).
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: pulumi.Input[str]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Input[str]:
        """
        The type of database instance you want to create (e.g. `db-dev-s`).
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter(name="backupSameRegion")
    def backup_same_region(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean to store logical backups in the same region as the database instance.
        """
        return pulumi.get(self, "backup_same_region")

    @backup_same_region.setter
    def backup_same_region(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backup_same_region", value)

    @property
    @pulumi.getter(name="backupScheduleFrequency")
    def backup_schedule_frequency(self) -> Optional[pulumi.Input[int]]:
        """
        Backup schedule frequency in hours.
        """
        return pulumi.get(self, "backup_schedule_frequency")

    @backup_schedule_frequency.setter
    def backup_schedule_frequency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_schedule_frequency", value)

    @property
    @pulumi.getter(name="backupScheduleRetention")
    def backup_schedule_retention(self) -> Optional[pulumi.Input[int]]:
        """
        Backup schedule retention in days.
        """
        return pulumi.get(self, "backup_schedule_retention")

    @backup_schedule_retention.setter
    def backup_schedule_retention(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_schedule_retention", value)

    @property
    @pulumi.getter(name="disableBackup")
    def disable_backup(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable automated backup for the database instance.
        """
        return pulumi.get(self, "disable_backup")

    @disable_backup.setter
    def disable_backup(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_backup", value)

    @property
    @pulumi.getter(name="isHaCluster")
    def is_ha_cluster(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable high availability for the database instance.
        """
        return pulumi.get(self, "is_ha_cluster")

    @is_ha_cluster.setter
    def is_ha_cluster(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_ha_cluster", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password for the first user of the database instance.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[pulumi.Input['DatabaseInstancePrivateNetworkArgs']]:
        """
        List of private networks endpoints of the database instance.
        """
        return pulumi.get(self, "private_network")

    @private_network.setter
    def private_network(self, value: Optional[pulumi.Input['DatabaseInstancePrivateNetworkArgs']]):
        pulumi.set(self, "private_network", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        `project_id`) The ID of the project the Database Instance is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        `region`) The region in which the Database Instance should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of engine settings to be set. Using this option will override default config. Available settings for your engine can be found on scaleway console or fetched using [rdb engine list route](https://developers.scaleway.com/en/products/rdb/api/#get-1eafb7)
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags associated with the Database Instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for the first user of the database instance.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="volumeSizeInGb")
    def volume_size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Volume size (in GB) when `volume_type` is set to `bssd`. Must be a multiple of 5000000000.
        """
        return pulumi.get(self, "volume_size_in_gb")

    @volume_size_in_gb.setter
    def volume_size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volume_size_in_gb", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of volume where data are stored (`bssd` or `lssd`).
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class _DatabaseInstanceState:
    def __init__(__self__, *,
                 backup_same_region: Optional[pulumi.Input[bool]] = None,
                 backup_schedule_frequency: Optional[pulumi.Input[int]] = None,
                 backup_schedule_retention: Optional[pulumi.Input[int]] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 disable_backup: Optional[pulumi.Input[bool]] = None,
                 endpoint_ip: Optional[pulumi.Input[str]] = None,
                 endpoint_port: Optional[pulumi.Input[int]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 is_ha_cluster: Optional[pulumi.Input[bool]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceLoadBalancerArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 private_network: Optional[pulumi.Input['DatabaseInstancePrivateNetworkArgs']] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 read_replicas: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceReadReplicaArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 volume_size_in_gb: Optional[pulumi.Input[int]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DatabaseInstance resources.
        :param pulumi.Input[bool] backup_same_region: Boolean to store logical backups in the same region as the database instance.
        :param pulumi.Input[int] backup_schedule_frequency: Backup schedule frequency in hours.
        :param pulumi.Input[int] backup_schedule_retention: Backup schedule retention in days.
        :param pulumi.Input[str] certificate: Certificate of the database instance.
        :param pulumi.Input[bool] disable_backup: Disable automated backup for the database instance.
        :param pulumi.Input[str] endpoint_ip: (Deprecated) The IP of the Database Instance.
        :param pulumi.Input[int] endpoint_port: (Deprecated) The port of the Database Instance.
        :param pulumi.Input[str] engine: Database Instance's engine version (e.g. `PostgreSQL-11`).
        :param pulumi.Input[bool] is_ha_cluster: Enable or disable high availability for the database instance.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceLoadBalancerArgs']]] load_balancers: List of load balancer endpoints of the database instance.
        :param pulumi.Input[str] name: The name of the Database Instance.
        :param pulumi.Input[str] node_type: The type of database instance you want to create (e.g. `db-dev-s`).
        :param pulumi.Input[str] organization_id: The organization ID the Database Instance is associated with.
        :param pulumi.Input[str] password: Password for the first user of the database instance.
        :param pulumi.Input['DatabaseInstancePrivateNetworkArgs'] private_network: List of private networks endpoints of the database instance.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the Database Instance is associated with.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceReadReplicaArgs']]] read_replicas: List of read replicas of the database instance.
        :param pulumi.Input[str] region: `region`) The region in which the Database Instance should be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Map of engine settings to be set. Using this option will override default config. Available settings for your engine can be found on scaleway console or fetched using [rdb engine list route](https://developers.scaleway.com/en/products/rdb/api/#get-1eafb7)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the Database Instance.
        :param pulumi.Input[str] user_name: Identifier for the first user of the database instance.
        :param pulumi.Input[int] volume_size_in_gb: Volume size (in GB) when `volume_type` is set to `bssd`. Must be a multiple of 5000000000.
        :param pulumi.Input[str] volume_type: Type of volume where data are stored (`bssd` or `lssd`).
        """
        if backup_same_region is not None:
            pulumi.set(__self__, "backup_same_region", backup_same_region)
        if backup_schedule_frequency is not None:
            pulumi.set(__self__, "backup_schedule_frequency", backup_schedule_frequency)
        if backup_schedule_retention is not None:
            pulumi.set(__self__, "backup_schedule_retention", backup_schedule_retention)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if disable_backup is not None:
            pulumi.set(__self__, "disable_backup", disable_backup)
        if endpoint_ip is not None:
            warnings.warn("""Please use the private_network or the load_balancer attribute""", DeprecationWarning)
            pulumi.log.warn("""endpoint_ip is deprecated: Please use the private_network or the load_balancer attribute""")
        if endpoint_ip is not None:
            pulumi.set(__self__, "endpoint_ip", endpoint_ip)
        if endpoint_port is not None:
            pulumi.set(__self__, "endpoint_port", endpoint_port)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if is_ha_cluster is not None:
            pulumi.set(__self__, "is_ha_cluster", is_ha_cluster)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if read_replicas is not None:
            pulumi.set(__self__, "read_replicas", read_replicas)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if volume_size_in_gb is not None:
            pulumi.set(__self__, "volume_size_in_gb", volume_size_in_gb)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="backupSameRegion")
    def backup_same_region(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean to store logical backups in the same region as the database instance.
        """
        return pulumi.get(self, "backup_same_region")

    @backup_same_region.setter
    def backup_same_region(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backup_same_region", value)

    @property
    @pulumi.getter(name="backupScheduleFrequency")
    def backup_schedule_frequency(self) -> Optional[pulumi.Input[int]]:
        """
        Backup schedule frequency in hours.
        """
        return pulumi.get(self, "backup_schedule_frequency")

    @backup_schedule_frequency.setter
    def backup_schedule_frequency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_schedule_frequency", value)

    @property
    @pulumi.getter(name="backupScheduleRetention")
    def backup_schedule_retention(self) -> Optional[pulumi.Input[int]]:
        """
        Backup schedule retention in days.
        """
        return pulumi.get(self, "backup_schedule_retention")

    @backup_schedule_retention.setter
    def backup_schedule_retention(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_schedule_retention", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate of the database instance.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="disableBackup")
    def disable_backup(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable automated backup for the database instance.
        """
        return pulumi.get(self, "disable_backup")

    @disable_backup.setter
    def disable_backup(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_backup", value)

    @property
    @pulumi.getter(name="endpointIp")
    def endpoint_ip(self) -> Optional[pulumi.Input[str]]:
        """
        (Deprecated) The IP of the Database Instance.
        """
        return pulumi.get(self, "endpoint_ip")

    @endpoint_ip.setter
    def endpoint_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_ip", value)

    @property
    @pulumi.getter(name="endpointPort")
    def endpoint_port(self) -> Optional[pulumi.Input[int]]:
        """
        (Deprecated) The port of the Database Instance.
        """
        return pulumi.get(self, "endpoint_port")

    @endpoint_port.setter
    def endpoint_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "endpoint_port", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[str]]:
        """
        Database Instance's engine version (e.g. `PostgreSQL-11`).
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="isHaCluster")
    def is_ha_cluster(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable high availability for the database instance.
        """
        return pulumi.get(self, "is_ha_cluster")

    @is_ha_cluster.setter
    def is_ha_cluster(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_ha_cluster", value)

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceLoadBalancerArgs']]]]:
        """
        List of load balancer endpoints of the database instance.
        """
        return pulumi.get(self, "load_balancers")

    @load_balancers.setter
    def load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceLoadBalancerArgs']]]]):
        pulumi.set(self, "load_balancers", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of database instance you want to create (e.g. `db-dev-s`).
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        The organization ID the Database Instance is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password for the first user of the database instance.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[pulumi.Input['DatabaseInstancePrivateNetworkArgs']]:
        """
        List of private networks endpoints of the database instance.
        """
        return pulumi.get(self, "private_network")

    @private_network.setter
    def private_network(self, value: Optional[pulumi.Input['DatabaseInstancePrivateNetworkArgs']]):
        pulumi.set(self, "private_network", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        `project_id`) The ID of the project the Database Instance is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="readReplicas")
    def read_replicas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceReadReplicaArgs']]]]:
        """
        List of read replicas of the database instance.
        """
        return pulumi.get(self, "read_replicas")

    @read_replicas.setter
    def read_replicas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceReadReplicaArgs']]]]):
        pulumi.set(self, "read_replicas", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        `region`) The region in which the Database Instance should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of engine settings to be set. Using this option will override default config. Available settings for your engine can be found on scaleway console or fetched using [rdb engine list route](https://developers.scaleway.com/en/products/rdb/api/#get-1eafb7)
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags associated with the Database Instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for the first user of the database instance.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="volumeSizeInGb")
    def volume_size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Volume size (in GB) when `volume_type` is set to `bssd`. Must be a multiple of 5000000000.
        """
        return pulumi.get(self, "volume_size_in_gb")

    @volume_size_in_gb.setter
    def volume_size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volume_size_in_gb", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of volume where data are stored (`bssd` or `lssd`).
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)


class DatabaseInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_same_region: Optional[pulumi.Input[bool]] = None,
                 backup_schedule_frequency: Optional[pulumi.Input[int]] = None,
                 backup_schedule_retention: Optional[pulumi.Input[int]] = None,
                 disable_backup: Optional[pulumi.Input[bool]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 is_ha_cluster: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 private_network: Optional[pulumi.Input[pulumi.InputType['DatabaseInstancePrivateNetworkArgs']]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 volume_size_in_gb: Optional[pulumi.Input[int]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Database Instances.
        For more information, see [the documentation](https://developers.scaleway.com/en/products/rdb/api).

        ## Examples

        ### Basic

        ```python
        import pulumi
        import lbrlabs_scaleway as scaleway

        main_database_instance = scaleway.DatabaseInstance("mainDatabaseInstance",
            node_type="DB-DEV-S",
            engine="PostgreSQL-11",
            is_ha_cluster=True,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret")
        # with backup schedule
        main_index_database_instance_database_instance = scaleway.DatabaseInstance("mainIndex/databaseInstanceDatabaseInstance",
            node_type="DB-DEV-S",
            engine="PostgreSQL-11",
            is_ha_cluster=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            disable_backup=True,
            backup_schedule_frequency=24,
            backup_schedule_retention=7)
        # keep it one week
        # with private network and dhcp configuration
        pn02 = scaleway.VpcPrivateNetwork("pn02")
        main_vpc_public_gateway_dhcp = scaleway.VpcPublicGatewayDhcp("mainVpcPublicGatewayDhcp", subnet="192.168.1.0/24")
        main_vpc_public_gateway_ip = scaleway.VpcPublicGatewayIp("mainVpcPublicGatewayIp")
        main_vpc_public_gateway = scaleway.VpcPublicGateway("mainVpcPublicGateway",
            type="VPC-GW-S",
            ip_id=main_vpc_public_gateway_ip.id)
        main_vpc_gateway_network = scaleway.VpcGatewayNetwork("mainVpcGatewayNetwork",
            gateway_id=main_vpc_public_gateway.id,
            private_network_id=pn02.id,
            dhcp_id=main_vpc_public_gateway_dhcp.id,
            cleanup_dhcp=True,
            enable_masquerade=True,
            opts=pulumi.ResourceOptions(depends_on=[
                    main_vpc_public_gateway_ip,
                    pn02,
                ]))
        main_vpc_public_gateway_pat_rule = scaleway.VpcPublicGatewayPatRule("mainVpcPublicGatewayPatRule",
            gateway_id=main_vpc_public_gateway.id,
            private_ip=main_vpc_public_gateway_dhcp.address,
            private_port=main_database_instance.private_network.port,
            public_port=42,
            protocol="both",
            opts=pulumi.ResourceOptions(depends_on=[
                    main_vpc_gateway_network,
                    pn02,
                ]))
        main_scaleway_index_database_instance_database_instance = scaleway.DatabaseInstance("mainScalewayIndex/databaseInstanceDatabaseInstance",
            node_type="db-dev-s",
            engine="PostgreSQL-11",
            is_ha_cluster=False,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            region="fr-par",
            tags=[
                "terraform-test",
                "scaleway_rdb_instance",
                "volume",
                "rdb_pn",
            ],
            volume_type="bssd",
            volume_size_in_gb=10,
            private_network=scaleway.DatabaseInstancePrivateNetworkArgs(
                ip_net="192.168.1.254/24",
                pn_id=pn02.id,
            ))
        ```

        ## Private Network

        > **Important:** Updates to `private_network` will recreate the attachment Instance.

        - `ip_net` - (Required) The IP network where to con.
        - `pn_id` - (Required) The ID of the private network. If not provided it will be randomly generated.

        ## Limitations

        The Managed Database product is only compliant with the private network in the default availability zone (AZ).
        i.e. `fr-par-1`, `nl-ams-1`, `pl-waw-1`. To learn more, read our section [How to connect a PostgreSQL and MySQL Database Instance to a Private Network](https://www.scaleway.com/en/docs/managed-databases/postgresql-and-mysql/how-to/connect-database-private-network/)

        ## Import

        Database Instance can be imported using the `{region}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/databaseInstance:DatabaseInstance rdb01 fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] backup_same_region: Boolean to store logical backups in the same region as the database instance.
        :param pulumi.Input[int] backup_schedule_frequency: Backup schedule frequency in hours.
        :param pulumi.Input[int] backup_schedule_retention: Backup schedule retention in days.
        :param pulumi.Input[bool] disable_backup: Disable automated backup for the database instance.
        :param pulumi.Input[str] engine: Database Instance's engine version (e.g. `PostgreSQL-11`).
        :param pulumi.Input[bool] is_ha_cluster: Enable or disable high availability for the database instance.
        :param pulumi.Input[str] name: The name of the Database Instance.
        :param pulumi.Input[str] node_type: The type of database instance you want to create (e.g. `db-dev-s`).
        :param pulumi.Input[str] password: Password for the first user of the database instance.
        :param pulumi.Input[pulumi.InputType['DatabaseInstancePrivateNetworkArgs']] private_network: List of private networks endpoints of the database instance.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the Database Instance is associated with.
        :param pulumi.Input[str] region: `region`) The region in which the Database Instance should be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Map of engine settings to be set. Using this option will override default config. Available settings for your engine can be found on scaleway console or fetched using [rdb engine list route](https://developers.scaleway.com/en/products/rdb/api/#get-1eafb7)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the Database Instance.
        :param pulumi.Input[str] user_name: Identifier for the first user of the database instance.
        :param pulumi.Input[int] volume_size_in_gb: Volume size (in GB) when `volume_type` is set to `bssd`. Must be a multiple of 5000000000.
        :param pulumi.Input[str] volume_type: Type of volume where data are stored (`bssd` or `lssd`).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Database Instances.
        For more information, see [the documentation](https://developers.scaleway.com/en/products/rdb/api).

        ## Examples

        ### Basic

        ```python
        import pulumi
        import lbrlabs_scaleway as scaleway

        main_database_instance = scaleway.DatabaseInstance("mainDatabaseInstance",
            node_type="DB-DEV-S",
            engine="PostgreSQL-11",
            is_ha_cluster=True,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret")
        # with backup schedule
        main_index_database_instance_database_instance = scaleway.DatabaseInstance("mainIndex/databaseInstanceDatabaseInstance",
            node_type="DB-DEV-S",
            engine="PostgreSQL-11",
            is_ha_cluster=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            disable_backup=True,
            backup_schedule_frequency=24,
            backup_schedule_retention=7)
        # keep it one week
        # with private network and dhcp configuration
        pn02 = scaleway.VpcPrivateNetwork("pn02")
        main_vpc_public_gateway_dhcp = scaleway.VpcPublicGatewayDhcp("mainVpcPublicGatewayDhcp", subnet="192.168.1.0/24")
        main_vpc_public_gateway_ip = scaleway.VpcPublicGatewayIp("mainVpcPublicGatewayIp")
        main_vpc_public_gateway = scaleway.VpcPublicGateway("mainVpcPublicGateway",
            type="VPC-GW-S",
            ip_id=main_vpc_public_gateway_ip.id)
        main_vpc_gateway_network = scaleway.VpcGatewayNetwork("mainVpcGatewayNetwork",
            gateway_id=main_vpc_public_gateway.id,
            private_network_id=pn02.id,
            dhcp_id=main_vpc_public_gateway_dhcp.id,
            cleanup_dhcp=True,
            enable_masquerade=True,
            opts=pulumi.ResourceOptions(depends_on=[
                    main_vpc_public_gateway_ip,
                    pn02,
                ]))
        main_vpc_public_gateway_pat_rule = scaleway.VpcPublicGatewayPatRule("mainVpcPublicGatewayPatRule",
            gateway_id=main_vpc_public_gateway.id,
            private_ip=main_vpc_public_gateway_dhcp.address,
            private_port=main_database_instance.private_network.port,
            public_port=42,
            protocol="both",
            opts=pulumi.ResourceOptions(depends_on=[
                    main_vpc_gateway_network,
                    pn02,
                ]))
        main_scaleway_index_database_instance_database_instance = scaleway.DatabaseInstance("mainScalewayIndex/databaseInstanceDatabaseInstance",
            node_type="db-dev-s",
            engine="PostgreSQL-11",
            is_ha_cluster=False,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            region="fr-par",
            tags=[
                "terraform-test",
                "scaleway_rdb_instance",
                "volume",
                "rdb_pn",
            ],
            volume_type="bssd",
            volume_size_in_gb=10,
            private_network=scaleway.DatabaseInstancePrivateNetworkArgs(
                ip_net="192.168.1.254/24",
                pn_id=pn02.id,
            ))
        ```

        ## Private Network

        > **Important:** Updates to `private_network` will recreate the attachment Instance.

        - `ip_net` - (Required) The IP network where to con.
        - `pn_id` - (Required) The ID of the private network. If not provided it will be randomly generated.

        ## Limitations

        The Managed Database product is only compliant with the private network in the default availability zone (AZ).
        i.e. `fr-par-1`, `nl-ams-1`, `pl-waw-1`. To learn more, read our section [How to connect a PostgreSQL and MySQL Database Instance to a Private Network](https://www.scaleway.com/en/docs/managed-databases/postgresql-and-mysql/how-to/connect-database-private-network/)

        ## Import

        Database Instance can be imported using the `{region}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/databaseInstance:DatabaseInstance rdb01 fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_same_region: Optional[pulumi.Input[bool]] = None,
                 backup_schedule_frequency: Optional[pulumi.Input[int]] = None,
                 backup_schedule_retention: Optional[pulumi.Input[int]] = None,
                 disable_backup: Optional[pulumi.Input[bool]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 is_ha_cluster: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 private_network: Optional[pulumi.Input[pulumi.InputType['DatabaseInstancePrivateNetworkArgs']]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 volume_size_in_gb: Optional[pulumi.Input[int]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseInstanceArgs.__new__(DatabaseInstanceArgs)

            __props__.__dict__["backup_same_region"] = backup_same_region
            __props__.__dict__["backup_schedule_frequency"] = backup_schedule_frequency
            __props__.__dict__["backup_schedule_retention"] = backup_schedule_retention
            __props__.__dict__["disable_backup"] = disable_backup
            if engine is None and not opts.urn:
                raise TypeError("Missing required property 'engine'")
            __props__.__dict__["engine"] = engine
            __props__.__dict__["is_ha_cluster"] = is_ha_cluster
            __props__.__dict__["name"] = name
            if node_type is None and not opts.urn:
                raise TypeError("Missing required property 'node_type'")
            __props__.__dict__["node_type"] = node_type
            __props__.__dict__["password"] = password
            __props__.__dict__["private_network"] = private_network
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["settings"] = settings
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_name"] = user_name
            __props__.__dict__["volume_size_in_gb"] = volume_size_in_gb
            __props__.__dict__["volume_type"] = volume_type
            __props__.__dict__["certificate"] = None
            __props__.__dict__["endpoint_ip"] = None
            __props__.__dict__["endpoint_port"] = None
            __props__.__dict__["load_balancers"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["read_replicas"] = None
        super(DatabaseInstance, __self__).__init__(
            'scaleway:index/databaseInstance:DatabaseInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_same_region: Optional[pulumi.Input[bool]] = None,
            backup_schedule_frequency: Optional[pulumi.Input[int]] = None,
            backup_schedule_retention: Optional[pulumi.Input[int]] = None,
            certificate: Optional[pulumi.Input[str]] = None,
            disable_backup: Optional[pulumi.Input[bool]] = None,
            endpoint_ip: Optional[pulumi.Input[str]] = None,
            endpoint_port: Optional[pulumi.Input[int]] = None,
            engine: Optional[pulumi.Input[str]] = None,
            is_ha_cluster: Optional[pulumi.Input[bool]] = None,
            load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseInstanceLoadBalancerArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_type: Optional[pulumi.Input[str]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            private_network: Optional[pulumi.Input[pulumi.InputType['DatabaseInstancePrivateNetworkArgs']]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            read_replicas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseInstanceReadReplicaArgs']]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            user_name: Optional[pulumi.Input[str]] = None,
            volume_size_in_gb: Optional[pulumi.Input[int]] = None,
            volume_type: Optional[pulumi.Input[str]] = None) -> 'DatabaseInstance':
        """
        Get an existing DatabaseInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] backup_same_region: Boolean to store logical backups in the same region as the database instance.
        :param pulumi.Input[int] backup_schedule_frequency: Backup schedule frequency in hours.
        :param pulumi.Input[int] backup_schedule_retention: Backup schedule retention in days.
        :param pulumi.Input[str] certificate: Certificate of the database instance.
        :param pulumi.Input[bool] disable_backup: Disable automated backup for the database instance.
        :param pulumi.Input[str] endpoint_ip: (Deprecated) The IP of the Database Instance.
        :param pulumi.Input[int] endpoint_port: (Deprecated) The port of the Database Instance.
        :param pulumi.Input[str] engine: Database Instance's engine version (e.g. `PostgreSQL-11`).
        :param pulumi.Input[bool] is_ha_cluster: Enable or disable high availability for the database instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseInstanceLoadBalancerArgs']]]] load_balancers: List of load balancer endpoints of the database instance.
        :param pulumi.Input[str] name: The name of the Database Instance.
        :param pulumi.Input[str] node_type: The type of database instance you want to create (e.g. `db-dev-s`).
        :param pulumi.Input[str] organization_id: The organization ID the Database Instance is associated with.
        :param pulumi.Input[str] password: Password for the first user of the database instance.
        :param pulumi.Input[pulumi.InputType['DatabaseInstancePrivateNetworkArgs']] private_network: List of private networks endpoints of the database instance.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the Database Instance is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseInstanceReadReplicaArgs']]]] read_replicas: List of read replicas of the database instance.
        :param pulumi.Input[str] region: `region`) The region in which the Database Instance should be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Map of engine settings to be set. Using this option will override default config. Available settings for your engine can be found on scaleway console or fetched using [rdb engine list route](https://developers.scaleway.com/en/products/rdb/api/#get-1eafb7)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the Database Instance.
        :param pulumi.Input[str] user_name: Identifier for the first user of the database instance.
        :param pulumi.Input[int] volume_size_in_gb: Volume size (in GB) when `volume_type` is set to `bssd`. Must be a multiple of 5000000000.
        :param pulumi.Input[str] volume_type: Type of volume where data are stored (`bssd` or `lssd`).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseInstanceState.__new__(_DatabaseInstanceState)

        __props__.__dict__["backup_same_region"] = backup_same_region
        __props__.__dict__["backup_schedule_frequency"] = backup_schedule_frequency
        __props__.__dict__["backup_schedule_retention"] = backup_schedule_retention
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["disable_backup"] = disable_backup
        __props__.__dict__["endpoint_ip"] = endpoint_ip
        __props__.__dict__["endpoint_port"] = endpoint_port
        __props__.__dict__["engine"] = engine
        __props__.__dict__["is_ha_cluster"] = is_ha_cluster
        __props__.__dict__["load_balancers"] = load_balancers
        __props__.__dict__["name"] = name
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["password"] = password
        __props__.__dict__["private_network"] = private_network
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["read_replicas"] = read_replicas
        __props__.__dict__["region"] = region
        __props__.__dict__["settings"] = settings
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["volume_size_in_gb"] = volume_size_in_gb
        __props__.__dict__["volume_type"] = volume_type
        return DatabaseInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backupSameRegion")
    def backup_same_region(self) -> pulumi.Output[bool]:
        """
        Boolean to store logical backups in the same region as the database instance.
        """
        return pulumi.get(self, "backup_same_region")

    @property
    @pulumi.getter(name="backupScheduleFrequency")
    def backup_schedule_frequency(self) -> pulumi.Output[int]:
        """
        Backup schedule frequency in hours.
        """
        return pulumi.get(self, "backup_schedule_frequency")

    @property
    @pulumi.getter(name="backupScheduleRetention")
    def backup_schedule_retention(self) -> pulumi.Output[int]:
        """
        Backup schedule retention in days.
        """
        return pulumi.get(self, "backup_schedule_retention")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[str]:
        """
        Certificate of the database instance.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="disableBackup")
    def disable_backup(self) -> pulumi.Output[Optional[bool]]:
        """
        Disable automated backup for the database instance.
        """
        return pulumi.get(self, "disable_backup")

    @property
    @pulumi.getter(name="endpointIp")
    def endpoint_ip(self) -> pulumi.Output[str]:
        """
        (Deprecated) The IP of the Database Instance.
        """
        return pulumi.get(self, "endpoint_ip")

    @property
    @pulumi.getter(name="endpointPort")
    def endpoint_port(self) -> pulumi.Output[int]:
        """
        (Deprecated) The port of the Database Instance.
        """
        return pulumi.get(self, "endpoint_port")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[str]:
        """
        Database Instance's engine version (e.g. `PostgreSQL-11`).
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="isHaCluster")
    def is_ha_cluster(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable or disable high availability for the database instance.
        """
        return pulumi.get(self, "is_ha_cluster")

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> pulumi.Output[Sequence['outputs.DatabaseInstanceLoadBalancer']]:
        """
        List of load balancer endpoints of the database instance.
        """
        return pulumi.get(self, "load_balancers")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[str]:
        """
        The type of database instance you want to create (e.g. `db-dev-s`).
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        The organization ID the Database Instance is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        Password for the first user of the database instance.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> pulumi.Output[Optional['outputs.DatabaseInstancePrivateNetwork']]:
        """
        List of private networks endpoints of the database instance.
        """
        return pulumi.get(self, "private_network")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        `project_id`) The ID of the project the Database Instance is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="readReplicas")
    def read_replicas(self) -> pulumi.Output[Sequence['outputs.DatabaseInstanceReadReplica']]:
        """
        List of read replicas of the database instance.
        """
        return pulumi.get(self, "read_replicas")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        `region`) The region in which the Database Instance should be created.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of engine settings to be set. Using this option will override default config. Available settings for your engine can be found on scaleway console or fetched using [rdb engine list route](https://developers.scaleway.com/en/products/rdb/api/#get-1eafb7)
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The tags associated with the Database Instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[Optional[str]]:
        """
        Identifier for the first user of the database instance.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="volumeSizeInGb")
    def volume_size_in_gb(self) -> pulumi.Output[int]:
        """
        Volume size (in GB) when `volume_type` is set to `bssd`. Must be a multiple of 5000000000.
        """
        return pulumi.get(self, "volume_size_in_gb")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Output[Optional[str]]:
        """
        Type of volume where data are stored (`bssd` or `lssd`).
        """
        return pulumi.get(self, "volume_type")

