# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ContainerArgs', 'Container']

@pulumi.input_type
class ContainerArgs:
    def __init__(__self__, *,
                 namespace_id: pulumi.Input[str],
                 cpu_limit: Optional[pulumi.Input[int]] = None,
                 deploy: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_concurrency: Optional[pulumi.Input[int]] = None,
                 max_scale: Optional[pulumi.Input[int]] = None,
                 memory_limit: Optional[pulumi.Input[int]] = None,
                 min_scale: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 privacy: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 registry_image: Optional[pulumi.Input[str]] = None,
                 registry_sha256: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Container resource.
        :param pulumi.Input[str] namespace_id: The container namespace ID of the container.
        :param pulumi.Input[int] cpu_limit: The amount of vCPU computing resources to allocate to each container. Defaults to 70.
        :param pulumi.Input[bool] deploy: Boolean controlling whether the container is on a production environment.
        :param pulumi.Input[str] description: The description of the container.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: The [environment](https://www.scaleway.com/en/docs/compute/containers/concepts/#environment-variables) variables of the container.
        :param pulumi.Input[int] max_concurrency: The maximum number of simultaneous requests your container can handle at the same time. Defaults to 50.
        :param pulumi.Input[int] max_scale: The maximum of number of instances this container can scale to. Default to 20.
        :param pulumi.Input[int] memory_limit: The memory computing resources in MB to allocate to each container. Defaults to 128.
        :param pulumi.Input[int] min_scale: The minimum of running container instances continuously. Defaults to 0.
        :param pulumi.Input[str] name: The unique name of the container name.
        :param pulumi.Input[int] port: The port to expose the container. Defaults to 8080.
        :param pulumi.Input[str] privacy: The privacy type define the way to authenticate to your container. Please check our dedicated [section](https://developers.scaleway.com/en/products/containers/api/#protocol-9dd4c8).
        :param pulumi.Input[str] protocol: The communication [protocol](https://developers.scaleway.com/en/products/containers/api/#protocol-9dd4c8) http1 or h2c. Defaults to http1.
        :param pulumi.Input[str] registry_image: The registry image address. e.g: **"rg.fr-par.scw.cloud/$NAMESPACE/$IMAGE"**.
        :param pulumi.Input[str] registry_sha256: The sha256 of your source registry image, changing it will re-apply the deployment. Can be any string
        :param pulumi.Input[str] status: The container status.
        :param pulumi.Input[int] timeout: The maximum amount of time in seconds during which your container can process a request before we stop it. Defaults to 300s.
        """
        pulumi.set(__self__, "namespace_id", namespace_id)
        if cpu_limit is not None:
            pulumi.set(__self__, "cpu_limit", cpu_limit)
        if deploy is not None:
            pulumi.set(__self__, "deploy", deploy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if max_concurrency is not None:
            pulumi.set(__self__, "max_concurrency", max_concurrency)
        if max_scale is not None:
            pulumi.set(__self__, "max_scale", max_scale)
        if memory_limit is not None:
            pulumi.set(__self__, "memory_limit", memory_limit)
        if min_scale is not None:
            pulumi.set(__self__, "min_scale", min_scale)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if privacy is not None:
            pulumi.set(__self__, "privacy", privacy)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if registry_image is not None:
            pulumi.set(__self__, "registry_image", registry_image)
        if registry_sha256 is not None:
            pulumi.set(__self__, "registry_sha256", registry_sha256)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> pulumi.Input[str]:
        """
        The container namespace ID of the container.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace_id", value)

    @property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of vCPU computing resources to allocate to each container. Defaults to 70.
        """
        return pulumi.get(self, "cpu_limit")

    @cpu_limit.setter
    def cpu_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_limit", value)

    @property
    @pulumi.getter
    def deploy(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean controlling whether the container is on a production environment.
        """
        return pulumi.get(self, "deploy")

    @deploy.setter
    def deploy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deploy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the container.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The [environment](https://www.scaleway.com/en/docs/compute/containers/concepts/#environment-variables) variables of the container.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of simultaneous requests your container can handle at the same time. Defaults to 50.
        """
        return pulumi.get(self, "max_concurrency")

    @max_concurrency.setter
    def max_concurrency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrency", value)

    @property
    @pulumi.getter(name="maxScale")
    def max_scale(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum of number of instances this container can scale to. Default to 20.
        """
        return pulumi.get(self, "max_scale")

    @max_scale.setter
    def max_scale(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_scale", value)

    @property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The memory computing resources in MB to allocate to each container. Defaults to 128.
        """
        return pulumi.get(self, "memory_limit")

    @memory_limit.setter
    def memory_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_limit", value)

    @property
    @pulumi.getter(name="minScale")
    def min_scale(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum of running container instances continuously. Defaults to 0.
        """
        return pulumi.get(self, "min_scale")

    @min_scale.setter
    def min_scale(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_scale", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique name of the container name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port to expose the container. Defaults to 8080.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def privacy(self) -> Optional[pulumi.Input[str]]:
        """
        The privacy type define the way to authenticate to your container. Please check our dedicated [section](https://developers.scaleway.com/en/products/containers/api/#protocol-9dd4c8).
        """
        return pulumi.get(self, "privacy")

    @privacy.setter
    def privacy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "privacy", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The communication [protocol](https://developers.scaleway.com/en/products/containers/api/#protocol-9dd4c8) http1 or h2c. Defaults to http1.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="registryImage")
    def registry_image(self) -> Optional[pulumi.Input[str]]:
        """
        The registry image address. e.g: **"rg.fr-par.scw.cloud/$NAMESPACE/$IMAGE"**.
        """
        return pulumi.get(self, "registry_image")

    @registry_image.setter
    def registry_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry_image", value)

    @property
    @pulumi.getter(name="registrySha256")
    def registry_sha256(self) -> Optional[pulumi.Input[str]]:
        """
        The sha256 of your source registry image, changing it will re-apply the deployment. Can be any string
        """
        return pulumi.get(self, "registry_sha256")

    @registry_sha256.setter
    def registry_sha256(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry_sha256", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The container status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum amount of time in seconds during which your container can process a request before we stop it. Defaults to 300s.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class _ContainerState:
    def __init__(__self__, *,
                 cpu_limit: Optional[pulumi.Input[int]] = None,
                 cron_status: Optional[pulumi.Input[str]] = None,
                 deploy: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 error_message: Optional[pulumi.Input[str]] = None,
                 max_concurrency: Optional[pulumi.Input[int]] = None,
                 max_scale: Optional[pulumi.Input[int]] = None,
                 memory_limit: Optional[pulumi.Input[int]] = None,
                 min_scale: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace_id: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 privacy: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 registry_image: Optional[pulumi.Input[str]] = None,
                 registry_sha256: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Container resources.
        :param pulumi.Input[int] cpu_limit: The amount of vCPU computing resources to allocate to each container. Defaults to 70.
        :param pulumi.Input[str] cron_status: The cron status of the container.
        :param pulumi.Input[bool] deploy: Boolean controlling whether the container is on a production environment.
        :param pulumi.Input[str] description: The description of the container.
        :param pulumi.Input[str] domain_name: The container domain name.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: The [environment](https://www.scaleway.com/en/docs/compute/containers/concepts/#environment-variables) variables of the container.
        :param pulumi.Input[str] error_message: The error message of the container.
        :param pulumi.Input[int] max_concurrency: The maximum number of simultaneous requests your container can handle at the same time. Defaults to 50.
        :param pulumi.Input[int] max_scale: The maximum of number of instances this container can scale to. Default to 20.
        :param pulumi.Input[int] memory_limit: The memory computing resources in MB to allocate to each container. Defaults to 128.
        :param pulumi.Input[int] min_scale: The minimum of running container instances continuously. Defaults to 0.
        :param pulumi.Input[str] name: The unique name of the container name.
        :param pulumi.Input[str] namespace_id: The container namespace ID of the container.
        :param pulumi.Input[int] port: The port to expose the container. Defaults to 8080.
        :param pulumi.Input[str] privacy: The privacy type define the way to authenticate to your container. Please check our dedicated [section](https://developers.scaleway.com/en/products/containers/api/#protocol-9dd4c8).
        :param pulumi.Input[str] protocol: The communication [protocol](https://developers.scaleway.com/en/products/containers/api/#protocol-9dd4c8) http1 or h2c. Defaults to http1.
        :param pulumi.Input[str] region: (Defaults to provider `region`) The region in which the container was created.
        :param pulumi.Input[str] registry_image: The registry image address. e.g: **"rg.fr-par.scw.cloud/$NAMESPACE/$IMAGE"**.
        :param pulumi.Input[str] registry_sha256: The sha256 of your source registry image, changing it will re-apply the deployment. Can be any string
        :param pulumi.Input[str] status: The container status.
        :param pulumi.Input[int] timeout: The maximum amount of time in seconds during which your container can process a request before we stop it. Defaults to 300s.
        """
        if cpu_limit is not None:
            pulumi.set(__self__, "cpu_limit", cpu_limit)
        if cron_status is not None:
            pulumi.set(__self__, "cron_status", cron_status)
        if deploy is not None:
            pulumi.set(__self__, "deploy", deploy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if max_concurrency is not None:
            pulumi.set(__self__, "max_concurrency", max_concurrency)
        if max_scale is not None:
            pulumi.set(__self__, "max_scale", max_scale)
        if memory_limit is not None:
            pulumi.set(__self__, "memory_limit", memory_limit)
        if min_scale is not None:
            pulumi.set(__self__, "min_scale", min_scale)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if privacy is not None:
            pulumi.set(__self__, "privacy", privacy)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if registry_image is not None:
            pulumi.set(__self__, "registry_image", registry_image)
        if registry_sha256 is not None:
            pulumi.set(__self__, "registry_sha256", registry_sha256)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of vCPU computing resources to allocate to each container. Defaults to 70.
        """
        return pulumi.get(self, "cpu_limit")

    @cpu_limit.setter
    def cpu_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_limit", value)

    @property
    @pulumi.getter(name="cronStatus")
    def cron_status(self) -> Optional[pulumi.Input[str]]:
        """
        The cron status of the container.
        """
        return pulumi.get(self, "cron_status")

    @cron_status.setter
    def cron_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cron_status", value)

    @property
    @pulumi.getter
    def deploy(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean controlling whether the container is on a production environment.
        """
        return pulumi.get(self, "deploy")

    @deploy.setter
    def deploy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deploy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the container.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The container domain name.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The [environment](https://www.scaleway.com/en/docs/compute/containers/concepts/#environment-variables) variables of the container.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[pulumi.Input[str]]:
        """
        The error message of the container.
        """
        return pulumi.get(self, "error_message")

    @error_message.setter
    def error_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error_message", value)

    @property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of simultaneous requests your container can handle at the same time. Defaults to 50.
        """
        return pulumi.get(self, "max_concurrency")

    @max_concurrency.setter
    def max_concurrency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrency", value)

    @property
    @pulumi.getter(name="maxScale")
    def max_scale(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum of number of instances this container can scale to. Default to 20.
        """
        return pulumi.get(self, "max_scale")

    @max_scale.setter
    def max_scale(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_scale", value)

    @property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The memory computing resources in MB to allocate to each container. Defaults to 128.
        """
        return pulumi.get(self, "memory_limit")

    @memory_limit.setter
    def memory_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_limit", value)

    @property
    @pulumi.getter(name="minScale")
    def min_scale(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum of running container instances continuously. Defaults to 0.
        """
        return pulumi.get(self, "min_scale")

    @min_scale.setter
    def min_scale(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_scale", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique name of the container name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[pulumi.Input[str]]:
        """
        The container namespace ID of the container.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace_id", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port to expose the container. Defaults to 8080.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def privacy(self) -> Optional[pulumi.Input[str]]:
        """
        The privacy type define the way to authenticate to your container. Please check our dedicated [section](https://developers.scaleway.com/en/products/containers/api/#protocol-9dd4c8).
        """
        return pulumi.get(self, "privacy")

    @privacy.setter
    def privacy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "privacy", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The communication [protocol](https://developers.scaleway.com/en/products/containers/api/#protocol-9dd4c8) http1 or h2c. Defaults to http1.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        (Defaults to provider `region`) The region in which the container was created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="registryImage")
    def registry_image(self) -> Optional[pulumi.Input[str]]:
        """
        The registry image address. e.g: **"rg.fr-par.scw.cloud/$NAMESPACE/$IMAGE"**.
        """
        return pulumi.get(self, "registry_image")

    @registry_image.setter
    def registry_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry_image", value)

    @property
    @pulumi.getter(name="registrySha256")
    def registry_sha256(self) -> Optional[pulumi.Input[str]]:
        """
        The sha256 of your source registry image, changing it will re-apply the deployment. Can be any string
        """
        return pulumi.get(self, "registry_sha256")

    @registry_sha256.setter
    def registry_sha256(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry_sha256", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The container status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum amount of time in seconds during which your container can process a request before we stop it. Defaults to 300s.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)


class Container(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cpu_limit: Optional[pulumi.Input[int]] = None,
                 deploy: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_concurrency: Optional[pulumi.Input[int]] = None,
                 max_scale: Optional[pulumi.Input[int]] = None,
                 memory_limit: Optional[pulumi.Input[int]] = None,
                 min_scale: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace_id: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 privacy: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 registry_image: Optional[pulumi.Input[str]] = None,
                 registry_sha256: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Container.

        For more information consult the [documentation](https://www.scaleway.com/en/docs/faq/serverless-containers/).

        For more details about the limitation check [containers-limitations](https://www.scaleway.com/en/docs/compute/containers/reference-content/containers-limitations/).

        You can check also our [containers guide](https://www.scaleway.com/en/docs/compute/containers/concepts/).

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_scaleway as scaleway

        main_container_namespace = scaleway.ContainerNamespace("mainContainerNamespace", description="test container")
        main_container = scaleway.Container("mainContainer",
            description="environment variables test",
            namespace_id=main_container_namespace.id,
            registry_image=main_container_namespace.registry_endpoint.apply(lambda registry_endpoint: f"{registry_endpoint}/alpine:test"),
            port=9997,
            cpu_limit=140,
            memory_limit=256,
            min_scale=3,
            max_scale=5,
            timeout=600,
            max_concurrency=80,
            privacy="private",
            protocol="h2c",
            deploy=True,
            environment_variables={
                "foo": "var",
            })
        ```
        ## Protocols

        The supported protocols are:

        * `h2c`: HTTP/2 over TCP.
        * `http1`: Hypertext Transfer Protocol.

        **Important:** For details about the protocols check [this](https://httpd.apache.org/docs/2.4/howto/http2.html)

        ## Privacy

        By default, creating a container will make it `public`, meaning that anybody knowing the endpoint could execute it.
        A container can be made `private` with the privacy parameter.

        Please check our [authentication](https://developers.scaleway.com/en/products/containers/api/#protocol-9dd4c8) section

        ## Memory and vCPUs configuration

        The vCPU represents a portion or share of the underlying, physical CPU that is assigned to a particular virtual machine (VM).

        You may decide how much computing resources to allocate to each container.
        The `memory_limit` (in MB) must correspond with the right amount of vCPU.

        **Important:** The right choice for your container's resources is very important, as you will be billed based on compute usage over time and the number of Containers executions.

        Please check our [price](https://www.scaleway.com/en/docs/faq/serverless-containers/#prices) section for more details.

        | Memory (in MB) | vCPU |
        |----------------|------|
        | 128            | 70m  |
        | 256            | 140m |
        | 512            | 280m |
        | 1024           | 560m |

        **Note:** 560mCPU accounts roughly for half of one CPU power of a Scaleway General Purpose instance

        ## Import

        Container can be imported using the `{region}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/container:Container main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] cpu_limit: The amount of vCPU computing resources to allocate to each container. Defaults to 70.
        :param pulumi.Input[bool] deploy: Boolean controlling whether the container is on a production environment.
        :param pulumi.Input[str] description: The description of the container.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: The [environment](https://www.scaleway.com/en/docs/compute/containers/concepts/#environment-variables) variables of the container.
        :param pulumi.Input[int] max_concurrency: The maximum number of simultaneous requests your container can handle at the same time. Defaults to 50.
        :param pulumi.Input[int] max_scale: The maximum of number of instances this container can scale to. Default to 20.
        :param pulumi.Input[int] memory_limit: The memory computing resources in MB to allocate to each container. Defaults to 128.
        :param pulumi.Input[int] min_scale: The minimum of running container instances continuously. Defaults to 0.
        :param pulumi.Input[str] name: The unique name of the container name.
        :param pulumi.Input[str] namespace_id: The container namespace ID of the container.
        :param pulumi.Input[int] port: The port to expose the container. Defaults to 8080.
        :param pulumi.Input[str] privacy: The privacy type define the way to authenticate to your container. Please check our dedicated [section](https://developers.scaleway.com/en/products/containers/api/#protocol-9dd4c8).
        :param pulumi.Input[str] protocol: The communication [protocol](https://developers.scaleway.com/en/products/containers/api/#protocol-9dd4c8) http1 or h2c. Defaults to http1.
        :param pulumi.Input[str] registry_image: The registry image address. e.g: **"rg.fr-par.scw.cloud/$NAMESPACE/$IMAGE"**.
        :param pulumi.Input[str] registry_sha256: The sha256 of your source registry image, changing it will re-apply the deployment. Can be any string
        :param pulumi.Input[str] status: The container status.
        :param pulumi.Input[int] timeout: The maximum amount of time in seconds during which your container can process a request before we stop it. Defaults to 300s.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContainerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Container.

        For more information consult the [documentation](https://www.scaleway.com/en/docs/faq/serverless-containers/).

        For more details about the limitation check [containers-limitations](https://www.scaleway.com/en/docs/compute/containers/reference-content/containers-limitations/).

        You can check also our [containers guide](https://www.scaleway.com/en/docs/compute/containers/concepts/).

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_scaleway as scaleway

        main_container_namespace = scaleway.ContainerNamespace("mainContainerNamespace", description="test container")
        main_container = scaleway.Container("mainContainer",
            description="environment variables test",
            namespace_id=main_container_namespace.id,
            registry_image=main_container_namespace.registry_endpoint.apply(lambda registry_endpoint: f"{registry_endpoint}/alpine:test"),
            port=9997,
            cpu_limit=140,
            memory_limit=256,
            min_scale=3,
            max_scale=5,
            timeout=600,
            max_concurrency=80,
            privacy="private",
            protocol="h2c",
            deploy=True,
            environment_variables={
                "foo": "var",
            })
        ```
        ## Protocols

        The supported protocols are:

        * `h2c`: HTTP/2 over TCP.
        * `http1`: Hypertext Transfer Protocol.

        **Important:** For details about the protocols check [this](https://httpd.apache.org/docs/2.4/howto/http2.html)

        ## Privacy

        By default, creating a container will make it `public`, meaning that anybody knowing the endpoint could execute it.
        A container can be made `private` with the privacy parameter.

        Please check our [authentication](https://developers.scaleway.com/en/products/containers/api/#protocol-9dd4c8) section

        ## Memory and vCPUs configuration

        The vCPU represents a portion or share of the underlying, physical CPU that is assigned to a particular virtual machine (VM).

        You may decide how much computing resources to allocate to each container.
        The `memory_limit` (in MB) must correspond with the right amount of vCPU.

        **Important:** The right choice for your container's resources is very important, as you will be billed based on compute usage over time and the number of Containers executions.

        Please check our [price](https://www.scaleway.com/en/docs/faq/serverless-containers/#prices) section for more details.

        | Memory (in MB) | vCPU |
        |----------------|------|
        | 128            | 70m  |
        | 256            | 140m |
        | 512            | 280m |
        | 1024           | 560m |

        **Note:** 560mCPU accounts roughly for half of one CPU power of a Scaleway General Purpose instance

        ## Import

        Container can be imported using the `{region}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/container:Container main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param ContainerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContainerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cpu_limit: Optional[pulumi.Input[int]] = None,
                 deploy: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_concurrency: Optional[pulumi.Input[int]] = None,
                 max_scale: Optional[pulumi.Input[int]] = None,
                 memory_limit: Optional[pulumi.Input[int]] = None,
                 min_scale: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace_id: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 privacy: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 registry_image: Optional[pulumi.Input[str]] = None,
                 registry_sha256: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContainerArgs.__new__(ContainerArgs)

            __props__.__dict__["cpu_limit"] = cpu_limit
            __props__.__dict__["deploy"] = deploy
            __props__.__dict__["description"] = description
            __props__.__dict__["environment_variables"] = environment_variables
            __props__.__dict__["max_concurrency"] = max_concurrency
            __props__.__dict__["max_scale"] = max_scale
            __props__.__dict__["memory_limit"] = memory_limit
            __props__.__dict__["min_scale"] = min_scale
            __props__.__dict__["name"] = name
            if namespace_id is None and not opts.urn:
                raise TypeError("Missing required property 'namespace_id'")
            __props__.__dict__["namespace_id"] = namespace_id
            __props__.__dict__["port"] = port
            __props__.__dict__["privacy"] = privacy
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["registry_image"] = registry_image
            __props__.__dict__["registry_sha256"] = registry_sha256
            __props__.__dict__["status"] = status
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["cron_status"] = None
            __props__.__dict__["domain_name"] = None
            __props__.__dict__["error_message"] = None
            __props__.__dict__["region"] = None
        super(Container, __self__).__init__(
            'scaleway:index/container:Container',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cpu_limit: Optional[pulumi.Input[int]] = None,
            cron_status: Optional[pulumi.Input[str]] = None,
            deploy: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            domain_name: Optional[pulumi.Input[str]] = None,
            environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            error_message: Optional[pulumi.Input[str]] = None,
            max_concurrency: Optional[pulumi.Input[int]] = None,
            max_scale: Optional[pulumi.Input[int]] = None,
            memory_limit: Optional[pulumi.Input[int]] = None,
            min_scale: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace_id: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            privacy: Optional[pulumi.Input[str]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            registry_image: Optional[pulumi.Input[str]] = None,
            registry_sha256: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            timeout: Optional[pulumi.Input[int]] = None) -> 'Container':
        """
        Get an existing Container resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] cpu_limit: The amount of vCPU computing resources to allocate to each container. Defaults to 70.
        :param pulumi.Input[str] cron_status: The cron status of the container.
        :param pulumi.Input[bool] deploy: Boolean controlling whether the container is on a production environment.
        :param pulumi.Input[str] description: The description of the container.
        :param pulumi.Input[str] domain_name: The container domain name.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: The [environment](https://www.scaleway.com/en/docs/compute/containers/concepts/#environment-variables) variables of the container.
        :param pulumi.Input[str] error_message: The error message of the container.
        :param pulumi.Input[int] max_concurrency: The maximum number of simultaneous requests your container can handle at the same time. Defaults to 50.
        :param pulumi.Input[int] max_scale: The maximum of number of instances this container can scale to. Default to 20.
        :param pulumi.Input[int] memory_limit: The memory computing resources in MB to allocate to each container. Defaults to 128.
        :param pulumi.Input[int] min_scale: The minimum of running container instances continuously. Defaults to 0.
        :param pulumi.Input[str] name: The unique name of the container name.
        :param pulumi.Input[str] namespace_id: The container namespace ID of the container.
        :param pulumi.Input[int] port: The port to expose the container. Defaults to 8080.
        :param pulumi.Input[str] privacy: The privacy type define the way to authenticate to your container. Please check our dedicated [section](https://developers.scaleway.com/en/products/containers/api/#protocol-9dd4c8).
        :param pulumi.Input[str] protocol: The communication [protocol](https://developers.scaleway.com/en/products/containers/api/#protocol-9dd4c8) http1 or h2c. Defaults to http1.
        :param pulumi.Input[str] region: (Defaults to provider `region`) The region in which the container was created.
        :param pulumi.Input[str] registry_image: The registry image address. e.g: **"rg.fr-par.scw.cloud/$NAMESPACE/$IMAGE"**.
        :param pulumi.Input[str] registry_sha256: The sha256 of your source registry image, changing it will re-apply the deployment. Can be any string
        :param pulumi.Input[str] status: The container status.
        :param pulumi.Input[int] timeout: The maximum amount of time in seconds during which your container can process a request before we stop it. Defaults to 300s.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContainerState.__new__(_ContainerState)

        __props__.__dict__["cpu_limit"] = cpu_limit
        __props__.__dict__["cron_status"] = cron_status
        __props__.__dict__["deploy"] = deploy
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["error_message"] = error_message
        __props__.__dict__["max_concurrency"] = max_concurrency
        __props__.__dict__["max_scale"] = max_scale
        __props__.__dict__["memory_limit"] = memory_limit
        __props__.__dict__["min_scale"] = min_scale
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace_id"] = namespace_id
        __props__.__dict__["port"] = port
        __props__.__dict__["privacy"] = privacy
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["region"] = region
        __props__.__dict__["registry_image"] = registry_image
        __props__.__dict__["registry_sha256"] = registry_sha256
        __props__.__dict__["status"] = status
        __props__.__dict__["timeout"] = timeout
        return Container(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> pulumi.Output[int]:
        """
        The amount of vCPU computing resources to allocate to each container. Defaults to 70.
        """
        return pulumi.get(self, "cpu_limit")

    @property
    @pulumi.getter(name="cronStatus")
    def cron_status(self) -> pulumi.Output[str]:
        """
        The cron status of the container.
        """
        return pulumi.get(self, "cron_status")

    @property
    @pulumi.getter
    def deploy(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean controlling whether the container is on a production environment.
        """
        return pulumi.get(self, "deploy")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the container.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        The container domain name.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The [environment](https://www.scaleway.com/en/docs/compute/containers/concepts/#environment-variables) variables of the container.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> pulumi.Output[str]:
        """
        The error message of the container.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> pulumi.Output[int]:
        """
        The maximum number of simultaneous requests your container can handle at the same time. Defaults to 50.
        """
        return pulumi.get(self, "max_concurrency")

    @property
    @pulumi.getter(name="maxScale")
    def max_scale(self) -> pulumi.Output[int]:
        """
        The maximum of number of instances this container can scale to. Default to 20.
        """
        return pulumi.get(self, "max_scale")

    @property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> pulumi.Output[int]:
        """
        The memory computing resources in MB to allocate to each container. Defaults to 128.
        """
        return pulumi.get(self, "memory_limit")

    @property
    @pulumi.getter(name="minScale")
    def min_scale(self) -> pulumi.Output[int]:
        """
        The minimum of running container instances continuously. Defaults to 0.
        """
        return pulumi.get(self, "min_scale")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The unique name of the container name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> pulumi.Output[str]:
        """
        The container namespace ID of the container.
        """
        return pulumi.get(self, "namespace_id")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        The port to expose the container. Defaults to 8080.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def privacy(self) -> pulumi.Output[Optional[str]]:
        """
        The privacy type define the way to authenticate to your container. Please check our dedicated [section](https://developers.scaleway.com/en/products/containers/api/#protocol-9dd4c8).
        """
        return pulumi.get(self, "privacy")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[str]]:
        """
        The communication [protocol](https://developers.scaleway.com/en/products/containers/api/#protocol-9dd4c8) http1 or h2c. Defaults to http1.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        (Defaults to provider `region`) The region in which the container was created.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="registryImage")
    def registry_image(self) -> pulumi.Output[str]:
        """
        The registry image address. e.g: **"rg.fr-par.scw.cloud/$NAMESPACE/$IMAGE"**.
        """
        return pulumi.get(self, "registry_image")

    @property
    @pulumi.getter(name="registrySha256")
    def registry_sha256(self) -> pulumi.Output[Optional[str]]:
        """
        The sha256 of your source registry image, changing it will re-apply the deployment. Can be any string
        """
        return pulumi.get(self, "registry_sha256")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The container status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[int]:
        """
        The maximum amount of time in seconds during which your container can process a request before we stop it. Defaults to 300s.
        """
        return pulumi.get(self, "timeout")

