# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class TrunkMetricsTopicLocalTime(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        TrunkMetricsTopicLocalTime - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'hour': 'int',
            'minute': 'int',
            'second': 'int',
            'nano': 'int'
        }

        self.attribute_map = {
            'hour': 'hour',
            'minute': 'minute',
            'second': 'second',
            'nano': 'nano'
        }

        self._hour = None
        self._minute = None
        self._second = None
        self._nano = None

    @property
    def hour(self):
        """
        Gets the hour of this TrunkMetricsTopicLocalTime.


        :return: The hour of this TrunkMetricsTopicLocalTime.
        :rtype: int
        """
        return self._hour

    @hour.setter
    def hour(self, hour):
        """
        Sets the hour of this TrunkMetricsTopicLocalTime.


        :param hour: The hour of this TrunkMetricsTopicLocalTime.
        :type: int
        """
        
        self._hour = hour

    @property
    def minute(self):
        """
        Gets the minute of this TrunkMetricsTopicLocalTime.


        :return: The minute of this TrunkMetricsTopicLocalTime.
        :rtype: int
        """
        return self._minute

    @minute.setter
    def minute(self, minute):
        """
        Sets the minute of this TrunkMetricsTopicLocalTime.


        :param minute: The minute of this TrunkMetricsTopicLocalTime.
        :type: int
        """
        
        self._minute = minute

    @property
    def second(self):
        """
        Gets the second of this TrunkMetricsTopicLocalTime.


        :return: The second of this TrunkMetricsTopicLocalTime.
        :rtype: int
        """
        return self._second

    @second.setter
    def second(self, second):
        """
        Sets the second of this TrunkMetricsTopicLocalTime.


        :param second: The second of this TrunkMetricsTopicLocalTime.
        :type: int
        """
        
        self._second = second

    @property
    def nano(self):
        """
        Gets the nano of this TrunkMetricsTopicLocalTime.


        :return: The nano of this TrunkMetricsTopicLocalTime.
        :rtype: int
        """
        return self._nano

    @nano.setter
    def nano(self, nano):
        """
        Sets the nano of this TrunkMetricsTopicLocalTime.


        :param nano: The nano of this TrunkMetricsTopicLocalTime.
        :type: int
        """
        
        self._nano = nano

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

