# Milvus_CLI🚀

![GitHub release (latest by date including pre-releases)](https://img.shields.io/github/v/release/zilliztech/milvus_cli?include_prereleases) ![PyPI](https://img.shields.io/pypi/v/milvus-cli)
![PyPI - Downloads](https://img.shields.io/pypi/dm/milvus_cli?label=PYPI%20downloads) ![GitHub release (latest by date including pre-releases)](https://img.shields.io/github/downloads-pre/zilliztech/milvus_cli/latest/total?label=Release%40latest%20downloads) ![Docker Pulls](https://img.shields.io/docker/pulls/zilliz/milvus_cli)
![GitHub repo size](https://img.shields.io/github/repo-size/zilliztech/milvus_cli) ![PyPI - License](https://img.shields.io/pypi/l/milvus-cli)

## Overview

[Milvus](https://github.com/milvus-io/milvus) Command Line Interface based on [Milvus Python SDK](https://github.com/milvus-io/pymilvus).

- Applicable to most platforms: MS Windows, macOS, Ubuntu

- Support pip install & offline installation package

- Support single executable file

- Milvus Python SDK full function coverage

- Built-in help function

- Support auto completion

## Installation methods

### 🔝Install in a Python environment

#### Prerequisites

Python >= 3.8.5

#### Install from PyPI (Recommended)

Run `pip install milvus-cli==0.3.1`

#### Install from a tarball

1. Download the [latest release](https://github.com/zilliztech/milvus_cli/releases/latest) of ` milvus_cli-<version>.tar.gz`.
2. Run `pip install milvus_cli-<version>.tar.gz`.

#### Install from source code

1. Run `git clone https://github.com/zilliztech/milvus_cli.git`.
2. Run `cd milvus_cli`.
3. Run `pip install --editable .`

### Install from an executable file

#### Windows .exe file

Download the [latest release](https://github.com/zilliztech/milvus_cli/releases/latest) of `milvus_cli.exe` and run it.

#### Ubuntu executable file

1. Download the [latest release](https://github.com/zilliztech/milvus_cli/releases/latest) of `milvus_cli-<version>-Linux`.
2. Run `sudo chmod +x milvus_cli-<version>-Linux` to allow executing `milvus_cli-<version>-Linux` as program.
3. Run `./milvus_cli-<version>-Linux`.

#### MacOS executable file

1. Download the [latest release](https://github.com/zilliztech/milvus_cli/releases/latest) of `milvus_cli-<version>-macOS`.
2. Run `sudo chmod +x milvus_cli-<version>-macOS` to allow executing `milvus_cli-<version>-macOS` as program.
3. Run `./milvus_cli-<version>-macOS`.

### Docker image in docker hub

`docker run -it zilliz/milvus_cli:latest`

## Usage

Run `milvus_cli` (in a Python environment) or double click `milvus_cli-<version>.exe` file (in a Windows environment).

#### Run Milvus_CLI

- In a Python environment, run `milvus_cli`.
- In a Windows environment, double click `milvus_cli-<version>.exe`.
- In an Ubuntu environment, run `./milvus_cli-<version>-Linux`.
- In a MacOS environment, run `./milvus_cli-<version>-macOS`.

### Document

https://github.com/zilliztech/milvus_cli/tree/main/doc

## Community

💬 Community isn’t just about writing code together. Come join the conversation, share your knowledge and get your questions answered on [Milvus Slack Channel](https://join.slack.com/t/milvusio/shared_invite/zt-e0u4qu3k-bI2GDNys3ZqX1YCJ9OM~GQ)!

<a href="https://join.slack.com/t/milvusio/shared_invite/zt-e0u4qu3k-bI2GDNys3ZqX1YCJ9OM~GQ">
    <img src="https://assets.zilliz.com/readme_slack_4a07c4c92f.png" alt="Miluvs Slack Channel"  height="150" width="500">
</a>

<br><!-- Do not remove start of hero-bot --><br>
<img src="https://img.shields.io/badge/all--contributors-6-orange"><br>
<a href="https://github.com/chris-zilliz"><img src="https://avatars.githubusercontent.com/u/91247127?v=4" width="30px" /></a>
<a href="https://github.com/czhen-zilliz"><img src="https://avatars.githubusercontent.com/u/83751452?v=4" width="30px" /></a>
<a href="https://github.com/haorenfsa"><img src="https://avatars.githubusercontent.com/u/15938850?v=4" width="30px" /></a>
<a href="https://github.com/kateshaowanjou"><img src="https://avatars.githubusercontent.com/u/58837504?v=4" width="30px" /></a>
<a href="https://github.com/matrixji"><img src="https://avatars.githubusercontent.com/u/183388?v=4" width="30px" /></a>
<a href="https://github.com/sre-ci-robot"><img src="https://avatars.githubusercontent.com/u/56469371?v=4" width="30px" /></a>
<br><!-- Do not remove end of hero-bot --><br>
