"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HelmChart = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const kubectl_provider_1 = require("./kubectl-provider");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
/**
 * Represents a helm chart within the Kubernetes system.
 *
 * Applies/deletes the resources using `kubectl` in sync with the resource.
 */
class HelmChart extends core_2.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d, _e, _f, _g, _h;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_eks_HelmChartProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const stack = core_1.Stack.of(this);
        const provider = kubectl_provider_1.KubectlProvider.getOrCreate(this, props.cluster);
        const timeout = (_b = props.timeout) === null || _b === void 0 ? void 0 : _b.toSeconds();
        if (timeout && timeout > 900) {
            throw new Error('Helm chart timeout cannot be higher than 15 minutes.');
        }
        if (!props.chart && !props.chartAsset) {
            throw new Error("Either 'chart' or 'chartAsset' must be specified to install a helm chart");
        }
        if (props.chartAsset && (props.repository || props.version)) {
            throw new Error("Neither 'repository' nor 'version' can be used when configuring 'chartAsset'");
        }
        // default not to wait
        const wait = (_c = props.wait) !== null && _c !== void 0 ? _c : false;
        // default to create new namespace
        const createNamespace = (_d = props.createNamespace) !== null && _d !== void 0 ? _d : true;
        (_e = props.chartAsset) === null || _e === void 0 ? void 0 : _e.grantRead(provider.handlerRole);
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: HelmChart.RESOURCE_TYPE,
            properties: {
                ClusterName: props.cluster.clusterName,
                RoleArn: provider.roleArn,
                Release: (_f = props.release) !== null && _f !== void 0 ? _f : core_1.Names.uniqueId(this).slice(-53).toLowerCase(),
                Chart: props.chart,
                ChartAssetURL: (_g = props.chartAsset) === null || _g === void 0 ? void 0 : _g.s3ObjectUrl,
                Version: props.version,
                Wait: wait || undefined,
                Timeout: timeout ? `${timeout.toString()}s` : undefined,
                Values: (props.values ? stack.toJsonString(props.values) : undefined),
                Namespace: (_h = props.namespace) !== null && _h !== void 0 ? _h : 'default',
                Repository: props.repository,
                CreateNamespace: createNamespace || undefined,
            },
        });
    }
}
exports.HelmChart = HelmChart;
_a = JSII_RTTI_SYMBOL_1;
HelmChart[_a] = { fqn: "@aws-cdk/aws-eks.HelmChart", version: "1.158.0" };
/**
 * The CloudFormation resource type.
 */
HelmChart.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-HelmChart';
//# sourceMappingURL=data:application/json;base64,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