# coding: utf-8

"""
    Nomad Pilot

    This is the API descriptor for the Nomad Pilot API, responsible for shipping and logistics processing. Developed by [Samarkand Global](https://samarkand.global) in partnership with [SF Express](https://www.sf-express.com/cn/sc), [eSinotrans](http://www.esinotrans.com/haitao.html), [sto](https://open.sto.cn/). Read the documentation online at [Nomad API Suite](https://api.samarkand.io/) and Check out the detailed [changelog](https://gitlab.com/samarkand-nomad/nomad_readme/-/raw/master/history/nomad_pilot.md). - Install for node with ``npm install nomad_pilot_cli`` - Install for python with ``pip install nomad-pilot-cli`` - Install for Maven users ``groupId, com.gitlab.samarkand-nomad; artifactId, nomad-pilot-cli``  # noqa: E501

    The version of the OpenAPI document: 1.31.1
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nomad_pilot_cli.configuration import Configuration


class PackagePutRequired(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'tracking_reference': 'str',
        'status': 'str'
    }

    attribute_map = {
        'tracking_reference': 'trackingReference',
        'status': 'status'
    }

    def __init__(self, tracking_reference=None, status='PACKED', local_vars_configuration=None):  # noqa: E501
        """PackagePutRequired - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._tracking_reference = None
        self._status = None
        self.discriminator = None

        self.tracking_reference = tracking_reference
        if status is not None:
            self.status = status

    @property
    def tracking_reference(self):
        """Gets the tracking_reference of this PackagePutRequired.  # noqa: E501


        :return: The tracking_reference of this PackagePutRequired.  # noqa: E501
        :rtype: str
        """
        return self._tracking_reference

    @tracking_reference.setter
    def tracking_reference(self, tracking_reference):
        """Sets the tracking_reference of this PackagePutRequired.


        :param tracking_reference: The tracking_reference of this PackagePutRequired.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and tracking_reference is None:  # noqa: E501
            raise ValueError("Invalid value for `tracking_reference`, must not be `None`")  # noqa: E501

        self._tracking_reference = tracking_reference

    @property
    def status(self):
        """Gets the status of this PackagePutRequired.  # noqa: E501

        package status, 3 available options: UNPROCESSED, PACKED, PROCESSED, CANCEL. Status SHIPPED are updated by confirm api  # noqa: E501

        :return: The status of this PackagePutRequired.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this PackagePutRequired.

        package status, 3 available options: UNPROCESSED, PACKED, PROCESSED, CANCEL. Status SHIPPED are updated by confirm api  # noqa: E501

        :param status: The status of this PackagePutRequired.  # noqa: E501
        :type: str
        """

        self._status = status

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PackagePutRequired):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PackagePutRequired):
            return True

        return self.to_dict() != other.to_dict()
