# coding: utf-8

"""
    Nomad Pilot

    This is the API descriptor for the Nomad Pilot API, responsible for shipping and logistics processing. Developed by [Samarkand Global](https://samarkand.global) in partnership with [SF Express](https://www.sf-express.com/cn/sc), [eSinotrans](http://www.esinotrans.com/haitao.html), [sto](https://open.sto.cn/). Read the documentation online at [Nomad API Suite](https://api.samarkand.io/) and Check out the detailed [changelog](https://gitlab.com/samarkand-nomad/nomad_readme/-/raw/master/history/nomad_pilot.md). - Install for node with ``npm install nomad_pilot_cli`` - Install for python with ``pip install nomad-pilot-cli`` - Install for Maven users ``groupId, com.gitlab.samarkand-nomad; artifactId, nomad-pilot-cli``  # noqa: E501

    The version of the OpenAPI document: 1.31.1
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nomad_pilot_cli.configuration import Configuration


class PackageItem(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'name_cn': 'str',
        'barcode': 'str',
        'sku_number': 'str',
        'quantity': 'int',
        'price': 'float',
        'brand': 'str',
        'quantity_uom': 'str',
        'hs_code': 'str',
        'country_of_origin': 'str',
        'goldjet': 'Goldjet',
        'gross_weight': 'float',
        'net_weight': 'float',
        'customs_unit_code': 'str',
        'customs_unit_code_package': 'str',
        'customs_unit_code_weight': 'str',
        'customs_filing_id': 'str',
        'spec': 'str',
        'model': 'str',
        'ingredients': 'str'
    }

    attribute_map = {
        'name': 'name',
        'name_cn': 'nameCn',
        'barcode': 'barcode',
        'sku_number': 'skuNumber',
        'quantity': 'quantity',
        'price': 'price',
        'brand': 'brand',
        'quantity_uom': 'quantityUom',
        'hs_code': 'hsCode',
        'country_of_origin': 'countryOfOrigin',
        'goldjet': 'goldjet',
        'gross_weight': 'grossWeight',
        'net_weight': 'netWeight',
        'customs_unit_code': 'customsUnitCode',
        'customs_unit_code_package': 'customsUnitCodePackage',
        'customs_unit_code_weight': 'customsUnitCodeWeight',
        'customs_filing_id': 'customsFilingId',
        'spec': 'spec',
        'model': 'model',
        'ingredients': 'ingredients'
    }

    def __init__(self, name=None, name_cn=None, barcode=None, sku_number=None, quantity=None, price=None, brand=None, quantity_uom=None, hs_code=None, country_of_origin=None, goldjet=None, gross_weight=None, net_weight=None, customs_unit_code=None, customs_unit_code_package=None, customs_unit_code_weight='035', customs_filing_id=None, spec=None, model=None, ingredients=None, local_vars_configuration=None):  # noqa: E501
        """PackageItem - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._name_cn = None
        self._barcode = None
        self._sku_number = None
        self._quantity = None
        self._price = None
        self._brand = None
        self._quantity_uom = None
        self._hs_code = None
        self._country_of_origin = None
        self._goldjet = None
        self._gross_weight = None
        self._net_weight = None
        self._customs_unit_code = None
        self._customs_unit_code_package = None
        self._customs_unit_code_weight = None
        self._customs_filing_id = None
        self._spec = None
        self._model = None
        self._ingredients = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if name_cn is not None:
            self.name_cn = name_cn
        if barcode is not None:
            self.barcode = barcode
        if sku_number is not None:
            self.sku_number = sku_number
        if quantity is not None:
            self.quantity = quantity
        if price is not None:
            self.price = price
        if brand is not None:
            self.brand = brand
        if quantity_uom is not None:
            self.quantity_uom = quantity_uom
        if hs_code is not None:
            self.hs_code = hs_code
        if country_of_origin is not None:
            self.country_of_origin = country_of_origin
        if goldjet is not None:
            self.goldjet = goldjet
        if gross_weight is not None:
            self.gross_weight = gross_weight
        if net_weight is not None:
            self.net_weight = net_weight
        if customs_unit_code is not None:
            self.customs_unit_code = customs_unit_code
        if customs_unit_code_package is not None:
            self.customs_unit_code_package = customs_unit_code_package
        if customs_unit_code_weight is not None:
            self.customs_unit_code_weight = customs_unit_code_weight
        if customs_filing_id is not None:
            self.customs_filing_id = customs_filing_id
        if spec is not None:
            self.spec = spec
        if model is not None:
            self.model = model
        if ingredients is not None:
            self.ingredients = ingredients

    @property
    def name(self):
        """Gets the name of this PackageItem.  # noqa: E501


        :return: The name of this PackageItem.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this PackageItem.


        :param name: The name of this PackageItem.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def name_cn(self):
        """Gets the name_cn of this PackageItem.  # noqa: E501

        The Chinese name of current product item  # noqa: E501

        :return: The name_cn of this PackageItem.  # noqa: E501
        :rtype: str
        """
        return self._name_cn

    @name_cn.setter
    def name_cn(self, name_cn):
        """Sets the name_cn of this PackageItem.

        The Chinese name of current product item  # noqa: E501

        :param name_cn: The name_cn of this PackageItem.  # noqa: E501
        :type: str
        """

        self._name_cn = name_cn

    @property
    def barcode(self):
        """Gets the barcode of this PackageItem.  # noqa: E501


        :return: The barcode of this PackageItem.  # noqa: E501
        :rtype: str
        """
        return self._barcode

    @barcode.setter
    def barcode(self, barcode):
        """Sets the barcode of this PackageItem.


        :param barcode: The barcode of this PackageItem.  # noqa: E501
        :type: str
        """

        self._barcode = barcode

    @property
    def sku_number(self):
        """Gets the sku_number of this PackageItem.  # noqa: E501


        :return: The sku_number of this PackageItem.  # noqa: E501
        :rtype: str
        """
        return self._sku_number

    @sku_number.setter
    def sku_number(self, sku_number):
        """Sets the sku_number of this PackageItem.


        :param sku_number: The sku_number of this PackageItem.  # noqa: E501
        :type: str
        """

        self._sku_number = sku_number

    @property
    def quantity(self):
        """Gets the quantity of this PackageItem.  # noqa: E501


        :return: The quantity of this PackageItem.  # noqa: E501
        :rtype: int
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this PackageItem.


        :param quantity: The quantity of this PackageItem.  # noqa: E501
        :type: int
        """

        self._quantity = quantity

    @property
    def price(self):
        """Gets the price of this PackageItem.  # noqa: E501

        The price of this product, not including any discount and tax.  # noqa: E501

        :return: The price of this PackageItem.  # noqa: E501
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this PackageItem.

        The price of this product, not including any discount and tax.  # noqa: E501

        :param price: The price of this PackageItem.  # noqa: E501
        :type: float
        """

        self._price = price

    @property
    def brand(self):
        """Gets the brand of this PackageItem.  # noqa: E501


        :return: The brand of this PackageItem.  # noqa: E501
        :rtype: str
        """
        return self._brand

    @brand.setter
    def brand(self, brand):
        """Sets the brand of this PackageItem.


        :param brand: The brand of this PackageItem.  # noqa: E501
        :type: str
        """

        self._brand = brand

    @property
    def quantity_uom(self):
        """Gets the quantity_uom of this PackageItem.  # noqa: E501


        :return: The quantity_uom of this PackageItem.  # noqa: E501
        :rtype: str
        """
        return self._quantity_uom

    @quantity_uom.setter
    def quantity_uom(self, quantity_uom):
        """Sets the quantity_uom of this PackageItem.


        :param quantity_uom: The quantity_uom of this PackageItem.  # noqa: E501
        :type: str
        """

        self._quantity_uom = quantity_uom

    @property
    def hs_code(self):
        """Gets the hs_code of this PackageItem.  # noqa: E501


        :return: The hs_code of this PackageItem.  # noqa: E501
        :rtype: str
        """
        return self._hs_code

    @hs_code.setter
    def hs_code(self, hs_code):
        """Sets the hs_code of this PackageItem.


        :param hs_code: The hs_code of this PackageItem.  # noqa: E501
        :type: str
        """

        self._hs_code = hs_code

    @property
    def country_of_origin(self):
        """Gets the country_of_origin of this PackageItem.  # noqa: E501


        :return: The country_of_origin of this PackageItem.  # noqa: E501
        :rtype: str
        """
        return self._country_of_origin

    @country_of_origin.setter
    def country_of_origin(self, country_of_origin):
        """Sets the country_of_origin of this PackageItem.


        :param country_of_origin: The country_of_origin of this PackageItem.  # noqa: E501
        :type: str
        """

        self._country_of_origin = country_of_origin

    @property
    def goldjet(self):
        """Gets the goldjet of this PackageItem.  # noqa: E501


        :return: The goldjet of this PackageItem.  # noqa: E501
        :rtype: Goldjet
        """
        return self._goldjet

    @goldjet.setter
    def goldjet(self, goldjet):
        """Sets the goldjet of this PackageItem.


        :param goldjet: The goldjet of this PackageItem.  # noqa: E501
        :type: Goldjet
        """

        self._goldjet = goldjet

    @property
    def gross_weight(self):
        """Gets the gross_weight of this PackageItem.  # noqa: E501

        Use Kilogram as the basic unit of mass.  # noqa: E501

        :return: The gross_weight of this PackageItem.  # noqa: E501
        :rtype: float
        """
        return self._gross_weight

    @gross_weight.setter
    def gross_weight(self, gross_weight):
        """Sets the gross_weight of this PackageItem.

        Use Kilogram as the basic unit of mass.  # noqa: E501

        :param gross_weight: The gross_weight of this PackageItem.  # noqa: E501
        :type: float
        """

        self._gross_weight = gross_weight

    @property
    def net_weight(self):
        """Gets the net_weight of this PackageItem.  # noqa: E501

        Use Kilogram as the basic unit of mass.  # noqa: E501

        :return: The net_weight of this PackageItem.  # noqa: E501
        :rtype: float
        """
        return self._net_weight

    @net_weight.setter
    def net_weight(self, net_weight):
        """Sets the net_weight of this PackageItem.

        Use Kilogram as the basic unit of mass.  # noqa: E501

        :param net_weight: The net_weight of this PackageItem.  # noqa: E501
        :type: float
        """

        self._net_weight = net_weight

    @property
    def customs_unit_code(self):
        """Gets the customs_unit_code of this PackageItem.  # noqa: E501

        aka customsUnitCodeSKU. The quantity unit code of current sku for customs purpose. Both Chinese or number are ok.  # noqa: E501

        :return: The customs_unit_code of this PackageItem.  # noqa: E501
        :rtype: str
        """
        return self._customs_unit_code

    @customs_unit_code.setter
    def customs_unit_code(self, customs_unit_code):
        """Sets the customs_unit_code of this PackageItem.

        aka customsUnitCodeSKU. The quantity unit code of current sku for customs purpose. Both Chinese or number are ok.  # noqa: E501

        :param customs_unit_code: The customs_unit_code of this PackageItem.  # noqa: E501
        :type: str
        """

        self._customs_unit_code = customs_unit_code

    @property
    def customs_unit_code_package(self):
        """Gets the customs_unit_code_package of this PackageItem.  # noqa: E501

        The quantity unit code customs purpose. Declaration Unit, 申报单位.  # noqa: E501

        :return: The customs_unit_code_package of this PackageItem.  # noqa: E501
        :rtype: str
        """
        return self._customs_unit_code_package

    @customs_unit_code_package.setter
    def customs_unit_code_package(self, customs_unit_code_package):
        """Sets the customs_unit_code_package of this PackageItem.

        The quantity unit code customs purpose. Declaration Unit, 申报单位.  # noqa: E501

        :param customs_unit_code_package: The customs_unit_code_package of this PackageItem.  # noqa: E501
        :type: str
        """

        self._customs_unit_code_package = customs_unit_code_package

    @property
    def customs_unit_code_weight(self):
        """Gets the customs_unit_code_weight of this PackageItem.  # noqa: E501

        The weight unit code for customs purpose.  # noqa: E501

        :return: The customs_unit_code_weight of this PackageItem.  # noqa: E501
        :rtype: str
        """
        return self._customs_unit_code_weight

    @customs_unit_code_weight.setter
    def customs_unit_code_weight(self, customs_unit_code_weight):
        """Sets the customs_unit_code_weight of this PackageItem.

        The weight unit code for customs purpose.  # noqa: E501

        :param customs_unit_code_weight: The customs_unit_code_weight of this PackageItem.  # noqa: E501
        :type: str
        """

        self._customs_unit_code_weight = customs_unit_code_weight

    @property
    def customs_filing_id(self):
        """Gets the customs_filing_id of this PackageItem.  # noqa: E501

        The returned filing id of current SKU from customs  # noqa: E501

        :return: The customs_filing_id of this PackageItem.  # noqa: E501
        :rtype: str
        """
        return self._customs_filing_id

    @customs_filing_id.setter
    def customs_filing_id(self, customs_filing_id):
        """Sets the customs_filing_id of this PackageItem.

        The returned filing id of current SKU from customs  # noqa: E501

        :param customs_filing_id: The customs_filing_id of this PackageItem.  # noqa: E501
        :type: str
        """

        self._customs_filing_id = customs_filing_id

    @property
    def spec(self):
        """Gets the spec of this PackageItem.  # noqa: E501

        The spec of current product.  # noqa: E501

        :return: The spec of this PackageItem.  # noqa: E501
        :rtype: str
        """
        return self._spec

    @spec.setter
    def spec(self, spec):
        """Sets the spec of this PackageItem.

        The spec of current product.  # noqa: E501

        :param spec: The spec of this PackageItem.  # noqa: E501
        :type: str
        """

        self._spec = spec

    @property
    def model(self):
        """Gets the model of this PackageItem.  # noqa: E501

        The model of current product.  # noqa: E501

        :return: The model of this PackageItem.  # noqa: E501
        :rtype: str
        """
        return self._model

    @model.setter
    def model(self, model):
        """Sets the model of this PackageItem.

        The model of current product.  # noqa: E501

        :param model: The model of this PackageItem.  # noqa: E501
        :type: str
        """

        self._model = model

    @property
    def ingredients(self):
        """Gets the ingredients of this PackageItem.  # noqa: E501

        The ingredients of current product.  # noqa: E501

        :return: The ingredients of this PackageItem.  # noqa: E501
        :rtype: str
        """
        return self._ingredients

    @ingredients.setter
    def ingredients(self, ingredients):
        """Sets the ingredients of this PackageItem.

        The ingredients of current product.  # noqa: E501

        :param ingredients: The ingredients of this PackageItem.  # noqa: E501
        :type: str
        """

        self._ingredients = ingredients

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PackageItem):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PackageItem):
            return True

        return self.to_dict() != other.to_dict()
