# SPDX-License-Identifier: LGPL-2.1-or-later

# Copyright (C) 2020, 2021 igo95862

# This file is part of python-sdbus

# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.

# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.

# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA
from __future__ import annotations

from .enums import (AccessPointCapabilities, BluetoothCapabilities,
                    ConnectionFlags, ConnectionState, ConnectionStateFlags,
                    ConnectionStateReason, ConnectivityState,
                    DeviceCapabilities, DeviceInterfaceFlags, DeviceMetered,
                    DeviceState, DeviceStateReason, DeviceType, IpTunnelMode,
                    ModemCapabilities, NetworkManagerConnectivityState,
                    NetworkManagerState, SecretAgentCapabilities, VpnFailure,
                    VpnState, WiFiOperationMode, WirelessCapabilities,
                    WpaSecurityFlags)
from .interfaces_devices import (NetworkManagerDeviceBluetoothInterface,
                                 NetworkManagerDeviceBondInterface,
                                 NetworkManagerDeviceBridgeInterface,
                                 NetworkManagerDeviceGenericInterface,
                                 NetworkManagerDeviceInterface,
                                 NetworkManagerDeviceIPTunnelInterface,
                                 NetworkManagerDeviceLowpanInterface,
                                 NetworkManagerDeviceMacsecInterface,
                                 NetworkManagerDeviceMacvlanInterface,
                                 NetworkManagerDeviceModemInterface,
                                 NetworkManagerDeviceOlpcMeshInterface,
                                 NetworkManagerDeviceOvsBridgeInterface,
                                 NetworkManagerDeviceOvsPortInterface,
                                 NetworkManagerDeviceStatisticsInterface,
                                 NetworkManagerDeviceTeamInterface,
                                 NetworkManagerDeviceTunInterface,
                                 NetworkManagerDeviceVethInterface,
                                 NetworkManagerDeviceVlanInterface,
                                 NetworkManagerDeviceVrfInterface,
                                 NetworkManagerDeviceVxlanInterface,
                                 NetworkManagerDeviceWifiP2PInterface,
                                 NetworkManagerDeviceWiredInterface,
                                 NetworkManagerDeviceWireGuardInterface,
                                 NetworkManagerDeviceWirelessInterface,
                                 NetworkManagerPPPInterface)
from .interfaces_other import (NetworkManagerAccessPointInterface,
                               NetworkManagerCheckpointInterface,
                               NetworkManagerConnectionActiveInterface,
                               NetworkManagerDHCP4ConfigInterface,
                               NetworkManagerDHCP6ConfigInterface,
                               NetworkManagerDnsManagerInterface,
                               NetworkManagerInterface,
                               NetworkManagerIP4ConfigInterface,
                               NetworkManagerIP6ConfigInterface,
                               NetworkManagerSecretAgentInterface,
                               NetworkManagerSecretAgentManagerInterface,
                               NetworkManagerSettingsConnectionInterface,
                               NetworkManagerSettingsInterface,
                               NetworkManagerVPNConnectionInterface,
                               NetworkManagerVPNPluginInterface,
                               NetworkManagerWifiP2PPeerInterface)
from .objects import (AccessPoint, ActiveConnection, ActiveVPNConnection,
                      ConfigCheckpoint, DHCPv4Config, DHCPv6Config, IPv4Config,
                      IPv6Config, NetworkConnectionSettings,
                      NetworkDeviceBluetooth, NetworkDeviceBond,
                      NetworkDeviceBridge, NetworkDeviceGeneric,
                      NetworkDeviceIpTunnel, NetworkDeviceMacsec,
                      NetworkDeviceMacvlan, NetworkDeviceModem,
                      NetworkDeviceOlpcMesh, NetworkDeviceOpenVSwitchBridge,
                      NetworkDeviceOpenVSwitchPort, NetworkDevicePPP,
                      NetworkDeviceTeam, NetworkDeviceTun, NetworkDeviceVeth,
                      NetworkDeviceVlan, NetworkDeviceVrf, NetworkDeviceVxlan,
                      NetworkDeviceWifiP2P, NetworkDeviceWired,
                      NetworkDeviceWireGuard, NetworkDeviceWireless,
                      NetworkManager, NetworkManagerAgentManager,
                      NetworkManagerDnsManager, NetworkManagerSettings,
                      WiFiP2PPeer)


DEVICE_TYPE_TO_CLASS = {
    DeviceType.ETHERNET: NetworkDeviceWired,
    DeviceType.WIFI: NetworkDeviceWireless,
    DeviceType.BLUETOOTH: NetworkDeviceBluetooth,
    DeviceType.OLPC_MESH: NetworkDeviceOlpcMesh,
    DeviceType.VETH: NetworkDeviceVeth,
    DeviceType.WIREGUARD: NetworkDeviceWireGuard,
    DeviceType.PPP: NetworkDevicePPP,
    DeviceType.BRIDGE: NetworkDeviceBridge,
    DeviceType.MODEM: NetworkDeviceModem,
}


__all__ = (
    'AccessPointCapabilities', 'BluetoothCapabilities',
    'ConnectionFlags', 'ConnectionState', 'ConnectionStateFlags',
    'ConnectionStateReason', 'ConnectivityState',
    'DeviceCapabilities', 'DeviceInterfaceFlags', 'DeviceMetered',
    'DeviceState', 'DeviceStateReason', 'DeviceType', 'IpTunnelMode',
    'ModemCapabilities', 'NetworkManagerConnectivityState',
    'NetworkManagerState', 'SecretAgentCapabilities', 'VpnFailure',
    'VpnState', 'WiFiOperationMode', 'WirelessCapabilities',
    'WpaSecurityFlags',

    'NetworkManagerDeviceBluetoothInterface',
    'NetworkManagerDeviceBondInterface',
    'NetworkManagerDeviceBridgeInterface',
    'NetworkManagerDeviceGenericInterface',
    'NetworkManagerDeviceInterface',
    'NetworkManagerDeviceIPTunnelInterface',
    'NetworkManagerDeviceLowpanInterface',
    'NetworkManagerDeviceMacsecInterface',
    'NetworkManagerDeviceMacvlanInterface',
    'NetworkManagerDeviceModemInterface',
    'NetworkManagerDeviceOlpcMeshInterface',
    'NetworkManagerDeviceOvsBridgeInterface',
    'NetworkManagerDeviceOvsPortInterface',
    'NetworkManagerDeviceStatisticsInterface',
    'NetworkManagerDeviceTeamInterface',
    'NetworkManagerDeviceTunInterface',
    'NetworkManagerDeviceVethInterface',
    'NetworkManagerDeviceVlanInterface',
    'NetworkManagerDeviceVrfInterface',
    'NetworkManagerDeviceVxlanInterface',
    'NetworkManagerDeviceWifiP2PInterface',
    'NetworkManagerDeviceWiredInterface',
    'NetworkManagerDeviceWireGuardInterface',
    'NetworkManagerDeviceWirelessInterface',
    'NetworkManagerPPPInterface',

    'NetworkManagerAccessPointInterface',
    'NetworkManagerSecretAgentManagerInterface',
    'NetworkManagerCheckpointInterface',
    'NetworkManagerConnectionActiveInterface',
    'NetworkManagerVPNConnectionInterface',
    'NetworkManagerDHCP4ConfigInterface',
    'NetworkManagerDHCP6ConfigInterface',
    'NetworkManagerDnsManagerInterface',
    'NetworkManagerIP4ConfigInterface',
    'NetworkManagerIP6ConfigInterface',
    'NetworkManagerSecretAgentInterface',
    'NetworkManagerSettingsConnectionInterface',
    'NetworkManagerSettingsInterface',
    'NetworkManagerVPNPluginInterface',
    'NetworkManagerWifiP2PPeerInterface',
    'NetworkManagerInterface',

    'NetworkManager',
    'NetworkManagerAgentManager',
    'NetworkManagerDnsManager',
    'NetworkManagerSettings',
    'NetworkConnectionSettings',
    'NetworkDeviceGeneric',
    'NetworkDeviceWired',
    'NetworkDeviceWireless',
    'NetworkDeviceBluetooth',
    'NetworkDeviceBond',
    'NetworkDeviceBridge',
    'NetworkDeviceIpTunnel',
    'NetworkDeviceMacsec',
    'NetworkDeviceMacvlan',
    'NetworkDeviceModem',
    'NetworkDeviceOlpcMesh',
    'NetworkDeviceOpenVSwitchBridge',
    'NetworkDeviceOpenVSwitchPort',
    'NetworkDeviceTeam',
    'NetworkDeviceTun',
    'NetworkDeviceVeth',
    'NetworkDeviceVlan',
    'NetworkDeviceVrf',
    'NetworkDeviceVxlan',
    'NetworkDeviceWifiP2P',
    'NetworkDeviceWireGuard',
    'NetworkDevicePPP',
    'ActiveConnection',
    'ActiveVPNConnection',
    'IPv4Config',
    'IPv6Config',
    'DHCPv4Config',
    'DHCPv6Config',
    'AccessPoint',
    'WiFiP2PPeer',
    'ConfigCheckpoint',

    'DEVICE_TYPE_TO_CLASS',
)
