"""Notebooks Mutation."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

from typing import TYPE_CHECKING, Any, List, Dict, Optional, Tuple, Union

from taegis_sdk_python.utils import build_output_string, prepare_input
from taegis_sdk_python.services.notebooks.types import *

from taegis_sdk_python import GraphQLNoRowsInResultSetError

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.notebooks import NotebooksService


class TaegisSDKNotebooksMutation:
    """Teagis Notebooks Mutation operations."""

    def __init__(self, service: NotebooksService):
        self.service = service

    def create_notebook(self) -> Notebook:
        """creates a new notebook instance and associated components."""
        endpoint = "createNotebook"

        result = self.service.execute_mutation(
            endpoint=endpoint, variables={}, output=build_output_string(Notebook)
        )
        if result.get(endpoint) is not None:
            return Notebook.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createNotebook")

    def start_notebook(self) -> Notebook:
        """starts the current user's notebook instance."""
        endpoint = "startNotebook"

        result = self.service.execute_mutation(
            endpoint=endpoint, variables={}, output=build_output_string(Notebook)
        )
        if result.get(endpoint) is not None:
            return Notebook.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation startNotebook")

    def shutdown_notebook(self) -> Notebook:
        """stops the current user's notebook instance."""
        endpoint = "shutdownNotebook"

        result = self.service.execute_mutation(
            endpoint=endpoint, variables={}, output=build_output_string(Notebook)
        )
        if result.get(endpoint) is not None:
            return Notebook.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation shutdownNotebook")
