"""Comments Query."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

from typing import TYPE_CHECKING, Any, List, Dict, Optional, Tuple, Union

from taegis_sdk_python.utils import build_output_string, prepare_input
from taegis_sdk_python.services.comments.types import *

from taegis_sdk_python import GraphQLNoRowsInResultSetError

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.comments import CommentsService


class TaegisSDKCommentsQuery:
    """Teagis Comments Query operations."""

    def __init__(self, service: CommentsService):
        self.service = service

    def comment(self, comment_id: str) -> Comment:
        """None."""
        endpoint = "comment"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "comment_id": prepare_input(comment_id),
            },
            output=build_output_string(Comment),
        )
        if result.get(endpoint) is not None:
            return Comment.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query comment")

    def comments_by_parent(self, parent_type: str, parent_id: str) -> List[Comment]:
        """None."""
        endpoint = "commentsByParent"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "parent_type": prepare_input(parent_type),
                "parent_id": prepare_input(parent_id),
            },
            output=build_output_string(Comment),
        )
        if result.get(endpoint) is not None:
            return Comment.schema().load(result.get(endpoint), many=True)
        raise GraphQLNoRowsInResultSetError("for query commentsByParent")

    def comments_by_parent_section(
        self, parent_type: str, parent_id: str, section_type: str, section_id: str
    ) -> List[Comment]:
        """None."""
        endpoint = "commentsByParentSection"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "parent_type": prepare_input(parent_type),
                "parent_id": prepare_input(parent_id),
                "section_type": prepare_input(section_type),
                "section_id": prepare_input(section_id),
            },
            output=build_output_string(Comment),
        )
        if result.get(endpoint) is not None:
            return Comment.schema().load(result.get(endpoint), many=True)
        raise GraphQLNoRowsInResultSetError("for query commentsByParentSection")

    def comments_count_by_parent(self, parent_type: str, parent_id: str) -> ParentCount:
        """None."""
        endpoint = "commentsCountByParent"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "parent_type": prepare_input(parent_type),
                "parent_id": prepare_input(parent_id),
            },
            output=build_output_string(ParentCount),
        )
        if result.get(endpoint) is not None:
            return ParentCount.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query commentsCountByParent")

    def comments_count_by_parent_type(self, parent_type: str) -> List[ParentCount]:
        """None."""
        endpoint = "commentsCountByParentType"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "parent_type": prepare_input(parent_type),
            },
            output=build_output_string(ParentCount),
        )
        if result.get(endpoint) is not None:
            return ParentCount.schema().load(result.get(endpoint), many=True)
        raise GraphQLNoRowsInResultSetError("for query commentsCountByParentType")

    def unread_comments_by_parents(self, parents: List[Parent]) -> List[Comment]:
        """None."""
        endpoint = "unreadCommentsByParents"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "parents": prepare_input(parents),
            },
            output=build_output_string(Comment),
        )
        if result.get(endpoint) is not None:
            return Comment.schema().load(result.get(endpoint), many=True)
        raise GraphQLNoRowsInResultSetError("for query unreadCommentsByParents")

    def latest_bulk_comments_by_parent(
        self, parent_type: str, parent_ids: List[str]
    ) -> List[LatestComment]:
        """None."""
        endpoint = "latestBulkCommentsByParent"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "parent_type": prepare_input(parent_type),
                "parent_ids": prepare_input(parent_ids),
            },
            output=build_output_string(LatestComment),
        )
        if result.get(endpoint) is not None:
            return LatestComment.schema().load(result.get(endpoint), many=True)
        raise GraphQLNoRowsInResultSetError("for query latestBulkCommentsByParent")

    def comments_count_by_parent_ids(
        self, parent_type: str, parent_ids: List[str]
    ) -> List[ParentCount]:
        """None."""
        endpoint = "commentsCountByParentIds"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "parent_type": prepare_input(parent_type),
                "parent_ids": prepare_input(parent_ids),
            },
            output=build_output_string(ParentCount),
        )
        if result.get(endpoint) is not None:
            return ParentCount.schema().load(result.get(endpoint), many=True)
        raise GraphQLNoRowsInResultSetError("for query commentsCountByParentIds")
