# Safe-DS Python Library

[![PyPI](https://img.shields.io/pypi/v/safe-ds)](https://pypi.org/project/safe-ds)
[![Main](https://github.com/Safe-DS/Stdlib/actions/workflows/main.yml/badge.svg)](https://github.com/Safe-DS/Stdlib/actions/workflows/main.yml)
[![codecov](https://codecov.io/gh/Safe-DS/Stdlib/branch/main/graph/badge.svg?token=HVRP1633B1)](https://codecov.io/gh/Safe-DS/Stdlib)
[![Documentation Status](https://readthedocs.org/projects/safe-ds-stdlib/badge/?version=stable)](https://stdlib.safe-ds.com)

A user-friendly library for Data Science (DS) in Python.

Our goal is to make DS more accessible to a wider audience by providing a simple, intuitive, and consistent API to solve common tasks on small to moderately sized datasets. As such, a major focus is to provide a learning tool for DS novices.

Instead of implementing DS methods from scratch, we use established DS libraries under the hood such as:

* [pandas](https://pandas.pydata.org) for data manipulation,
* [scikit-learn](https://scikit-learn.org) for machine learning, and
* [seaborn](https://seaborn.pydata.org) for visualization.

 For more specialized tasks, we recommend using these or other DS libraries directly.

Note that this library is still in development and not yet ready for production. Expect breaking changes in the future without a major version bump (while in the `0.x.y` version range). Feedback is very welcome! If you have a suggestion or find a bug, please [open an issue](https://github.com/Safe-DS/Stdlib/issues/new/choose). If you have a question, please [use our discussion forum](https://github.com/orgs/Safe-DS/discussions).

## Documentation

You can find the full documentation [here](https://stdlib.safe-ds.com).

## Installation

Get the latest version from [PyPI](https://pypi.org/project/safe-ds):

```shell
pip install safe-ds
```
