# This file contains sets of entities categorized by their type.
# Entity types include the following:
# - articles: 1 entities
# - authors: 50 entities
# - names: 3727 entities
# - ordinals: 50 entities
# - articles: 55025 entities
# - subjects: 2339 entities
# - iri: 60932 entities

# Existential nodes to represent articles (_article).
article_node = {
    '_article',
}

# List of author positions - these are existential nodes.
authors = {
    '_authorpos000',
    '_authorpos001',
    '_authorpos002',
    '_authorpos003',
    '_authorpos004',
    '_authorpos005',
    '_authorpos006',
    '_authorpos007',
    '_authorpos008',
    '_authorpos009',
    '_authorpos010',
    '_authorpos011',
    '_authorpos012',
    '_authorpos013',
    '_authorpos014',
    '_authorpos015',
    '_authorpos016',
    '_authorpos017',
    '_authorpos018',
    '_authorpos019',
    '_authorpos020',
    '_authorpos021',
    '_authorpos022',
    '_authorpos023',
    '_authorpos024',
    '_authorpos025',
    '_authorpos026',
    '_authorpos027',
    '_authorpos028',
    '_authorpos029',
    '_authorpos030',
    '_authorpos031',
    '_authorpos032',
    '_authorpos033',
    '_authorpos034',
    '_authorpos035',
    '_authorpos036',
    '_authorpos037',
    '_authorpos038',
    '_authorpos039',
    '_authorpos040',
    '_authorpos041',
    '_authorpos042',
    '_authorpos043',
    '_authorpos044',
    '_authorpos045',
    '_authorpos046',
    '_authorpos047',
    '_authorpos048',
    '_authorpos049',
}

# List of existential nodes to represent names or, it the names are commonly occurring in the dataset, then their IRI's.
names = {
    '_author000',
    '_author001',
    '_author002',
    '_author003',
    '_author004',
    '_author005',
    '_author006',
    '_author007',
    '_author008',
    '_author009',
    '_author010',
    '_author011',
    '_author012',
    '_author013',
    '_author014',
    '_author015',
    '_author016',
    '_author017',
    '_author018',
    '_author019',
    '_author020',
    '_author021',
    '_author022',
    '_author023',
    '_author024',
    '_author025',
    '_author026',
    '_author027',
    '_author028',
    '_author029',
    '_author030',
    '_author031',
    '_author032',
    '_author033',
    '_author034',
    '_author035',
    '_author036',
    '_author037',
    '_author038',
    '_author039',
    '_author040',
    '_author041',
    '_author042',
    '_author043',
    '_author044',
    '_author045',
    '_author046',
    '_author047',
    '_author048',
    '_author049',
    'http://www.wikidata.org/entity/Q100301637',
    'http://www.wikidata.org/entity/Q100559638',
    'http://www.wikidata.org/entity/Q100804242',
    'http://www.wikidata.org/entity/Q101474031',
    'http://www.wikidata.org/entity/Q101823445',
    'http://www.wikidata.org/entity/Q103203078',
    'http://www.wikidata.org/entity/Q104111313',
    'http://www.wikidata.org/entity/Q10414373',
    'http://www.wikidata.org/entity/Q104694114',
    'http://www.wikidata.org/entity/Q104696538',
    'http://www.wikidata.org/entity/Q104743728',
    'http://www.wikidata.org/entity/Q104771102',
    'http://www.wikidata.org/entity/Q104932039',
    'http://www.wikidata.org/entity/Q104932176',
    'http://www.wikidata.org/entity/Q104975407',
    'http://www.wikidata.org/entity/Q105452530',
    'http://www.wikidata.org/entity/Q105531697',
    'http://www.wikidata.org/entity/Q105627683',
    'http://www.wikidata.org/entity/Q105659907',
    'http://www.wikidata.org/entity/Q107652',
    'http://www.wikidata.org/entity/Q1079331',
    'http://www.wikidata.org/entity/Q1084355',
    'http://www.wikidata.org/entity/Q109599',
    'http://www.wikidata.org/entity/Q1097806',
    'http://www.wikidata.org/entity/Q1108510',
    'http://www.wikidata.org/entity/Q110957',
    'http://www.wikidata.org/entity/Q11256815',
    'http://www.wikidata.org/entity/Q1133904',
    'http://www.wikidata.org/entity/Q11473927',
    'http://www.wikidata.org/entity/Q11500329',
    'http://www.wikidata.org/entity/Q117008',
    'http://www.wikidata.org/entity/Q11718746',
    'http://www.wikidata.org/entity/Q11720088',
    'http://www.wikidata.org/entity/Q117256',
    'http://www.wikidata.org/entity/Q1173787',
    'http://www.wikidata.org/entity/Q1174606',
    'http://www.wikidata.org/entity/Q11765283',
    'http://www.wikidata.org/entity/Q11851325',
    'http://www.wikidata.org/entity/Q11867366',
    'http://www.wikidata.org/entity/Q11868705',
    'http://www.wikidata.org/entity/Q11893052',
    'http://www.wikidata.org/entity/Q11893731',
    'http://www.wikidata.org/entity/Q11966779',
    'http://www.wikidata.org/entity/Q11974765',
    'http://www.wikidata.org/entity/Q11995248',
    'http://www.wikidata.org/entity/Q11998625',
    'http://www.wikidata.org/entity/Q1201308',
    'http://www.wikidata.org/entity/Q121382',
    'http://www.wikidata.org/entity/Q12302131',
    'http://www.wikidata.org/entity/Q12303219',
    'http://www.wikidata.org/entity/Q12328808',
    'http://www.wikidata.org/entity/Q12331359',
    'http://www.wikidata.org/entity/Q12403332',
    'http://www.wikidata.org/entity/Q1248240',
    'http://www.wikidata.org/entity/Q124962',
    'http://www.wikidata.org/entity/Q1269496',
    'http://www.wikidata.org/entity/Q126992',
    'http://www.wikidata.org/entity/Q13135289',
    'http://www.wikidata.org/entity/Q1322769',
    'http://www.wikidata.org/entity/Q13578863',
    'http://www.wikidata.org/entity/Q1364917',
    'http://www.wikidata.org/entity/Q1394415',
    'http://www.wikidata.org/entity/Q1398103',
    'http://www.wikidata.org/entity/Q1424562',
    'http://www.wikidata.org/entity/Q1457071',
    'http://www.wikidata.org/entity/Q1471193',
    'http://www.wikidata.org/entity/Q15055172',
    'http://www.wikidata.org/entity/Q15067176',
    'http://www.wikidata.org/entity/Q1511131',
    'http://www.wikidata.org/entity/Q1515807',
    'http://www.wikidata.org/entity/Q1517116',
    'http://www.wikidata.org/entity/Q15429212',
    'http://www.wikidata.org/entity/Q15431947',
    'http://www.wikidata.org/entity/Q15439895',
    'http://www.wikidata.org/entity/Q15440263',
    'http://www.wikidata.org/entity/Q1545025',
    'http://www.wikidata.org/entity/Q15453363',
    'http://www.wikidata.org/entity/Q1547900',
    'http://www.wikidata.org/entity/Q15488818',
    'http://www.wikidata.org/entity/Q155380',
    'http://www.wikidata.org/entity/Q1564831',
    'http://www.wikidata.org/entity/Q1567536',
    'http://www.wikidata.org/entity/Q1575859',
    'http://www.wikidata.org/entity/Q1576857',
    'http://www.wikidata.org/entity/Q1577771',
    'http://www.wikidata.org/entity/Q15783199',
    'http://www.wikidata.org/entity/Q1581017',
    'http://www.wikidata.org/entity/Q15845100',
    'http://www.wikidata.org/entity/Q15855147',
    'http://www.wikidata.org/entity/Q1591992',
    'http://www.wikidata.org/entity/Q15967402',
    'http://www.wikidata.org/entity/Q15968782',
    'http://www.wikidata.org/entity/Q15989781',
    'http://www.wikidata.org/entity/Q15994492',
    'http://www.wikidata.org/entity/Q15994497',
    'http://www.wikidata.org/entity/Q15994704',
    'http://www.wikidata.org/entity/Q15995540',
    'http://www.wikidata.org/entity/Q15995569',
    'http://www.wikidata.org/entity/Q1602385',
    'http://www.wikidata.org/entity/Q16027697',
    'http://www.wikidata.org/entity/Q16075097',
    'http://www.wikidata.org/entity/Q16106681',
    'http://www.wikidata.org/entity/Q16150048',
    'http://www.wikidata.org/entity/Q16187183',
    'http://www.wikidata.org/entity/Q16187422',
    'http://www.wikidata.org/entity/Q16196411',
    'http://www.wikidata.org/entity/Q16199016',
    'http://www.wikidata.org/entity/Q16204130',
    'http://www.wikidata.org/entity/Q16213661',
    'http://www.wikidata.org/entity/Q16214224',
    'http://www.wikidata.org/entity/Q16221560',
    'http://www.wikidata.org/entity/Q1622212',
    'http://www.wikidata.org/entity/Q16260071',
    'http://www.wikidata.org/entity/Q16301016',
    'http://www.wikidata.org/entity/Q1631578',
    'http://www.wikidata.org/entity/Q16335202',
    'http://www.wikidata.org/entity/Q1646045',
    'http://www.wikidata.org/entity/Q16499850',
    'http://www.wikidata.org/entity/Q1655646',
    'http://www.wikidata.org/entity/Q16560862',
    'http://www.wikidata.org/entity/Q16561003',
    'http://www.wikidata.org/entity/Q16729973',
    'http://www.wikidata.org/entity/Q16731445',
    'http://www.wikidata.org/entity/Q16732954',
    'http://www.wikidata.org/entity/Q16733099',
    'http://www.wikidata.org/entity/Q16733372',
    'http://www.wikidata.org/entity/Q16770280',
    'http://www.wikidata.org/entity/Q16773696',
    'http://www.wikidata.org/entity/Q16873337',
    'http://www.wikidata.org/entity/Q16898627',
    'http://www.wikidata.org/entity/Q16940884',
    'http://www.wikidata.org/entity/Q16980703',
    'http://www.wikidata.org/entity/Q16991196',
    'http://www.wikidata.org/entity/Q16991428',
    'http://www.wikidata.org/entity/Q170342',
    'http://www.wikidata.org/entity/Q17059251',
    'http://www.wikidata.org/entity/Q17068400',
    'http://www.wikidata.org/entity/Q1707155',
    'http://www.wikidata.org/entity/Q17109045',
    'http://www.wikidata.org/entity/Q1711972',
    'http://www.wikidata.org/entity/Q1712378',
    'http://www.wikidata.org/entity/Q17126504',
    'http://www.wikidata.org/entity/Q17146579',
    'http://www.wikidata.org/entity/Q172151',
    'http://www.wikidata.org/entity/Q17305867',
    'http://www.wikidata.org/entity/Q17308889',
    'http://www.wikidata.org/entity/Q17318939',
    'http://www.wikidata.org/entity/Q17322542',
    'http://www.wikidata.org/entity/Q1740773',
    'http://www.wikidata.org/entity/Q17489039',
    'http://www.wikidata.org/entity/Q17507299',
    'http://www.wikidata.org/entity/Q17579989',
    'http://www.wikidata.org/entity/Q17612495',
    'http://www.wikidata.org/entity/Q17626836',
    'http://www.wikidata.org/entity/Q1788006',
    'http://www.wikidata.org/entity/Q1790491',
    'http://www.wikidata.org/entity/Q1795041',
    'http://www.wikidata.org/entity/Q1795145',
    'http://www.wikidata.org/entity/Q1795407',
    'http://www.wikidata.org/entity/Q18022197',
    'http://www.wikidata.org/entity/Q18044124',
    'http://www.wikidata.org/entity/Q18062123',
    'http://www.wikidata.org/entity/Q18097511',
    'http://www.wikidata.org/entity/Q18161438',
    'http://www.wikidata.org/entity/Q18167158',
    'http://www.wikidata.org/entity/Q18195722',
    'http://www.wikidata.org/entity/Q18246437',
    'http://www.wikidata.org/entity/Q18387155',
    'http://www.wikidata.org/entity/Q18387924',
    'http://www.wikidata.org/entity/Q18393023',
    'http://www.wikidata.org/entity/Q18521479',
    'http://www.wikidata.org/entity/Q18546138',
    'http://www.wikidata.org/entity/Q18603730',
    'http://www.wikidata.org/entity/Q18626787',
    'http://www.wikidata.org/entity/Q18631415',
    'http://www.wikidata.org/entity/Q18631493',
    'http://www.wikidata.org/entity/Q18701325',
    'http://www.wikidata.org/entity/Q18749055',
    'http://www.wikidata.org/entity/Q18749082',
    'http://www.wikidata.org/entity/Q18763976',
    'http://www.wikidata.org/entity/Q1883780',
    'http://www.wikidata.org/entity/Q1890061',
    'http://www.wikidata.org/entity/Q19276825',
    'http://www.wikidata.org/entity/Q19281782',
    'http://www.wikidata.org/entity/Q19283882',
    'http://www.wikidata.org/entity/Q1928530',
    'http://www.wikidata.org/entity/Q1929839',
    'http://www.wikidata.org/entity/Q19365412',
    'http://www.wikidata.org/entity/Q19397499',
    'http://www.wikidata.org/entity/Q194539',
    'http://www.wikidata.org/entity/Q19501099',
    'http://www.wikidata.org/entity/Q19508945',
    'http://www.wikidata.org/entity/Q19518807',
    'http://www.wikidata.org/entity/Q19561490',
    'http://www.wikidata.org/entity/Q19609689',
    'http://www.wikidata.org/entity/Q19629397',
    'http://www.wikidata.org/entity/Q19631268',
    'http://www.wikidata.org/entity/Q19637038',
    'http://www.wikidata.org/entity/Q19665429',
    'http://www.wikidata.org/entity/Q19667788',
    'http://www.wikidata.org/entity/Q19668152',
    'http://www.wikidata.org/entity/Q19668192',
    'http://www.wikidata.org/entity/Q19766132',
    'http://www.wikidata.org/entity/Q19766141',
    'http://www.wikidata.org/entity/Q1982431',
    'http://www.wikidata.org/entity/Q19845641',
    'http://www.wikidata.org/entity/Q19857262',
    'http://www.wikidata.org/entity/Q19859634',
    'http://www.wikidata.org/entity/Q19973479',
    'http://www.wikidata.org/entity/Q19996372',
    'http://www.wikidata.org/entity/Q2000017',
    'http://www.wikidata.org/entity/Q20028848',
    'http://www.wikidata.org/entity/Q20054092',
    'http://www.wikidata.org/entity/Q20089576',
    'http://www.wikidata.org/entity/Q20090640',
    'http://www.wikidata.org/entity/Q20100355',
    'http://www.wikidata.org/entity/Q20127995',
    'http://www.wikidata.org/entity/Q20172819',
    'http://www.wikidata.org/entity/Q20196322',
    'http://www.wikidata.org/entity/Q20203713',
    'http://www.wikidata.org/entity/Q20242799',
    'http://www.wikidata.org/entity/Q20502360',
    'http://www.wikidata.org/entity/Q20513630',
    'http://www.wikidata.org/entity/Q20518451',
    'http://www.wikidata.org/entity/Q20638823',
    'http://www.wikidata.org/entity/Q20657126',
    'http://www.wikidata.org/entity/Q20664754',
    'http://www.wikidata.org/entity/Q20675564',
    'http://www.wikidata.org/entity/Q20732365',
    'http://www.wikidata.org/entity/Q20738697',
    'http://www.wikidata.org/entity/Q20740762',
    'http://www.wikidata.org/entity/Q20740896',
    'http://www.wikidata.org/entity/Q20742688',
    'http://www.wikidata.org/entity/Q20742720',
    'http://www.wikidata.org/entity/Q2074300',
    'http://www.wikidata.org/entity/Q2074784',
    'http://www.wikidata.org/entity/Q20752664',
    'http://www.wikidata.org/entity/Q2075967',
    'http://www.wikidata.org/entity/Q2077335',
    'http://www.wikidata.org/entity/Q2078286',
    'http://www.wikidata.org/entity/Q20807130',
    'http://www.wikidata.org/entity/Q20855537',
    'http://www.wikidata.org/entity/Q20894526',
    'http://www.wikidata.org/entity/Q20984698',
    'http://www.wikidata.org/entity/Q20986533',
    'http://www.wikidata.org/entity/Q21003878',
    'http://www.wikidata.org/entity/Q21005299',
    'http://www.wikidata.org/entity/Q21062265',
    'http://www.wikidata.org/entity/Q21062285',
    'http://www.wikidata.org/entity/Q21062359',
    'http://www.wikidata.org/entity/Q21062532',
    'http://www.wikidata.org/entity/Q21062625',
    'http://www.wikidata.org/entity/Q21063471',
    'http://www.wikidata.org/entity/Q21063634',
    'http://www.wikidata.org/entity/Q21064602',
    'http://www.wikidata.org/entity/Q21066148',
    'http://www.wikidata.org/entity/Q21094780',
    'http://www.wikidata.org/entity/Q21094872',
    'http://www.wikidata.org/entity/Q21094931',
    'http://www.wikidata.org/entity/Q21094933',
    'http://www.wikidata.org/entity/Q21094958',
    'http://www.wikidata.org/entity/Q21104125',
    'http://www.wikidata.org/entity/Q21114976',
    'http://www.wikidata.org/entity/Q21127249',
    'http://www.wikidata.org/entity/Q21165015',
    'http://www.wikidata.org/entity/Q21165208',
    'http://www.wikidata.org/entity/Q21165363',
    'http://www.wikidata.org/entity/Q21165677',
    'http://www.wikidata.org/entity/Q21165834',
    'http://www.wikidata.org/entity/Q21165903',
    'http://www.wikidata.org/entity/Q21166753',
    'http://www.wikidata.org/entity/Q21166848',
    'http://www.wikidata.org/entity/Q21168777',
    'http://www.wikidata.org/entity/Q21254312',
    'http://www.wikidata.org/entity/Q21256003',
    'http://www.wikidata.org/entity/Q21258788',
    'http://www.wikidata.org/entity/Q21259942',
    'http://www.wikidata.org/entity/Q21261200',
    'http://www.wikidata.org/entity/Q21263002',
    'http://www.wikidata.org/entity/Q21263057',
    'http://www.wikidata.org/entity/Q21264355',
    'http://www.wikidata.org/entity/Q21264467',
    'http://www.wikidata.org/entity/Q21264497',
    'http://www.wikidata.org/entity/Q21264632',
    'http://www.wikidata.org/entity/Q21264686',
    'http://www.wikidata.org/entity/Q21264733',
    'http://www.wikidata.org/entity/Q21337902',
    'http://www.wikidata.org/entity/Q21337916',
    'http://www.wikidata.org/entity/Q21337923',
    'http://www.wikidata.org/entity/Q21339744',
    'http://www.wikidata.org/entity/Q21390503',
    'http://www.wikidata.org/entity/Q21394434',
    'http://www.wikidata.org/entity/Q21394718',
    'http://www.wikidata.org/entity/Q21401975',
    'http://www.wikidata.org/entity/Q21448010',
    'http://www.wikidata.org/entity/Q21469470',
    'http://www.wikidata.org/entity/Q21531361',
    'http://www.wikidata.org/entity/Q2154243',
    'http://www.wikidata.org/entity/Q21559103',
    'http://www.wikidata.org/entity/Q2159171',
    'http://www.wikidata.org/entity/Q21594962',
    'http://www.wikidata.org/entity/Q21598164',
    'http://www.wikidata.org/entity/Q21699620',
    'http://www.wikidata.org/entity/Q21712261',
    'http://www.wikidata.org/entity/Q2174164',
    'http://www.wikidata.org/entity/Q2183197',
    'http://www.wikidata.org/entity/Q21979916',
    'http://www.wikidata.org/entity/Q21995591',
    'http://www.wikidata.org/entity/Q22006776',
    'http://www.wikidata.org/entity/Q22006961',
    'http://www.wikidata.org/entity/Q22069468',
    'http://www.wikidata.org/entity/Q22089123',
    'http://www.wikidata.org/entity/Q22095342',
    'http://www.wikidata.org/entity/Q22096751',
    'http://www.wikidata.org/entity/Q22114836',
    'http://www.wikidata.org/entity/Q2214357',
    'http://www.wikidata.org/entity/Q2214381',
    'http://www.wikidata.org/entity/Q22227944',
    'http://www.wikidata.org/entity/Q22277627',
    'http://www.wikidata.org/entity/Q22278197',
    'http://www.wikidata.org/entity/Q22279398',
    'http://www.wikidata.org/entity/Q22280357',
    'http://www.wikidata.org/entity/Q2247235',
    'http://www.wikidata.org/entity/Q22583669',
    'http://www.wikidata.org/entity/Q22669757',
    'http://www.wikidata.org/entity/Q22670611',
    'http://www.wikidata.org/entity/Q2279629',
    'http://www.wikidata.org/entity/Q2283474',
    'http://www.wikidata.org/entity/Q22959312',
    'http://www.wikidata.org/entity/Q23020582',
    'http://www.wikidata.org/entity/Q23039738',
    'http://www.wikidata.org/entity/Q23039804',
    'http://www.wikidata.org/entity/Q23039996',
    'http://www.wikidata.org/entity/Q23040024',
    'http://www.wikidata.org/entity/Q23135514',
    'http://www.wikidata.org/entity/Q23303113',
    'http://www.wikidata.org/entity/Q233205',
    'http://www.wikidata.org/entity/Q2336447',
    'http://www.wikidata.org/entity/Q2336668',
    'http://www.wikidata.org/entity/Q2343304',
    'http://www.wikidata.org/entity/Q2346715',
    'http://www.wikidata.org/entity/Q2348034',
    'http://www.wikidata.org/entity/Q23564829',
    'http://www.wikidata.org/entity/Q23638664',
    'http://www.wikidata.org/entity/Q23670497',
    'http://www.wikidata.org/entity/Q23678502',
    'http://www.wikidata.org/entity/Q2373320',
    'http://www.wikidata.org/entity/Q23770361',
    'http://www.wikidata.org/entity/Q23771643',
    'http://www.wikidata.org/entity/Q23883396',
    'http://www.wikidata.org/entity/Q23890446',
    'http://www.wikidata.org/entity/Q23910833',
    'http://www.wikidata.org/entity/Q23950132',
    'http://www.wikidata.org/entity/Q24039464',
    'http://www.wikidata.org/entity/Q2405291',
    'http://www.wikidata.org/entity/Q2405380',
    'http://www.wikidata.org/entity/Q24084302',
    'http://www.wikidata.org/entity/Q24209151',
    'http://www.wikidata.org/entity/Q2422875',
    'http://www.wikidata.org/entity/Q2423758',
    'http://www.wikidata.org/entity/Q24239756',
    'http://www.wikidata.org/entity/Q24255834',
    'http://www.wikidata.org/entity/Q24265625',
    'http://www.wikidata.org/entity/Q2440397',
    'http://www.wikidata.org/entity/Q24517868',
    'http://www.wikidata.org/entity/Q24580798',
    'http://www.wikidata.org/entity/Q246731',
    'http://www.wikidata.org/entity/Q24700004',
    'http://www.wikidata.org/entity/Q24727761',
    'http://www.wikidata.org/entity/Q24727787',
    'http://www.wikidata.org/entity/Q24747188',
    'http://www.wikidata.org/entity/Q24804686',
    'http://www.wikidata.org/entity/Q24805306',
    'http://www.wikidata.org/entity/Q24846806',
    'http://www.wikidata.org/entity/Q24924339',
    'http://www.wikidata.org/entity/Q25005765',
    'http://www.wikidata.org/entity/Q25115246',
    'http://www.wikidata.org/entity/Q25174983',
    'http://www.wikidata.org/entity/Q25189761',
    'http://www.wikidata.org/entity/Q25272201',
    'http://www.wikidata.org/entity/Q25336883',
    'http://www.wikidata.org/entity/Q2543973',
    'http://www.wikidata.org/entity/Q25506911',
    'http://www.wikidata.org/entity/Q2562602',
    'http://www.wikidata.org/entity/Q25712856',
    'http://www.wikidata.org/entity/Q25820644',
    'http://www.wikidata.org/entity/Q25894609',
    'http://www.wikidata.org/entity/Q25912123',
    'http://www.wikidata.org/entity/Q25935337',
    'http://www.wikidata.org/entity/Q25999450',
    'http://www.wikidata.org/entity/Q26000238',
    'http://www.wikidata.org/entity/Q2600921',
    'http://www.wikidata.org/entity/Q2600945',
    'http://www.wikidata.org/entity/Q26234925',
    'http://www.wikidata.org/entity/Q26265142',
    'http://www.wikidata.org/entity/Q26321',
    'http://www.wikidata.org/entity/Q26464741',
    'http://www.wikidata.org/entity/Q26689960',
    'http://www.wikidata.org/entity/Q26704483',
    'http://www.wikidata.org/entity/Q26706202',
    'http://www.wikidata.org/entity/Q26737169',
    'http://www.wikidata.org/entity/Q26856925',
    'http://www.wikidata.org/entity/Q26883279',
    'http://www.wikidata.org/entity/Q26883886',
    'http://www.wikidata.org/entity/Q26923514',
    'http://www.wikidata.org/entity/Q27075107',
    'http://www.wikidata.org/entity/Q27214742',
    'http://www.wikidata.org/entity/Q27254551',
    'http://www.wikidata.org/entity/Q27457147',
    'http://www.wikidata.org/entity/Q27653754',
    'http://www.wikidata.org/entity/Q27662300',
    'http://www.wikidata.org/entity/Q27662321',
    'http://www.wikidata.org/entity/Q27663335',
    'http://www.wikidata.org/entity/Q27664356',
    'http://www.wikidata.org/entity/Q27704551',
    'http://www.wikidata.org/entity/Q27734333',
    'http://www.wikidata.org/entity/Q27887604',
    'http://www.wikidata.org/entity/Q27908223',
    'http://www.wikidata.org/entity/Q27990117',
    'http://www.wikidata.org/entity/Q28007338',
    'http://www.wikidata.org/entity/Q28028607',
    'http://www.wikidata.org/entity/Q28028610',
    'http://www.wikidata.org/entity/Q28028611',
    'http://www.wikidata.org/entity/Q28028698',
    'http://www.wikidata.org/entity/Q28033645',
    'http://www.wikidata.org/entity/Q28033668',
    'http://www.wikidata.org/entity/Q28036061',
    'http://www.wikidata.org/entity/Q28036295',
    'http://www.wikidata.org/entity/Q28036307',
    'http://www.wikidata.org/entity/Q28036336',
    'http://www.wikidata.org/entity/Q28036347',
    'http://www.wikidata.org/entity/Q28036534',
    'http://www.wikidata.org/entity/Q28036553',
    'http://www.wikidata.org/entity/Q28036799',
    'http://www.wikidata.org/entity/Q28036851',
    'http://www.wikidata.org/entity/Q28036904',
    'http://www.wikidata.org/entity/Q28036906',
    'http://www.wikidata.org/entity/Q28037078',
    'http://www.wikidata.org/entity/Q28037119',
    'http://www.wikidata.org/entity/Q28037145',
    'http://www.wikidata.org/entity/Q28037157',
    'http://www.wikidata.org/entity/Q28037158',
    'http://www.wikidata.org/entity/Q28037159',
    'http://www.wikidata.org/entity/Q28037202',
    'http://www.wikidata.org/entity/Q28037210',
    'http://www.wikidata.org/entity/Q28037258',
    'http://www.wikidata.org/entity/Q28037361',
    'http://www.wikidata.org/entity/Q28037369',
    'http://www.wikidata.org/entity/Q28039067',
    'http://www.wikidata.org/entity/Q28039071',
    'http://www.wikidata.org/entity/Q28039205',
    'http://www.wikidata.org/entity/Q28039214',
    'http://www.wikidata.org/entity/Q28039220',
    'http://www.wikidata.org/entity/Q28039310',
    'http://www.wikidata.org/entity/Q28039312',
    'http://www.wikidata.org/entity/Q28039313',
    'http://www.wikidata.org/entity/Q28039315',
    'http://www.wikidata.org/entity/Q28039326',
    'http://www.wikidata.org/entity/Q28039332',
    'http://www.wikidata.org/entity/Q28039334',
    'http://www.wikidata.org/entity/Q28039341',
    'http://www.wikidata.org/entity/Q28050008',
    'http://www.wikidata.org/entity/Q28050060',
    'http://www.wikidata.org/entity/Q28050062',
    'http://www.wikidata.org/entity/Q28050067',
    'http://www.wikidata.org/entity/Q28050074',
    'http://www.wikidata.org/entity/Q28050079',
    'http://www.wikidata.org/entity/Q28050103',
    'http://www.wikidata.org/entity/Q28050104',
    'http://www.wikidata.org/entity/Q28050155',
    'http://www.wikidata.org/entity/Q28050161',
    'http://www.wikidata.org/entity/Q28050622',
    'http://www.wikidata.org/entity/Q28050631',
    'http://www.wikidata.org/entity/Q28050857',
    'http://www.wikidata.org/entity/Q28050869',
    'http://www.wikidata.org/entity/Q28051146',
    'http://www.wikidata.org/entity/Q28052887',
    'http://www.wikidata.org/entity/Q28052926',
    'http://www.wikidata.org/entity/Q28151824',
    'http://www.wikidata.org/entity/Q28152053',
    'http://www.wikidata.org/entity/Q28152057',
    'http://www.wikidata.org/entity/Q28152069',
    'http://www.wikidata.org/entity/Q28211478',
    'http://www.wikidata.org/entity/Q28219811',
    'http://www.wikidata.org/entity/Q28219914',
    'http://www.wikidata.org/entity/Q28316983',
    'http://www.wikidata.org/entity/Q28317020',
    'http://www.wikidata.org/entity/Q28317088',
    'http://www.wikidata.org/entity/Q28317101',
    'http://www.wikidata.org/entity/Q28320142',
    'http://www.wikidata.org/entity/Q28320201',
    'http://www.wikidata.org/entity/Q28320547',
    'http://www.wikidata.org/entity/Q28320562',
    'http://www.wikidata.org/entity/Q28320564',
    'http://www.wikidata.org/entity/Q28320569',
    'http://www.wikidata.org/entity/Q28320581',
    'http://www.wikidata.org/entity/Q28320594',
    'http://www.wikidata.org/entity/Q28320644',
    'http://www.wikidata.org/entity/Q28320691',
    'http://www.wikidata.org/entity/Q28320715',
    'http://www.wikidata.org/entity/Q28320727',
    'http://www.wikidata.org/entity/Q28320748',
    'http://www.wikidata.org/entity/Q28320791',
    'http://www.wikidata.org/entity/Q28321102',
    'http://www.wikidata.org/entity/Q28321446',
    'http://www.wikidata.org/entity/Q28321550',
    'http://www.wikidata.org/entity/Q28321762',
    'http://www.wikidata.org/entity/Q28321770',
    'http://www.wikidata.org/entity/Q28321777',
    'http://www.wikidata.org/entity/Q28321786',
    'http://www.wikidata.org/entity/Q28321917',
    'http://www.wikidata.org/entity/Q28322200',
    'http://www.wikidata.org/entity/Q28322400',
    'http://www.wikidata.org/entity/Q28322422',
    'http://www.wikidata.org/entity/Q28322454',
    'http://www.wikidata.org/entity/Q28322492',
    'http://www.wikidata.org/entity/Q28322530',
    'http://www.wikidata.org/entity/Q28322531',
    'http://www.wikidata.org/entity/Q28322534',
    'http://www.wikidata.org/entity/Q28322549',
    'http://www.wikidata.org/entity/Q28322826',
    'http://www.wikidata.org/entity/Q28322958',
    'http://www.wikidata.org/entity/Q28323625',
    'http://www.wikidata.org/entity/Q28323632',
    'http://www.wikidata.org/entity/Q28323647',
    'http://www.wikidata.org/entity/Q28324161',
    'http://www.wikidata.org/entity/Q28324209',
    'http://www.wikidata.org/entity/Q28324218',
    'http://www.wikidata.org/entity/Q28324230',
    'http://www.wikidata.org/entity/Q28324237',
    'http://www.wikidata.org/entity/Q28324256',
    'http://www.wikidata.org/entity/Q28324296',
    'http://www.wikidata.org/entity/Q28324373',
    'http://www.wikidata.org/entity/Q28324587',
    'http://www.wikidata.org/entity/Q28324591',
    'http://www.wikidata.org/entity/Q28324641',
    'http://www.wikidata.org/entity/Q28325054',
    'http://www.wikidata.org/entity/Q28355961',
    'http://www.wikidata.org/entity/Q28356149',
    'http://www.wikidata.org/entity/Q28356166',
    'http://www.wikidata.org/entity/Q28356191',
    'http://www.wikidata.org/entity/Q28356227',
    'http://www.wikidata.org/entity/Q28356235',
    'http://www.wikidata.org/entity/Q28356279',
    'http://www.wikidata.org/entity/Q28356285',
    'http://www.wikidata.org/entity/Q28356290',
    'http://www.wikidata.org/entity/Q28356361',
    'http://www.wikidata.org/entity/Q28359617',
    'http://www.wikidata.org/entity/Q28359691',
    'http://www.wikidata.org/entity/Q28360321',
    'http://www.wikidata.org/entity/Q28360345',
    'http://www.wikidata.org/entity/Q28360446',
    'http://www.wikidata.org/entity/Q28360456',
    'http://www.wikidata.org/entity/Q28360612',
    'http://www.wikidata.org/entity/Q28360617',
    'http://www.wikidata.org/entity/Q28360645',
    'http://www.wikidata.org/entity/Q28360647',
    'http://www.wikidata.org/entity/Q28360648',
    'http://www.wikidata.org/entity/Q28360650',
    'http://www.wikidata.org/entity/Q28364404',
    'http://www.wikidata.org/entity/Q28373106',
    'http://www.wikidata.org/entity/Q28379581',
    'http://www.wikidata.org/entity/Q28379677',
    'http://www.wikidata.org/entity/Q28407524',
    'http://www.wikidata.org/entity/Q28466382',
    'http://www.wikidata.org/entity/Q28468788',
    'http://www.wikidata.org/entity/Q28468840',
    'http://www.wikidata.org/entity/Q28468841',
    'http://www.wikidata.org/entity/Q28468851',
    'http://www.wikidata.org/entity/Q28468859',
    'http://www.wikidata.org/entity/Q28468898',
    'http://www.wikidata.org/entity/Q28468935',
    'http://www.wikidata.org/entity/Q28468944',
    'http://www.wikidata.org/entity/Q28468946',
    'http://www.wikidata.org/entity/Q28468978',
    'http://www.wikidata.org/entity/Q28468993',
    'http://www.wikidata.org/entity/Q28469526',
    'http://www.wikidata.org/entity/Q28480394',
    'http://www.wikidata.org/entity/Q28480403',
    'http://www.wikidata.org/entity/Q28480570',
    'http://www.wikidata.org/entity/Q28484000',
    'http://www.wikidata.org/entity/Q28484006',
    'http://www.wikidata.org/entity/Q28498326',
    'http://www.wikidata.org/entity/Q28498785',
    'http://www.wikidata.org/entity/Q28516588',
    'http://www.wikidata.org/entity/Q28516610',
    'http://www.wikidata.org/entity/Q28516641',
    'http://www.wikidata.org/entity/Q28516669',
    'http://www.wikidata.org/entity/Q28516676',
    'http://www.wikidata.org/entity/Q28516692',
    'http://www.wikidata.org/entity/Q28540892',
    'http://www.wikidata.org/entity/Q28550098',
    'http://www.wikidata.org/entity/Q28554103',
    'http://www.wikidata.org/entity/Q28595173',
    'http://www.wikidata.org/entity/Q28606776',
    'http://www.wikidata.org/entity/Q28606966',
    'http://www.wikidata.org/entity/Q28656527',
    'http://www.wikidata.org/entity/Q2865808',
    'http://www.wikidata.org/entity/Q28741758',
    'http://www.wikidata.org/entity/Q28743695',
    'http://www.wikidata.org/entity/Q28743701',
    'http://www.wikidata.org/entity/Q28743738',
    'http://www.wikidata.org/entity/Q28754501',
    'http://www.wikidata.org/entity/Q28759321',
    'http://www.wikidata.org/entity/Q28777946',
    'http://www.wikidata.org/entity/Q28777952',
    'http://www.wikidata.org/entity/Q28802134',
    'http://www.wikidata.org/entity/Q28804941',
    'http://www.wikidata.org/entity/Q28805278',
    'http://www.wikidata.org/entity/Q28805336',
    'http://www.wikidata.org/entity/Q28805343',
    'http://www.wikidata.org/entity/Q28805344',
    'http://www.wikidata.org/entity/Q28817154',
    'http://www.wikidata.org/entity/Q28817156',
    'http://www.wikidata.org/entity/Q28817180',
    'http://www.wikidata.org/entity/Q28817187',
    'http://www.wikidata.org/entity/Q28833227',
    'http://www.wikidata.org/entity/Q28833307',
    'http://www.wikidata.org/entity/Q28840198',
    'http://www.wikidata.org/entity/Q28842555',
    'http://www.wikidata.org/entity/Q28862028',
    'http://www.wikidata.org/entity/Q28868886',
    'http://www.wikidata.org/entity/Q28870485',
    'http://www.wikidata.org/entity/Q28870686',
    'http://www.wikidata.org/entity/Q28871943',
    'http://www.wikidata.org/entity/Q28913667',
    'http://www.wikidata.org/entity/Q28913668',
    'http://www.wikidata.org/entity/Q28913759',
    'http://www.wikidata.org/entity/Q28913765',
    'http://www.wikidata.org/entity/Q28925161',
    'http://www.wikidata.org/entity/Q28940908',
    'http://www.wikidata.org/entity/Q28958315',
    'http://www.wikidata.org/entity/Q29056937',
    'http://www.wikidata.org/entity/Q29122092',
    'http://www.wikidata.org/entity/Q2919877',
    'http://www.wikidata.org/entity/Q29315318',
    'http://www.wikidata.org/entity/Q293195',
    'http://www.wikidata.org/entity/Q29348045',
    'http://www.wikidata.org/entity/Q29364431',
    'http://www.wikidata.org/entity/Q29381120',
    'http://www.wikidata.org/entity/Q2939207',
    'http://www.wikidata.org/entity/Q29397681',
    'http://www.wikidata.org/entity/Q29446276',
    'http://www.wikidata.org/entity/Q29460378',
    'http://www.wikidata.org/entity/Q29564378',
    'http://www.wikidata.org/entity/Q29564379',
    'http://www.wikidata.org/entity/Q295659',
    'http://www.wikidata.org/entity/Q295691',
    'http://www.wikidata.org/entity/Q29573',
    'http://www.wikidata.org/entity/Q29583803',
    'http://www.wikidata.org/entity/Q29583849',
    'http://www.wikidata.org/entity/Q29642394',
    'http://www.wikidata.org/entity/Q29642449',
    'http://www.wikidata.org/entity/Q29642556',
    'http://www.wikidata.org/entity/Q29642643',
    'http://www.wikidata.org/entity/Q29642738',
    'http://www.wikidata.org/entity/Q29643044',
    'http://www.wikidata.org/entity/Q29643374',
    'http://www.wikidata.org/entity/Q29653465',
    'http://www.wikidata.org/entity/Q29653573',
    'http://www.wikidata.org/entity/Q29668313',
    'http://www.wikidata.org/entity/Q2977048',
    'http://www.wikidata.org/entity/Q29838958',
    'http://www.wikidata.org/entity/Q29839192',
    'http://www.wikidata.org/entity/Q29839292',
    'http://www.wikidata.org/entity/Q29839349',
    'http://www.wikidata.org/entity/Q29839397',
    'http://www.wikidata.org/entity/Q29839423',
    'http://www.wikidata.org/entity/Q29839633',
    'http://www.wikidata.org/entity/Q29839699',
    'http://www.wikidata.org/entity/Q29839772',
    'http://www.wikidata.org/entity/Q29839787',
    'http://www.wikidata.org/entity/Q29840618',
    'http://www.wikidata.org/entity/Q29840626',
    'http://www.wikidata.org/entity/Q29840663',
    'http://www.wikidata.org/entity/Q29840807',
    'http://www.wikidata.org/entity/Q29840812',
    'http://www.wikidata.org/entity/Q29887904',
    'http://www.wikidata.org/entity/Q29887911',
    'http://www.wikidata.org/entity/Q29946263',
    'http://www.wikidata.org/entity/Q29998745',
    'http://www.wikidata.org/entity/Q29998751',
    'http://www.wikidata.org/entity/Q29998759',
    'http://www.wikidata.org/entity/Q29998784',
    'http://www.wikidata.org/entity/Q29999917',
    'http://www.wikidata.org/entity/Q30000117',
    'http://www.wikidata.org/entity/Q30001859',
    'http://www.wikidata.org/entity/Q30001903',
    'http://www.wikidata.org/entity/Q30002003',
    'http://www.wikidata.org/entity/Q30002171',
    'http://www.wikidata.org/entity/Q30002194',
    'http://www.wikidata.org/entity/Q30002265',
    'http://www.wikidata.org/entity/Q30003371',
    'http://www.wikidata.org/entity/Q30003384',
    'http://www.wikidata.org/entity/Q30003447',
    'http://www.wikidata.org/entity/Q30003462',
    'http://www.wikidata.org/entity/Q30003976',
    'http://www.wikidata.org/entity/Q30004039',
    'http://www.wikidata.org/entity/Q30004087',
    'http://www.wikidata.org/entity/Q30004089',
    'http://www.wikidata.org/entity/Q30004103',
    'http://www.wikidata.org/entity/Q30004276',
    'http://www.wikidata.org/entity/Q30004359',
    'http://www.wikidata.org/entity/Q30004457',
    'http://www.wikidata.org/entity/Q30004466',
    'http://www.wikidata.org/entity/Q30032479',
    'http://www.wikidata.org/entity/Q30068232',
    'http://www.wikidata.org/entity/Q30069510',
    'http://www.wikidata.org/entity/Q30069759',
    'http://www.wikidata.org/entity/Q30069760',
    'http://www.wikidata.org/entity/Q30089824',
    'http://www.wikidata.org/entity/Q30089872',
    'http://www.wikidata.org/entity/Q30089880',
    'http://www.wikidata.org/entity/Q30089894',
    'http://www.wikidata.org/entity/Q30089935',
    'http://www.wikidata.org/entity/Q30089946',
    'http://www.wikidata.org/entity/Q30089971',
    'http://www.wikidata.org/entity/Q30089996',
    'http://www.wikidata.org/entity/Q30090007',
    'http://www.wikidata.org/entity/Q30090012',
    'http://www.wikidata.org/entity/Q30090013',
    'http://www.wikidata.org/entity/Q30090014',
    'http://www.wikidata.org/entity/Q30093095',
    'http://www.wikidata.org/entity/Q30093137',
    'http://www.wikidata.org/entity/Q30093319',
    'http://www.wikidata.org/entity/Q30102986',
    'http://www.wikidata.org/entity/Q30103010',
    'http://www.wikidata.org/entity/Q30106731',
    'http://www.wikidata.org/entity/Q30106739',
    'http://www.wikidata.org/entity/Q30111631',
    'http://www.wikidata.org/entity/Q30111686',
    'http://www.wikidata.org/entity/Q30111804',
    'http://www.wikidata.org/entity/Q30112202',
    'http://www.wikidata.org/entity/Q30112482',
    'http://www.wikidata.org/entity/Q30112539',
    'http://www.wikidata.org/entity/Q30112579',
    'http://www.wikidata.org/entity/Q30112644',
    'http://www.wikidata.org/entity/Q30114382',
    'http://www.wikidata.org/entity/Q30119824',
    'http://www.wikidata.org/entity/Q30121906',
    'http://www.wikidata.org/entity/Q30158290',
    'http://www.wikidata.org/entity/Q30158291',
    'http://www.wikidata.org/entity/Q30158311',
    'http://www.wikidata.org/entity/Q30158357',
    'http://www.wikidata.org/entity/Q30158391',
    'http://www.wikidata.org/entity/Q30190796',
    'http://www.wikidata.org/entity/Q30223679',
    'http://www.wikidata.org/entity/Q30223717',
    'http://www.wikidata.org/entity/Q30223725',
    'http://www.wikidata.org/entity/Q30223726',
    'http://www.wikidata.org/entity/Q30247983',
    'http://www.wikidata.org/entity/Q30248024',
    'http://www.wikidata.org/entity/Q30299891',
    'http://www.wikidata.org/entity/Q30302466',
    'http://www.wikidata.org/entity/Q30303486',
    'http://www.wikidata.org/entity/Q30310195',
    'http://www.wikidata.org/entity/Q30315189',
    'http://www.wikidata.org/entity/Q30317317',
    'http://www.wikidata.org/entity/Q30322452',
    'http://www.wikidata.org/entity/Q30322465',
    'http://www.wikidata.org/entity/Q30329016',
    'http://www.wikidata.org/entity/Q30346950',
    'http://www.wikidata.org/entity/Q30347065',
    'http://www.wikidata.org/entity/Q30347235',
    'http://www.wikidata.org/entity/Q30347432',
    'http://www.wikidata.org/entity/Q30347467',
    'http://www.wikidata.org/entity/Q30347566',
    'http://www.wikidata.org/entity/Q30347672',
    'http://www.wikidata.org/entity/Q30347695',
    'http://www.wikidata.org/entity/Q30347705',
    'http://www.wikidata.org/entity/Q30347871',
    'http://www.wikidata.org/entity/Q30347888',
    'http://www.wikidata.org/entity/Q30347960',
    'http://www.wikidata.org/entity/Q30348011',
    'http://www.wikidata.org/entity/Q30348322',
    'http://www.wikidata.org/entity/Q30348324',
    'http://www.wikidata.org/entity/Q30348333',
    'http://www.wikidata.org/entity/Q30348344',
    'http://www.wikidata.org/entity/Q30348348',
    'http://www.wikidata.org/entity/Q30348349',
    'http://www.wikidata.org/entity/Q30348351',
    'http://www.wikidata.org/entity/Q30348949',
    'http://www.wikidata.org/entity/Q30348950',
    'http://www.wikidata.org/entity/Q30349390',
    'http://www.wikidata.org/entity/Q30349405',
    'http://www.wikidata.org/entity/Q30355720',
    'http://www.wikidata.org/entity/Q30361422',
    'http://www.wikidata.org/entity/Q30361447',
    'http://www.wikidata.org/entity/Q30361876',
    'http://www.wikidata.org/entity/Q30362072',
    'http://www.wikidata.org/entity/Q30362327',
    'http://www.wikidata.org/entity/Q30388929',
    'http://www.wikidata.org/entity/Q30388950',
    'http://www.wikidata.org/entity/Q30410265',
    'http://www.wikidata.org/entity/Q30414755',
    'http://www.wikidata.org/entity/Q30421554',
    'http://www.wikidata.org/entity/Q30421754',
    'http://www.wikidata.org/entity/Q30423350',
    'http://www.wikidata.org/entity/Q30423469',
    'http://www.wikidata.org/entity/Q30423489',
    'http://www.wikidata.org/entity/Q30427222',
    'http://www.wikidata.org/entity/Q30427632',
    'http://www.wikidata.org/entity/Q30428761',
    'http://www.wikidata.org/entity/Q30428909',
    'http://www.wikidata.org/entity/Q30429884',
    'http://www.wikidata.org/entity/Q30429993',
    'http://www.wikidata.org/entity/Q30430548',
    'http://www.wikidata.org/entity/Q30434362',
    'http://www.wikidata.org/entity/Q30435924',
    'http://www.wikidata.org/entity/Q30436517',
    'http://www.wikidata.org/entity/Q30436602',
    'http://www.wikidata.org/entity/Q30445602',
    'http://www.wikidata.org/entity/Q30456091',
    'http://www.wikidata.org/entity/Q30456284',
    'http://www.wikidata.org/entity/Q30500724',
    'http://www.wikidata.org/entity/Q30500735',
    'http://www.wikidata.org/entity/Q30500942',
    'http://www.wikidata.org/entity/Q30501357',
    'http://www.wikidata.org/entity/Q30501410',
    'http://www.wikidata.org/entity/Q30501469',
    'http://www.wikidata.org/entity/Q30501736',
    'http://www.wikidata.org/entity/Q30502927',
    'http://www.wikidata.org/entity/Q30502933',
    'http://www.wikidata.org/entity/Q30503669',
    'http://www.wikidata.org/entity/Q30503723',
    'http://www.wikidata.org/entity/Q30503962',
    'http://www.wikidata.org/entity/Q30504197',
    'http://www.wikidata.org/entity/Q30504740',
    'http://www.wikidata.org/entity/Q30504747',
    'http://www.wikidata.org/entity/Q30504798',
    'http://www.wikidata.org/entity/Q30505008',
    'http://www.wikidata.org/entity/Q30505183',
    'http://www.wikidata.org/entity/Q30505257',
    'http://www.wikidata.org/entity/Q30505337',
    'http://www.wikidata.org/entity/Q30505555',
    'http://www.wikidata.org/entity/Q30505567',
    'http://www.wikidata.org/entity/Q30505709',
    'http://www.wikidata.org/entity/Q30506132',
    'http://www.wikidata.org/entity/Q30506146',
    'http://www.wikidata.org/entity/Q30506180',
    'http://www.wikidata.org/entity/Q30506253',
    'http://www.wikidata.org/entity/Q30506416',
    'http://www.wikidata.org/entity/Q30506440',
    'http://www.wikidata.org/entity/Q30506457',
    'http://www.wikidata.org/entity/Q30506463',
    'http://www.wikidata.org/entity/Q30506542',
    'http://www.wikidata.org/entity/Q30507691',
    'http://www.wikidata.org/entity/Q30507739',
    'http://www.wikidata.org/entity/Q30507943',
    'http://www.wikidata.org/entity/Q30507980',
    'http://www.wikidata.org/entity/Q30508504',
    'http://www.wikidata.org/entity/Q30508821',
    'http://www.wikidata.org/entity/Q30510155',
    'http://www.wikidata.org/entity/Q30510170',
    'http://www.wikidata.org/entity/Q30511302',
    'http://www.wikidata.org/entity/Q30512667',
    'http://www.wikidata.org/entity/Q30513802',
    'http://www.wikidata.org/entity/Q30513842',
    'http://www.wikidata.org/entity/Q30513910',
    'http://www.wikidata.org/entity/Q30514181',
    'http://www.wikidata.org/entity/Q30514182',
    'http://www.wikidata.org/entity/Q30519127',
    'http://www.wikidata.org/entity/Q30524411',
    'http://www.wikidata.org/entity/Q30525400',
    'http://www.wikidata.org/entity/Q30525541',
    'http://www.wikidata.org/entity/Q30530404',
    'http://www.wikidata.org/entity/Q30530447',
    'http://www.wikidata.org/entity/Q30530451',
    'http://www.wikidata.org/entity/Q30530678',
    'http://www.wikidata.org/entity/Q30533411',
    'http://www.wikidata.org/entity/Q30533735',
    'http://www.wikidata.org/entity/Q30537295',
    'http://www.wikidata.org/entity/Q30582986',
    'http://www.wikidata.org/entity/Q30583108',
    'http://www.wikidata.org/entity/Q30650518',
    'http://www.wikidata.org/entity/Q30668464',
    'http://www.wikidata.org/entity/Q30668534',
    'http://www.wikidata.org/entity/Q30742679',
    'http://www.wikidata.org/entity/Q3074353',
    'http://www.wikidata.org/entity/Q30830898',
    'http://www.wikidata.org/entity/Q30905495',
    'http://www.wikidata.org/entity/Q309814',
    'http://www.wikidata.org/entity/Q309979',
    'http://www.wikidata.org/entity/Q31051436',
    'http://www.wikidata.org/entity/Q31088142',
    'http://www.wikidata.org/entity/Q3121397',
    'http://www.wikidata.org/entity/Q3121500',
    'http://www.wikidata.org/entity/Q31229142',
    'http://www.wikidata.org/entity/Q31229298',
    'http://www.wikidata.org/entity/Q3167023',
    'http://www.wikidata.org/entity/Q32072525',
    'http://www.wikidata.org/entity/Q322114',
    'http://www.wikidata.org/entity/Q32424966',
    'http://www.wikidata.org/entity/Q32425219',
    'http://www.wikidata.org/entity/Q32425238',
    'http://www.wikidata.org/entity/Q32426109',
    'http://www.wikidata.org/entity/Q3259614',
    'http://www.wikidata.org/entity/Q3261234',
    'http://www.wikidata.org/entity/Q32632869',
    'http://www.wikidata.org/entity/Q32637684',
    'http://www.wikidata.org/entity/Q32642078',
    'http://www.wikidata.org/entity/Q32642588',
    'http://www.wikidata.org/entity/Q32646381',
    'http://www.wikidata.org/entity/Q32649203',
    'http://www.wikidata.org/entity/Q32654119',
    'http://www.wikidata.org/entity/Q3294273',
    'http://www.wikidata.org/entity/Q32984952',
    'http://www.wikidata.org/entity/Q32985045',
    'http://www.wikidata.org/entity/Q3298995',
    'http://www.wikidata.org/entity/Q33101711',
    'http://www.wikidata.org/entity/Q33102917',
    'http://www.wikidata.org/entity/Q33103772',
    'http://www.wikidata.org/entity/Q33103799',
    'http://www.wikidata.org/entity/Q33106021',
    'http://www.wikidata.org/entity/Q33113039',
    'http://www.wikidata.org/entity/Q33113943',
    'http://www.wikidata.org/entity/Q33142437',
    'http://www.wikidata.org/entity/Q33172727',
    'http://www.wikidata.org/entity/Q33240377',
    'http://www.wikidata.org/entity/Q33277616',
    'http://www.wikidata.org/entity/Q33310590',
    'http://www.wikidata.org/entity/Q33310611',
    'http://www.wikidata.org/entity/Q33310632',
    'http://www.wikidata.org/entity/Q33489592',
    'http://www.wikidata.org/entity/Q336080',
    'http://www.wikidata.org/entity/Q3362604',
    'http://www.wikidata.org/entity/Q3379857',
    'http://www.wikidata.org/entity/Q340097',
    'http://www.wikidata.org/entity/Q3401334',
    'http://www.wikidata.org/entity/Q34176386',
    'http://www.wikidata.org/entity/Q3433234',
    'http://www.wikidata.org/entity/Q3434896',
    'http://www.wikidata.org/entity/Q34445573',
    'http://www.wikidata.org/entity/Q34572218',
    'http://www.wikidata.org/entity/Q34572450',
    'http://www.wikidata.org/entity/Q34580790',
    'http://www.wikidata.org/entity/Q35028511',
    'http://www.wikidata.org/entity/Q35028955',
    'http://www.wikidata.org/entity/Q354237',
    'http://www.wikidata.org/entity/Q35703947',
    'http://www.wikidata.org/entity/Q35704469',
    'http://www.wikidata.org/entity/Q35704729',
    'http://www.wikidata.org/entity/Q35705246',
    'http://www.wikidata.org/entity/Q3573439',
    'http://www.wikidata.org/entity/Q3659396',
    'http://www.wikidata.org/entity/Q36832398',
    'http://www.wikidata.org/entity/Q3699974',
    'http://www.wikidata.org/entity/Q37063701',
    'http://www.wikidata.org/entity/Q37065855',
    'http://www.wikidata.org/entity/Q37242255',
    'http://www.wikidata.org/entity/Q37321044',
    'http://www.wikidata.org/entity/Q37322423',
    'http://www.wikidata.org/entity/Q37322997',
    'http://www.wikidata.org/entity/Q37323613',
    'http://www.wikidata.org/entity/Q37342847',
    'http://www.wikidata.org/entity/Q37366500',
    'http://www.wikidata.org/entity/Q37366533',
    'http://www.wikidata.org/entity/Q37366804',
    'http://www.wikidata.org/entity/Q37366846',
    'http://www.wikidata.org/entity/Q37367375',
    'http://www.wikidata.org/entity/Q37368159',
    'http://www.wikidata.org/entity/Q37368167',
    'http://www.wikidata.org/entity/Q37368449',
    'http://www.wikidata.org/entity/Q37368469',
    'http://www.wikidata.org/entity/Q37368509',
    'http://www.wikidata.org/entity/Q37368815',
    'http://www.wikidata.org/entity/Q37369318',
    'http://www.wikidata.org/entity/Q37369579',
    'http://www.wikidata.org/entity/Q37369581',
    'http://www.wikidata.org/entity/Q37370038',
    'http://www.wikidata.org/entity/Q37370251',
    'http://www.wikidata.org/entity/Q37370272',
    'http://www.wikidata.org/entity/Q37370300',
    'http://www.wikidata.org/entity/Q37370333',
    'http://www.wikidata.org/entity/Q37370747',
    'http://www.wikidata.org/entity/Q37371270',
    'http://www.wikidata.org/entity/Q37371672',
    'http://www.wikidata.org/entity/Q37371767',
    'http://www.wikidata.org/entity/Q37372407',
    'http://www.wikidata.org/entity/Q37372644',
    'http://www.wikidata.org/entity/Q37372762',
    'http://www.wikidata.org/entity/Q37373352',
    'http://www.wikidata.org/entity/Q37373398',
    'http://www.wikidata.org/entity/Q37373586',
    'http://www.wikidata.org/entity/Q37373699',
    'http://www.wikidata.org/entity/Q37373977',
    'http://www.wikidata.org/entity/Q37373997',
    'http://www.wikidata.org/entity/Q37374066',
    'http://www.wikidata.org/entity/Q37374449',
    'http://www.wikidata.org/entity/Q37374768',
    'http://www.wikidata.org/entity/Q37374905',
    'http://www.wikidata.org/entity/Q37374908',
    'http://www.wikidata.org/entity/Q37375068',
    'http://www.wikidata.org/entity/Q37375142',
    'http://www.wikidata.org/entity/Q37375476',
    'http://www.wikidata.org/entity/Q37375734',
    'http://www.wikidata.org/entity/Q37375884',
    'http://www.wikidata.org/entity/Q37375907',
    'http://www.wikidata.org/entity/Q37376039',
    'http://www.wikidata.org/entity/Q37376223',
    'http://www.wikidata.org/entity/Q37376260',
    'http://www.wikidata.org/entity/Q37376291',
    'http://www.wikidata.org/entity/Q37376316',
    'http://www.wikidata.org/entity/Q37376519',
    'http://www.wikidata.org/entity/Q37376540',
    'http://www.wikidata.org/entity/Q37376561',
    'http://www.wikidata.org/entity/Q37376725',
    'http://www.wikidata.org/entity/Q37376751',
    'http://www.wikidata.org/entity/Q37376815',
    'http://www.wikidata.org/entity/Q37377244',
    'http://www.wikidata.org/entity/Q37377392',
    'http://www.wikidata.org/entity/Q37377512',
    'http://www.wikidata.org/entity/Q37377631',
    'http://www.wikidata.org/entity/Q37377915',
    'http://www.wikidata.org/entity/Q37378385',
    'http://www.wikidata.org/entity/Q37378539',
    'http://www.wikidata.org/entity/Q37378801',
    'http://www.wikidata.org/entity/Q37378984',
    'http://www.wikidata.org/entity/Q37379024',
    'http://www.wikidata.org/entity/Q37380227',
    'http://www.wikidata.org/entity/Q37380250',
    'http://www.wikidata.org/entity/Q37380266',
    'http://www.wikidata.org/entity/Q37380328',
    'http://www.wikidata.org/entity/Q37380492',
    'http://www.wikidata.org/entity/Q37380559',
    'http://www.wikidata.org/entity/Q37381192',
    'http://www.wikidata.org/entity/Q37381668',
    'http://www.wikidata.org/entity/Q37381732',
    'http://www.wikidata.org/entity/Q37381945',
    'http://www.wikidata.org/entity/Q37381999',
    'http://www.wikidata.org/entity/Q37382237',
    'http://www.wikidata.org/entity/Q37382396',
    'http://www.wikidata.org/entity/Q37382500',
    'http://www.wikidata.org/entity/Q37382620',
    'http://www.wikidata.org/entity/Q37383108',
    'http://www.wikidata.org/entity/Q37383258',
    'http://www.wikidata.org/entity/Q37383398',
    'http://www.wikidata.org/entity/Q37383505',
    'http://www.wikidata.org/entity/Q37383590',
    'http://www.wikidata.org/entity/Q37383605',
    'http://www.wikidata.org/entity/Q37384108',
    'http://www.wikidata.org/entity/Q37384205',
    'http://www.wikidata.org/entity/Q37384241',
    'http://www.wikidata.org/entity/Q37384282',
    'http://www.wikidata.org/entity/Q37384520',
    'http://www.wikidata.org/entity/Q37384936',
    'http://www.wikidata.org/entity/Q37385040',
    'http://www.wikidata.org/entity/Q37385179',
    'http://www.wikidata.org/entity/Q37385698',
    'http://www.wikidata.org/entity/Q37386335',
    'http://www.wikidata.org/entity/Q37386732',
    'http://www.wikidata.org/entity/Q37386865',
    'http://www.wikidata.org/entity/Q37387267',
    'http://www.wikidata.org/entity/Q37387600',
    'http://www.wikidata.org/entity/Q37387705',
    'http://www.wikidata.org/entity/Q37387850',
    'http://www.wikidata.org/entity/Q37389793',
    'http://www.wikidata.org/entity/Q37389903',
    'http://www.wikidata.org/entity/Q37390255',
    'http://www.wikidata.org/entity/Q37390410',
    'http://www.wikidata.org/entity/Q37390434',
    'http://www.wikidata.org/entity/Q37390473',
    'http://www.wikidata.org/entity/Q37390536',
    'http://www.wikidata.org/entity/Q37390604',
    'http://www.wikidata.org/entity/Q37391231',
    'http://www.wikidata.org/entity/Q37391682',
    'http://www.wikidata.org/entity/Q37391688',
    'http://www.wikidata.org/entity/Q37391755',
    'http://www.wikidata.org/entity/Q37392328',
    'http://www.wikidata.org/entity/Q37392993',
    'http://www.wikidata.org/entity/Q37393221',
    'http://www.wikidata.org/entity/Q37393309',
    'http://www.wikidata.org/entity/Q37393357',
    'http://www.wikidata.org/entity/Q37393390',
    'http://www.wikidata.org/entity/Q37393431',
    'http://www.wikidata.org/entity/Q37393483',
    'http://www.wikidata.org/entity/Q37393655',
    'http://www.wikidata.org/entity/Q3742417',
    'http://www.wikidata.org/entity/Q375410',
    'http://www.wikidata.org/entity/Q37603772',
    'http://www.wikidata.org/entity/Q37605522',
    'http://www.wikidata.org/entity/Q37605549',
    'http://www.wikidata.org/entity/Q37605908',
    'http://www.wikidata.org/entity/Q37606371',
    'http://www.wikidata.org/entity/Q37608248',
    'http://www.wikidata.org/entity/Q37608549',
    'http://www.wikidata.org/entity/Q37609428',
    'http://www.wikidata.org/entity/Q37610875',
    'http://www.wikidata.org/entity/Q37611197',
    'http://www.wikidata.org/entity/Q37611244',
    'http://www.wikidata.org/entity/Q37611658',
    'http://www.wikidata.org/entity/Q37612120',
    'http://www.wikidata.org/entity/Q37612247',
    'http://www.wikidata.org/entity/Q37612618',
    'http://www.wikidata.org/entity/Q37614102',
    'http://www.wikidata.org/entity/Q37615657',
    'http://www.wikidata.org/entity/Q37615703',
    'http://www.wikidata.org/entity/Q37616051',
    'http://www.wikidata.org/entity/Q37616108',
    'http://www.wikidata.org/entity/Q37616205',
    'http://www.wikidata.org/entity/Q37618308',
    'http://www.wikidata.org/entity/Q37620738',
    'http://www.wikidata.org/entity/Q37624941',
    'http://www.wikidata.org/entity/Q37625061',
    'http://www.wikidata.org/entity/Q37629853',
    'http://www.wikidata.org/entity/Q37630021',
    'http://www.wikidata.org/entity/Q37630107',
    'http://www.wikidata.org/entity/Q37630755',
    'http://www.wikidata.org/entity/Q37631967',
    'http://www.wikidata.org/entity/Q37632158',
    'http://www.wikidata.org/entity/Q37632234',
    'http://www.wikidata.org/entity/Q37632831',
    'http://www.wikidata.org/entity/Q37634364',
    'http://www.wikidata.org/entity/Q37638868',
    'http://www.wikidata.org/entity/Q37640706',
    'http://www.wikidata.org/entity/Q37644367',
    'http://www.wikidata.org/entity/Q37649643',
    'http://www.wikidata.org/entity/Q37649676',
    'http://www.wikidata.org/entity/Q37650477',
    'http://www.wikidata.org/entity/Q37650609',
    'http://www.wikidata.org/entity/Q37651649',
    'http://www.wikidata.org/entity/Q37651777',
    'http://www.wikidata.org/entity/Q37651969',
    'http://www.wikidata.org/entity/Q37652358',
    'http://www.wikidata.org/entity/Q37652504',
    'http://www.wikidata.org/entity/Q37652751',
    'http://www.wikidata.org/entity/Q37652829',
    'http://www.wikidata.org/entity/Q37653004',
    'http://www.wikidata.org/entity/Q37653053',
    'http://www.wikidata.org/entity/Q37653103',
    'http://www.wikidata.org/entity/Q37662525',
    'http://www.wikidata.org/entity/Q3768021',
    'http://www.wikidata.org/entity/Q37826926',
    'http://www.wikidata.org/entity/Q37828599',
    'http://www.wikidata.org/entity/Q37828656',
    'http://www.wikidata.org/entity/Q37828676',
    'http://www.wikidata.org/entity/Q37828754',
    'http://www.wikidata.org/entity/Q37828756',
    'http://www.wikidata.org/entity/Q37828790',
    'http://www.wikidata.org/entity/Q37828820',
    'http://www.wikidata.org/entity/Q37828851',
    'http://www.wikidata.org/entity/Q37828961',
    'http://www.wikidata.org/entity/Q37828999',
    'http://www.wikidata.org/entity/Q37829051',
    'http://www.wikidata.org/entity/Q37829195',
    'http://www.wikidata.org/entity/Q37829204',
    'http://www.wikidata.org/entity/Q37829208',
    'http://www.wikidata.org/entity/Q37829251',
    'http://www.wikidata.org/entity/Q37829338',
    'http://www.wikidata.org/entity/Q37829390',
    'http://www.wikidata.org/entity/Q37829812',
    'http://www.wikidata.org/entity/Q37829852',
    'http://www.wikidata.org/entity/Q37829860',
    'http://www.wikidata.org/entity/Q37830087',
    'http://www.wikidata.org/entity/Q37830422',
    'http://www.wikidata.org/entity/Q37830438',
    'http://www.wikidata.org/entity/Q37830449',
    'http://www.wikidata.org/entity/Q37830471',
    'http://www.wikidata.org/entity/Q37830519',
    'http://www.wikidata.org/entity/Q37830561',
    'http://www.wikidata.org/entity/Q37830585',
    'http://www.wikidata.org/entity/Q37830642',
    'http://www.wikidata.org/entity/Q37830651',
    'http://www.wikidata.org/entity/Q37830656',
    'http://www.wikidata.org/entity/Q37830668',
    'http://www.wikidata.org/entity/Q37830687',
    'http://www.wikidata.org/entity/Q37830753',
    'http://www.wikidata.org/entity/Q37830794',
    'http://www.wikidata.org/entity/Q37831294',
    'http://www.wikidata.org/entity/Q37831311',
    'http://www.wikidata.org/entity/Q37831452',
    'http://www.wikidata.org/entity/Q37831481',
    'http://www.wikidata.org/entity/Q37831495',
    'http://www.wikidata.org/entity/Q37831540',
    'http://www.wikidata.org/entity/Q37831612',
    'http://www.wikidata.org/entity/Q3783177',
    'http://www.wikidata.org/entity/Q37834305',
    'http://www.wikidata.org/entity/Q37834353',
    'http://www.wikidata.org/entity/Q37834358',
    'http://www.wikidata.org/entity/Q37834389',
    'http://www.wikidata.org/entity/Q37834611',
    'http://www.wikidata.org/entity/Q37834847',
    'http://www.wikidata.org/entity/Q37834883',
    'http://www.wikidata.org/entity/Q37834895',
    'http://www.wikidata.org/entity/Q37835033',
    'http://www.wikidata.org/entity/Q37835108',
    'http://www.wikidata.org/entity/Q37836517',
    'http://www.wikidata.org/entity/Q37836966',
    'http://www.wikidata.org/entity/Q37837275',
    'http://www.wikidata.org/entity/Q37837380',
    'http://www.wikidata.org/entity/Q37837778',
    'http://www.wikidata.org/entity/Q37837814',
    'http://www.wikidata.org/entity/Q37837864',
    'http://www.wikidata.org/entity/Q37837929',
    'http://www.wikidata.org/entity/Q37837978',
    'http://www.wikidata.org/entity/Q37837994',
    'http://www.wikidata.org/entity/Q37838118',
    'http://www.wikidata.org/entity/Q37838216',
    'http://www.wikidata.org/entity/Q37838294',
    'http://www.wikidata.org/entity/Q37838402',
    'http://www.wikidata.org/entity/Q37838417',
    'http://www.wikidata.org/entity/Q37838458',
    'http://www.wikidata.org/entity/Q37838558',
    'http://www.wikidata.org/entity/Q37838645',
    'http://www.wikidata.org/entity/Q37838727',
    'http://www.wikidata.org/entity/Q37838769',
    'http://www.wikidata.org/entity/Q37838937',
    'http://www.wikidata.org/entity/Q37839057',
    'http://www.wikidata.org/entity/Q37839199',
    'http://www.wikidata.org/entity/Q37839279',
    'http://www.wikidata.org/entity/Q37839660',
    'http://www.wikidata.org/entity/Q37839983',
    'http://www.wikidata.org/entity/Q37840355',
    'http://www.wikidata.org/entity/Q37840488',
    'http://www.wikidata.org/entity/Q37840564',
    'http://www.wikidata.org/entity/Q37840795',
    'http://www.wikidata.org/entity/Q37841134',
    'http://www.wikidata.org/entity/Q37841297',
    'http://www.wikidata.org/entity/Q37841724',
    'http://www.wikidata.org/entity/Q37842284',
    'http://www.wikidata.org/entity/Q37842347',
    'http://www.wikidata.org/entity/Q37842536',
    'http://www.wikidata.org/entity/Q37842645',
    'http://www.wikidata.org/entity/Q37843077',
    'http://www.wikidata.org/entity/Q37843472',
    'http://www.wikidata.org/entity/Q38132017',
    'http://www.wikidata.org/entity/Q3814528',
    'http://www.wikidata.org/entity/Q3816008',
    'http://www.wikidata.org/entity/Q38304599',
    'http://www.wikidata.org/entity/Q38304685',
    'http://www.wikidata.org/entity/Q38305500',
    'http://www.wikidata.org/entity/Q38317846',
    'http://www.wikidata.org/entity/Q38318328',
    'http://www.wikidata.org/entity/Q38318822',
    'http://www.wikidata.org/entity/Q38318831',
    'http://www.wikidata.org/entity/Q38318906',
    'http://www.wikidata.org/entity/Q38319217',
    'http://www.wikidata.org/entity/Q38319793',
    'http://www.wikidata.org/entity/Q38322692',
    'http://www.wikidata.org/entity/Q38323377',
    'http://www.wikidata.org/entity/Q38323975',
    'http://www.wikidata.org/entity/Q38324909',
    'http://www.wikidata.org/entity/Q38325512',
    'http://www.wikidata.org/entity/Q38325540',
    'http://www.wikidata.org/entity/Q38325765',
    'http://www.wikidata.org/entity/Q38326091',
    'http://www.wikidata.org/entity/Q38326286',
    'http://www.wikidata.org/entity/Q38326393',
    'http://www.wikidata.org/entity/Q38326817',
    'http://www.wikidata.org/entity/Q38326936',
    'http://www.wikidata.org/entity/Q38327146',
    'http://www.wikidata.org/entity/Q38328269',
    'http://www.wikidata.org/entity/Q38328382',
    'http://www.wikidata.org/entity/Q38328848',
    'http://www.wikidata.org/entity/Q38328879',
    'http://www.wikidata.org/entity/Q38329405',
    'http://www.wikidata.org/entity/Q38329590',
    'http://www.wikidata.org/entity/Q38329804',
    'http://www.wikidata.org/entity/Q38330464',
    'http://www.wikidata.org/entity/Q38358929',
    'http://www.wikidata.org/entity/Q38359288',
    'http://www.wikidata.org/entity/Q38359671',
    'http://www.wikidata.org/entity/Q38360372',
    'http://www.wikidata.org/entity/Q38360494',
    'http://www.wikidata.org/entity/Q38361689',
    'http://www.wikidata.org/entity/Q38362730',
    'http://www.wikidata.org/entity/Q38362819',
    'http://www.wikidata.org/entity/Q38523181',
    'http://www.wikidata.org/entity/Q38523281',
    'http://www.wikidata.org/entity/Q38523404',
    'http://www.wikidata.org/entity/Q38543909',
    'http://www.wikidata.org/entity/Q38543979',
    'http://www.wikidata.org/entity/Q38543991',
    'http://www.wikidata.org/entity/Q38544264',
    'http://www.wikidata.org/entity/Q38544311',
    'http://www.wikidata.org/entity/Q38544320',
    'http://www.wikidata.org/entity/Q38544548',
    'http://www.wikidata.org/entity/Q38544823',
    'http://www.wikidata.org/entity/Q38544864',
    'http://www.wikidata.org/entity/Q38544871',
    'http://www.wikidata.org/entity/Q38545136',
    'http://www.wikidata.org/entity/Q38545234',
    'http://www.wikidata.org/entity/Q38545271',
    'http://www.wikidata.org/entity/Q38545647',
    'http://www.wikidata.org/entity/Q38546582',
    'http://www.wikidata.org/entity/Q38546847',
    'http://www.wikidata.org/entity/Q38546986',
    'http://www.wikidata.org/entity/Q38548220',
    'http://www.wikidata.org/entity/Q38548964',
    'http://www.wikidata.org/entity/Q38549176',
    'http://www.wikidata.org/entity/Q38549204',
    'http://www.wikidata.org/entity/Q38550003',
    'http://www.wikidata.org/entity/Q38589185',
    'http://www.wikidata.org/entity/Q38589467',
    'http://www.wikidata.org/entity/Q38589865',
    'http://www.wikidata.org/entity/Q38590672',
    'http://www.wikidata.org/entity/Q38590804',
    'http://www.wikidata.org/entity/Q38591023',
    'http://www.wikidata.org/entity/Q38591100',
    'http://www.wikidata.org/entity/Q38591158',
    'http://www.wikidata.org/entity/Q38591193',
    'http://www.wikidata.org/entity/Q38600826',
    'http://www.wikidata.org/entity/Q38601196',
    'http://www.wikidata.org/entity/Q38601327',
    'http://www.wikidata.org/entity/Q38636823',
    'http://www.wikidata.org/entity/Q38637441',
    'http://www.wikidata.org/entity/Q38638999',
    'http://www.wikidata.org/entity/Q38639094',
    'http://www.wikidata.org/entity/Q38639483',
    'http://www.wikidata.org/entity/Q38640629',
    'http://www.wikidata.org/entity/Q38640707',
    'http://www.wikidata.org/entity/Q38640728',
    'http://www.wikidata.org/entity/Q38640820',
    'http://www.wikidata.org/entity/Q38641034',
    'http://www.wikidata.org/entity/Q38641417',
    'http://www.wikidata.org/entity/Q38641478',
    'http://www.wikidata.org/entity/Q38641833',
    'http://www.wikidata.org/entity/Q38642235',
    'http://www.wikidata.org/entity/Q38642423',
    'http://www.wikidata.org/entity/Q38800410',
    'http://www.wikidata.org/entity/Q38802211',
    'http://www.wikidata.org/entity/Q38802305',
    'http://www.wikidata.org/entity/Q38802645',
    'http://www.wikidata.org/entity/Q38803002',
    'http://www.wikidata.org/entity/Q38803329',
    'http://www.wikidata.org/entity/Q38803551',
    'http://www.wikidata.org/entity/Q38803739',
    'http://www.wikidata.org/entity/Q38803763',
    'http://www.wikidata.org/entity/Q38804522',
    'http://www.wikidata.org/entity/Q38848822',
    'http://www.wikidata.org/entity/Q39024816',
    'http://www.wikidata.org/entity/Q39026591',
    'http://www.wikidata.org/entity/Q39031689',
    'http://www.wikidata.org/entity/Q39031972',
    'http://www.wikidata.org/entity/Q39034312',
    'http://www.wikidata.org/entity/Q39034463',
    'http://www.wikidata.org/entity/Q39049575',
    'http://www.wikidata.org/entity/Q39051055',
    'http://www.wikidata.org/entity/Q39051364',
    'http://www.wikidata.org/entity/Q39052654',
    'http://www.wikidata.org/entity/Q39061421',
    'http://www.wikidata.org/entity/Q39061520',
    'http://www.wikidata.org/entity/Q39062628',
    'http://www.wikidata.org/entity/Q39062673',
    'http://www.wikidata.org/entity/Q39062686',
    'http://www.wikidata.org/entity/Q39062919',
    'http://www.wikidata.org/entity/Q39065635',
    'http://www.wikidata.org/entity/Q39071290',
    'http://www.wikidata.org/entity/Q39183179',
    'http://www.wikidata.org/entity/Q39183458',
    'http://www.wikidata.org/entity/Q39184696',
    'http://www.wikidata.org/entity/Q39188368',
    'http://www.wikidata.org/entity/Q39188870',
    'http://www.wikidata.org/entity/Q39190118',
    'http://www.wikidata.org/entity/Q39196569',
    'http://www.wikidata.org/entity/Q39272295',
    'http://www.wikidata.org/entity/Q39273048',
    'http://www.wikidata.org/entity/Q39273342',
    'http://www.wikidata.org/entity/Q39274051',
    'http://www.wikidata.org/entity/Q39274416',
    'http://www.wikidata.org/entity/Q39362985',
    'http://www.wikidata.org/entity/Q39373166',
    'http://www.wikidata.org/entity/Q39380920',
    'http://www.wikidata.org/entity/Q39381992',
    'http://www.wikidata.org/entity/Q39386968',
    'http://www.wikidata.org/entity/Q39408549',
    'http://www.wikidata.org/entity/Q39438017',
    'http://www.wikidata.org/entity/Q39444311',
    'http://www.wikidata.org/entity/Q39447567',
    'http://www.wikidata.org/entity/Q39477656',
    'http://www.wikidata.org/entity/Q39481008',
    'http://www.wikidata.org/entity/Q39482766',
    'http://www.wikidata.org/entity/Q39501983',
    'http://www.wikidata.org/entity/Q39515110',
    'http://www.wikidata.org/entity/Q39515167',
    'http://www.wikidata.org/entity/Q39585651',
    'http://www.wikidata.org/entity/Q39597291',
    'http://www.wikidata.org/entity/Q39636291',
    'http://www.wikidata.org/entity/Q39638049',
    'http://www.wikidata.org/entity/Q39672238',
    'http://www.wikidata.org/entity/Q39679773',
    'http://www.wikidata.org/entity/Q39683404',
    'http://www.wikidata.org/entity/Q39684181',
    'http://www.wikidata.org/entity/Q39689151',
    'http://www.wikidata.org/entity/Q39709513',
    'http://www.wikidata.org/entity/Q39713200',
    'http://www.wikidata.org/entity/Q39724789',
    'http://www.wikidata.org/entity/Q39752275',
    'http://www.wikidata.org/entity/Q39756841',
    'http://www.wikidata.org/entity/Q39783155',
    'http://www.wikidata.org/entity/Q39793026',
    'http://www.wikidata.org/entity/Q39809013',
    'http://www.wikidata.org/entity/Q39811054',
    'http://www.wikidata.org/entity/Q39814267',
    'http://www.wikidata.org/entity/Q39815349',
    'http://www.wikidata.org/entity/Q39818611',
    'http://www.wikidata.org/entity/Q39821866',
    'http://www.wikidata.org/entity/Q39861503',
    'http://www.wikidata.org/entity/Q39874121',
    'http://www.wikidata.org/entity/Q39880503',
    'http://www.wikidata.org/entity/Q39885017',
    'http://www.wikidata.org/entity/Q39892434',
    'http://www.wikidata.org/entity/Q39915183',
    'http://www.wikidata.org/entity/Q39931206',
    'http://www.wikidata.org/entity/Q39933641',
    'http://www.wikidata.org/entity/Q39953740',
    'http://www.wikidata.org/entity/Q39956334',
    'http://www.wikidata.org/entity/Q39961579',
    'http://www.wikidata.org/entity/Q39963438',
    'http://www.wikidata.org/entity/Q39964242',
    'http://www.wikidata.org/entity/Q39979518',
    'http://www.wikidata.org/entity/Q39980956',
    'http://www.wikidata.org/entity/Q39992784',
    'http://www.wikidata.org/entity/Q39995144',
    'http://www.wikidata.org/entity/Q39998334',
    'http://www.wikidata.org/entity/Q40007133',
    'http://www.wikidata.org/entity/Q40008451',
    'http://www.wikidata.org/entity/Q40012298',
    'http://www.wikidata.org/entity/Q40022853',
    'http://www.wikidata.org/entity/Q40024880',
    'http://www.wikidata.org/entity/Q40050893',
    'http://www.wikidata.org/entity/Q40058345',
    'http://www.wikidata.org/entity/Q40059112',
    'http://www.wikidata.org/entity/Q40083442',
    'http://www.wikidata.org/entity/Q40087926',
    'http://www.wikidata.org/entity/Q40092574',
    'http://www.wikidata.org/entity/Q40097388',
    'http://www.wikidata.org/entity/Q40115857',
    'http://www.wikidata.org/entity/Q40122833',
    'http://www.wikidata.org/entity/Q40141436',
    'http://www.wikidata.org/entity/Q40152658',
    'http://www.wikidata.org/entity/Q40159479',
    'http://www.wikidata.org/entity/Q40173515',
    'http://www.wikidata.org/entity/Q40183186',
    'http://www.wikidata.org/entity/Q40201403',
    'http://www.wikidata.org/entity/Q40205995',
    'http://www.wikidata.org/entity/Q40206813',
    'http://www.wikidata.org/entity/Q40233168',
    'http://www.wikidata.org/entity/Q40235097',
    'http://www.wikidata.org/entity/Q40267285',
    'http://www.wikidata.org/entity/Q40276762',
    'http://www.wikidata.org/entity/Q40279915',
    'http://www.wikidata.org/entity/Q40280648',
    'http://www.wikidata.org/entity/Q40296391',
    'http://www.wikidata.org/entity/Q40310748',
    'http://www.wikidata.org/entity/Q40335499',
    'http://www.wikidata.org/entity/Q40336008',
    'http://www.wikidata.org/entity/Q40340965',
    'http://www.wikidata.org/entity/Q40345576',
    'http://www.wikidata.org/entity/Q40351138',
    'http://www.wikidata.org/entity/Q40358533',
    'http://www.wikidata.org/entity/Q40369289',
    'http://www.wikidata.org/entity/Q40371853',
    'http://www.wikidata.org/entity/Q40388857',
    'http://www.wikidata.org/entity/Q40394898',
    'http://www.wikidata.org/entity/Q40398470',
    'http://www.wikidata.org/entity/Q40403049',
    'http://www.wikidata.org/entity/Q40406948',
    'http://www.wikidata.org/entity/Q40442775',
    'http://www.wikidata.org/entity/Q40444031',
    'http://www.wikidata.org/entity/Q40448764',
    'http://www.wikidata.org/entity/Q40473885',
    'http://www.wikidata.org/entity/Q40487296',
    'http://www.wikidata.org/entity/Q40505165',
    'http://www.wikidata.org/entity/Q40529350',
    'http://www.wikidata.org/entity/Q40539354',
    'http://www.wikidata.org/entity/Q40551946',
    'http://www.wikidata.org/entity/Q40562067',
    'http://www.wikidata.org/entity/Q40580095',
    'http://www.wikidata.org/entity/Q40595596',
    'http://www.wikidata.org/entity/Q40614280',
    'http://www.wikidata.org/entity/Q40649499',
    'http://www.wikidata.org/entity/Q40664103',
    'http://www.wikidata.org/entity/Q40664138',
    'http://www.wikidata.org/entity/Q40664206',
    'http://www.wikidata.org/entity/Q40693832',
    'http://www.wikidata.org/entity/Q40718196',
    'http://www.wikidata.org/entity/Q40719683',
    'http://www.wikidata.org/entity/Q40744820',
    'http://www.wikidata.org/entity/Q40776867',
    'http://www.wikidata.org/entity/Q40808779',
    'http://www.wikidata.org/entity/Q40830286',
    'http://www.wikidata.org/entity/Q40845084',
    'http://www.wikidata.org/entity/Q40845114',
    'http://www.wikidata.org/entity/Q40855602',
    'http://www.wikidata.org/entity/Q40868810',
    'http://www.wikidata.org/entity/Q40910220',
    'http://www.wikidata.org/entity/Q40920526',
    'http://www.wikidata.org/entity/Q40922377',
    'http://www.wikidata.org/entity/Q40927042',
    'http://www.wikidata.org/entity/Q40949081',
    'http://www.wikidata.org/entity/Q40960510',
    'http://www.wikidata.org/entity/Q40997570',
    'http://www.wikidata.org/entity/Q41043812',
    'http://www.wikidata.org/entity/Q41044400',
    'http://www.wikidata.org/entity/Q41047849',
    'http://www.wikidata.org/entity/Q41048428',
    'http://www.wikidata.org/entity/Q41048454',
    'http://www.wikidata.org/entity/Q41048648',
    'http://www.wikidata.org/entity/Q41049772',
    'http://www.wikidata.org/entity/Q41071275',
    'http://www.wikidata.org/entity/Q41086613',
    'http://www.wikidata.org/entity/Q41122225',
    'http://www.wikidata.org/entity/Q41130800',
    'http://www.wikidata.org/entity/Q41147578',
    'http://www.wikidata.org/entity/Q41172848',
    'http://www.wikidata.org/entity/Q41184800',
    'http://www.wikidata.org/entity/Q41200324',
    'http://www.wikidata.org/entity/Q41203524',
    'http://www.wikidata.org/entity/Q41247264',
    'http://www.wikidata.org/entity/Q41254125',
    'http://www.wikidata.org/entity/Q41266200',
    'http://www.wikidata.org/entity/Q41283370',
    'http://www.wikidata.org/entity/Q41312267',
    'http://www.wikidata.org/entity/Q41318276',
    'http://www.wikidata.org/entity/Q41348687',
    'http://www.wikidata.org/entity/Q41369154',
    'http://www.wikidata.org/entity/Q41380315',
    'http://www.wikidata.org/entity/Q41417991',
    'http://www.wikidata.org/entity/Q41430673',
    'http://www.wikidata.org/entity/Q41459791',
    'http://www.wikidata.org/entity/Q41464259',
    'http://www.wikidata.org/entity/Q41470166',
    'http://www.wikidata.org/entity/Q41484123',
    'http://www.wikidata.org/entity/Q41507095',
    'http://www.wikidata.org/entity/Q41522778',
    'http://www.wikidata.org/entity/Q41526116',
    'http://www.wikidata.org/entity/Q41529107',
    'http://www.wikidata.org/entity/Q41533751',
    'http://www.wikidata.org/entity/Q41536866',
    'http://www.wikidata.org/entity/Q41548586',
    'http://www.wikidata.org/entity/Q41557049',
    'http://www.wikidata.org/entity/Q41583629',
    'http://www.wikidata.org/entity/Q41584388',
    'http://www.wikidata.org/entity/Q41584587',
    'http://www.wikidata.org/entity/Q41584589',
    'http://www.wikidata.org/entity/Q41590321',
    'http://www.wikidata.org/entity/Q41593349',
    'http://www.wikidata.org/entity/Q41599688',
    'http://www.wikidata.org/entity/Q41613164',
    'http://www.wikidata.org/entity/Q41638422',
    'http://www.wikidata.org/entity/Q41659183',
    'http://www.wikidata.org/entity/Q41674216',
    'http://www.wikidata.org/entity/Q41674629',
    'http://www.wikidata.org/entity/Q41696958',
    'http://www.wikidata.org/entity/Q41721876',
    'http://www.wikidata.org/entity/Q41729082',
    'http://www.wikidata.org/entity/Q41772215',
    'http://www.wikidata.org/entity/Q41778370',
    'http://www.wikidata.org/entity/Q41788247',
    'http://www.wikidata.org/entity/Q41813383',
    'http://www.wikidata.org/entity/Q41813401',
    'http://www.wikidata.org/entity/Q41823449',
    'http://www.wikidata.org/entity/Q41838693',
    'http://www.wikidata.org/entity/Q41845137',
    'http://www.wikidata.org/entity/Q41845659',
    'http://www.wikidata.org/entity/Q41878022',
    'http://www.wikidata.org/entity/Q41878494',
    'http://www.wikidata.org/entity/Q41881644',
    'http://www.wikidata.org/entity/Q41896189',
    'http://www.wikidata.org/entity/Q41899936',
    'http://www.wikidata.org/entity/Q41910343',
    'http://www.wikidata.org/entity/Q41917506',
    'http://www.wikidata.org/entity/Q41920614',
    'http://www.wikidata.org/entity/Q41947277',
    'http://www.wikidata.org/entity/Q42044931',
    'http://www.wikidata.org/entity/Q42047023',
    'http://www.wikidata.org/entity/Q42055496',
    'http://www.wikidata.org/entity/Q42067412',
    'http://www.wikidata.org/entity/Q42094305',
    'http://www.wikidata.org/entity/Q42116477',
    'http://www.wikidata.org/entity/Q42118531',
    'http://www.wikidata.org/entity/Q42127905',
    'http://www.wikidata.org/entity/Q42132305',
    'http://www.wikidata.org/entity/Q42134282',
    'http://www.wikidata.org/entity/Q42138371',
    'http://www.wikidata.org/entity/Q42142202',
    'http://www.wikidata.org/entity/Q42169304',
    'http://www.wikidata.org/entity/Q42174255',
    'http://www.wikidata.org/entity/Q42183639',
    'http://www.wikidata.org/entity/Q42201029',
    'http://www.wikidata.org/entity/Q42217714',
    'http://www.wikidata.org/entity/Q42218235',
    'http://www.wikidata.org/entity/Q42225632',
    'http://www.wikidata.org/entity/Q42226756',
    'http://www.wikidata.org/entity/Q42226825',
    'http://www.wikidata.org/entity/Q42233078',
    'http://www.wikidata.org/entity/Q42249738',
    'http://www.wikidata.org/entity/Q42264535',
    'http://www.wikidata.org/entity/Q42289929',
    'http://www.wikidata.org/entity/Q42291137',
    'http://www.wikidata.org/entity/Q42292899',
    'http://www.wikidata.org/entity/Q42293368',
    'http://www.wikidata.org/entity/Q42305518',
    'http://www.wikidata.org/entity/Q42305702',
    'http://www.wikidata.org/entity/Q42305743',
    'http://www.wikidata.org/entity/Q42305768',
    'http://www.wikidata.org/entity/Q42305770',
    'http://www.wikidata.org/entity/Q42305790',
    'http://www.wikidata.org/entity/Q42305796',
    'http://www.wikidata.org/entity/Q42305988',
    'http://www.wikidata.org/entity/Q42306048',
    'http://www.wikidata.org/entity/Q42306074',
    'http://www.wikidata.org/entity/Q42314409',
    'http://www.wikidata.org/entity/Q42314586',
    'http://www.wikidata.org/entity/Q42317155',
    'http://www.wikidata.org/entity/Q42321857',
    'http://www.wikidata.org/entity/Q42322807',
    'http://www.wikidata.org/entity/Q42324980',
    'http://www.wikidata.org/entity/Q42326409',
    'http://www.wikidata.org/entity/Q42326677',
    'http://www.wikidata.org/entity/Q42334206',
    'http://www.wikidata.org/entity/Q42335489',
    'http://www.wikidata.org/entity/Q42342090',
    'http://www.wikidata.org/entity/Q42349305',
    'http://www.wikidata.org/entity/Q42355589',
    'http://www.wikidata.org/entity/Q42362603',
    'http://www.wikidata.org/entity/Q42365589',
    'http://www.wikidata.org/entity/Q42374687',
    'http://www.wikidata.org/entity/Q42383672',
    'http://www.wikidata.org/entity/Q42384442',
    'http://www.wikidata.org/entity/Q42391830',
    'http://www.wikidata.org/entity/Q42392436',
    'http://www.wikidata.org/entity/Q42399947',
    'http://www.wikidata.org/entity/Q42406209',
    'http://www.wikidata.org/entity/Q42407062',
    'http://www.wikidata.org/entity/Q42407146',
    'http://www.wikidata.org/entity/Q42407886',
    'http://www.wikidata.org/entity/Q42407887',
    'http://www.wikidata.org/entity/Q42412309',
    'http://www.wikidata.org/entity/Q42418807',
    'http://www.wikidata.org/entity/Q42425361',
    'http://www.wikidata.org/entity/Q42425494',
    'http://www.wikidata.org/entity/Q42425682',
    'http://www.wikidata.org/entity/Q42426997',
    'http://www.wikidata.org/entity/Q42430073',
    'http://www.wikidata.org/entity/Q42431793',
    'http://www.wikidata.org/entity/Q42432705',
    'http://www.wikidata.org/entity/Q42433498',
    'http://www.wikidata.org/entity/Q42434378',
    'http://www.wikidata.org/entity/Q42458179',
    'http://www.wikidata.org/entity/Q42482144',
    'http://www.wikidata.org/entity/Q42482187',
    'http://www.wikidata.org/entity/Q42494390',
    'http://www.wikidata.org/entity/Q42497991',
    'http://www.wikidata.org/entity/Q42521269',
    'http://www.wikidata.org/entity/Q42530445',
    'http://www.wikidata.org/entity/Q42533757',
    'http://www.wikidata.org/entity/Q42549799',
    'http://www.wikidata.org/entity/Q42551337',
    'http://www.wikidata.org/entity/Q42552797',
    'http://www.wikidata.org/entity/Q42555605',
    'http://www.wikidata.org/entity/Q42558515',
    'http://www.wikidata.org/entity/Q42571941',
    'http://www.wikidata.org/entity/Q42572197',
    'http://www.wikidata.org/entity/Q42574299',
    'http://www.wikidata.org/entity/Q42574302',
    'http://www.wikidata.org/entity/Q42576932',
    'http://www.wikidata.org/entity/Q42576981',
    'http://www.wikidata.org/entity/Q42577979',
    'http://www.wikidata.org/entity/Q42580129',
    'http://www.wikidata.org/entity/Q42586954',
    'http://www.wikidata.org/entity/Q42591886',
    'http://www.wikidata.org/entity/Q42592839',
    'http://www.wikidata.org/entity/Q42595404',
    'http://www.wikidata.org/entity/Q42595850',
    'http://www.wikidata.org/entity/Q42598676',
    'http://www.wikidata.org/entity/Q42602961',
    'http://www.wikidata.org/entity/Q42613009',
    'http://www.wikidata.org/entity/Q42614637',
    'http://www.wikidata.org/entity/Q42617487',
    'http://www.wikidata.org/entity/Q42623641',
    'http://www.wikidata.org/entity/Q42625166',
    'http://www.wikidata.org/entity/Q42643576',
    'http://www.wikidata.org/entity/Q42647269',
    'http://www.wikidata.org/entity/Q42647701',
    'http://www.wikidata.org/entity/Q42654598',
    'http://www.wikidata.org/entity/Q42656024',
    'http://www.wikidata.org/entity/Q42659242',
    'http://www.wikidata.org/entity/Q42664068',
    'http://www.wikidata.org/entity/Q42669883',
    'http://www.wikidata.org/entity/Q42689783',
    'http://www.wikidata.org/entity/Q42695907',
    'http://www.wikidata.org/entity/Q42696401',
    'http://www.wikidata.org/entity/Q42698968',
    'http://www.wikidata.org/entity/Q42699729',
    'http://www.wikidata.org/entity/Q42701344',
    'http://www.wikidata.org/entity/Q42701521',
    'http://www.wikidata.org/entity/Q42702081',
    'http://www.wikidata.org/entity/Q42703405',
    'http://www.wikidata.org/entity/Q42703812',
    'http://www.wikidata.org/entity/Q42712557',
    'http://www.wikidata.org/entity/Q42714101',
    'http://www.wikidata.org/entity/Q42725529',
    'http://www.wikidata.org/entity/Q42725577',
    'http://www.wikidata.org/entity/Q42728806',
    'http://www.wikidata.org/entity/Q42734915',
    'http://www.wikidata.org/entity/Q42737998',
    'http://www.wikidata.org/entity/Q42748966',
    'http://www.wikidata.org/entity/Q42757038',
    'http://www.wikidata.org/entity/Q42762752',
    'http://www.wikidata.org/entity/Q42788703',
    'http://www.wikidata.org/entity/Q42796646',
    'http://www.wikidata.org/entity/Q42798499',
    'http://www.wikidata.org/entity/Q42831833',
    'http://www.wikidata.org/entity/Q42838417',
    'http://www.wikidata.org/entity/Q42846212',
    'http://www.wikidata.org/entity/Q42859723',
    'http://www.wikidata.org/entity/Q42862244',
    'http://www.wikidata.org/entity/Q42878762',
    'http://www.wikidata.org/entity/Q42883335',
    'http://www.wikidata.org/entity/Q42888203',
    'http://www.wikidata.org/entity/Q42891634',
    'http://www.wikidata.org/entity/Q4291013',
    'http://www.wikidata.org/entity/Q42915359',
    'http://www.wikidata.org/entity/Q42932552',
    'http://www.wikidata.org/entity/Q42946335',
    'http://www.wikidata.org/entity/Q42947628',
    'http://www.wikidata.org/entity/Q43005750',
    'http://www.wikidata.org/entity/Q43007829',
    'http://www.wikidata.org/entity/Q43029565',
    'http://www.wikidata.org/entity/Q43062546',
    'http://www.wikidata.org/entity/Q43073840',
    'http://www.wikidata.org/entity/Q43074378',
    'http://www.wikidata.org/entity/Q43094042',
    'http://www.wikidata.org/entity/Q43098269',
    'http://www.wikidata.org/entity/Q43099579',
    'http://www.wikidata.org/entity/Q43119760',
    'http://www.wikidata.org/entity/Q43124102',
    'http://www.wikidata.org/entity/Q43136345',
    'http://www.wikidata.org/entity/Q43145446',
    'http://www.wikidata.org/entity/Q43157198',
    'http://www.wikidata.org/entity/Q43161913',
    'http://www.wikidata.org/entity/Q43162643',
    'http://www.wikidata.org/entity/Q43166091',
    'http://www.wikidata.org/entity/Q43184302',
    'http://www.wikidata.org/entity/Q43185278',
    'http://www.wikidata.org/entity/Q43188834',
    'http://www.wikidata.org/entity/Q43191125',
    'http://www.wikidata.org/entity/Q43196929',
    'http://www.wikidata.org/entity/Q43222898',
    'http://www.wikidata.org/entity/Q43249705',
    'http://www.wikidata.org/entity/Q43249984',
    'http://www.wikidata.org/entity/Q43252014',
    'http://www.wikidata.org/entity/Q43258192',
    'http://www.wikidata.org/entity/Q43269911',
    'http://www.wikidata.org/entity/Q43272535',
    'http://www.wikidata.org/entity/Q43272749',
    'http://www.wikidata.org/entity/Q43273047',
    'http://www.wikidata.org/entity/Q43297739',
    'http://www.wikidata.org/entity/Q43299345',
    'http://www.wikidata.org/entity/Q43369501',
    'http://www.wikidata.org/entity/Q43375842',
    'http://www.wikidata.org/entity/Q43399614',
    'http://www.wikidata.org/entity/Q43414494',
    'http://www.wikidata.org/entity/Q43420926',
    'http://www.wikidata.org/entity/Q43427856',
    'http://www.wikidata.org/entity/Q43508137',
    'http://www.wikidata.org/entity/Q43530123',
    'http://www.wikidata.org/entity/Q43550393',
    'http://www.wikidata.org/entity/Q43602682',
    'http://www.wikidata.org/entity/Q43613053',
    'http://www.wikidata.org/entity/Q43643566',
    'http://www.wikidata.org/entity/Q43665860',
    'http://www.wikidata.org/entity/Q43809750',
    'http://www.wikidata.org/entity/Q43857421',
    'http://www.wikidata.org/entity/Q43864655',
    'http://www.wikidata.org/entity/Q43900549',
    'http://www.wikidata.org/entity/Q43933456',
    'http://www.wikidata.org/entity/Q43947889',
    'http://www.wikidata.org/entity/Q44016653',
    'http://www.wikidata.org/entity/Q44024347',
    'http://www.wikidata.org/entity/Q44041398',
    'http://www.wikidata.org/entity/Q44045637',
    'http://www.wikidata.org/entity/Q44066308',
    'http://www.wikidata.org/entity/Q44074321',
    'http://www.wikidata.org/entity/Q44078623',
    'http://www.wikidata.org/entity/Q44168464',
    'http://www.wikidata.org/entity/Q44172566',
    'http://www.wikidata.org/entity/Q44200654',
    'http://www.wikidata.org/entity/Q44227537',
    'http://www.wikidata.org/entity/Q44274855',
    'http://www.wikidata.org/entity/Q44343351',
    'http://www.wikidata.org/entity/Q44423686',
    'http://www.wikidata.org/entity/Q44431641',
    'http://www.wikidata.org/entity/Q44481764',
    'http://www.wikidata.org/entity/Q44481779',
    'http://www.wikidata.org/entity/Q44564002',
    'http://www.wikidata.org/entity/Q44635657',
    'http://www.wikidata.org/entity/Q44682954',
    'http://www.wikidata.org/entity/Q44797022',
    'http://www.wikidata.org/entity/Q44813108',
    'http://www.wikidata.org/entity/Q448512',
    'http://www.wikidata.org/entity/Q44931654',
    'http://www.wikidata.org/entity/Q44953390',
    'http://www.wikidata.org/entity/Q44958229',
    'http://www.wikidata.org/entity/Q45304807',
    'http://www.wikidata.org/entity/Q45347453',
    'http://www.wikidata.org/entity/Q45354617',
    'http://www.wikidata.org/entity/Q45371764',
    'http://www.wikidata.org/entity/Q45397326',
    'http://www.wikidata.org/entity/Q45660395',
    'http://www.wikidata.org/entity/Q45671710',
    'http://www.wikidata.org/entity/Q4573501',
    'http://www.wikidata.org/entity/Q45773073',
    'http://www.wikidata.org/entity/Q45791880',
    'http://www.wikidata.org/entity/Q457967',
    'http://www.wikidata.org/entity/Q4583003',
    'http://www.wikidata.org/entity/Q45860413',
    'http://www.wikidata.org/entity/Q45876704',
    'http://www.wikidata.org/entity/Q45903512',
    'http://www.wikidata.org/entity/Q45904300',
    'http://www.wikidata.org/entity/Q45909111',
    'http://www.wikidata.org/entity/Q45913613',
    'http://www.wikidata.org/entity/Q45955550',
    'http://www.wikidata.org/entity/Q45958912',
    'http://www.wikidata.org/entity/Q46002363',
    'http://www.wikidata.org/entity/Q46003804',
    'http://www.wikidata.org/entity/Q46035237',
    'http://www.wikidata.org/entity/Q46050523',
    'http://www.wikidata.org/entity/Q46054072',
    'http://www.wikidata.org/entity/Q46090938',
    'http://www.wikidata.org/entity/Q46107172',
    'http://www.wikidata.org/entity/Q46115021',
    'http://www.wikidata.org/entity/Q46155812',
    'http://www.wikidata.org/entity/Q46155909',
    'http://www.wikidata.org/entity/Q46161972',
    'http://www.wikidata.org/entity/Q46205941',
    'http://www.wikidata.org/entity/Q46245773',
    'http://www.wikidata.org/entity/Q46249399',
    'http://www.wikidata.org/entity/Q46423864',
    'http://www.wikidata.org/entity/Q46474398',
    'http://www.wikidata.org/entity/Q46484636',
    'http://www.wikidata.org/entity/Q46574285',
    'http://www.wikidata.org/entity/Q46601108',
    'http://www.wikidata.org/entity/Q46630268',
    'http://www.wikidata.org/entity/Q4663555',
    'http://www.wikidata.org/entity/Q46643879',
    'http://www.wikidata.org/entity/Q46695778',
    'http://www.wikidata.org/entity/Q46730140',
    'http://www.wikidata.org/entity/Q46730807',
    'http://www.wikidata.org/entity/Q46740441',
    'http://www.wikidata.org/entity/Q46863719',
    'http://www.wikidata.org/entity/Q46915135',
    'http://www.wikidata.org/entity/Q46935730',
    'http://www.wikidata.org/entity/Q46942445',
    'http://www.wikidata.org/entity/Q46943072',
    'http://www.wikidata.org/entity/Q46961827',
    'http://www.wikidata.org/entity/Q46978152',
    'http://www.wikidata.org/entity/Q469904',
    'http://www.wikidata.org/entity/Q47007246',
    'http://www.wikidata.org/entity/Q47007270',
    'http://www.wikidata.org/entity/Q47013811',
    'http://www.wikidata.org/entity/Q47014167',
    'http://www.wikidata.org/entity/Q47014258',
    'http://www.wikidata.org/entity/Q47014266',
    'http://www.wikidata.org/entity/Q47083123',
    'http://www.wikidata.org/entity/Q47087451',
    'http://www.wikidata.org/entity/Q4714332',
    'http://www.wikidata.org/entity/Q4714442',
    'http://www.wikidata.org/entity/Q47146705',
    'http://www.wikidata.org/entity/Q47149235',
    'http://www.wikidata.org/entity/Q47156571',
    'http://www.wikidata.org/entity/Q47157894',
    'http://www.wikidata.org/entity/Q47159504',
    'http://www.wikidata.org/entity/Q47161409',
    'http://www.wikidata.org/entity/Q47161413',
    'http://www.wikidata.org/entity/Q47164710',
    'http://www.wikidata.org/entity/Q47168189',
    'http://www.wikidata.org/entity/Q47171583',
    'http://www.wikidata.org/entity/Q47179127',
    'http://www.wikidata.org/entity/Q47205948',
    'http://www.wikidata.org/entity/Q47234019',
    'http://www.wikidata.org/entity/Q4723845',
    'http://www.wikidata.org/entity/Q47242588',
    'http://www.wikidata.org/entity/Q4724944',
    'http://www.wikidata.org/entity/Q47249781',
    'http://www.wikidata.org/entity/Q47262835',
    'http://www.wikidata.org/entity/Q47265013',
    'http://www.wikidata.org/entity/Q4726678',
    'http://www.wikidata.org/entity/Q47267816',
    'http://www.wikidata.org/entity/Q47272070',
    'http://www.wikidata.org/entity/Q47272078',
    'http://www.wikidata.org/entity/Q47321195',
    'http://www.wikidata.org/entity/Q47325875',
    'http://www.wikidata.org/entity/Q47337660',
    'http://www.wikidata.org/entity/Q47344174',
    'http://www.wikidata.org/entity/Q47356567',
    'http://www.wikidata.org/entity/Q47367042',
    'http://www.wikidata.org/entity/Q47367473',
    'http://www.wikidata.org/entity/Q47377903',
    'http://www.wikidata.org/entity/Q4738819',
    'http://www.wikidata.org/entity/Q47392947',
    'http://www.wikidata.org/entity/Q47451221',
    'http://www.wikidata.org/entity/Q47452544',
    'http://www.wikidata.org/entity/Q47492209',
    'http://www.wikidata.org/entity/Q47493725',
    'http://www.wikidata.org/entity/Q47498758',
    'http://www.wikidata.org/entity/Q47499088',
    'http://www.wikidata.org/entity/Q47501298',
    'http://www.wikidata.org/entity/Q47502447',
    'http://www.wikidata.org/entity/Q47502687',
    'http://www.wikidata.org/entity/Q47503005',
    'http://www.wikidata.org/entity/Q47503095',
    'http://www.wikidata.org/entity/Q47503486',
    'http://www.wikidata.org/entity/Q47503663',
    'http://www.wikidata.org/entity/Q47503879',
    'http://www.wikidata.org/entity/Q47503909',
    'http://www.wikidata.org/entity/Q47504017',
    'http://www.wikidata.org/entity/Q47504039',
    'http://www.wikidata.org/entity/Q47504128',
    'http://www.wikidata.org/entity/Q47504379',
    'http://www.wikidata.org/entity/Q47504417',
    'http://www.wikidata.org/entity/Q47504540',
    'http://www.wikidata.org/entity/Q47532475',
    'http://www.wikidata.org/entity/Q4753847',
    'http://www.wikidata.org/entity/Q47543328',
    'http://www.wikidata.org/entity/Q4755471',
    'http://www.wikidata.org/entity/Q4757729',
    'http://www.wikidata.org/entity/Q4758591',
    'http://www.wikidata.org/entity/Q47600878',
    'http://www.wikidata.org/entity/Q4762579',
    'http://www.wikidata.org/entity/Q47645497',
    'http://www.wikidata.org/entity/Q47697949',
    'http://www.wikidata.org/entity/Q47698773',
    'http://www.wikidata.org/entity/Q47702564',
    'http://www.wikidata.org/entity/Q47703124',
    'http://www.wikidata.org/entity/Q47703366',
    'http://www.wikidata.org/entity/Q47704055',
    'http://www.wikidata.org/entity/Q47704315',
    'http://www.wikidata.org/entity/Q47705879',
    'http://www.wikidata.org/entity/Q47706102',
    'http://www.wikidata.org/entity/Q47709957',
    'http://www.wikidata.org/entity/Q47710725',
    'http://www.wikidata.org/entity/Q47745212',
    'http://www.wikidata.org/entity/Q4776661',
    'http://www.wikidata.org/entity/Q47805431',
    'http://www.wikidata.org/entity/Q47805453',
    'http://www.wikidata.org/entity/Q47808556',
    'http://www.wikidata.org/entity/Q47809492',
    'http://www.wikidata.org/entity/Q47810394',
    'http://www.wikidata.org/entity/Q47812749',
    'http://www.wikidata.org/entity/Q47825425',
    'http://www.wikidata.org/entity/Q47867487',
    'http://www.wikidata.org/entity/Q47874711',
    'http://www.wikidata.org/entity/Q47903854',
    'http://www.wikidata.org/entity/Q4793409',
    'http://www.wikidata.org/entity/Q4793714',
    'http://www.wikidata.org/entity/Q4795006',
    'http://www.wikidata.org/entity/Q48017488',
    'http://www.wikidata.org/entity/Q48067174',
    'http://www.wikidata.org/entity/Q48067656',
    'http://www.wikidata.org/entity/Q48068705',
    'http://www.wikidata.org/entity/Q48086103',
    'http://www.wikidata.org/entity/Q48106268',
    'http://www.wikidata.org/entity/Q48110196',
    'http://www.wikidata.org/entity/Q48131182',
    'http://www.wikidata.org/entity/Q48165776',
    'http://www.wikidata.org/entity/Q4818772',
    'http://www.wikidata.org/entity/Q48208397',
    'http://www.wikidata.org/entity/Q48287171',
    'http://www.wikidata.org/entity/Q4829027',
    'http://www.wikidata.org/entity/Q4830364',
    'http://www.wikidata.org/entity/Q48342908',
    'http://www.wikidata.org/entity/Q48356058',
    'http://www.wikidata.org/entity/Q4841852',
    'http://www.wikidata.org/entity/Q48467582',
    'http://www.wikidata.org/entity/Q4859279',
    'http://www.wikidata.org/entity/Q4865062',
    'http://www.wikidata.org/entity/Q4865631',
    'http://www.wikidata.org/entity/Q48806407',
    'http://www.wikidata.org/entity/Q48808732',
    'http://www.wikidata.org/entity/Q4888433',
    'http://www.wikidata.org/entity/Q4893595',
    'http://www.wikidata.org/entity/Q4894212',
    'http://www.wikidata.org/entity/Q49168510',
    'http://www.wikidata.org/entity/Q49238133',
    'http://www.wikidata.org/entity/Q4963885',
    'http://www.wikidata.org/entity/Q49858632',
    'http://www.wikidata.org/entity/Q49905192',
    'http://www.wikidata.org/entity/Q4991085',
    'http://www.wikidata.org/entity/Q49943995',
    'http://www.wikidata.org/entity/Q49996439',
    'http://www.wikidata.org/entity/Q50039778',
    'http://www.wikidata.org/entity/Q50277683',
    'http://www.wikidata.org/entity/Q50285668',
    'http://www.wikidata.org/entity/Q50285669',
    'http://www.wikidata.org/entity/Q50332851',
    'http://www.wikidata.org/entity/Q50345544',
    'http://www.wikidata.org/entity/Q504021',
    'http://www.wikidata.org/entity/Q50577322',
    'http://www.wikidata.org/entity/Q50585710',
    'http://www.wikidata.org/entity/Q505876',
    'http://www.wikidata.org/entity/Q50617525',
    'http://www.wikidata.org/entity/Q50620445',
    'http://www.wikidata.org/entity/Q50636340',
    'http://www.wikidata.org/entity/Q50639680',
    'http://www.wikidata.org/entity/Q50659957',
    'http://www.wikidata.org/entity/Q50723416',
    'http://www.wikidata.org/entity/Q50761111',
    'http://www.wikidata.org/entity/Q50848345',
    'http://www.wikidata.org/entity/Q50848927',
    'http://www.wikidata.org/entity/Q50911059',
    'http://www.wikidata.org/entity/Q50923597',
    'http://www.wikidata.org/entity/Q5092682',
    'http://www.wikidata.org/entity/Q50946862',
    'http://www.wikidata.org/entity/Q50976258',
    'http://www.wikidata.org/entity/Q510206',
    'http://www.wikidata.org/entity/Q51025201',
    'http://www.wikidata.org/entity/Q51053608',
    'http://www.wikidata.org/entity/Q51066788',
    'http://www.wikidata.org/entity/Q5107785',
    'http://www.wikidata.org/entity/Q51092200',
    'http://www.wikidata.org/entity/Q51103426',
    'http://www.wikidata.org/entity/Q51118358',
    'http://www.wikidata.org/entity/Q5111990',
    'http://www.wikidata.org/entity/Q51120582',
    'http://www.wikidata.org/entity/Q5112251',
    'http://www.wikidata.org/entity/Q51123729',
    'http://www.wikidata.org/entity/Q51130517',
    'http://www.wikidata.org/entity/Q51134597',
    'http://www.wikidata.org/entity/Q5113577',
    'http://www.wikidata.org/entity/Q51142479',
    'http://www.wikidata.org/entity/Q51195550',
    'http://www.wikidata.org/entity/Q51269909',
    'http://www.wikidata.org/entity/Q51283820',
    'http://www.wikidata.org/entity/Q51294604',
    'http://www.wikidata.org/entity/Q51439504',
    'http://www.wikidata.org/entity/Q51505621',
    'http://www.wikidata.org/entity/Q515364',
    'http://www.wikidata.org/entity/Q51557762',
    'http://www.wikidata.org/entity/Q516521',
    'http://www.wikidata.org/entity/Q51662715',
    'http://www.wikidata.org/entity/Q51690278',
    'http://www.wikidata.org/entity/Q51706465',
    'http://www.wikidata.org/entity/Q51708961',
    'http://www.wikidata.org/entity/Q51732004',
    'http://www.wikidata.org/entity/Q51742719',
    'http://www.wikidata.org/entity/Q51744546',
    'http://www.wikidata.org/entity/Q51766178',
    'http://www.wikidata.org/entity/Q51775643',
    'http://www.wikidata.org/entity/Q51778669',
    'http://www.wikidata.org/entity/Q51837299',
    'http://www.wikidata.org/entity/Q51846974',
    'http://www.wikidata.org/entity/Q51900818',
    'http://www.wikidata.org/entity/Q51905718',
    'http://www.wikidata.org/entity/Q5191546',
    'http://www.wikidata.org/entity/Q51931782',
    'http://www.wikidata.org/entity/Q5200110',
    'http://www.wikidata.org/entity/Q52088891',
    'http://www.wikidata.org/entity/Q52094500',
    'http://www.wikidata.org/entity/Q520992',
    'http://www.wikidata.org/entity/Q5213742',
    'http://www.wikidata.org/entity/Q52147710',
    'http://www.wikidata.org/entity/Q52159103',
    'http://www.wikidata.org/entity/Q5217119',
    'http://www.wikidata.org/entity/Q5221159',
    'http://www.wikidata.org/entity/Q52235585',
    'http://www.wikidata.org/entity/Q52280048',
    'http://www.wikidata.org/entity/Q5229885',
    'http://www.wikidata.org/entity/Q5230746',
    'http://www.wikidata.org/entity/Q5233311',
    'http://www.wikidata.org/entity/Q5234055',
    'http://www.wikidata.org/entity/Q5235558',
    'http://www.wikidata.org/entity/Q5238846',
    'http://www.wikidata.org/entity/Q5239645',
    'http://www.wikidata.org/entity/Q52422599',
    'http://www.wikidata.org/entity/Q52431492',
    'http://www.wikidata.org/entity/Q52448430',
    'http://www.wikidata.org/entity/Q52509909',
    'http://www.wikidata.org/entity/Q52561006',
    'http://www.wikidata.org/entity/Q52577914',
    'http://www.wikidata.org/entity/Q52683245',
    'http://www.wikidata.org/entity/Q52717443',
    'http://www.wikidata.org/entity/Q5274187',
    'http://www.wikidata.org/entity/Q52931455',
    'http://www.wikidata.org/entity/Q5298740',
    'http://www.wikidata.org/entity/Q5300242',
    'http://www.wikidata.org/entity/Q5301922',
    'http://www.wikidata.org/entity/Q53027419',
    'http://www.wikidata.org/entity/Q53059518',
    'http://www.wikidata.org/entity/Q53081088',
    'http://www.wikidata.org/entity/Q53394076',
    'http://www.wikidata.org/entity/Q53457475',
    'http://www.wikidata.org/entity/Q53475307',
    'http://www.wikidata.org/entity/Q53506120',
    'http://www.wikidata.org/entity/Q53506796',
    'http://www.wikidata.org/entity/Q53534777',
    'http://www.wikidata.org/entity/Q53680127',
    'http://www.wikidata.org/entity/Q53680267',
    'http://www.wikidata.org/entity/Q53731361',
    'http://www.wikidata.org/entity/Q53843801',
    'http://www.wikidata.org/entity/Q53843820',
    'http://www.wikidata.org/entity/Q5386338',
    'http://www.wikidata.org/entity/Q5386498',
    'http://www.wikidata.org/entity/Q5386788',
    'http://www.wikidata.org/entity/Q5387331',
    'http://www.wikidata.org/entity/Q5387640',
    'http://www.wikidata.org/entity/Q5392530',
    'http://www.wikidata.org/entity/Q5398061',
    'http://www.wikidata.org/entity/Q54006519',
    'http://www.wikidata.org/entity/Q54006941',
    'http://www.wikidata.org/entity/Q54008242',
    'http://www.wikidata.org/entity/Q54029065',
    'http://www.wikidata.org/entity/Q5404558',
    'http://www.wikidata.org/entity/Q54067420',
    'http://www.wikidata.org/entity/Q5415063',
    'http://www.wikidata.org/entity/Q54188848',
    'http://www.wikidata.org/entity/Q54196156',
    'http://www.wikidata.org/entity/Q54209622',
    'http://www.wikidata.org/entity/Q54230575',
    'http://www.wikidata.org/entity/Q54239361',
    'http://www.wikidata.org/entity/Q54241891',
    'http://www.wikidata.org/entity/Q54283626',
    'http://www.wikidata.org/entity/Q54303306',
    'http://www.wikidata.org/entity/Q54323544',
    'http://www.wikidata.org/entity/Q54394',
    'http://www.wikidata.org/entity/Q54404820',
    'http://www.wikidata.org/entity/Q54438194',
    'http://www.wikidata.org/entity/Q54475261',
    'http://www.wikidata.org/entity/Q54487968',
    'http://www.wikidata.org/entity/Q54605007',
    'http://www.wikidata.org/entity/Q54627337',
    'http://www.wikidata.org/entity/Q54635423',
    'http://www.wikidata.org/entity/Q54643363',
    'http://www.wikidata.org/entity/Q54656098',
    'http://www.wikidata.org/entity/Q5469096',
    'http://www.wikidata.org/entity/Q54801742',
    'http://www.wikidata.org/entity/Q54802124',
    'http://www.wikidata.org/entity/Q54802168',
    'http://www.wikidata.org/entity/Q54818249',
    'http://www.wikidata.org/entity/Q54954109',
    'http://www.wikidata.org/entity/Q54957698',
    'http://www.wikidata.org/entity/Q54958038',
    'http://www.wikidata.org/entity/Q54963541',
    'http://www.wikidata.org/entity/Q55030523',
    'http://www.wikidata.org/entity/Q55060859',
    'http://www.wikidata.org/entity/Q550833',
    'http://www.wikidata.org/entity/Q55086978',
    'http://www.wikidata.org/entity/Q55091681',
    'http://www.wikidata.org/entity/Q55098484',
    'http://www.wikidata.org/entity/Q55130377',
    'http://www.wikidata.org/entity/Q55136897',
    'http://www.wikidata.org/entity/Q55154446',
    'http://www.wikidata.org/entity/Q5515719',
    'http://www.wikidata.org/entity/Q55174556',
    'http://www.wikidata.org/entity/Q55174835',
    'http://www.wikidata.org/entity/Q55174838',
    'http://www.wikidata.org/entity/Q55174927',
    'http://www.wikidata.org/entity/Q55176139',
    'http://www.wikidata.org/entity/Q55205960',
    'http://www.wikidata.org/entity/Q55206472',
    'http://www.wikidata.org/entity/Q55207459',
    'http://www.wikidata.org/entity/Q55209159',
    'http://www.wikidata.org/entity/Q55215113',
    'http://www.wikidata.org/entity/Q55230980',
    'http://www.wikidata.org/entity/Q55232471',
    'http://www.wikidata.org/entity/Q55232846',
    'http://www.wikidata.org/entity/Q55233350',
    'http://www.wikidata.org/entity/Q55271568',
    'http://www.wikidata.org/entity/Q55277832',
    'http://www.wikidata.org/entity/Q55278809',
    'http://www.wikidata.org/entity/Q55296508',
    'http://www.wikidata.org/entity/Q55300055',
    'http://www.wikidata.org/entity/Q55300102',
    'http://www.wikidata.org/entity/Q55314071',
    'http://www.wikidata.org/entity/Q5534494',
    'http://www.wikidata.org/entity/Q55345261',
    'http://www.wikidata.org/entity/Q55362900',
    'http://www.wikidata.org/entity/Q55404027',
    'http://www.wikidata.org/entity/Q55404660',
    'http://www.wikidata.org/entity/Q5541413',
    'http://www.wikidata.org/entity/Q5542230',
    'http://www.wikidata.org/entity/Q55426351',
    'http://www.wikidata.org/entity/Q5543353',
    'http://www.wikidata.org/entity/Q5543595',
    'http://www.wikidata.org/entity/Q55437593',
    'http://www.wikidata.org/entity/Q5544506',
    'http://www.wikidata.org/entity/Q55446034',
    'http://www.wikidata.org/entity/Q55446277',
    'http://www.wikidata.org/entity/Q55446285',
    'http://www.wikidata.org/entity/Q55454936',
    'http://www.wikidata.org/entity/Q55457923',
    'http://www.wikidata.org/entity/Q55473044',
    'http://www.wikidata.org/entity/Q55473327',
    'http://www.wikidata.org/entity/Q5548822',
    'http://www.wikidata.org/entity/Q5550618',
    'http://www.wikidata.org/entity/Q55523364',
    'http://www.wikidata.org/entity/Q55536098',
    'http://www.wikidata.org/entity/Q55536140',
    'http://www.wikidata.org/entity/Q55545039',
    'http://www.wikidata.org/entity/Q5559617',
    'http://www.wikidata.org/entity/Q5562196',
    'http://www.wikidata.org/entity/Q55686122',
    'http://www.wikidata.org/entity/Q55690446',
    'http://www.wikidata.org/entity/Q55719625',
    'http://www.wikidata.org/entity/Q55723659',
    'http://www.wikidata.org/entity/Q5572854',
    'http://www.wikidata.org/entity/Q55743468',
    'http://www.wikidata.org/entity/Q55762440',
    'http://www.wikidata.org/entity/Q55762444',
    'http://www.wikidata.org/entity/Q55778919',
    'http://www.wikidata.org/entity/Q55807541',
    'http://www.wikidata.org/entity/Q55815903',
    'http://www.wikidata.org/entity/Q55835077',
    'http://www.wikidata.org/entity/Q5585214',
    'http://www.wikidata.org/entity/Q55908210',
    'http://www.wikidata.org/entity/Q5592728',
    'http://www.wikidata.org/entity/Q55948266',
    'http://www.wikidata.org/entity/Q55950471',
    'http://www.wikidata.org/entity/Q55950716',
    'http://www.wikidata.org/entity/Q55950718',
    'http://www.wikidata.org/entity/Q55965683',
    'http://www.wikidata.org/entity/Q56027743',
    'http://www.wikidata.org/entity/Q56057073',
    'http://www.wikidata.org/entity/Q56065756',
    'http://www.wikidata.org/entity/Q56068',
    'http://www.wikidata.org/entity/Q56074818',
    'http://www.wikidata.org/entity/Q56090410',
    'http://www.wikidata.org/entity/Q56099781',
    'http://www.wikidata.org/entity/Q5610125',
    'http://www.wikidata.org/entity/Q56190',
    'http://www.wikidata.org/entity/Q5619162',
    'http://www.wikidata.org/entity/Q56192531',
    'http://www.wikidata.org/entity/Q56229906',
    'http://www.wikidata.org/entity/Q56239497',
    'http://www.wikidata.org/entity/Q56245986',
    'http://www.wikidata.org/entity/Q56261169',
    'http://www.wikidata.org/entity/Q56273613',
    'http://www.wikidata.org/entity/Q56274801',
    'http://www.wikidata.org/entity/Q56285657',
    'http://www.wikidata.org/entity/Q56331320',
    'http://www.wikidata.org/entity/Q56332432',
    'http://www.wikidata.org/entity/Q56332553',
    'http://www.wikidata.org/entity/Q56363858',
    'http://www.wikidata.org/entity/Q56378220',
    'http://www.wikidata.org/entity/Q56379022',
    'http://www.wikidata.org/entity/Q56379732',
    'http://www.wikidata.org/entity/Q56380873',
    'http://www.wikidata.org/entity/Q56380923',
    'http://www.wikidata.org/entity/Q56380976',
    'http://www.wikidata.org/entity/Q56381433',
    'http://www.wikidata.org/entity/Q56383875',
    'http://www.wikidata.org/entity/Q56394581',
    'http://www.wikidata.org/entity/Q56394641',
    'http://www.wikidata.org/entity/Q56394695',
    'http://www.wikidata.org/entity/Q56417107',
    'http://www.wikidata.org/entity/Q56418228',
    'http://www.wikidata.org/entity/Q56419243',
    'http://www.wikidata.org/entity/Q56419301',
    'http://www.wikidata.org/entity/Q56419420',
    'http://www.wikidata.org/entity/Q56419498',
    'http://www.wikidata.org/entity/Q56419717',
    'http://www.wikidata.org/entity/Q56419795',
    'http://www.wikidata.org/entity/Q56420294',
    'http://www.wikidata.org/entity/Q56420957',
    'http://www.wikidata.org/entity/Q56425974',
    'http://www.wikidata.org/entity/Q56430125',
    'http://www.wikidata.org/entity/Q56432880',
    'http://www.wikidata.org/entity/Q56447702',
    'http://www.wikidata.org/entity/Q56449890',
    'http://www.wikidata.org/entity/Q56450083',
    'http://www.wikidata.org/entity/Q56451880',
    'http://www.wikidata.org/entity/Q56451881',
    'http://www.wikidata.org/entity/Q56451901',
    'http://www.wikidata.org/entity/Q56452610',
    'http://www.wikidata.org/entity/Q56454849',
    'http://www.wikidata.org/entity/Q56454942',
    'http://www.wikidata.org/entity/Q56454988',
    'http://www.wikidata.org/entity/Q56457356',
    'http://www.wikidata.org/entity/Q56458621',
    'http://www.wikidata.org/entity/Q56460588',
    'http://www.wikidata.org/entity/Q56461511',
    'http://www.wikidata.org/entity/Q56479838',
    'http://www.wikidata.org/entity/Q56488012',
    'http://www.wikidata.org/entity/Q56517624',
    'http://www.wikidata.org/entity/Q56533682',
    'http://www.wikidata.org/entity/Q56543577',
    'http://www.wikidata.org/entity/Q56557641',
    'http://www.wikidata.org/entity/Q56560911',
    'http://www.wikidata.org/entity/Q56564114',
    'http://www.wikidata.org/entity/Q56597151',
    'http://www.wikidata.org/entity/Q56600018',
    'http://www.wikidata.org/entity/Q56604530',
    'http://www.wikidata.org/entity/Q56613348',
    'http://www.wikidata.org/entity/Q56614941',
    'http://www.wikidata.org/entity/Q56616406',
    'http://www.wikidata.org/entity/Q56633150',
    'http://www.wikidata.org/entity/Q56648717',
    'http://www.wikidata.org/entity/Q56650544',
    'http://www.wikidata.org/entity/Q56654208',
    'http://www.wikidata.org/entity/Q56677294',
    'http://www.wikidata.org/entity/Q56678768',
    'http://www.wikidata.org/entity/Q56685550',
    'http://www.wikidata.org/entity/Q56697676',
    'http://www.wikidata.org/entity/Q56704818',
    'http://www.wikidata.org/entity/Q56760979',
    'http://www.wikidata.org/entity/Q56772413',
    'http://www.wikidata.org/entity/Q5677307',
    'http://www.wikidata.org/entity/Q5677403',
    'http://www.wikidata.org/entity/Q56774786',
    'http://www.wikidata.org/entity/Q56777754',
    'http://www.wikidata.org/entity/Q56780488',
    'http://www.wikidata.org/entity/Q56792357',
    'http://www.wikidata.org/entity/Q56798439',
    'http://www.wikidata.org/entity/Q56798521',
    'http://www.wikidata.org/entity/Q56807965',
    'http://www.wikidata.org/entity/Q56810665',
    'http://www.wikidata.org/entity/Q56810690',
    'http://www.wikidata.org/entity/Q56815959',
    'http://www.wikidata.org/entity/Q56816879',
    'http://www.wikidata.org/entity/Q56825815',
    'http://www.wikidata.org/entity/Q56827171',
    'http://www.wikidata.org/entity/Q56839732',
    'http://www.wikidata.org/entity/Q56839763',
    'http://www.wikidata.org/entity/Q56839853',
    'http://www.wikidata.org/entity/Q56840297',
    'http://www.wikidata.org/entity/Q56841622',
    'http://www.wikidata.org/entity/Q56841861',
    'http://www.wikidata.org/entity/Q56850430',
    'http://www.wikidata.org/entity/Q56850440',
    'http://www.wikidata.org/entity/Q56850448',
    'http://www.wikidata.org/entity/Q56850486',
    'http://www.wikidata.org/entity/Q56850515',
    'http://www.wikidata.org/entity/Q56850580',
    'http://www.wikidata.org/entity/Q56852961',
    'http://www.wikidata.org/entity/Q56855135',
    'http://www.wikidata.org/entity/Q56855588',
    'http://www.wikidata.org/entity/Q56856236',
    'http://www.wikidata.org/entity/Q56861768',
    'http://www.wikidata.org/entity/Q56862825',
    'http://www.wikidata.org/entity/Q56863017',
    'http://www.wikidata.org/entity/Q56863190',
    'http://www.wikidata.org/entity/Q56864503',
    'http://www.wikidata.org/entity/Q56871310',
    'http://www.wikidata.org/entity/Q56871312',
    'http://www.wikidata.org/entity/Q56876774',
    'http://www.wikidata.org/entity/Q56885069',
    'http://www.wikidata.org/entity/Q56885285',
    'http://www.wikidata.org/entity/Q56886480',
    'http://www.wikidata.org/entity/Q56887227',
    'http://www.wikidata.org/entity/Q56896008',
    'http://www.wikidata.org/entity/Q56906396',
    'http://www.wikidata.org/entity/Q56912028',
    'http://www.wikidata.org/entity/Q56935612',
    'http://www.wikidata.org/entity/Q56936055',
    'http://www.wikidata.org/entity/Q56936660',
    'http://www.wikidata.org/entity/Q56950965',
    'http://www.wikidata.org/entity/Q56952634',
    'http://www.wikidata.org/entity/Q56953699',
    'http://www.wikidata.org/entity/Q56954279',
    'http://www.wikidata.org/entity/Q56957375',
    'http://www.wikidata.org/entity/Q56966508',
    'http://www.wikidata.org/entity/Q56985500',
    'http://www.wikidata.org/entity/Q56987848',
    'http://www.wikidata.org/entity/Q56988847',
    'http://www.wikidata.org/entity/Q56988961',
    'http://www.wikidata.org/entity/Q56990850',
    'http://www.wikidata.org/entity/Q56997698',
    'http://www.wikidata.org/entity/Q56999697',
    'http://www.wikidata.org/entity/Q56999987',
    'http://www.wikidata.org/entity/Q57006487',
    'http://www.wikidata.org/entity/Q57008272',
    'http://www.wikidata.org/entity/Q57008906',
    'http://www.wikidata.org/entity/Q57012884',
    'http://www.wikidata.org/entity/Q57015055',
    'http://www.wikidata.org/entity/Q57020237',
    'http://www.wikidata.org/entity/Q57021229',
    'http://www.wikidata.org/entity/Q57025338',
    'http://www.wikidata.org/entity/Q57039462',
    'http://www.wikidata.org/entity/Q57052520',
    'http://www.wikidata.org/entity/Q57060699',
    'http://www.wikidata.org/entity/Q57062280',
    'http://www.wikidata.org/entity/Q57072151',
    'http://www.wikidata.org/entity/Q57073392',
    'http://www.wikidata.org/entity/Q57077698',
    'http://www.wikidata.org/entity/Q57078994',
    'http://www.wikidata.org/entity/Q57080970',
    'http://www.wikidata.org/entity/Q57081059',
    'http://www.wikidata.org/entity/Q57083376',
    'http://www.wikidata.org/entity/Q57087709',
    'http://www.wikidata.org/entity/Q57094822',
    'http://www.wikidata.org/entity/Q57095519',
    'http://www.wikidata.org/entity/Q57096345',
    'http://www.wikidata.org/entity/Q57100559',
    'http://www.wikidata.org/entity/Q57115257',
    'http://www.wikidata.org/entity/Q57116954',
    'http://www.wikidata.org/entity/Q57164086',
    'http://www.wikidata.org/entity/Q57195229',
    'http://www.wikidata.org/entity/Q57203217',
    'http://www.wikidata.org/entity/Q57232807',
    'http://www.wikidata.org/entity/Q57252951',
    'http://www.wikidata.org/entity/Q57259759',
    'http://www.wikidata.org/entity/Q57269588',
    'http://www.wikidata.org/entity/Q57288054',
    'http://www.wikidata.org/entity/Q57298292',
    'http://www.wikidata.org/entity/Q57303439',
    'http://www.wikidata.org/entity/Q57305547',
    'http://www.wikidata.org/entity/Q57316555',
    'http://www.wikidata.org/entity/Q57317305',
    'http://www.wikidata.org/entity/Q57320799',
    'http://www.wikidata.org/entity/Q573246',
    'http://www.wikidata.org/entity/Q57326656',
    'http://www.wikidata.org/entity/Q57328383',
    'http://www.wikidata.org/entity/Q57330018',
    'http://www.wikidata.org/entity/Q57330225',
    'http://www.wikidata.org/entity/Q57332397',
    'http://www.wikidata.org/entity/Q573389',
    'http://www.wikidata.org/entity/Q5740316',
    'http://www.wikidata.org/entity/Q57414706',
    'http://www.wikidata.org/entity/Q57414746',
    'http://www.wikidata.org/entity/Q57419364',
    'http://www.wikidata.org/entity/Q57423000',
    'http://www.wikidata.org/entity/Q57425849',
    'http://www.wikidata.org/entity/Q57425986',
    'http://www.wikidata.org/entity/Q57432563',
    'http://www.wikidata.org/entity/Q57447898',
    'http://www.wikidata.org/entity/Q57525101',
    'http://www.wikidata.org/entity/Q57551509',
    'http://www.wikidata.org/entity/Q57558116',
    'http://www.wikidata.org/entity/Q57570738',
    'http://www.wikidata.org/entity/Q57580775',
    'http://www.wikidata.org/entity/Q57641026',
    'http://www.wikidata.org/entity/Q57662855',
    'http://www.wikidata.org/entity/Q57687954',
    'http://www.wikidata.org/entity/Q57693390',
    'http://www.wikidata.org/entity/Q57695977',
    'http://www.wikidata.org/entity/Q57715733',
    'http://www.wikidata.org/entity/Q57796544',
    'http://www.wikidata.org/entity/Q57871505',
    'http://www.wikidata.org/entity/Q57874460',
    'http://www.wikidata.org/entity/Q57889447',
    'http://www.wikidata.org/entity/Q57889897',
    'http://www.wikidata.org/entity/Q57899870',
    'http://www.wikidata.org/entity/Q57911728',
    'http://www.wikidata.org/entity/Q57912848',
    'http://www.wikidata.org/entity/Q57913483',
    'http://www.wikidata.org/entity/Q57915484',
    'http://www.wikidata.org/entity/Q57934978',
    'http://www.wikidata.org/entity/Q58040497',
    'http://www.wikidata.org/entity/Q58046422',
    'http://www.wikidata.org/entity/Q58065844',
    'http://www.wikidata.org/entity/Q58068887',
    'http://www.wikidata.org/entity/Q58071709',
    'http://www.wikidata.org/entity/Q580803',
    'http://www.wikidata.org/entity/Q5811529',
    'http://www.wikidata.org/entity/Q58119603',
    'http://www.wikidata.org/entity/Q58121713',
    'http://www.wikidata.org/entity/Q58148798',
    'http://www.wikidata.org/entity/Q58209453',
    'http://www.wikidata.org/entity/Q58227745',
    'http://www.wikidata.org/entity/Q58252388',
    'http://www.wikidata.org/entity/Q58295323',
    'http://www.wikidata.org/entity/Q5830202',
    'http://www.wikidata.org/entity/Q58316583',
    'http://www.wikidata.org/entity/Q58323109',
    'http://www.wikidata.org/entity/Q58325156',
    'http://www.wikidata.org/entity/Q58326616',
    'http://www.wikidata.org/entity/Q58329375',
    'http://www.wikidata.org/entity/Q58371379',
    'http://www.wikidata.org/entity/Q583725',
    'http://www.wikidata.org/entity/Q58374621',
    'http://www.wikidata.org/entity/Q58459763',
    'http://www.wikidata.org/entity/Q58674010',
    'http://www.wikidata.org/entity/Q58677380',
    'http://www.wikidata.org/entity/Q58678552',
    'http://www.wikidata.org/entity/Q58685888',
    'http://www.wikidata.org/entity/Q58689309',
    'http://www.wikidata.org/entity/Q58815841',
    'http://www.wikidata.org/entity/Q58823749',
    'http://www.wikidata.org/entity/Q58841590',
    'http://www.wikidata.org/entity/Q58867501',
    'http://www.wikidata.org/entity/Q58870907',
    'http://www.wikidata.org/entity/Q58876158',
    'http://www.wikidata.org/entity/Q58888437',
    'http://www.wikidata.org/entity/Q58941021',
    'http://www.wikidata.org/entity/Q58949104',
    'http://www.wikidata.org/entity/Q58987399',
    'http://www.wikidata.org/entity/Q5912759',
    'http://www.wikidata.org/entity/Q59158946',
    'http://www.wikidata.org/entity/Q59163549',
    'http://www.wikidata.org/entity/Q59179623',
    'http://www.wikidata.org/entity/Q59193684',
    'http://www.wikidata.org/entity/Q59194517',
    'http://www.wikidata.org/entity/Q59210534',
    'http://www.wikidata.org/entity/Q59223164',
    'http://www.wikidata.org/entity/Q59275181',
    'http://www.wikidata.org/entity/Q59282063',
    'http://www.wikidata.org/entity/Q59314790',
    'http://www.wikidata.org/entity/Q59348768',
    'http://www.wikidata.org/entity/Q59435668',
    'http://www.wikidata.org/entity/Q59440413',
    'http://www.wikidata.org/entity/Q59441577',
    'http://www.wikidata.org/entity/Q59453900',
    'http://www.wikidata.org/entity/Q59501124',
    'http://www.wikidata.org/entity/Q59505994',
    'http://www.wikidata.org/entity/Q59538405',
    'http://www.wikidata.org/entity/Q59544365',
    'http://www.wikidata.org/entity/Q59553652',
    'http://www.wikidata.org/entity/Q59593777',
    'http://www.wikidata.org/entity/Q59641746',
    'http://www.wikidata.org/entity/Q59654343',
    'http://www.wikidata.org/entity/Q59660150',
    'http://www.wikidata.org/entity/Q59660391',
    'http://www.wikidata.org/entity/Q59662454',
    'http://www.wikidata.org/entity/Q59678161',
    'http://www.wikidata.org/entity/Q59682072',
    'http://www.wikidata.org/entity/Q59685637',
    'http://www.wikidata.org/entity/Q59692852',
    'http://www.wikidata.org/entity/Q59696572',
    'http://www.wikidata.org/entity/Q59698496',
    'http://www.wikidata.org/entity/Q59699835',
    'http://www.wikidata.org/entity/Q59705822',
    'http://www.wikidata.org/entity/Q59708828',
    'http://www.wikidata.org/entity/Q59752277',
    'http://www.wikidata.org/entity/Q59755238',
    'http://www.wikidata.org/entity/Q59765406',
    'http://www.wikidata.org/entity/Q59785509',
    'http://www.wikidata.org/entity/Q59812154',
    'http://www.wikidata.org/entity/Q59813011',
    'http://www.wikidata.org/entity/Q59817482',
    'http://www.wikidata.org/entity/Q59817484',
    'http://www.wikidata.org/entity/Q59830754',
    'http://www.wikidata.org/entity/Q59831451',
    'http://www.wikidata.org/entity/Q5983280',
    'http://www.wikidata.org/entity/Q59846369',
    'http://www.wikidata.org/entity/Q59880799',
    'http://www.wikidata.org/entity/Q59903179',
    'http://www.wikidata.org/entity/Q59908394',
    'http://www.wikidata.org/entity/Q59925740',
    'http://www.wikidata.org/entity/Q5993296',
    'http://www.wikidata.org/entity/Q59939141',
    'http://www.wikidata.org/entity/Q59976170',
    'http://www.wikidata.org/entity/Q59993174',
    'http://www.wikidata.org/entity/Q60016666',
    'http://www.wikidata.org/entity/Q60018876',
    'http://www.wikidata.org/entity/Q60027172',
    'http://www.wikidata.org/entity/Q60029509',
    'http://www.wikidata.org/entity/Q60031328',
    'http://www.wikidata.org/entity/Q60031943',
    'http://www.wikidata.org/entity/Q60032029',
    'http://www.wikidata.org/entity/Q60032286',
    'http://www.wikidata.org/entity/Q60032771',
    'http://www.wikidata.org/entity/Q60043791',
    'http://www.wikidata.org/entity/Q60043817',
    'http://www.wikidata.org/entity/Q60043835',
    'http://www.wikidata.org/entity/Q60043898',
    'http://www.wikidata.org/entity/Q60043950',
    'http://www.wikidata.org/entity/Q60044273',
    'http://www.wikidata.org/entity/Q60044507',
    'http://www.wikidata.org/entity/Q60048495',
    'http://www.wikidata.org/entity/Q60048789',
    'http://www.wikidata.org/entity/Q60048856',
    'http://www.wikidata.org/entity/Q60057788',
    'http://www.wikidata.org/entity/Q60059378',
    'http://www.wikidata.org/entity/Q60059386',
    'http://www.wikidata.org/entity/Q60060211',
    'http://www.wikidata.org/entity/Q60060712',
    'http://www.wikidata.org/entity/Q60061444',
    'http://www.wikidata.org/entity/Q60108',
    'http://www.wikidata.org/entity/Q60127341',
    'http://www.wikidata.org/entity/Q60144040',
    'http://www.wikidata.org/entity/Q60160510',
    'http://www.wikidata.org/entity/Q60176026',
    'http://www.wikidata.org/entity/Q60176093',
    'http://www.wikidata.org/entity/Q60194377',
    'http://www.wikidata.org/entity/Q60213447',
    'http://www.wikidata.org/entity/Q60213488',
    'http://www.wikidata.org/entity/Q60220360',
    'http://www.wikidata.org/entity/Q60227555',
    'http://www.wikidata.org/entity/Q60227625',
    'http://www.wikidata.org/entity/Q60227936',
    'http://www.wikidata.org/entity/Q60231547',
    'http://www.wikidata.org/entity/Q60243210',
    'http://www.wikidata.org/entity/Q6025968',
    'http://www.wikidata.org/entity/Q60268731',
    'http://www.wikidata.org/entity/Q60303019',
    'http://www.wikidata.org/entity/Q60318865',
    'http://www.wikidata.org/entity/Q60320900',
    'http://www.wikidata.org/entity/Q60321359',
    'http://www.wikidata.org/entity/Q60324489',
    'http://www.wikidata.org/entity/Q60327489',
    'http://www.wikidata.org/entity/Q60386359',
    'http://www.wikidata.org/entity/Q60393087',
    'http://www.wikidata.org/entity/Q60393320',
    'http://www.wikidata.org/entity/Q60393741',
    'http://www.wikidata.org/entity/Q60394248',
    'http://www.wikidata.org/entity/Q60394812',
    'http://www.wikidata.org/entity/Q60415973',
    'http://www.wikidata.org/entity/Q60417104',
    'http://www.wikidata.org/entity/Q60418097',
    'http://www.wikidata.org/entity/Q60429505',
    'http://www.wikidata.org/entity/Q60429811',
    'http://www.wikidata.org/entity/Q60429866',
    'http://www.wikidata.org/entity/Q60430405',
    'http://www.wikidata.org/entity/Q60431480',
    'http://www.wikidata.org/entity/Q60442596',
    'http://www.wikidata.org/entity/Q60451387',
    'http://www.wikidata.org/entity/Q60451763',
    'http://www.wikidata.org/entity/Q60457714',
    'http://www.wikidata.org/entity/Q60465926',
    'http://www.wikidata.org/entity/Q60467738',
    'http://www.wikidata.org/entity/Q60473788',
    'http://www.wikidata.org/entity/Q60489118',
    'http://www.wikidata.org/entity/Q60489346',
    'http://www.wikidata.org/entity/Q60489684',
    'http://www.wikidata.org/entity/Q60499915',
    'http://www.wikidata.org/entity/Q60499958',
    'http://www.wikidata.org/entity/Q60500113',
    'http://www.wikidata.org/entity/Q60500462',
    'http://www.wikidata.org/entity/Q60502430',
    'http://www.wikidata.org/entity/Q60502755',
    'http://www.wikidata.org/entity/Q60537481',
    'http://www.wikidata.org/entity/Q60541156',
    'http://www.wikidata.org/entity/Q60547381',
    'http://www.wikidata.org/entity/Q60550218',
    'http://www.wikidata.org/entity/Q60557129',
    'http://www.wikidata.org/entity/Q60557342',
    'http://www.wikidata.org/entity/Q60557491',
    'http://www.wikidata.org/entity/Q60557555',
    'http://www.wikidata.org/entity/Q60571091',
    'http://www.wikidata.org/entity/Q60572357',
    'http://www.wikidata.org/entity/Q60572448',
    'http://www.wikidata.org/entity/Q60573000',
    'http://www.wikidata.org/entity/Q60586209',
    'http://www.wikidata.org/entity/Q60589802',
    'http://www.wikidata.org/entity/Q60590121',
    'http://www.wikidata.org/entity/Q60606783',
    'http://www.wikidata.org/entity/Q60607806',
    'http://www.wikidata.org/entity/Q60607838',
    'http://www.wikidata.org/entity/Q60616491',
    'http://www.wikidata.org/entity/Q60622809',
    'http://www.wikidata.org/entity/Q60629770',
    'http://www.wikidata.org/entity/Q60634074',
    'http://www.wikidata.org/entity/Q60642067',
    'http://www.wikidata.org/entity/Q60644344',
    'http://www.wikidata.org/entity/Q60644631',
    'http://www.wikidata.org/entity/Q60644644',
    'http://www.wikidata.org/entity/Q60647167',
    'http://www.wikidata.org/entity/Q60649471',
    'http://www.wikidata.org/entity/Q60659843',
    'http://www.wikidata.org/entity/Q60674969',
    'http://www.wikidata.org/entity/Q60676174',
    'http://www.wikidata.org/entity/Q60684635',
    'http://www.wikidata.org/entity/Q60716338',
    'http://www.wikidata.org/entity/Q60723688',
    'http://www.wikidata.org/entity/Q6074204',
    'http://www.wikidata.org/entity/Q60820298',
    'http://www.wikidata.org/entity/Q60835422',
    'http://www.wikidata.org/entity/Q60879344',
    'http://www.wikidata.org/entity/Q60885159',
    'http://www.wikidata.org/entity/Q60908373',
    'http://www.wikidata.org/entity/Q60959176',
    'http://www.wikidata.org/entity/Q60960702',
    'http://www.wikidata.org/entity/Q60969800',
    'http://www.wikidata.org/entity/Q60974897',
    'http://www.wikidata.org/entity/Q60977114',
    'http://www.wikidata.org/entity/Q61050371',
    'http://www.wikidata.org/entity/Q61052060',
    'http://www.wikidata.org/entity/Q61052514',
    'http://www.wikidata.org/entity/Q61053270',
    'http://www.wikidata.org/entity/Q61060729',
    'http://www.wikidata.org/entity/Q61071114',
    'http://www.wikidata.org/entity/Q61078502',
    'http://www.wikidata.org/entity/Q61082017',
    'http://www.wikidata.org/entity/Q61084667',
    'http://www.wikidata.org/entity/Q61097173',
    'http://www.wikidata.org/entity/Q61108096',
    'http://www.wikidata.org/entity/Q61112866',
    'http://www.wikidata.org/entity/Q61123608',
    'http://www.wikidata.org/entity/Q61134450',
    'http://www.wikidata.org/entity/Q61139603',
    'http://www.wikidata.org/entity/Q61151498',
    'http://www.wikidata.org/entity/Q61157836',
    'http://www.wikidata.org/entity/Q61163991',
    'http://www.wikidata.org/entity/Q61188503',
    'http://www.wikidata.org/entity/Q61190143',
    'http://www.wikidata.org/entity/Q61245592',
    'http://www.wikidata.org/entity/Q61266127',
    'http://www.wikidata.org/entity/Q61332770',
    'http://www.wikidata.org/entity/Q61333709',
    'http://www.wikidata.org/entity/Q61337175',
    'http://www.wikidata.org/entity/Q6141679',
    'http://www.wikidata.org/entity/Q61448594',
    'http://www.wikidata.org/entity/Q61451544',
    'http://www.wikidata.org/entity/Q61465837',
    'http://www.wikidata.org/entity/Q61476062',
    'http://www.wikidata.org/entity/Q61643074',
    'http://www.wikidata.org/entity/Q61679249',
    'http://www.wikidata.org/entity/Q6175920',
    'http://www.wikidata.org/entity/Q6176064',
    'http://www.wikidata.org/entity/Q6176130',
    'http://www.wikidata.org/entity/Q61761312',
    'http://www.wikidata.org/entity/Q61762640',
    'http://www.wikidata.org/entity/Q61771354',
    'http://www.wikidata.org/entity/Q61773631',
    'http://www.wikidata.org/entity/Q61773638',
    'http://www.wikidata.org/entity/Q61783563',
    'http://www.wikidata.org/entity/Q61783575',
    'http://www.wikidata.org/entity/Q61783596',
    'http://www.wikidata.org/entity/Q61783706',
    'http://www.wikidata.org/entity/Q61783828',
    'http://www.wikidata.org/entity/Q61784115',
    'http://www.wikidata.org/entity/Q61784496',
    'http://www.wikidata.org/entity/Q61784644',
    'http://www.wikidata.org/entity/Q6178547',
    'http://www.wikidata.org/entity/Q61791154',
    'http://www.wikidata.org/entity/Q61791823',
    'http://www.wikidata.org/entity/Q61809634',
    'http://www.wikidata.org/entity/Q61820692',
    'http://www.wikidata.org/entity/Q61822938',
    'http://www.wikidata.org/entity/Q61822968',
    'http://www.wikidata.org/entity/Q61825758',
    'http://www.wikidata.org/entity/Q61833640',
    'http://www.wikidata.org/entity/Q6188504',
    'http://www.wikidata.org/entity/Q61887623',
    'http://www.wikidata.org/entity/Q61890865',
    'http://www.wikidata.org/entity/Q61949008',
    'http://www.wikidata.org/entity/Q61949657',
    'http://www.wikidata.org/entity/Q61982175',
    'http://www.wikidata.org/entity/Q6201879',
    'http://www.wikidata.org/entity/Q6204013',
    'http://www.wikidata.org/entity/Q62050240',
    'http://www.wikidata.org/entity/Q62050247',
    'http://www.wikidata.org/entity/Q62066082',
    'http://www.wikidata.org/entity/Q62066229',
    'http://www.wikidata.org/entity/Q62067329',
    'http://www.wikidata.org/entity/Q62070963',
    'http://www.wikidata.org/entity/Q62089936',
    'http://www.wikidata.org/entity/Q6213343',
    'http://www.wikidata.org/entity/Q6228900',
    'http://www.wikidata.org/entity/Q6237755',
    'http://www.wikidata.org/entity/Q6247207',
    'http://www.wikidata.org/entity/Q62496584',
    'http://www.wikidata.org/entity/Q62506980',
    'http://www.wikidata.org/entity/Q6251482',
    'http://www.wikidata.org/entity/Q62516257',
    'http://www.wikidata.org/entity/Q62516263',
    'http://www.wikidata.org/entity/Q6252048',
    'http://www.wikidata.org/entity/Q6253636',
    'http://www.wikidata.org/entity/Q6253638',
    'http://www.wikidata.org/entity/Q62556560',
    'http://www.wikidata.org/entity/Q62559552',
    'http://www.wikidata.org/entity/Q62559921',
    'http://www.wikidata.org/entity/Q62560089',
    'http://www.wikidata.org/entity/Q62560161',
    'http://www.wikidata.org/entity/Q62562909',
    'http://www.wikidata.org/entity/Q62563919',
    'http://www.wikidata.org/entity/Q62566057',
    'http://www.wikidata.org/entity/Q62566537',
    'http://www.wikidata.org/entity/Q62567707',
    'http://www.wikidata.org/entity/Q62567829',
    'http://www.wikidata.org/entity/Q62568473',
    'http://www.wikidata.org/entity/Q62568676',
    'http://www.wikidata.org/entity/Q62569422',
    'http://www.wikidata.org/entity/Q62578915',
    'http://www.wikidata.org/entity/Q62592795',
    'http://www.wikidata.org/entity/Q62607693',
    'http://www.wikidata.org/entity/Q62643285',
    'http://www.wikidata.org/entity/Q62719182',
    'http://www.wikidata.org/entity/Q62726281',
    'http://www.wikidata.org/entity/Q62733235',
    'http://www.wikidata.org/entity/Q6274745',
    'http://www.wikidata.org/entity/Q62779676',
    'http://www.wikidata.org/entity/Q6280515',
    'http://www.wikidata.org/entity/Q6284337',
    'http://www.wikidata.org/entity/Q62851552',
    'http://www.wikidata.org/entity/Q62914910',
    'http://www.wikidata.org/entity/Q62942988',
    'http://www.wikidata.org/entity/Q62957896',
    'http://www.wikidata.org/entity/Q62993666',
    'http://www.wikidata.org/entity/Q62994281',
    'http://www.wikidata.org/entity/Q62995311',
    'http://www.wikidata.org/entity/Q63018132',
    'http://www.wikidata.org/entity/Q63018779',
    'http://www.wikidata.org/entity/Q63019538',
    'http://www.wikidata.org/entity/Q63021326',
    'http://www.wikidata.org/entity/Q63022682',
    'http://www.wikidata.org/entity/Q63034773',
    'http://www.wikidata.org/entity/Q63100920',
    'http://www.wikidata.org/entity/Q63101609',
    'http://www.wikidata.org/entity/Q63107356',
    'http://www.wikidata.org/entity/Q63107378',
    'http://www.wikidata.org/entity/Q63108049',
    'http://www.wikidata.org/entity/Q63132773',
    'http://www.wikidata.org/entity/Q63133894',
    'http://www.wikidata.org/entity/Q63136192',
    'http://www.wikidata.org/entity/Q63144077',
    'http://www.wikidata.org/entity/Q63144471',
    'http://www.wikidata.org/entity/Q63152758',
    'http://www.wikidata.org/entity/Q63164447',
    'http://www.wikidata.org/entity/Q63168606',
    'http://www.wikidata.org/entity/Q63168795',
    'http://www.wikidata.org/entity/Q63199069',
    'http://www.wikidata.org/entity/Q63213090',
    'http://www.wikidata.org/entity/Q63213673',
    'http://www.wikidata.org/entity/Q63213683',
    'http://www.wikidata.org/entity/Q63214194',
    'http://www.wikidata.org/entity/Q63214783',
    'http://www.wikidata.org/entity/Q63214788',
    'http://www.wikidata.org/entity/Q63214851',
    'http://www.wikidata.org/entity/Q63214873',
    'http://www.wikidata.org/entity/Q63214888',
    'http://www.wikidata.org/entity/Q63232438',
    'http://www.wikidata.org/entity/Q63244903',
    'http://www.wikidata.org/entity/Q63245124',
    'http://www.wikidata.org/entity/Q63245391',
    'http://www.wikidata.org/entity/Q63253317',
    'http://www.wikidata.org/entity/Q63253440',
    'http://www.wikidata.org/entity/Q63254476',
    'http://www.wikidata.org/entity/Q63255217',
    'http://www.wikidata.org/entity/Q63255347',
    'http://www.wikidata.org/entity/Q63256451',
    'http://www.wikidata.org/entity/Q63256598',
    'http://www.wikidata.org/entity/Q63284785',
    'http://www.wikidata.org/entity/Q63285070',
    'http://www.wikidata.org/entity/Q63302442',
    'http://www.wikidata.org/entity/Q63302725',
    'http://www.wikidata.org/entity/Q63364934',
    'http://www.wikidata.org/entity/Q63378055',
    'http://www.wikidata.org/entity/Q63378132',
    'http://www.wikidata.org/entity/Q63391550',
    'http://www.wikidata.org/entity/Q63436668',
    'http://www.wikidata.org/entity/Q63437515',
    'http://www.wikidata.org/entity/Q63508979',
    'http://www.wikidata.org/entity/Q63509536',
    'http://www.wikidata.org/entity/Q6359924',
    'http://www.wikidata.org/entity/Q63676329',
    'http://www.wikidata.org/entity/Q63695821',
    'http://www.wikidata.org/entity/Q6370341',
    'http://www.wikidata.org/entity/Q6371926',
    'http://www.wikidata.org/entity/Q6380176',
    'http://www.wikidata.org/entity/Q63860522',
    'http://www.wikidata.org/entity/Q63881333',
    'http://www.wikidata.org/entity/Q6390313',
    'http://www.wikidata.org/entity/Q63919218',
    'http://www.wikidata.org/entity/Q63919345',
    'http://www.wikidata.org/entity/Q63943669',
    'http://www.wikidata.org/entity/Q63963026',
    'http://www.wikidata.org/entity/Q63967707',
    'http://www.wikidata.org/entity/Q63973058',
    'http://www.wikidata.org/entity/Q63974196',
    'http://www.wikidata.org/entity/Q64004119',
    'http://www.wikidata.org/entity/Q64005064',
    'http://www.wikidata.org/entity/Q64025726',
    'http://www.wikidata.org/entity/Q64026235',
    'http://www.wikidata.org/entity/Q64026278',
    'http://www.wikidata.org/entity/Q640381',
    'http://www.wikidata.org/entity/Q64145165',
    'http://www.wikidata.org/entity/Q64148038',
    'http://www.wikidata.org/entity/Q64148695',
    'http://www.wikidata.org/entity/Q64157128',
    'http://www.wikidata.org/entity/Q64162946',
    'http://www.wikidata.org/entity/Q64175653',
    'http://www.wikidata.org/entity/Q6419831',
    'http://www.wikidata.org/entity/Q64215088',
    'http://www.wikidata.org/entity/Q64350507',
    'http://www.wikidata.org/entity/Q64364605',
    'http://www.wikidata.org/entity/Q64364618',
    'http://www.wikidata.org/entity/Q64367205',
    'http://www.wikidata.org/entity/Q64368056',
    'http://www.wikidata.org/entity/Q64384545',
    'http://www.wikidata.org/entity/Q64399734',
    'http://www.wikidata.org/entity/Q6440188',
    'http://www.wikidata.org/entity/Q64409983',
    'http://www.wikidata.org/entity/Q64474825',
    'http://www.wikidata.org/entity/Q64481885',
    'http://www.wikidata.org/entity/Q64495464',
    'http://www.wikidata.org/entity/Q64495494',
    'http://www.wikidata.org/entity/Q64495559',
    'http://www.wikidata.org/entity/Q64497539',
    'http://www.wikidata.org/entity/Q64498968',
    'http://www.wikidata.org/entity/Q64511714',
    'http://www.wikidata.org/entity/Q64511828',
    'http://www.wikidata.org/entity/Q64524473',
    'http://www.wikidata.org/entity/Q6453246',
    'http://www.wikidata.org/entity/Q64539049',
    'http://www.wikidata.org/entity/Q64539216',
    'http://www.wikidata.org/entity/Q64539321',
    'http://www.wikidata.org/entity/Q64584555',
    'http://www.wikidata.org/entity/Q64584835',
    'http://www.wikidata.org/entity/Q64585410',
    'http://www.wikidata.org/entity/Q64590239',
    'http://www.wikidata.org/entity/Q64624932',
    'http://www.wikidata.org/entity/Q64682736',
    'http://www.wikidata.org/entity/Q64684757',
    'http://www.wikidata.org/entity/Q64689171',
    'http://www.wikidata.org/entity/Q64690943',
    'http://www.wikidata.org/entity/Q64731348',
    'http://www.wikidata.org/entity/Q64736336',
    'http://www.wikidata.org/entity/Q64746271',
    'http://www.wikidata.org/entity/Q64750687',
    'http://www.wikidata.org/entity/Q64750736',
    'http://www.wikidata.org/entity/Q64754704',
    'http://www.wikidata.org/entity/Q64754997',
    'http://www.wikidata.org/entity/Q64755281',
    'http://www.wikidata.org/entity/Q64760526',
    'http://www.wikidata.org/entity/Q64761181',
    'http://www.wikidata.org/entity/Q64768286',
    'http://www.wikidata.org/entity/Q64778814',
    'http://www.wikidata.org/entity/Q64785850',
    'http://www.wikidata.org/entity/Q64836066',
    'http://www.wikidata.org/entity/Q64853144',
    'http://www.wikidata.org/entity/Q64855267',
    'http://www.wikidata.org/entity/Q64855790',
    'http://www.wikidata.org/entity/Q64855910',
    'http://www.wikidata.org/entity/Q64856164',
    'http://www.wikidata.org/entity/Q64857438',
    'http://www.wikidata.org/entity/Q64857515',
    'http://www.wikidata.org/entity/Q64857638',
    'http://www.wikidata.org/entity/Q64857656',
    'http://www.wikidata.org/entity/Q64863292',
    'http://www.wikidata.org/entity/Q64863318',
    'http://www.wikidata.org/entity/Q64863736',
    'http://www.wikidata.org/entity/Q64863747',
    'http://www.wikidata.org/entity/Q64863825',
    'http://www.wikidata.org/entity/Q64863932',
    'http://www.wikidata.org/entity/Q64863961',
    'http://www.wikidata.org/entity/Q64864311',
    'http://www.wikidata.org/entity/Q64864469',
    'http://www.wikidata.org/entity/Q64866574',
    'http://www.wikidata.org/entity/Q64867086',
    'http://www.wikidata.org/entity/Q64867609',
    'http://www.wikidata.org/entity/Q64868070',
    'http://www.wikidata.org/entity/Q64869526',
    'http://www.wikidata.org/entity/Q64932411',
    'http://www.wikidata.org/entity/Q64978393',
    'http://www.wikidata.org/entity/Q6503944',
    'http://www.wikidata.org/entity/Q65054855',
    'http://www.wikidata.org/entity/Q65055037',
    'http://www.wikidata.org/entity/Q6525406',
    'http://www.wikidata.org/entity/Q6537960',
    'http://www.wikidata.org/entity/Q6551889',
    'http://www.wikidata.org/entity/Q65553923',
    'http://www.wikidata.org/entity/Q65554890',
    'http://www.wikidata.org/entity/Q65555428',
    'http://www.wikidata.org/entity/Q65556580',
    'http://www.wikidata.org/entity/Q65559179',
    'http://www.wikidata.org/entity/Q65559413',
    'http://www.wikidata.org/entity/Q65559528',
    'http://www.wikidata.org/entity/Q65559694',
    'http://www.wikidata.org/entity/Q65560413',
    'http://www.wikidata.org/entity/Q65648536',
    'http://www.wikidata.org/entity/Q65649374',
    'http://www.wikidata.org/entity/Q65660760',
    'http://www.wikidata.org/entity/Q65665974',
    'http://www.wikidata.org/entity/Q65672913',
    'http://www.wikidata.org/entity/Q65766963',
    'http://www.wikidata.org/entity/Q65769660',
    'http://www.wikidata.org/entity/Q65769671',
    'http://www.wikidata.org/entity/Q658060',
    'http://www.wikidata.org/entity/Q65824971',
    'http://www.wikidata.org/entity/Q65953285',
    'http://www.wikidata.org/entity/Q65971879',
    'http://www.wikidata.org/entity/Q65992534',
    'http://www.wikidata.org/entity/Q66000726',
    'http://www.wikidata.org/entity/Q66126603',
    'http://www.wikidata.org/entity/Q66360703',
    'http://www.wikidata.org/entity/Q66370727',
    'http://www.wikidata.org/entity/Q66370731',
    'http://www.wikidata.org/entity/Q66370740',
    'http://www.wikidata.org/entity/Q66370794',
    'http://www.wikidata.org/entity/Q66370881',
    'http://www.wikidata.org/entity/Q66370907',
    'http://www.wikidata.org/entity/Q66385413',
    'http://www.wikidata.org/entity/Q66385416',
    'http://www.wikidata.org/entity/Q66385451',
    'http://www.wikidata.org/entity/Q66385504',
    'http://www.wikidata.org/entity/Q66385542',
    'http://www.wikidata.org/entity/Q66385580',
    'http://www.wikidata.org/entity/Q66385785',
    'http://www.wikidata.org/entity/Q66386593',
    'http://www.wikidata.org/entity/Q66411928',
    'http://www.wikidata.org/entity/Q66413491',
    'http://www.wikidata.org/entity/Q66414148',
    'http://www.wikidata.org/entity/Q66429598',
    'http://www.wikidata.org/entity/Q66429603',
    'http://www.wikidata.org/entity/Q66473921',
    'http://www.wikidata.org/entity/Q66672643',
    'http://www.wikidata.org/entity/Q66679700',
    'http://www.wikidata.org/entity/Q66724584',
    'http://www.wikidata.org/entity/Q66724706',
    'http://www.wikidata.org/entity/Q66724764',
    'http://www.wikidata.org/entity/Q66724775',
    'http://www.wikidata.org/entity/Q66730291',
    'http://www.wikidata.org/entity/Q66730599',
    'http://www.wikidata.org/entity/Q66732147',
    'http://www.wikidata.org/entity/Q66732805',
    'http://www.wikidata.org/entity/Q66732898',
    'http://www.wikidata.org/entity/Q66739234',
    'http://www.wikidata.org/entity/Q66739430',
    'http://www.wikidata.org/entity/Q66751416',
    'http://www.wikidata.org/entity/Q66752863',
    'http://www.wikidata.org/entity/Q66759492',
    'http://www.wikidata.org/entity/Q66759549',
    'http://www.wikidata.org/entity/Q66764484',
    'http://www.wikidata.org/entity/Q66771471',
    'http://www.wikidata.org/entity/Q66809437',
    'http://www.wikidata.org/entity/Q66813386',
    'http://www.wikidata.org/entity/Q66816358',
    'http://www.wikidata.org/entity/Q66816388',
    'http://www.wikidata.org/entity/Q66816428',
    'http://www.wikidata.org/entity/Q66871632',
    'http://www.wikidata.org/entity/Q66876252',
    'http://www.wikidata.org/entity/Q66877204',
    'http://www.wikidata.org/entity/Q66905378',
    'http://www.wikidata.org/entity/Q66905953',
    'http://www.wikidata.org/entity/Q66908908',
    'http://www.wikidata.org/entity/Q66909797',
    'http://www.wikidata.org/entity/Q66911182',
    'http://www.wikidata.org/entity/Q66912067',
    'http://www.wikidata.org/entity/Q66933446',
    'http://www.wikidata.org/entity/Q66933976',
    'http://www.wikidata.org/entity/Q66937460',
    'http://www.wikidata.org/entity/Q67117669',
    'http://www.wikidata.org/entity/Q67123714',
    'http://www.wikidata.org/entity/Q67137291',
    'http://www.wikidata.org/entity/Q67154939',
    'http://www.wikidata.org/entity/Q67167640',
    'http://www.wikidata.org/entity/Q67168137',
    'http://www.wikidata.org/entity/Q67168469',
    'http://www.wikidata.org/entity/Q67172896',
    'http://www.wikidata.org/entity/Q67175546',
    'http://www.wikidata.org/entity/Q67175552',
    'http://www.wikidata.org/entity/Q67189332',
    'http://www.wikidata.org/entity/Q67189720',
    'http://www.wikidata.org/entity/Q67189866',
    'http://www.wikidata.org/entity/Q67190177',
    'http://www.wikidata.org/entity/Q67190496',
    'http://www.wikidata.org/entity/Q67190604',
    'http://www.wikidata.org/entity/Q67191021',
    'http://www.wikidata.org/entity/Q67191264',
    'http://www.wikidata.org/entity/Q67191520',
    'http://www.wikidata.org/entity/Q67191563',
    'http://www.wikidata.org/entity/Q67209813',
    'http://www.wikidata.org/entity/Q67213466',
    'http://www.wikidata.org/entity/Q67215429',
    'http://www.wikidata.org/entity/Q67215432',
    'http://www.wikidata.org/entity/Q67218060',
    'http://www.wikidata.org/entity/Q67218653',
    'http://www.wikidata.org/entity/Q67223099',
    'http://www.wikidata.org/entity/Q67224134',
    'http://www.wikidata.org/entity/Q67224421',
    'http://www.wikidata.org/entity/Q67225001',
    'http://www.wikidata.org/entity/Q67270373',
    'http://www.wikidata.org/entity/Q67283317',
    'http://www.wikidata.org/entity/Q67293866',
    'http://www.wikidata.org/entity/Q67328594',
    'http://www.wikidata.org/entity/Q67342803',
    'http://www.wikidata.org/entity/Q67343781',
    'http://www.wikidata.org/entity/Q67408980',
    'http://www.wikidata.org/entity/Q67435054',
    'http://www.wikidata.org/entity/Q6743602',
    'http://www.wikidata.org/entity/Q67440680',
    'http://www.wikidata.org/entity/Q67466335',
    'http://www.wikidata.org/entity/Q67482510',
    'http://www.wikidata.org/entity/Q67482673',
    'http://www.wikidata.org/entity/Q67485110',
    'http://www.wikidata.org/entity/Q6755364',
    'http://www.wikidata.org/entity/Q6758483',
    'http://www.wikidata.org/entity/Q67597794',
    'http://www.wikidata.org/entity/Q67623807',
    'http://www.wikidata.org/entity/Q67627458',
    'http://www.wikidata.org/entity/Q67650828',
    'http://www.wikidata.org/entity/Q67650912',
    'http://www.wikidata.org/entity/Q67650927',
    'http://www.wikidata.org/entity/Q67650970',
    'http://www.wikidata.org/entity/Q6766473',
    'http://www.wikidata.org/entity/Q676661',
    'http://www.wikidata.org/entity/Q6766711',
    'http://www.wikidata.org/entity/Q6768494',
    'http://www.wikidata.org/entity/Q6768760',
    'http://www.wikidata.org/entity/Q6771717',
    'http://www.wikidata.org/entity/Q67732460',
    'http://www.wikidata.org/entity/Q6774136',
    'http://www.wikidata.org/entity/Q67755317',
    'http://www.wikidata.org/entity/Q6775770',
    'http://www.wikidata.org/entity/Q6775901',
    'http://www.wikidata.org/entity/Q67783220',
    'http://www.wikidata.org/entity/Q67874262',
    'http://www.wikidata.org/entity/Q6791022',
    'http://www.wikidata.org/entity/Q67953759',
    'http://www.wikidata.org/entity/Q68046418',
    'http://www.wikidata.org/entity/Q6833284',
    'http://www.wikidata.org/entity/Q6833706',
    'http://www.wikidata.org/entity/Q68596151',
    'http://www.wikidata.org/entity/Q68637442',
    'http://www.wikidata.org/entity/Q68639132',
    'http://www.wikidata.org/entity/Q68690794',
    'http://www.wikidata.org/entity/Q69016835',
    'http://www.wikidata.org/entity/Q69022472',
    'http://www.wikidata.org/entity/Q69031422',
    'http://www.wikidata.org/entity/Q69035242',
    'http://www.wikidata.org/entity/Q69141941',
    'http://www.wikidata.org/entity/Q69142484',
    'http://www.wikidata.org/entity/Q69263108',
    'http://www.wikidata.org/entity/Q69264179',
    'http://www.wikidata.org/entity/Q69358288',
    'http://www.wikidata.org/entity/Q69542125',
    'http://www.wikidata.org/entity/Q69556563',
    'http://www.wikidata.org/entity/Q69662859',
    'http://www.wikidata.org/entity/Q6990732',
    'http://www.wikidata.org/entity/Q7027511',
    'http://www.wikidata.org/entity/Q7037244',
    'http://www.wikidata.org/entity/Q70376235',
    'http://www.wikidata.org/entity/Q70377150',
    'http://www.wikidata.org/entity/Q70527438',
    'http://www.wikidata.org/entity/Q7088836',
    'http://www.wikidata.org/entity/Q70916399',
    'http://www.wikidata.org/entity/Q70954053',
    'http://www.wikidata.org/entity/Q71013029',
    'http://www.wikidata.org/entity/Q71025350',
    'http://www.wikidata.org/entity/Q7102692',
    'http://www.wikidata.org/entity/Q71037672',
    'http://www.wikidata.org/entity/Q71040112',
    'http://www.wikidata.org/entity/Q71098091',
    'http://www.wikidata.org/entity/Q71104683',
    'http://www.wikidata.org/entity/Q71109132',
    'http://www.wikidata.org/entity/Q7113303',
    'http://www.wikidata.org/entity/Q71289712',
    'http://www.wikidata.org/entity/Q7132103',
    'http://www.wikidata.org/entity/Q71350587',
    'http://www.wikidata.org/entity/Q7146446',
    'http://www.wikidata.org/entity/Q7147153',
    'http://www.wikidata.org/entity/Q71497668',
    'http://www.wikidata.org/entity/Q71525020',
    'http://www.wikidata.org/entity/Q7153226',
    'http://www.wikidata.org/entity/Q7153848',
    'http://www.wikidata.org/entity/Q7160367',
    'http://www.wikidata.org/entity/Q7169326',
    'http://www.wikidata.org/entity/Q7173132',
    'http://www.wikidata.org/entity/Q7174738',
    'http://www.wikidata.org/entity/Q7175067',
    'http://www.wikidata.org/entity/Q71773159',
    'http://www.wikidata.org/entity/Q71778587',
    'http://www.wikidata.org/entity/Q7183255',
    'http://www.wikidata.org/entity/Q7191735',
    'http://www.wikidata.org/entity/Q72190852',
    'http://www.wikidata.org/entity/Q72250521',
    'http://www.wikidata.org/entity/Q72250716',
    'http://www.wikidata.org/entity/Q72412361',
    'http://www.wikidata.org/entity/Q72525816',
    'http://www.wikidata.org/entity/Q725840',
    'http://www.wikidata.org/entity/Q72617881',
    'http://www.wikidata.org/entity/Q72677293',
    'http://www.wikidata.org/entity/Q72772138',
    'http://www.wikidata.org/entity/Q7282400',
    'http://www.wikidata.org/entity/Q7285945',
    'http://www.wikidata.org/entity/Q72868603',
    'http://www.wikidata.org/entity/Q7288259',
    'http://www.wikidata.org/entity/Q72940290',
    'http://www.wikidata.org/entity/Q73044805',
    'http://www.wikidata.org/entity/Q73186070',
    'http://www.wikidata.org/entity/Q73192148',
    'http://www.wikidata.org/entity/Q7325058',
    'http://www.wikidata.org/entity/Q7328381',
    'http://www.wikidata.org/entity/Q7329022',
    'http://www.wikidata.org/entity/Q73297886',
    'http://www.wikidata.org/entity/Q73300356',
    'http://www.wikidata.org/entity/Q73305204',
    'http://www.wikidata.org/entity/Q73418907',
    'http://www.wikidata.org/entity/Q73422966',
    'http://www.wikidata.org/entity/Q7342606',
    'http://www.wikidata.org/entity/Q7343698',
    'http://www.wikidata.org/entity/Q73442154',
    'http://www.wikidata.org/entity/Q7345927',
    'http://www.wikidata.org/entity/Q7347468',
    'http://www.wikidata.org/entity/Q73523499',
    'http://www.wikidata.org/entity/Q7352679',
    'http://www.wikidata.org/entity/Q73543531',
    'http://www.wikidata.org/entity/Q73543623',
    'http://www.wikidata.org/entity/Q73546094',
    'http://www.wikidata.org/entity/Q73556800',
    'http://www.wikidata.org/entity/Q73557011',
    'http://www.wikidata.org/entity/Q73565675',
    'http://www.wikidata.org/entity/Q73567194',
    'http://www.wikidata.org/entity/Q73567837',
    'http://www.wikidata.org/entity/Q73570557',
    'http://www.wikidata.org/entity/Q73606228',
    'http://www.wikidata.org/entity/Q7360689',
    'http://www.wikidata.org/entity/Q7364712',
    'http://www.wikidata.org/entity/Q73660621',
    'http://www.wikidata.org/entity/Q73660645',
    'http://www.wikidata.org/entity/Q73731383',
    'http://www.wikidata.org/entity/Q7377799',
    'http://www.wikidata.org/entity/Q7383152',
    'http://www.wikidata.org/entity/Q73862394',
    'http://www.wikidata.org/entity/Q73990240',
    'http://www.wikidata.org/entity/Q740638',
    'http://www.wikidata.org/entity/Q7456522',
    'http://www.wikidata.org/entity/Q74766086',
    'http://www.wikidata.org/entity/Q74988006',
    'http://www.wikidata.org/entity/Q74988477',
    'http://www.wikidata.org/entity/Q75025725',
    'http://www.wikidata.org/entity/Q75026076',
    'http://www.wikidata.org/entity/Q75114791',
    'http://www.wikidata.org/entity/Q75152138',
    'http://www.wikidata.org/entity/Q75155595',
    'http://www.wikidata.org/entity/Q75159249',
    'http://www.wikidata.org/entity/Q75205210',
    'http://www.wikidata.org/entity/Q75469591',
    'http://www.wikidata.org/entity/Q75515424',
    'http://www.wikidata.org/entity/Q75573197',
    'http://www.wikidata.org/entity/Q7598991',
    'http://www.wikidata.org/entity/Q76003719',
    'http://www.wikidata.org/entity/Q7606605',
    'http://www.wikidata.org/entity/Q76082664',
    'http://www.wikidata.org/entity/Q7609174',
    'http://www.wikidata.org/entity/Q7610775',
    'http://www.wikidata.org/entity/Q7647625',
    'http://www.wikidata.org/entity/Q7648182',
    'http://www.wikidata.org/entity/Q76568659',
    'http://www.wikidata.org/entity/Q7666528',
    'http://www.wikidata.org/entity/Q76753473',
    'http://www.wikidata.org/entity/Q7693360',
    'http://www.wikidata.org/entity/Q76998834',
    'http://www.wikidata.org/entity/Q77013848',
    'http://www.wikidata.org/entity/Q77049459',
    'http://www.wikidata.org/entity/Q77050292',
    'http://www.wikidata.org/entity/Q77085900',
    'http://www.wikidata.org/entity/Q77086497',
    'http://www.wikidata.org/entity/Q77093362',
    'http://www.wikidata.org/entity/Q77203523',
    'http://www.wikidata.org/entity/Q77286771',
    'http://www.wikidata.org/entity/Q77401379',
    'http://www.wikidata.org/entity/Q77754426',
    'http://www.wikidata.org/entity/Q7791362',
    'http://www.wikidata.org/entity/Q7792302',
    'http://www.wikidata.org/entity/Q7802018',
    'http://www.wikidata.org/entity/Q7812388',
    'http://www.wikidata.org/entity/Q7814993',
    'http://www.wikidata.org/entity/Q7825461',
    'http://www.wikidata.org/entity/Q78298494',
    'http://www.wikidata.org/entity/Q78299016',
    'http://www.wikidata.org/entity/Q7839400',
    'http://www.wikidata.org/entity/Q7847286',
    'http://www.wikidata.org/entity/Q78649226',
    'http://www.wikidata.org/entity/Q78651257',
    'http://www.wikidata.org/entity/Q78653335',
    'http://www.wikidata.org/entity/Q78659706',
    'http://www.wikidata.org/entity/Q78665360',
    'http://www.wikidata.org/entity/Q78712697',
    'http://www.wikidata.org/entity/Q78735551',
    'http://www.wikidata.org/entity/Q78744825',
    'http://www.wikidata.org/entity/Q78768282',
    'http://www.wikidata.org/entity/Q78768461',
    'http://www.wikidata.org/entity/Q78771344',
    'http://www.wikidata.org/entity/Q78790362',
    'http://www.wikidata.org/entity/Q78827847',
    'http://www.wikidata.org/entity/Q79074213',
    'http://www.wikidata.org/entity/Q79074636',
    'http://www.wikidata.org/entity/Q79075231',
    'http://www.wikidata.org/entity/Q79085901',
    'http://www.wikidata.org/entity/Q79148245',
    'http://www.wikidata.org/entity/Q79170615',
    'http://www.wikidata.org/entity/Q79171656',
    'http://www.wikidata.org/entity/Q7926167',
    'http://www.wikidata.org/entity/Q7926191',
    'http://www.wikidata.org/entity/Q79275529',
    'http://www.wikidata.org/entity/Q79326643',
    'http://www.wikidata.org/entity/Q79404240',
    'http://www.wikidata.org/entity/Q79434476',
    'http://www.wikidata.org/entity/Q79437079',
    'http://www.wikidata.org/entity/Q7945702',
    'http://www.wikidata.org/entity/Q79465156',
    'http://www.wikidata.org/entity/Q7959409',
    'http://www.wikidata.org/entity/Q79693816',
    'http://www.wikidata.org/entity/Q79708953',
    'http://www.wikidata.org/entity/Q80058071',
    'http://www.wikidata.org/entity/Q80152612',
    'http://www.wikidata.org/entity/Q80153371',
    'http://www.wikidata.org/entity/Q80154537',
    'http://www.wikidata.org/entity/Q80154641',
    'http://www.wikidata.org/entity/Q80154692',
    'http://www.wikidata.org/entity/Q80160585',
    'http://www.wikidata.org/entity/Q80161330',
    'http://www.wikidata.org/entity/Q80162864',
    'http://www.wikidata.org/entity/Q80164992',
    'http://www.wikidata.org/entity/Q80167861',
    'http://www.wikidata.org/entity/Q80331838',
    'http://www.wikidata.org/entity/Q80366411',
    'http://www.wikidata.org/entity/Q8057843',
    'http://www.wikidata.org/entity/Q80954488',
    'http://www.wikidata.org/entity/Q81746042',
    'http://www.wikidata.org/entity/Q81746600',
    'http://www.wikidata.org/entity/Q81746870',
    'http://www.wikidata.org/entity/Q82060328',
    'http://www.wikidata.org/entity/Q82083581',
    'http://www.wikidata.org/entity/Q8210183',
    'http://www.wikidata.org/entity/Q82176151',
    'http://www.wikidata.org/entity/Q822617',
    'http://www.wikidata.org/entity/Q82564642',
    'http://www.wikidata.org/entity/Q82659340',
    'http://www.wikidata.org/entity/Q827492',
    'http://www.wikidata.org/entity/Q82859255',
    'http://www.wikidata.org/entity/Q83110194',
    'http://www.wikidata.org/entity/Q83192873',
    'http://www.wikidata.org/entity/Q832302',
    'http://www.wikidata.org/entity/Q83230766',
    'http://www.wikidata.org/entity/Q83366010',
    'http://www.wikidata.org/entity/Q83381527',
    'http://www.wikidata.org/entity/Q83392312',
    'http://www.wikidata.org/entity/Q83392937',
    'http://www.wikidata.org/entity/Q834442',
    'http://www.wikidata.org/entity/Q83493982',
    'http://www.wikidata.org/entity/Q83494647',
    'http://www.wikidata.org/entity/Q83563889',
    'http://www.wikidata.org/entity/Q83642043',
    'http://www.wikidata.org/entity/Q83760769',
    'http://www.wikidata.org/entity/Q83762357',
    'http://www.wikidata.org/entity/Q83769465',
    'http://www.wikidata.org/entity/Q84104218',
    'http://www.wikidata.org/entity/Q84115152',
    'http://www.wikidata.org/entity/Q84165482',
    'http://www.wikidata.org/entity/Q84166596',
    'http://www.wikidata.org/entity/Q84362200',
    'http://www.wikidata.org/entity/Q84503550',
    'http://www.wikidata.org/entity/Q84518962',
    'http://www.wikidata.org/entity/Q84571879',
    'http://www.wikidata.org/entity/Q84599331',
    'http://www.wikidata.org/entity/Q84841135',
    'http://www.wikidata.org/entity/Q84842464',
    'http://www.wikidata.org/entity/Q84913499',
    'http://www.wikidata.org/entity/Q84914570',
    'http://www.wikidata.org/entity/Q85239829',
    'http://www.wikidata.org/entity/Q85240315',
    'http://www.wikidata.org/entity/Q85240560',
    'http://www.wikidata.org/entity/Q85242167',
    'http://www.wikidata.org/entity/Q85242678',
    'http://www.wikidata.org/entity/Q85286202',
    'http://www.wikidata.org/entity/Q85344273',
    'http://www.wikidata.org/entity/Q85344858',
    'http://www.wikidata.org/entity/Q85489048',
    'http://www.wikidata.org/entity/Q85863579',
    'http://www.wikidata.org/entity/Q85938878',
    'http://www.wikidata.org/entity/Q86028053',
    'http://www.wikidata.org/entity/Q86529620',
    'http://www.wikidata.org/entity/Q86839898',
    'http://www.wikidata.org/entity/Q86863442',
    'http://www.wikidata.org/entity/Q86870133',
    'http://www.wikidata.org/entity/Q87003499',
    'http://www.wikidata.org/entity/Q87013105',
    'http://www.wikidata.org/entity/Q87015965',
    'http://www.wikidata.org/entity/Q87018912',
    'http://www.wikidata.org/entity/Q87062824',
    'http://www.wikidata.org/entity/Q87075032',
    'http://www.wikidata.org/entity/Q87075146',
    'http://www.wikidata.org/entity/Q87075528',
    'http://www.wikidata.org/entity/Q87076179',
    'http://www.wikidata.org/entity/Q87077992',
    'http://www.wikidata.org/entity/Q87082629',
    'http://www.wikidata.org/entity/Q87085809',
    'http://www.wikidata.org/entity/Q87090318',
    'http://www.wikidata.org/entity/Q87121083',
    'http://www.wikidata.org/entity/Q87128576',
    'http://www.wikidata.org/entity/Q87128638',
    'http://www.wikidata.org/entity/Q87138615',
    'http://www.wikidata.org/entity/Q87140054',
    'http://www.wikidata.org/entity/Q87148386',
    'http://www.wikidata.org/entity/Q87148470',
    'http://www.wikidata.org/entity/Q87220141',
    'http://www.wikidata.org/entity/Q87223694',
    'http://www.wikidata.org/entity/Q87223816',
    'http://www.wikidata.org/entity/Q87223976',
    'http://www.wikidata.org/entity/Q87224063',
    'http://www.wikidata.org/entity/Q87224411',
    'http://www.wikidata.org/entity/Q87248746',
    'http://www.wikidata.org/entity/Q87347438',
    'http://www.wikidata.org/entity/Q87373879',
    'http://www.wikidata.org/entity/Q87398680',
    'http://www.wikidata.org/entity/Q87416031',
    'http://www.wikidata.org/entity/Q87441179',
    'http://www.wikidata.org/entity/Q87441186',
    'http://www.wikidata.org/entity/Q87441912',
    'http://www.wikidata.org/entity/Q87444696',
    'http://www.wikidata.org/entity/Q87489627',
    'http://www.wikidata.org/entity/Q87699695',
    'http://www.wikidata.org/entity/Q87706397',
    'http://www.wikidata.org/entity/Q87706464',
    'http://www.wikidata.org/entity/Q87712102',
    'http://www.wikidata.org/entity/Q87720346',
    'http://www.wikidata.org/entity/Q87723639',
    'http://www.wikidata.org/entity/Q87727132',
    'http://www.wikidata.org/entity/Q87742312',
    'http://www.wikidata.org/entity/Q87747574',
    'http://www.wikidata.org/entity/Q87755004',
    'http://www.wikidata.org/entity/Q87756591',
    'http://www.wikidata.org/entity/Q87774572',
    'http://www.wikidata.org/entity/Q87840199',
    'http://www.wikidata.org/entity/Q87841521',
    'http://www.wikidata.org/entity/Q87841734',
    'http://www.wikidata.org/entity/Q87865766',
    'http://www.wikidata.org/entity/Q87874621',
    'http://www.wikidata.org/entity/Q87875811',
    'http://www.wikidata.org/entity/Q87919930',
    'http://www.wikidata.org/entity/Q87928638',
    'http://www.wikidata.org/entity/Q87932047',
    'http://www.wikidata.org/entity/Q87934467',
    'http://www.wikidata.org/entity/Q87944029',
    'http://www.wikidata.org/entity/Q87944728',
    'http://www.wikidata.org/entity/Q87945766',
    'http://www.wikidata.org/entity/Q87949010',
    'http://www.wikidata.org/entity/Q87949515',
    'http://www.wikidata.org/entity/Q87950141',
    'http://www.wikidata.org/entity/Q87967182',
    'http://www.wikidata.org/entity/Q87981947',
    'http://www.wikidata.org/entity/Q87994211',
    'http://www.wikidata.org/entity/Q88007708',
    'http://www.wikidata.org/entity/Q88008619',
    'http://www.wikidata.org/entity/Q88026329',
    'http://www.wikidata.org/entity/Q88039086',
    'http://www.wikidata.org/entity/Q88050391',
    'http://www.wikidata.org/entity/Q88070100',
    'http://www.wikidata.org/entity/Q88077314',
    'http://www.wikidata.org/entity/Q88077554',
    'http://www.wikidata.org/entity/Q88102777',
    'http://www.wikidata.org/entity/Q88118974',
    'http://www.wikidata.org/entity/Q88137705',
    'http://www.wikidata.org/entity/Q88142946',
    'http://www.wikidata.org/entity/Q88192078',
    'http://www.wikidata.org/entity/Q88217415',
    'http://www.wikidata.org/entity/Q88218091',
    'http://www.wikidata.org/entity/Q88219254',
    'http://www.wikidata.org/entity/Q88221572',
    'http://www.wikidata.org/entity/Q88230658',
    'http://www.wikidata.org/entity/Q88319987',
    'http://www.wikidata.org/entity/Q88324182',
    'http://www.wikidata.org/entity/Q88345864',
    'http://www.wikidata.org/entity/Q88360960',
    'http://www.wikidata.org/entity/Q88390533',
    'http://www.wikidata.org/entity/Q88406948',
    'http://www.wikidata.org/entity/Q88412867',
    'http://www.wikidata.org/entity/Q88413008',
    'http://www.wikidata.org/entity/Q88413396',
    'http://www.wikidata.org/entity/Q88459455',
    'http://www.wikidata.org/entity/Q88472825',
    'http://www.wikidata.org/entity/Q88475153',
    'http://www.wikidata.org/entity/Q88475862',
    'http://www.wikidata.org/entity/Q88477108',
    'http://www.wikidata.org/entity/Q88567420',
    'http://www.wikidata.org/entity/Q88569524',
    'http://www.wikidata.org/entity/Q88590279',
    'http://www.wikidata.org/entity/Q88591752',
    'http://www.wikidata.org/entity/Q88607034',
    'http://www.wikidata.org/entity/Q88613246',
    'http://www.wikidata.org/entity/Q88614827',
    'http://www.wikidata.org/entity/Q88627519',
    'http://www.wikidata.org/entity/Q88637547',
    'http://www.wikidata.org/entity/Q88652661',
    'http://www.wikidata.org/entity/Q88653122',
    'http://www.wikidata.org/entity/Q88679013',
    'http://www.wikidata.org/entity/Q88712489',
    'http://www.wikidata.org/entity/Q88725880',
    'http://www.wikidata.org/entity/Q88727177',
    'http://www.wikidata.org/entity/Q88762246',
    'http://www.wikidata.org/entity/Q88773550',
    'http://www.wikidata.org/entity/Q88773672',
    'http://www.wikidata.org/entity/Q88778474',
    'http://www.wikidata.org/entity/Q88786090',
    'http://www.wikidata.org/entity/Q88878357',
    'http://www.wikidata.org/entity/Q88883209',
    'http://www.wikidata.org/entity/Q88902029',
    'http://www.wikidata.org/entity/Q88992942',
    'http://www.wikidata.org/entity/Q89108863',
    'http://www.wikidata.org/entity/Q89169',
    'http://www.wikidata.org/entity/Q89181819',
    'http://www.wikidata.org/entity/Q89184800',
    'http://www.wikidata.org/entity/Q89223280',
    'http://www.wikidata.org/entity/Q89253689',
    'http://www.wikidata.org/entity/Q89269942',
    'http://www.wikidata.org/entity/Q89270058',
    'http://www.wikidata.org/entity/Q89270545',
    'http://www.wikidata.org/entity/Q89296982',
    'http://www.wikidata.org/entity/Q89297056',
    'http://www.wikidata.org/entity/Q89297358',
    'http://www.wikidata.org/entity/Q89298880',
    'http://www.wikidata.org/entity/Q89317565',
    'http://www.wikidata.org/entity/Q89342920',
    'http://www.wikidata.org/entity/Q89373527',
    'http://www.wikidata.org/entity/Q89419301',
    'http://www.wikidata.org/entity/Q89436665',
    'http://www.wikidata.org/entity/Q89454622',
    'http://www.wikidata.org/entity/Q89498724',
    'http://www.wikidata.org/entity/Q89520964',
    'http://www.wikidata.org/entity/Q89550138',
    'http://www.wikidata.org/entity/Q89553449',
    'http://www.wikidata.org/entity/Q895547',
    'http://www.wikidata.org/entity/Q89587663',
    'http://www.wikidata.org/entity/Q89595126',
    'http://www.wikidata.org/entity/Q8962817',
    'http://www.wikidata.org/entity/Q89637656',
    'http://www.wikidata.org/entity/Q89645924',
    'http://www.wikidata.org/entity/Q89668545',
    'http://www.wikidata.org/entity/Q89697826',
    'http://www.wikidata.org/entity/Q89708224',
    'http://www.wikidata.org/entity/Q89808263',
    'http://www.wikidata.org/entity/Q89850327',
    'http://www.wikidata.org/entity/Q89959150',
    'http://www.wikidata.org/entity/Q89963371',
    'http://www.wikidata.org/entity/Q899840',
    'http://www.wikidata.org/entity/Q89998373',
    'http://www.wikidata.org/entity/Q90073',
    'http://www.wikidata.org/entity/Q90093',
    'http://www.wikidata.org/entity/Q90209285',
    'http://www.wikidata.org/entity/Q90217822',
    'http://www.wikidata.org/entity/Q90241000',
    'http://www.wikidata.org/entity/Q90301782',
    'http://www.wikidata.org/entity/Q90314248',
    'http://www.wikidata.org/entity/Q90332899',
    'http://www.wikidata.org/entity/Q90344341',
    'http://www.wikidata.org/entity/Q90363775',
    'http://www.wikidata.org/entity/Q903809',
    'http://www.wikidata.org/entity/Q90390457',
    'http://www.wikidata.org/entity/Q903973',
    'http://www.wikidata.org/entity/Q90422543',
    'http://www.wikidata.org/entity/Q90432014',
    'http://www.wikidata.org/entity/Q90448459',
    'http://www.wikidata.org/entity/Q90459818',
    'http://www.wikidata.org/entity/Q904654',
    'http://www.wikidata.org/entity/Q90469687',
    'http://www.wikidata.org/entity/Q90481278',
    'http://www.wikidata.org/entity/Q90520703',
    'http://www.wikidata.org/entity/Q90572515',
    'http://www.wikidata.org/entity/Q90583552',
    'http://www.wikidata.org/entity/Q90626068',
    'http://www.wikidata.org/entity/Q906529',
    'http://www.wikidata.org/entity/Q90685305',
    'http://www.wikidata.org/entity/Q90690384',
    'http://www.wikidata.org/entity/Q90695799',
    'http://www.wikidata.org/entity/Q90754539',
    'http://www.wikidata.org/entity/Q90796636',
    'http://www.wikidata.org/entity/Q90798004',
    'http://www.wikidata.org/entity/Q90856971',
    'http://www.wikidata.org/entity/Q90866339',
    'http://www.wikidata.org/entity/Q90921094',
    'http://www.wikidata.org/entity/Q9096554',
    'http://www.wikidata.org/entity/Q91014109',
    'http://www.wikidata.org/entity/Q91067808',
    'http://www.wikidata.org/entity/Q91134545',
    'http://www.wikidata.org/entity/Q91254753',
    'http://www.wikidata.org/entity/Q91265862',
    'http://www.wikidata.org/entity/Q91326834',
    'http://www.wikidata.org/entity/Q91365286',
    'http://www.wikidata.org/entity/Q91520926',
    'http://www.wikidata.org/entity/Q91546354',
    'http://www.wikidata.org/entity/Q915676',
    'http://www.wikidata.org/entity/Q91581573',
    'http://www.wikidata.org/entity/Q91760966',
    'http://www.wikidata.org/entity/Q91780528',
    'http://www.wikidata.org/entity/Q91790562',
    'http://www.wikidata.org/entity/Q91822160',
    'http://www.wikidata.org/entity/Q918343',
    'http://www.wikidata.org/entity/Q91931795',
    'http://www.wikidata.org/entity/Q91939875',
    'http://www.wikidata.org/entity/Q91946580',
    'http://www.wikidata.org/entity/Q92382877',
    'http://www.wikidata.org/entity/Q92418478',
    'http://www.wikidata.org/entity/Q92482004',
    'http://www.wikidata.org/entity/Q92575078',
    'http://www.wikidata.org/entity/Q92785902',
    'http://www.wikidata.org/entity/Q92965709',
    'http://www.wikidata.org/entity/Q93109128',
    'http://www.wikidata.org/entity/Q93253929',
    'http://www.wikidata.org/entity/Q93254117',
    'http://www.wikidata.org/entity/Q93363551',
    'http://www.wikidata.org/entity/Q9346569',
    'http://www.wikidata.org/entity/Q935993',
    'http://www.wikidata.org/entity/Q93869989',
    'http://www.wikidata.org/entity/Q94114332',
    'http://www.wikidata.org/entity/Q94459276',
    'http://www.wikidata.org/entity/Q94471977',
    'http://www.wikidata.org/entity/Q94486238',
    'http://www.wikidata.org/entity/Q94570815',
    'http://www.wikidata.org/entity/Q94948720',
    'http://www.wikidata.org/entity/Q94951199',
    'http://www.wikidata.org/entity/Q95267900',
    'http://www.wikidata.org/entity/Q95423256',
    'http://www.wikidata.org/entity/Q95423257',
    'http://www.wikidata.org/entity/Q95746107',
    'http://www.wikidata.org/entity/Q95977614',
    'http://www.wikidata.org/entity/Q96032',
    'http://www.wikidata.org/entity/Q96067584',
    'http://www.wikidata.org/entity/Q96107754',
    'http://www.wikidata.org/entity/Q96140937',
    'http://www.wikidata.org/entity/Q96619701',
    'http://www.wikidata.org/entity/Q96619726',
    'http://www.wikidata.org/entity/Q96642108',
    'http://www.wikidata.org/entity/Q96651271',
    'http://www.wikidata.org/entity/Q96691052',
    'http://www.wikidata.org/entity/Q96691251',
    'http://www.wikidata.org/entity/Q96691253',
    'http://www.wikidata.org/entity/Q96691295',
    'http://www.wikidata.org/entity/Q96691551',
    'http://www.wikidata.org/entity/Q96691553',
    'http://www.wikidata.org/entity/Q96691701',
    'http://www.wikidata.org/entity/Q96781744',
    'http://www.wikidata.org/entity/Q96781751',
    'http://www.wikidata.org/entity/Q96817021',
    'http://www.wikidata.org/entity/Q969420',
    'http://www.wikidata.org/entity/Q9696930',
    'http://www.wikidata.org/entity/Q970550',
    'http://www.wikidata.org/entity/Q97061552',
    'http://www.wikidata.org/entity/Q97065526',
    'http://www.wikidata.org/entity/Q97118155',
    'http://www.wikidata.org/entity/Q97270',
    'http://www.wikidata.org/entity/Q97317520',
    'http://www.wikidata.org/entity/Q97333782',
    'http://www.wikidata.org/entity/Q97397251',
    'http://www.wikidata.org/entity/Q97397352',
    'http://www.wikidata.org/entity/Q97397450',
    'http://www.wikidata.org/entity/Q97397851',
    'http://www.wikidata.org/entity/Q97397914',
    'http://www.wikidata.org/entity/Q97443679',
    'http://www.wikidata.org/entity/Q97443689',
    'http://www.wikidata.org/entity/Q97443693',
    'http://www.wikidata.org/entity/Q97443703',
    'http://www.wikidata.org/entity/Q97444460',
    'http://www.wikidata.org/entity/Q97445092',
    'http://www.wikidata.org/entity/Q97445316',
    'http://www.wikidata.org/entity/Q97445439',
    'http://www.wikidata.org/entity/Q975470',
    'http://www.wikidata.org/entity/Q97573186',
    'http://www.wikidata.org/entity/Q97635775',
    'http://www.wikidata.org/entity/Q97650019',
    'http://www.wikidata.org/entity/Q977751',
    'http://www.wikidata.org/entity/Q98152855',
    'http://www.wikidata.org/entity/Q98173788',
    'http://www.wikidata.org/entity/Q98243295',
    'http://www.wikidata.org/entity/Q98243598',
    'http://www.wikidata.org/entity/Q98321265',
    'http://www.wikidata.org/entity/Q98358503',
    'http://www.wikidata.org/entity/Q98358734',
    'http://www.wikidata.org/entity/Q98359136',
    'http://www.wikidata.org/entity/Q98359584',
    'http://www.wikidata.org/entity/Q98359710',
    'http://www.wikidata.org/entity/Q98359841',
    'http://www.wikidata.org/entity/Q98360435',
    'http://www.wikidata.org/entity/Q98360634',
    'http://www.wikidata.org/entity/Q98360921',
    'http://www.wikidata.org/entity/Q98361212',
    'http://www.wikidata.org/entity/Q98362684',
    'http://www.wikidata.org/entity/Q98362966',
    'http://www.wikidata.org/entity/Q98363166',
    'http://www.wikidata.org/entity/Q98363399',
    'http://www.wikidata.org/entity/Q98363515',
    'http://www.wikidata.org/entity/Q98363681',
    'http://www.wikidata.org/entity/Q98363849',
    'http://www.wikidata.org/entity/Q98364295',
    'http://www.wikidata.org/entity/Q98364465',
    'http://www.wikidata.org/entity/Q98364696',
    'http://www.wikidata.org/entity/Q98364889',
    'http://www.wikidata.org/entity/Q98365948',
    'http://www.wikidata.org/entity/Q98366333',
    'http://www.wikidata.org/entity/Q98366502',
    'http://www.wikidata.org/entity/Q98383060',
    'http://www.wikidata.org/entity/Q98456874',
    'http://www.wikidata.org/entity/Q98456898',
    'http://www.wikidata.org/entity/Q98456956',
    'http://www.wikidata.org/entity/Q98457064',
    'http://www.wikidata.org/entity/Q98526439',
    'http://www.wikidata.org/entity/Q98545378',
    'http://www.wikidata.org/entity/Q98639347',
    'http://www.wikidata.org/entity/Q98657227',
    'http://www.wikidata.org/entity/Q98687631',
    'http://www.wikidata.org/entity/Q98688870',
    'http://www.wikidata.org/entity/Q98688976',
    'http://www.wikidata.org/entity/Q98689126',
    'http://www.wikidata.org/entity/Q98689182',
    'http://www.wikidata.org/entity/Q98791672',
    'http://www.wikidata.org/entity/Q98841128',
    'http://www.wikidata.org/entity/Q99231870',
    'http://www.wikidata.org/entity/Q99337102',
    'http://www.wikidata.org/entity/Q99520901',
    'http://www.wikidata.org/entity/Q99522156',
    'http://www.wikidata.org/entity/Q99630149',
    'http://www.wikidata.org/entity/Q99678107',
    'http://www.wikidata.org/entity/Q99678175',
}

# List of ordinal numbers representing the order of authors - these are existential nodes.
ordinals = {
    'ordinal_001',
    'ordinal_002',
    'ordinal_003',
    'ordinal_004',
    'ordinal_005',
    'ordinal_006',
    'ordinal_007',
    'ordinal_008',
    'ordinal_009',
    'ordinal_010',
    'ordinal_011',
    'ordinal_012',
    'ordinal_013',
    'ordinal_014',
    'ordinal_015',
    'ordinal_016',
    'ordinal_017',
    'ordinal_018',
    'ordinal_019',
    'ordinal_020',
    'ordinal_021',
    'ordinal_022',
    'ordinal_023',
    'ordinal_024',
    'ordinal_025',
    'ordinal_026',
    'ordinal_027',
    'ordinal_028',
    'ordinal_029',
    'ordinal_030',
    'ordinal_031',
    'ordinal_032',
    'ordinal_033',
    'ordinal_034',
    'ordinal_035',
    'ordinal_036',
    'ordinal_037',
    'ordinal_038',
    'ordinal_039',
    'ordinal_040',
    'ordinal_041',
    'ordinal_042',
    'ordinal_043',
    'ordinal_044',
    'ordinal_045',
    'ordinal_046',
    'ordinal_047',
    'ordinal_048',
    'ordinal_049',
    'ordinal_050',
}

# List of IRI's of articles .
articles = {
    'http://www.wikidata.org/entity/Q104206347',
    'http://www.wikidata.org/entity/Q104206486',
    'http://www.wikidata.org/entity/Q104437590',
    'http://www.wikidata.org/entity/Q104501843',
    'http://www.wikidata.org/entity/Q105070776',
    'http://www.wikidata.org/entity/Q13416674',
    'http://www.wikidata.org/entity/Q13683362',
    'http://www.wikidata.org/entity/Q1542532',
    'http://www.wikidata.org/entity/Q15750361',
    'http://www.wikidata.org/entity/Q17278583',
    'http://www.wikidata.org/entity/Q17485680',
    'http://www.wikidata.org/entity/Q17485682',
    'http://www.wikidata.org/entity/Q17485684',
    'http://www.wikidata.org/entity/Q17485692',
    'http://www.wikidata.org/entity/Q17792525',
    'http://www.wikidata.org/entity/Q18507561',
    'http://www.wikidata.org/entity/Q1895685',
    'http://www.wikidata.org/entity/Q19671539',
    'http://www.wikidata.org/entity/Q19671692',
    'http://www.wikidata.org/entity/Q20823063',
    'http://www.wikidata.org/entity/Q20900776',
    'http://www.wikidata.org/entity/Q20901697',
    'http://www.wikidata.org/entity/Q20905423',
    'http://www.wikidata.org/entity/Q21003936',
    'http://www.wikidata.org/entity/Q21004125',
    'http://www.wikidata.org/entity/Q21030635',
    'http://www.wikidata.org/entity/Q21032463',
    'http://www.wikidata.org/entity/Q21032480',
    'http://www.wikidata.org/entity/Q21032481',
    'http://www.wikidata.org/entity/Q21032486',
    'http://www.wikidata.org/entity/Q21032494',
    'http://www.wikidata.org/entity/Q21032496',
    'http://www.wikidata.org/entity/Q21032502',
    'http://www.wikidata.org/entity/Q21032505',
    'http://www.wikidata.org/entity/Q21032507',
    'http://www.wikidata.org/entity/Q21032514',
    'http://www.wikidata.org/entity/Q21032517',
    'http://www.wikidata.org/entity/Q21032523',
    'http://www.wikidata.org/entity/Q21032534',
    'http://www.wikidata.org/entity/Q21033747',
    'http://www.wikidata.org/entity/Q21034097',
    'http://www.wikidata.org/entity/Q21034098',
    'http://www.wikidata.org/entity/Q21034112',
    'http://www.wikidata.org/entity/Q21034164',
    'http://www.wikidata.org/entity/Q21034167',
    'http://www.wikidata.org/entity/Q21034169',
    'http://www.wikidata.org/entity/Q21045365',
    'http://www.wikidata.org/entity/Q21045412',
    'http://www.wikidata.org/entity/Q21056874',
    'http://www.wikidata.org/entity/Q21061201',
    'http://www.wikidata.org/entity/Q21061202',
    'http://www.wikidata.org/entity/Q21061203',
    'http://www.wikidata.org/entity/Q21089567',
    'http://www.wikidata.org/entity/Q21089619',
    'http://www.wikidata.org/entity/Q21089657',
    'http://www.wikidata.org/entity/Q21089989',
    'http://www.wikidata.org/entity/Q21090025',
    'http://www.wikidata.org/entity/Q21090079',
    'http://www.wikidata.org/entity/Q21090106',
    'http://www.wikidata.org/entity/Q21090111',
    'http://www.wikidata.org/entity/Q21090117',
    'http://www.wikidata.org/entity/Q21090133',
    'http://www.wikidata.org/entity/Q21090145',
    'http://www.wikidata.org/entity/Q21090166',
    'http://www.wikidata.org/entity/Q21090167',
    'http://www.wikidata.org/entity/Q21090173',
    'http://www.wikidata.org/entity/Q21090181',
    'http://www.wikidata.org/entity/Q21090194',
    'http://www.wikidata.org/entity/Q21090212',
    'http://www.wikidata.org/entity/Q21090215',
    'http://www.wikidata.org/entity/Q21090219',
    'http://www.wikidata.org/entity/Q21090226',
    'http://www.wikidata.org/entity/Q21090230',
    'http://www.wikidata.org/entity/Q21090233',
    'http://www.wikidata.org/entity/Q21090482',
    'http://www.wikidata.org/entity/Q21090489',
    'http://www.wikidata.org/entity/Q21090494',
    'http://www.wikidata.org/entity/Q21090509',
    'http://www.wikidata.org/entity/Q21090516',
    'http://www.wikidata.org/entity/Q21090518',
    'http://www.wikidata.org/entity/Q21090519',
    'http://www.wikidata.org/entity/Q21090526',
    'http://www.wikidata.org/entity/Q21090528',
    'http://www.wikidata.org/entity/Q21090529',
    'http://www.wikidata.org/entity/Q21090792',
    'http://www.wikidata.org/entity/Q21090793',
    'http://www.wikidata.org/entity/Q21090909',
    'http://www.wikidata.org/entity/Q21090935',
    'http://www.wikidata.org/entity/Q21090966',
    'http://www.wikidata.org/entity/Q21090997',
    'http://www.wikidata.org/entity/Q21091008',
    'http://www.wikidata.org/entity/Q21091065',
    'http://www.wikidata.org/entity/Q21091074',
    'http://www.wikidata.org/entity/Q21091076',
    'http://www.wikidata.org/entity/Q21091183',
    'http://www.wikidata.org/entity/Q21091184',
    'http://www.wikidata.org/entity/Q21091189',
    'http://www.wikidata.org/entity/Q21091191',
    'http://www.wikidata.org/entity/Q21092232',
    'http://www.wikidata.org/entity/Q21092237',
    'http://www.wikidata.org/entity/Q21092263',
    'http://www.wikidata.org/entity/Q21092274',
    'http://www.wikidata.org/entity/Q21092286',
    'http://www.wikidata.org/entity/Q21092296',
    'http://www.wikidata.org/entity/Q21092298',
    'http://www.wikidata.org/entity/Q21092321',
    'http://www.wikidata.org/entity/Q21092323',
    'http://www.wikidata.org/entity/Q21092360',
    'http://www.wikidata.org/entity/Q21092366',
    'http://www.wikidata.org/entity/Q21092368',
    'http://www.wikidata.org/entity/Q21092372',
    'http://www.wikidata.org/entity/Q21092395',
    'http://www.wikidata.org/entity/Q21092428',
    'http://www.wikidata.org/entity/Q21092430',
    'http://www.wikidata.org/entity/Q21092447',
    'http://www.wikidata.org/entity/Q21092450',
    'http://www.wikidata.org/entity/Q21092458',
    'http://www.wikidata.org/entity/Q21092459',
    'http://www.wikidata.org/entity/Q21092462',
    'http://www.wikidata.org/entity/Q21092463',
    'http://www.wikidata.org/entity/Q21092465',
    'http://www.wikidata.org/entity/Q21092473',
    'http://www.wikidata.org/entity/Q21092474',
    'http://www.wikidata.org/entity/Q21092481',
    'http://www.wikidata.org/entity/Q21092502',
    'http://www.wikidata.org/entity/Q21092513',
    'http://www.wikidata.org/entity/Q21092565',
    'http://www.wikidata.org/entity/Q21092716',
    'http://www.wikidata.org/entity/Q21092718',
    'http://www.wikidata.org/entity/Q21092720',
    'http://www.wikidata.org/entity/Q21092733',
    'http://www.wikidata.org/entity/Q21092736',
    'http://www.wikidata.org/entity/Q21092742',
    'http://www.wikidata.org/entity/Q21092751',
    'http://www.wikidata.org/entity/Q21092763',
    'http://www.wikidata.org/entity/Q21092840',
    'http://www.wikidata.org/entity/Q21092859',
    'http://www.wikidata.org/entity/Q21092875',
    'http://www.wikidata.org/entity/Q21092878',
    'http://www.wikidata.org/entity/Q21092879',
    'http://www.wikidata.org/entity/Q21092888',
    'http://www.wikidata.org/entity/Q21092897',
    'http://www.wikidata.org/entity/Q21092922',
    'http://www.wikidata.org/entity/Q21093194',
    'http://www.wikidata.org/entity/Q21093221',
    'http://www.wikidata.org/entity/Q21093232',
    'http://www.wikidata.org/entity/Q21093323',
    'http://www.wikidata.org/entity/Q21093386',
    'http://www.wikidata.org/entity/Q21093638',
    'http://www.wikidata.org/entity/Q21093646',
    'http://www.wikidata.org/entity/Q21094652',
    'http://www.wikidata.org/entity/Q21094858',
    'http://www.wikidata.org/entity/Q21128645',
    'http://www.wikidata.org/entity/Q21128647',
    'http://www.wikidata.org/entity/Q21128684',
    'http://www.wikidata.org/entity/Q21128766',
    'http://www.wikidata.org/entity/Q21128771',
    'http://www.wikidata.org/entity/Q21128781',
    'http://www.wikidata.org/entity/Q21128797',
    'http://www.wikidata.org/entity/Q21129037',
    'http://www.wikidata.org/entity/Q21129074',
    'http://www.wikidata.org/entity/Q21129222',
    'http://www.wikidata.org/entity/Q21129332',
    'http://www.wikidata.org/entity/Q21129496',
    'http://www.wikidata.org/entity/Q21131391',
    'http://www.wikidata.org/entity/Q21131394',
    'http://www.wikidata.org/entity/Q21131405',
    'http://www.wikidata.org/entity/Q21131409',
    'http://www.wikidata.org/entity/Q21131423',
    'http://www.wikidata.org/entity/Q21131599',
    'http://www.wikidata.org/entity/Q21131607',
    'http://www.wikidata.org/entity/Q21131610',
    'http://www.wikidata.org/entity/Q21131616',
    'http://www.wikidata.org/entity/Q21131621',
    'http://www.wikidata.org/entity/Q21131623',
    'http://www.wikidata.org/entity/Q21131626',
    'http://www.wikidata.org/entity/Q21132532',
    'http://www.wikidata.org/entity/Q21132990',
    'http://www.wikidata.org/entity/Q21133704',
    'http://www.wikidata.org/entity/Q21133930',
    'http://www.wikidata.org/entity/Q21134554',
    'http://www.wikidata.org/entity/Q21134611',
    'http://www.wikidata.org/entity/Q21134799',
    'http://www.wikidata.org/entity/Q21135257',
    'http://www.wikidata.org/entity/Q21135308',
    'http://www.wikidata.org/entity/Q21135329',
    'http://www.wikidata.org/entity/Q21135528',
    'http://www.wikidata.org/entity/Q21135549',
    'http://www.wikidata.org/entity/Q21135613',
    'http://www.wikidata.org/entity/Q21136069',
    'http://www.wikidata.org/entity/Q21136177',
    'http://www.wikidata.org/entity/Q21136317',
    'http://www.wikidata.org/entity/Q21136353',
    'http://www.wikidata.org/entity/Q21136406',
    'http://www.wikidata.org/entity/Q21142622',
    'http://www.wikidata.org/entity/Q21142738',
    'http://www.wikidata.org/entity/Q21143799',
    'http://www.wikidata.org/entity/Q21143854',
    'http://www.wikidata.org/entity/Q21143855',
    'http://www.wikidata.org/entity/Q21144210',
    'http://www.wikidata.org/entity/Q21144238',
    'http://www.wikidata.org/entity/Q21144296',
    'http://www.wikidata.org/entity/Q21144321',
    'http://www.wikidata.org/entity/Q21144355',
    'http://www.wikidata.org/entity/Q21144402',
    'http://www.wikidata.org/entity/Q21144433',
    'http://www.wikidata.org/entity/Q21144444',
    'http://www.wikidata.org/entity/Q21144455',
    'http://www.wikidata.org/entity/Q21144495',
    'http://www.wikidata.org/entity/Q21144498',
    'http://www.wikidata.org/entity/Q21144502',
    'http://www.wikidata.org/entity/Q21144503',
    'http://www.wikidata.org/entity/Q21144518',
    'http://www.wikidata.org/entity/Q21144523',
    'http://www.wikidata.org/entity/Q21144525',
    'http://www.wikidata.org/entity/Q21144557',
    'http://www.wikidata.org/entity/Q21144621',
    'http://www.wikidata.org/entity/Q21144622',
    'http://www.wikidata.org/entity/Q21144624',
    'http://www.wikidata.org/entity/Q21144627',
    'http://www.wikidata.org/entity/Q21144643',
    'http://www.wikidata.org/entity/Q21144647',
    'http://www.wikidata.org/entity/Q21144650',
    'http://www.wikidata.org/entity/Q21144657',
    'http://www.wikidata.org/entity/Q21144658',
    'http://www.wikidata.org/entity/Q21144661',
    'http://www.wikidata.org/entity/Q21144675',
    'http://www.wikidata.org/entity/Q21144685',
    'http://www.wikidata.org/entity/Q21144688',
    'http://www.wikidata.org/entity/Q21144689',
    'http://www.wikidata.org/entity/Q21144706',
    'http://www.wikidata.org/entity/Q21144712',
    'http://www.wikidata.org/entity/Q21144715',
    'http://www.wikidata.org/entity/Q21144720',
    'http://www.wikidata.org/entity/Q21144740',
    'http://www.wikidata.org/entity/Q21144780',
    'http://www.wikidata.org/entity/Q21144861',
    'http://www.wikidata.org/entity/Q21144948',
    'http://www.wikidata.org/entity/Q21144949',
    'http://www.wikidata.org/entity/Q21144952',
    'http://www.wikidata.org/entity/Q21144969',
    'http://www.wikidata.org/entity/Q21144983',
    'http://www.wikidata.org/entity/Q21144988',
    'http://www.wikidata.org/entity/Q21144992',
    'http://www.wikidata.org/entity/Q21144993',
    'http://www.wikidata.org/entity/Q21144997',
    'http://www.wikidata.org/entity/Q21145001',
    'http://www.wikidata.org/entity/Q21145003',
    'http://www.wikidata.org/entity/Q21145012',
    'http://www.wikidata.org/entity/Q21145026',
    'http://www.wikidata.org/entity/Q21145030',
    'http://www.wikidata.org/entity/Q21145032',
    'http://www.wikidata.org/entity/Q21145040',
    'http://www.wikidata.org/entity/Q21145042',
    'http://www.wikidata.org/entity/Q21145046',
    'http://www.wikidata.org/entity/Q21145056',
    'http://www.wikidata.org/entity/Q21145221',
    'http://www.wikidata.org/entity/Q21145227',
    'http://www.wikidata.org/entity/Q21145230',
    'http://www.wikidata.org/entity/Q21145248',
    'http://www.wikidata.org/entity/Q21145260',
    'http://www.wikidata.org/entity/Q21145278',
    'http://www.wikidata.org/entity/Q21145286',
    'http://www.wikidata.org/entity/Q21145347',
    'http://www.wikidata.org/entity/Q21145373',
    'http://www.wikidata.org/entity/Q21145687',
    'http://www.wikidata.org/entity/Q21145693',
    'http://www.wikidata.org/entity/Q21145696',
    'http://www.wikidata.org/entity/Q21145770',
    'http://www.wikidata.org/entity/Q21145782',
    'http://www.wikidata.org/entity/Q21145794',
    'http://www.wikidata.org/entity/Q21145802',
    'http://www.wikidata.org/entity/Q21145806',
    'http://www.wikidata.org/entity/Q21145809',
    'http://www.wikidata.org/entity/Q21145846',
    'http://www.wikidata.org/entity/Q21145862',
    'http://www.wikidata.org/entity/Q21145869',
    'http://www.wikidata.org/entity/Q21145874',
    'http://www.wikidata.org/entity/Q21145890',
    'http://www.wikidata.org/entity/Q21145898',
    'http://www.wikidata.org/entity/Q21146032',
    'http://www.wikidata.org/entity/Q21146037',
    'http://www.wikidata.org/entity/Q21146044',
    'http://www.wikidata.org/entity/Q21146047',
    'http://www.wikidata.org/entity/Q21146051',
    'http://www.wikidata.org/entity/Q21146068',
    'http://www.wikidata.org/entity/Q21146096',
    'http://www.wikidata.org/entity/Q21146285',
    'http://www.wikidata.org/entity/Q21146359',
    'http://www.wikidata.org/entity/Q21146368',
    'http://www.wikidata.org/entity/Q21146369',
    'http://www.wikidata.org/entity/Q21146381',
    'http://www.wikidata.org/entity/Q21146393',
    'http://www.wikidata.org/entity/Q21146396',
    'http://www.wikidata.org/entity/Q21146400',
    'http://www.wikidata.org/entity/Q21146401',
    'http://www.wikidata.org/entity/Q21146408',
    'http://www.wikidata.org/entity/Q21146433',
    'http://www.wikidata.org/entity/Q21146437',
    'http://www.wikidata.org/entity/Q21146441',
    'http://www.wikidata.org/entity/Q21146621',
    'http://www.wikidata.org/entity/Q21146690',
    'http://www.wikidata.org/entity/Q21147044',
    'http://www.wikidata.org/entity/Q21147047',
    'http://www.wikidata.org/entity/Q21147058',
    'http://www.wikidata.org/entity/Q21183894',
    'http://www.wikidata.org/entity/Q21183895',
    'http://www.wikidata.org/entity/Q21183902',
    'http://www.wikidata.org/entity/Q21183907',
    'http://www.wikidata.org/entity/Q21183983',
    'http://www.wikidata.org/entity/Q21183994',
    'http://www.wikidata.org/entity/Q21184009',
    'http://www.wikidata.org/entity/Q21184018',
    'http://www.wikidata.org/entity/Q21184022',
    'http://www.wikidata.org/entity/Q21184030',
    'http://www.wikidata.org/entity/Q21184103',
    'http://www.wikidata.org/entity/Q21184110',
    'http://www.wikidata.org/entity/Q21184112',
    'http://www.wikidata.org/entity/Q21184123',
    'http://www.wikidata.org/entity/Q21184138',
    'http://www.wikidata.org/entity/Q21184141',
    'http://www.wikidata.org/entity/Q21184167',
    'http://www.wikidata.org/entity/Q21184168',
    'http://www.wikidata.org/entity/Q21184175',
    'http://www.wikidata.org/entity/Q21194846',
    'http://www.wikidata.org/entity/Q21194851',
    'http://www.wikidata.org/entity/Q21194861',
    'http://www.wikidata.org/entity/Q21194867',
    'http://www.wikidata.org/entity/Q21195041',
    'http://www.wikidata.org/entity/Q21195082',
    'http://www.wikidata.org/entity/Q21195211',
    'http://www.wikidata.org/entity/Q21195215',
    'http://www.wikidata.org/entity/Q21195421',
    'http://www.wikidata.org/entity/Q21195843',
    'http://www.wikidata.org/entity/Q21198697',
    'http://www.wikidata.org/entity/Q21198766',
    'http://www.wikidata.org/entity/Q21198868',
    'http://www.wikidata.org/entity/Q21198917',
    'http://www.wikidata.org/entity/Q21198944',
    'http://www.wikidata.org/entity/Q21202053',
    'http://www.wikidata.org/entity/Q21203135',
    'http://www.wikidata.org/entity/Q21203780',
    'http://www.wikidata.org/entity/Q21223673',
    'http://www.wikidata.org/entity/Q21245260',
    'http://www.wikidata.org/entity/Q21245262',
    'http://www.wikidata.org/entity/Q21245265',
    'http://www.wikidata.org/entity/Q21245271',
    'http://www.wikidata.org/entity/Q21245281',
    'http://www.wikidata.org/entity/Q21245286',
    'http://www.wikidata.org/entity/Q21245309',
    'http://www.wikidata.org/entity/Q21245495',
    'http://www.wikidata.org/entity/Q21245705',
    'http://www.wikidata.org/entity/Q21245710',
    'http://www.wikidata.org/entity/Q21245767',
    'http://www.wikidata.org/entity/Q21245891',
    'http://www.wikidata.org/entity/Q21254567',
    'http://www.wikidata.org/entity/Q21254606',
    'http://www.wikidata.org/entity/Q21257215',
    'http://www.wikidata.org/entity/Q21257222',
    'http://www.wikidata.org/entity/Q21260247',
    'http://www.wikidata.org/entity/Q21260251',
    'http://www.wikidata.org/entity/Q21260259',
    'http://www.wikidata.org/entity/Q21260264',
    'http://www.wikidata.org/entity/Q21260292',
    'http://www.wikidata.org/entity/Q21260332',
    'http://www.wikidata.org/entity/Q21261357',
    'http://www.wikidata.org/entity/Q21261358',
    'http://www.wikidata.org/entity/Q21261848',
    'http://www.wikidata.org/entity/Q21262976',
    'http://www.wikidata.org/entity/Q21263010',
    'http://www.wikidata.org/entity/Q21263129',
    'http://www.wikidata.org/entity/Q21263157',
    'http://www.wikidata.org/entity/Q21266548',
    'http://www.wikidata.org/entity/Q21266566',
    'http://www.wikidata.org/entity/Q21266573',
    'http://www.wikidata.org/entity/Q21266584',
    'http://www.wikidata.org/entity/Q21266606',
    'http://www.wikidata.org/entity/Q21266698',
    'http://www.wikidata.org/entity/Q21267188',
    'http://www.wikidata.org/entity/Q21267209',
    'http://www.wikidata.org/entity/Q21283970',
    'http://www.wikidata.org/entity/Q21283975',
    'http://www.wikidata.org/entity/Q21284194',
    'http://www.wikidata.org/entity/Q21284200',
    'http://www.wikidata.org/entity/Q21284202',
    'http://www.wikidata.org/entity/Q21284208',
    'http://www.wikidata.org/entity/Q21284219',
    'http://www.wikidata.org/entity/Q21284230',
    'http://www.wikidata.org/entity/Q21284234',
    'http://www.wikidata.org/entity/Q21284241',
    'http://www.wikidata.org/entity/Q21284285',
    'http://www.wikidata.org/entity/Q21284290',
    'http://www.wikidata.org/entity/Q21284294',
    'http://www.wikidata.org/entity/Q21284295',
    'http://www.wikidata.org/entity/Q21284296',
    'http://www.wikidata.org/entity/Q21284335',
    'http://www.wikidata.org/entity/Q21284368',
    'http://www.wikidata.org/entity/Q21284370',
    'http://www.wikidata.org/entity/Q21284375',
    'http://www.wikidata.org/entity/Q21284500',
    'http://www.wikidata.org/entity/Q21285153',
    'http://www.wikidata.org/entity/Q21296784',
    'http://www.wikidata.org/entity/Q21296817',
    'http://www.wikidata.org/entity/Q21342816',
    'http://www.wikidata.org/entity/Q21342839',
    'http://www.wikidata.org/entity/Q21481859',
    'http://www.wikidata.org/entity/Q21508827',
    'http://www.wikidata.org/entity/Q21521427',
    'http://www.wikidata.org/entity/Q21521430',
    'http://www.wikidata.org/entity/Q21534928',
    'http://www.wikidata.org/entity/Q21558572',
    'http://www.wikidata.org/entity/Q21558628',
    'http://www.wikidata.org/entity/Q21558779',
    'http://www.wikidata.org/entity/Q21559402',
    'http://www.wikidata.org/entity/Q21559409',
    'http://www.wikidata.org/entity/Q21559416',
    'http://www.wikidata.org/entity/Q21559421',
    'http://www.wikidata.org/entity/Q21559464',
    'http://www.wikidata.org/entity/Q21559499',
    'http://www.wikidata.org/entity/Q21559504',
    'http://www.wikidata.org/entity/Q21560848',
    'http://www.wikidata.org/entity/Q21560852',
    'http://www.wikidata.org/entity/Q21560921',
    'http://www.wikidata.org/entity/Q21560928',
    'http://www.wikidata.org/entity/Q21560953',
    'http://www.wikidata.org/entity/Q21562139',
    'http://www.wikidata.org/entity/Q21562179',
    'http://www.wikidata.org/entity/Q21562196',
    'http://www.wikidata.org/entity/Q21562249',
    'http://www.wikidata.org/entity/Q21562255',
    'http://www.wikidata.org/entity/Q21562256',
    'http://www.wikidata.org/entity/Q21562278',
    'http://www.wikidata.org/entity/Q21562281',
    'http://www.wikidata.org/entity/Q21562306',
    'http://www.wikidata.org/entity/Q21562320',
    'http://www.wikidata.org/entity/Q21562333',
    'http://www.wikidata.org/entity/Q21562478',
    'http://www.wikidata.org/entity/Q21562507',
    'http://www.wikidata.org/entity/Q21562542',
    'http://www.wikidata.org/entity/Q21562557',
    'http://www.wikidata.org/entity/Q21562589',
    'http://www.wikidata.org/entity/Q21563315',
    'http://www.wikidata.org/entity/Q21563317',
    'http://www.wikidata.org/entity/Q21563319',
    'http://www.wikidata.org/entity/Q21563350',
    'http://www.wikidata.org/entity/Q21563374',
    'http://www.wikidata.org/entity/Q21563391',
    'http://www.wikidata.org/entity/Q21563399',
    'http://www.wikidata.org/entity/Q21563408',
    'http://www.wikidata.org/entity/Q21563446',
    'http://www.wikidata.org/entity/Q21563449',
    'http://www.wikidata.org/entity/Q21563452',
    'http://www.wikidata.org/entity/Q21563456',
    'http://www.wikidata.org/entity/Q21563490',
    'http://www.wikidata.org/entity/Q21563491',
    'http://www.wikidata.org/entity/Q21563495',
    'http://www.wikidata.org/entity/Q21563528',
    'http://www.wikidata.org/entity/Q21563530',
    'http://www.wikidata.org/entity/Q21563547',
    'http://www.wikidata.org/entity/Q21563551',
    'http://www.wikidata.org/entity/Q21563555',
    'http://www.wikidata.org/entity/Q21563557',
    'http://www.wikidata.org/entity/Q21563561',
    'http://www.wikidata.org/entity/Q21563563',
    'http://www.wikidata.org/entity/Q21563598',
    'http://www.wikidata.org/entity/Q21563616',
    'http://www.wikidata.org/entity/Q21563617',
    'http://www.wikidata.org/entity/Q21563623',
    'http://www.wikidata.org/entity/Q21563624',
    'http://www.wikidata.org/entity/Q21563625',
    'http://www.wikidata.org/entity/Q21563630',
    'http://www.wikidata.org/entity/Q21563636',
    'http://www.wikidata.org/entity/Q21563637',
    'http://www.wikidata.org/entity/Q21563638',
    'http://www.wikidata.org/entity/Q21563646',
    'http://www.wikidata.org/entity/Q21563680',
    'http://www.wikidata.org/entity/Q21563711',
    'http://www.wikidata.org/entity/Q21563713',
    'http://www.wikidata.org/entity/Q21563748',
    'http://www.wikidata.org/entity/Q21563828',
    'http://www.wikidata.org/entity/Q21563873',
    'http://www.wikidata.org/entity/Q21563939',
    'http://www.wikidata.org/entity/Q21651041',
    'http://www.wikidata.org/entity/Q21651547',
    'http://www.wikidata.org/entity/Q21666110',
    'http://www.wikidata.org/entity/Q21686179',
    'http://www.wikidata.org/entity/Q21694527',
    'http://www.wikidata.org/entity/Q21698173',
    'http://www.wikidata.org/entity/Q21698303',
    'http://www.wikidata.org/entity/Q21698325',
    'http://www.wikidata.org/entity/Q21698586',
    'http://www.wikidata.org/entity/Q21698590',
    'http://www.wikidata.org/entity/Q21698608',
    'http://www.wikidata.org/entity/Q21698763',
    'http://www.wikidata.org/entity/Q21698912',
    'http://www.wikidata.org/entity/Q21698949',
    'http://www.wikidata.org/entity/Q21706166',
    'http://www.wikidata.org/entity/Q21706191',
    'http://www.wikidata.org/entity/Q21706237',
    'http://www.wikidata.org/entity/Q21706258',
    'http://www.wikidata.org/entity/Q21706398',
    'http://www.wikidata.org/entity/Q21706433',
    'http://www.wikidata.org/entity/Q21706555',
    'http://www.wikidata.org/entity/Q21708350',
    'http://www.wikidata.org/entity/Q21708488',
    'http://www.wikidata.org/entity/Q21708504',
    'http://www.wikidata.org/entity/Q21708802',
    'http://www.wikidata.org/entity/Q21708840',
    'http://www.wikidata.org/entity/Q21709057',
    'http://www.wikidata.org/entity/Q21709091',
    'http://www.wikidata.org/entity/Q21709313',
    'http://www.wikidata.org/entity/Q21709392',
    'http://www.wikidata.org/entity/Q21710682',
    'http://www.wikidata.org/entity/Q21710698',
    'http://www.wikidata.org/entity/Q21735916',
    'http://www.wikidata.org/entity/Q21735918',
    'http://www.wikidata.org/entity/Q21735921',
    'http://www.wikidata.org/entity/Q21735927',
    'http://www.wikidata.org/entity/Q21735929',
    'http://www.wikidata.org/entity/Q21735930',
    'http://www.wikidata.org/entity/Q21735934',
    'http://www.wikidata.org/entity/Q21972822',
    'http://www.wikidata.org/entity/Q21972828',
    'http://www.wikidata.org/entity/Q21972837',
    'http://www.wikidata.org/entity/Q21972841',
    'http://www.wikidata.org/entity/Q21972843',
    'http://www.wikidata.org/entity/Q21972844',
    'http://www.wikidata.org/entity/Q21972851',
    'http://www.wikidata.org/entity/Q21994396',
    'http://www.wikidata.org/entity/Q21994463',
    'http://www.wikidata.org/entity/Q21994528',
    'http://www.wikidata.org/entity/Q21996341',
    'http://www.wikidata.org/entity/Q21999020',
    'http://www.wikidata.org/entity/Q21999032',
    'http://www.wikidata.org/entity/Q21999078',
    'http://www.wikidata.org/entity/Q21999527',
    'http://www.wikidata.org/entity/Q21999542',
    'http://www.wikidata.org/entity/Q22000127',
    'http://www.wikidata.org/entity/Q22001452',
    'http://www.wikidata.org/entity/Q22001503',
    'http://www.wikidata.org/entity/Q22001504',
    'http://www.wikidata.org/entity/Q22001513',
    'http://www.wikidata.org/entity/Q22001532',
    'http://www.wikidata.org/entity/Q22003770',
    'http://www.wikidata.org/entity/Q22003872',
    'http://www.wikidata.org/entity/Q22003890',
    'http://www.wikidata.org/entity/Q22003891',
    'http://www.wikidata.org/entity/Q22003951',
    'http://www.wikidata.org/entity/Q22003954',
    'http://www.wikidata.org/entity/Q22003973',
    'http://www.wikidata.org/entity/Q22004174',
    'http://www.wikidata.org/entity/Q22004178',
    'http://www.wikidata.org/entity/Q22004269',
    'http://www.wikidata.org/entity/Q22007971',
    'http://www.wikidata.org/entity/Q22007974',
    'http://www.wikidata.org/entity/Q22007981',
    'http://www.wikidata.org/entity/Q22008002',
    'http://www.wikidata.org/entity/Q22008015',
    'http://www.wikidata.org/entity/Q22008022',
    'http://www.wikidata.org/entity/Q22008465',
    'http://www.wikidata.org/entity/Q22008484',
    'http://www.wikidata.org/entity/Q22008492',
    'http://www.wikidata.org/entity/Q22008502',
    'http://www.wikidata.org/entity/Q22008508',
    'http://www.wikidata.org/entity/Q22008514',
    'http://www.wikidata.org/entity/Q22008528',
    'http://www.wikidata.org/entity/Q22008543',
    'http://www.wikidata.org/entity/Q22008544',
    'http://www.wikidata.org/entity/Q22008551',
    'http://www.wikidata.org/entity/Q22008560',
    'http://www.wikidata.org/entity/Q22008569',
    'http://www.wikidata.org/entity/Q22008570',
    'http://www.wikidata.org/entity/Q22008574',
    'http://www.wikidata.org/entity/Q22008582',
    'http://www.wikidata.org/entity/Q22008584',
    'http://www.wikidata.org/entity/Q22008612',
    'http://www.wikidata.org/entity/Q22008645',
    'http://www.wikidata.org/entity/Q22008661',
    'http://www.wikidata.org/entity/Q22008676',
    'http://www.wikidata.org/entity/Q22008682',
    'http://www.wikidata.org/entity/Q22008705',
    'http://www.wikidata.org/entity/Q22008727',
    'http://www.wikidata.org/entity/Q22008730',
    'http://www.wikidata.org/entity/Q22008754',
    'http://www.wikidata.org/entity/Q22008808',
    'http://www.wikidata.org/entity/Q22009022',
    'http://www.wikidata.org/entity/Q22009034',
    'http://www.wikidata.org/entity/Q22009078',
    'http://www.wikidata.org/entity/Q22009084',
    'http://www.wikidata.org/entity/Q22009096',
    'http://www.wikidata.org/entity/Q22009125',
    'http://www.wikidata.org/entity/Q22009126',
    'http://www.wikidata.org/entity/Q22009379',
    'http://www.wikidata.org/entity/Q22009393',
    'http://www.wikidata.org/entity/Q22009394',
    'http://www.wikidata.org/entity/Q22009407',
    'http://www.wikidata.org/entity/Q22009462',
    'http://www.wikidata.org/entity/Q22009519',
    'http://www.wikidata.org/entity/Q22009563',
    'http://www.wikidata.org/entity/Q22009893',
    'http://www.wikidata.org/entity/Q22009928',
    'http://www.wikidata.org/entity/Q22009936',
    'http://www.wikidata.org/entity/Q22009943',
    'http://www.wikidata.org/entity/Q22009974',
    'http://www.wikidata.org/entity/Q22010046',
    'http://www.wikidata.org/entity/Q22010047',
    'http://www.wikidata.org/entity/Q22010058',
    'http://www.wikidata.org/entity/Q22010063',
    'http://www.wikidata.org/entity/Q22010149',
    'http://www.wikidata.org/entity/Q22010150',
    'http://www.wikidata.org/entity/Q22010155',
    'http://www.wikidata.org/entity/Q22010158',
    'http://www.wikidata.org/entity/Q22010159',
    'http://www.wikidata.org/entity/Q22010164',
    'http://www.wikidata.org/entity/Q22010191',
    'http://www.wikidata.org/entity/Q22010192',
    'http://www.wikidata.org/entity/Q22010198',
    'http://www.wikidata.org/entity/Q22010200',
    'http://www.wikidata.org/entity/Q22010201',
    'http://www.wikidata.org/entity/Q22010236',
    'http://www.wikidata.org/entity/Q22010245',
    'http://www.wikidata.org/entity/Q22010372',
    'http://www.wikidata.org/entity/Q22010440',
    'http://www.wikidata.org/entity/Q22010441',
    'http://www.wikidata.org/entity/Q22010442',
    'http://www.wikidata.org/entity/Q22010443',
    'http://www.wikidata.org/entity/Q22010457',
    'http://www.wikidata.org/entity/Q22010466',
    'http://www.wikidata.org/entity/Q22010473',
    'http://www.wikidata.org/entity/Q22010577',
    'http://www.wikidata.org/entity/Q22010594',
    'http://www.wikidata.org/entity/Q22010648',
    'http://www.wikidata.org/entity/Q22010650',
    'http://www.wikidata.org/entity/Q22010685',
    'http://www.wikidata.org/entity/Q22010705',
    'http://www.wikidata.org/entity/Q22010765',
    'http://www.wikidata.org/entity/Q22010773',
    'http://www.wikidata.org/entity/Q22010790',
    'http://www.wikidata.org/entity/Q22010800',
    'http://www.wikidata.org/entity/Q22010808',
    'http://www.wikidata.org/entity/Q22010821',
    'http://www.wikidata.org/entity/Q22010837',
    'http://www.wikidata.org/entity/Q22010866',
    'http://www.wikidata.org/entity/Q22010912',
    'http://www.wikidata.org/entity/Q22010914',
    'http://www.wikidata.org/entity/Q22010951',
    'http://www.wikidata.org/entity/Q22010952',
    'http://www.wikidata.org/entity/Q22010955',
    'http://www.wikidata.org/entity/Q22011000',
    'http://www.wikidata.org/entity/Q22011017',
    'http://www.wikidata.org/entity/Q22011018',
    'http://www.wikidata.org/entity/Q22011049',
    'http://www.wikidata.org/entity/Q22011091',
    'http://www.wikidata.org/entity/Q22011167',
    'http://www.wikidata.org/entity/Q22061726',
    'http://www.wikidata.org/entity/Q22061731',
    'http://www.wikidata.org/entity/Q22061740',
    'http://www.wikidata.org/entity/Q22061741',
    'http://www.wikidata.org/entity/Q22061778',
    'http://www.wikidata.org/entity/Q22061782',
    'http://www.wikidata.org/entity/Q22061790',
    'http://www.wikidata.org/entity/Q22061798',
    'http://www.wikidata.org/entity/Q22061799',
    'http://www.wikidata.org/entity/Q22061852',
    'http://www.wikidata.org/entity/Q22061854',
    'http://www.wikidata.org/entity/Q22061863',
    'http://www.wikidata.org/entity/Q22061872',
    'http://www.wikidata.org/entity/Q22061873',
    'http://www.wikidata.org/entity/Q22061876',
    'http://www.wikidata.org/entity/Q22061877',
    'http://www.wikidata.org/entity/Q22061943',
    'http://www.wikidata.org/entity/Q22064504',
    'http://www.wikidata.org/entity/Q22064572',
    'http://www.wikidata.org/entity/Q22064599',
    'http://www.wikidata.org/entity/Q22065252',
    'http://www.wikidata.org/entity/Q22065275',
    'http://www.wikidata.org/entity/Q22065366',
    'http://www.wikidata.org/entity/Q22065370',
    'http://www.wikidata.org/entity/Q22065375',
    'http://www.wikidata.org/entity/Q22065376',
    'http://www.wikidata.org/entity/Q22065386',
    'http://www.wikidata.org/entity/Q22065392',
    'http://www.wikidata.org/entity/Q22065393',
    'http://www.wikidata.org/entity/Q22065411',
    'http://www.wikidata.org/entity/Q22065419',
    'http://www.wikidata.org/entity/Q22065445',
    'http://www.wikidata.org/entity/Q22065459',
    'http://www.wikidata.org/entity/Q22065462',
    'http://www.wikidata.org/entity/Q22065464',
    'http://www.wikidata.org/entity/Q22065515',
    'http://www.wikidata.org/entity/Q22065541',
    'http://www.wikidata.org/entity/Q22065545',
    'http://www.wikidata.org/entity/Q22065549',
    'http://www.wikidata.org/entity/Q22065553',
    'http://www.wikidata.org/entity/Q22065556',
    'http://www.wikidata.org/entity/Q22065557',
    'http://www.wikidata.org/entity/Q22065559',
    'http://www.wikidata.org/entity/Q22065564',
    'http://www.wikidata.org/entity/Q22065571',
    'http://www.wikidata.org/entity/Q22065573',
    'http://www.wikidata.org/entity/Q22065574',
    'http://www.wikidata.org/entity/Q22065591',
    'http://www.wikidata.org/entity/Q22065600',
    'http://www.wikidata.org/entity/Q22065603',
    'http://www.wikidata.org/entity/Q22065604',
    'http://www.wikidata.org/entity/Q22065607',
    'http://www.wikidata.org/entity/Q22065647',
    'http://www.wikidata.org/entity/Q22065654',
    'http://www.wikidata.org/entity/Q22065657',
    'http://www.wikidata.org/entity/Q22065662',
    'http://www.wikidata.org/entity/Q22065674',
    'http://www.wikidata.org/entity/Q22065694',
    'http://www.wikidata.org/entity/Q22065751',
    'http://www.wikidata.org/entity/Q22065761',
    'http://www.wikidata.org/entity/Q22065780',
    'http://www.wikidata.org/entity/Q22065783',
    'http://www.wikidata.org/entity/Q22065796',
    'http://www.wikidata.org/entity/Q22065797',
    'http://www.wikidata.org/entity/Q22065798',
    'http://www.wikidata.org/entity/Q22065799',
    'http://www.wikidata.org/entity/Q22065802',
    'http://www.wikidata.org/entity/Q22065807',
    'http://www.wikidata.org/entity/Q22065810',
    'http://www.wikidata.org/entity/Q22065811',
    'http://www.wikidata.org/entity/Q22065813',
    'http://www.wikidata.org/entity/Q22065818',
    'http://www.wikidata.org/entity/Q22065819',
    'http://www.wikidata.org/entity/Q22065823',
    'http://www.wikidata.org/entity/Q22065825',
    'http://www.wikidata.org/entity/Q22065826',
    'http://www.wikidata.org/entity/Q22065827',
    'http://www.wikidata.org/entity/Q22065828',
    'http://www.wikidata.org/entity/Q22065831',
    'http://www.wikidata.org/entity/Q22065834',
    'http://www.wikidata.org/entity/Q22065835',
    'http://www.wikidata.org/entity/Q22065838',
    'http://www.wikidata.org/entity/Q22065840',
    'http://www.wikidata.org/entity/Q22065841',
    'http://www.wikidata.org/entity/Q22065842',
    'http://www.wikidata.org/entity/Q22065852',
    'http://www.wikidata.org/entity/Q22065853',
    'http://www.wikidata.org/entity/Q22065864',
    'http://www.wikidata.org/entity/Q22065867',
    'http://www.wikidata.org/entity/Q22065869',
    'http://www.wikidata.org/entity/Q22065872',
    'http://www.wikidata.org/entity/Q22065873',
    'http://www.wikidata.org/entity/Q22065874',
    'http://www.wikidata.org/entity/Q22065876',
    'http://www.wikidata.org/entity/Q22065877',
    'http://www.wikidata.org/entity/Q22065878',
    'http://www.wikidata.org/entity/Q22065880',
    'http://www.wikidata.org/entity/Q22065883',
    'http://www.wikidata.org/entity/Q22065887',
    'http://www.wikidata.org/entity/Q22065889',
    'http://www.wikidata.org/entity/Q22065890',
    'http://www.wikidata.org/entity/Q22065891',
    'http://www.wikidata.org/entity/Q22065892',
    'http://www.wikidata.org/entity/Q22065895',
    'http://www.wikidata.org/entity/Q22065896',
    'http://www.wikidata.org/entity/Q22065897',
    'http://www.wikidata.org/entity/Q22065898',
    'http://www.wikidata.org/entity/Q22065899',
    'http://www.wikidata.org/entity/Q22065900',
    'http://www.wikidata.org/entity/Q22065975',
    'http://www.wikidata.org/entity/Q22065976',
    'http://www.wikidata.org/entity/Q22065989',
    'http://www.wikidata.org/entity/Q22066003',
    'http://www.wikidata.org/entity/Q22066036',
    'http://www.wikidata.org/entity/Q22066043',
    'http://www.wikidata.org/entity/Q22066088',
    'http://www.wikidata.org/entity/Q22066105',
    'http://www.wikidata.org/entity/Q22066123',
    'http://www.wikidata.org/entity/Q22066139',
    'http://www.wikidata.org/entity/Q22066140',
    'http://www.wikidata.org/entity/Q22066172',
    'http://www.wikidata.org/entity/Q22066179',
    'http://www.wikidata.org/entity/Q22066195',
    'http://www.wikidata.org/entity/Q22066200',
    'http://www.wikidata.org/entity/Q22066206',
    'http://www.wikidata.org/entity/Q22066207',
    'http://www.wikidata.org/entity/Q22066209',
    'http://www.wikidata.org/entity/Q22066245',
    'http://www.wikidata.org/entity/Q22066257',
    'http://www.wikidata.org/entity/Q22066275',
    'http://www.wikidata.org/entity/Q22066281',
    'http://www.wikidata.org/entity/Q22066282',
    'http://www.wikidata.org/entity/Q22066284',
    'http://www.wikidata.org/entity/Q22066298',
    'http://www.wikidata.org/entity/Q22066310',
    'http://www.wikidata.org/entity/Q22066312',
    'http://www.wikidata.org/entity/Q22066315',
    'http://www.wikidata.org/entity/Q22066325',
    'http://www.wikidata.org/entity/Q22066348',
    'http://www.wikidata.org/entity/Q22066352',
    'http://www.wikidata.org/entity/Q22066387',
    'http://www.wikidata.org/entity/Q22066389',
    'http://www.wikidata.org/entity/Q22121929',
    'http://www.wikidata.org/entity/Q22121931',
    'http://www.wikidata.org/entity/Q22121933',
    'http://www.wikidata.org/entity/Q22121951',
    'http://www.wikidata.org/entity/Q22121990',
    'http://www.wikidata.org/entity/Q22121992',
    'http://www.wikidata.org/entity/Q22121993',
    'http://www.wikidata.org/entity/Q22121996',
    'http://www.wikidata.org/entity/Q22121998',
    'http://www.wikidata.org/entity/Q22122002',
    'http://www.wikidata.org/entity/Q22122003',
    'http://www.wikidata.org/entity/Q22122006',
    'http://www.wikidata.org/entity/Q22122008',
    'http://www.wikidata.org/entity/Q22122009',
    'http://www.wikidata.org/entity/Q22122010',
    'http://www.wikidata.org/entity/Q22122015',
    'http://www.wikidata.org/entity/Q22122017',
    'http://www.wikidata.org/entity/Q22122018',
    'http://www.wikidata.org/entity/Q22122019',
    'http://www.wikidata.org/entity/Q22122021',
    'http://www.wikidata.org/entity/Q22122024',
    'http://www.wikidata.org/entity/Q22122027',
    'http://www.wikidata.org/entity/Q22122035',
    'http://www.wikidata.org/entity/Q22122044',
    'http://www.wikidata.org/entity/Q22122046',
    'http://www.wikidata.org/entity/Q22122047',
    'http://www.wikidata.org/entity/Q22122053',
    'http://www.wikidata.org/entity/Q22122056',
    'http://www.wikidata.org/entity/Q22122058',
    'http://www.wikidata.org/entity/Q22122060',
    'http://www.wikidata.org/entity/Q22122065',
    'http://www.wikidata.org/entity/Q22122076',
    'http://www.wikidata.org/entity/Q22122077',
    'http://www.wikidata.org/entity/Q22122078',
    'http://www.wikidata.org/entity/Q22122079',
    'http://www.wikidata.org/entity/Q22122083',
    'http://www.wikidata.org/entity/Q22122084',
    'http://www.wikidata.org/entity/Q22122094',
    'http://www.wikidata.org/entity/Q22122107',
    'http://www.wikidata.org/entity/Q22122108',
    'http://www.wikidata.org/entity/Q22122125',
    'http://www.wikidata.org/entity/Q22122140',
    'http://www.wikidata.org/entity/Q22122143',
    'http://www.wikidata.org/entity/Q22122144',
    'http://www.wikidata.org/entity/Q22122150',
    'http://www.wikidata.org/entity/Q22122151',
    'http://www.wikidata.org/entity/Q22122152',
    'http://www.wikidata.org/entity/Q22122153',
    'http://www.wikidata.org/entity/Q22122156',
    'http://www.wikidata.org/entity/Q22122158',
    'http://www.wikidata.org/entity/Q22122162',
    'http://www.wikidata.org/entity/Q22122163',
    'http://www.wikidata.org/entity/Q22122164',
    'http://www.wikidata.org/entity/Q22122167',
    'http://www.wikidata.org/entity/Q22122169',
    'http://www.wikidata.org/entity/Q22122173',
    'http://www.wikidata.org/entity/Q22122174',
    'http://www.wikidata.org/entity/Q22122176',
    'http://www.wikidata.org/entity/Q22122180',
    'http://www.wikidata.org/entity/Q22122181',
    'http://www.wikidata.org/entity/Q22122189',
    'http://www.wikidata.org/entity/Q22122192',
    'http://www.wikidata.org/entity/Q22122194',
    'http://www.wikidata.org/entity/Q22122196',
    'http://www.wikidata.org/entity/Q22122197',
    'http://www.wikidata.org/entity/Q22122198',
    'http://www.wikidata.org/entity/Q22122199',
    'http://www.wikidata.org/entity/Q22122200',
    'http://www.wikidata.org/entity/Q22122202',
    'http://www.wikidata.org/entity/Q22122204',
    'http://www.wikidata.org/entity/Q22122208',
    'http://www.wikidata.org/entity/Q22122209',
    'http://www.wikidata.org/entity/Q22122211',
    'http://www.wikidata.org/entity/Q22122214',
    'http://www.wikidata.org/entity/Q22122215',
    'http://www.wikidata.org/entity/Q22122216',
    'http://www.wikidata.org/entity/Q22122217',
    'http://www.wikidata.org/entity/Q22122220',
    'http://www.wikidata.org/entity/Q22122221',
    'http://www.wikidata.org/entity/Q22122222',
    'http://www.wikidata.org/entity/Q22122223',
    'http://www.wikidata.org/entity/Q22122226',
    'http://www.wikidata.org/entity/Q22122227',
    'http://www.wikidata.org/entity/Q22122228',
    'http://www.wikidata.org/entity/Q22122229',
    'http://www.wikidata.org/entity/Q22122230',
    'http://www.wikidata.org/entity/Q22122231',
    'http://www.wikidata.org/entity/Q22122234',
    'http://www.wikidata.org/entity/Q22122237',
    'http://www.wikidata.org/entity/Q22122301',
    'http://www.wikidata.org/entity/Q22122352',
    'http://www.wikidata.org/entity/Q22122353',
    'http://www.wikidata.org/entity/Q22122355',
    'http://www.wikidata.org/entity/Q22122357',
    'http://www.wikidata.org/entity/Q22122360',
    'http://www.wikidata.org/entity/Q22122361',
    'http://www.wikidata.org/entity/Q22122362',
    'http://www.wikidata.org/entity/Q22122366',
    'http://www.wikidata.org/entity/Q22122367',
    'http://www.wikidata.org/entity/Q22122369',
    'http://www.wikidata.org/entity/Q22122370',
    'http://www.wikidata.org/entity/Q22122371',
    'http://www.wikidata.org/entity/Q22122379',
    'http://www.wikidata.org/entity/Q22122381',
    'http://www.wikidata.org/entity/Q22122382',
    'http://www.wikidata.org/entity/Q22122385',
    'http://www.wikidata.org/entity/Q22122387',
    'http://www.wikidata.org/entity/Q22122393',
    'http://www.wikidata.org/entity/Q22122394',
    'http://www.wikidata.org/entity/Q22122396',
    'http://www.wikidata.org/entity/Q22122397',
    'http://www.wikidata.org/entity/Q22122398',
    'http://www.wikidata.org/entity/Q22122399',
    'http://www.wikidata.org/entity/Q22122401',
    'http://www.wikidata.org/entity/Q22122402',
    'http://www.wikidata.org/entity/Q22122407',
    'http://www.wikidata.org/entity/Q22122411',
    'http://www.wikidata.org/entity/Q22122425',
    'http://www.wikidata.org/entity/Q22122428',
    'http://www.wikidata.org/entity/Q22122430',
    'http://www.wikidata.org/entity/Q22122432',
    'http://www.wikidata.org/entity/Q22122435',
    'http://www.wikidata.org/entity/Q22122443',
    'http://www.wikidata.org/entity/Q22122457',
    'http://www.wikidata.org/entity/Q22122460',
    'http://www.wikidata.org/entity/Q22122462',
    'http://www.wikidata.org/entity/Q22122464',
    'http://www.wikidata.org/entity/Q22122465',
    'http://www.wikidata.org/entity/Q22122466',
    'http://www.wikidata.org/entity/Q22122468',
    'http://www.wikidata.org/entity/Q22122475',
    'http://www.wikidata.org/entity/Q22122479',
    'http://www.wikidata.org/entity/Q22122481',
    'http://www.wikidata.org/entity/Q22122482',
    'http://www.wikidata.org/entity/Q22122483',
    'http://www.wikidata.org/entity/Q22122484',
    'http://www.wikidata.org/entity/Q22122487',
    'http://www.wikidata.org/entity/Q22122488',
    'http://www.wikidata.org/entity/Q22122491',
    'http://www.wikidata.org/entity/Q22122497',
    'http://www.wikidata.org/entity/Q22122498',
    'http://www.wikidata.org/entity/Q22122502',
    'http://www.wikidata.org/entity/Q22122503',
    'http://www.wikidata.org/entity/Q22122505',
    'http://www.wikidata.org/entity/Q22122511',
    'http://www.wikidata.org/entity/Q22122512',
    'http://www.wikidata.org/entity/Q22122516',
    'http://www.wikidata.org/entity/Q22122521',
    'http://www.wikidata.org/entity/Q22122524',
    'http://www.wikidata.org/entity/Q221226',
    'http://www.wikidata.org/entity/Q22162492',
    'http://www.wikidata.org/entity/Q22162497',
    'http://www.wikidata.org/entity/Q22162505',
    'http://www.wikidata.org/entity/Q22240545',
    'http://www.wikidata.org/entity/Q22240615',
    'http://www.wikidata.org/entity/Q22240838',
    'http://www.wikidata.org/entity/Q22240841',
    'http://www.wikidata.org/entity/Q22241102',
    'http://www.wikidata.org/entity/Q22241113',
    'http://www.wikidata.org/entity/Q22241138',
    'http://www.wikidata.org/entity/Q22241139',
    'http://www.wikidata.org/entity/Q22241143',
    'http://www.wikidata.org/entity/Q22241144',
    'http://www.wikidata.org/entity/Q22241145',
    'http://www.wikidata.org/entity/Q22241227',
    'http://www.wikidata.org/entity/Q22241238',
    'http://www.wikidata.org/entity/Q22241243',
    'http://www.wikidata.org/entity/Q22241244',
    'http://www.wikidata.org/entity/Q22241278',
    'http://www.wikidata.org/entity/Q22241283',
    'http://www.wikidata.org/entity/Q22241286',
    'http://www.wikidata.org/entity/Q22241287',
    'http://www.wikidata.org/entity/Q22241288',
    'http://www.wikidata.org/entity/Q22241292',
    'http://www.wikidata.org/entity/Q22241393',
    'http://www.wikidata.org/entity/Q22241422',
    'http://www.wikidata.org/entity/Q22241451',
    'http://www.wikidata.org/entity/Q22241453',
    'http://www.wikidata.org/entity/Q22241500',
    'http://www.wikidata.org/entity/Q22241506',
    'http://www.wikidata.org/entity/Q22241518',
    'http://www.wikidata.org/entity/Q22241534',
    'http://www.wikidata.org/entity/Q22241538',
    'http://www.wikidata.org/entity/Q22241572',
    'http://www.wikidata.org/entity/Q22241595',
    'http://www.wikidata.org/entity/Q22241638',
    'http://www.wikidata.org/entity/Q22241644',
    'http://www.wikidata.org/entity/Q22241654',
    'http://www.wikidata.org/entity/Q22241655',
    'http://www.wikidata.org/entity/Q22241659',
    'http://www.wikidata.org/entity/Q22241664',
    'http://www.wikidata.org/entity/Q22241666',
    'http://www.wikidata.org/entity/Q22241669',
    'http://www.wikidata.org/entity/Q22241683',
    'http://www.wikidata.org/entity/Q22241687',
    'http://www.wikidata.org/entity/Q22241688',
    'http://www.wikidata.org/entity/Q22241700',
    'http://www.wikidata.org/entity/Q22241718',
    'http://www.wikidata.org/entity/Q22241759',
    'http://www.wikidata.org/entity/Q22241762',
    'http://www.wikidata.org/entity/Q22241772',
    'http://www.wikidata.org/entity/Q22241794',
    'http://www.wikidata.org/entity/Q22241864',
    'http://www.wikidata.org/entity/Q22241865',
    'http://www.wikidata.org/entity/Q22241872',
    'http://www.wikidata.org/entity/Q22241876',
    'http://www.wikidata.org/entity/Q22241878',
    'http://www.wikidata.org/entity/Q22241893',
    'http://www.wikidata.org/entity/Q22241895',
    'http://www.wikidata.org/entity/Q22241898',
    'http://www.wikidata.org/entity/Q22241905',
    'http://www.wikidata.org/entity/Q22241907',
    'http://www.wikidata.org/entity/Q22241912',
    'http://www.wikidata.org/entity/Q22241919',
    'http://www.wikidata.org/entity/Q22241921',
    'http://www.wikidata.org/entity/Q22241923',
    'http://www.wikidata.org/entity/Q22241925',
    'http://www.wikidata.org/entity/Q22241929',
    'http://www.wikidata.org/entity/Q22241961',
    'http://www.wikidata.org/entity/Q22241970',
    'http://www.wikidata.org/entity/Q22241976',
    'http://www.wikidata.org/entity/Q22241980',
    'http://www.wikidata.org/entity/Q22241982',
    'http://www.wikidata.org/entity/Q22241995',
    'http://www.wikidata.org/entity/Q22241996',
    'http://www.wikidata.org/entity/Q22242000',
    'http://www.wikidata.org/entity/Q22242009',
    'http://www.wikidata.org/entity/Q22242011',
    'http://www.wikidata.org/entity/Q22242019',
    'http://www.wikidata.org/entity/Q22242021',
    'http://www.wikidata.org/entity/Q22242024',
    'http://www.wikidata.org/entity/Q22242044',
    'http://www.wikidata.org/entity/Q22242049',
    'http://www.wikidata.org/entity/Q22242061',
    'http://www.wikidata.org/entity/Q22242066',
    'http://www.wikidata.org/entity/Q22242077',
    'http://www.wikidata.org/entity/Q22242080',
    'http://www.wikidata.org/entity/Q22242086',
    'http://www.wikidata.org/entity/Q22242088',
    'http://www.wikidata.org/entity/Q22242096',
    'http://www.wikidata.org/entity/Q22242240',
    'http://www.wikidata.org/entity/Q22242245',
    'http://www.wikidata.org/entity/Q22242250',
    'http://www.wikidata.org/entity/Q22242252',
    'http://www.wikidata.org/entity/Q22242256',
    'http://www.wikidata.org/entity/Q22242262',
    'http://www.wikidata.org/entity/Q22242267',
    'http://www.wikidata.org/entity/Q22242268',
    'http://www.wikidata.org/entity/Q22242269',
    'http://www.wikidata.org/entity/Q22242276',
    'http://www.wikidata.org/entity/Q22242278',
    'http://www.wikidata.org/entity/Q22242279',
    'http://www.wikidata.org/entity/Q22242282',
    'http://www.wikidata.org/entity/Q22242288',
    'http://www.wikidata.org/entity/Q22242341',
    'http://www.wikidata.org/entity/Q22242356',
    'http://www.wikidata.org/entity/Q22242383',
    'http://www.wikidata.org/entity/Q22242384',
    'http://www.wikidata.org/entity/Q22242386',
    'http://www.wikidata.org/entity/Q22242388',
    'http://www.wikidata.org/entity/Q22242396',
    'http://www.wikidata.org/entity/Q22242403',
    'http://www.wikidata.org/entity/Q22242408',
    'http://www.wikidata.org/entity/Q22242651',
    'http://www.wikidata.org/entity/Q22242661',
    'http://www.wikidata.org/entity/Q22242672',
    'http://www.wikidata.org/entity/Q22242702',
    'http://www.wikidata.org/entity/Q22242713',
    'http://www.wikidata.org/entity/Q22242742',
    'http://www.wikidata.org/entity/Q22242745',
    'http://www.wikidata.org/entity/Q22242760',
    'http://www.wikidata.org/entity/Q22242775',
    'http://www.wikidata.org/entity/Q22242826',
    'http://www.wikidata.org/entity/Q22242827',
    'http://www.wikidata.org/entity/Q22242828',
    'http://www.wikidata.org/entity/Q22242829',
    'http://www.wikidata.org/entity/Q22242831',
    'http://www.wikidata.org/entity/Q22242854',
    'http://www.wikidata.org/entity/Q22242870',
    'http://www.wikidata.org/entity/Q22242874',
    'http://www.wikidata.org/entity/Q22242892',
    'http://www.wikidata.org/entity/Q22242895',
    'http://www.wikidata.org/entity/Q22242896',
    'http://www.wikidata.org/entity/Q22242898',
    'http://www.wikidata.org/entity/Q22242899',
    'http://www.wikidata.org/entity/Q22242900',
    'http://www.wikidata.org/entity/Q22242905',
    'http://www.wikidata.org/entity/Q22242909',
    'http://www.wikidata.org/entity/Q22242922',
    'http://www.wikidata.org/entity/Q22242925',
    'http://www.wikidata.org/entity/Q22242926',
    'http://www.wikidata.org/entity/Q22242935',
    'http://www.wikidata.org/entity/Q22242958',
    'http://www.wikidata.org/entity/Q22242965',
    'http://www.wikidata.org/entity/Q22242967',
    'http://www.wikidata.org/entity/Q22242981',
    'http://www.wikidata.org/entity/Q22242991',
    'http://www.wikidata.org/entity/Q22248075',
    'http://www.wikidata.org/entity/Q22248076',
    'http://www.wikidata.org/entity/Q22248090',
    'http://www.wikidata.org/entity/Q22248091',
    'http://www.wikidata.org/entity/Q22248092',
    'http://www.wikidata.org/entity/Q22248094',
    'http://www.wikidata.org/entity/Q22248107',
    'http://www.wikidata.org/entity/Q22248111',
    'http://www.wikidata.org/entity/Q22248114',
    'http://www.wikidata.org/entity/Q22248115',
    'http://www.wikidata.org/entity/Q22248116',
    'http://www.wikidata.org/entity/Q22250873',
    'http://www.wikidata.org/entity/Q22250874',
    'http://www.wikidata.org/entity/Q22250876',
    'http://www.wikidata.org/entity/Q22250877',
    'http://www.wikidata.org/entity/Q22250878',
    'http://www.wikidata.org/entity/Q22250879',
    'http://www.wikidata.org/entity/Q22250880',
    'http://www.wikidata.org/entity/Q22250881',
    'http://www.wikidata.org/entity/Q22250882',
    'http://www.wikidata.org/entity/Q22250883',
    'http://www.wikidata.org/entity/Q22250884',
    'http://www.wikidata.org/entity/Q22250885',
    'http://www.wikidata.org/entity/Q22250886',
    'http://www.wikidata.org/entity/Q22250887',
    'http://www.wikidata.org/entity/Q22250889',
    'http://www.wikidata.org/entity/Q22250890',
    'http://www.wikidata.org/entity/Q22250891',
    'http://www.wikidata.org/entity/Q22250892',
    'http://www.wikidata.org/entity/Q22250902',
    'http://www.wikidata.org/entity/Q22250903',
    'http://www.wikidata.org/entity/Q22250906',
    'http://www.wikidata.org/entity/Q22250907',
    'http://www.wikidata.org/entity/Q22250908',
    'http://www.wikidata.org/entity/Q22250910',
    'http://www.wikidata.org/entity/Q22250911',
    'http://www.wikidata.org/entity/Q22250916',
    'http://www.wikidata.org/entity/Q22250934',
    'http://www.wikidata.org/entity/Q22250939',
    'http://www.wikidata.org/entity/Q22250942',
    'http://www.wikidata.org/entity/Q22250943',
    'http://www.wikidata.org/entity/Q22250952',
    'http://www.wikidata.org/entity/Q22250987',
    'http://www.wikidata.org/entity/Q22250989',
    'http://www.wikidata.org/entity/Q22251006',
    'http://www.wikidata.org/entity/Q22251017',
    'http://www.wikidata.org/entity/Q22251020',
    'http://www.wikidata.org/entity/Q22251021',
    'http://www.wikidata.org/entity/Q22251022',
    'http://www.wikidata.org/entity/Q22251023',
    'http://www.wikidata.org/entity/Q22251040',
    'http://www.wikidata.org/entity/Q22251042',
    'http://www.wikidata.org/entity/Q22251045',
    'http://www.wikidata.org/entity/Q22251049',
    'http://www.wikidata.org/entity/Q22251052',
    'http://www.wikidata.org/entity/Q22251054',
    'http://www.wikidata.org/entity/Q22251061',
    'http://www.wikidata.org/entity/Q22251063',
    'http://www.wikidata.org/entity/Q22251064',
    'http://www.wikidata.org/entity/Q22251066',
    'http://www.wikidata.org/entity/Q22251067',
    'http://www.wikidata.org/entity/Q22251069',
    'http://www.wikidata.org/entity/Q22251071',
    'http://www.wikidata.org/entity/Q22251072',
    'http://www.wikidata.org/entity/Q22251077',
    'http://www.wikidata.org/entity/Q22251079',
    'http://www.wikidata.org/entity/Q22251080',
    'http://www.wikidata.org/entity/Q22251081',
    'http://www.wikidata.org/entity/Q22251082',
    'http://www.wikidata.org/entity/Q22251083',
    'http://www.wikidata.org/entity/Q22251085',
    'http://www.wikidata.org/entity/Q22251086',
    'http://www.wikidata.org/entity/Q22251088',
    'http://www.wikidata.org/entity/Q22251089',
    'http://www.wikidata.org/entity/Q22251090',
    'http://www.wikidata.org/entity/Q22251092',
    'http://www.wikidata.org/entity/Q22251093',
    'http://www.wikidata.org/entity/Q22251107',
    'http://www.wikidata.org/entity/Q22251111',
    'http://www.wikidata.org/entity/Q22251112',
    'http://www.wikidata.org/entity/Q22251115',
    'http://www.wikidata.org/entity/Q22251122',
    'http://www.wikidata.org/entity/Q22251191',
    'http://www.wikidata.org/entity/Q22251218',
    'http://www.wikidata.org/entity/Q22251247',
    'http://www.wikidata.org/entity/Q22251253',
    'http://www.wikidata.org/entity/Q22251255',
    'http://www.wikidata.org/entity/Q22251256',
    'http://www.wikidata.org/entity/Q22251270',
    'http://www.wikidata.org/entity/Q22251280',
    'http://www.wikidata.org/entity/Q22251282',
    'http://www.wikidata.org/entity/Q22251285',
    'http://www.wikidata.org/entity/Q22251288',
    'http://www.wikidata.org/entity/Q22251291',
    'http://www.wikidata.org/entity/Q22251292',
    'http://www.wikidata.org/entity/Q22251299',
    'http://www.wikidata.org/entity/Q22251325',
    'http://www.wikidata.org/entity/Q22251330',
    'http://www.wikidata.org/entity/Q22251333',
    'http://www.wikidata.org/entity/Q22251337',
    'http://www.wikidata.org/entity/Q22251379',
    'http://www.wikidata.org/entity/Q22251429',
    'http://www.wikidata.org/entity/Q22251430',
    'http://www.wikidata.org/entity/Q22251439',
    'http://www.wikidata.org/entity/Q22251440',
    'http://www.wikidata.org/entity/Q22251463',
    'http://www.wikidata.org/entity/Q22251464',
    'http://www.wikidata.org/entity/Q22252218',
    'http://www.wikidata.org/entity/Q22252247',
    'http://www.wikidata.org/entity/Q22252269',
    'http://www.wikidata.org/entity/Q22252270',
    'http://www.wikidata.org/entity/Q22252278',
    'http://www.wikidata.org/entity/Q22252311',
    'http://www.wikidata.org/entity/Q22252312',
    'http://www.wikidata.org/entity/Q22252314',
    'http://www.wikidata.org/entity/Q22252318',
    'http://www.wikidata.org/entity/Q22252403',
    'http://www.wikidata.org/entity/Q22252406',
    'http://www.wikidata.org/entity/Q22252424',
    'http://www.wikidata.org/entity/Q22252506',
    'http://www.wikidata.org/entity/Q22252520',
    'http://www.wikidata.org/entity/Q22252552',
    'http://www.wikidata.org/entity/Q22252553',
    'http://www.wikidata.org/entity/Q22252567',
    'http://www.wikidata.org/entity/Q22252603',
    'http://www.wikidata.org/entity/Q22252614',
    'http://www.wikidata.org/entity/Q22252618',
    'http://www.wikidata.org/entity/Q22252629',
    'http://www.wikidata.org/entity/Q22252639',
    'http://www.wikidata.org/entity/Q22252649',
    'http://www.wikidata.org/entity/Q22252652',
    'http://www.wikidata.org/entity/Q22252658',
    'http://www.wikidata.org/entity/Q22252693',
    'http://www.wikidata.org/entity/Q22252698',
    'http://www.wikidata.org/entity/Q22252705',
    'http://www.wikidata.org/entity/Q22252855',
    'http://www.wikidata.org/entity/Q22252860',
    'http://www.wikidata.org/entity/Q22252865',
    'http://www.wikidata.org/entity/Q22252904',
    'http://www.wikidata.org/entity/Q22252926',
    'http://www.wikidata.org/entity/Q22252927',
    'http://www.wikidata.org/entity/Q22252936',
    'http://www.wikidata.org/entity/Q22252937',
    'http://www.wikidata.org/entity/Q22252938',
    'http://www.wikidata.org/entity/Q22252943',
    'http://www.wikidata.org/entity/Q22252975',
    'http://www.wikidata.org/entity/Q22252980',
    'http://www.wikidata.org/entity/Q22252985',
    'http://www.wikidata.org/entity/Q22252990',
    'http://www.wikidata.org/entity/Q22252996',
    'http://www.wikidata.org/entity/Q22252997',
    'http://www.wikidata.org/entity/Q22252999',
    'http://www.wikidata.org/entity/Q22253001',
    'http://www.wikidata.org/entity/Q22253003',
    'http://www.wikidata.org/entity/Q22253005',
    'http://www.wikidata.org/entity/Q22253015',
    'http://www.wikidata.org/entity/Q22253016',
    'http://www.wikidata.org/entity/Q22253024',
    'http://www.wikidata.org/entity/Q22253025',
    'http://www.wikidata.org/entity/Q22253027',
    'http://www.wikidata.org/entity/Q22253029',
    'http://www.wikidata.org/entity/Q22253031',
    'http://www.wikidata.org/entity/Q22253032',
    'http://www.wikidata.org/entity/Q22253034',
    'http://www.wikidata.org/entity/Q22253035',
    'http://www.wikidata.org/entity/Q22253037',
    'http://www.wikidata.org/entity/Q22253039',
    'http://www.wikidata.org/entity/Q22253040',
    'http://www.wikidata.org/entity/Q22253049',
    'http://www.wikidata.org/entity/Q22253052',
    'http://www.wikidata.org/entity/Q22253054',
    'http://www.wikidata.org/entity/Q22253055',
    'http://www.wikidata.org/entity/Q22253194',
    'http://www.wikidata.org/entity/Q22253248',
    'http://www.wikidata.org/entity/Q22253284',
    'http://www.wikidata.org/entity/Q22253357',
    'http://www.wikidata.org/entity/Q22253421',
    'http://www.wikidata.org/entity/Q22253423',
    'http://www.wikidata.org/entity/Q22253424',
    'http://www.wikidata.org/entity/Q22253435',
    'http://www.wikidata.org/entity/Q22253874',
    'http://www.wikidata.org/entity/Q22254000',
    'http://www.wikidata.org/entity/Q22254014',
    'http://www.wikidata.org/entity/Q22254042',
    'http://www.wikidata.org/entity/Q22254116',
    'http://www.wikidata.org/entity/Q22254119',
    'http://www.wikidata.org/entity/Q22254160',
    'http://www.wikidata.org/entity/Q22254186',
    'http://www.wikidata.org/entity/Q22254202',
    'http://www.wikidata.org/entity/Q22254333',
    'http://www.wikidata.org/entity/Q22254367',
    'http://www.wikidata.org/entity/Q22254582',
    'http://www.wikidata.org/entity/Q22254584',
    'http://www.wikidata.org/entity/Q22254603',
    'http://www.wikidata.org/entity/Q22254716',
    'http://www.wikidata.org/entity/Q22254730',
    'http://www.wikidata.org/entity/Q22254751',
    'http://www.wikidata.org/entity/Q22254771',
    'http://www.wikidata.org/entity/Q22254785',
    'http://www.wikidata.org/entity/Q22255401',
    'http://www.wikidata.org/entity/Q22255451',
    'http://www.wikidata.org/entity/Q22255452',
    'http://www.wikidata.org/entity/Q22255454',
    'http://www.wikidata.org/entity/Q22255462',
    'http://www.wikidata.org/entity/Q22255464',
    'http://www.wikidata.org/entity/Q22255499',
    'http://www.wikidata.org/entity/Q22255501',
    'http://www.wikidata.org/entity/Q22255503',
    'http://www.wikidata.org/entity/Q22255504',
    'http://www.wikidata.org/entity/Q22255505',
    'http://www.wikidata.org/entity/Q22255523',
    'http://www.wikidata.org/entity/Q22255575',
    'http://www.wikidata.org/entity/Q22255578',
    'http://www.wikidata.org/entity/Q22255605',
    'http://www.wikidata.org/entity/Q22255608',
    'http://www.wikidata.org/entity/Q22255613',
    'http://www.wikidata.org/entity/Q22255615',
    'http://www.wikidata.org/entity/Q22255617',
    'http://www.wikidata.org/entity/Q22255618',
    'http://www.wikidata.org/entity/Q22255624',
    'http://www.wikidata.org/entity/Q22255628',
    'http://www.wikidata.org/entity/Q22255632',
    'http://www.wikidata.org/entity/Q22255635',
    'http://www.wikidata.org/entity/Q22255648',
    'http://www.wikidata.org/entity/Q22255652',
    'http://www.wikidata.org/entity/Q22255655',
    'http://www.wikidata.org/entity/Q22255656',
    'http://www.wikidata.org/entity/Q22255667',
    'http://www.wikidata.org/entity/Q22255668',
    'http://www.wikidata.org/entity/Q22272632',
    'http://www.wikidata.org/entity/Q22299203',
    'http://www.wikidata.org/entity/Q22299206',
    'http://www.wikidata.org/entity/Q22299207',
    'http://www.wikidata.org/entity/Q22299208',
    'http://www.wikidata.org/entity/Q22299313',
    'http://www.wikidata.org/entity/Q22299328',
    'http://www.wikidata.org/entity/Q22299356',
    'http://www.wikidata.org/entity/Q22299358',
    'http://www.wikidata.org/entity/Q22299359',
    'http://www.wikidata.org/entity/Q22299362',
    'http://www.wikidata.org/entity/Q22299387',
    'http://www.wikidata.org/entity/Q22299417',
    'http://www.wikidata.org/entity/Q22299419',
    'http://www.wikidata.org/entity/Q22299421',
    'http://www.wikidata.org/entity/Q22299423',
    'http://www.wikidata.org/entity/Q22299424',
    'http://www.wikidata.org/entity/Q22305005',
    'http://www.wikidata.org/entity/Q22305324',
    'http://www.wikidata.org/entity/Q22305327',
    'http://www.wikidata.org/entity/Q22305336',
    'http://www.wikidata.org/entity/Q22305455',
    'http://www.wikidata.org/entity/Q22305468',
    'http://www.wikidata.org/entity/Q22305500',
    'http://www.wikidata.org/entity/Q22305638',
    'http://www.wikidata.org/entity/Q22305643',
    'http://www.wikidata.org/entity/Q22305649',
    'http://www.wikidata.org/entity/Q22305656',
    'http://www.wikidata.org/entity/Q22305657',
    'http://www.wikidata.org/entity/Q22305957',
    'http://www.wikidata.org/entity/Q22305963',
    'http://www.wikidata.org/entity/Q22306049',
    'http://www.wikidata.org/entity/Q22306050',
    'http://www.wikidata.org/entity/Q22306067',
    'http://www.wikidata.org/entity/Q22306086',
    'http://www.wikidata.org/entity/Q22306097',
    'http://www.wikidata.org/entity/Q22306130',
    'http://www.wikidata.org/entity/Q22306172',
    'http://www.wikidata.org/entity/Q22306182',
    'http://www.wikidata.org/entity/Q22306201',
    'http://www.wikidata.org/entity/Q22306207',
    'http://www.wikidata.org/entity/Q22306208',
    'http://www.wikidata.org/entity/Q22306211',
    'http://www.wikidata.org/entity/Q22306219',
    'http://www.wikidata.org/entity/Q22306225',
    'http://www.wikidata.org/entity/Q22306227',
    'http://www.wikidata.org/entity/Q22306233',
    'http://www.wikidata.org/entity/Q22306239',
    'http://www.wikidata.org/entity/Q22306268',
    'http://www.wikidata.org/entity/Q22306274',
    'http://www.wikidata.org/entity/Q22306277',
    'http://www.wikidata.org/entity/Q22306283',
    'http://www.wikidata.org/entity/Q22306284',
    'http://www.wikidata.org/entity/Q22306308',
    'http://www.wikidata.org/entity/Q22306331',
    'http://www.wikidata.org/entity/Q22306343',
    'http://www.wikidata.org/entity/Q22306345',
    'http://www.wikidata.org/entity/Q22306347',
    'http://www.wikidata.org/entity/Q22306349',
    'http://www.wikidata.org/entity/Q22306351',
    'http://www.wikidata.org/entity/Q22306352',
    'http://www.wikidata.org/entity/Q22306353',
    'http://www.wikidata.org/entity/Q22306355',
    'http://www.wikidata.org/entity/Q22306356',
    'http://www.wikidata.org/entity/Q22306358',
    'http://www.wikidata.org/entity/Q22306370',
    'http://www.wikidata.org/entity/Q22306381',
    'http://www.wikidata.org/entity/Q22306384',
    'http://www.wikidata.org/entity/Q22306385',
    'http://www.wikidata.org/entity/Q22306395',
    'http://www.wikidata.org/entity/Q22306450',
    'http://www.wikidata.org/entity/Q22306516',
    'http://www.wikidata.org/entity/Q22306530',
    'http://www.wikidata.org/entity/Q22306544',
    'http://www.wikidata.org/entity/Q22306552',
    'http://www.wikidata.org/entity/Q22330669',
    'http://www.wikidata.org/entity/Q22330676',
    'http://www.wikidata.org/entity/Q22330677',
    'http://www.wikidata.org/entity/Q22330682',
    'http://www.wikidata.org/entity/Q22330702',
    'http://www.wikidata.org/entity/Q22330706',
    'http://www.wikidata.org/entity/Q22330711',
    'http://www.wikidata.org/entity/Q22330713',
    'http://www.wikidata.org/entity/Q22330715',
    'http://www.wikidata.org/entity/Q22330722',
    'http://www.wikidata.org/entity/Q22330729',
    'http://www.wikidata.org/entity/Q22330735',
    'http://www.wikidata.org/entity/Q22330739',
    'http://www.wikidata.org/entity/Q22330743',
    'http://www.wikidata.org/entity/Q22330746',
    'http://www.wikidata.org/entity/Q22330747',
    'http://www.wikidata.org/entity/Q22330748',
    'http://www.wikidata.org/entity/Q22330749',
    'http://www.wikidata.org/entity/Q22330753',
    'http://www.wikidata.org/entity/Q22330759',
    'http://www.wikidata.org/entity/Q22330760',
    'http://www.wikidata.org/entity/Q22330766',
    'http://www.wikidata.org/entity/Q22330782',
    'http://www.wikidata.org/entity/Q22330853',
    'http://www.wikidata.org/entity/Q22330859',
    'http://www.wikidata.org/entity/Q22330869',
    'http://www.wikidata.org/entity/Q22330876',
    'http://www.wikidata.org/entity/Q22330883',
    'http://www.wikidata.org/entity/Q22330884',
    'http://www.wikidata.org/entity/Q22330885',
    'http://www.wikidata.org/entity/Q22330886',
    'http://www.wikidata.org/entity/Q22330898',
    'http://www.wikidata.org/entity/Q22330899',
    'http://www.wikidata.org/entity/Q22330904',
    'http://www.wikidata.org/entity/Q22336985',
    'http://www.wikidata.org/entity/Q22337020',
    'http://www.wikidata.org/entity/Q22337023',
    'http://www.wikidata.org/entity/Q22337026',
    'http://www.wikidata.org/entity/Q22337027',
    'http://www.wikidata.org/entity/Q22337028',
    'http://www.wikidata.org/entity/Q22337032',
    'http://www.wikidata.org/entity/Q22337058',
    'http://www.wikidata.org/entity/Q22337068',
    'http://www.wikidata.org/entity/Q22337072',
    'http://www.wikidata.org/entity/Q22337105',
    'http://www.wikidata.org/entity/Q22337109',
    'http://www.wikidata.org/entity/Q22337119',
    'http://www.wikidata.org/entity/Q22337161',
    'http://www.wikidata.org/entity/Q22337170',
    'http://www.wikidata.org/entity/Q22337172',
    'http://www.wikidata.org/entity/Q22337192',
    'http://www.wikidata.org/entity/Q22337221',
    'http://www.wikidata.org/entity/Q22337223',
    'http://www.wikidata.org/entity/Q22337225',
    'http://www.wikidata.org/entity/Q22337229',
    'http://www.wikidata.org/entity/Q22337233',
    'http://www.wikidata.org/entity/Q22337234',
    'http://www.wikidata.org/entity/Q22337235',
    'http://www.wikidata.org/entity/Q22337237',
    'http://www.wikidata.org/entity/Q22337245',
    'http://www.wikidata.org/entity/Q22337246',
    'http://www.wikidata.org/entity/Q22337247',
    'http://www.wikidata.org/entity/Q22337251',
    'http://www.wikidata.org/entity/Q22337257',
    'http://www.wikidata.org/entity/Q22337260',
    'http://www.wikidata.org/entity/Q22337274',
    'http://www.wikidata.org/entity/Q22337276',
    'http://www.wikidata.org/entity/Q22337277',
    'http://www.wikidata.org/entity/Q22337278',
    'http://www.wikidata.org/entity/Q22337282',
    'http://www.wikidata.org/entity/Q22337290',
    'http://www.wikidata.org/entity/Q22337300',
    'http://www.wikidata.org/entity/Q22337301',
    'http://www.wikidata.org/entity/Q22337308',
    'http://www.wikidata.org/entity/Q22337342',
    'http://www.wikidata.org/entity/Q22337358',
    'http://www.wikidata.org/entity/Q22337363',
    'http://www.wikidata.org/entity/Q22337370',
    'http://www.wikidata.org/entity/Q22337395',
    'http://www.wikidata.org/entity/Q22337408',
    'http://www.wikidata.org/entity/Q22337412',
    'http://www.wikidata.org/entity/Q22337453',
    'http://www.wikidata.org/entity/Q22348097',
    'http://www.wikidata.org/entity/Q22673963',
    'http://www.wikidata.org/entity/Q22676705',
    'http://www.wikidata.org/entity/Q22680374',
    'http://www.wikidata.org/entity/Q22680660',
    'http://www.wikidata.org/entity/Q22683189',
    'http://www.wikidata.org/entity/Q22808996',
    'http://www.wikidata.org/entity/Q23000444',
    'http://www.wikidata.org/entity/Q23000449',
    'http://www.wikidata.org/entity/Q23005539',
    'http://www.wikidata.org/entity/Q23008981',
    'http://www.wikidata.org/entity/Q23012849',
    'http://www.wikidata.org/entity/Q23014548',
    'http://www.wikidata.org/entity/Q23039065',
    'http://www.wikidata.org/entity/Q23042979',
    'http://www.wikidata.org/entity/Q23302003',
    'http://www.wikidata.org/entity/Q23309956',
    'http://www.wikidata.org/entity/Q23311397',
    'http://www.wikidata.org/entity/Q23319322',
    'http://www.wikidata.org/entity/Q23649767',
    'http://www.wikidata.org/entity/Q23667364',
    'http://www.wikidata.org/entity/Q23669177',
    'http://www.wikidata.org/entity/Q23670156',
    'http://www.wikidata.org/entity/Q23670968',
    'http://www.wikidata.org/entity/Q23671721',
    'http://www.wikidata.org/entity/Q23680595',
    'http://www.wikidata.org/entity/Q23731787',
    'http://www.wikidata.org/entity/Q23747506',
    'http://www.wikidata.org/entity/Q23748220',
    'http://www.wikidata.org/entity/Q23757358',
    'http://www.wikidata.org/entity/Q23760733',
    'http://www.wikidata.org/entity/Q23761158',
    'http://www.wikidata.org/entity/Q23761230',
    'http://www.wikidata.org/entity/Q23781406',
    'http://www.wikidata.org/entity/Q23791313',
    'http://www.wikidata.org/entity/Q23815222',
    'http://www.wikidata.org/entity/Q23832736',
    'http://www.wikidata.org/entity/Q23890369',
    'http://www.wikidata.org/entity/Q23890890',
    'http://www.wikidata.org/entity/Q23891064',
    'http://www.wikidata.org/entity/Q23891114',
    'http://www.wikidata.org/entity/Q23891136',
    'http://www.wikidata.org/entity/Q23891366',
    'http://www.wikidata.org/entity/Q23906889',
    'http://www.wikidata.org/entity/Q23909354',
    'http://www.wikidata.org/entity/Q23909387',
    'http://www.wikidata.org/entity/Q23909837',
    'http://www.wikidata.org/entity/Q23909863',
    'http://www.wikidata.org/entity/Q23909890',
    'http://www.wikidata.org/entity/Q23909980',
    'http://www.wikidata.org/entity/Q23909986',
    'http://www.wikidata.org/entity/Q23910003',
    'http://www.wikidata.org/entity/Q23910492',
    'http://www.wikidata.org/entity/Q23910493',
    'http://www.wikidata.org/entity/Q23911518',
    'http://www.wikidata.org/entity/Q23911520',
    'http://www.wikidata.org/entity/Q23911531',
    'http://www.wikidata.org/entity/Q23913230',
    'http://www.wikidata.org/entity/Q23913594',
    'http://www.wikidata.org/entity/Q23913609',
    'http://www.wikidata.org/entity/Q23913805',
    'http://www.wikidata.org/entity/Q23914309',
    'http://www.wikidata.org/entity/Q23915196',
    'http://www.wikidata.org/entity/Q23916367',
    'http://www.wikidata.org/entity/Q23916996',
    'http://www.wikidata.org/entity/Q23917307',
    'http://www.wikidata.org/entity/Q23918014',
    'http://www.wikidata.org/entity/Q23918752',
    'http://www.wikidata.org/entity/Q23919332',
    'http://www.wikidata.org/entity/Q23919668',
    'http://www.wikidata.org/entity/Q23919669',
    'http://www.wikidata.org/entity/Q23919831',
    'http://www.wikidata.org/entity/Q23919884',
    'http://www.wikidata.org/entity/Q23919994',
    'http://www.wikidata.org/entity/Q23920166',
    'http://www.wikidata.org/entity/Q23920372',
    'http://www.wikidata.org/entity/Q23921608',
    'http://www.wikidata.org/entity/Q23921756',
    'http://www.wikidata.org/entity/Q23921944',
    'http://www.wikidata.org/entity/Q23922091',
    'http://www.wikidata.org/entity/Q23922775',
    'http://www.wikidata.org/entity/Q23922793',
    'http://www.wikidata.org/entity/Q23922836',
    'http://www.wikidata.org/entity/Q23922854',
    'http://www.wikidata.org/entity/Q23922957',
    'http://www.wikidata.org/entity/Q23923113',
    'http://www.wikidata.org/entity/Q23923171',
    'http://www.wikidata.org/entity/Q23923187',
    'http://www.wikidata.org/entity/Q23923708',
    'http://www.wikidata.org/entity/Q23923876',
    'http://www.wikidata.org/entity/Q23923877',
    'http://www.wikidata.org/entity/Q23924188',
    'http://www.wikidata.org/entity/Q23924480',
    'http://www.wikidata.org/entity/Q23924497',
    'http://www.wikidata.org/entity/Q23992753',
    'http://www.wikidata.org/entity/Q23992764',
    'http://www.wikidata.org/entity/Q24004552',
    'http://www.wikidata.org/entity/Q24021074',
    'http://www.wikidata.org/entity/Q24040257',
    'http://www.wikidata.org/entity/Q24047379',
    'http://www.wikidata.org/entity/Q24047862',
    'http://www.wikidata.org/entity/Q24047993',
    'http://www.wikidata.org/entity/Q24048030',
    'http://www.wikidata.org/entity/Q24050115',
    'http://www.wikidata.org/entity/Q24053233',
    'http://www.wikidata.org/entity/Q24067152',
    'http://www.wikidata.org/entity/Q24082695',
    'http://www.wikidata.org/entity/Q24082710',
    'http://www.wikidata.org/entity/Q24083091',
    'http://www.wikidata.org/entity/Q24091299',
    'http://www.wikidata.org/entity/Q24170269',
    'http://www.wikidata.org/entity/Q24170370',
    'http://www.wikidata.org/entity/Q24174698',
    'http://www.wikidata.org/entity/Q24188653',
    'http://www.wikidata.org/entity/Q24197505',
    'http://www.wikidata.org/entity/Q24197546',
    'http://www.wikidata.org/entity/Q24198292',
    'http://www.wikidata.org/entity/Q24200378',
    'http://www.wikidata.org/entity/Q24200464',
    'http://www.wikidata.org/entity/Q24200603',
    'http://www.wikidata.org/entity/Q24200709',
    'http://www.wikidata.org/entity/Q24200969',
    'http://www.wikidata.org/entity/Q24200976',
    'http://www.wikidata.org/entity/Q24201026',
    'http://www.wikidata.org/entity/Q24201081',
    'http://www.wikidata.org/entity/Q24201160',
    'http://www.wikidata.org/entity/Q24201394',
    'http://www.wikidata.org/entity/Q24201436',
    'http://www.wikidata.org/entity/Q24201466',
    'http://www.wikidata.org/entity/Q24201946',
    'http://www.wikidata.org/entity/Q24202405',
    'http://www.wikidata.org/entity/Q24202439',
    'http://www.wikidata.org/entity/Q24202475',
    'http://www.wikidata.org/entity/Q24202591',
    'http://www.wikidata.org/entity/Q24202663',
    'http://www.wikidata.org/entity/Q24202862',
    'http://www.wikidata.org/entity/Q24202991',
    'http://www.wikidata.org/entity/Q24203724',
    'http://www.wikidata.org/entity/Q24204030',
    'http://www.wikidata.org/entity/Q24234551',
    'http://www.wikidata.org/entity/Q24235365',
    'http://www.wikidata.org/entity/Q24235817',
    'http://www.wikidata.org/entity/Q24236296',
    'http://www.wikidata.org/entity/Q24236544',
    'http://www.wikidata.org/entity/Q24236780',
    'http://www.wikidata.org/entity/Q24236807',
    'http://www.wikidata.org/entity/Q24239885',
    'http://www.wikidata.org/entity/Q24239902',
    'http://www.wikidata.org/entity/Q24239997',
    'http://www.wikidata.org/entity/Q24240159',
    'http://www.wikidata.org/entity/Q24240680',
    'http://www.wikidata.org/entity/Q24241052',
    'http://www.wikidata.org/entity/Q24241349',
    'http://www.wikidata.org/entity/Q24241785',
    'http://www.wikidata.org/entity/Q24241862',
    'http://www.wikidata.org/entity/Q24241884',
    'http://www.wikidata.org/entity/Q24242801',
    'http://www.wikidata.org/entity/Q24242851',
    'http://www.wikidata.org/entity/Q24242905',
    'http://www.wikidata.org/entity/Q24243045',
    'http://www.wikidata.org/entity/Q24243120',
    'http://www.wikidata.org/entity/Q24243146',
    'http://www.wikidata.org/entity/Q24243174',
    'http://www.wikidata.org/entity/Q24243296',
    'http://www.wikidata.org/entity/Q24243891',
    'http://www.wikidata.org/entity/Q24243959',
    'http://www.wikidata.org/entity/Q24245056',
    'http://www.wikidata.org/entity/Q24245140',
    'http://www.wikidata.org/entity/Q24245162',
    'http://www.wikidata.org/entity/Q24245169',
    'http://www.wikidata.org/entity/Q24245194',
    'http://www.wikidata.org/entity/Q24245348',
    'http://www.wikidata.org/entity/Q24245481',
    'http://www.wikidata.org/entity/Q24245912',
    'http://www.wikidata.org/entity/Q24246141',
    'http://www.wikidata.org/entity/Q24246443',
    'http://www.wikidata.org/entity/Q24246517',
    'http://www.wikidata.org/entity/Q24246781',
    'http://www.wikidata.org/entity/Q24246991',
    'http://www.wikidata.org/entity/Q24247105',
    'http://www.wikidata.org/entity/Q24248021',
    'http://www.wikidata.org/entity/Q24248165',
    'http://www.wikidata.org/entity/Q24255001',
    'http://www.wikidata.org/entity/Q24255215',
    'http://www.wikidata.org/entity/Q24255260',
    'http://www.wikidata.org/entity/Q24259024',
    'http://www.wikidata.org/entity/Q24261103',
    'http://www.wikidata.org/entity/Q24261124',
    'http://www.wikidata.org/entity/Q24261137',
    'http://www.wikidata.org/entity/Q24261160',
    'http://www.wikidata.org/entity/Q24261163',
    'http://www.wikidata.org/entity/Q24261167',
    'http://www.wikidata.org/entity/Q24261180',
    'http://www.wikidata.org/entity/Q24261183',
    'http://www.wikidata.org/entity/Q24261185',
    'http://www.wikidata.org/entity/Q24261255',
    'http://www.wikidata.org/entity/Q24261288',
    'http://www.wikidata.org/entity/Q24261340',
    'http://www.wikidata.org/entity/Q24261402',
    'http://www.wikidata.org/entity/Q24261403',
    'http://www.wikidata.org/entity/Q24261408',
    'http://www.wikidata.org/entity/Q24261421',
    'http://www.wikidata.org/entity/Q24273204',
    'http://www.wikidata.org/entity/Q24273229',
    'http://www.wikidata.org/entity/Q24273231',
    'http://www.wikidata.org/entity/Q24273233',
    'http://www.wikidata.org/entity/Q24273244',
    'http://www.wikidata.org/entity/Q24273261',
    'http://www.wikidata.org/entity/Q24273386',
    'http://www.wikidata.org/entity/Q24273398',
    'http://www.wikidata.org/entity/Q24276099',
    'http://www.wikidata.org/entity/Q24276200',
    'http://www.wikidata.org/entity/Q24276401',
    'http://www.wikidata.org/entity/Q24276429',
    'http://www.wikidata.org/entity/Q24278525',
    'http://www.wikidata.org/entity/Q24279410',
    'http://www.wikidata.org/entity/Q24282603',
    'http://www.wikidata.org/entity/Q24286924',
    'http://www.wikidata.org/entity/Q24286926',
    'http://www.wikidata.org/entity/Q24286945',
    'http://www.wikidata.org/entity/Q24286947',
    'http://www.wikidata.org/entity/Q24286948',
    'http://www.wikidata.org/entity/Q24286949',
    'http://www.wikidata.org/entity/Q24286950',
    'http://www.wikidata.org/entity/Q24288698',
    'http://www.wikidata.org/entity/Q24288717',
    'http://www.wikidata.org/entity/Q24288732',
    'http://www.wikidata.org/entity/Q24288768',
    'http://www.wikidata.org/entity/Q24288915',
    'http://www.wikidata.org/entity/Q24288966',
    'http://www.wikidata.org/entity/Q24288986',
    'http://www.wikidata.org/entity/Q24288996',
    'http://www.wikidata.org/entity/Q24289005',
    'http://www.wikidata.org/entity/Q24289024',
    'http://www.wikidata.org/entity/Q24289032',
    'http://www.wikidata.org/entity/Q24289119',
    'http://www.wikidata.org/entity/Q24289124',
    'http://www.wikidata.org/entity/Q24289127',
    'http://www.wikidata.org/entity/Q24289128',
    'http://www.wikidata.org/entity/Q24289131',
    'http://www.wikidata.org/entity/Q24289132',
    'http://www.wikidata.org/entity/Q24289133',
    'http://www.wikidata.org/entity/Q24289136',
    'http://www.wikidata.org/entity/Q24289190',
    'http://www.wikidata.org/entity/Q24289215',
    'http://www.wikidata.org/entity/Q24289219',
    'http://www.wikidata.org/entity/Q24289232',
    'http://www.wikidata.org/entity/Q24289247',
    'http://www.wikidata.org/entity/Q24289268',
    'http://www.wikidata.org/entity/Q24289280',
    'http://www.wikidata.org/entity/Q24289281',
    'http://www.wikidata.org/entity/Q24289320',
    'http://www.wikidata.org/entity/Q24289327',
    'http://www.wikidata.org/entity/Q24289328',
    'http://www.wikidata.org/entity/Q24289329',
    'http://www.wikidata.org/entity/Q24289338',
    'http://www.wikidata.org/entity/Q24289359',
    'http://www.wikidata.org/entity/Q24289362',
    'http://www.wikidata.org/entity/Q24289387',
    'http://www.wikidata.org/entity/Q24289394',
    'http://www.wikidata.org/entity/Q24289436',
    'http://www.wikidata.org/entity/Q24289450',
    'http://www.wikidata.org/entity/Q24289484',
    'http://www.wikidata.org/entity/Q24289532',
    'http://www.wikidata.org/entity/Q24289552',
    'http://www.wikidata.org/entity/Q24289612',
    'http://www.wikidata.org/entity/Q24289635',
    'http://www.wikidata.org/entity/Q24289643',
    'http://www.wikidata.org/entity/Q24290105',
    'http://www.wikidata.org/entity/Q24290115',
    'http://www.wikidata.org/entity/Q24290118',
    'http://www.wikidata.org/entity/Q24290146',
    'http://www.wikidata.org/entity/Q24290189',
    'http://www.wikidata.org/entity/Q24290192',
    'http://www.wikidata.org/entity/Q24290197',
    'http://www.wikidata.org/entity/Q24290228',
    'http://www.wikidata.org/entity/Q24290265',
    'http://www.wikidata.org/entity/Q24290287',
    'http://www.wikidata.org/entity/Q24290355',
    'http://www.wikidata.org/entity/Q24290356',
    'http://www.wikidata.org/entity/Q24290380',
    'http://www.wikidata.org/entity/Q24290391',
    'http://www.wikidata.org/entity/Q24290392',
    'http://www.wikidata.org/entity/Q24290402',
    'http://www.wikidata.org/entity/Q24290438',
    'http://www.wikidata.org/entity/Q24290481',
    'http://www.wikidata.org/entity/Q24290495',
    'http://www.wikidata.org/entity/Q24290496',
    'http://www.wikidata.org/entity/Q24290518',
    'http://www.wikidata.org/entity/Q24290523',
    'http://www.wikidata.org/entity/Q24290539',
    'http://www.wikidata.org/entity/Q24290546',
    'http://www.wikidata.org/entity/Q24290548',
    'http://www.wikidata.org/entity/Q24290576',
    'http://www.wikidata.org/entity/Q24290609',
    'http://www.wikidata.org/entity/Q24290619',
    'http://www.wikidata.org/entity/Q24290664',
    'http://www.wikidata.org/entity/Q24290668',
    'http://www.wikidata.org/entity/Q24290675',
    'http://www.wikidata.org/entity/Q24290693',
    'http://www.wikidata.org/entity/Q24290696',
    'http://www.wikidata.org/entity/Q24290709',
    'http://www.wikidata.org/entity/Q24290716',
    'http://www.wikidata.org/entity/Q24290723',
    'http://www.wikidata.org/entity/Q24290731',
    'http://www.wikidata.org/entity/Q24290749',
    'http://www.wikidata.org/entity/Q24290757',
    'http://www.wikidata.org/entity/Q24290776',
    'http://www.wikidata.org/entity/Q24290782',
    'http://www.wikidata.org/entity/Q24290838',
    'http://www.wikidata.org/entity/Q24290847',
    'http://www.wikidata.org/entity/Q24290861',
    'http://www.wikidata.org/entity/Q24290864',
    'http://www.wikidata.org/entity/Q24290903',
    'http://www.wikidata.org/entity/Q24290906',
    'http://www.wikidata.org/entity/Q24290908',
    'http://www.wikidata.org/entity/Q24290909',
    'http://www.wikidata.org/entity/Q24290912',
    'http://www.wikidata.org/entity/Q24290940',
    'http://www.wikidata.org/entity/Q24290976',
    'http://www.wikidata.org/entity/Q24291001',
    'http://www.wikidata.org/entity/Q24291027',
    'http://www.wikidata.org/entity/Q24291041',
    'http://www.wikidata.org/entity/Q24291070',
    'http://www.wikidata.org/entity/Q24291081',
    'http://www.wikidata.org/entity/Q24291102',
    'http://www.wikidata.org/entity/Q24291119',
    'http://www.wikidata.org/entity/Q24291136',
    'http://www.wikidata.org/entity/Q24291183',
    'http://www.wikidata.org/entity/Q24291185',
    'http://www.wikidata.org/entity/Q24291275',
    'http://www.wikidata.org/entity/Q24291383',
    'http://www.wikidata.org/entity/Q24291397',
    'http://www.wikidata.org/entity/Q24291412',
    'http://www.wikidata.org/entity/Q24291420',
    'http://www.wikidata.org/entity/Q24291433',
    'http://www.wikidata.org/entity/Q24291453',
    'http://www.wikidata.org/entity/Q24291454',
    'http://www.wikidata.org/entity/Q24291462',
    'http://www.wikidata.org/entity/Q24291463',
    'http://www.wikidata.org/entity/Q24291482',
    'http://www.wikidata.org/entity/Q24291591',
    'http://www.wikidata.org/entity/Q24291653',
    'http://www.wikidata.org/entity/Q24291661',
    'http://www.wikidata.org/entity/Q24291691',
    'http://www.wikidata.org/entity/Q24291755',
    'http://www.wikidata.org/entity/Q24291759',
    'http://www.wikidata.org/entity/Q24291767',
    'http://www.wikidata.org/entity/Q24291780',
    'http://www.wikidata.org/entity/Q24291783',
    'http://www.wikidata.org/entity/Q24291784',
    'http://www.wikidata.org/entity/Q24291794',
    'http://www.wikidata.org/entity/Q24291798',
    'http://www.wikidata.org/entity/Q24291819',
    'http://www.wikidata.org/entity/Q24291828',
    'http://www.wikidata.org/entity/Q24291829',
    'http://www.wikidata.org/entity/Q24291856',
    'http://www.wikidata.org/entity/Q24291905',
    'http://www.wikidata.org/entity/Q24291926',
    'http://www.wikidata.org/entity/Q24291942',
    'http://www.wikidata.org/entity/Q24291966',
    'http://www.wikidata.org/entity/Q24292020',
    'http://www.wikidata.org/entity/Q24292102',
    'http://www.wikidata.org/entity/Q24292104',
    'http://www.wikidata.org/entity/Q24292162',
    'http://www.wikidata.org/entity/Q24292165',
    'http://www.wikidata.org/entity/Q24292169',
    'http://www.wikidata.org/entity/Q24292184',
    'http://www.wikidata.org/entity/Q24292209',
    'http://www.wikidata.org/entity/Q24292229',
    'http://www.wikidata.org/entity/Q24292278',
    'http://www.wikidata.org/entity/Q24292395',
    'http://www.wikidata.org/entity/Q24292425',
    'http://www.wikidata.org/entity/Q24292468',
    'http://www.wikidata.org/entity/Q24292504',
    'http://www.wikidata.org/entity/Q24292505',
    'http://www.wikidata.org/entity/Q24292675',
    'http://www.wikidata.org/entity/Q24292682',
    'http://www.wikidata.org/entity/Q24292705',
    'http://www.wikidata.org/entity/Q24292709',
    'http://www.wikidata.org/entity/Q24292730',
    'http://www.wikidata.org/entity/Q24292781',
    'http://www.wikidata.org/entity/Q24292810',
    'http://www.wikidata.org/entity/Q24292850',
    'http://www.wikidata.org/entity/Q24292870',
    'http://www.wikidata.org/entity/Q24292901',
    'http://www.wikidata.org/entity/Q24292930',
    'http://www.wikidata.org/entity/Q24292946',
    'http://www.wikidata.org/entity/Q24292957',
    'http://www.wikidata.org/entity/Q24292977',
    'http://www.wikidata.org/entity/Q24293004',
    'http://www.wikidata.org/entity/Q24293099',
    'http://www.wikidata.org/entity/Q24293134',
    'http://www.wikidata.org/entity/Q24293191',
    'http://www.wikidata.org/entity/Q24293229',
    'http://www.wikidata.org/entity/Q24293235',
    'http://www.wikidata.org/entity/Q24293245',
    'http://www.wikidata.org/entity/Q24293248',
    'http://www.wikidata.org/entity/Q24293481',
    'http://www.wikidata.org/entity/Q24293501',
    'http://www.wikidata.org/entity/Q24293504',
    'http://www.wikidata.org/entity/Q24293532',
    'http://www.wikidata.org/entity/Q24293587',
    'http://www.wikidata.org/entity/Q24293598',
    'http://www.wikidata.org/entity/Q24293646',
    'http://www.wikidata.org/entity/Q24293656',
    'http://www.wikidata.org/entity/Q24293704',
    'http://www.wikidata.org/entity/Q24293705',
    'http://www.wikidata.org/entity/Q24293710',
    'http://www.wikidata.org/entity/Q24293723',
    'http://www.wikidata.org/entity/Q24293754',
    'http://www.wikidata.org/entity/Q24293924',
    'http://www.wikidata.org/entity/Q24294219',
    'http://www.wikidata.org/entity/Q24294262',
    'http://www.wikidata.org/entity/Q24294296',
    'http://www.wikidata.org/entity/Q24294365',
    'http://www.wikidata.org/entity/Q24294366',
    'http://www.wikidata.org/entity/Q24294409',
    'http://www.wikidata.org/entity/Q24294466',
    'http://www.wikidata.org/entity/Q24294635',
    'http://www.wikidata.org/entity/Q24294647',
    'http://www.wikidata.org/entity/Q24294691',
    'http://www.wikidata.org/entity/Q24294695',
    'http://www.wikidata.org/entity/Q24294716',
    'http://www.wikidata.org/entity/Q24294720',
    'http://www.wikidata.org/entity/Q24294726',
    'http://www.wikidata.org/entity/Q24294734',
    'http://www.wikidata.org/entity/Q24294741',
    'http://www.wikidata.org/entity/Q24294798',
    'http://www.wikidata.org/entity/Q24294809',
    'http://www.wikidata.org/entity/Q24294860',
    'http://www.wikidata.org/entity/Q24294864',
    'http://www.wikidata.org/entity/Q24294883',
    'http://www.wikidata.org/entity/Q24294904',
    'http://www.wikidata.org/entity/Q24294906',
    'http://www.wikidata.org/entity/Q24294908',
    'http://www.wikidata.org/entity/Q24294948',
    'http://www.wikidata.org/entity/Q24294993',
    'http://www.wikidata.org/entity/Q24294999',
    'http://www.wikidata.org/entity/Q24295120',
    'http://www.wikidata.org/entity/Q24295211',
    'http://www.wikidata.org/entity/Q24295234',
    'http://www.wikidata.org/entity/Q24295305',
    'http://www.wikidata.org/entity/Q24295641',
    'http://www.wikidata.org/entity/Q24296105',
    'http://www.wikidata.org/entity/Q24296107',
    'http://www.wikidata.org/entity/Q24296209',
    'http://www.wikidata.org/entity/Q24296229',
    'http://www.wikidata.org/entity/Q24296245',
    'http://www.wikidata.org/entity/Q24296260',
    'http://www.wikidata.org/entity/Q24296269',
    'http://www.wikidata.org/entity/Q24296288',
    'http://www.wikidata.org/entity/Q24296388',
    'http://www.wikidata.org/entity/Q24296441',
    'http://www.wikidata.org/entity/Q24296452',
    'http://www.wikidata.org/entity/Q24296473',
    'http://www.wikidata.org/entity/Q24296478',
    'http://www.wikidata.org/entity/Q24296492',
    'http://www.wikidata.org/entity/Q24296532',
    'http://www.wikidata.org/entity/Q24296620',
    'http://www.wikidata.org/entity/Q24296645',
    'http://www.wikidata.org/entity/Q24296738',
    'http://www.wikidata.org/entity/Q24296739',
    'http://www.wikidata.org/entity/Q24296766',
    'http://www.wikidata.org/entity/Q24296807',
    'http://www.wikidata.org/entity/Q24296836',
    'http://www.wikidata.org/entity/Q24296846',
    'http://www.wikidata.org/entity/Q24296940',
    'http://www.wikidata.org/entity/Q24296941',
    'http://www.wikidata.org/entity/Q24296955',
    'http://www.wikidata.org/entity/Q24296962',
    'http://www.wikidata.org/entity/Q24296973',
    'http://www.wikidata.org/entity/Q24297031',
    'http://www.wikidata.org/entity/Q24297037',
    'http://www.wikidata.org/entity/Q24297062',
    'http://www.wikidata.org/entity/Q24297064',
    'http://www.wikidata.org/entity/Q24297155',
    'http://www.wikidata.org/entity/Q24297207',
    'http://www.wikidata.org/entity/Q24297271',
    'http://www.wikidata.org/entity/Q24297338',
    'http://www.wikidata.org/entity/Q24297369',
    'http://www.wikidata.org/entity/Q24297376',
    'http://www.wikidata.org/entity/Q24297378',
    'http://www.wikidata.org/entity/Q24297416',
    'http://www.wikidata.org/entity/Q24297420',
    'http://www.wikidata.org/entity/Q24297430',
    'http://www.wikidata.org/entity/Q24297462',
    'http://www.wikidata.org/entity/Q24297538',
    'http://www.wikidata.org/entity/Q24297600',
    'http://www.wikidata.org/entity/Q24297643',
    'http://www.wikidata.org/entity/Q24297656',
    'http://www.wikidata.org/entity/Q24297669',
    'http://www.wikidata.org/entity/Q24297703',
    'http://www.wikidata.org/entity/Q24297732',
    'http://www.wikidata.org/entity/Q24297748',
    'http://www.wikidata.org/entity/Q24297794',
    'http://www.wikidata.org/entity/Q24297808',
    'http://www.wikidata.org/entity/Q24297812',
    'http://www.wikidata.org/entity/Q24297813',
    'http://www.wikidata.org/entity/Q24297880',
    'http://www.wikidata.org/entity/Q24297939',
    'http://www.wikidata.org/entity/Q24297966',
    'http://www.wikidata.org/entity/Q24297993',
    'http://www.wikidata.org/entity/Q24298013',
    'http://www.wikidata.org/entity/Q24298021',
    'http://www.wikidata.org/entity/Q24298036',
    'http://www.wikidata.org/entity/Q24298221',
    'http://www.wikidata.org/entity/Q24298271',
    'http://www.wikidata.org/entity/Q24298297',
    'http://www.wikidata.org/entity/Q24298360',
    'http://www.wikidata.org/entity/Q24298367',
    'http://www.wikidata.org/entity/Q24298384',
    'http://www.wikidata.org/entity/Q24298429',
    'http://www.wikidata.org/entity/Q24298439',
    'http://www.wikidata.org/entity/Q24298483',
    'http://www.wikidata.org/entity/Q24298486',
    'http://www.wikidata.org/entity/Q24298494',
    'http://www.wikidata.org/entity/Q24298499',
    'http://www.wikidata.org/entity/Q24298525',
    'http://www.wikidata.org/entity/Q24298581',
    'http://www.wikidata.org/entity/Q24298587',
    'http://www.wikidata.org/entity/Q24298605',
    'http://www.wikidata.org/entity/Q24298620',
    'http://www.wikidata.org/entity/Q24298626',
    'http://www.wikidata.org/entity/Q24298670',
    'http://www.wikidata.org/entity/Q24298685',
    'http://www.wikidata.org/entity/Q24298746',
    'http://www.wikidata.org/entity/Q24298747',
    'http://www.wikidata.org/entity/Q24298767',
    'http://www.wikidata.org/entity/Q24298863',
    'http://www.wikidata.org/entity/Q24298865',
    'http://www.wikidata.org/entity/Q24298937',
    'http://www.wikidata.org/entity/Q24298944',
    'http://www.wikidata.org/entity/Q24298956',
    'http://www.wikidata.org/entity/Q24299020',
    'http://www.wikidata.org/entity/Q24299042',
    'http://www.wikidata.org/entity/Q24299048',
    'http://www.wikidata.org/entity/Q24299061',
    'http://www.wikidata.org/entity/Q24299106',
    'http://www.wikidata.org/entity/Q24299149',
    'http://www.wikidata.org/entity/Q24299215',
    'http://www.wikidata.org/entity/Q24299236',
    'http://www.wikidata.org/entity/Q24299287',
    'http://www.wikidata.org/entity/Q24299301',
    'http://www.wikidata.org/entity/Q24299387',
    'http://www.wikidata.org/entity/Q24299488',
    'http://www.wikidata.org/entity/Q24299501',
    'http://www.wikidata.org/entity/Q24299523',
    'http://www.wikidata.org/entity/Q24299573',
    'http://www.wikidata.org/entity/Q24299603',
    'http://www.wikidata.org/entity/Q24299618',
    'http://www.wikidata.org/entity/Q24299631',
    'http://www.wikidata.org/entity/Q24299641',
    'http://www.wikidata.org/entity/Q24299813',
    'http://www.wikidata.org/entity/Q24299822',
    'http://www.wikidata.org/entity/Q24299852',
    'http://www.wikidata.org/entity/Q24299860',
    'http://www.wikidata.org/entity/Q24299862',
    'http://www.wikidata.org/entity/Q24299873',
    'http://www.wikidata.org/entity/Q24299939',
    'http://www.wikidata.org/entity/Q24299948',
    'http://www.wikidata.org/entity/Q24299991',
    'http://www.wikidata.org/entity/Q24300005',
    'http://www.wikidata.org/entity/Q24300015',
    'http://www.wikidata.org/entity/Q24300016',
    'http://www.wikidata.org/entity/Q24300024',
    'http://www.wikidata.org/entity/Q24300091',
    'http://www.wikidata.org/entity/Q24300161',
    'http://www.wikidata.org/entity/Q24300173',
    'http://www.wikidata.org/entity/Q24300176',
    'http://www.wikidata.org/entity/Q24300179',
    'http://www.wikidata.org/entity/Q24300249',
    'http://www.wikidata.org/entity/Q24300271',
    'http://www.wikidata.org/entity/Q24300284',
    'http://www.wikidata.org/entity/Q24300336',
    'http://www.wikidata.org/entity/Q24300347',
    'http://www.wikidata.org/entity/Q24300411',
    'http://www.wikidata.org/entity/Q24300428',
    'http://www.wikidata.org/entity/Q24300432',
    'http://www.wikidata.org/entity/Q24300435',
    'http://www.wikidata.org/entity/Q24300456',
    'http://www.wikidata.org/entity/Q24300526',
    'http://www.wikidata.org/entity/Q24300630',
    'http://www.wikidata.org/entity/Q24300707',
    'http://www.wikidata.org/entity/Q24300734',
    'http://www.wikidata.org/entity/Q24300737',
    'http://www.wikidata.org/entity/Q24300781',
    'http://www.wikidata.org/entity/Q24300834',
    'http://www.wikidata.org/entity/Q24300878',
    'http://www.wikidata.org/entity/Q24300880',
    'http://www.wikidata.org/entity/Q24300915',
    'http://www.wikidata.org/entity/Q24300926',
    'http://www.wikidata.org/entity/Q24300945',
    'http://www.wikidata.org/entity/Q24300975',
    'http://www.wikidata.org/entity/Q24301009',
    'http://www.wikidata.org/entity/Q24301020',
    'http://www.wikidata.org/entity/Q24301028',
    'http://www.wikidata.org/entity/Q24301045',
    'http://www.wikidata.org/entity/Q24301087',
    'http://www.wikidata.org/entity/Q24301153',
    'http://www.wikidata.org/entity/Q24301357',
    'http://www.wikidata.org/entity/Q24301410',
    'http://www.wikidata.org/entity/Q24301468',
    'http://www.wikidata.org/entity/Q24301514',
    'http://www.wikidata.org/entity/Q24301554',
    'http://www.wikidata.org/entity/Q24301564',
    'http://www.wikidata.org/entity/Q24301629',
    'http://www.wikidata.org/entity/Q24301655',
    'http://www.wikidata.org/entity/Q24301679',
    'http://www.wikidata.org/entity/Q24301688',
    'http://www.wikidata.org/entity/Q24301720',
    'http://www.wikidata.org/entity/Q24301829',
    'http://www.wikidata.org/entity/Q24301843',
    'http://www.wikidata.org/entity/Q24301868',
    'http://www.wikidata.org/entity/Q24301883',
    'http://www.wikidata.org/entity/Q24301892',
    'http://www.wikidata.org/entity/Q24301895',
    'http://www.wikidata.org/entity/Q24301905',
    'http://www.wikidata.org/entity/Q24301912',
    'http://www.wikidata.org/entity/Q24301944',
    'http://www.wikidata.org/entity/Q24301946',
    'http://www.wikidata.org/entity/Q24302042',
    'http://www.wikidata.org/entity/Q24302046',
    'http://www.wikidata.org/entity/Q24302072',
    'http://www.wikidata.org/entity/Q24302129',
    'http://www.wikidata.org/entity/Q24302150',
    'http://www.wikidata.org/entity/Q24302166',
    'http://www.wikidata.org/entity/Q24302178',
    'http://www.wikidata.org/entity/Q24302185',
    'http://www.wikidata.org/entity/Q24302194',
    'http://www.wikidata.org/entity/Q24302195',
    'http://www.wikidata.org/entity/Q24302241',
    'http://www.wikidata.org/entity/Q24302290',
    'http://www.wikidata.org/entity/Q24302298',
    'http://www.wikidata.org/entity/Q24302381',
    'http://www.wikidata.org/entity/Q24302411',
    'http://www.wikidata.org/entity/Q24302494',
    'http://www.wikidata.org/entity/Q24302505',
    'http://www.wikidata.org/entity/Q24302526',
    'http://www.wikidata.org/entity/Q24302549',
    'http://www.wikidata.org/entity/Q24302566',
    'http://www.wikidata.org/entity/Q24302640',
    'http://www.wikidata.org/entity/Q24302858',
    'http://www.wikidata.org/entity/Q24302985',
    'http://www.wikidata.org/entity/Q24303092',
    'http://www.wikidata.org/entity/Q24303227',
    'http://www.wikidata.org/entity/Q24303248',
    'http://www.wikidata.org/entity/Q24303369',
    'http://www.wikidata.org/entity/Q24303416',
    'http://www.wikidata.org/entity/Q24303420',
    'http://www.wikidata.org/entity/Q24303448',
    'http://www.wikidata.org/entity/Q24303499',
    'http://www.wikidata.org/entity/Q24303558',
    'http://www.wikidata.org/entity/Q24303603',
    'http://www.wikidata.org/entity/Q24303649',
    'http://www.wikidata.org/entity/Q24303662',
    'http://www.wikidata.org/entity/Q24303752',
    'http://www.wikidata.org/entity/Q24303760',
    'http://www.wikidata.org/entity/Q24303802',
    'http://www.wikidata.org/entity/Q24303817',
    'http://www.wikidata.org/entity/Q24303857',
    'http://www.wikidata.org/entity/Q24303900',
    'http://www.wikidata.org/entity/Q24303914',
    'http://www.wikidata.org/entity/Q24304073',
    'http://www.wikidata.org/entity/Q24304087',
    'http://www.wikidata.org/entity/Q24304147',
    'http://www.wikidata.org/entity/Q24304190',
    'http://www.wikidata.org/entity/Q24304260',
    'http://www.wikidata.org/entity/Q24304277',
    'http://www.wikidata.org/entity/Q24304337',
    'http://www.wikidata.org/entity/Q24304348',
    'http://www.wikidata.org/entity/Q24304409',
    'http://www.wikidata.org/entity/Q24304415',
    'http://www.wikidata.org/entity/Q24304438',
    'http://www.wikidata.org/entity/Q24304447',
    'http://www.wikidata.org/entity/Q24304841',
    'http://www.wikidata.org/entity/Q24304874',
    'http://www.wikidata.org/entity/Q24304889',
    'http://www.wikidata.org/entity/Q24304896',
    'http://www.wikidata.org/entity/Q24304921',
    'http://www.wikidata.org/entity/Q24304937',
    'http://www.wikidata.org/entity/Q24304941',
    'http://www.wikidata.org/entity/Q24304942',
    'http://www.wikidata.org/entity/Q24304955',
    'http://www.wikidata.org/entity/Q24305030',
    'http://www.wikidata.org/entity/Q24305075',
    'http://www.wikidata.org/entity/Q24305090',
    'http://www.wikidata.org/entity/Q24305112',
    'http://www.wikidata.org/entity/Q24305136',
    'http://www.wikidata.org/entity/Q24305145',
    'http://www.wikidata.org/entity/Q24305201',
    'http://www.wikidata.org/entity/Q24305231',
    'http://www.wikidata.org/entity/Q24305238',
    'http://www.wikidata.org/entity/Q24305242',
    'http://www.wikidata.org/entity/Q24305254',
    'http://www.wikidata.org/entity/Q24305315',
    'http://www.wikidata.org/entity/Q24305335',
    'http://www.wikidata.org/entity/Q24305372',
    'http://www.wikidata.org/entity/Q24305376',
    'http://www.wikidata.org/entity/Q24305416',
    'http://www.wikidata.org/entity/Q24305439',
    'http://www.wikidata.org/entity/Q24305442',
    'http://www.wikidata.org/entity/Q24305459',
    'http://www.wikidata.org/entity/Q24305536',
    'http://www.wikidata.org/entity/Q24305570',
    'http://www.wikidata.org/entity/Q24305575',
    'http://www.wikidata.org/entity/Q24305646',
    'http://www.wikidata.org/entity/Q24305830',
    'http://www.wikidata.org/entity/Q24306039',
    'http://www.wikidata.org/entity/Q24306108',
    'http://www.wikidata.org/entity/Q24306121',
    'http://www.wikidata.org/entity/Q24306181',
    'http://www.wikidata.org/entity/Q24306203',
    'http://www.wikidata.org/entity/Q24306298',
    'http://www.wikidata.org/entity/Q24306318',
    'http://www.wikidata.org/entity/Q24306328',
    'http://www.wikidata.org/entity/Q24306330',
    'http://www.wikidata.org/entity/Q24306444',
    'http://www.wikidata.org/entity/Q24306469',
    'http://www.wikidata.org/entity/Q24306483',
    'http://www.wikidata.org/entity/Q24306525',
    'http://www.wikidata.org/entity/Q24306560',
    'http://www.wikidata.org/entity/Q24306621',
    'http://www.wikidata.org/entity/Q24306633',
    'http://www.wikidata.org/entity/Q24306635',
    'http://www.wikidata.org/entity/Q24306696',
    'http://www.wikidata.org/entity/Q24306743',
    'http://www.wikidata.org/entity/Q24306745',
    'http://www.wikidata.org/entity/Q24306765',
    'http://www.wikidata.org/entity/Q24306782',
    'http://www.wikidata.org/entity/Q24306789',
    'http://www.wikidata.org/entity/Q24306795',
    'http://www.wikidata.org/entity/Q24306807',
    'http://www.wikidata.org/entity/Q24306825',
    'http://www.wikidata.org/entity/Q24306850',
    'http://www.wikidata.org/entity/Q24306903',
    'http://www.wikidata.org/entity/Q24306904',
    'http://www.wikidata.org/entity/Q24307146',
    'http://www.wikidata.org/entity/Q24307232',
    'http://www.wikidata.org/entity/Q24307362',
    'http://www.wikidata.org/entity/Q24307379',
    'http://www.wikidata.org/entity/Q24307382',
    'http://www.wikidata.org/entity/Q24307384',
    'http://www.wikidata.org/entity/Q24307391',
    'http://www.wikidata.org/entity/Q24307426',
    'http://www.wikidata.org/entity/Q24307429',
    'http://www.wikidata.org/entity/Q24307457',
    'http://www.wikidata.org/entity/Q24307461',
    'http://www.wikidata.org/entity/Q24307473',
    'http://www.wikidata.org/entity/Q24307570',
    'http://www.wikidata.org/entity/Q24307627',
    'http://www.wikidata.org/entity/Q24307661',
    'http://www.wikidata.org/entity/Q24307684',
    'http://www.wikidata.org/entity/Q24307700',
    'http://www.wikidata.org/entity/Q24307703',
    'http://www.wikidata.org/entity/Q24307717',
    'http://www.wikidata.org/entity/Q24307721',
    'http://www.wikidata.org/entity/Q24307759',
    'http://www.wikidata.org/entity/Q24307776',
    'http://www.wikidata.org/entity/Q24307778',
    'http://www.wikidata.org/entity/Q24307822',
    'http://www.wikidata.org/entity/Q24307946',
    'http://www.wikidata.org/entity/Q24307957',
    'http://www.wikidata.org/entity/Q24307963',
    'http://www.wikidata.org/entity/Q24307985',
    'http://www.wikidata.org/entity/Q24307994',
    'http://www.wikidata.org/entity/Q24307995',
    'http://www.wikidata.org/entity/Q24307999',
    'http://www.wikidata.org/entity/Q24308005',
    'http://www.wikidata.org/entity/Q24308048',
    'http://www.wikidata.org/entity/Q24308079',
    'http://www.wikidata.org/entity/Q24308632',
    'http://www.wikidata.org/entity/Q24308725',
    'http://www.wikidata.org/entity/Q24308751',
    'http://www.wikidata.org/entity/Q24308767',
    'http://www.wikidata.org/entity/Q24308770',
    'http://www.wikidata.org/entity/Q24308774',
    'http://www.wikidata.org/entity/Q24308803',
    'http://www.wikidata.org/entity/Q24308810',
    'http://www.wikidata.org/entity/Q24308818',
    'http://www.wikidata.org/entity/Q24308837',
    'http://www.wikidata.org/entity/Q24308838',
    'http://www.wikidata.org/entity/Q24308839',
    'http://www.wikidata.org/entity/Q24309034',
    'http://www.wikidata.org/entity/Q24309037',
    'http://www.wikidata.org/entity/Q24309061',
    'http://www.wikidata.org/entity/Q24309066',
    'http://www.wikidata.org/entity/Q24309107',
    'http://www.wikidata.org/entity/Q24309112',
    'http://www.wikidata.org/entity/Q24309181',
    'http://www.wikidata.org/entity/Q24309195',
    'http://www.wikidata.org/entity/Q24309211',
    'http://www.wikidata.org/entity/Q24309274',
    'http://www.wikidata.org/entity/Q24309283',
    'http://www.wikidata.org/entity/Q24309287',
    'http://www.wikidata.org/entity/Q24309316',
    'http://www.wikidata.org/entity/Q24309323',
    'http://www.wikidata.org/entity/Q24309359',
    'http://www.wikidata.org/entity/Q24309386',
    'http://www.wikidata.org/entity/Q24309392',
    'http://www.wikidata.org/entity/Q24309412',
    'http://www.wikidata.org/entity/Q24309438',
    'http://www.wikidata.org/entity/Q24309442',
    'http://www.wikidata.org/entity/Q24309462',
    'http://www.wikidata.org/entity/Q24309521',
    'http://www.wikidata.org/entity/Q24309528',
    'http://www.wikidata.org/entity/Q24309549',
    'http://www.wikidata.org/entity/Q24309588',
    'http://www.wikidata.org/entity/Q24309601',
    'http://www.wikidata.org/entity/Q24309753',
    'http://www.wikidata.org/entity/Q24309767',
    'http://www.wikidata.org/entity/Q24310014',
    'http://www.wikidata.org/entity/Q24310017',
    'http://www.wikidata.org/entity/Q24310068',
    'http://www.wikidata.org/entity/Q24310115',
    'http://www.wikidata.org/entity/Q24310146',
    'http://www.wikidata.org/entity/Q24310148',
    'http://www.wikidata.org/entity/Q24310185',
    'http://www.wikidata.org/entity/Q24310187',
    'http://www.wikidata.org/entity/Q24310207',
    'http://www.wikidata.org/entity/Q24310253',
    'http://www.wikidata.org/entity/Q24310279',
    'http://www.wikidata.org/entity/Q24310301',
    'http://www.wikidata.org/entity/Q24310383',
    'http://www.wikidata.org/entity/Q24310398',
    'http://www.wikidata.org/entity/Q24310431',
    'http://www.wikidata.org/entity/Q24310434',
    'http://www.wikidata.org/entity/Q24310456',
    'http://www.wikidata.org/entity/Q24310473',
    'http://www.wikidata.org/entity/Q24310536',
    'http://www.wikidata.org/entity/Q24310545',
    'http://www.wikidata.org/entity/Q24310559',
    'http://www.wikidata.org/entity/Q24310570',
    'http://www.wikidata.org/entity/Q24310596',
    'http://www.wikidata.org/entity/Q24310597',
    'http://www.wikidata.org/entity/Q24310603',
    'http://www.wikidata.org/entity/Q24310618',
    'http://www.wikidata.org/entity/Q24310629',
    'http://www.wikidata.org/entity/Q24310637',
    'http://www.wikidata.org/entity/Q24310658',
    'http://www.wikidata.org/entity/Q24310670',
    'http://www.wikidata.org/entity/Q24310677',
    'http://www.wikidata.org/entity/Q24310712',
    'http://www.wikidata.org/entity/Q24310742',
    'http://www.wikidata.org/entity/Q24310786',
    'http://www.wikidata.org/entity/Q24310836',
    'http://www.wikidata.org/entity/Q24310885',
    'http://www.wikidata.org/entity/Q24311006',
    'http://www.wikidata.org/entity/Q24311139',
    'http://www.wikidata.org/entity/Q24311186',
    'http://www.wikidata.org/entity/Q24311291',
    'http://www.wikidata.org/entity/Q24311298',
    'http://www.wikidata.org/entity/Q24311332',
    'http://www.wikidata.org/entity/Q24311448',
    'http://www.wikidata.org/entity/Q24311488',
    'http://www.wikidata.org/entity/Q24311582',
    'http://www.wikidata.org/entity/Q24311588',
    'http://www.wikidata.org/entity/Q24311615',
    'http://www.wikidata.org/entity/Q24311676',
    'http://www.wikidata.org/entity/Q24311685',
    'http://www.wikidata.org/entity/Q24311702',
    'http://www.wikidata.org/entity/Q24311708',
    'http://www.wikidata.org/entity/Q24311741',
    'http://www.wikidata.org/entity/Q24311749',
    'http://www.wikidata.org/entity/Q24311799',
    'http://www.wikidata.org/entity/Q24311809',
    'http://www.wikidata.org/entity/Q24311815',
    'http://www.wikidata.org/entity/Q24311830',
    'http://www.wikidata.org/entity/Q24311839',
    'http://www.wikidata.org/entity/Q24311858',
    'http://www.wikidata.org/entity/Q24311871',
    'http://www.wikidata.org/entity/Q24311891',
    'http://www.wikidata.org/entity/Q24311906',
    'http://www.wikidata.org/entity/Q24311913',
    'http://www.wikidata.org/entity/Q24312038',
    'http://www.wikidata.org/entity/Q24312106',
    'http://www.wikidata.org/entity/Q24312113',
    'http://www.wikidata.org/entity/Q24312147',
    'http://www.wikidata.org/entity/Q24312157',
    'http://www.wikidata.org/entity/Q24312187',
    'http://www.wikidata.org/entity/Q24312211',
    'http://www.wikidata.org/entity/Q24312224',
    'http://www.wikidata.org/entity/Q24312492',
    'http://www.wikidata.org/entity/Q24312603',
    'http://www.wikidata.org/entity/Q24312611',
    'http://www.wikidata.org/entity/Q24312638',
    'http://www.wikidata.org/entity/Q24312713',
    'http://www.wikidata.org/entity/Q24312733',
    'http://www.wikidata.org/entity/Q24312738',
    'http://www.wikidata.org/entity/Q24312778',
    'http://www.wikidata.org/entity/Q24312844',
    'http://www.wikidata.org/entity/Q24312912',
    'http://www.wikidata.org/entity/Q24312925',
    'http://www.wikidata.org/entity/Q24312942',
    'http://www.wikidata.org/entity/Q24312958',
    'http://www.wikidata.org/entity/Q24312962',
    'http://www.wikidata.org/entity/Q24312976',
    'http://www.wikidata.org/entity/Q24313022',
    'http://www.wikidata.org/entity/Q24313082',
    'http://www.wikidata.org/entity/Q24313168',
    'http://www.wikidata.org/entity/Q24313174',
    'http://www.wikidata.org/entity/Q24313196',
    'http://www.wikidata.org/entity/Q24313206',
    'http://www.wikidata.org/entity/Q24313303',
    'http://www.wikidata.org/entity/Q24313328',
    'http://www.wikidata.org/entity/Q24313329',
    'http://www.wikidata.org/entity/Q24313372',
    'http://www.wikidata.org/entity/Q24313374',
    'http://www.wikidata.org/entity/Q24313427',
    'http://www.wikidata.org/entity/Q24313433',
    'http://www.wikidata.org/entity/Q24313471',
    'http://www.wikidata.org/entity/Q24313491',
    'http://www.wikidata.org/entity/Q24313501',
    'http://www.wikidata.org/entity/Q24313505',
    'http://www.wikidata.org/entity/Q24313508',
    'http://www.wikidata.org/entity/Q24313544',
    'http://www.wikidata.org/entity/Q24313546',
    'http://www.wikidata.org/entity/Q24313572',
    'http://www.wikidata.org/entity/Q24313579',
    'http://www.wikidata.org/entity/Q24313586',
    'http://www.wikidata.org/entity/Q24313590',
    'http://www.wikidata.org/entity/Q24313604',
    'http://www.wikidata.org/entity/Q24313656',
    'http://www.wikidata.org/entity/Q24313701',
    'http://www.wikidata.org/entity/Q24313918',
    'http://www.wikidata.org/entity/Q24314148',
    'http://www.wikidata.org/entity/Q24314282',
    'http://www.wikidata.org/entity/Q24314301',
    'http://www.wikidata.org/entity/Q24314317',
    'http://www.wikidata.org/entity/Q24314357',
    'http://www.wikidata.org/entity/Q24314363',
    'http://www.wikidata.org/entity/Q24314385',
    'http://www.wikidata.org/entity/Q24314398',
    'http://www.wikidata.org/entity/Q24314404',
    'http://www.wikidata.org/entity/Q24314434',
    'http://www.wikidata.org/entity/Q24314442',
    'http://www.wikidata.org/entity/Q24314465',
    'http://www.wikidata.org/entity/Q24314491',
    'http://www.wikidata.org/entity/Q24314520',
    'http://www.wikidata.org/entity/Q24314526',
    'http://www.wikidata.org/entity/Q24314579',
    'http://www.wikidata.org/entity/Q24314612',
    'http://www.wikidata.org/entity/Q24314616',
    'http://www.wikidata.org/entity/Q24314628',
    'http://www.wikidata.org/entity/Q24314644',
    'http://www.wikidata.org/entity/Q24314661',
    'http://www.wikidata.org/entity/Q24314667',
    'http://www.wikidata.org/entity/Q24314740',
    'http://www.wikidata.org/entity/Q24314755',
    'http://www.wikidata.org/entity/Q24314763',
    'http://www.wikidata.org/entity/Q24314766',
    'http://www.wikidata.org/entity/Q24314793',
    'http://www.wikidata.org/entity/Q24314809',
    'http://www.wikidata.org/entity/Q24314906',
    'http://www.wikidata.org/entity/Q24314991',
    'http://www.wikidata.org/entity/Q24315006',
    'http://www.wikidata.org/entity/Q24315021',
    'http://www.wikidata.org/entity/Q24315074',
    'http://www.wikidata.org/entity/Q24315083',
    'http://www.wikidata.org/entity/Q24315133',
    'http://www.wikidata.org/entity/Q24315144',
    'http://www.wikidata.org/entity/Q24315150',
    'http://www.wikidata.org/entity/Q24315182',
    'http://www.wikidata.org/entity/Q24315236',
    'http://www.wikidata.org/entity/Q24315369',
    'http://www.wikidata.org/entity/Q24315492',
    'http://www.wikidata.org/entity/Q24315540',
    'http://www.wikidata.org/entity/Q24315566',
    'http://www.wikidata.org/entity/Q24315619',
    'http://www.wikidata.org/entity/Q24315625',
    'http://www.wikidata.org/entity/Q24315670',
    'http://www.wikidata.org/entity/Q24315679',
    'http://www.wikidata.org/entity/Q24315707',
    'http://www.wikidata.org/entity/Q24315722',
    'http://www.wikidata.org/entity/Q24315723',
    'http://www.wikidata.org/entity/Q24315738',
    'http://www.wikidata.org/entity/Q24315805',
    'http://www.wikidata.org/entity/Q24315811',
    'http://www.wikidata.org/entity/Q24315875',
    'http://www.wikidata.org/entity/Q24315882',
    'http://www.wikidata.org/entity/Q24315885',
    'http://www.wikidata.org/entity/Q24315937',
    'http://www.wikidata.org/entity/Q24315943',
    'http://www.wikidata.org/entity/Q24315967',
    'http://www.wikidata.org/entity/Q24316037',
    'http://www.wikidata.org/entity/Q24316038',
    'http://www.wikidata.org/entity/Q24316075',
    'http://www.wikidata.org/entity/Q24316079',
    'http://www.wikidata.org/entity/Q24316085',
    'http://www.wikidata.org/entity/Q24316090',
    'http://www.wikidata.org/entity/Q24316099',
    'http://www.wikidata.org/entity/Q24316112',
    'http://www.wikidata.org/entity/Q24316121',
    'http://www.wikidata.org/entity/Q24316135',
    'http://www.wikidata.org/entity/Q24316177',
    'http://www.wikidata.org/entity/Q24316203',
    'http://www.wikidata.org/entity/Q24316216',
    'http://www.wikidata.org/entity/Q24316236',
    'http://www.wikidata.org/entity/Q24316320',
    'http://www.wikidata.org/entity/Q24316355',
    'http://www.wikidata.org/entity/Q24316367',
    'http://www.wikidata.org/entity/Q24316383',
    'http://www.wikidata.org/entity/Q24316439',
    'http://www.wikidata.org/entity/Q24316446',
    'http://www.wikidata.org/entity/Q24316449',
    'http://www.wikidata.org/entity/Q24316454',
    'http://www.wikidata.org/entity/Q24316469',
    'http://www.wikidata.org/entity/Q24316492',
    'http://www.wikidata.org/entity/Q24316501',
    'http://www.wikidata.org/entity/Q24316540',
    'http://www.wikidata.org/entity/Q24316558',
    'http://www.wikidata.org/entity/Q24316697',
    'http://www.wikidata.org/entity/Q24316811',
    'http://www.wikidata.org/entity/Q24316905',
    'http://www.wikidata.org/entity/Q24316939',
    'http://www.wikidata.org/entity/Q24316945',
    'http://www.wikidata.org/entity/Q24316950',
    'http://www.wikidata.org/entity/Q24316967',
    'http://www.wikidata.org/entity/Q24317051',
    'http://www.wikidata.org/entity/Q24317067',
    'http://www.wikidata.org/entity/Q24317099',
    'http://www.wikidata.org/entity/Q24317134',
    'http://www.wikidata.org/entity/Q24317137',
    'http://www.wikidata.org/entity/Q24317164',
    'http://www.wikidata.org/entity/Q24317317',
    'http://www.wikidata.org/entity/Q24317348',
    'http://www.wikidata.org/entity/Q24317377',
    'http://www.wikidata.org/entity/Q24317381',
    'http://www.wikidata.org/entity/Q24317429',
    'http://www.wikidata.org/entity/Q24317437',
    'http://www.wikidata.org/entity/Q24317441',
    'http://www.wikidata.org/entity/Q24317451',
    'http://www.wikidata.org/entity/Q24317471',
    'http://www.wikidata.org/entity/Q24317488',
    'http://www.wikidata.org/entity/Q24317523',
    'http://www.wikidata.org/entity/Q24317564',
    'http://www.wikidata.org/entity/Q24317574',
    'http://www.wikidata.org/entity/Q24317613',
    'http://www.wikidata.org/entity/Q24317667',
    'http://www.wikidata.org/entity/Q24317670',
    'http://www.wikidata.org/entity/Q24317677',
    'http://www.wikidata.org/entity/Q24317714',
    'http://www.wikidata.org/entity/Q24317745',
    'http://www.wikidata.org/entity/Q24317771',
    'http://www.wikidata.org/entity/Q24317775',
    'http://www.wikidata.org/entity/Q24317778',
    'http://www.wikidata.org/entity/Q24317782',
    'http://www.wikidata.org/entity/Q24317784',
    'http://www.wikidata.org/entity/Q24317859',
    'http://www.wikidata.org/entity/Q24317933',
    'http://www.wikidata.org/entity/Q24318187',
    'http://www.wikidata.org/entity/Q24318271',
    'http://www.wikidata.org/entity/Q24318280',
    'http://www.wikidata.org/entity/Q24318406',
    'http://www.wikidata.org/entity/Q24318423',
    'http://www.wikidata.org/entity/Q24318426',
    'http://www.wikidata.org/entity/Q24318446',
    'http://www.wikidata.org/entity/Q24318484',
    'http://www.wikidata.org/entity/Q24318486',
    'http://www.wikidata.org/entity/Q24318500',
    'http://www.wikidata.org/entity/Q24318533',
    'http://www.wikidata.org/entity/Q24318546',
    'http://www.wikidata.org/entity/Q24318563',
    'http://www.wikidata.org/entity/Q24318603',
    'http://www.wikidata.org/entity/Q24318643',
    'http://www.wikidata.org/entity/Q24318669',
    'http://www.wikidata.org/entity/Q24318702',
    'http://www.wikidata.org/entity/Q24318710',
    'http://www.wikidata.org/entity/Q24318742',
    'http://www.wikidata.org/entity/Q24318814',
    'http://www.wikidata.org/entity/Q24318845',
    'http://www.wikidata.org/entity/Q24318937',
    'http://www.wikidata.org/entity/Q24318972',
    'http://www.wikidata.org/entity/Q24318979',
    'http://www.wikidata.org/entity/Q24319002',
    'http://www.wikidata.org/entity/Q24319016',
    'http://www.wikidata.org/entity/Q24319020',
    'http://www.wikidata.org/entity/Q24319150',
    'http://www.wikidata.org/entity/Q24319677',
    'http://www.wikidata.org/entity/Q24319706',
    'http://www.wikidata.org/entity/Q24319737',
    'http://www.wikidata.org/entity/Q24319751',
    'http://www.wikidata.org/entity/Q24319765',
    'http://www.wikidata.org/entity/Q24319767',
    'http://www.wikidata.org/entity/Q24319797',
    'http://www.wikidata.org/entity/Q24319799',
    'http://www.wikidata.org/entity/Q24319816',
    'http://www.wikidata.org/entity/Q24319848',
    'http://www.wikidata.org/entity/Q24319855',
    'http://www.wikidata.org/entity/Q24319891',
    'http://www.wikidata.org/entity/Q24319897',
    'http://www.wikidata.org/entity/Q24319940',
    'http://www.wikidata.org/entity/Q24319974',
    'http://www.wikidata.org/entity/Q24319995',
    'http://www.wikidata.org/entity/Q24319999',
    'http://www.wikidata.org/entity/Q24320018',
    'http://www.wikidata.org/entity/Q24320035',
    'http://www.wikidata.org/entity/Q24320057',
    'http://www.wikidata.org/entity/Q24320080',
    'http://www.wikidata.org/entity/Q24320105',
    'http://www.wikidata.org/entity/Q24320111',
    'http://www.wikidata.org/entity/Q24320127',
    'http://www.wikidata.org/entity/Q24320173',
    'http://www.wikidata.org/entity/Q24320178',
    'http://www.wikidata.org/entity/Q24320227',
    'http://www.wikidata.org/entity/Q24320229',
    'http://www.wikidata.org/entity/Q24320239',
    'http://www.wikidata.org/entity/Q24320240',
    'http://www.wikidata.org/entity/Q24320257',
    'http://www.wikidata.org/entity/Q24320260',
    'http://www.wikidata.org/entity/Q24320267',
    'http://www.wikidata.org/entity/Q24320277',
    'http://www.wikidata.org/entity/Q24320301',
    'http://www.wikidata.org/entity/Q24320314',
    'http://www.wikidata.org/entity/Q24320327',
    'http://www.wikidata.org/entity/Q24320385',
    'http://www.wikidata.org/entity/Q24320401',
    'http://www.wikidata.org/entity/Q24320710',
    'http://www.wikidata.org/entity/Q24321082',
    'http://www.wikidata.org/entity/Q24321247',
    'http://www.wikidata.org/entity/Q24321319',
    'http://www.wikidata.org/entity/Q24321355',
    'http://www.wikidata.org/entity/Q24321359',
    'http://www.wikidata.org/entity/Q24321429',
    'http://www.wikidata.org/entity/Q24321455',
    'http://www.wikidata.org/entity/Q24321489',
    'http://www.wikidata.org/entity/Q24321505',
    'http://www.wikidata.org/entity/Q24321564',
    'http://www.wikidata.org/entity/Q24321631',
    'http://www.wikidata.org/entity/Q24321670',
    'http://www.wikidata.org/entity/Q24321699',
    'http://www.wikidata.org/entity/Q24321709',
    'http://www.wikidata.org/entity/Q24321727',
    'http://www.wikidata.org/entity/Q24321775',
    'http://www.wikidata.org/entity/Q24321787',
    'http://www.wikidata.org/entity/Q24321792',
    'http://www.wikidata.org/entity/Q24321797',
    'http://www.wikidata.org/entity/Q24321888',
    'http://www.wikidata.org/entity/Q24321919',
    'http://www.wikidata.org/entity/Q24321939',
    'http://www.wikidata.org/entity/Q24322016',
    'http://www.wikidata.org/entity/Q24322017',
    'http://www.wikidata.org/entity/Q24322072',
    'http://www.wikidata.org/entity/Q24322090',
    'http://www.wikidata.org/entity/Q24322162',
    'http://www.wikidata.org/entity/Q24322379',
    'http://www.wikidata.org/entity/Q24322558',
    'http://www.wikidata.org/entity/Q24322597',
    'http://www.wikidata.org/entity/Q24322614',
    'http://www.wikidata.org/entity/Q24322618',
    'http://www.wikidata.org/entity/Q24322668',
    'http://www.wikidata.org/entity/Q24322674',
    'http://www.wikidata.org/entity/Q24322718',
    'http://www.wikidata.org/entity/Q24322723',
    'http://www.wikidata.org/entity/Q24322747',
    'http://www.wikidata.org/entity/Q24322872',
    'http://www.wikidata.org/entity/Q24322907',
    'http://www.wikidata.org/entity/Q24322925',
    'http://www.wikidata.org/entity/Q24322974',
    'http://www.wikidata.org/entity/Q24322990',
    'http://www.wikidata.org/entity/Q24323168',
    'http://www.wikidata.org/entity/Q24323236',
    'http://www.wikidata.org/entity/Q24323274',
    'http://www.wikidata.org/entity/Q24323300',
    'http://www.wikidata.org/entity/Q24323318',
    'http://www.wikidata.org/entity/Q24323343',
    'http://www.wikidata.org/entity/Q24323360',
    'http://www.wikidata.org/entity/Q24323363',
    'http://www.wikidata.org/entity/Q24323370',
    'http://www.wikidata.org/entity/Q24323379',
    'http://www.wikidata.org/entity/Q24323433',
    'http://www.wikidata.org/entity/Q24323579',
    'http://www.wikidata.org/entity/Q24323830',
    'http://www.wikidata.org/entity/Q24323876',
    'http://www.wikidata.org/entity/Q24323888',
    'http://www.wikidata.org/entity/Q24323906',
    'http://www.wikidata.org/entity/Q24323946',
    'http://www.wikidata.org/entity/Q24324004',
    'http://www.wikidata.org/entity/Q24324026',
    'http://www.wikidata.org/entity/Q24324148',
    'http://www.wikidata.org/entity/Q24324172',
    'http://www.wikidata.org/entity/Q24324365',
    'http://www.wikidata.org/entity/Q24324450',
    'http://www.wikidata.org/entity/Q24324452',
    'http://www.wikidata.org/entity/Q24324482',
    'http://www.wikidata.org/entity/Q24324497',
    'http://www.wikidata.org/entity/Q24324535',
    'http://www.wikidata.org/entity/Q24324556',
    'http://www.wikidata.org/entity/Q24324559',
    'http://www.wikidata.org/entity/Q24324577',
    'http://www.wikidata.org/entity/Q24324602',
    'http://www.wikidata.org/entity/Q24324679',
    'http://www.wikidata.org/entity/Q24324692',
    'http://www.wikidata.org/entity/Q24324798',
    'http://www.wikidata.org/entity/Q24324828',
    'http://www.wikidata.org/entity/Q24328775',
    'http://www.wikidata.org/entity/Q24328777',
    'http://www.wikidata.org/entity/Q24328782',
    'http://www.wikidata.org/entity/Q24328901',
    'http://www.wikidata.org/entity/Q24329019',
    'http://www.wikidata.org/entity/Q24329065',
    'http://www.wikidata.org/entity/Q24329073',
    'http://www.wikidata.org/entity/Q24329089',
    'http://www.wikidata.org/entity/Q24329123',
    'http://www.wikidata.org/entity/Q24329155',
    'http://www.wikidata.org/entity/Q24329156',
    'http://www.wikidata.org/entity/Q24329175',
    'http://www.wikidata.org/entity/Q24329214',
    'http://www.wikidata.org/entity/Q24329220',
    'http://www.wikidata.org/entity/Q24329236',
    'http://www.wikidata.org/entity/Q24329244',
    'http://www.wikidata.org/entity/Q24329246',
    'http://www.wikidata.org/entity/Q24335999',
    'http://www.wikidata.org/entity/Q24336018',
    'http://www.wikidata.org/entity/Q24336057',
    'http://www.wikidata.org/entity/Q24336081',
    'http://www.wikidata.org/entity/Q24336088',
    'http://www.wikidata.org/entity/Q24336098',
    'http://www.wikidata.org/entity/Q24336131',
    'http://www.wikidata.org/entity/Q24336139',
    'http://www.wikidata.org/entity/Q24336152',
    'http://www.wikidata.org/entity/Q24336174',
    'http://www.wikidata.org/entity/Q24336187',
    'http://www.wikidata.org/entity/Q24336199',
    'http://www.wikidata.org/entity/Q24336216',
    'http://www.wikidata.org/entity/Q24336220',
    'http://www.wikidata.org/entity/Q24336250',
    'http://www.wikidata.org/entity/Q24336255',
    'http://www.wikidata.org/entity/Q24336259',
    'http://www.wikidata.org/entity/Q24336272',
    'http://www.wikidata.org/entity/Q24336293',
    'http://www.wikidata.org/entity/Q24336321',
    'http://www.wikidata.org/entity/Q24336322',
    'http://www.wikidata.org/entity/Q24336334',
    'http://www.wikidata.org/entity/Q24336389',
    'http://www.wikidata.org/entity/Q24336391',
    'http://www.wikidata.org/entity/Q24336398',
    'http://www.wikidata.org/entity/Q24336409',
    'http://www.wikidata.org/entity/Q24336451',
    'http://www.wikidata.org/entity/Q24336455',
    'http://www.wikidata.org/entity/Q24336457',
    'http://www.wikidata.org/entity/Q24336478',
    'http://www.wikidata.org/entity/Q24336486',
    'http://www.wikidata.org/entity/Q24336487',
    'http://www.wikidata.org/entity/Q24336523',
    'http://www.wikidata.org/entity/Q24336639',
    'http://www.wikidata.org/entity/Q24336707',
    'http://www.wikidata.org/entity/Q24336715',
    'http://www.wikidata.org/entity/Q24336747',
    'http://www.wikidata.org/entity/Q24336822',
    'http://www.wikidata.org/entity/Q24336832',
    'http://www.wikidata.org/entity/Q24336898',
    'http://www.wikidata.org/entity/Q24336912',
    'http://www.wikidata.org/entity/Q24337040',
    'http://www.wikidata.org/entity/Q24337084',
    'http://www.wikidata.org/entity/Q24337108',
    'http://www.wikidata.org/entity/Q24337114',
    'http://www.wikidata.org/entity/Q24337128',
    'http://www.wikidata.org/entity/Q24337152',
    'http://www.wikidata.org/entity/Q24337155',
    'http://www.wikidata.org/entity/Q24337195',
    'http://www.wikidata.org/entity/Q24337208',
    'http://www.wikidata.org/entity/Q24337209',
    'http://www.wikidata.org/entity/Q24337225',
    'http://www.wikidata.org/entity/Q24337331',
    'http://www.wikidata.org/entity/Q24337471',
    'http://www.wikidata.org/entity/Q24337474',
    'http://www.wikidata.org/entity/Q24337476',
    'http://www.wikidata.org/entity/Q24337494',
    'http://www.wikidata.org/entity/Q24337586',
    'http://www.wikidata.org/entity/Q24337605',
    'http://www.wikidata.org/entity/Q24337622',
    'http://www.wikidata.org/entity/Q24337626',
    'http://www.wikidata.org/entity/Q24337655',
    'http://www.wikidata.org/entity/Q24337703',
    'http://www.wikidata.org/entity/Q24337727',
    'http://www.wikidata.org/entity/Q24337742',
    'http://www.wikidata.org/entity/Q24337838',
    'http://www.wikidata.org/entity/Q24337851',
    'http://www.wikidata.org/entity/Q24337906',
    'http://www.wikidata.org/entity/Q24337930',
    'http://www.wikidata.org/entity/Q24338113',
    'http://www.wikidata.org/entity/Q24338119',
    'http://www.wikidata.org/entity/Q24338124',
    'http://www.wikidata.org/entity/Q24338129',
    'http://www.wikidata.org/entity/Q24338135',
    'http://www.wikidata.org/entity/Q24338169',
    'http://www.wikidata.org/entity/Q24338311',
    'http://www.wikidata.org/entity/Q24338327',
    'http://www.wikidata.org/entity/Q24338329',
    'http://www.wikidata.org/entity/Q24338339',
    'http://www.wikidata.org/entity/Q24338441',
    'http://www.wikidata.org/entity/Q24338482',
    'http://www.wikidata.org/entity/Q24338488',
    'http://www.wikidata.org/entity/Q24338558',
    'http://www.wikidata.org/entity/Q24338592',
    'http://www.wikidata.org/entity/Q24338599',
    'http://www.wikidata.org/entity/Q24338605',
    'http://www.wikidata.org/entity/Q24338607',
    'http://www.wikidata.org/entity/Q24338639',
    'http://www.wikidata.org/entity/Q24338647',
    'http://www.wikidata.org/entity/Q24338681',
    'http://www.wikidata.org/entity/Q24338767',
    'http://www.wikidata.org/entity/Q24338845',
    'http://www.wikidata.org/entity/Q24338876',
    'http://www.wikidata.org/entity/Q24338884',
    'http://www.wikidata.org/entity/Q24338972',
    'http://www.wikidata.org/entity/Q24339224',
    'http://www.wikidata.org/entity/Q24339405',
    'http://www.wikidata.org/entity/Q24339409',
    'http://www.wikidata.org/entity/Q24339477',
    'http://www.wikidata.org/entity/Q24339489',
    'http://www.wikidata.org/entity/Q24339508',
    'http://www.wikidata.org/entity/Q24339570',
    'http://www.wikidata.org/entity/Q24339606',
    'http://www.wikidata.org/entity/Q24367663',
    'http://www.wikidata.org/entity/Q24369689',
    'http://www.wikidata.org/entity/Q24456430',
    'http://www.wikidata.org/entity/Q24456431',
    'http://www.wikidata.org/entity/Q24465922',
    'http://www.wikidata.org/entity/Q24465930',
    'http://www.wikidata.org/entity/Q24471099',
    'http://www.wikidata.org/entity/Q24489818',
    'http://www.wikidata.org/entity/Q24490632',
    'http://www.wikidata.org/entity/Q24498082',
    'http://www.wikidata.org/entity/Q24498105',
    'http://www.wikidata.org/entity/Q24498142',
    'http://www.wikidata.org/entity/Q24498207',
    'http://www.wikidata.org/entity/Q24498251',
    'http://www.wikidata.org/entity/Q24498349',
    'http://www.wikidata.org/entity/Q24498364',
    'http://www.wikidata.org/entity/Q24498689',
    'http://www.wikidata.org/entity/Q24514532',
    'http://www.wikidata.org/entity/Q24514913',
    'http://www.wikidata.org/entity/Q24515037',
    'http://www.wikidata.org/entity/Q24515041',
    'http://www.wikidata.org/entity/Q24515071',
    'http://www.wikidata.org/entity/Q24515107',
    'http://www.wikidata.org/entity/Q24515297',
    'http://www.wikidata.org/entity/Q24515301',
    'http://www.wikidata.org/entity/Q24515306',
    'http://www.wikidata.org/entity/Q24515358',
    'http://www.wikidata.org/entity/Q24515378',
    'http://www.wikidata.org/entity/Q24515682',
    'http://www.wikidata.org/entity/Q24519280',
    'http://www.wikidata.org/entity/Q24519364',
    'http://www.wikidata.org/entity/Q24520245',
    'http://www.wikidata.org/entity/Q24520510',
    'http://www.wikidata.org/entity/Q24521297',
    'http://www.wikidata.org/entity/Q24521497',
    'http://www.wikidata.org/entity/Q24522329',
    'http://www.wikidata.org/entity/Q24522352',
    'http://www.wikidata.org/entity/Q24522443',
    'http://www.wikidata.org/entity/Q24522454',
    'http://www.wikidata.org/entity/Q24522458',
    'http://www.wikidata.org/entity/Q24522461',
    'http://www.wikidata.org/entity/Q24522462',
    'http://www.wikidata.org/entity/Q24522511',
    'http://www.wikidata.org/entity/Q24522611',
    'http://www.wikidata.org/entity/Q24522696',
    'http://www.wikidata.org/entity/Q24522708',
    'http://www.wikidata.org/entity/Q24522711',
    'http://www.wikidata.org/entity/Q24522744',
    'http://www.wikidata.org/entity/Q24522751',
    'http://www.wikidata.org/entity/Q24522941',
    'http://www.wikidata.org/entity/Q24523182',
    'http://www.wikidata.org/entity/Q24523292',
    'http://www.wikidata.org/entity/Q24523336',
    'http://www.wikidata.org/entity/Q24523548',
    'http://www.wikidata.org/entity/Q24523640',
    'http://www.wikidata.org/entity/Q24523761',
    'http://www.wikidata.org/entity/Q24523893',
    'http://www.wikidata.org/entity/Q24523933',
    'http://www.wikidata.org/entity/Q24523983',
    'http://www.wikidata.org/entity/Q24524119',
    'http://www.wikidata.org/entity/Q24524128',
    'http://www.wikidata.org/entity/Q24524209',
    'http://www.wikidata.org/entity/Q24524329',
    'http://www.wikidata.org/entity/Q24524809',
    'http://www.wikidata.org/entity/Q24524896',
    'http://www.wikidata.org/entity/Q24527325',
    'http://www.wikidata.org/entity/Q24527330',
    'http://www.wikidata.org/entity/Q24527684',
    'http://www.wikidata.org/entity/Q24528139',
    'http://www.wikidata.org/entity/Q24528253',
    'http://www.wikidata.org/entity/Q24528695',
    'http://www.wikidata.org/entity/Q24529125',
    'http://www.wikidata.org/entity/Q24529143',
    'http://www.wikidata.org/entity/Q24529165',
    'http://www.wikidata.org/entity/Q24529306',
    'http://www.wikidata.org/entity/Q24529823',
    'http://www.wikidata.org/entity/Q24529865',
    'http://www.wikidata.org/entity/Q24529878',
    'http://www.wikidata.org/entity/Q24529898',
    'http://www.wikidata.org/entity/Q24529909',
    'http://www.wikidata.org/entity/Q24529938',
    'http://www.wikidata.org/entity/Q24530006',
    'http://www.wikidata.org/entity/Q24530012',
    'http://www.wikidata.org/entity/Q24530052',
    'http://www.wikidata.org/entity/Q24530086',
    'http://www.wikidata.org/entity/Q24530131',
    'http://www.wikidata.org/entity/Q24530153',
    'http://www.wikidata.org/entity/Q24530173',
    'http://www.wikidata.org/entity/Q24530218',
    'http://www.wikidata.org/entity/Q24530264',
    'http://www.wikidata.org/entity/Q24530279',
    'http://www.wikidata.org/entity/Q24530286',
    'http://www.wikidata.org/entity/Q24530376',
    'http://www.wikidata.org/entity/Q24530412',
    'http://www.wikidata.org/entity/Q24530447',
    'http://www.wikidata.org/entity/Q24530456',
    'http://www.wikidata.org/entity/Q24530535',
    'http://www.wikidata.org/entity/Q24530553',
    'http://www.wikidata.org/entity/Q24530558',
    'http://www.wikidata.org/entity/Q24530571',
    'http://www.wikidata.org/entity/Q24530578',
    'http://www.wikidata.org/entity/Q24530580',
    'http://www.wikidata.org/entity/Q24530652',
    'http://www.wikidata.org/entity/Q24530690',
    'http://www.wikidata.org/entity/Q24530695',
    'http://www.wikidata.org/entity/Q24530820',
    'http://www.wikidata.org/entity/Q24531005',
    'http://www.wikidata.org/entity/Q24531184',
    'http://www.wikidata.org/entity/Q24531285',
    'http://www.wikidata.org/entity/Q24531346',
    'http://www.wikidata.org/entity/Q24531393',
    'http://www.wikidata.org/entity/Q24531454',
    'http://www.wikidata.org/entity/Q24531469',
    'http://www.wikidata.org/entity/Q24531503',
    'http://www.wikidata.org/entity/Q24531514',
    'http://www.wikidata.org/entity/Q24531519',
    'http://www.wikidata.org/entity/Q24531622',
    'http://www.wikidata.org/entity/Q24531633',
    'http://www.wikidata.org/entity/Q24531755',
    'http://www.wikidata.org/entity/Q24531822',
    'http://www.wikidata.org/entity/Q24531840',
    'http://www.wikidata.org/entity/Q24531941',
    'http://www.wikidata.org/entity/Q24531972',
    'http://www.wikidata.org/entity/Q24531993',
    'http://www.wikidata.org/entity/Q24531994',
    'http://www.wikidata.org/entity/Q24532026',
    'http://www.wikidata.org/entity/Q24532042',
    'http://www.wikidata.org/entity/Q24532048',
    'http://www.wikidata.org/entity/Q24532049',
    'http://www.wikidata.org/entity/Q24532072',
    'http://www.wikidata.org/entity/Q24532105',
    'http://www.wikidata.org/entity/Q24532168',
    'http://www.wikidata.org/entity/Q24532207',
    'http://www.wikidata.org/entity/Q24532227',
    'http://www.wikidata.org/entity/Q24532247',
    'http://www.wikidata.org/entity/Q24532252',
    'http://www.wikidata.org/entity/Q24532278',
    'http://www.wikidata.org/entity/Q24532326',
    'http://www.wikidata.org/entity/Q24532517',
    'http://www.wikidata.org/entity/Q24532567',
    'http://www.wikidata.org/entity/Q24532720',
    'http://www.wikidata.org/entity/Q24532799',
    'http://www.wikidata.org/entity/Q24532809',
    'http://www.wikidata.org/entity/Q24532834',
    'http://www.wikidata.org/entity/Q24532850',
    'http://www.wikidata.org/entity/Q24532851',
    'http://www.wikidata.org/entity/Q24532876',
    'http://www.wikidata.org/entity/Q24532889',
    'http://www.wikidata.org/entity/Q24532901',
    'http://www.wikidata.org/entity/Q24532974',
    'http://www.wikidata.org/entity/Q24533140',
    'http://www.wikidata.org/entity/Q24533190',
    'http://www.wikidata.org/entity/Q24533219',
    'http://www.wikidata.org/entity/Q24533223',
    'http://www.wikidata.org/entity/Q24533236',
    'http://www.wikidata.org/entity/Q24533239',
    'http://www.wikidata.org/entity/Q24533260',
    'http://www.wikidata.org/entity/Q24533270',
    'http://www.wikidata.org/entity/Q24533278',
    'http://www.wikidata.org/entity/Q24533320',
    'http://www.wikidata.org/entity/Q24533323',
    'http://www.wikidata.org/entity/Q24533334',
    'http://www.wikidata.org/entity/Q24533335',
    'http://www.wikidata.org/entity/Q24533346',
    'http://www.wikidata.org/entity/Q24533390',
    'http://www.wikidata.org/entity/Q24533391',
    'http://www.wikidata.org/entity/Q24533408',
    'http://www.wikidata.org/entity/Q24533409',
    'http://www.wikidata.org/entity/Q24533420',
    'http://www.wikidata.org/entity/Q24533429',
    'http://www.wikidata.org/entity/Q24533465',
    'http://www.wikidata.org/entity/Q24533466',
    'http://www.wikidata.org/entity/Q24533495',
    'http://www.wikidata.org/entity/Q24533507',
    'http://www.wikidata.org/entity/Q24533512',
    'http://www.wikidata.org/entity/Q24533519',
    'http://www.wikidata.org/entity/Q24533538',
    'http://www.wikidata.org/entity/Q24533541',
    'http://www.wikidata.org/entity/Q24533551',
    'http://www.wikidata.org/entity/Q24533556',
    'http://www.wikidata.org/entity/Q24533797',
    'http://www.wikidata.org/entity/Q24533828',
    'http://www.wikidata.org/entity/Q24533845',
    'http://www.wikidata.org/entity/Q24533852',
    'http://www.wikidata.org/entity/Q24534016',
    'http://www.wikidata.org/entity/Q24534045',
    'http://www.wikidata.org/entity/Q24534089',
    'http://www.wikidata.org/entity/Q24534099',
    'http://www.wikidata.org/entity/Q24534129',
    'http://www.wikidata.org/entity/Q24534155',
    'http://www.wikidata.org/entity/Q24534193',
    'http://www.wikidata.org/entity/Q24534259',
    'http://www.wikidata.org/entity/Q24534271',
    'http://www.wikidata.org/entity/Q24534284',
    'http://www.wikidata.org/entity/Q24534298',
    'http://www.wikidata.org/entity/Q24534308',
    'http://www.wikidata.org/entity/Q24534321',
    'http://www.wikidata.org/entity/Q24534323',
    'http://www.wikidata.org/entity/Q24534333',
    'http://www.wikidata.org/entity/Q24534359',
    'http://www.wikidata.org/entity/Q24534375',
    'http://www.wikidata.org/entity/Q24534380',
    'http://www.wikidata.org/entity/Q24534395',
    'http://www.wikidata.org/entity/Q24534420',
    'http://www.wikidata.org/entity/Q24534441',
    'http://www.wikidata.org/entity/Q24534497',
    'http://www.wikidata.org/entity/Q24534526',
    'http://www.wikidata.org/entity/Q24534539',
    'http://www.wikidata.org/entity/Q24534652',
    'http://www.wikidata.org/entity/Q24534668',
    'http://www.wikidata.org/entity/Q24534904',
    'http://www.wikidata.org/entity/Q24534926',
    'http://www.wikidata.org/entity/Q24534939',
    'http://www.wikidata.org/entity/Q24534992',
    'http://www.wikidata.org/entity/Q24534999',
    'http://www.wikidata.org/entity/Q24535010',
    'http://www.wikidata.org/entity/Q24535043',
    'http://www.wikidata.org/entity/Q24535510',
    'http://www.wikidata.org/entity/Q24535547',
    'http://www.wikidata.org/entity/Q24535572',
    'http://www.wikidata.org/entity/Q24535587',
    'http://www.wikidata.org/entity/Q24535595',
    'http://www.wikidata.org/entity/Q24535599',
    'http://www.wikidata.org/entity/Q24535657',
    'http://www.wikidata.org/entity/Q24535661',
    'http://www.wikidata.org/entity/Q24535672',
    'http://www.wikidata.org/entity/Q24535690',
    'http://www.wikidata.org/entity/Q24535749',
    'http://www.wikidata.org/entity/Q24535773',
    'http://www.wikidata.org/entity/Q24535780',
    'http://www.wikidata.org/entity/Q24535781',
    'http://www.wikidata.org/entity/Q24535805',
    'http://www.wikidata.org/entity/Q24535835',
    'http://www.wikidata.org/entity/Q24535848',
    'http://www.wikidata.org/entity/Q24535854',
    'http://www.wikidata.org/entity/Q24535861',
    'http://www.wikidata.org/entity/Q24535862',
    'http://www.wikidata.org/entity/Q24535929',
    'http://www.wikidata.org/entity/Q24536024',
    'http://www.wikidata.org/entity/Q24536028',
    'http://www.wikidata.org/entity/Q24536032',
    'http://www.wikidata.org/entity/Q24536055',
    'http://www.wikidata.org/entity/Q24536069',
    'http://www.wikidata.org/entity/Q24536078',
    'http://www.wikidata.org/entity/Q24536097',
    'http://www.wikidata.org/entity/Q24536108',
    'http://www.wikidata.org/entity/Q24536144',
    'http://www.wikidata.org/entity/Q24536164',
    'http://www.wikidata.org/entity/Q24536169',
    'http://www.wikidata.org/entity/Q24536241',
    'http://www.wikidata.org/entity/Q24536329',
    'http://www.wikidata.org/entity/Q24536345',
    'http://www.wikidata.org/entity/Q24536351',
    'http://www.wikidata.org/entity/Q24536377',
    'http://www.wikidata.org/entity/Q24536398',
    'http://www.wikidata.org/entity/Q24536429',
    'http://www.wikidata.org/entity/Q24536474',
    'http://www.wikidata.org/entity/Q24536497',
    'http://www.wikidata.org/entity/Q24536498',
    'http://www.wikidata.org/entity/Q24536543',
    'http://www.wikidata.org/entity/Q24536566',
    'http://www.wikidata.org/entity/Q24536807',
    'http://www.wikidata.org/entity/Q24536837',
    'http://www.wikidata.org/entity/Q24536888',
    'http://www.wikidata.org/entity/Q24537105',
    'http://www.wikidata.org/entity/Q24537142',
    'http://www.wikidata.org/entity/Q24537161',
    'http://www.wikidata.org/entity/Q24537176',
    'http://www.wikidata.org/entity/Q24537183',
    'http://www.wikidata.org/entity/Q24537185',
    'http://www.wikidata.org/entity/Q24537186',
    'http://www.wikidata.org/entity/Q24537205',
    'http://www.wikidata.org/entity/Q24537210',
    'http://www.wikidata.org/entity/Q24537302',
    'http://www.wikidata.org/entity/Q24537307',
    'http://www.wikidata.org/entity/Q24537310',
    'http://www.wikidata.org/entity/Q24537313',
    'http://www.wikidata.org/entity/Q24537316',
    'http://www.wikidata.org/entity/Q24537320',
    'http://www.wikidata.org/entity/Q24537328',
    'http://www.wikidata.org/entity/Q24537363',
    'http://www.wikidata.org/entity/Q24537364',
    'http://www.wikidata.org/entity/Q24537397',
    'http://www.wikidata.org/entity/Q24537436',
    'http://www.wikidata.org/entity/Q24537443',
    'http://www.wikidata.org/entity/Q24537462',
    'http://www.wikidata.org/entity/Q24537488',
    'http://www.wikidata.org/entity/Q24537501',
    'http://www.wikidata.org/entity/Q24537504',
    'http://www.wikidata.org/entity/Q24537513',
    'http://www.wikidata.org/entity/Q24537549',
    'http://www.wikidata.org/entity/Q24537554',
    'http://www.wikidata.org/entity/Q24537565',
    'http://www.wikidata.org/entity/Q24537628',
    'http://www.wikidata.org/entity/Q24537656',
    'http://www.wikidata.org/entity/Q24537657',
    'http://www.wikidata.org/entity/Q24537682',
    'http://www.wikidata.org/entity/Q24537699',
    'http://www.wikidata.org/entity/Q24538147',
    'http://www.wikidata.org/entity/Q24538218',
    'http://www.wikidata.org/entity/Q24538230',
    'http://www.wikidata.org/entity/Q24538300',
    'http://www.wikidata.org/entity/Q24538382',
    'http://www.wikidata.org/entity/Q24538626',
    'http://www.wikidata.org/entity/Q24538628',
    'http://www.wikidata.org/entity/Q24538650',
    'http://www.wikidata.org/entity/Q24538656',
    'http://www.wikidata.org/entity/Q24538674',
    'http://www.wikidata.org/entity/Q24538709',
    'http://www.wikidata.org/entity/Q24538714',
    'http://www.wikidata.org/entity/Q24538734',
    'http://www.wikidata.org/entity/Q24538737',
    'http://www.wikidata.org/entity/Q24538740',
    'http://www.wikidata.org/entity/Q24538783',
    'http://www.wikidata.org/entity/Q24538798',
    'http://www.wikidata.org/entity/Q24538821',
    'http://www.wikidata.org/entity/Q24538824',
    'http://www.wikidata.org/entity/Q24538827',
    'http://www.wikidata.org/entity/Q24538916',
    'http://www.wikidata.org/entity/Q24538964',
    'http://www.wikidata.org/entity/Q24538985',
    'http://www.wikidata.org/entity/Q24538990',
    'http://www.wikidata.org/entity/Q24538996',
    'http://www.wikidata.org/entity/Q24539016',
    'http://www.wikidata.org/entity/Q24539098',
    'http://www.wikidata.org/entity/Q24539118',
    'http://www.wikidata.org/entity/Q24539174',
    'http://www.wikidata.org/entity/Q24539231',
    'http://www.wikidata.org/entity/Q24539335',
    'http://www.wikidata.org/entity/Q24539813',
    'http://www.wikidata.org/entity/Q24539990',
    'http://www.wikidata.org/entity/Q24540025',
    'http://www.wikidata.org/entity/Q24540092',
    'http://www.wikidata.org/entity/Q24540104',
    'http://www.wikidata.org/entity/Q24540135',
    'http://www.wikidata.org/entity/Q24540153',
    'http://www.wikidata.org/entity/Q24540159',
    'http://www.wikidata.org/entity/Q24540176',
    'http://www.wikidata.org/entity/Q24540181',
    'http://www.wikidata.org/entity/Q24540187',
    'http://www.wikidata.org/entity/Q24540192',
    'http://www.wikidata.org/entity/Q24540195',
    'http://www.wikidata.org/entity/Q24540223',
    'http://www.wikidata.org/entity/Q24540233',
    'http://www.wikidata.org/entity/Q24540245',
    'http://www.wikidata.org/entity/Q24540247',
    'http://www.wikidata.org/entity/Q24540256',
    'http://www.wikidata.org/entity/Q24540343',
    'http://www.wikidata.org/entity/Q24540347',
    'http://www.wikidata.org/entity/Q24540367',
    'http://www.wikidata.org/entity/Q24540473',
    'http://www.wikidata.org/entity/Q24541286',
    'http://www.wikidata.org/entity/Q24541289',
    'http://www.wikidata.org/entity/Q24541292',
    'http://www.wikidata.org/entity/Q24541302',
    'http://www.wikidata.org/entity/Q24541418',
    'http://www.wikidata.org/entity/Q24541443',
    'http://www.wikidata.org/entity/Q24541455',
    'http://www.wikidata.org/entity/Q24541464',
    'http://www.wikidata.org/entity/Q24541475',
    'http://www.wikidata.org/entity/Q24541524',
    'http://www.wikidata.org/entity/Q24541564',
    'http://www.wikidata.org/entity/Q24542354',
    'http://www.wikidata.org/entity/Q24542357',
    'http://www.wikidata.org/entity/Q24542385',
    'http://www.wikidata.org/entity/Q24542424',
    'http://www.wikidata.org/entity/Q24542449',
    'http://www.wikidata.org/entity/Q24542507',
    'http://www.wikidata.org/entity/Q24542523',
    'http://www.wikidata.org/entity/Q24542643',
    'http://www.wikidata.org/entity/Q24543188',
    'http://www.wikidata.org/entity/Q24543864',
    'http://www.wikidata.org/entity/Q24543917',
    'http://www.wikidata.org/entity/Q24543967',
    'http://www.wikidata.org/entity/Q24544001',
    'http://www.wikidata.org/entity/Q24544014',
    'http://www.wikidata.org/entity/Q24544092',
    'http://www.wikidata.org/entity/Q24544111',
    'http://www.wikidata.org/entity/Q24544133',
    'http://www.wikidata.org/entity/Q24544206',
    'http://www.wikidata.org/entity/Q24544241',
    'http://www.wikidata.org/entity/Q24544255',
    'http://www.wikidata.org/entity/Q24544260',
    'http://www.wikidata.org/entity/Q24544311',
    'http://www.wikidata.org/entity/Q24544333',
    'http://www.wikidata.org/entity/Q24544392',
    'http://www.wikidata.org/entity/Q24544402',
    'http://www.wikidata.org/entity/Q24544673',
    'http://www.wikidata.org/entity/Q24544727',
    'http://www.wikidata.org/entity/Q24544833',
    'http://www.wikidata.org/entity/Q24544917',
    'http://www.wikidata.org/entity/Q24545170',
    'http://www.wikidata.org/entity/Q24545186',
    'http://www.wikidata.org/entity/Q24545748',
    'http://www.wikidata.org/entity/Q24545809',
    'http://www.wikidata.org/entity/Q24545938',
    'http://www.wikidata.org/entity/Q24546018',
    'http://www.wikidata.org/entity/Q24546024',
    'http://www.wikidata.org/entity/Q24546032',
    'http://www.wikidata.org/entity/Q24546166',
    'http://www.wikidata.org/entity/Q24546204',
    'http://www.wikidata.org/entity/Q24546221',
    'http://www.wikidata.org/entity/Q24546271',
    'http://www.wikidata.org/entity/Q24546288',
    'http://www.wikidata.org/entity/Q24546294',
    'http://www.wikidata.org/entity/Q24546318',
    'http://www.wikidata.org/entity/Q24546361',
    'http://www.wikidata.org/entity/Q24546369',
    'http://www.wikidata.org/entity/Q24547085',
    'http://www.wikidata.org/entity/Q24547389',
    'http://www.wikidata.org/entity/Q24547409',
    'http://www.wikidata.org/entity/Q24547572',
    'http://www.wikidata.org/entity/Q24547899',
    'http://www.wikidata.org/entity/Q24547928',
    'http://www.wikidata.org/entity/Q24548000',
    'http://www.wikidata.org/entity/Q24548002',
    'http://www.wikidata.org/entity/Q24548019',
    'http://www.wikidata.org/entity/Q24548042',
    'http://www.wikidata.org/entity/Q24548110',
    'http://www.wikidata.org/entity/Q24548114',
    'http://www.wikidata.org/entity/Q24548125',
    'http://www.wikidata.org/entity/Q24548189',
    'http://www.wikidata.org/entity/Q24548191',
    'http://www.wikidata.org/entity/Q24548229',
    'http://www.wikidata.org/entity/Q24548297',
    'http://www.wikidata.org/entity/Q24548304',
    'http://www.wikidata.org/entity/Q24548308',
    'http://www.wikidata.org/entity/Q24548312',
    'http://www.wikidata.org/entity/Q24548319',
    'http://www.wikidata.org/entity/Q24548344',
    'http://www.wikidata.org/entity/Q24548362',
    'http://www.wikidata.org/entity/Q24548371',
    'http://www.wikidata.org/entity/Q24548408',
    'http://www.wikidata.org/entity/Q24548452',
    'http://www.wikidata.org/entity/Q24548456',
    'http://www.wikidata.org/entity/Q24548457',
    'http://www.wikidata.org/entity/Q24548472',
    'http://www.wikidata.org/entity/Q24548489',
    'http://www.wikidata.org/entity/Q24548510',
    'http://www.wikidata.org/entity/Q24548521',
    'http://www.wikidata.org/entity/Q24548534',
    'http://www.wikidata.org/entity/Q24548535',
    'http://www.wikidata.org/entity/Q24548557',
    'http://www.wikidata.org/entity/Q24548565',
    'http://www.wikidata.org/entity/Q24548569',
    'http://www.wikidata.org/entity/Q24548575',
    'http://www.wikidata.org/entity/Q24548585',
    'http://www.wikidata.org/entity/Q24548602',
    'http://www.wikidata.org/entity/Q24548611',
    'http://www.wikidata.org/entity/Q24548616',
    'http://www.wikidata.org/entity/Q24548702',
    'http://www.wikidata.org/entity/Q24548730',
    'http://www.wikidata.org/entity/Q24548757',
    'http://www.wikidata.org/entity/Q24548762',
    'http://www.wikidata.org/entity/Q24548867',
    'http://www.wikidata.org/entity/Q24548929',
    'http://www.wikidata.org/entity/Q24548930',
    'http://www.wikidata.org/entity/Q24548960',
    'http://www.wikidata.org/entity/Q24548994',
    'http://www.wikidata.org/entity/Q24549102',
    'http://www.wikidata.org/entity/Q24549617',
    'http://www.wikidata.org/entity/Q24550361',
    'http://www.wikidata.org/entity/Q24550522',
    'http://www.wikidata.org/entity/Q24550591',
    'http://www.wikidata.org/entity/Q24550605',
    'http://www.wikidata.org/entity/Q24550606',
    'http://www.wikidata.org/entity/Q24550611',
    'http://www.wikidata.org/entity/Q24550616',
    'http://www.wikidata.org/entity/Q24550620',
    'http://www.wikidata.org/entity/Q24550626',
    'http://www.wikidata.org/entity/Q24550632',
    'http://www.wikidata.org/entity/Q24550661',
    'http://www.wikidata.org/entity/Q24550668',
    'http://www.wikidata.org/entity/Q24550671',
    'http://www.wikidata.org/entity/Q24550672',
    'http://www.wikidata.org/entity/Q24550675',
    'http://www.wikidata.org/entity/Q24550676',
    'http://www.wikidata.org/entity/Q24550684',
    'http://www.wikidata.org/entity/Q24550687',
    'http://www.wikidata.org/entity/Q24550689',
    'http://www.wikidata.org/entity/Q24550713',
    'http://www.wikidata.org/entity/Q24550729',
    'http://www.wikidata.org/entity/Q24550730',
    'http://www.wikidata.org/entity/Q24550738',
    'http://www.wikidata.org/entity/Q24550739',
    'http://www.wikidata.org/entity/Q24550740',
    'http://www.wikidata.org/entity/Q24550748',
    'http://www.wikidata.org/entity/Q24550756',
    'http://www.wikidata.org/entity/Q24550776',
    'http://www.wikidata.org/entity/Q24550824',
    'http://www.wikidata.org/entity/Q24550952',
    'http://www.wikidata.org/entity/Q24550956',
    'http://www.wikidata.org/entity/Q24551018',
    'http://www.wikidata.org/entity/Q24551036',
    'http://www.wikidata.org/entity/Q24551041',
    'http://www.wikidata.org/entity/Q24551158',
    'http://www.wikidata.org/entity/Q24551181',
    'http://www.wikidata.org/entity/Q24551250',
    'http://www.wikidata.org/entity/Q24551335',
    'http://www.wikidata.org/entity/Q24551516',
    'http://www.wikidata.org/entity/Q24552910',
    'http://www.wikidata.org/entity/Q24553188',
    'http://www.wikidata.org/entity/Q24553315',
    'http://www.wikidata.org/entity/Q24553334',
    'http://www.wikidata.org/entity/Q24553347',
    'http://www.wikidata.org/entity/Q24553624',
    'http://www.wikidata.org/entity/Q24554008',
    'http://www.wikidata.org/entity/Q24554204',
    'http://www.wikidata.org/entity/Q24554227',
    'http://www.wikidata.org/entity/Q24554231',
    'http://www.wikidata.org/entity/Q24554266',
    'http://www.wikidata.org/entity/Q24554302',
    'http://www.wikidata.org/entity/Q24554359',
    'http://www.wikidata.org/entity/Q24554361',
    'http://www.wikidata.org/entity/Q24554423',
    'http://www.wikidata.org/entity/Q24554428',
    'http://www.wikidata.org/entity/Q24554481',
    'http://www.wikidata.org/entity/Q24554513',
    'http://www.wikidata.org/entity/Q24555050',
    'http://www.wikidata.org/entity/Q24555065',
    'http://www.wikidata.org/entity/Q24555072',
    'http://www.wikidata.org/entity/Q24555112',
    'http://www.wikidata.org/entity/Q24555133',
    'http://www.wikidata.org/entity/Q24555146',
    'http://www.wikidata.org/entity/Q24555224',
    'http://www.wikidata.org/entity/Q24555225',
    'http://www.wikidata.org/entity/Q24555229',
    'http://www.wikidata.org/entity/Q24555478',
    'http://www.wikidata.org/entity/Q24555655',
    'http://www.wikidata.org/entity/Q24555679',
    'http://www.wikidata.org/entity/Q24555706',
    'http://www.wikidata.org/entity/Q24555724',
    'http://www.wikidata.org/entity/Q24555737',
    'http://www.wikidata.org/entity/Q24555755',
    'http://www.wikidata.org/entity/Q24555773',
    'http://www.wikidata.org/entity/Q24555807',
    'http://www.wikidata.org/entity/Q24555861',
    'http://www.wikidata.org/entity/Q24556499',
    'http://www.wikidata.org/entity/Q24556501',
    'http://www.wikidata.org/entity/Q24556514',
    'http://www.wikidata.org/entity/Q24556523',
    'http://www.wikidata.org/entity/Q24556571',
    'http://www.wikidata.org/entity/Q24556626',
    'http://www.wikidata.org/entity/Q24556645',
    'http://www.wikidata.org/entity/Q24556673',
    'http://www.wikidata.org/entity/Q24556676',
    'http://www.wikidata.org/entity/Q24556678',
    'http://www.wikidata.org/entity/Q24556683',
    'http://www.wikidata.org/entity/Q24556686',
    'http://www.wikidata.org/entity/Q24556763',
    'http://www.wikidata.org/entity/Q24557418',
    'http://www.wikidata.org/entity/Q24557438',
    'http://www.wikidata.org/entity/Q24557506',
    'http://www.wikidata.org/entity/Q24557518',
    'http://www.wikidata.org/entity/Q24557547',
    'http://www.wikidata.org/entity/Q24557562',
    'http://www.wikidata.org/entity/Q24558202',
    'http://www.wikidata.org/entity/Q24558576',
    'http://www.wikidata.org/entity/Q24558580',
    'http://www.wikidata.org/entity/Q24558582',
    'http://www.wikidata.org/entity/Q24558589',
    'http://www.wikidata.org/entity/Q24558592',
    'http://www.wikidata.org/entity/Q24558597',
    'http://www.wikidata.org/entity/Q24558606',
    'http://www.wikidata.org/entity/Q24558689',
    'http://www.wikidata.org/entity/Q24558698',
    'http://www.wikidata.org/entity/Q24558699',
    'http://www.wikidata.org/entity/Q24558736',
    'http://www.wikidata.org/entity/Q24558745',
    'http://www.wikidata.org/entity/Q24558751',
    'http://www.wikidata.org/entity/Q24558763',
    'http://www.wikidata.org/entity/Q24558779',
    'http://www.wikidata.org/entity/Q24558831',
    'http://www.wikidata.org/entity/Q24559264',
    'http://www.wikidata.org/entity/Q24559314',
    'http://www.wikidata.org/entity/Q24559347',
    'http://www.wikidata.org/entity/Q24559743',
    'http://www.wikidata.org/entity/Q24559953',
    'http://www.wikidata.org/entity/Q24559973',
    'http://www.wikidata.org/entity/Q24559990',
    'http://www.wikidata.org/entity/Q24560006',
    'http://www.wikidata.org/entity/Q24560010',
    'http://www.wikidata.org/entity/Q24560014',
    'http://www.wikidata.org/entity/Q24560015',
    'http://www.wikidata.org/entity/Q24560016',
    'http://www.wikidata.org/entity/Q24561461',
    'http://www.wikidata.org/entity/Q24561479',
    'http://www.wikidata.org/entity/Q24561516',
    'http://www.wikidata.org/entity/Q24561539',
    'http://www.wikidata.org/entity/Q24561604',
    'http://www.wikidata.org/entity/Q24561636',
    'http://www.wikidata.org/entity/Q24561666',
    'http://www.wikidata.org/entity/Q24561679',
    'http://www.wikidata.org/entity/Q24561689',
    'http://www.wikidata.org/entity/Q24561734',
    'http://www.wikidata.org/entity/Q24561773',
    'http://www.wikidata.org/entity/Q24561799',
    'http://www.wikidata.org/entity/Q24561804',
    'http://www.wikidata.org/entity/Q24561819',
    'http://www.wikidata.org/entity/Q24561833',
    'http://www.wikidata.org/entity/Q24561842',
    'http://www.wikidata.org/entity/Q24561866',
    'http://www.wikidata.org/entity/Q24561874',
    'http://www.wikidata.org/entity/Q24561882',
    'http://www.wikidata.org/entity/Q24561905',
    'http://www.wikidata.org/entity/Q24561910',
    'http://www.wikidata.org/entity/Q24561917',
    'http://www.wikidata.org/entity/Q24561920',
    'http://www.wikidata.org/entity/Q24561953',
    'http://www.wikidata.org/entity/Q24561987',
    'http://www.wikidata.org/entity/Q24562032',
    'http://www.wikidata.org/entity/Q24562044',
    'http://www.wikidata.org/entity/Q24562049',
    'http://www.wikidata.org/entity/Q24562065',
    'http://www.wikidata.org/entity/Q24562083',
    'http://www.wikidata.org/entity/Q24562106',
    'http://www.wikidata.org/entity/Q24562157',
    'http://www.wikidata.org/entity/Q24562214',
    'http://www.wikidata.org/entity/Q24562298',
    'http://www.wikidata.org/entity/Q24562398',
    'http://www.wikidata.org/entity/Q24562400',
    'http://www.wikidata.org/entity/Q24562409',
    'http://www.wikidata.org/entity/Q24562444',
    'http://www.wikidata.org/entity/Q24562489',
    'http://www.wikidata.org/entity/Q24562562',
    'http://www.wikidata.org/entity/Q24562644',
    'http://www.wikidata.org/entity/Q24562649',
    'http://www.wikidata.org/entity/Q24562666',
    'http://www.wikidata.org/entity/Q24562713',
    'http://www.wikidata.org/entity/Q24562729',
    'http://www.wikidata.org/entity/Q24562755',
    'http://www.wikidata.org/entity/Q24562761',
    'http://www.wikidata.org/entity/Q24562763',
    'http://www.wikidata.org/entity/Q24562822',
    'http://www.wikidata.org/entity/Q24562846',
    'http://www.wikidata.org/entity/Q24562866',
    'http://www.wikidata.org/entity/Q24562877',
    'http://www.wikidata.org/entity/Q24562896',
    'http://www.wikidata.org/entity/Q24563014',
    'http://www.wikidata.org/entity/Q24563021',
    'http://www.wikidata.org/entity/Q24563024',
    'http://www.wikidata.org/entity/Q24563025',
    'http://www.wikidata.org/entity/Q24563026',
    'http://www.wikidata.org/entity/Q24563029',
    'http://www.wikidata.org/entity/Q24563043',
    'http://www.wikidata.org/entity/Q24563083',
    'http://www.wikidata.org/entity/Q24563151',
    'http://www.wikidata.org/entity/Q24563174',
    'http://www.wikidata.org/entity/Q24563197',
    'http://www.wikidata.org/entity/Q24563205',
    'http://www.wikidata.org/entity/Q24563212',
    'http://www.wikidata.org/entity/Q24563220',
    'http://www.wikidata.org/entity/Q24563235',
    'http://www.wikidata.org/entity/Q24563287',
    'http://www.wikidata.org/entity/Q24563299',
    'http://www.wikidata.org/entity/Q24563309',
    'http://www.wikidata.org/entity/Q24563341',
    'http://www.wikidata.org/entity/Q24563351',
    'http://www.wikidata.org/entity/Q24563363',
    'http://www.wikidata.org/entity/Q24563371',
    'http://www.wikidata.org/entity/Q24563394',
    'http://www.wikidata.org/entity/Q24563395',
    'http://www.wikidata.org/entity/Q24563397',
    'http://www.wikidata.org/entity/Q24563398',
    'http://www.wikidata.org/entity/Q24563436',
    'http://www.wikidata.org/entity/Q24563474',
    'http://www.wikidata.org/entity/Q24563490',
    'http://www.wikidata.org/entity/Q24563505',
    'http://www.wikidata.org/entity/Q24563539',
    'http://www.wikidata.org/entity/Q24563612',
    'http://www.wikidata.org/entity/Q24563620',
    'http://www.wikidata.org/entity/Q24563654',
    'http://www.wikidata.org/entity/Q24563732',
    'http://www.wikidata.org/entity/Q24563771',
    'http://www.wikidata.org/entity/Q24563807',
    'http://www.wikidata.org/entity/Q24563885',
    'http://www.wikidata.org/entity/Q24563904',
    'http://www.wikidata.org/entity/Q24563907',
    'http://www.wikidata.org/entity/Q24563914',
    'http://www.wikidata.org/entity/Q24563957',
    'http://www.wikidata.org/entity/Q24564008',
    'http://www.wikidata.org/entity/Q24564014',
    'http://www.wikidata.org/entity/Q24564033',
    'http://www.wikidata.org/entity/Q24564100',
    'http://www.wikidata.org/entity/Q24564120',
    'http://www.wikidata.org/entity/Q24564127',
    'http://www.wikidata.org/entity/Q24564147',
    'http://www.wikidata.org/entity/Q24564154',
    'http://www.wikidata.org/entity/Q24564159',
    'http://www.wikidata.org/entity/Q24564166',
    'http://www.wikidata.org/entity/Q24564168',
    'http://www.wikidata.org/entity/Q24564256',
    'http://www.wikidata.org/entity/Q24564269',
    'http://www.wikidata.org/entity/Q24564272',
    'http://www.wikidata.org/entity/Q24564294',
    'http://www.wikidata.org/entity/Q24564321',
    'http://www.wikidata.org/entity/Q24564342',
    'http://www.wikidata.org/entity/Q24564360',
    'http://www.wikidata.org/entity/Q24564371',
    'http://www.wikidata.org/entity/Q24564390',
    'http://www.wikidata.org/entity/Q24564402',
    'http://www.wikidata.org/entity/Q24564406',
    'http://www.wikidata.org/entity/Q24564441',
    'http://www.wikidata.org/entity/Q24564458',
    'http://www.wikidata.org/entity/Q24564509',
    'http://www.wikidata.org/entity/Q24564523',
    'http://www.wikidata.org/entity/Q24564534',
    'http://www.wikidata.org/entity/Q24564540',
    'http://www.wikidata.org/entity/Q24564623',
    'http://www.wikidata.org/entity/Q24564656',
    'http://www.wikidata.org/entity/Q24564723',
    'http://www.wikidata.org/entity/Q24564739',
    'http://www.wikidata.org/entity/Q24564747',
    'http://www.wikidata.org/entity/Q24564757',
    'http://www.wikidata.org/entity/Q24564775',
    'http://www.wikidata.org/entity/Q24564779',
    'http://www.wikidata.org/entity/Q24564821',
    'http://www.wikidata.org/entity/Q24564824',
    'http://www.wikidata.org/entity/Q24564834',
    'http://www.wikidata.org/entity/Q24564849',
    'http://www.wikidata.org/entity/Q24564850',
    'http://www.wikidata.org/entity/Q24564855',
    'http://www.wikidata.org/entity/Q24564869',
    'http://www.wikidata.org/entity/Q24564876',
    'http://www.wikidata.org/entity/Q24564912',
    'http://www.wikidata.org/entity/Q24567623',
    'http://www.wikidata.org/entity/Q24567737',
    'http://www.wikidata.org/entity/Q24567743',
    'http://www.wikidata.org/entity/Q24567767',
    'http://www.wikidata.org/entity/Q24567998',
    'http://www.wikidata.org/entity/Q24568002',
    'http://www.wikidata.org/entity/Q24568043',
    'http://www.wikidata.org/entity/Q24568049',
    'http://www.wikidata.org/entity/Q24568101',
    'http://www.wikidata.org/entity/Q24568134',
    'http://www.wikidata.org/entity/Q24568195',
    'http://www.wikidata.org/entity/Q24568204',
    'http://www.wikidata.org/entity/Q24568279',
    'http://www.wikidata.org/entity/Q24568302',
    'http://www.wikidata.org/entity/Q24568332',
    'http://www.wikidata.org/entity/Q24568334',
    'http://www.wikidata.org/entity/Q24568341',
    'http://www.wikidata.org/entity/Q24568384',
    'http://www.wikidata.org/entity/Q24569515',
    'http://www.wikidata.org/entity/Q24569516',
    'http://www.wikidata.org/entity/Q24569526',
    'http://www.wikidata.org/entity/Q24569560',
    'http://www.wikidata.org/entity/Q24569561',
    'http://www.wikidata.org/entity/Q24569609',
    'http://www.wikidata.org/entity/Q24569637',
    'http://www.wikidata.org/entity/Q24569647',
    'http://www.wikidata.org/entity/Q24569653',
    'http://www.wikidata.org/entity/Q24569665',
    'http://www.wikidata.org/entity/Q24569710',
    'http://www.wikidata.org/entity/Q24569770',
    'http://www.wikidata.org/entity/Q24569799',
    'http://www.wikidata.org/entity/Q24569815',
    'http://www.wikidata.org/entity/Q24570051',
    'http://www.wikidata.org/entity/Q24570052',
    'http://www.wikidata.org/entity/Q24570057',
    'http://www.wikidata.org/entity/Q24570061',
    'http://www.wikidata.org/entity/Q24570064',
    'http://www.wikidata.org/entity/Q24570066',
    'http://www.wikidata.org/entity/Q24570115',
    'http://www.wikidata.org/entity/Q24570121',
    'http://www.wikidata.org/entity/Q24570122',
    'http://www.wikidata.org/entity/Q24570126',
    'http://www.wikidata.org/entity/Q24570127',
    'http://www.wikidata.org/entity/Q24570128',
    'http://www.wikidata.org/entity/Q24570129',
    'http://www.wikidata.org/entity/Q24570132',
    'http://www.wikidata.org/entity/Q24570441',
    'http://www.wikidata.org/entity/Q24570529',
    'http://www.wikidata.org/entity/Q24575500',
    'http://www.wikidata.org/entity/Q24575556',
    'http://www.wikidata.org/entity/Q24575990',
    'http://www.wikidata.org/entity/Q24575991',
    'http://www.wikidata.org/entity/Q24594076',
    'http://www.wikidata.org/entity/Q24594315',
    'http://www.wikidata.org/entity/Q24594356',
    'http://www.wikidata.org/entity/Q24594425',
    'http://www.wikidata.org/entity/Q24594522',
    'http://www.wikidata.org/entity/Q24594632',
    'http://www.wikidata.org/entity/Q24594634',
    'http://www.wikidata.org/entity/Q24594730',
    'http://www.wikidata.org/entity/Q24594745',
    'http://www.wikidata.org/entity/Q24594790',
    'http://www.wikidata.org/entity/Q24594803',
    'http://www.wikidata.org/entity/Q24594844',
    'http://www.wikidata.org/entity/Q24594848',
    'http://www.wikidata.org/entity/Q24594899',
    'http://www.wikidata.org/entity/Q24594901',
    'http://www.wikidata.org/entity/Q24594904',
    'http://www.wikidata.org/entity/Q24594920',
    'http://www.wikidata.org/entity/Q24594942',
    'http://www.wikidata.org/entity/Q24595040',
    'http://www.wikidata.org/entity/Q24595073',
    'http://www.wikidata.org/entity/Q24595082',
    'http://www.wikidata.org/entity/Q24595096',
    'http://www.wikidata.org/entity/Q24595121',
    'http://www.wikidata.org/entity/Q24595162',
    'http://www.wikidata.org/entity/Q24595315',
    'http://www.wikidata.org/entity/Q24595376',
    'http://www.wikidata.org/entity/Q24595378',
    'http://www.wikidata.org/entity/Q24595447',
    'http://www.wikidata.org/entity/Q24595511',
    'http://www.wikidata.org/entity/Q24595550',
    'http://www.wikidata.org/entity/Q24595581',
    'http://www.wikidata.org/entity/Q24595592',
    'http://www.wikidata.org/entity/Q24595656',
    'http://www.wikidata.org/entity/Q24595669',
    'http://www.wikidata.org/entity/Q24595691',
    'http://www.wikidata.org/entity/Q24595707',
    'http://www.wikidata.org/entity/Q24595768',
    'http://www.wikidata.org/entity/Q24595802',
    'http://www.wikidata.org/entity/Q24595841',
    'http://www.wikidata.org/entity/Q24595845',
    'http://www.wikidata.org/entity/Q24595900',
    'http://www.wikidata.org/entity/Q24595910',
    'http://www.wikidata.org/entity/Q24595981',
    'http://www.wikidata.org/entity/Q24596016',
    'http://www.wikidata.org/entity/Q24596055',
    'http://www.wikidata.org/entity/Q24596097',
    'http://www.wikidata.org/entity/Q24596169',
    'http://www.wikidata.org/entity/Q24596191',
    'http://www.wikidata.org/entity/Q24596247',
    'http://www.wikidata.org/entity/Q24596270',
    'http://www.wikidata.org/entity/Q24596295',
    'http://www.wikidata.org/entity/Q24596340',
    'http://www.wikidata.org/entity/Q24596439',
    'http://www.wikidata.org/entity/Q24596660',
    'http://www.wikidata.org/entity/Q24596677',
    'http://www.wikidata.org/entity/Q24596679',
    'http://www.wikidata.org/entity/Q24596727',
    'http://www.wikidata.org/entity/Q24596763',
    'http://www.wikidata.org/entity/Q24596804',
    'http://www.wikidata.org/entity/Q24597019',
    'http://www.wikidata.org/entity/Q24597052',
    'http://www.wikidata.org/entity/Q24597089',
    'http://www.wikidata.org/entity/Q24597139',
    'http://www.wikidata.org/entity/Q24597151',
    'http://www.wikidata.org/entity/Q24597152',
    'http://www.wikidata.org/entity/Q24597162',
    'http://www.wikidata.org/entity/Q24597164',
    'http://www.wikidata.org/entity/Q24597228',
    'http://www.wikidata.org/entity/Q24597282',
    'http://www.wikidata.org/entity/Q24597354',
    'http://www.wikidata.org/entity/Q24597370',
    'http://www.wikidata.org/entity/Q24597380',
    'http://www.wikidata.org/entity/Q24597470',
    'http://www.wikidata.org/entity/Q24597491',
    'http://www.wikidata.org/entity/Q24597501',
    'http://www.wikidata.org/entity/Q24597543',
    'http://www.wikidata.org/entity/Q24597718',
    'http://www.wikidata.org/entity/Q24597726',
    'http://www.wikidata.org/entity/Q24597771',
    'http://www.wikidata.org/entity/Q24597783',
    'http://www.wikidata.org/entity/Q24597790',
    'http://www.wikidata.org/entity/Q24597817',
    'http://www.wikidata.org/entity/Q24597886',
    'http://www.wikidata.org/entity/Q24597904',
    'http://www.wikidata.org/entity/Q24597971',
    'http://www.wikidata.org/entity/Q24597989',
    'http://www.wikidata.org/entity/Q24598012',
    'http://www.wikidata.org/entity/Q24598040',
    'http://www.wikidata.org/entity/Q24598068',
    'http://www.wikidata.org/entity/Q24598126',
    'http://www.wikidata.org/entity/Q24598129',
    'http://www.wikidata.org/entity/Q24598142',
    'http://www.wikidata.org/entity/Q24598165',
    'http://www.wikidata.org/entity/Q24598190',
    'http://www.wikidata.org/entity/Q24598357',
    'http://www.wikidata.org/entity/Q24598387',
    'http://www.wikidata.org/entity/Q24598394',
    'http://www.wikidata.org/entity/Q24598423',
    'http://www.wikidata.org/entity/Q24598427',
    'http://www.wikidata.org/entity/Q24598443',
    'http://www.wikidata.org/entity/Q24598580',
    'http://www.wikidata.org/entity/Q24598596',
    'http://www.wikidata.org/entity/Q24598633',
    'http://www.wikidata.org/entity/Q24598642',
    'http://www.wikidata.org/entity/Q24598678',
    'http://www.wikidata.org/entity/Q24598687',
    'http://www.wikidata.org/entity/Q24598690',
    'http://www.wikidata.org/entity/Q24598695',
    'http://www.wikidata.org/entity/Q24598714',
    'http://www.wikidata.org/entity/Q24598765',
    'http://www.wikidata.org/entity/Q24598773',
    'http://www.wikidata.org/entity/Q24598815',
    'http://www.wikidata.org/entity/Q24598826',
    'http://www.wikidata.org/entity/Q24598853',
    'http://www.wikidata.org/entity/Q24598887',
    'http://www.wikidata.org/entity/Q24598917',
    'http://www.wikidata.org/entity/Q24598921',
    'http://www.wikidata.org/entity/Q24598936',
    'http://www.wikidata.org/entity/Q24599020',
    'http://www.wikidata.org/entity/Q24599025',
    'http://www.wikidata.org/entity/Q24599062',
    'http://www.wikidata.org/entity/Q24599080',
    'http://www.wikidata.org/entity/Q24599089',
    'http://www.wikidata.org/entity/Q24599152',
    'http://www.wikidata.org/entity/Q24599153',
    'http://www.wikidata.org/entity/Q24599157',
    'http://www.wikidata.org/entity/Q24599191',
    'http://www.wikidata.org/entity/Q24599205',
    'http://www.wikidata.org/entity/Q24599219',
    'http://www.wikidata.org/entity/Q24599234',
    'http://www.wikidata.org/entity/Q24599284',
    'http://www.wikidata.org/entity/Q24599371',
    'http://www.wikidata.org/entity/Q24599389',
    'http://www.wikidata.org/entity/Q24599420',
    'http://www.wikidata.org/entity/Q24599442',
    'http://www.wikidata.org/entity/Q24599455',
    'http://www.wikidata.org/entity/Q24599466',
    'http://www.wikidata.org/entity/Q24599479',
    'http://www.wikidata.org/entity/Q24599580',
    'http://www.wikidata.org/entity/Q24599676',
    'http://www.wikidata.org/entity/Q24599864',
    'http://www.wikidata.org/entity/Q24599872',
    'http://www.wikidata.org/entity/Q24600002',
    'http://www.wikidata.org/entity/Q24600027',
    'http://www.wikidata.org/entity/Q24600193',
    'http://www.wikidata.org/entity/Q24600195',
    'http://www.wikidata.org/entity/Q24600230',
    'http://www.wikidata.org/entity/Q24600279',
    'http://www.wikidata.org/entity/Q24600318',
    'http://www.wikidata.org/entity/Q24600325',
    'http://www.wikidata.org/entity/Q24600330',
    'http://www.wikidata.org/entity/Q24600350',
    'http://www.wikidata.org/entity/Q24600510',
    'http://www.wikidata.org/entity/Q24600542',
    'http://www.wikidata.org/entity/Q24600582',
    'http://www.wikidata.org/entity/Q24600618',
    'http://www.wikidata.org/entity/Q24600624',
    'http://www.wikidata.org/entity/Q24600644',
    'http://www.wikidata.org/entity/Q24600668',
    'http://www.wikidata.org/entity/Q24600734',
    'http://www.wikidata.org/entity/Q24600763',
    'http://www.wikidata.org/entity/Q24600773',
    'http://www.wikidata.org/entity/Q24600787',
    'http://www.wikidata.org/entity/Q24600803',
    'http://www.wikidata.org/entity/Q24600879',
    'http://www.wikidata.org/entity/Q24600893',
    'http://www.wikidata.org/entity/Q24600925',
    'http://www.wikidata.org/entity/Q24601030',
    'http://www.wikidata.org/entity/Q24601035',
    'http://www.wikidata.org/entity/Q24601099',
    'http://www.wikidata.org/entity/Q24601132',
    'http://www.wikidata.org/entity/Q24601311',
    'http://www.wikidata.org/entity/Q24601338',
    'http://www.wikidata.org/entity/Q24601372',
    'http://www.wikidata.org/entity/Q24601392',
    'http://www.wikidata.org/entity/Q24601406',
    'http://www.wikidata.org/entity/Q24601502',
    'http://www.wikidata.org/entity/Q24601515',
    'http://www.wikidata.org/entity/Q24601536',
    'http://www.wikidata.org/entity/Q24601575',
    'http://www.wikidata.org/entity/Q24601618',
    'http://www.wikidata.org/entity/Q24601772',
    'http://www.wikidata.org/entity/Q24601802',
    'http://www.wikidata.org/entity/Q24601804',
    'http://www.wikidata.org/entity/Q24601951',
    'http://www.wikidata.org/entity/Q24601971',
    'http://www.wikidata.org/entity/Q24602033',
    'http://www.wikidata.org/entity/Q24602058',
    'http://www.wikidata.org/entity/Q24602082',
    'http://www.wikidata.org/entity/Q24602140',
    'http://www.wikidata.org/entity/Q24602153',
    'http://www.wikidata.org/entity/Q24602238',
    'http://www.wikidata.org/entity/Q24602305',
    'http://www.wikidata.org/entity/Q24602353',
    'http://www.wikidata.org/entity/Q24602369',
    'http://www.wikidata.org/entity/Q24602401',
    'http://www.wikidata.org/entity/Q24602445',
    'http://www.wikidata.org/entity/Q24602467',
    'http://www.wikidata.org/entity/Q24602490',
    'http://www.wikidata.org/entity/Q24602498',
    'http://www.wikidata.org/entity/Q24602512',
    'http://www.wikidata.org/entity/Q24602539',
    'http://www.wikidata.org/entity/Q24602642',
    'http://www.wikidata.org/entity/Q24602657',
    'http://www.wikidata.org/entity/Q24602847',
    'http://www.wikidata.org/entity/Q24602936',
    'http://www.wikidata.org/entity/Q24602950',
    'http://www.wikidata.org/entity/Q24603069',
    'http://www.wikidata.org/entity/Q24603071',
    'http://www.wikidata.org/entity/Q24603117',
    'http://www.wikidata.org/entity/Q24603176',
    'http://www.wikidata.org/entity/Q24603195',
    'http://www.wikidata.org/entity/Q24603196',
    'http://www.wikidata.org/entity/Q24603204',
    'http://www.wikidata.org/entity/Q24603211',
    'http://www.wikidata.org/entity/Q24603239',
    'http://www.wikidata.org/entity/Q24603249',
    'http://www.wikidata.org/entity/Q24603319',
    'http://www.wikidata.org/entity/Q24603357',
    'http://www.wikidata.org/entity/Q24603359',
    'http://www.wikidata.org/entity/Q24603373',
    'http://www.wikidata.org/entity/Q24603413',
    'http://www.wikidata.org/entity/Q24603475',
    'http://www.wikidata.org/entity/Q24603491',
    'http://www.wikidata.org/entity/Q24603494',
    'http://www.wikidata.org/entity/Q24603526',
    'http://www.wikidata.org/entity/Q24603529',
    'http://www.wikidata.org/entity/Q24603537',
    'http://www.wikidata.org/entity/Q24603560',
    'http://www.wikidata.org/entity/Q24603590',
    'http://www.wikidata.org/entity/Q24603699',
    'http://www.wikidata.org/entity/Q24603736',
    'http://www.wikidata.org/entity/Q24603793',
    'http://www.wikidata.org/entity/Q24603974',
    'http://www.wikidata.org/entity/Q24603976',
    'http://www.wikidata.org/entity/Q24603986',
    'http://www.wikidata.org/entity/Q24604068',
    'http://www.wikidata.org/entity/Q24604235',
    'http://www.wikidata.org/entity/Q24604308',
    'http://www.wikidata.org/entity/Q24604376',
    'http://www.wikidata.org/entity/Q24604386',
    'http://www.wikidata.org/entity/Q24604389',
    'http://www.wikidata.org/entity/Q24604436',
    'http://www.wikidata.org/entity/Q24604459',
    'http://www.wikidata.org/entity/Q24604466',
    'http://www.wikidata.org/entity/Q24604486',
    'http://www.wikidata.org/entity/Q24604601',
    'http://www.wikidata.org/entity/Q24604615',
    'http://www.wikidata.org/entity/Q24604643',
    'http://www.wikidata.org/entity/Q24604730',
    'http://www.wikidata.org/entity/Q24604760',
    'http://www.wikidata.org/entity/Q24604787',
    'http://www.wikidata.org/entity/Q24604814',
    'http://www.wikidata.org/entity/Q24604856',
    'http://www.wikidata.org/entity/Q24604882',
    'http://www.wikidata.org/entity/Q24604904',
    'http://www.wikidata.org/entity/Q24605087',
    'http://www.wikidata.org/entity/Q24605111',
    'http://www.wikidata.org/entity/Q24605173',
    'http://www.wikidata.org/entity/Q24605199',
    'http://www.wikidata.org/entity/Q24605252',
    'http://www.wikidata.org/entity/Q24605258',
    'http://www.wikidata.org/entity/Q24605342',
    'http://www.wikidata.org/entity/Q24605347',
    'http://www.wikidata.org/entity/Q24605360',
    'http://www.wikidata.org/entity/Q24605371',
    'http://www.wikidata.org/entity/Q24605448',
    'http://www.wikidata.org/entity/Q24605493',
    'http://www.wikidata.org/entity/Q24605530',
    'http://www.wikidata.org/entity/Q24605576',
    'http://www.wikidata.org/entity/Q24605589',
    'http://www.wikidata.org/entity/Q24605675',
    'http://www.wikidata.org/entity/Q24605680',
    'http://www.wikidata.org/entity/Q24605722',
    'http://www.wikidata.org/entity/Q24605727',
    'http://www.wikidata.org/entity/Q24605940',
    'http://www.wikidata.org/entity/Q24605958',
    'http://www.wikidata.org/entity/Q24606006',
    'http://www.wikidata.org/entity/Q24606025',
    'http://www.wikidata.org/entity/Q24606055',
    'http://www.wikidata.org/entity/Q24606097',
    'http://www.wikidata.org/entity/Q24606115',
    'http://www.wikidata.org/entity/Q24606203',
    'http://www.wikidata.org/entity/Q24606211',
    'http://www.wikidata.org/entity/Q24606271',
    'http://www.wikidata.org/entity/Q24606281',
    'http://www.wikidata.org/entity/Q24606320',
    'http://www.wikidata.org/entity/Q24606352',
    'http://www.wikidata.org/entity/Q24606366',
    'http://www.wikidata.org/entity/Q24606462',
    'http://www.wikidata.org/entity/Q24606577',
    'http://www.wikidata.org/entity/Q24606581',
    'http://www.wikidata.org/entity/Q24606586',
    'http://www.wikidata.org/entity/Q24606608',
    'http://www.wikidata.org/entity/Q24606701',
    'http://www.wikidata.org/entity/Q24606718',
    'http://www.wikidata.org/entity/Q24606766',
    'http://www.wikidata.org/entity/Q24606808',
    'http://www.wikidata.org/entity/Q24606873',
    'http://www.wikidata.org/entity/Q24606915',
    'http://www.wikidata.org/entity/Q24606956',
    'http://www.wikidata.org/entity/Q24606980',
    'http://www.wikidata.org/entity/Q24607078',
    'http://www.wikidata.org/entity/Q24607202',
    'http://www.wikidata.org/entity/Q24607229',
    'http://www.wikidata.org/entity/Q24607308',
    'http://www.wikidata.org/entity/Q24607353',
    'http://www.wikidata.org/entity/Q24607361',
    'http://www.wikidata.org/entity/Q24607390',
    'http://www.wikidata.org/entity/Q24607522',
    'http://www.wikidata.org/entity/Q24607545',
    'http://www.wikidata.org/entity/Q24607574',
    'http://www.wikidata.org/entity/Q24607587',
    'http://www.wikidata.org/entity/Q24607621',
    'http://www.wikidata.org/entity/Q24607640',
    'http://www.wikidata.org/entity/Q24607724',
    'http://www.wikidata.org/entity/Q24607742',
    'http://www.wikidata.org/entity/Q24607949',
    'http://www.wikidata.org/entity/Q24607952',
    'http://www.wikidata.org/entity/Q24608005',
    'http://www.wikidata.org/entity/Q24608039',
    'http://www.wikidata.org/entity/Q24608049',
    'http://www.wikidata.org/entity/Q24608159',
    'http://www.wikidata.org/entity/Q24608173',
    'http://www.wikidata.org/entity/Q24608190',
    'http://www.wikidata.org/entity/Q24608197',
    'http://www.wikidata.org/entity/Q24608263',
    'http://www.wikidata.org/entity/Q24608301',
    'http://www.wikidata.org/entity/Q24608343',
    'http://www.wikidata.org/entity/Q24608391',
    'http://www.wikidata.org/entity/Q24608407',
    'http://www.wikidata.org/entity/Q24608468',
    'http://www.wikidata.org/entity/Q24608514',
    'http://www.wikidata.org/entity/Q24608568',
    'http://www.wikidata.org/entity/Q24608592',
    'http://www.wikidata.org/entity/Q24608599',
    'http://www.wikidata.org/entity/Q24608672',
    'http://www.wikidata.org/entity/Q24608743',
    'http://www.wikidata.org/entity/Q24608778',
    'http://www.wikidata.org/entity/Q24608810',
    'http://www.wikidata.org/entity/Q24608829',
    'http://www.wikidata.org/entity/Q24608960',
    'http://www.wikidata.org/entity/Q24608988',
    'http://www.wikidata.org/entity/Q24609173',
    'http://www.wikidata.org/entity/Q24609215',
    'http://www.wikidata.org/entity/Q24609294',
    'http://www.wikidata.org/entity/Q24609324',
    'http://www.wikidata.org/entity/Q24609340',
    'http://www.wikidata.org/entity/Q24609392',
    'http://www.wikidata.org/entity/Q24609401',
    'http://www.wikidata.org/entity/Q24609425',
    'http://www.wikidata.org/entity/Q24609428',
    'http://www.wikidata.org/entity/Q24609513',
    'http://www.wikidata.org/entity/Q24609520',
    'http://www.wikidata.org/entity/Q24609577',
    'http://www.wikidata.org/entity/Q24609584',
    'http://www.wikidata.org/entity/Q24609648',
    'http://www.wikidata.org/entity/Q24609706',
    'http://www.wikidata.org/entity/Q24609722',
    'http://www.wikidata.org/entity/Q24609857',
    'http://www.wikidata.org/entity/Q24609864',
    'http://www.wikidata.org/entity/Q24609907',
    'http://www.wikidata.org/entity/Q24609914',
    'http://www.wikidata.org/entity/Q24609915',
    'http://www.wikidata.org/entity/Q24609980',
    'http://www.wikidata.org/entity/Q24609988',
    'http://www.wikidata.org/entity/Q24610026',
    'http://www.wikidata.org/entity/Q24610255',
    'http://www.wikidata.org/entity/Q24610308',
    'http://www.wikidata.org/entity/Q24610450',
    'http://www.wikidata.org/entity/Q24610466',
    'http://www.wikidata.org/entity/Q24610484',
    'http://www.wikidata.org/entity/Q24610574',
    'http://www.wikidata.org/entity/Q24610576',
    'http://www.wikidata.org/entity/Q24610632',
    'http://www.wikidata.org/entity/Q24610723',
    'http://www.wikidata.org/entity/Q24610731',
    'http://www.wikidata.org/entity/Q24610741',
    'http://www.wikidata.org/entity/Q24610764',
    'http://www.wikidata.org/entity/Q24610828',
    'http://www.wikidata.org/entity/Q24610890',
    'http://www.wikidata.org/entity/Q24611053',
    'http://www.wikidata.org/entity/Q24611198',
    'http://www.wikidata.org/entity/Q24611465',
    'http://www.wikidata.org/entity/Q24611474',
    'http://www.wikidata.org/entity/Q24611517',
    'http://www.wikidata.org/entity/Q24611595',
    'http://www.wikidata.org/entity/Q24611619',
    'http://www.wikidata.org/entity/Q24611806',
    'http://www.wikidata.org/entity/Q24611930',
    'http://www.wikidata.org/entity/Q24612082',
    'http://www.wikidata.org/entity/Q24612084',
    'http://www.wikidata.org/entity/Q24612175',
    'http://www.wikidata.org/entity/Q24612233',
    'http://www.wikidata.org/entity/Q24612235',
    'http://www.wikidata.org/entity/Q24612248',
    'http://www.wikidata.org/entity/Q24612359',
    'http://www.wikidata.org/entity/Q24612411',
    'http://www.wikidata.org/entity/Q24612429',
    'http://www.wikidata.org/entity/Q24612437',
    'http://www.wikidata.org/entity/Q24612505',
    'http://www.wikidata.org/entity/Q24612644',
    'http://www.wikidata.org/entity/Q24612653',
    'http://www.wikidata.org/entity/Q24612662',
    'http://www.wikidata.org/entity/Q24612811',
    'http://www.wikidata.org/entity/Q24612820',
    'http://www.wikidata.org/entity/Q24612868',
    'http://www.wikidata.org/entity/Q24612975',
    'http://www.wikidata.org/entity/Q24612983',
    'http://www.wikidata.org/entity/Q24613026',
    'http://www.wikidata.org/entity/Q24613094',
    'http://www.wikidata.org/entity/Q24613142',
    'http://www.wikidata.org/entity/Q24613221',
    'http://www.wikidata.org/entity/Q24613339',
    'http://www.wikidata.org/entity/Q24613456',
    'http://www.wikidata.org/entity/Q24613481',
    'http://www.wikidata.org/entity/Q24613529',
    'http://www.wikidata.org/entity/Q24613553',
    'http://www.wikidata.org/entity/Q24613579',
    'http://www.wikidata.org/entity/Q24613599',
    'http://www.wikidata.org/entity/Q24613645',
    'http://www.wikidata.org/entity/Q24613755',
    'http://www.wikidata.org/entity/Q24613799',
    'http://www.wikidata.org/entity/Q24613870',
    'http://www.wikidata.org/entity/Q24613881',
    'http://www.wikidata.org/entity/Q24614077',
    'http://www.wikidata.org/entity/Q24614376',
    'http://www.wikidata.org/entity/Q24614431',
    'http://www.wikidata.org/entity/Q24614464',
    'http://www.wikidata.org/entity/Q24614467',
    'http://www.wikidata.org/entity/Q24614511',
    'http://www.wikidata.org/entity/Q24614572',
    'http://www.wikidata.org/entity/Q24614582',
    'http://www.wikidata.org/entity/Q24614583',
    'http://www.wikidata.org/entity/Q24614608',
    'http://www.wikidata.org/entity/Q24614627',
    'http://www.wikidata.org/entity/Q24614644',
    'http://www.wikidata.org/entity/Q24614672',
    'http://www.wikidata.org/entity/Q24614679',
    'http://www.wikidata.org/entity/Q24614699',
    'http://www.wikidata.org/entity/Q24614744',
    'http://www.wikidata.org/entity/Q24614759',
    'http://www.wikidata.org/entity/Q24614810',
    'http://www.wikidata.org/entity/Q24614831',
    'http://www.wikidata.org/entity/Q24614859',
    'http://www.wikidata.org/entity/Q24614960',
    'http://www.wikidata.org/entity/Q24614989',
    'http://www.wikidata.org/entity/Q24614998',
    'http://www.wikidata.org/entity/Q24615080',
    'http://www.wikidata.org/entity/Q24615211',
    'http://www.wikidata.org/entity/Q24615216',
    'http://www.wikidata.org/entity/Q24615271',
    'http://www.wikidata.org/entity/Q24615307',
    'http://www.wikidata.org/entity/Q24615381',
    'http://www.wikidata.org/entity/Q24615397',
    'http://www.wikidata.org/entity/Q24615485',
    'http://www.wikidata.org/entity/Q24615541',
    'http://www.wikidata.org/entity/Q24615562',
    'http://www.wikidata.org/entity/Q24615624',
    'http://www.wikidata.org/entity/Q24615770',
    'http://www.wikidata.org/entity/Q24615914',
    'http://www.wikidata.org/entity/Q24616026',
    'http://www.wikidata.org/entity/Q24616059',
    'http://www.wikidata.org/entity/Q24616077',
    'http://www.wikidata.org/entity/Q24616084',
    'http://www.wikidata.org/entity/Q24616117',
    'http://www.wikidata.org/entity/Q24616175',
    'http://www.wikidata.org/entity/Q24616204',
    'http://www.wikidata.org/entity/Q24616207',
    'http://www.wikidata.org/entity/Q24616209',
    'http://www.wikidata.org/entity/Q24616264',
    'http://www.wikidata.org/entity/Q24616273',
    'http://www.wikidata.org/entity/Q24616298',
    'http://www.wikidata.org/entity/Q24616310',
    'http://www.wikidata.org/entity/Q24616329',
    'http://www.wikidata.org/entity/Q24616471',
    'http://www.wikidata.org/entity/Q24616537',
    'http://www.wikidata.org/entity/Q24616649',
    'http://www.wikidata.org/entity/Q24616650',
    'http://www.wikidata.org/entity/Q24616711',
    'http://www.wikidata.org/entity/Q24616749',
    'http://www.wikidata.org/entity/Q24616798',
    'http://www.wikidata.org/entity/Q24616826',
    'http://www.wikidata.org/entity/Q24616827',
    'http://www.wikidata.org/entity/Q24616873',
    'http://www.wikidata.org/entity/Q24616875',
    'http://www.wikidata.org/entity/Q24616897',
    'http://www.wikidata.org/entity/Q24616921',
    'http://www.wikidata.org/entity/Q24617063',
    'http://www.wikidata.org/entity/Q24617064',
    'http://www.wikidata.org/entity/Q24617121',
    'http://www.wikidata.org/entity/Q24617130',
    'http://www.wikidata.org/entity/Q24617191',
    'http://www.wikidata.org/entity/Q24617317',
    'http://www.wikidata.org/entity/Q24617322',
    'http://www.wikidata.org/entity/Q24617331',
    'http://www.wikidata.org/entity/Q24617394',
    'http://www.wikidata.org/entity/Q24617406',
    'http://www.wikidata.org/entity/Q24617494',
    'http://www.wikidata.org/entity/Q24617520',
    'http://www.wikidata.org/entity/Q24617537',
    'http://www.wikidata.org/entity/Q24617547',
    'http://www.wikidata.org/entity/Q24617663',
    'http://www.wikidata.org/entity/Q24617743',
    'http://www.wikidata.org/entity/Q24617794',
    'http://www.wikidata.org/entity/Q24617800',
    'http://www.wikidata.org/entity/Q24617818',
    'http://www.wikidata.org/entity/Q24617969',
    'http://www.wikidata.org/entity/Q24618003',
    'http://www.wikidata.org/entity/Q24618089',
    'http://www.wikidata.org/entity/Q24618185',
    'http://www.wikidata.org/entity/Q24618242',
    'http://www.wikidata.org/entity/Q24618334',
    'http://www.wikidata.org/entity/Q24618405',
    'http://www.wikidata.org/entity/Q24618592',
    'http://www.wikidata.org/entity/Q24618618',
    'http://www.wikidata.org/entity/Q24618705',
    'http://www.wikidata.org/entity/Q24618823',
    'http://www.wikidata.org/entity/Q24618931',
    'http://www.wikidata.org/entity/Q24618997',
    'http://www.wikidata.org/entity/Q24619049',
    'http://www.wikidata.org/entity/Q24619130',
    'http://www.wikidata.org/entity/Q24619146',
    'http://www.wikidata.org/entity/Q24619199',
    'http://www.wikidata.org/entity/Q24619275',
    'http://www.wikidata.org/entity/Q24619298',
    'http://www.wikidata.org/entity/Q24619346',
    'http://www.wikidata.org/entity/Q24619410',
    'http://www.wikidata.org/entity/Q24619485',
    'http://www.wikidata.org/entity/Q24619549',
    'http://www.wikidata.org/entity/Q24619630',
    'http://www.wikidata.org/entity/Q24619697',
    'http://www.wikidata.org/entity/Q24619698',
    'http://www.wikidata.org/entity/Q24619716',
    'http://www.wikidata.org/entity/Q24619737',
    'http://www.wikidata.org/entity/Q24619841',
    'http://www.wikidata.org/entity/Q24619875',
    'http://www.wikidata.org/entity/Q24619907',
    'http://www.wikidata.org/entity/Q24619932',
    'http://www.wikidata.org/entity/Q24619974',
    'http://www.wikidata.org/entity/Q24620090',
    'http://www.wikidata.org/entity/Q24620096',
    'http://www.wikidata.org/entity/Q24620144',
    'http://www.wikidata.org/entity/Q24620160',
    'http://www.wikidata.org/entity/Q24620284',
    'http://www.wikidata.org/entity/Q24620291',
    'http://www.wikidata.org/entity/Q24620297',
    'http://www.wikidata.org/entity/Q24620363',
    'http://www.wikidata.org/entity/Q24620437',
    'http://www.wikidata.org/entity/Q24620449',
    'http://www.wikidata.org/entity/Q24620453',
    'http://www.wikidata.org/entity/Q24620517',
    'http://www.wikidata.org/entity/Q24620573',
    'http://www.wikidata.org/entity/Q24620576',
    'http://www.wikidata.org/entity/Q24620604',
    'http://www.wikidata.org/entity/Q24620628',
    'http://www.wikidata.org/entity/Q24620671',
    'http://www.wikidata.org/entity/Q24620683',
    'http://www.wikidata.org/entity/Q24620686',
    'http://www.wikidata.org/entity/Q24620753',
    'http://www.wikidata.org/entity/Q24620766',
    'http://www.wikidata.org/entity/Q24620887',
    'http://www.wikidata.org/entity/Q24620909',
    'http://www.wikidata.org/entity/Q24620915',
    'http://www.wikidata.org/entity/Q24620970',
    'http://www.wikidata.org/entity/Q24620975',
    'http://www.wikidata.org/entity/Q24621004',
    'http://www.wikidata.org/entity/Q24621218',
    'http://www.wikidata.org/entity/Q24621388',
    'http://www.wikidata.org/entity/Q24621392',
    'http://www.wikidata.org/entity/Q24621431',
    'http://www.wikidata.org/entity/Q24621500',
    'http://www.wikidata.org/entity/Q24621515',
    'http://www.wikidata.org/entity/Q24621611',
    'http://www.wikidata.org/entity/Q24621641',
    'http://www.wikidata.org/entity/Q24621715',
    'http://www.wikidata.org/entity/Q24621753',
    'http://www.wikidata.org/entity/Q24621776',
    'http://www.wikidata.org/entity/Q24621854',
    'http://www.wikidata.org/entity/Q24621907',
    'http://www.wikidata.org/entity/Q24621930',
    'http://www.wikidata.org/entity/Q24621983',
    'http://www.wikidata.org/entity/Q24622048',
    'http://www.wikidata.org/entity/Q24622076',
    'http://www.wikidata.org/entity/Q24622101',
    'http://www.wikidata.org/entity/Q24622141',
    'http://www.wikidata.org/entity/Q24622333',
    'http://www.wikidata.org/entity/Q24622424',
    'http://www.wikidata.org/entity/Q24622470',
    'http://www.wikidata.org/entity/Q24622513',
    'http://www.wikidata.org/entity/Q24622539',
    'http://www.wikidata.org/entity/Q24622541',
    'http://www.wikidata.org/entity/Q24622558',
    'http://www.wikidata.org/entity/Q24622583',
    'http://www.wikidata.org/entity/Q24622610',
    'http://www.wikidata.org/entity/Q24622634',
    'http://www.wikidata.org/entity/Q24622676',
    'http://www.wikidata.org/entity/Q24622701',
    'http://www.wikidata.org/entity/Q24622801',
    'http://www.wikidata.org/entity/Q24622857',
    'http://www.wikidata.org/entity/Q24622896',
    'http://www.wikidata.org/entity/Q24623108',
    'http://www.wikidata.org/entity/Q24623113',
    'http://www.wikidata.org/entity/Q24623166',
    'http://www.wikidata.org/entity/Q24623214',
    'http://www.wikidata.org/entity/Q24623215',
    'http://www.wikidata.org/entity/Q24623225',
    'http://www.wikidata.org/entity/Q24623245',
    'http://www.wikidata.org/entity/Q24623433',
    'http://www.wikidata.org/entity/Q24623437',
    'http://www.wikidata.org/entity/Q24623538',
    'http://www.wikidata.org/entity/Q24623563',
    'http://www.wikidata.org/entity/Q24623640',
    'http://www.wikidata.org/entity/Q24623766',
    'http://www.wikidata.org/entity/Q24623931',
    'http://www.wikidata.org/entity/Q24623940',
    'http://www.wikidata.org/entity/Q24624069',
    'http://www.wikidata.org/entity/Q24624239',
    'http://www.wikidata.org/entity/Q24624284',
    'http://www.wikidata.org/entity/Q24624362',
    'http://www.wikidata.org/entity/Q24624497',
    'http://www.wikidata.org/entity/Q24624558',
    'http://www.wikidata.org/entity/Q24624664',
    'http://www.wikidata.org/entity/Q24624698',
    'http://www.wikidata.org/entity/Q24624866',
    'http://www.wikidata.org/entity/Q24624885',
    'http://www.wikidata.org/entity/Q24624906',
    'http://www.wikidata.org/entity/Q24624921',
    'http://www.wikidata.org/entity/Q24625230',
    'http://www.wikidata.org/entity/Q24625342',
    'http://www.wikidata.org/entity/Q24625361',
    'http://www.wikidata.org/entity/Q24625373',
    'http://www.wikidata.org/entity/Q24625416',
    'http://www.wikidata.org/entity/Q24625591',
    'http://www.wikidata.org/entity/Q24625697',
    'http://www.wikidata.org/entity/Q24625794',
    'http://www.wikidata.org/entity/Q24625811',
    'http://www.wikidata.org/entity/Q24625873',
    'http://www.wikidata.org/entity/Q24625879',
    'http://www.wikidata.org/entity/Q24625887',
    'http://www.wikidata.org/entity/Q24625970',
    'http://www.wikidata.org/entity/Q24625992',
    'http://www.wikidata.org/entity/Q24626018',
    'http://www.wikidata.org/entity/Q24626072',
    'http://www.wikidata.org/entity/Q24626076',
    'http://www.wikidata.org/entity/Q24626122',
    'http://www.wikidata.org/entity/Q24626182',
    'http://www.wikidata.org/entity/Q24626229',
    'http://www.wikidata.org/entity/Q24626264',
    'http://www.wikidata.org/entity/Q24626267',
    'http://www.wikidata.org/entity/Q24626352',
    'http://www.wikidata.org/entity/Q24626362',
    'http://www.wikidata.org/entity/Q24626370',
    'http://www.wikidata.org/entity/Q24626418',
    'http://www.wikidata.org/entity/Q24626446',
    'http://www.wikidata.org/entity/Q24626464',
    'http://www.wikidata.org/entity/Q24626579',
    'http://www.wikidata.org/entity/Q24627041',
    'http://www.wikidata.org/entity/Q24627067',
    'http://www.wikidata.org/entity/Q24627074',
    'http://www.wikidata.org/entity/Q24627187',
    'http://www.wikidata.org/entity/Q24627219',
    'http://www.wikidata.org/entity/Q24627354',
    'http://www.wikidata.org/entity/Q24627393',
    'http://www.wikidata.org/entity/Q24627396',
    'http://www.wikidata.org/entity/Q24627398',
    'http://www.wikidata.org/entity/Q24627425',
    'http://www.wikidata.org/entity/Q24627483',
    'http://www.wikidata.org/entity/Q24627506',
    'http://www.wikidata.org/entity/Q24627618',
    'http://www.wikidata.org/entity/Q24627620',
    'http://www.wikidata.org/entity/Q24627696',
    'http://www.wikidata.org/entity/Q24627863',
    'http://www.wikidata.org/entity/Q24627935',
    'http://www.wikidata.org/entity/Q24628050',
    'http://www.wikidata.org/entity/Q24628057',
    'http://www.wikidata.org/entity/Q24628062',
    'http://www.wikidata.org/entity/Q24628159',
    'http://www.wikidata.org/entity/Q24628207',
    'http://www.wikidata.org/entity/Q24628401',
    'http://www.wikidata.org/entity/Q24628532',
    'http://www.wikidata.org/entity/Q24628579',
    'http://www.wikidata.org/entity/Q24628685',
    'http://www.wikidata.org/entity/Q24628686',
    'http://www.wikidata.org/entity/Q24628710',
    'http://www.wikidata.org/entity/Q24628728',
    'http://www.wikidata.org/entity/Q24628739',
    'http://www.wikidata.org/entity/Q24628758',
    'http://www.wikidata.org/entity/Q24628768',
    'http://www.wikidata.org/entity/Q24628783',
    'http://www.wikidata.org/entity/Q24628796',
    'http://www.wikidata.org/entity/Q24628821',
    'http://www.wikidata.org/entity/Q24628836',
    'http://www.wikidata.org/entity/Q24628843',
    'http://www.wikidata.org/entity/Q24628845',
    'http://www.wikidata.org/entity/Q24628870',
    'http://www.wikidata.org/entity/Q24628889',
    'http://www.wikidata.org/entity/Q24628913',
    'http://www.wikidata.org/entity/Q24628935',
    'http://www.wikidata.org/entity/Q24628961',
    'http://www.wikidata.org/entity/Q24628969',
    'http://www.wikidata.org/entity/Q24628978',
    'http://www.wikidata.org/entity/Q24628988',
    'http://www.wikidata.org/entity/Q24629019',
    'http://www.wikidata.org/entity/Q24629022',
    'http://www.wikidata.org/entity/Q24629032',
    'http://www.wikidata.org/entity/Q24629035',
    'http://www.wikidata.org/entity/Q24629036',
    'http://www.wikidata.org/entity/Q24629044',
    'http://www.wikidata.org/entity/Q24629045',
    'http://www.wikidata.org/entity/Q24629062',
    'http://www.wikidata.org/entity/Q24629067',
    'http://www.wikidata.org/entity/Q24629070',
    'http://www.wikidata.org/entity/Q24629117',
    'http://www.wikidata.org/entity/Q24629119',
    'http://www.wikidata.org/entity/Q24629130',
    'http://www.wikidata.org/entity/Q24629145',
    'http://www.wikidata.org/entity/Q24629208',
    'http://www.wikidata.org/entity/Q24629255',
    'http://www.wikidata.org/entity/Q24629282',
    'http://www.wikidata.org/entity/Q24629315',
    'http://www.wikidata.org/entity/Q24629323',
    'http://www.wikidata.org/entity/Q24629327',
    'http://www.wikidata.org/entity/Q24629337',
    'http://www.wikidata.org/entity/Q24629338',
    'http://www.wikidata.org/entity/Q24629342',
    'http://www.wikidata.org/entity/Q24629400',
    'http://www.wikidata.org/entity/Q24629431',
    'http://www.wikidata.org/entity/Q24629445',
    'http://www.wikidata.org/entity/Q24629471',
    'http://www.wikidata.org/entity/Q24629474',
    'http://www.wikidata.org/entity/Q24629495',
    'http://www.wikidata.org/entity/Q24629513',
    'http://www.wikidata.org/entity/Q24629514',
    'http://www.wikidata.org/entity/Q24629543',
    'http://www.wikidata.org/entity/Q24629562',
    'http://www.wikidata.org/entity/Q24629582',
    'http://www.wikidata.org/entity/Q24629589',
    'http://www.wikidata.org/entity/Q24629598',
    'http://www.wikidata.org/entity/Q24629603',
    'http://www.wikidata.org/entity/Q24629626',
    'http://www.wikidata.org/entity/Q24629627',
    'http://www.wikidata.org/entity/Q24629630',
    'http://www.wikidata.org/entity/Q24629646',
    'http://www.wikidata.org/entity/Q24629653',
    'http://www.wikidata.org/entity/Q24629706',
    'http://www.wikidata.org/entity/Q24629716',
    'http://www.wikidata.org/entity/Q24629727',
    'http://www.wikidata.org/entity/Q24629733',
    'http://www.wikidata.org/entity/Q24629747',
    'http://www.wikidata.org/entity/Q24629773',
    'http://www.wikidata.org/entity/Q24629777',
    'http://www.wikidata.org/entity/Q24629806',
    'http://www.wikidata.org/entity/Q24629841',
    'http://www.wikidata.org/entity/Q24629879',
    'http://www.wikidata.org/entity/Q24629938',
    'http://www.wikidata.org/entity/Q24629958',
    'http://www.wikidata.org/entity/Q24629968',
    'http://www.wikidata.org/entity/Q24629972',
    'http://www.wikidata.org/entity/Q24629974',
    'http://www.wikidata.org/entity/Q24629991',
    'http://www.wikidata.org/entity/Q24630012',
    'http://www.wikidata.org/entity/Q24630037',
    'http://www.wikidata.org/entity/Q24630078',
    'http://www.wikidata.org/entity/Q24630087',
    'http://www.wikidata.org/entity/Q24630097',
    'http://www.wikidata.org/entity/Q24630100',
    'http://www.wikidata.org/entity/Q24630145',
    'http://www.wikidata.org/entity/Q24630163',
    'http://www.wikidata.org/entity/Q24630213',
    'http://www.wikidata.org/entity/Q24630221',
    'http://www.wikidata.org/entity/Q24630239',
    'http://www.wikidata.org/entity/Q24630261',
    'http://www.wikidata.org/entity/Q24630267',
    'http://www.wikidata.org/entity/Q24630288',
    'http://www.wikidata.org/entity/Q24630289',
    'http://www.wikidata.org/entity/Q24630300',
    'http://www.wikidata.org/entity/Q24630304',
    'http://www.wikidata.org/entity/Q24630341',
    'http://www.wikidata.org/entity/Q24630359',
    'http://www.wikidata.org/entity/Q24630362',
    'http://www.wikidata.org/entity/Q24630366',
    'http://www.wikidata.org/entity/Q24630389',
    'http://www.wikidata.org/entity/Q24630394',
    'http://www.wikidata.org/entity/Q24630397',
    'http://www.wikidata.org/entity/Q24630410',
    'http://www.wikidata.org/entity/Q24630415',
    'http://www.wikidata.org/entity/Q24630431',
    'http://www.wikidata.org/entity/Q24630455',
    'http://www.wikidata.org/entity/Q24630456',
    'http://www.wikidata.org/entity/Q24630467',
    'http://www.wikidata.org/entity/Q24630468',
    'http://www.wikidata.org/entity/Q24630475',
    'http://www.wikidata.org/entity/Q24630528',
    'http://www.wikidata.org/entity/Q24630541',
    'http://www.wikidata.org/entity/Q24630545',
    'http://www.wikidata.org/entity/Q24630557',
    'http://www.wikidata.org/entity/Q24630584',
    'http://www.wikidata.org/entity/Q24630599',
    'http://www.wikidata.org/entity/Q24630600',
    'http://www.wikidata.org/entity/Q24630608',
    'http://www.wikidata.org/entity/Q24630610',
    'http://www.wikidata.org/entity/Q24630613',
    'http://www.wikidata.org/entity/Q24630622',
    'http://www.wikidata.org/entity/Q24630646',
    'http://www.wikidata.org/entity/Q24630669',
    'http://www.wikidata.org/entity/Q24630673',
    'http://www.wikidata.org/entity/Q24630674',
    'http://www.wikidata.org/entity/Q24630679',
    'http://www.wikidata.org/entity/Q24630683',
    'http://www.wikidata.org/entity/Q24630756',
    'http://www.wikidata.org/entity/Q24630758',
    'http://www.wikidata.org/entity/Q24630778',
    'http://www.wikidata.org/entity/Q24630793',
    'http://www.wikidata.org/entity/Q24630827',
    'http://www.wikidata.org/entity/Q24630828',
    'http://www.wikidata.org/entity/Q24630836',
    'http://www.wikidata.org/entity/Q24630840',
    'http://www.wikidata.org/entity/Q24630844',
    'http://www.wikidata.org/entity/Q24630875',
    'http://www.wikidata.org/entity/Q24630877',
    'http://www.wikidata.org/entity/Q24630900',
    'http://www.wikidata.org/entity/Q24630921',
    'http://www.wikidata.org/entity/Q24630938',
    'http://www.wikidata.org/entity/Q24630945',
    'http://www.wikidata.org/entity/Q24630958',
    'http://www.wikidata.org/entity/Q24630961',
    'http://www.wikidata.org/entity/Q24630962',
    'http://www.wikidata.org/entity/Q24630976',
    'http://www.wikidata.org/entity/Q24630979',
    'http://www.wikidata.org/entity/Q24630997',
    'http://www.wikidata.org/entity/Q24631041',
    'http://www.wikidata.org/entity/Q24631052',
    'http://www.wikidata.org/entity/Q24631164',
    'http://www.wikidata.org/entity/Q24631167',
    'http://www.wikidata.org/entity/Q24631176',
    'http://www.wikidata.org/entity/Q24631193',
    'http://www.wikidata.org/entity/Q24631203',
    'http://www.wikidata.org/entity/Q24631269',
    'http://www.wikidata.org/entity/Q24631336',
    'http://www.wikidata.org/entity/Q24631347',
    'http://www.wikidata.org/entity/Q24631354',
    'http://www.wikidata.org/entity/Q24631425',
    'http://www.wikidata.org/entity/Q24631490',
    'http://www.wikidata.org/entity/Q24631504',
    'http://www.wikidata.org/entity/Q24631510',
    'http://www.wikidata.org/entity/Q24631513',
    'http://www.wikidata.org/entity/Q24631519',
    'http://www.wikidata.org/entity/Q24631525',
    'http://www.wikidata.org/entity/Q24631638',
    'http://www.wikidata.org/entity/Q24631645',
    'http://www.wikidata.org/entity/Q24631660',
    'http://www.wikidata.org/entity/Q24631676',
    'http://www.wikidata.org/entity/Q24631680',
    'http://www.wikidata.org/entity/Q24631683',
    'http://www.wikidata.org/entity/Q24631702',
    'http://www.wikidata.org/entity/Q24631745',
    'http://www.wikidata.org/entity/Q24631774',
    'http://www.wikidata.org/entity/Q24631814',
    'http://www.wikidata.org/entity/Q24631903',
    'http://www.wikidata.org/entity/Q24631922',
    'http://www.wikidata.org/entity/Q24631953',
    'http://www.wikidata.org/entity/Q24631957',
    'http://www.wikidata.org/entity/Q24631966',
    'http://www.wikidata.org/entity/Q24631987',
    'http://www.wikidata.org/entity/Q24631992',
    'http://www.wikidata.org/entity/Q24632064',
    'http://www.wikidata.org/entity/Q24632072',
    'http://www.wikidata.org/entity/Q24632076',
    'http://www.wikidata.org/entity/Q24632095',
    'http://www.wikidata.org/entity/Q24632119',
    'http://www.wikidata.org/entity/Q24632186',
    'http://www.wikidata.org/entity/Q24632206',
    'http://www.wikidata.org/entity/Q24632283',
    'http://www.wikidata.org/entity/Q24632329',
    'http://www.wikidata.org/entity/Q24632342',
    'http://www.wikidata.org/entity/Q24632353',
    'http://www.wikidata.org/entity/Q24632365',
    'http://www.wikidata.org/entity/Q24632382',
    'http://www.wikidata.org/entity/Q24632383',
    'http://www.wikidata.org/entity/Q24632387',
    'http://www.wikidata.org/entity/Q24632414',
    'http://www.wikidata.org/entity/Q24632425',
    'http://www.wikidata.org/entity/Q24632444',
    'http://www.wikidata.org/entity/Q24632455',
    'http://www.wikidata.org/entity/Q24632506',
    'http://www.wikidata.org/entity/Q24632533',
    'http://www.wikidata.org/entity/Q24632538',
    'http://www.wikidata.org/entity/Q24632620',
    'http://www.wikidata.org/entity/Q24632639',
    'http://www.wikidata.org/entity/Q24632651',
    'http://www.wikidata.org/entity/Q24632666',
    'http://www.wikidata.org/entity/Q24632675',
    'http://www.wikidata.org/entity/Q24632695',
    'http://www.wikidata.org/entity/Q24632749',
    'http://www.wikidata.org/entity/Q24632755',
    'http://www.wikidata.org/entity/Q24632756',
    'http://www.wikidata.org/entity/Q24632766',
    'http://www.wikidata.org/entity/Q24632768',
    'http://www.wikidata.org/entity/Q24632788',
    'http://www.wikidata.org/entity/Q24632791',
    'http://www.wikidata.org/entity/Q24632807',
    'http://www.wikidata.org/entity/Q24632826',
    'http://www.wikidata.org/entity/Q24632857',
    'http://www.wikidata.org/entity/Q24632872',
    'http://www.wikidata.org/entity/Q24632891',
    'http://www.wikidata.org/entity/Q24632892',
    'http://www.wikidata.org/entity/Q24632902',
    'http://www.wikidata.org/entity/Q24632927',
    'http://www.wikidata.org/entity/Q24632936',
    'http://www.wikidata.org/entity/Q24632951',
    'http://www.wikidata.org/entity/Q24632966',
    'http://www.wikidata.org/entity/Q24632975',
    'http://www.wikidata.org/entity/Q24632977',
    'http://www.wikidata.org/entity/Q24632987',
    'http://www.wikidata.org/entity/Q24633002',
    'http://www.wikidata.org/entity/Q24633007',
    'http://www.wikidata.org/entity/Q24633015',
    'http://www.wikidata.org/entity/Q24633026',
    'http://www.wikidata.org/entity/Q24633053',
    'http://www.wikidata.org/entity/Q24633063',
    'http://www.wikidata.org/entity/Q24633065',
    'http://www.wikidata.org/entity/Q24633070',
    'http://www.wikidata.org/entity/Q24633110',
    'http://www.wikidata.org/entity/Q24633113',
    'http://www.wikidata.org/entity/Q24633123',
    'http://www.wikidata.org/entity/Q24633183',
    'http://www.wikidata.org/entity/Q24633203',
    'http://www.wikidata.org/entity/Q24633214',
    'http://www.wikidata.org/entity/Q24633262',
    'http://www.wikidata.org/entity/Q24633274',
    'http://www.wikidata.org/entity/Q24633282',
    'http://www.wikidata.org/entity/Q24633316',
    'http://www.wikidata.org/entity/Q24633319',
    'http://www.wikidata.org/entity/Q24633341',
    'http://www.wikidata.org/entity/Q24633352',
    'http://www.wikidata.org/entity/Q24633372',
    'http://www.wikidata.org/entity/Q24633377',
    'http://www.wikidata.org/entity/Q24633391',
    'http://www.wikidata.org/entity/Q24633406',
    'http://www.wikidata.org/entity/Q24633417',
    'http://www.wikidata.org/entity/Q24633445',
    'http://www.wikidata.org/entity/Q24633468',
    'http://www.wikidata.org/entity/Q24633486',
    'http://www.wikidata.org/entity/Q24633499',
    'http://www.wikidata.org/entity/Q24633526',
    'http://www.wikidata.org/entity/Q24633527',
    'http://www.wikidata.org/entity/Q24633543',
    'http://www.wikidata.org/entity/Q24633549',
    'http://www.wikidata.org/entity/Q24633604',
    'http://www.wikidata.org/entity/Q24633606',
    'http://www.wikidata.org/entity/Q24633626',
    'http://www.wikidata.org/entity/Q24633648',
    'http://www.wikidata.org/entity/Q24633662',
    'http://www.wikidata.org/entity/Q24633663',
    'http://www.wikidata.org/entity/Q24633664',
    'http://www.wikidata.org/entity/Q24633670',
    'http://www.wikidata.org/entity/Q24633677',
    'http://www.wikidata.org/entity/Q24633678',
    'http://www.wikidata.org/entity/Q24633692',
    'http://www.wikidata.org/entity/Q24633693',
    'http://www.wikidata.org/entity/Q24633731',
    'http://www.wikidata.org/entity/Q24633736',
    'http://www.wikidata.org/entity/Q24633765',
    'http://www.wikidata.org/entity/Q24633766',
    'http://www.wikidata.org/entity/Q24633789',
    'http://www.wikidata.org/entity/Q24633791',
    'http://www.wikidata.org/entity/Q24633806',
    'http://www.wikidata.org/entity/Q24633857',
    'http://www.wikidata.org/entity/Q24633874',
    'http://www.wikidata.org/entity/Q24633888',
    'http://www.wikidata.org/entity/Q24633890',
    'http://www.wikidata.org/entity/Q24633898',
    'http://www.wikidata.org/entity/Q24633916',
    'http://www.wikidata.org/entity/Q24633947',
    'http://www.wikidata.org/entity/Q24633965',
    'http://www.wikidata.org/entity/Q24633967',
    'http://www.wikidata.org/entity/Q24634002',
    'http://www.wikidata.org/entity/Q24634010',
    'http://www.wikidata.org/entity/Q24634030',
    'http://www.wikidata.org/entity/Q24634051',
    'http://www.wikidata.org/entity/Q24634064',
    'http://www.wikidata.org/entity/Q24634141',
    'http://www.wikidata.org/entity/Q24634151',
    'http://www.wikidata.org/entity/Q24634165',
    'http://www.wikidata.org/entity/Q24634173',
    'http://www.wikidata.org/entity/Q24634174',
    'http://www.wikidata.org/entity/Q24634180',
    'http://www.wikidata.org/entity/Q24634193',
    'http://www.wikidata.org/entity/Q24634204',
    'http://www.wikidata.org/entity/Q24634284',
    'http://www.wikidata.org/entity/Q24634390',
    'http://www.wikidata.org/entity/Q24634394',
    'http://www.wikidata.org/entity/Q24634416',
    'http://www.wikidata.org/entity/Q24634442',
    'http://www.wikidata.org/entity/Q24634548',
    'http://www.wikidata.org/entity/Q24634556',
    'http://www.wikidata.org/entity/Q24634577',
    'http://www.wikidata.org/entity/Q24634583',
    'http://www.wikidata.org/entity/Q24634631',
    'http://www.wikidata.org/entity/Q24634652',
    'http://www.wikidata.org/entity/Q24634688',
    'http://www.wikidata.org/entity/Q24634698',
    'http://www.wikidata.org/entity/Q24634716',
    'http://www.wikidata.org/entity/Q24634719',
    'http://www.wikidata.org/entity/Q24634724',
    'http://www.wikidata.org/entity/Q24634779',
    'http://www.wikidata.org/entity/Q24634788',
    'http://www.wikidata.org/entity/Q24634829',
    'http://www.wikidata.org/entity/Q24634871',
    'http://www.wikidata.org/entity/Q24634970',
    'http://www.wikidata.org/entity/Q24635070',
    'http://www.wikidata.org/entity/Q24635138',
    'http://www.wikidata.org/entity/Q24635151',
    'http://www.wikidata.org/entity/Q24635154',
    'http://www.wikidata.org/entity/Q24635174',
    'http://www.wikidata.org/entity/Q24635198',
    'http://www.wikidata.org/entity/Q24635224',
    'http://www.wikidata.org/entity/Q24635244',
    'http://www.wikidata.org/entity/Q24635327',
    'http://www.wikidata.org/entity/Q24635333',
    'http://www.wikidata.org/entity/Q24635367',
    'http://www.wikidata.org/entity/Q24635370',
    'http://www.wikidata.org/entity/Q24635842',
    'http://www.wikidata.org/entity/Q24635849',
    'http://www.wikidata.org/entity/Q24635921',
    'http://www.wikidata.org/entity/Q24635938',
    'http://www.wikidata.org/entity/Q24635951',
    'http://www.wikidata.org/entity/Q24641811',
    'http://www.wikidata.org/entity/Q24641880',
    'http://www.wikidata.org/entity/Q24641881',
    'http://www.wikidata.org/entity/Q24641887',
    'http://www.wikidata.org/entity/Q24641894',
    'http://www.wikidata.org/entity/Q24641912',
    'http://www.wikidata.org/entity/Q24641913',
    'http://www.wikidata.org/entity/Q24641981',
    'http://www.wikidata.org/entity/Q24641993',
    'http://www.wikidata.org/entity/Q24642029',
    'http://www.wikidata.org/entity/Q24642106',
    'http://www.wikidata.org/entity/Q24642111',
    'http://www.wikidata.org/entity/Q24642113',
    'http://www.wikidata.org/entity/Q24642126',
    'http://www.wikidata.org/entity/Q24642170',
    'http://www.wikidata.org/entity/Q24642184',
    'http://www.wikidata.org/entity/Q24642201',
    'http://www.wikidata.org/entity/Q24642281',
    'http://www.wikidata.org/entity/Q24642303',
    'http://www.wikidata.org/entity/Q24642367',
    'http://www.wikidata.org/entity/Q24642387',
    'http://www.wikidata.org/entity/Q24642417',
    'http://www.wikidata.org/entity/Q24642447',
    'http://www.wikidata.org/entity/Q24642456',
    'http://www.wikidata.org/entity/Q24642503',
    'http://www.wikidata.org/entity/Q24642509',
    'http://www.wikidata.org/entity/Q24642513',
    'http://www.wikidata.org/entity/Q24642530',
    'http://www.wikidata.org/entity/Q24642534',
    'http://www.wikidata.org/entity/Q24642540',
    'http://www.wikidata.org/entity/Q24642583',
    'http://www.wikidata.org/entity/Q24642606',
    'http://www.wikidata.org/entity/Q24642619',
    'http://www.wikidata.org/entity/Q24642620',
    'http://www.wikidata.org/entity/Q24642630',
    'http://www.wikidata.org/entity/Q24642646',
    'http://www.wikidata.org/entity/Q24642697',
    'http://www.wikidata.org/entity/Q24642708',
    'http://www.wikidata.org/entity/Q24642711',
    'http://www.wikidata.org/entity/Q24642794',
    'http://www.wikidata.org/entity/Q24642820',
    'http://www.wikidata.org/entity/Q24642852',
    'http://www.wikidata.org/entity/Q24642901',
    'http://www.wikidata.org/entity/Q24642944',
    'http://www.wikidata.org/entity/Q24642979',
    'http://www.wikidata.org/entity/Q24642996',
    'http://www.wikidata.org/entity/Q24643023',
    'http://www.wikidata.org/entity/Q24643034',
    'http://www.wikidata.org/entity/Q24643054',
    'http://www.wikidata.org/entity/Q24643067',
    'http://www.wikidata.org/entity/Q24643343',
    'http://www.wikidata.org/entity/Q24643398',
    'http://www.wikidata.org/entity/Q24643421',
    'http://www.wikidata.org/entity/Q24643426',
    'http://www.wikidata.org/entity/Q24643436',
    'http://www.wikidata.org/entity/Q24643440',
    'http://www.wikidata.org/entity/Q24643447',
    'http://www.wikidata.org/entity/Q24643477',
    'http://www.wikidata.org/entity/Q24643479',
    'http://www.wikidata.org/entity/Q24643490',
    'http://www.wikidata.org/entity/Q24643492',
    'http://www.wikidata.org/entity/Q24643503',
    'http://www.wikidata.org/entity/Q24643514',
    'http://www.wikidata.org/entity/Q24643584',
    'http://www.wikidata.org/entity/Q24643628',
    'http://www.wikidata.org/entity/Q24643698',
    'http://www.wikidata.org/entity/Q24643720',
    'http://www.wikidata.org/entity/Q24643775',
    'http://www.wikidata.org/entity/Q24643816',
    'http://www.wikidata.org/entity/Q24643849',
    'http://www.wikidata.org/entity/Q24643876',
    'http://www.wikidata.org/entity/Q24643882',
    'http://www.wikidata.org/entity/Q24643889',
    'http://www.wikidata.org/entity/Q24643897',
    'http://www.wikidata.org/entity/Q24643899',
    'http://www.wikidata.org/entity/Q24643902',
    'http://www.wikidata.org/entity/Q24643922',
    'http://www.wikidata.org/entity/Q24643933',
    'http://www.wikidata.org/entity/Q24643935',
    'http://www.wikidata.org/entity/Q24643939',
    'http://www.wikidata.org/entity/Q24643947',
    'http://www.wikidata.org/entity/Q24643985',
    'http://www.wikidata.org/entity/Q24644003',
    'http://www.wikidata.org/entity/Q24644008',
    'http://www.wikidata.org/entity/Q24644113',
    'http://www.wikidata.org/entity/Q24644179',
    'http://www.wikidata.org/entity/Q24644184',
    'http://www.wikidata.org/entity/Q24644195',
    'http://www.wikidata.org/entity/Q24644216',
    'http://www.wikidata.org/entity/Q24644218',
    'http://www.wikidata.org/entity/Q24644255',
    'http://www.wikidata.org/entity/Q24644257',
    'http://www.wikidata.org/entity/Q24644303',
    'http://www.wikidata.org/entity/Q24644329',
    'http://www.wikidata.org/entity/Q24644381',
    'http://www.wikidata.org/entity/Q24644391',
    'http://www.wikidata.org/entity/Q24644398',
    'http://www.wikidata.org/entity/Q24644436',
    'http://www.wikidata.org/entity/Q24644442',
    'http://www.wikidata.org/entity/Q24644457',
    'http://www.wikidata.org/entity/Q24644463',
    'http://www.wikidata.org/entity/Q24644472',
    'http://www.wikidata.org/entity/Q24644474',
    'http://www.wikidata.org/entity/Q24644514',
    'http://www.wikidata.org/entity/Q24644519',
    'http://www.wikidata.org/entity/Q24644523',
    'http://www.wikidata.org/entity/Q24644530',
    'http://www.wikidata.org/entity/Q24644543',
    'http://www.wikidata.org/entity/Q24644554',
    'http://www.wikidata.org/entity/Q24644573',
    'http://www.wikidata.org/entity/Q24644599',
    'http://www.wikidata.org/entity/Q24644612',
    'http://www.wikidata.org/entity/Q24644640',
    'http://www.wikidata.org/entity/Q24644650',
    'http://www.wikidata.org/entity/Q24644662',
    'http://www.wikidata.org/entity/Q24644670',
    'http://www.wikidata.org/entity/Q24644672',
    'http://www.wikidata.org/entity/Q24644686',
    'http://www.wikidata.org/entity/Q24644691',
    'http://www.wikidata.org/entity/Q24644706',
    'http://www.wikidata.org/entity/Q24644709',
    'http://www.wikidata.org/entity/Q24644712',
    'http://www.wikidata.org/entity/Q24644721',
    'http://www.wikidata.org/entity/Q24644752',
    'http://www.wikidata.org/entity/Q24644757',
    'http://www.wikidata.org/entity/Q24644774',
    'http://www.wikidata.org/entity/Q24644775',
    'http://www.wikidata.org/entity/Q24644776',
    'http://www.wikidata.org/entity/Q24644779',
    'http://www.wikidata.org/entity/Q24644798',
    'http://www.wikidata.org/entity/Q24644828',
    'http://www.wikidata.org/entity/Q24644850',
    'http://www.wikidata.org/entity/Q24644870',
    'http://www.wikidata.org/entity/Q24644872',
    'http://www.wikidata.org/entity/Q24644883',
    'http://www.wikidata.org/entity/Q24644916',
    'http://www.wikidata.org/entity/Q24644945',
    'http://www.wikidata.org/entity/Q24644961',
    'http://www.wikidata.org/entity/Q24644975',
    'http://www.wikidata.org/entity/Q24644984',
    'http://www.wikidata.org/entity/Q24644990',
    'http://www.wikidata.org/entity/Q24645008',
    'http://www.wikidata.org/entity/Q24645012',
    'http://www.wikidata.org/entity/Q24645026',
    'http://www.wikidata.org/entity/Q24645048',
    'http://www.wikidata.org/entity/Q24645052',
    'http://www.wikidata.org/entity/Q24645074',
    'http://www.wikidata.org/entity/Q24645076',
    'http://www.wikidata.org/entity/Q24645091',
    'http://www.wikidata.org/entity/Q24645092',
    'http://www.wikidata.org/entity/Q24645106',
    'http://www.wikidata.org/entity/Q24645126',
    'http://www.wikidata.org/entity/Q24645157',
    'http://www.wikidata.org/entity/Q24645190',
    'http://www.wikidata.org/entity/Q24645192',
    'http://www.wikidata.org/entity/Q24645193',
    'http://www.wikidata.org/entity/Q24645204',
    'http://www.wikidata.org/entity/Q24645232',
    'http://www.wikidata.org/entity/Q24645237',
    'http://www.wikidata.org/entity/Q24645245',
    'http://www.wikidata.org/entity/Q24645253',
    'http://www.wikidata.org/entity/Q24645346',
    'http://www.wikidata.org/entity/Q24645354',
    'http://www.wikidata.org/entity/Q24645356',
    'http://www.wikidata.org/entity/Q24645367',
    'http://www.wikidata.org/entity/Q24645380',
    'http://www.wikidata.org/entity/Q24645391',
    'http://www.wikidata.org/entity/Q24645400',
    'http://www.wikidata.org/entity/Q24645420',
    'http://www.wikidata.org/entity/Q24645430',
    'http://www.wikidata.org/entity/Q24645441',
    'http://www.wikidata.org/entity/Q24645445',
    'http://www.wikidata.org/entity/Q24645499',
    'http://www.wikidata.org/entity/Q24645514',
    'http://www.wikidata.org/entity/Q24645528',
    'http://www.wikidata.org/entity/Q24645530',
    'http://www.wikidata.org/entity/Q24645537',
    'http://www.wikidata.org/entity/Q24645580',
    'http://www.wikidata.org/entity/Q24645600',
    'http://www.wikidata.org/entity/Q24645614',
    'http://www.wikidata.org/entity/Q24645628',
    'http://www.wikidata.org/entity/Q24645631',
    'http://www.wikidata.org/entity/Q24645655',
    'http://www.wikidata.org/entity/Q24645663',
    'http://www.wikidata.org/entity/Q24645668',
    'http://www.wikidata.org/entity/Q24645689',
    'http://www.wikidata.org/entity/Q24645701',
    'http://www.wikidata.org/entity/Q24645703',
    'http://www.wikidata.org/entity/Q24645732',
    'http://www.wikidata.org/entity/Q24645815',
    'http://www.wikidata.org/entity/Q24645826',
    'http://www.wikidata.org/entity/Q24645977',
    'http://www.wikidata.org/entity/Q24645989',
    'http://www.wikidata.org/entity/Q24645994',
    'http://www.wikidata.org/entity/Q24646014',
    'http://www.wikidata.org/entity/Q24646031',
    'http://www.wikidata.org/entity/Q24646062',
    'http://www.wikidata.org/entity/Q24646090',
    'http://www.wikidata.org/entity/Q24646104',
    'http://www.wikidata.org/entity/Q24646174',
    'http://www.wikidata.org/entity/Q24646179',
    'http://www.wikidata.org/entity/Q24646191',
    'http://www.wikidata.org/entity/Q24646194',
    'http://www.wikidata.org/entity/Q24646206',
    'http://www.wikidata.org/entity/Q24646234',
    'http://www.wikidata.org/entity/Q24646236',
    'http://www.wikidata.org/entity/Q24646248',
    'http://www.wikidata.org/entity/Q24646257',
    'http://www.wikidata.org/entity/Q24646275',
    'http://www.wikidata.org/entity/Q24646295',
    'http://www.wikidata.org/entity/Q24646296',
    'http://www.wikidata.org/entity/Q24646313',
    'http://www.wikidata.org/entity/Q24646326',
    'http://www.wikidata.org/entity/Q24646352',
    'http://www.wikidata.org/entity/Q24646370',
    'http://www.wikidata.org/entity/Q24646374',
    'http://www.wikidata.org/entity/Q24646434',
    'http://www.wikidata.org/entity/Q24646439',
    'http://www.wikidata.org/entity/Q24646454',
    'http://www.wikidata.org/entity/Q24646468',
    'http://www.wikidata.org/entity/Q24646495',
    'http://www.wikidata.org/entity/Q24646499',
    'http://www.wikidata.org/entity/Q24646512',
    'http://www.wikidata.org/entity/Q24646531',
    'http://www.wikidata.org/entity/Q24646535',
    'http://www.wikidata.org/entity/Q24646565',
    'http://www.wikidata.org/entity/Q24646571',
    'http://www.wikidata.org/entity/Q24646584',
    'http://www.wikidata.org/entity/Q24646605',
    'http://www.wikidata.org/entity/Q24646623',
    'http://www.wikidata.org/entity/Q24646628',
    'http://www.wikidata.org/entity/Q24646644',
    'http://www.wikidata.org/entity/Q24646654',
    'http://www.wikidata.org/entity/Q24646663',
    'http://www.wikidata.org/entity/Q24646677',
    'http://www.wikidata.org/entity/Q24646698',
    'http://www.wikidata.org/entity/Q24646738',
    'http://www.wikidata.org/entity/Q24646744',
    'http://www.wikidata.org/entity/Q24646758',
    'http://www.wikidata.org/entity/Q24646817',
    'http://www.wikidata.org/entity/Q24646833',
    'http://www.wikidata.org/entity/Q24646855',
    'http://www.wikidata.org/entity/Q24646863',
    'http://www.wikidata.org/entity/Q24646902',
    'http://www.wikidata.org/entity/Q24646921',
    'http://www.wikidata.org/entity/Q24646936',
    'http://www.wikidata.org/entity/Q24646943',
    'http://www.wikidata.org/entity/Q24646970',
    'http://www.wikidata.org/entity/Q24646977',
    'http://www.wikidata.org/entity/Q24646996',
    'http://www.wikidata.org/entity/Q24647026',
    'http://www.wikidata.org/entity/Q24647053',
    'http://www.wikidata.org/entity/Q24647067',
    'http://www.wikidata.org/entity/Q24647069',
    'http://www.wikidata.org/entity/Q24647081',
    'http://www.wikidata.org/entity/Q24647095',
    'http://www.wikidata.org/entity/Q24647099',
    'http://www.wikidata.org/entity/Q24647100',
    'http://www.wikidata.org/entity/Q24647109',
    'http://www.wikidata.org/entity/Q24647137',
    'http://www.wikidata.org/entity/Q24647146',
    'http://www.wikidata.org/entity/Q24647156',
    'http://www.wikidata.org/entity/Q24647201',
    'http://www.wikidata.org/entity/Q24647211',
    'http://www.wikidata.org/entity/Q24647220',
    'http://www.wikidata.org/entity/Q24647231',
    'http://www.wikidata.org/entity/Q24647259',
    'http://www.wikidata.org/entity/Q24647264',
    'http://www.wikidata.org/entity/Q24647287',
    'http://www.wikidata.org/entity/Q24647290',
    'http://www.wikidata.org/entity/Q24647312',
    'http://www.wikidata.org/entity/Q24647318',
    'http://www.wikidata.org/entity/Q24647373',
    'http://www.wikidata.org/entity/Q24647437',
    'http://www.wikidata.org/entity/Q24647443',
    'http://www.wikidata.org/entity/Q24647482',
    'http://www.wikidata.org/entity/Q24647487',
    'http://www.wikidata.org/entity/Q24647533',
    'http://www.wikidata.org/entity/Q24647538',
    'http://www.wikidata.org/entity/Q24647539',
    'http://www.wikidata.org/entity/Q24647550',
    'http://www.wikidata.org/entity/Q24647555',
    'http://www.wikidata.org/entity/Q24647568',
    'http://www.wikidata.org/entity/Q24647574',
    'http://www.wikidata.org/entity/Q24647580',
    'http://www.wikidata.org/entity/Q24647583',
    'http://www.wikidata.org/entity/Q24647586',
    'http://www.wikidata.org/entity/Q24647611',
    'http://www.wikidata.org/entity/Q24647617',
    'http://www.wikidata.org/entity/Q24647620',
    'http://www.wikidata.org/entity/Q24647626',
    'http://www.wikidata.org/entity/Q24647647',
    'http://www.wikidata.org/entity/Q24647655',
    'http://www.wikidata.org/entity/Q24647697',
    'http://www.wikidata.org/entity/Q24647709',
    'http://www.wikidata.org/entity/Q24647754',
    'http://www.wikidata.org/entity/Q24647775',
    'http://www.wikidata.org/entity/Q24647805',
    'http://www.wikidata.org/entity/Q24647858',
    'http://www.wikidata.org/entity/Q24647863',
    'http://www.wikidata.org/entity/Q24647883',
    'http://www.wikidata.org/entity/Q24647888',
    'http://www.wikidata.org/entity/Q24647900',
    'http://www.wikidata.org/entity/Q24647926',
    'http://www.wikidata.org/entity/Q24647928',
    'http://www.wikidata.org/entity/Q24647929',
    'http://www.wikidata.org/entity/Q24647935',
    'http://www.wikidata.org/entity/Q24647944',
    'http://www.wikidata.org/entity/Q24647989',
    'http://www.wikidata.org/entity/Q24648017',
    'http://www.wikidata.org/entity/Q24648021',
    'http://www.wikidata.org/entity/Q24648025',
    'http://www.wikidata.org/entity/Q24648032',
    'http://www.wikidata.org/entity/Q24648041',
    'http://www.wikidata.org/entity/Q24648045',
    'http://www.wikidata.org/entity/Q24648051',
    'http://www.wikidata.org/entity/Q24648090',
    'http://www.wikidata.org/entity/Q24648102',
    'http://www.wikidata.org/entity/Q24648103',
    'http://www.wikidata.org/entity/Q24648105',
    'http://www.wikidata.org/entity/Q24648136',
    'http://www.wikidata.org/entity/Q24648176',
    'http://www.wikidata.org/entity/Q24648186',
    'http://www.wikidata.org/entity/Q24648192',
    'http://www.wikidata.org/entity/Q24648241',
    'http://www.wikidata.org/entity/Q24648242',
    'http://www.wikidata.org/entity/Q24648260',
    'http://www.wikidata.org/entity/Q24648319',
    'http://www.wikidata.org/entity/Q24648323',
    'http://www.wikidata.org/entity/Q24648324',
    'http://www.wikidata.org/entity/Q24648426',
    'http://www.wikidata.org/entity/Q24648473',
    'http://www.wikidata.org/entity/Q24648484',
    'http://www.wikidata.org/entity/Q24648488',
    'http://www.wikidata.org/entity/Q24648552',
    'http://www.wikidata.org/entity/Q24648565',
    'http://www.wikidata.org/entity/Q24648574',
    'http://www.wikidata.org/entity/Q24648580',
    'http://www.wikidata.org/entity/Q24648590',
    'http://www.wikidata.org/entity/Q24648624',
    'http://www.wikidata.org/entity/Q24648628',
    'http://www.wikidata.org/entity/Q24648636',
    'http://www.wikidata.org/entity/Q24648672',
    'http://www.wikidata.org/entity/Q24648717',
    'http://www.wikidata.org/entity/Q24648721',
    'http://www.wikidata.org/entity/Q24648757',
    'http://www.wikidata.org/entity/Q24648789',
    'http://www.wikidata.org/entity/Q24648793',
    'http://www.wikidata.org/entity/Q24648835',
    'http://www.wikidata.org/entity/Q24648851',
    'http://www.wikidata.org/entity/Q24648857',
    'http://www.wikidata.org/entity/Q24648860',
    'http://www.wikidata.org/entity/Q24648865',
    'http://www.wikidata.org/entity/Q24648889',
    'http://www.wikidata.org/entity/Q24648892',
    'http://www.wikidata.org/entity/Q24648897',
    'http://www.wikidata.org/entity/Q24648938',
    'http://www.wikidata.org/entity/Q24648944',
    'http://www.wikidata.org/entity/Q24648948',
    'http://www.wikidata.org/entity/Q24648961',
    'http://www.wikidata.org/entity/Q24648963',
    'http://www.wikidata.org/entity/Q24648977',
    'http://www.wikidata.org/entity/Q24648984',
    'http://www.wikidata.org/entity/Q24649017',
    'http://www.wikidata.org/entity/Q24649032',
    'http://www.wikidata.org/entity/Q24649064',
    'http://www.wikidata.org/entity/Q24649077',
    'http://www.wikidata.org/entity/Q24649095',
    'http://www.wikidata.org/entity/Q24649098',
    'http://www.wikidata.org/entity/Q24649109',
    'http://www.wikidata.org/entity/Q24649111',
    'http://www.wikidata.org/entity/Q24649122',
    'http://www.wikidata.org/entity/Q24649127',
    'http://www.wikidata.org/entity/Q24649151',
    'http://www.wikidata.org/entity/Q24649156',
    'http://www.wikidata.org/entity/Q24649158',
    'http://www.wikidata.org/entity/Q24649273',
    'http://www.wikidata.org/entity/Q24649374',
    'http://www.wikidata.org/entity/Q24649418',
    'http://www.wikidata.org/entity/Q24649479',
    'http://www.wikidata.org/entity/Q24649539',
    'http://www.wikidata.org/entity/Q24649549',
    'http://www.wikidata.org/entity/Q24649595',
    'http://www.wikidata.org/entity/Q24649598',
    'http://www.wikidata.org/entity/Q24649633',
    'http://www.wikidata.org/entity/Q24649634',
    'http://www.wikidata.org/entity/Q24649640',
    'http://www.wikidata.org/entity/Q24649645',
    'http://www.wikidata.org/entity/Q24649648',
    'http://www.wikidata.org/entity/Q24649687',
    'http://www.wikidata.org/entity/Q24649709',
    'http://www.wikidata.org/entity/Q24649711',
    'http://www.wikidata.org/entity/Q24649726',
    'http://www.wikidata.org/entity/Q24649732',
    'http://www.wikidata.org/entity/Q24649768',
    'http://www.wikidata.org/entity/Q24649802',
    'http://www.wikidata.org/entity/Q24649811',
    'http://www.wikidata.org/entity/Q24649863',
    'http://www.wikidata.org/entity/Q24649872',
    'http://www.wikidata.org/entity/Q24649924',
    'http://www.wikidata.org/entity/Q24649926',
    'http://www.wikidata.org/entity/Q24649935',
    'http://www.wikidata.org/entity/Q24649949',
    'http://www.wikidata.org/entity/Q24650014',
    'http://www.wikidata.org/entity/Q24650035',
    'http://www.wikidata.org/entity/Q24650037',
    'http://www.wikidata.org/entity/Q24650056',
    'http://www.wikidata.org/entity/Q24650094',
    'http://www.wikidata.org/entity/Q24650108',
    'http://www.wikidata.org/entity/Q24650126',
    'http://www.wikidata.org/entity/Q24650168',
    'http://www.wikidata.org/entity/Q24650184',
    'http://www.wikidata.org/entity/Q24650188',
    'http://www.wikidata.org/entity/Q24650204',
    'http://www.wikidata.org/entity/Q24650225',
    'http://www.wikidata.org/entity/Q24650229',
    'http://www.wikidata.org/entity/Q24650238',
    'http://www.wikidata.org/entity/Q24650268',
    'http://www.wikidata.org/entity/Q24650300',
    'http://www.wikidata.org/entity/Q24650312',
    'http://www.wikidata.org/entity/Q24650328',
    'http://www.wikidata.org/entity/Q24650347',
    'http://www.wikidata.org/entity/Q24650427',
    'http://www.wikidata.org/entity/Q24650518',
    'http://www.wikidata.org/entity/Q24650599',
    'http://www.wikidata.org/entity/Q24650627',
    'http://www.wikidata.org/entity/Q24650662',
    'http://www.wikidata.org/entity/Q24650670',
    'http://www.wikidata.org/entity/Q24650675',
    'http://www.wikidata.org/entity/Q24650686',
    'http://www.wikidata.org/entity/Q24650703',
    'http://www.wikidata.org/entity/Q24650727',
    'http://www.wikidata.org/entity/Q24650734',
    'http://www.wikidata.org/entity/Q24650739',
    'http://www.wikidata.org/entity/Q24650753',
    'http://www.wikidata.org/entity/Q24650786',
    'http://www.wikidata.org/entity/Q24650787',
    'http://www.wikidata.org/entity/Q24650793',
    'http://www.wikidata.org/entity/Q24650796',
    'http://www.wikidata.org/entity/Q24650811',
    'http://www.wikidata.org/entity/Q24650818',
    'http://www.wikidata.org/entity/Q24650896',
    'http://www.wikidata.org/entity/Q24650905',
    'http://www.wikidata.org/entity/Q24650911',
    'http://www.wikidata.org/entity/Q24650915',
    'http://www.wikidata.org/entity/Q24650924',
    'http://www.wikidata.org/entity/Q24650949',
    'http://www.wikidata.org/entity/Q24650951',
    'http://www.wikidata.org/entity/Q24650965',
    'http://www.wikidata.org/entity/Q24650969',
    'http://www.wikidata.org/entity/Q24650970',
    'http://www.wikidata.org/entity/Q24650981',
    'http://www.wikidata.org/entity/Q24651016',
    'http://www.wikidata.org/entity/Q24651076',
    'http://www.wikidata.org/entity/Q24651093',
    'http://www.wikidata.org/entity/Q24651102',
    'http://www.wikidata.org/entity/Q24651105',
    'http://www.wikidata.org/entity/Q24651119',
    'http://www.wikidata.org/entity/Q24651173',
    'http://www.wikidata.org/entity/Q24651183',
    'http://www.wikidata.org/entity/Q24651191',
    'http://www.wikidata.org/entity/Q24651226',
    'http://www.wikidata.org/entity/Q24651232',
    'http://www.wikidata.org/entity/Q24651258',
    'http://www.wikidata.org/entity/Q24651272',
    'http://www.wikidata.org/entity/Q24651280',
    'http://www.wikidata.org/entity/Q24651300',
    'http://www.wikidata.org/entity/Q24651301',
    'http://www.wikidata.org/entity/Q24651322',
    'http://www.wikidata.org/entity/Q24651334',
    'http://www.wikidata.org/entity/Q24651391',
    'http://www.wikidata.org/entity/Q24651397',
    'http://www.wikidata.org/entity/Q24651414',
    'http://www.wikidata.org/entity/Q24651422',
    'http://www.wikidata.org/entity/Q24651453',
    'http://www.wikidata.org/entity/Q24651456',
    'http://www.wikidata.org/entity/Q24651457',
    'http://www.wikidata.org/entity/Q24651475',
    'http://www.wikidata.org/entity/Q24651494',
    'http://www.wikidata.org/entity/Q24651508',
    'http://www.wikidata.org/entity/Q24651518',
    'http://www.wikidata.org/entity/Q24651527',
    'http://www.wikidata.org/entity/Q24651541',
    'http://www.wikidata.org/entity/Q24651548',
    'http://www.wikidata.org/entity/Q24651638',
    'http://www.wikidata.org/entity/Q24651802',
    'http://www.wikidata.org/entity/Q24651844',
    'http://www.wikidata.org/entity/Q24651886',
    'http://www.wikidata.org/entity/Q24651888',
    'http://www.wikidata.org/entity/Q24651897',
    'http://www.wikidata.org/entity/Q24651907',
    'http://www.wikidata.org/entity/Q24651913',
    'http://www.wikidata.org/entity/Q24651939',
    'http://www.wikidata.org/entity/Q24651949',
    'http://www.wikidata.org/entity/Q24651959',
    'http://www.wikidata.org/entity/Q24651962',
    'http://www.wikidata.org/entity/Q24651967',
    'http://www.wikidata.org/entity/Q24651973',
    'http://www.wikidata.org/entity/Q24651977',
    'http://www.wikidata.org/entity/Q24651983',
    'http://www.wikidata.org/entity/Q24651984',
    'http://www.wikidata.org/entity/Q24651985',
    'http://www.wikidata.org/entity/Q24652007',
    'http://www.wikidata.org/entity/Q24652098',
    'http://www.wikidata.org/entity/Q24652180',
    'http://www.wikidata.org/entity/Q24652199',
    'http://www.wikidata.org/entity/Q24652200',
    'http://www.wikidata.org/entity/Q24652212',
    'http://www.wikidata.org/entity/Q24652219',
    'http://www.wikidata.org/entity/Q24652230',
    'http://www.wikidata.org/entity/Q24652239',
    'http://www.wikidata.org/entity/Q24652259',
    'http://www.wikidata.org/entity/Q24652265',
    'http://www.wikidata.org/entity/Q24652311',
    'http://www.wikidata.org/entity/Q24652323',
    'http://www.wikidata.org/entity/Q24652324',
    'http://www.wikidata.org/entity/Q24652326',
    'http://www.wikidata.org/entity/Q24652468',
    'http://www.wikidata.org/entity/Q24652491',
    'http://www.wikidata.org/entity/Q24652502',
    'http://www.wikidata.org/entity/Q24652521',
    'http://www.wikidata.org/entity/Q24652525',
    'http://www.wikidata.org/entity/Q24652530',
    'http://www.wikidata.org/entity/Q24652547',
    'http://www.wikidata.org/entity/Q24652558',
    'http://www.wikidata.org/entity/Q24652569',
    'http://www.wikidata.org/entity/Q24652575',
    'http://www.wikidata.org/entity/Q24652600',
    'http://www.wikidata.org/entity/Q24652606',
    'http://www.wikidata.org/entity/Q24652643',
    'http://www.wikidata.org/entity/Q24652644',
    'http://www.wikidata.org/entity/Q24652669',
    'http://www.wikidata.org/entity/Q24652674',
    'http://www.wikidata.org/entity/Q24652678',
    'http://www.wikidata.org/entity/Q24652720',
    'http://www.wikidata.org/entity/Q24652778',
    'http://www.wikidata.org/entity/Q24652787',
    'http://www.wikidata.org/entity/Q24652803',
    'http://www.wikidata.org/entity/Q24652815',
    'http://www.wikidata.org/entity/Q24652826',
    'http://www.wikidata.org/entity/Q24652830',
    'http://www.wikidata.org/entity/Q24652833',
    'http://www.wikidata.org/entity/Q24652836',
    'http://www.wikidata.org/entity/Q24652913',
    'http://www.wikidata.org/entity/Q24652915',
    'http://www.wikidata.org/entity/Q24652941',
    'http://www.wikidata.org/entity/Q24652947',
    'http://www.wikidata.org/entity/Q24652963',
    'http://www.wikidata.org/entity/Q24652964',
    'http://www.wikidata.org/entity/Q24652967',
    'http://www.wikidata.org/entity/Q24652969',
    'http://www.wikidata.org/entity/Q24652976',
    'http://www.wikidata.org/entity/Q24652978',
    'http://www.wikidata.org/entity/Q24652992',
    'http://www.wikidata.org/entity/Q24653015',
    'http://www.wikidata.org/entity/Q24653078',
    'http://www.wikidata.org/entity/Q24653084',
    'http://www.wikidata.org/entity/Q24653086',
    'http://www.wikidata.org/entity/Q24653222',
    'http://www.wikidata.org/entity/Q24653244',
    'http://www.wikidata.org/entity/Q24653247',
    'http://www.wikidata.org/entity/Q24653260',
    'http://www.wikidata.org/entity/Q24653380',
    'http://www.wikidata.org/entity/Q24653386',
    'http://www.wikidata.org/entity/Q24653432',
    'http://www.wikidata.org/entity/Q24653442',
    'http://www.wikidata.org/entity/Q24653443',
    'http://www.wikidata.org/entity/Q24653481',
    'http://www.wikidata.org/entity/Q24653500',
    'http://www.wikidata.org/entity/Q24653502',
    'http://www.wikidata.org/entity/Q24653527',
    'http://www.wikidata.org/entity/Q24653549',
    'http://www.wikidata.org/entity/Q24653558',
    'http://www.wikidata.org/entity/Q24653626',
    'http://www.wikidata.org/entity/Q24653639',
    'http://www.wikidata.org/entity/Q24653650',
    'http://www.wikidata.org/entity/Q24653668',
    'http://www.wikidata.org/entity/Q24653676',
    'http://www.wikidata.org/entity/Q24653685',
    'http://www.wikidata.org/entity/Q24653700',
    'http://www.wikidata.org/entity/Q24653723',
    'http://www.wikidata.org/entity/Q24653724',
    'http://www.wikidata.org/entity/Q24653753',
    'http://www.wikidata.org/entity/Q24653754',
    'http://www.wikidata.org/entity/Q24653755',
    'http://www.wikidata.org/entity/Q24653759',
    'http://www.wikidata.org/entity/Q24653769',
    'http://www.wikidata.org/entity/Q24653771',
    'http://www.wikidata.org/entity/Q24653776',
    'http://www.wikidata.org/entity/Q24653779',
    'http://www.wikidata.org/entity/Q24653790',
    'http://www.wikidata.org/entity/Q24653818',
    'http://www.wikidata.org/entity/Q24653833',
    'http://www.wikidata.org/entity/Q24653853',
    'http://www.wikidata.org/entity/Q24653859',
    'http://www.wikidata.org/entity/Q24653924',
    'http://www.wikidata.org/entity/Q24653946',
    'http://www.wikidata.org/entity/Q24653978',
    'http://www.wikidata.org/entity/Q24653997',
    'http://www.wikidata.org/entity/Q24654019',
    'http://www.wikidata.org/entity/Q24654092',
    'http://www.wikidata.org/entity/Q24654123',
    'http://www.wikidata.org/entity/Q24654132',
    'http://www.wikidata.org/entity/Q24654145',
    'http://www.wikidata.org/entity/Q24654162',
    'http://www.wikidata.org/entity/Q24654225',
    'http://www.wikidata.org/entity/Q24654249',
    'http://www.wikidata.org/entity/Q24654258',
    'http://www.wikidata.org/entity/Q24654340',
    'http://www.wikidata.org/entity/Q24654374',
    'http://www.wikidata.org/entity/Q24654563',
    'http://www.wikidata.org/entity/Q24654617',
    'http://www.wikidata.org/entity/Q24654622',
    'http://www.wikidata.org/entity/Q24654643',
    'http://www.wikidata.org/entity/Q24654676',
    'http://www.wikidata.org/entity/Q24654685',
    'http://www.wikidata.org/entity/Q24654699',
    'http://www.wikidata.org/entity/Q24654727',
    'http://www.wikidata.org/entity/Q24654741',
    'http://www.wikidata.org/entity/Q24654755',
    'http://www.wikidata.org/entity/Q24654786',
    'http://www.wikidata.org/entity/Q24654787',
    'http://www.wikidata.org/entity/Q24654795',
    'http://www.wikidata.org/entity/Q24654905',
    'http://www.wikidata.org/entity/Q24654906',
    'http://www.wikidata.org/entity/Q24654912',
    'http://www.wikidata.org/entity/Q24654976',
    'http://www.wikidata.org/entity/Q24655027',
    'http://www.wikidata.org/entity/Q24655041',
    'http://www.wikidata.org/entity/Q24655061',
    'http://www.wikidata.org/entity/Q24655062',
    'http://www.wikidata.org/entity/Q24655064',
    'http://www.wikidata.org/entity/Q24655079',
    'http://www.wikidata.org/entity/Q24655095',
    'http://www.wikidata.org/entity/Q24655106',
    'http://www.wikidata.org/entity/Q24655154',
    'http://www.wikidata.org/entity/Q24655155',
    'http://www.wikidata.org/entity/Q24655166',
    'http://www.wikidata.org/entity/Q24655169',
    'http://www.wikidata.org/entity/Q24655218',
    'http://www.wikidata.org/entity/Q24655224',
    'http://www.wikidata.org/entity/Q24655262',
    'http://www.wikidata.org/entity/Q24655269',
    'http://www.wikidata.org/entity/Q24655274',
    'http://www.wikidata.org/entity/Q24655287',
    'http://www.wikidata.org/entity/Q24655295',
    'http://www.wikidata.org/entity/Q24655297',
    'http://www.wikidata.org/entity/Q24655308',
    'http://www.wikidata.org/entity/Q24655377',
    'http://www.wikidata.org/entity/Q24655388',
    'http://www.wikidata.org/entity/Q24655401',
    'http://www.wikidata.org/entity/Q24655403',
    'http://www.wikidata.org/entity/Q24655406',
    'http://www.wikidata.org/entity/Q24655432',
    'http://www.wikidata.org/entity/Q24655438',
    'http://www.wikidata.org/entity/Q24655442',
    'http://www.wikidata.org/entity/Q24655459',
    'http://www.wikidata.org/entity/Q24655465',
    'http://www.wikidata.org/entity/Q24655475',
    'http://www.wikidata.org/entity/Q24655481',
    'http://www.wikidata.org/entity/Q24655484',
    'http://www.wikidata.org/entity/Q24655505',
    'http://www.wikidata.org/entity/Q24655519',
    'http://www.wikidata.org/entity/Q24655530',
    'http://www.wikidata.org/entity/Q24655537',
    'http://www.wikidata.org/entity/Q24655562',
    'http://www.wikidata.org/entity/Q24655567',
    'http://www.wikidata.org/entity/Q24655574',
    'http://www.wikidata.org/entity/Q24655591',
    'http://www.wikidata.org/entity/Q24655615',
    'http://www.wikidata.org/entity/Q24655617',
    'http://www.wikidata.org/entity/Q24655629',
    'http://www.wikidata.org/entity/Q24655630',
    'http://www.wikidata.org/entity/Q24655632',
    'http://www.wikidata.org/entity/Q24655642',
    'http://www.wikidata.org/entity/Q24655655',
    'http://www.wikidata.org/entity/Q24655665',
    'http://www.wikidata.org/entity/Q24655676',
    'http://www.wikidata.org/entity/Q24655685',
    'http://www.wikidata.org/entity/Q24655701',
    'http://www.wikidata.org/entity/Q24655711',
    'http://www.wikidata.org/entity/Q24655725',
    'http://www.wikidata.org/entity/Q24655744',
    'http://www.wikidata.org/entity/Q24655755',
    'http://www.wikidata.org/entity/Q24655756',
    'http://www.wikidata.org/entity/Q24655759',
    'http://www.wikidata.org/entity/Q24655762',
    'http://www.wikidata.org/entity/Q24655788',
    'http://www.wikidata.org/entity/Q24655795',
    'http://www.wikidata.org/entity/Q24655812',
    'http://www.wikidata.org/entity/Q24655819',
    'http://www.wikidata.org/entity/Q24655821',
    'http://www.wikidata.org/entity/Q24655833',
    'http://www.wikidata.org/entity/Q24655848',
    'http://www.wikidata.org/entity/Q24655855',
    'http://www.wikidata.org/entity/Q24655857',
    'http://www.wikidata.org/entity/Q24655887',
    'http://www.wikidata.org/entity/Q24655899',
    'http://www.wikidata.org/entity/Q24655915',
    'http://www.wikidata.org/entity/Q24655923',
    'http://www.wikidata.org/entity/Q24655932',
    'http://www.wikidata.org/entity/Q24655948',
    'http://www.wikidata.org/entity/Q24655964',
    'http://www.wikidata.org/entity/Q24655994',
    'http://www.wikidata.org/entity/Q24656001',
    'http://www.wikidata.org/entity/Q24656032',
    'http://www.wikidata.org/entity/Q24656041',
    'http://www.wikidata.org/entity/Q24656047',
    'http://www.wikidata.org/entity/Q24656073',
    'http://www.wikidata.org/entity/Q24656090',
    'http://www.wikidata.org/entity/Q24656120',
    'http://www.wikidata.org/entity/Q24656128',
    'http://www.wikidata.org/entity/Q24656148',
    'http://www.wikidata.org/entity/Q24656166',
    'http://www.wikidata.org/entity/Q24656173',
    'http://www.wikidata.org/entity/Q24656176',
    'http://www.wikidata.org/entity/Q24656187',
    'http://www.wikidata.org/entity/Q24656193',
    'http://www.wikidata.org/entity/Q24656204',
    'http://www.wikidata.org/entity/Q24656209',
    'http://www.wikidata.org/entity/Q24656213',
    'http://www.wikidata.org/entity/Q24656230',
    'http://www.wikidata.org/entity/Q24656236',
    'http://www.wikidata.org/entity/Q24656239',
    'http://www.wikidata.org/entity/Q24656256',
    'http://www.wikidata.org/entity/Q24656261',
    'http://www.wikidata.org/entity/Q24656273',
    'http://www.wikidata.org/entity/Q24656275',
    'http://www.wikidata.org/entity/Q24656284',
    'http://www.wikidata.org/entity/Q24656322',
    'http://www.wikidata.org/entity/Q24656327',
    'http://www.wikidata.org/entity/Q24656544',
    'http://www.wikidata.org/entity/Q24656568',
    'http://www.wikidata.org/entity/Q24656574',
    'http://www.wikidata.org/entity/Q24656576',
    'http://www.wikidata.org/entity/Q24656613',
    'http://www.wikidata.org/entity/Q24656618',
    'http://www.wikidata.org/entity/Q24656640',
    'http://www.wikidata.org/entity/Q24656658',
    'http://www.wikidata.org/entity/Q24656663',
    'http://www.wikidata.org/entity/Q24656666',
    'http://www.wikidata.org/entity/Q24656668',
    'http://www.wikidata.org/entity/Q24656675',
    'http://www.wikidata.org/entity/Q24656702',
    'http://www.wikidata.org/entity/Q24656799',
    'http://www.wikidata.org/entity/Q24656840',
    'http://www.wikidata.org/entity/Q24656936',
    'http://www.wikidata.org/entity/Q24656947',
    'http://www.wikidata.org/entity/Q24656950',
    'http://www.wikidata.org/entity/Q24656954',
    'http://www.wikidata.org/entity/Q24656970',
    'http://www.wikidata.org/entity/Q24656974',
    'http://www.wikidata.org/entity/Q24657011',
    'http://www.wikidata.org/entity/Q24657078',
    'http://www.wikidata.org/entity/Q24657080',
    'http://www.wikidata.org/entity/Q24657119',
    'http://www.wikidata.org/entity/Q24657125',
    'http://www.wikidata.org/entity/Q24657130',
    'http://www.wikidata.org/entity/Q24657139',
    'http://www.wikidata.org/entity/Q24657178',
    'http://www.wikidata.org/entity/Q24657207',
    'http://www.wikidata.org/entity/Q24657221',
    'http://www.wikidata.org/entity/Q24657247',
    'http://www.wikidata.org/entity/Q24657260',
    'http://www.wikidata.org/entity/Q24657265',
    'http://www.wikidata.org/entity/Q24657268',
    'http://www.wikidata.org/entity/Q24657284',
    'http://www.wikidata.org/entity/Q24657292',
    'http://www.wikidata.org/entity/Q24657305',
    'http://www.wikidata.org/entity/Q24657354',
    'http://www.wikidata.org/entity/Q24657366',
    'http://www.wikidata.org/entity/Q24657378',
    'http://www.wikidata.org/entity/Q24657484',
    'http://www.wikidata.org/entity/Q24657511',
    'http://www.wikidata.org/entity/Q24657524',
    'http://www.wikidata.org/entity/Q24657531',
    'http://www.wikidata.org/entity/Q24657543',
    'http://www.wikidata.org/entity/Q24657546',
    'http://www.wikidata.org/entity/Q24657550',
    'http://www.wikidata.org/entity/Q24657553',
    'http://www.wikidata.org/entity/Q24657597',
    'http://www.wikidata.org/entity/Q24657623',
    'http://www.wikidata.org/entity/Q24657663',
    'http://www.wikidata.org/entity/Q24657666',
    'http://www.wikidata.org/entity/Q24657675',
    'http://www.wikidata.org/entity/Q24657708',
    'http://www.wikidata.org/entity/Q24657721',
    'http://www.wikidata.org/entity/Q24657731',
    'http://www.wikidata.org/entity/Q24657733',
    'http://www.wikidata.org/entity/Q24657856',
    'http://www.wikidata.org/entity/Q24657857',
    'http://www.wikidata.org/entity/Q24657869',
    'http://www.wikidata.org/entity/Q24657877',
    'http://www.wikidata.org/entity/Q24657908',
    'http://www.wikidata.org/entity/Q24657910',
    'http://www.wikidata.org/entity/Q24657924',
    'http://www.wikidata.org/entity/Q24657927',
    'http://www.wikidata.org/entity/Q24657929',
    'http://www.wikidata.org/entity/Q24657953',
    'http://www.wikidata.org/entity/Q24657958',
    'http://www.wikidata.org/entity/Q24657959',
    'http://www.wikidata.org/entity/Q24658039',
    'http://www.wikidata.org/entity/Q24658047',
    'http://www.wikidata.org/entity/Q24658051',
    'http://www.wikidata.org/entity/Q24658052',
    'http://www.wikidata.org/entity/Q24658073',
    'http://www.wikidata.org/entity/Q24658083',
    'http://www.wikidata.org/entity/Q24658090',
    'http://www.wikidata.org/entity/Q24658108',
    'http://www.wikidata.org/entity/Q24658134',
    'http://www.wikidata.org/entity/Q24658139',
    'http://www.wikidata.org/entity/Q24658147',
    'http://www.wikidata.org/entity/Q24658163',
    'http://www.wikidata.org/entity/Q24658173',
    'http://www.wikidata.org/entity/Q24658201',
    'http://www.wikidata.org/entity/Q24658205',
    'http://www.wikidata.org/entity/Q24658222',
    'http://www.wikidata.org/entity/Q24658224',
    'http://www.wikidata.org/entity/Q24658255',
    'http://www.wikidata.org/entity/Q24658271',
    'http://www.wikidata.org/entity/Q24658272',
    'http://www.wikidata.org/entity/Q24658285',
    'http://www.wikidata.org/entity/Q24658302',
    'http://www.wikidata.org/entity/Q24658343',
    'http://www.wikidata.org/entity/Q24658344',
    'http://www.wikidata.org/entity/Q24658353',
    'http://www.wikidata.org/entity/Q24658370',
    'http://www.wikidata.org/entity/Q24658386',
    'http://www.wikidata.org/entity/Q24658400',
    'http://www.wikidata.org/entity/Q24658408',
    'http://www.wikidata.org/entity/Q24658451',
    'http://www.wikidata.org/entity/Q24669531',
    'http://www.wikidata.org/entity/Q24669561',
    'http://www.wikidata.org/entity/Q24669579',
    'http://www.wikidata.org/entity/Q24669585',
    'http://www.wikidata.org/entity/Q24669594',
    'http://www.wikidata.org/entity/Q24669605',
    'http://www.wikidata.org/entity/Q24669649',
    'http://www.wikidata.org/entity/Q24669691',
    'http://www.wikidata.org/entity/Q24669708',
    'http://www.wikidata.org/entity/Q24669741',
    'http://www.wikidata.org/entity/Q24669742',
    'http://www.wikidata.org/entity/Q24669747',
    'http://www.wikidata.org/entity/Q24669771',
    'http://www.wikidata.org/entity/Q24669783',
    'http://www.wikidata.org/entity/Q24669789',
    'http://www.wikidata.org/entity/Q24669811',
    'http://www.wikidata.org/entity/Q24669815',
    'http://www.wikidata.org/entity/Q24669821',
    'http://www.wikidata.org/entity/Q24669847',
    'http://www.wikidata.org/entity/Q24669850',
    'http://www.wikidata.org/entity/Q24669862',
    'http://www.wikidata.org/entity/Q24669877',
    'http://www.wikidata.org/entity/Q24669892',
    'http://www.wikidata.org/entity/Q24669979',
    'http://www.wikidata.org/entity/Q24669991',
    'http://www.wikidata.org/entity/Q24670067',
    'http://www.wikidata.org/entity/Q24670080',
    'http://www.wikidata.org/entity/Q24670125',
    'http://www.wikidata.org/entity/Q24670137',
    'http://www.wikidata.org/entity/Q24670182',
    'http://www.wikidata.org/entity/Q24670192',
    'http://www.wikidata.org/entity/Q24670224',
    'http://www.wikidata.org/entity/Q24670346',
    'http://www.wikidata.org/entity/Q24670395',
    'http://www.wikidata.org/entity/Q24670409',
    'http://www.wikidata.org/entity/Q24670412',
    'http://www.wikidata.org/entity/Q24670432',
    'http://www.wikidata.org/entity/Q24670484',
    'http://www.wikidata.org/entity/Q24670528',
    'http://www.wikidata.org/entity/Q24670532',
    'http://www.wikidata.org/entity/Q24670544',
    'http://www.wikidata.org/entity/Q24670567',
    'http://www.wikidata.org/entity/Q24670576',
    'http://www.wikidata.org/entity/Q24670615',
    'http://www.wikidata.org/entity/Q24670661',
    'http://www.wikidata.org/entity/Q24670696',
    'http://www.wikidata.org/entity/Q24670719',
    'http://www.wikidata.org/entity/Q24670840',
    'http://www.wikidata.org/entity/Q24670887',
    'http://www.wikidata.org/entity/Q24670942',
    'http://www.wikidata.org/entity/Q24671032',
    'http://www.wikidata.org/entity/Q24671061',
    'http://www.wikidata.org/entity/Q24671064',
    'http://www.wikidata.org/entity/Q24671078',
    'http://www.wikidata.org/entity/Q24671316',
    'http://www.wikidata.org/entity/Q24671346',
    'http://www.wikidata.org/entity/Q24671467',
    'http://www.wikidata.org/entity/Q24671470',
    'http://www.wikidata.org/entity/Q24671514',
    'http://www.wikidata.org/entity/Q24671667',
    'http://www.wikidata.org/entity/Q24671687',
    'http://www.wikidata.org/entity/Q24671745',
    'http://www.wikidata.org/entity/Q24671750',
    'http://www.wikidata.org/entity/Q24671756',
    'http://www.wikidata.org/entity/Q24671785',
    'http://www.wikidata.org/entity/Q24671788',
    'http://www.wikidata.org/entity/Q24671831',
    'http://www.wikidata.org/entity/Q24671908',
    'http://www.wikidata.org/entity/Q24671936',
    'http://www.wikidata.org/entity/Q24671941',
    'http://www.wikidata.org/entity/Q24671987',
    'http://www.wikidata.org/entity/Q24671990',
    'http://www.wikidata.org/entity/Q24672005',
    'http://www.wikidata.org/entity/Q24672061',
    'http://www.wikidata.org/entity/Q24672110',
    'http://www.wikidata.org/entity/Q24672151',
    'http://www.wikidata.org/entity/Q24672170',
    'http://www.wikidata.org/entity/Q24672185',
    'http://www.wikidata.org/entity/Q24672199',
    'http://www.wikidata.org/entity/Q24672230',
    'http://www.wikidata.org/entity/Q24672232',
    'http://www.wikidata.org/entity/Q24672245',
    'http://www.wikidata.org/entity/Q24672297',
    'http://www.wikidata.org/entity/Q24672316',
    'http://www.wikidata.org/entity/Q24672356',
    'http://www.wikidata.org/entity/Q24672361',
    'http://www.wikidata.org/entity/Q24672368',
    'http://www.wikidata.org/entity/Q24672405',
    'http://www.wikidata.org/entity/Q24672424',
    'http://www.wikidata.org/entity/Q24672442',
    'http://www.wikidata.org/entity/Q24672450',
    'http://www.wikidata.org/entity/Q24672476',
    'http://www.wikidata.org/entity/Q24672480',
    'http://www.wikidata.org/entity/Q24672492',
    'http://www.wikidata.org/entity/Q24672501',
    'http://www.wikidata.org/entity/Q24672511',
    'http://www.wikidata.org/entity/Q24672515',
    'http://www.wikidata.org/entity/Q24672516',
    'http://www.wikidata.org/entity/Q24672530',
    'http://www.wikidata.org/entity/Q24672548',
    'http://www.wikidata.org/entity/Q24672549',
    'http://www.wikidata.org/entity/Q24672590',
    'http://www.wikidata.org/entity/Q24672592',
    'http://www.wikidata.org/entity/Q24672596',
    'http://www.wikidata.org/entity/Q24672627',
    'http://www.wikidata.org/entity/Q24672647',
    'http://www.wikidata.org/entity/Q24672664',
    'http://www.wikidata.org/entity/Q24672699',
    'http://www.wikidata.org/entity/Q24672708',
    'http://www.wikidata.org/entity/Q24672721',
    'http://www.wikidata.org/entity/Q24672780',
    'http://www.wikidata.org/entity/Q24672834',
    'http://www.wikidata.org/entity/Q24672842',
    'http://www.wikidata.org/entity/Q24672849',
    'http://www.wikidata.org/entity/Q24672855',
    'http://www.wikidata.org/entity/Q24672862',
    'http://www.wikidata.org/entity/Q24672925',
    'http://www.wikidata.org/entity/Q24672928',
    'http://www.wikidata.org/entity/Q24672958',
    'http://www.wikidata.org/entity/Q24673062',
    'http://www.wikidata.org/entity/Q24673066',
    'http://www.wikidata.org/entity/Q24673069',
    'http://www.wikidata.org/entity/Q24673075',
    'http://www.wikidata.org/entity/Q24673081',
    'http://www.wikidata.org/entity/Q24673096',
    'http://www.wikidata.org/entity/Q24673112',
    'http://www.wikidata.org/entity/Q24673118',
    'http://www.wikidata.org/entity/Q24673120',
    'http://www.wikidata.org/entity/Q24673122',
    'http://www.wikidata.org/entity/Q24673124',
    'http://www.wikidata.org/entity/Q24673131',
    'http://www.wikidata.org/entity/Q24673148',
    'http://www.wikidata.org/entity/Q24673189',
    'http://www.wikidata.org/entity/Q24673248',
    'http://www.wikidata.org/entity/Q24673330',
    'http://www.wikidata.org/entity/Q24673389',
    'http://www.wikidata.org/entity/Q24673418',
    'http://www.wikidata.org/entity/Q24673419',
    'http://www.wikidata.org/entity/Q24673466',
    'http://www.wikidata.org/entity/Q24673476',
    'http://www.wikidata.org/entity/Q24673516',
    'http://www.wikidata.org/entity/Q24673523',
    'http://www.wikidata.org/entity/Q24673524',
    'http://www.wikidata.org/entity/Q24673535',
    'http://www.wikidata.org/entity/Q24673547',
    'http://www.wikidata.org/entity/Q24673611',
    'http://www.wikidata.org/entity/Q24673619',
    'http://www.wikidata.org/entity/Q24673663',
    'http://www.wikidata.org/entity/Q24673688',
    'http://www.wikidata.org/entity/Q24673738',
    'http://www.wikidata.org/entity/Q24673768',
    'http://www.wikidata.org/entity/Q24673806',
    'http://www.wikidata.org/entity/Q24673923',
    'http://www.wikidata.org/entity/Q24673956',
    'http://www.wikidata.org/entity/Q24674070',
    'http://www.wikidata.org/entity/Q24674090',
    'http://www.wikidata.org/entity/Q24674091',
    'http://www.wikidata.org/entity/Q24674115',
    'http://www.wikidata.org/entity/Q24674126',
    'http://www.wikidata.org/entity/Q24674131',
    'http://www.wikidata.org/entity/Q24674132',
    'http://www.wikidata.org/entity/Q24674155',
    'http://www.wikidata.org/entity/Q24674179',
    'http://www.wikidata.org/entity/Q24674190',
    'http://www.wikidata.org/entity/Q24674274',
    'http://www.wikidata.org/entity/Q24674276',
    'http://www.wikidata.org/entity/Q24674295',
    'http://www.wikidata.org/entity/Q24674500',
    'http://www.wikidata.org/entity/Q24674578',
    'http://www.wikidata.org/entity/Q24674617',
    'http://www.wikidata.org/entity/Q24674636',
    'http://www.wikidata.org/entity/Q24674849',
    'http://www.wikidata.org/entity/Q24674856',
    'http://www.wikidata.org/entity/Q24674946',
    'http://www.wikidata.org/entity/Q24675046',
    'http://www.wikidata.org/entity/Q24675055',
    'http://www.wikidata.org/entity/Q24675122',
    'http://www.wikidata.org/entity/Q24675171',
    'http://www.wikidata.org/entity/Q24675176',
    'http://www.wikidata.org/entity/Q24675221',
    'http://www.wikidata.org/entity/Q24675225',
    'http://www.wikidata.org/entity/Q24675231',
    'http://www.wikidata.org/entity/Q24675281',
    'http://www.wikidata.org/entity/Q24675312',
    'http://www.wikidata.org/entity/Q24675333',
    'http://www.wikidata.org/entity/Q24675343',
    'http://www.wikidata.org/entity/Q24675361',
    'http://www.wikidata.org/entity/Q24675384',
    'http://www.wikidata.org/entity/Q24675391',
    'http://www.wikidata.org/entity/Q24675399',
    'http://www.wikidata.org/entity/Q24675443',
    'http://www.wikidata.org/entity/Q24675521',
    'http://www.wikidata.org/entity/Q24675540',
    'http://www.wikidata.org/entity/Q24675560',
    'http://www.wikidata.org/entity/Q24675592',
    'http://www.wikidata.org/entity/Q24675630',
    'http://www.wikidata.org/entity/Q24675659',
    'http://www.wikidata.org/entity/Q24675698',
    'http://www.wikidata.org/entity/Q24675699',
    'http://www.wikidata.org/entity/Q24675714',
    'http://www.wikidata.org/entity/Q24675719',
    'http://www.wikidata.org/entity/Q24675724',
    'http://www.wikidata.org/entity/Q24675729',
    'http://www.wikidata.org/entity/Q24675738',
    'http://www.wikidata.org/entity/Q24675740',
    'http://www.wikidata.org/entity/Q24675768',
    'http://www.wikidata.org/entity/Q24675773',
    'http://www.wikidata.org/entity/Q24675789',
    'http://www.wikidata.org/entity/Q24675827',
    'http://www.wikidata.org/entity/Q24675916',
    'http://www.wikidata.org/entity/Q24675924',
    'http://www.wikidata.org/entity/Q24675931',
    'http://www.wikidata.org/entity/Q24675955',
    'http://www.wikidata.org/entity/Q24676006',
    'http://www.wikidata.org/entity/Q24676026',
    'http://www.wikidata.org/entity/Q24676039',
    'http://www.wikidata.org/entity/Q24676080',
    'http://www.wikidata.org/entity/Q24676113',
    'http://www.wikidata.org/entity/Q24676119',
    'http://www.wikidata.org/entity/Q24676165',
    'http://www.wikidata.org/entity/Q24676178',
    'http://www.wikidata.org/entity/Q24676203',
    'http://www.wikidata.org/entity/Q24676216',
    'http://www.wikidata.org/entity/Q24676217',
    'http://www.wikidata.org/entity/Q24676280',
    'http://www.wikidata.org/entity/Q24676299',
    'http://www.wikidata.org/entity/Q24676353',
    'http://www.wikidata.org/entity/Q24676378',
    'http://www.wikidata.org/entity/Q24676413',
    'http://www.wikidata.org/entity/Q24676452',
    'http://www.wikidata.org/entity/Q24676453',
    'http://www.wikidata.org/entity/Q24676525',
    'http://www.wikidata.org/entity/Q24676527',
    'http://www.wikidata.org/entity/Q24676535',
    'http://www.wikidata.org/entity/Q24676539',
    'http://www.wikidata.org/entity/Q24676591',
    'http://www.wikidata.org/entity/Q24676637',
    'http://www.wikidata.org/entity/Q24676709',
    'http://www.wikidata.org/entity/Q24676716',
    'http://www.wikidata.org/entity/Q24676746',
    'http://www.wikidata.org/entity/Q24676749',
    'http://www.wikidata.org/entity/Q24676777',
    'http://www.wikidata.org/entity/Q24676790',
    'http://www.wikidata.org/entity/Q24676809',
    'http://www.wikidata.org/entity/Q24676827',
    'http://www.wikidata.org/entity/Q24676868',
    'http://www.wikidata.org/entity/Q24676881',
    'http://www.wikidata.org/entity/Q24676898',
    'http://www.wikidata.org/entity/Q24676901',
    'http://www.wikidata.org/entity/Q24676943',
    'http://www.wikidata.org/entity/Q24676976',
    'http://www.wikidata.org/entity/Q24676982',
    'http://www.wikidata.org/entity/Q24677007',
    'http://www.wikidata.org/entity/Q24677011',
    'http://www.wikidata.org/entity/Q24677013',
    'http://www.wikidata.org/entity/Q24677038',
    'http://www.wikidata.org/entity/Q24677057',
    'http://www.wikidata.org/entity/Q24677060',
    'http://www.wikidata.org/entity/Q24677061',
    'http://www.wikidata.org/entity/Q24677354',
    'http://www.wikidata.org/entity/Q24677407',
    'http://www.wikidata.org/entity/Q24677437',
    'http://www.wikidata.org/entity/Q24677460',
    'http://www.wikidata.org/entity/Q24677534',
    'http://www.wikidata.org/entity/Q24677591',
    'http://www.wikidata.org/entity/Q24677633',
    'http://www.wikidata.org/entity/Q24677790',
    'http://www.wikidata.org/entity/Q24677835',
    'http://www.wikidata.org/entity/Q24677881',
    'http://www.wikidata.org/entity/Q24677936',
    'http://www.wikidata.org/entity/Q24677973',
    'http://www.wikidata.org/entity/Q24678032',
    'http://www.wikidata.org/entity/Q24678057',
    'http://www.wikidata.org/entity/Q24678115',
    'http://www.wikidata.org/entity/Q24678210',
    'http://www.wikidata.org/entity/Q24678229',
    'http://www.wikidata.org/entity/Q24678240',
    'http://www.wikidata.org/entity/Q24678267',
    'http://www.wikidata.org/entity/Q24678290',
    'http://www.wikidata.org/entity/Q24678303',
    'http://www.wikidata.org/entity/Q24678317',
    'http://www.wikidata.org/entity/Q24678332',
    'http://www.wikidata.org/entity/Q24678361',
    'http://www.wikidata.org/entity/Q24678382',
    'http://www.wikidata.org/entity/Q24678400',
    'http://www.wikidata.org/entity/Q24678506',
    'http://www.wikidata.org/entity/Q24678522',
    'http://www.wikidata.org/entity/Q24678549',
    'http://www.wikidata.org/entity/Q24678564',
    'http://www.wikidata.org/entity/Q24678573',
    'http://www.wikidata.org/entity/Q24678575',
    'http://www.wikidata.org/entity/Q24678600',
    'http://www.wikidata.org/entity/Q24678661',
    'http://www.wikidata.org/entity/Q24678674',
    'http://www.wikidata.org/entity/Q24678779',
    'http://www.wikidata.org/entity/Q24678789',
    'http://www.wikidata.org/entity/Q24678793',
    'http://www.wikidata.org/entity/Q24678795',
    'http://www.wikidata.org/entity/Q24678846',
    'http://www.wikidata.org/entity/Q24678859',
    'http://www.wikidata.org/entity/Q24678867',
    'http://www.wikidata.org/entity/Q24678953',
    'http://www.wikidata.org/entity/Q24678967',
    'http://www.wikidata.org/entity/Q24679016',
    'http://www.wikidata.org/entity/Q24679073',
    'http://www.wikidata.org/entity/Q24679102',
    'http://www.wikidata.org/entity/Q24679272',
    'http://www.wikidata.org/entity/Q24679349',
    'http://www.wikidata.org/entity/Q24679382',
    'http://www.wikidata.org/entity/Q24679402',
    'http://www.wikidata.org/entity/Q24679412',
    'http://www.wikidata.org/entity/Q24679428',
    'http://www.wikidata.org/entity/Q24679543',
    'http://www.wikidata.org/entity/Q24679554',
    'http://www.wikidata.org/entity/Q24679555',
    'http://www.wikidata.org/entity/Q24679592',
    'http://www.wikidata.org/entity/Q24679593',
    'http://www.wikidata.org/entity/Q24679602',
    'http://www.wikidata.org/entity/Q24679648',
    'http://www.wikidata.org/entity/Q24679724',
    'http://www.wikidata.org/entity/Q24679736',
    'http://www.wikidata.org/entity/Q24679746',
    'http://www.wikidata.org/entity/Q24679747',
    'http://www.wikidata.org/entity/Q24679793',
    'http://www.wikidata.org/entity/Q24679805',
    'http://www.wikidata.org/entity/Q24679810',
    'http://www.wikidata.org/entity/Q24679827',
    'http://www.wikidata.org/entity/Q24679932',
    'http://www.wikidata.org/entity/Q24679991',
    'http://www.wikidata.org/entity/Q24680110',
    'http://www.wikidata.org/entity/Q24680160',
    'http://www.wikidata.org/entity/Q24680189',
    'http://www.wikidata.org/entity/Q24680247',
    'http://www.wikidata.org/entity/Q24680253',
    'http://www.wikidata.org/entity/Q24680274',
    'http://www.wikidata.org/entity/Q24680283',
    'http://www.wikidata.org/entity/Q24680284',
    'http://www.wikidata.org/entity/Q24680327',
    'http://www.wikidata.org/entity/Q24680389',
    'http://www.wikidata.org/entity/Q24680489',
    'http://www.wikidata.org/entity/Q24680561',
    'http://www.wikidata.org/entity/Q24680714',
    'http://www.wikidata.org/entity/Q24680733',
    'http://www.wikidata.org/entity/Q24680784',
    'http://www.wikidata.org/entity/Q24680814',
    'http://www.wikidata.org/entity/Q24680836',
    'http://www.wikidata.org/entity/Q24680880',
    'http://www.wikidata.org/entity/Q24680941',
    'http://www.wikidata.org/entity/Q24680943',
    'http://www.wikidata.org/entity/Q24680954',
    'http://www.wikidata.org/entity/Q24681014',
    'http://www.wikidata.org/entity/Q24681021',
    'http://www.wikidata.org/entity/Q24681029',
    'http://www.wikidata.org/entity/Q24681122',
    'http://www.wikidata.org/entity/Q24681191',
    'http://www.wikidata.org/entity/Q24681205',
    'http://www.wikidata.org/entity/Q24681243',
    'http://www.wikidata.org/entity/Q24681264',
    'http://www.wikidata.org/entity/Q24681266',
    'http://www.wikidata.org/entity/Q24681270',
    'http://www.wikidata.org/entity/Q24681292',
    'http://www.wikidata.org/entity/Q24681309',
    'http://www.wikidata.org/entity/Q24681325',
    'http://www.wikidata.org/entity/Q24681363',
    'http://www.wikidata.org/entity/Q24681377',
    'http://www.wikidata.org/entity/Q24681388',
    'http://www.wikidata.org/entity/Q24681392',
    'http://www.wikidata.org/entity/Q24681396',
    'http://www.wikidata.org/entity/Q24681466',
    'http://www.wikidata.org/entity/Q24681480',
    'http://www.wikidata.org/entity/Q24681488',
    'http://www.wikidata.org/entity/Q24681496',
    'http://www.wikidata.org/entity/Q24681507',
    'http://www.wikidata.org/entity/Q24681545',
    'http://www.wikidata.org/entity/Q24681548',
    'http://www.wikidata.org/entity/Q24681599',
    'http://www.wikidata.org/entity/Q24681609',
    'http://www.wikidata.org/entity/Q24681630',
    'http://www.wikidata.org/entity/Q24681642',
    'http://www.wikidata.org/entity/Q24681645',
    'http://www.wikidata.org/entity/Q24681662',
    'http://www.wikidata.org/entity/Q24681664',
    'http://www.wikidata.org/entity/Q24681677',
    'http://www.wikidata.org/entity/Q24681693',
    'http://www.wikidata.org/entity/Q24681719',
    'http://www.wikidata.org/entity/Q24681753',
    'http://www.wikidata.org/entity/Q24681774',
    'http://www.wikidata.org/entity/Q24681776',
    'http://www.wikidata.org/entity/Q24681805',
    'http://www.wikidata.org/entity/Q24681833',
    'http://www.wikidata.org/entity/Q24681875',
    'http://www.wikidata.org/entity/Q24681897',
    'http://www.wikidata.org/entity/Q24681903',
    'http://www.wikidata.org/entity/Q24681977',
    'http://www.wikidata.org/entity/Q24682045',
    'http://www.wikidata.org/entity/Q24682089',
    'http://www.wikidata.org/entity/Q24682128',
    'http://www.wikidata.org/entity/Q24682139',
    'http://www.wikidata.org/entity/Q24682164',
    'http://www.wikidata.org/entity/Q24682183',
    'http://www.wikidata.org/entity/Q24682189',
    'http://www.wikidata.org/entity/Q24682328',
    'http://www.wikidata.org/entity/Q24682395',
    'http://www.wikidata.org/entity/Q24682405',
    'http://www.wikidata.org/entity/Q24682432',
    'http://www.wikidata.org/entity/Q24682442',
    'http://www.wikidata.org/entity/Q24682449',
    'http://www.wikidata.org/entity/Q24682473',
    'http://www.wikidata.org/entity/Q24682490',
    'http://www.wikidata.org/entity/Q24682492',
    'http://www.wikidata.org/entity/Q24682526',
    'http://www.wikidata.org/entity/Q24682564',
    'http://www.wikidata.org/entity/Q24682572',
    'http://www.wikidata.org/entity/Q24682617',
    'http://www.wikidata.org/entity/Q24682662',
    'http://www.wikidata.org/entity/Q24682664',
    'http://www.wikidata.org/entity/Q24682668',
    'http://www.wikidata.org/entity/Q24682697',
    'http://www.wikidata.org/entity/Q24682703',
    'http://www.wikidata.org/entity/Q24682725',
    'http://www.wikidata.org/entity/Q24682735',
    'http://www.wikidata.org/entity/Q24682750',
    'http://www.wikidata.org/entity/Q24682767',
    'http://www.wikidata.org/entity/Q24682825',
    'http://www.wikidata.org/entity/Q24682832',
    'http://www.wikidata.org/entity/Q24682901',
    'http://www.wikidata.org/entity/Q24682958',
    'http://www.wikidata.org/entity/Q24682965',
    'http://www.wikidata.org/entity/Q24682985',
    'http://www.wikidata.org/entity/Q24683018',
    'http://www.wikidata.org/entity/Q24683034',
    'http://www.wikidata.org/entity/Q24683059',
    'http://www.wikidata.org/entity/Q24683086',
    'http://www.wikidata.org/entity/Q24683089',
    'http://www.wikidata.org/entity/Q24683139',
    'http://www.wikidata.org/entity/Q24683198',
    'http://www.wikidata.org/entity/Q24683214',
    'http://www.wikidata.org/entity/Q24683234',
    'http://www.wikidata.org/entity/Q24683340',
    'http://www.wikidata.org/entity/Q24683359',
    'http://www.wikidata.org/entity/Q24683425',
    'http://www.wikidata.org/entity/Q24683474',
    'http://www.wikidata.org/entity/Q24683513',
    'http://www.wikidata.org/entity/Q24683561',
    'http://www.wikidata.org/entity/Q24683601',
    'http://www.wikidata.org/entity/Q24683623',
    'http://www.wikidata.org/entity/Q24683675',
    'http://www.wikidata.org/entity/Q24683689',
    'http://www.wikidata.org/entity/Q24683694',
    'http://www.wikidata.org/entity/Q24683709',
    'http://www.wikidata.org/entity/Q24683715',
    'http://www.wikidata.org/entity/Q24683719',
    'http://www.wikidata.org/entity/Q24683727',
    'http://www.wikidata.org/entity/Q24683749',
    'http://www.wikidata.org/entity/Q24683753',
    'http://www.wikidata.org/entity/Q24683755',
    'http://www.wikidata.org/entity/Q24683758',
    'http://www.wikidata.org/entity/Q24683764',
    'http://www.wikidata.org/entity/Q24683783',
    'http://www.wikidata.org/entity/Q24683813',
    'http://www.wikidata.org/entity/Q24683823',
    'http://www.wikidata.org/entity/Q24683835',
    'http://www.wikidata.org/entity/Q24683841',
    'http://www.wikidata.org/entity/Q24683860',
    'http://www.wikidata.org/entity/Q24683881',
    'http://www.wikidata.org/entity/Q24683936',
    'http://www.wikidata.org/entity/Q24683952',
    'http://www.wikidata.org/entity/Q24684007',
    'http://www.wikidata.org/entity/Q24684087',
    'http://www.wikidata.org/entity/Q24684122',
    'http://www.wikidata.org/entity/Q24684263',
    'http://www.wikidata.org/entity/Q24684264',
    'http://www.wikidata.org/entity/Q24684315',
    'http://www.wikidata.org/entity/Q24684324',
    'http://www.wikidata.org/entity/Q24684328',
    'http://www.wikidata.org/entity/Q24684363',
    'http://www.wikidata.org/entity/Q24684376',
    'http://www.wikidata.org/entity/Q24684530',
    'http://www.wikidata.org/entity/Q24684603',
    'http://www.wikidata.org/entity/Q24684627',
    'http://www.wikidata.org/entity/Q24684655',
    'http://www.wikidata.org/entity/Q24684673',
    'http://www.wikidata.org/entity/Q24684689',
    'http://www.wikidata.org/entity/Q24684691',
    'http://www.wikidata.org/entity/Q24684760',
    'http://www.wikidata.org/entity/Q24684767',
    'http://www.wikidata.org/entity/Q24684800',
    'http://www.wikidata.org/entity/Q24684976',
    'http://www.wikidata.org/entity/Q24685034',
    'http://www.wikidata.org/entity/Q24685097',
    'http://www.wikidata.org/entity/Q24685208',
    'http://www.wikidata.org/entity/Q24685210',
    'http://www.wikidata.org/entity/Q24685406',
    'http://www.wikidata.org/entity/Q24685451',
    'http://www.wikidata.org/entity/Q24685491',
    'http://www.wikidata.org/entity/Q24685515',
    'http://www.wikidata.org/entity/Q24685531',
    'http://www.wikidata.org/entity/Q24685540',
    'http://www.wikidata.org/entity/Q24685542',
    'http://www.wikidata.org/entity/Q24685585',
    'http://www.wikidata.org/entity/Q24685633',
    'http://www.wikidata.org/entity/Q24685670',
    'http://www.wikidata.org/entity/Q24685689',
    'http://www.wikidata.org/entity/Q24685694',
    'http://www.wikidata.org/entity/Q24685719',
    'http://www.wikidata.org/entity/Q24685735',
    'http://www.wikidata.org/entity/Q24685737',
    'http://www.wikidata.org/entity/Q24685744',
    'http://www.wikidata.org/entity/Q24685766',
    'http://www.wikidata.org/entity/Q24685772',
    'http://www.wikidata.org/entity/Q24685829',
    'http://www.wikidata.org/entity/Q24685864',
    'http://www.wikidata.org/entity/Q24685870',
    'http://www.wikidata.org/entity/Q24685928',
    'http://www.wikidata.org/entity/Q24685958',
    'http://www.wikidata.org/entity/Q24685967',
    'http://www.wikidata.org/entity/Q24685976',
    'http://www.wikidata.org/entity/Q24696014',
    'http://www.wikidata.org/entity/Q24696032',
    'http://www.wikidata.org/entity/Q24701143',
    'http://www.wikidata.org/entity/Q24704002',
    'http://www.wikidata.org/entity/Q24706476',
    'http://www.wikidata.org/entity/Q24706529',
    'http://www.wikidata.org/entity/Q24727083',
    'http://www.wikidata.org/entity/Q24727581',
    'http://www.wikidata.org/entity/Q24727662',
    'http://www.wikidata.org/entity/Q24727669',
    'http://www.wikidata.org/entity/Q24736362',
    'http://www.wikidata.org/entity/Q24736810',
    'http://www.wikidata.org/entity/Q24736974',
    'http://www.wikidata.org/entity/Q24736978',
    'http://www.wikidata.org/entity/Q24737245',
    'http://www.wikidata.org/entity/Q24737247',
    'http://www.wikidata.org/entity/Q24740325',
    'http://www.wikidata.org/entity/Q24791029',
    'http://www.wikidata.org/entity/Q24791095',
    'http://www.wikidata.org/entity/Q24791704',
    'http://www.wikidata.org/entity/Q24791763',
    'http://www.wikidata.org/entity/Q24791909',
    'http://www.wikidata.org/entity/Q24791911',
    'http://www.wikidata.org/entity/Q24792290',
    'http://www.wikidata.org/entity/Q24792436',
    'http://www.wikidata.org/entity/Q24792437',
    'http://www.wikidata.org/entity/Q24792528',
    'http://www.wikidata.org/entity/Q24792785',
    'http://www.wikidata.org/entity/Q24792949',
    'http://www.wikidata.org/entity/Q24792966',
    'http://www.wikidata.org/entity/Q24792989',
    'http://www.wikidata.org/entity/Q24793009',
    'http://www.wikidata.org/entity/Q24793432',
    'http://www.wikidata.org/entity/Q24793744',
    'http://www.wikidata.org/entity/Q24793761',
    'http://www.wikidata.org/entity/Q24793962',
    'http://www.wikidata.org/entity/Q24794075',
    'http://www.wikidata.org/entity/Q24794210',
    'http://www.wikidata.org/entity/Q24794279',
    'http://www.wikidata.org/entity/Q24794410',
    'http://www.wikidata.org/entity/Q24794415',
    'http://www.wikidata.org/entity/Q24794765',
    'http://www.wikidata.org/entity/Q24794803',
    'http://www.wikidata.org/entity/Q24794823',
    'http://www.wikidata.org/entity/Q24794838',
    'http://www.wikidata.org/entity/Q24794841',
    'http://www.wikidata.org/entity/Q24794858',
    'http://www.wikidata.org/entity/Q24794991',
    'http://www.wikidata.org/entity/Q24795001',
    'http://www.wikidata.org/entity/Q24795080',
    'http://www.wikidata.org/entity/Q24795202',
    'http://www.wikidata.org/entity/Q24795306',
    'http://www.wikidata.org/entity/Q24795413',
    'http://www.wikidata.org/entity/Q24795605',
    'http://www.wikidata.org/entity/Q24795912',
    'http://www.wikidata.org/entity/Q24796221',
    'http://www.wikidata.org/entity/Q24796444',
    'http://www.wikidata.org/entity/Q24796534',
    'http://www.wikidata.org/entity/Q24796722',
    'http://www.wikidata.org/entity/Q24796729',
    'http://www.wikidata.org/entity/Q24796748',
    'http://www.wikidata.org/entity/Q24796901',
    'http://www.wikidata.org/entity/Q24797230',
    'http://www.wikidata.org/entity/Q24797363',
    'http://www.wikidata.org/entity/Q24797650',
    'http://www.wikidata.org/entity/Q24797869',
    'http://www.wikidata.org/entity/Q24797901',
    'http://www.wikidata.org/entity/Q24797999',
    'http://www.wikidata.org/entity/Q24798075',
    'http://www.wikidata.org/entity/Q24798236',
    'http://www.wikidata.org/entity/Q24798247',
    'http://www.wikidata.org/entity/Q24798292',
    'http://www.wikidata.org/entity/Q24798446',
    'http://www.wikidata.org/entity/Q24798477',
    'http://www.wikidata.org/entity/Q24798872',
    'http://www.wikidata.org/entity/Q24798992',
    'http://www.wikidata.org/entity/Q24799251',
    'http://www.wikidata.org/entity/Q24799838',
    'http://www.wikidata.org/entity/Q24800187',
    'http://www.wikidata.org/entity/Q24800474',
    'http://www.wikidata.org/entity/Q24801397',
    'http://www.wikidata.org/entity/Q24801517',
    'http://www.wikidata.org/entity/Q24801650',
    'http://www.wikidata.org/entity/Q24801721',
    'http://www.wikidata.org/entity/Q24801782',
    'http://www.wikidata.org/entity/Q24802158',
    'http://www.wikidata.org/entity/Q24802293',
    'http://www.wikidata.org/entity/Q24802442',
    'http://www.wikidata.org/entity/Q24802513',
    'http://www.wikidata.org/entity/Q24803366',
    'http://www.wikidata.org/entity/Q24803717',
    'http://www.wikidata.org/entity/Q24803815',
    'http://www.wikidata.org/entity/Q24803937',
    'http://www.wikidata.org/entity/Q24803948',
    'http://www.wikidata.org/entity/Q24803997',
    'http://www.wikidata.org/entity/Q24804042',
    'http://www.wikidata.org/entity/Q24804164',
    'http://www.wikidata.org/entity/Q24804178',
    'http://www.wikidata.org/entity/Q24804305',
    'http://www.wikidata.org/entity/Q24804332',
    'http://www.wikidata.org/entity/Q24804384',
    'http://www.wikidata.org/entity/Q24804397',
    'http://www.wikidata.org/entity/Q24804528',
    'http://www.wikidata.org/entity/Q24804545',
    'http://www.wikidata.org/entity/Q24804747',
    'http://www.wikidata.org/entity/Q24804829',
    'http://www.wikidata.org/entity/Q24804840',
    'http://www.wikidata.org/entity/Q24804901',
    'http://www.wikidata.org/entity/Q24804947',
    'http://www.wikidata.org/entity/Q24805158',
    'http://www.wikidata.org/entity/Q24805247',
    'http://www.wikidata.org/entity/Q24805298',
    'http://www.wikidata.org/entity/Q24805414',
    'http://www.wikidata.org/entity/Q24805716',
    'http://www.wikidata.org/entity/Q24805950',
    'http://www.wikidata.org/entity/Q24806036',
    'http://www.wikidata.org/entity/Q24806173',
    'http://www.wikidata.org/entity/Q24806203',
    'http://www.wikidata.org/entity/Q24806306',
    'http://www.wikidata.org/entity/Q24806321',
    'http://www.wikidata.org/entity/Q24806674',
    'http://www.wikidata.org/entity/Q24806738',
    'http://www.wikidata.org/entity/Q24806860',
    'http://www.wikidata.org/entity/Q24807048',
    'http://www.wikidata.org/entity/Q24807126',
    'http://www.wikidata.org/entity/Q24809091',
    'http://www.wikidata.org/entity/Q24809535',
    'http://www.wikidata.org/entity/Q24810079',
    'http://www.wikidata.org/entity/Q24810080',
    'http://www.wikidata.org/entity/Q24810244',
    'http://www.wikidata.org/entity/Q24810449',
    'http://www.wikidata.org/entity/Q24810599',
    'http://www.wikidata.org/entity/Q24810610',
    'http://www.wikidata.org/entity/Q24810617',
    'http://www.wikidata.org/entity/Q24810727',
    'http://www.wikidata.org/entity/Q24810772',
    'http://www.wikidata.org/entity/Q24810845',
    'http://www.wikidata.org/entity/Q24810918',
    'http://www.wikidata.org/entity/Q24810926',
    'http://www.wikidata.org/entity/Q24811085',
    'http://www.wikidata.org/entity/Q24811111',
    'http://www.wikidata.org/entity/Q24811208',
    'http://www.wikidata.org/entity/Q24811242',
    'http://www.wikidata.org/entity/Q24811266',
    'http://www.wikidata.org/entity/Q24811302',
    'http://www.wikidata.org/entity/Q24811634',
    'http://www.wikidata.org/entity/Q24811812',
    'http://www.wikidata.org/entity/Q24811999',
    'http://www.wikidata.org/entity/Q24812173',
    'http://www.wikidata.org/entity/Q24812180',
    'http://www.wikidata.org/entity/Q24812184',
    'http://www.wikidata.org/entity/Q24812223',
    'http://www.wikidata.org/entity/Q24812232',
    'http://www.wikidata.org/entity/Q24812401',
    'http://www.wikidata.org/entity/Q24812490',
    'http://www.wikidata.org/entity/Q24812526',
    'http://www.wikidata.org/entity/Q24812633',
    'http://www.wikidata.org/entity/Q24812677',
    'http://www.wikidata.org/entity/Q24812921',
    'http://www.wikidata.org/entity/Q24813038',
    'http://www.wikidata.org/entity/Q24813189',
    'http://www.wikidata.org/entity/Q24813284',
    'http://www.wikidata.org/entity/Q24813335',
    'http://www.wikidata.org/entity/Q24813539',
    'http://www.wikidata.org/entity/Q24813541',
    'http://www.wikidata.org/entity/Q24813639',
    'http://www.wikidata.org/entity/Q24813731',
    'http://www.wikidata.org/entity/Q24814175',
    'http://www.wikidata.org/entity/Q24814239',
    'http://www.wikidata.org/entity/Q24814249',
    'http://www.wikidata.org/entity/Q24814256',
    'http://www.wikidata.org/entity/Q24814335',
    'http://www.wikidata.org/entity/Q24814388',
    'http://www.wikidata.org/entity/Q24814424',
    'http://www.wikidata.org/entity/Q24814460',
    'http://www.wikidata.org/entity/Q24814564',
    'http://www.wikidata.org/entity/Q24814569',
    'http://www.wikidata.org/entity/Q24814665',
    'http://www.wikidata.org/entity/Q24814719',
    'http://www.wikidata.org/entity/Q24814743',
    'http://www.wikidata.org/entity/Q24814806',
    'http://www.wikidata.org/entity/Q24814830',
    'http://www.wikidata.org/entity/Q24814846',
    'http://www.wikidata.org/entity/Q24814952',
    'http://www.wikidata.org/entity/Q24815080',
    'http://www.wikidata.org/entity/Q24815188',
    'http://www.wikidata.org/entity/Q24815196',
    'http://www.wikidata.org/entity/Q24815670',
    'http://www.wikidata.org/entity/Q24815752',
    'http://www.wikidata.org/entity/Q24815783',
    'http://www.wikidata.org/entity/Q24815866',
    'http://www.wikidata.org/entity/Q24816065',
    'http://www.wikidata.org/entity/Q24816302',
    'http://www.wikidata.org/entity/Q24816529',
    'http://www.wikidata.org/entity/Q24816825',
    'http://www.wikidata.org/entity/Q24816847',
    'http://www.wikidata.org/entity/Q24816949',
    'http://www.wikidata.org/entity/Q24817087',
    'http://www.wikidata.org/entity/Q24817116',
    'http://www.wikidata.org/entity/Q24817136',
    'http://www.wikidata.org/entity/Q24817140',
    'http://www.wikidata.org/entity/Q24817161',
    'http://www.wikidata.org/entity/Q24817162',
    'http://www.wikidata.org/entity/Q24817166',
    'http://www.wikidata.org/entity/Q24817192',
    'http://www.wikidata.org/entity/Q24981510',
    'http://www.wikidata.org/entity/Q25114980',
    'http://www.wikidata.org/entity/Q25138202',
    'http://www.wikidata.org/entity/Q25160538',
    'http://www.wikidata.org/entity/Q25161212',
    'http://www.wikidata.org/entity/Q25165129',
    'http://www.wikidata.org/entity/Q25197990',
    'http://www.wikidata.org/entity/Q25236928',
    'http://www.wikidata.org/entity/Q25254988',
    'http://www.wikidata.org/entity/Q25255374',
    'http://www.wikidata.org/entity/Q25255387',
    'http://www.wikidata.org/entity/Q25255440',
    'http://www.wikidata.org/entity/Q25255616',
    'http://www.wikidata.org/entity/Q25255623',
    'http://www.wikidata.org/entity/Q25255632',
    'http://www.wikidata.org/entity/Q25255639',
    'http://www.wikidata.org/entity/Q25255688',
    'http://www.wikidata.org/entity/Q25255837',
    'http://www.wikidata.org/entity/Q25256120',
    'http://www.wikidata.org/entity/Q25256194',
    'http://www.wikidata.org/entity/Q25256560',
    'http://www.wikidata.org/entity/Q25256568',
    'http://www.wikidata.org/entity/Q25256621',
    'http://www.wikidata.org/entity/Q25256662',
    'http://www.wikidata.org/entity/Q25256698',
    'http://www.wikidata.org/entity/Q25256737',
    'http://www.wikidata.org/entity/Q25256782',
    'http://www.wikidata.org/entity/Q25256837',
    'http://www.wikidata.org/entity/Q25256847',
    'http://www.wikidata.org/entity/Q25256955',
    'http://www.wikidata.org/entity/Q25256957',
    'http://www.wikidata.org/entity/Q25256990',
    'http://www.wikidata.org/entity/Q25257027',
    'http://www.wikidata.org/entity/Q25257103',
    'http://www.wikidata.org/entity/Q25257161',
    'http://www.wikidata.org/entity/Q25257163',
    'http://www.wikidata.org/entity/Q25257186',
    'http://www.wikidata.org/entity/Q25257200',
    'http://www.wikidata.org/entity/Q25257225',
    'http://www.wikidata.org/entity/Q25257250',
    'http://www.wikidata.org/entity/Q25257257',
    'http://www.wikidata.org/entity/Q25257443',
    'http://www.wikidata.org/entity/Q25257532',
    'http://www.wikidata.org/entity/Q25257582',
    'http://www.wikidata.org/entity/Q25257621',
    'http://www.wikidata.org/entity/Q25257646',
    'http://www.wikidata.org/entity/Q25257673',
    'http://www.wikidata.org/entity/Q25257710',
    'http://www.wikidata.org/entity/Q25257713',
    'http://www.wikidata.org/entity/Q25257813',
    'http://www.wikidata.org/entity/Q25257876',
    'http://www.wikidata.org/entity/Q25257913',
    'http://www.wikidata.org/entity/Q25855787',
    'http://www.wikidata.org/entity/Q25909434',
    'http://www.wikidata.org/entity/Q25938983',
    'http://www.wikidata.org/entity/Q25938984',
    'http://www.wikidata.org/entity/Q25938986',
    'http://www.wikidata.org/entity/Q25938987',
    'http://www.wikidata.org/entity/Q25938988',
    'http://www.wikidata.org/entity/Q25938989',
    'http://www.wikidata.org/entity/Q25938991',
    'http://www.wikidata.org/entity/Q25938995',
    'http://www.wikidata.org/entity/Q25938996',
    'http://www.wikidata.org/entity/Q25938997',
    'http://www.wikidata.org/entity/Q25938998',
    'http://www.wikidata.org/entity/Q25938999',
    'http://www.wikidata.org/entity/Q25939000',
    'http://www.wikidata.org/entity/Q25939001',
    'http://www.wikidata.org/entity/Q25939002',
    'http://www.wikidata.org/entity/Q25939003',
    'http://www.wikidata.org/entity/Q25939004',
    'http://www.wikidata.org/entity/Q25939005',
    'http://www.wikidata.org/entity/Q25939007',
    'http://www.wikidata.org/entity/Q25939009',
    'http://www.wikidata.org/entity/Q25939010',
    'http://www.wikidata.org/entity/Q26240914',
    'http://www.wikidata.org/entity/Q26240948',
    'http://www.wikidata.org/entity/Q26240980',
    'http://www.wikidata.org/entity/Q26240981',
    'http://www.wikidata.org/entity/Q26247236',
    'http://www.wikidata.org/entity/Q26248603',
    'http://www.wikidata.org/entity/Q26248722',
    'http://www.wikidata.org/entity/Q26250218',
    'http://www.wikidata.org/entity/Q26252076',
    'http://www.wikidata.org/entity/Q26252081',
    'http://www.wikidata.org/entity/Q26252507',
    'http://www.wikidata.org/entity/Q26253810',
    'http://www.wikidata.org/entity/Q26253918',
    'http://www.wikidata.org/entity/Q26253934',
    'http://www.wikidata.org/entity/Q26258575',
    'http://www.wikidata.org/entity/Q26258784',
    'http://www.wikidata.org/entity/Q26258808',
    'http://www.wikidata.org/entity/Q26269865',
    'http://www.wikidata.org/entity/Q26269875',
    'http://www.wikidata.org/entity/Q26269883',
    'http://www.wikidata.org/entity/Q26269923',
    'http://www.wikidata.org/entity/Q26269924',
    'http://www.wikidata.org/entity/Q26269955',
    'http://www.wikidata.org/entity/Q26269963',
    'http://www.wikidata.org/entity/Q26269981',
    'http://www.wikidata.org/entity/Q26283296',
    'http://www.wikidata.org/entity/Q26316619',
    'http://www.wikidata.org/entity/Q26337009',
    'http://www.wikidata.org/entity/Q26681254',
    'http://www.wikidata.org/entity/Q26699142',
    'http://www.wikidata.org/entity/Q26699951',
    'http://www.wikidata.org/entity/Q26701411',
    'http://www.wikidata.org/entity/Q26722178',
    'http://www.wikidata.org/entity/Q26722188',
    'http://www.wikidata.org/entity/Q26734731',
    'http://www.wikidata.org/entity/Q26745802',
    'http://www.wikidata.org/entity/Q26746069',
    'http://www.wikidata.org/entity/Q26747306',
    'http://www.wikidata.org/entity/Q26749528',
    'http://www.wikidata.org/entity/Q26749640',
    'http://www.wikidata.org/entity/Q26765421',
    'http://www.wikidata.org/entity/Q26765857',
    'http://www.wikidata.org/entity/Q26768286',
    'http://www.wikidata.org/entity/Q26775834',
    'http://www.wikidata.org/entity/Q26776972',
    'http://www.wikidata.org/entity/Q26776976',
    'http://www.wikidata.org/entity/Q26776977',
    'http://www.wikidata.org/entity/Q26776979',
    'http://www.wikidata.org/entity/Q26776980',
    'http://www.wikidata.org/entity/Q26778243',
    'http://www.wikidata.org/entity/Q26778365',
    'http://www.wikidata.org/entity/Q26778373',
    'http://www.wikidata.org/entity/Q26778378',
    'http://www.wikidata.org/entity/Q26778379',
    'http://www.wikidata.org/entity/Q26778382',
    'http://www.wikidata.org/entity/Q26778383',
    'http://www.wikidata.org/entity/Q26778386',
    'http://www.wikidata.org/entity/Q26778389',
    'http://www.wikidata.org/entity/Q26778398',
    'http://www.wikidata.org/entity/Q26778399',
    'http://www.wikidata.org/entity/Q26778400',
    'http://www.wikidata.org/entity/Q26778401',
    'http://www.wikidata.org/entity/Q26778405',
    'http://www.wikidata.org/entity/Q26778409',
    'http://www.wikidata.org/entity/Q26778411',
    'http://www.wikidata.org/entity/Q26778412',
    'http://www.wikidata.org/entity/Q26778418',
    'http://www.wikidata.org/entity/Q26778419',
    'http://www.wikidata.org/entity/Q26778422',
    'http://www.wikidata.org/entity/Q26778424',
    'http://www.wikidata.org/entity/Q26778425',
    'http://www.wikidata.org/entity/Q26778432',
    'http://www.wikidata.org/entity/Q26778434',
    'http://www.wikidata.org/entity/Q26778437',
    'http://www.wikidata.org/entity/Q26778438',
    'http://www.wikidata.org/entity/Q26778439',
    'http://www.wikidata.org/entity/Q26778446',
    'http://www.wikidata.org/entity/Q26778447',
    'http://www.wikidata.org/entity/Q26778451',
    'http://www.wikidata.org/entity/Q26778456',
    'http://www.wikidata.org/entity/Q26778457',
    'http://www.wikidata.org/entity/Q26778459',
    'http://www.wikidata.org/entity/Q26778460',
    'http://www.wikidata.org/entity/Q26778461',
    'http://www.wikidata.org/entity/Q26778468',
    'http://www.wikidata.org/entity/Q26778471',
    'http://www.wikidata.org/entity/Q26778473',
    'http://www.wikidata.org/entity/Q26778475',
    'http://www.wikidata.org/entity/Q26778476',
    'http://www.wikidata.org/entity/Q26778481',
    'http://www.wikidata.org/entity/Q26778486',
    'http://www.wikidata.org/entity/Q26778487',
    'http://www.wikidata.org/entity/Q26778490',
    'http://www.wikidata.org/entity/Q26778491',
    'http://www.wikidata.org/entity/Q26778503',
    'http://www.wikidata.org/entity/Q26778512',
    'http://www.wikidata.org/entity/Q26781970',
    'http://www.wikidata.org/entity/Q26782012',
    'http://www.wikidata.org/entity/Q26782024',
    'http://www.wikidata.org/entity/Q26782032',
    'http://www.wikidata.org/entity/Q26794965',
    'http://www.wikidata.org/entity/Q26796321',
    'http://www.wikidata.org/entity/Q26810001',
    'http://www.wikidata.org/entity/Q26820851',
    'http://www.wikidata.org/entity/Q26821770',
    'http://www.wikidata.org/entity/Q26822516',
    'http://www.wikidata.org/entity/Q26822642',
    'http://www.wikidata.org/entity/Q26822698',
    'http://www.wikidata.org/entity/Q26822812',
    'http://www.wikidata.org/entity/Q26822851',
    'http://www.wikidata.org/entity/Q26822855',
    'http://www.wikidata.org/entity/Q26823158',
    'http://www.wikidata.org/entity/Q26823272',
    'http://www.wikidata.org/entity/Q26823453',
    'http://www.wikidata.org/entity/Q26823804',
    'http://www.wikidata.org/entity/Q26823904',
    'http://www.wikidata.org/entity/Q26823948',
    'http://www.wikidata.org/entity/Q26824037',
    'http://www.wikidata.org/entity/Q26824140',
    'http://www.wikidata.org/entity/Q26824393',
    'http://www.wikidata.org/entity/Q26824566',
    'http://www.wikidata.org/entity/Q26824917',
    'http://www.wikidata.org/entity/Q26825385',
    'http://www.wikidata.org/entity/Q26825590',
    'http://www.wikidata.org/entity/Q26825750',
    'http://www.wikidata.org/entity/Q26825768',
    'http://www.wikidata.org/entity/Q26825935',
    'http://www.wikidata.org/entity/Q26825941',
    'http://www.wikidata.org/entity/Q26826833',
    'http://www.wikidata.org/entity/Q26826917',
    'http://www.wikidata.org/entity/Q26827525',
    'http://www.wikidata.org/entity/Q26827655',
    'http://www.wikidata.org/entity/Q26827666',
    'http://www.wikidata.org/entity/Q26827766',
    'http://www.wikidata.org/entity/Q26827770',
    'http://www.wikidata.org/entity/Q26827825',
    'http://www.wikidata.org/entity/Q26828371',
    'http://www.wikidata.org/entity/Q26828418',
    'http://www.wikidata.org/entity/Q26828473',
    'http://www.wikidata.org/entity/Q26828547',
    'http://www.wikidata.org/entity/Q26828939',
    'http://www.wikidata.org/entity/Q26828970',
    'http://www.wikidata.org/entity/Q26829180',
    'http://www.wikidata.org/entity/Q26829668',
    'http://www.wikidata.org/entity/Q26829865',
    'http://www.wikidata.org/entity/Q26829944',
    'http://www.wikidata.org/entity/Q26830008',
    'http://www.wikidata.org/entity/Q26830509',
    'http://www.wikidata.org/entity/Q26830626',
    'http://www.wikidata.org/entity/Q26830678',
    'http://www.wikidata.org/entity/Q26830838',
    'http://www.wikidata.org/entity/Q26830884',
    'http://www.wikidata.org/entity/Q26831376',
    'http://www.wikidata.org/entity/Q26849305',
    'http://www.wikidata.org/entity/Q26849399',
    'http://www.wikidata.org/entity/Q26849714',
    'http://www.wikidata.org/entity/Q26850196',
    'http://www.wikidata.org/entity/Q26850298',
    'http://www.wikidata.org/entity/Q26850396',
    'http://www.wikidata.org/entity/Q26850563',
    'http://www.wikidata.org/entity/Q26850610',
    'http://www.wikidata.org/entity/Q26851176',
    'http://www.wikidata.org/entity/Q26851285',
    'http://www.wikidata.org/entity/Q26851424',
    'http://www.wikidata.org/entity/Q26851591',
    'http://www.wikidata.org/entity/Q26851952',
    'http://www.wikidata.org/entity/Q26852023',
    'http://www.wikidata.org/entity/Q26852129',
    'http://www.wikidata.org/entity/Q26852310',
    'http://www.wikidata.org/entity/Q26852473',
    'http://www.wikidata.org/entity/Q26852697',
    'http://www.wikidata.org/entity/Q26853177',
    'http://www.wikidata.org/entity/Q26853518',
    'http://www.wikidata.org/entity/Q26858999',
    'http://www.wikidata.org/entity/Q26859055',
    'http://www.wikidata.org/entity/Q26859094',
    'http://www.wikidata.org/entity/Q26859134',
    'http://www.wikidata.org/entity/Q26859157',
    'http://www.wikidata.org/entity/Q26859195',
    'http://www.wikidata.org/entity/Q26859386',
    'http://www.wikidata.org/entity/Q26860162',
    'http://www.wikidata.org/entity/Q26861219',
    'http://www.wikidata.org/entity/Q26861513',
    'http://www.wikidata.org/entity/Q26861675',
    'http://www.wikidata.org/entity/Q26862535',
    'http://www.wikidata.org/entity/Q26862597',
    'http://www.wikidata.org/entity/Q26863439',
    'http://www.wikidata.org/entity/Q26863686',
    'http://www.wikidata.org/entity/Q26863704',
    'http://www.wikidata.org/entity/Q26863751',
    'http://www.wikidata.org/entity/Q26864238',
    'http://www.wikidata.org/entity/Q26864356',
    'http://www.wikidata.org/entity/Q26864589',
    'http://www.wikidata.org/entity/Q26864648',
    'http://www.wikidata.org/entity/Q26864798',
    'http://www.wikidata.org/entity/Q26864816',
    'http://www.wikidata.org/entity/Q26864854',
    'http://www.wikidata.org/entity/Q26864888',
    'http://www.wikidata.org/entity/Q26865273',
    'http://www.wikidata.org/entity/Q26865284',
    'http://www.wikidata.org/entity/Q26865432',
    'http://www.wikidata.org/entity/Q26865504',
    'http://www.wikidata.org/entity/Q26865588',
    'http://www.wikidata.org/entity/Q26865723',
    'http://www.wikidata.org/entity/Q26865943',
    'http://www.wikidata.org/entity/Q26866096',
    'http://www.wikidata.org/entity/Q26866448',
    'http://www.wikidata.org/entity/Q26904459',
    'http://www.wikidata.org/entity/Q26991488',
    'http://www.wikidata.org/entity/Q26991572',
    'http://www.wikidata.org/entity/Q26991871',
    'http://www.wikidata.org/entity/Q26991873',
    'http://www.wikidata.org/entity/Q26991907',
    'http://www.wikidata.org/entity/Q26992045',
    'http://www.wikidata.org/entity/Q26992067',
    'http://www.wikidata.org/entity/Q26992233',
    'http://www.wikidata.org/entity/Q26992245',
    'http://www.wikidata.org/entity/Q26995336',
    'http://www.wikidata.org/entity/Q26995343',
    'http://www.wikidata.org/entity/Q26995720',
    'http://www.wikidata.org/entity/Q26995797',
    'http://www.wikidata.org/entity/Q26996386',
    'http://www.wikidata.org/entity/Q26996388',
    'http://www.wikidata.org/entity/Q26996441',
    'http://www.wikidata.org/entity/Q26996497',
    'http://www.wikidata.org/entity/Q26996605',
    'http://www.wikidata.org/entity/Q26996783',
    'http://www.wikidata.org/entity/Q26998075',
    'http://www.wikidata.org/entity/Q26998106',
    'http://www.wikidata.org/entity/Q26998422',
    'http://www.wikidata.org/entity/Q26998580',
    'http://www.wikidata.org/entity/Q26998599',
    'http://www.wikidata.org/entity/Q26998967',
    'http://www.wikidata.org/entity/Q26999711',
    'http://www.wikidata.org/entity/Q27000017',
    'http://www.wikidata.org/entity/Q27000167',
    'http://www.wikidata.org/entity/Q27000191',
    'http://www.wikidata.org/entity/Q27000334',
    'http://www.wikidata.org/entity/Q27000361',
    'http://www.wikidata.org/entity/Q27000491',
    'http://www.wikidata.org/entity/Q27000789',
    'http://www.wikidata.org/entity/Q27001186',
    'http://www.wikidata.org/entity/Q27001190',
    'http://www.wikidata.org/entity/Q27001240',
    'http://www.wikidata.org/entity/Q27001694',
    'http://www.wikidata.org/entity/Q27002456',
    'http://www.wikidata.org/entity/Q27002487',
    'http://www.wikidata.org/entity/Q27003069',
    'http://www.wikidata.org/entity/Q27003296',
    'http://www.wikidata.org/entity/Q27003314',
    'http://www.wikidata.org/entity/Q27003371',
    'http://www.wikidata.org/entity/Q27003964',
    'http://www.wikidata.org/entity/Q27004052',
    'http://www.wikidata.org/entity/Q27004360',
    'http://www.wikidata.org/entity/Q27004417',
    'http://www.wikidata.org/entity/Q27004487',
    'http://www.wikidata.org/entity/Q27006033',
    'http://www.wikidata.org/entity/Q27006715',
    'http://www.wikidata.org/entity/Q27006748',
    'http://www.wikidata.org/entity/Q27006831',
    'http://www.wikidata.org/entity/Q27007030',
    'http://www.wikidata.org/entity/Q27007091',
    'http://www.wikidata.org/entity/Q27008020',
    'http://www.wikidata.org/entity/Q27008342',
    'http://www.wikidata.org/entity/Q27009015',
    'http://www.wikidata.org/entity/Q27009044',
    'http://www.wikidata.org/entity/Q27009206',
    'http://www.wikidata.org/entity/Q27009249',
    'http://www.wikidata.org/entity/Q27010013',
    'http://www.wikidata.org/entity/Q27010076',
    'http://www.wikidata.org/entity/Q27010210',
    'http://www.wikidata.org/entity/Q27010263',
    'http://www.wikidata.org/entity/Q27010271',
    'http://www.wikidata.org/entity/Q27010273',
    'http://www.wikidata.org/entity/Q27011259',
    'http://www.wikidata.org/entity/Q27011356',
    'http://www.wikidata.org/entity/Q27011574',
    'http://www.wikidata.org/entity/Q27011598',
    'http://www.wikidata.org/entity/Q27011920',
    'http://www.wikidata.org/entity/Q27012569',
    'http://www.wikidata.org/entity/Q27012652',
    'http://www.wikidata.org/entity/Q27012984',
    'http://www.wikidata.org/entity/Q27013032',
    'http://www.wikidata.org/entity/Q27013561',
    'http://www.wikidata.org/entity/Q27013579',
    'http://www.wikidata.org/entity/Q27013736',
    'http://www.wikidata.org/entity/Q27013743',
    'http://www.wikidata.org/entity/Q27013770',
    'http://www.wikidata.org/entity/Q27013841',
    'http://www.wikidata.org/entity/Q27013917',
    'http://www.wikidata.org/entity/Q27014828',
    'http://www.wikidata.org/entity/Q27015585',
    'http://www.wikidata.org/entity/Q27015887',
    'http://www.wikidata.org/entity/Q27020961',
    'http://www.wikidata.org/entity/Q27021135',
    'http://www.wikidata.org/entity/Q27021428',
    'http://www.wikidata.org/entity/Q27021885',
    'http://www.wikidata.org/entity/Q27021937',
    'http://www.wikidata.org/entity/Q27022032',
    'http://www.wikidata.org/entity/Q27022289',
    'http://www.wikidata.org/entity/Q27022325',
    'http://www.wikidata.org/entity/Q27022410',
    'http://www.wikidata.org/entity/Q27022482',
    'http://www.wikidata.org/entity/Q27022560',
    'http://www.wikidata.org/entity/Q27022650',
    'http://www.wikidata.org/entity/Q27023027',
    'http://www.wikidata.org/entity/Q27023060',
    'http://www.wikidata.org/entity/Q27023277',
    'http://www.wikidata.org/entity/Q27023837',
    'http://www.wikidata.org/entity/Q27024088',
    'http://www.wikidata.org/entity/Q27024237',
    'http://www.wikidata.org/entity/Q27024382',
    'http://www.wikidata.org/entity/Q27024882',
    'http://www.wikidata.org/entity/Q27025091',
    'http://www.wikidata.org/entity/Q27025515',
    'http://www.wikidata.org/entity/Q27025586',
    'http://www.wikidata.org/entity/Q27025886',
    'http://www.wikidata.org/entity/Q27025956',
    'http://www.wikidata.org/entity/Q27026110',
    'http://www.wikidata.org/entity/Q27026533',
    'http://www.wikidata.org/entity/Q27026614',
    'http://www.wikidata.org/entity/Q27026645',
    'http://www.wikidata.org/entity/Q27026705',
    'http://www.wikidata.org/entity/Q27026840',
    'http://www.wikidata.org/entity/Q27027517',
    'http://www.wikidata.org/entity/Q27027638',
    'http://www.wikidata.org/entity/Q27027939',
    'http://www.wikidata.org/entity/Q27027950',
    'http://www.wikidata.org/entity/Q27028155',
    'http://www.wikidata.org/entity/Q27030819',
    'http://www.wikidata.org/entity/Q27037290',
    'http://www.wikidata.org/entity/Q27061829',
    'http://www.wikidata.org/entity/Q27061937',
    'http://www.wikidata.org/entity/Q27087751',
    'http://www.wikidata.org/entity/Q27098541',
    'http://www.wikidata.org/entity/Q27104011',
    'http://www.wikidata.org/entity/Q27107337',
    'http://www.wikidata.org/entity/Q27136473',
    'http://www.wikidata.org/entity/Q27136827',
    'http://www.wikidata.org/entity/Q27136845',
    'http://www.wikidata.org/entity/Q27144102',
    'http://www.wikidata.org/entity/Q27144176',
    'http://www.wikidata.org/entity/Q27144224',
    'http://www.wikidata.org/entity/Q27230048',
    'http://www.wikidata.org/entity/Q27230081',
    'http://www.wikidata.org/entity/Q27230870',
    'http://www.wikidata.org/entity/Q27231406',
    'http://www.wikidata.org/entity/Q27301328',
    'http://www.wikidata.org/entity/Q27301343',
    'http://www.wikidata.org/entity/Q27302134',
    'http://www.wikidata.org/entity/Q27303562',
    'http://www.wikidata.org/entity/Q27303723',
    'http://www.wikidata.org/entity/Q27307172',
    'http://www.wikidata.org/entity/Q27307675',
    'http://www.wikidata.org/entity/Q27308814',
    'http://www.wikidata.org/entity/Q27310243',
    'http://www.wikidata.org/entity/Q27310252',
    'http://www.wikidata.org/entity/Q27310261',
    'http://www.wikidata.org/entity/Q27311570',
    'http://www.wikidata.org/entity/Q27311815',
    'http://www.wikidata.org/entity/Q27312083',
    'http://www.wikidata.org/entity/Q27313378',
    'http://www.wikidata.org/entity/Q27313623',
    'http://www.wikidata.org/entity/Q27313630',
    'http://www.wikidata.org/entity/Q27314537',
    'http://www.wikidata.org/entity/Q27314538',
    'http://www.wikidata.org/entity/Q27315174',
    'http://www.wikidata.org/entity/Q27315772',
    'http://www.wikidata.org/entity/Q27315912',
    'http://www.wikidata.org/entity/Q27316166',
    'http://www.wikidata.org/entity/Q27316324',
    'http://www.wikidata.org/entity/Q27316453',
    'http://www.wikidata.org/entity/Q27316769',
    'http://www.wikidata.org/entity/Q27317206',
    'http://www.wikidata.org/entity/Q27318086',
    'http://www.wikidata.org/entity/Q27318203',
    'http://www.wikidata.org/entity/Q27318396',
    'http://www.wikidata.org/entity/Q27318750',
    'http://www.wikidata.org/entity/Q27319185',
    'http://www.wikidata.org/entity/Q27319538',
    'http://www.wikidata.org/entity/Q27321104',
    'http://www.wikidata.org/entity/Q27321802',
    'http://www.wikidata.org/entity/Q27322410',
    'http://www.wikidata.org/entity/Q27322515',
    'http://www.wikidata.org/entity/Q27322706',
    'http://www.wikidata.org/entity/Q27322943',
    'http://www.wikidata.org/entity/Q27323028',
    'http://www.wikidata.org/entity/Q27323145',
    'http://www.wikidata.org/entity/Q27323319',
    'http://www.wikidata.org/entity/Q27323997',
    'http://www.wikidata.org/entity/Q27324199',
    'http://www.wikidata.org/entity/Q27331839',
    'http://www.wikidata.org/entity/Q27332199',
    'http://www.wikidata.org/entity/Q27332392',
    'http://www.wikidata.org/entity/Q27332814',
    'http://www.wikidata.org/entity/Q27334139',
    'http://www.wikidata.org/entity/Q27335248',
    'http://www.wikidata.org/entity/Q27335737',
    'http://www.wikidata.org/entity/Q27336009',
    'http://www.wikidata.org/entity/Q27336076',
    'http://www.wikidata.org/entity/Q27339447',
    'http://www.wikidata.org/entity/Q27339566',
    'http://www.wikidata.org/entity/Q27339604',
    'http://www.wikidata.org/entity/Q27339986',
    'http://www.wikidata.org/entity/Q27340359',
    'http://www.wikidata.org/entity/Q27342464',
    'http://www.wikidata.org/entity/Q27345215',
    'http://www.wikidata.org/entity/Q27345294',
    'http://www.wikidata.org/entity/Q27346475',
    'http://www.wikidata.org/entity/Q27346893',
    'http://www.wikidata.org/entity/Q27347225',
    'http://www.wikidata.org/entity/Q27347231',
    'http://www.wikidata.org/entity/Q27347515',
    'http://www.wikidata.org/entity/Q27347595',
    'http://www.wikidata.org/entity/Q27347813',
    'http://www.wikidata.org/entity/Q27348022',
    'http://www.wikidata.org/entity/Q27348355',
    'http://www.wikidata.org/entity/Q27348561',
    'http://www.wikidata.org/entity/Q27348772',
    'http://www.wikidata.org/entity/Q27349023',
    'http://www.wikidata.org/entity/Q27349128',
    'http://www.wikidata.org/entity/Q27349223',
    'http://www.wikidata.org/entity/Q27349227',
    'http://www.wikidata.org/entity/Q27349399',
    'http://www.wikidata.org/entity/Q27349505',
    'http://www.wikidata.org/entity/Q27349568',
    'http://www.wikidata.org/entity/Q27349678',
    'http://www.wikidata.org/entity/Q27349833',
    'http://www.wikidata.org/entity/Q27350073',
    'http://www.wikidata.org/entity/Q27350165',
    'http://www.wikidata.org/entity/Q27350287',
    'http://www.wikidata.org/entity/Q27350336',
    'http://www.wikidata.org/entity/Q27439250',
    'http://www.wikidata.org/entity/Q27440259',
    'http://www.wikidata.org/entity/Q27448679',
    'http://www.wikidata.org/entity/Q27450342',
    'http://www.wikidata.org/entity/Q27450690',
    'http://www.wikidata.org/entity/Q27450819',
    'http://www.wikidata.org/entity/Q27450852',
    'http://www.wikidata.org/entity/Q27468570',
    'http://www.wikidata.org/entity/Q27468757',
    'http://www.wikidata.org/entity/Q27469155',
    'http://www.wikidata.org/entity/Q27469278',
    'http://www.wikidata.org/entity/Q27469307',
    'http://www.wikidata.org/entity/Q27469339',
    'http://www.wikidata.org/entity/Q27469358',
    'http://www.wikidata.org/entity/Q27469369',
    'http://www.wikidata.org/entity/Q27469442',
    'http://www.wikidata.org/entity/Q27469500',
    'http://www.wikidata.org/entity/Q27469507',
    'http://www.wikidata.org/entity/Q27469591',
    'http://www.wikidata.org/entity/Q27469599',
    'http://www.wikidata.org/entity/Q27469634',
    'http://www.wikidata.org/entity/Q27469636',
    'http://www.wikidata.org/entity/Q27469653',
    'http://www.wikidata.org/entity/Q27469687',
    'http://www.wikidata.org/entity/Q27469692',
    'http://www.wikidata.org/entity/Q27469705',
    'http://www.wikidata.org/entity/Q27469713',
    'http://www.wikidata.org/entity/Q27469769',
    'http://www.wikidata.org/entity/Q27469785',
    'http://www.wikidata.org/entity/Q27469794',
    'http://www.wikidata.org/entity/Q27469800',
    'http://www.wikidata.org/entity/Q27469830',
    'http://www.wikidata.org/entity/Q27469833',
    'http://www.wikidata.org/entity/Q27469837',
    'http://www.wikidata.org/entity/Q27469841',
    'http://www.wikidata.org/entity/Q27469844',
    'http://www.wikidata.org/entity/Q27469847',
    'http://www.wikidata.org/entity/Q27469848',
    'http://www.wikidata.org/entity/Q27469850',
    'http://www.wikidata.org/entity/Q27469877',
    'http://www.wikidata.org/entity/Q27469896',
    'http://www.wikidata.org/entity/Q27469935',
    'http://www.wikidata.org/entity/Q27469963',
    'http://www.wikidata.org/entity/Q27469999',
    'http://www.wikidata.org/entity/Q27470013',
    'http://www.wikidata.org/entity/Q27470232',
    'http://www.wikidata.org/entity/Q27470828',
    'http://www.wikidata.org/entity/Q27471311',
    'http://www.wikidata.org/entity/Q27471857',
    'http://www.wikidata.org/entity/Q27471916',
    'http://www.wikidata.org/entity/Q27472136',
    'http://www.wikidata.org/entity/Q27472605',
    'http://www.wikidata.org/entity/Q27472613',
    'http://www.wikidata.org/entity/Q27472669',
    'http://www.wikidata.org/entity/Q27472670',
    'http://www.wikidata.org/entity/Q27472850',
    'http://www.wikidata.org/entity/Q27472873',
    'http://www.wikidata.org/entity/Q27472878',
    'http://www.wikidata.org/entity/Q27472881',
    'http://www.wikidata.org/entity/Q27472884',
    'http://www.wikidata.org/entity/Q27472912',
    'http://www.wikidata.org/entity/Q27472922',
    'http://www.wikidata.org/entity/Q27472926',
    'http://www.wikidata.org/entity/Q27472963',
    'http://www.wikidata.org/entity/Q27472973',
    'http://www.wikidata.org/entity/Q27473001',
    'http://www.wikidata.org/entity/Q27473003',
    'http://www.wikidata.org/entity/Q27473041',
    'http://www.wikidata.org/entity/Q27473044',
    'http://www.wikidata.org/entity/Q27473048',
    'http://www.wikidata.org/entity/Q27473066',
    'http://www.wikidata.org/entity/Q27473080',
    'http://www.wikidata.org/entity/Q27473088',
    'http://www.wikidata.org/entity/Q27473103',
    'http://www.wikidata.org/entity/Q27473106',
    'http://www.wikidata.org/entity/Q27473134',
    'http://www.wikidata.org/entity/Q27473138',
    'http://www.wikidata.org/entity/Q27473147',
    'http://www.wikidata.org/entity/Q27473179',
    'http://www.wikidata.org/entity/Q27473186',
    'http://www.wikidata.org/entity/Q27473194',
    'http://www.wikidata.org/entity/Q27473213',
    'http://www.wikidata.org/entity/Q27473226',
    'http://www.wikidata.org/entity/Q27473290',
    'http://www.wikidata.org/entity/Q27473339',
    'http://www.wikidata.org/entity/Q27473345',
    'http://www.wikidata.org/entity/Q27473377',
    'http://www.wikidata.org/entity/Q27473379',
    'http://www.wikidata.org/entity/Q27473433',
    'http://www.wikidata.org/entity/Q27473436',
    'http://www.wikidata.org/entity/Q27473455',
    'http://www.wikidata.org/entity/Q27473464',
    'http://www.wikidata.org/entity/Q27473471',
    'http://www.wikidata.org/entity/Q27473511',
    'http://www.wikidata.org/entity/Q27477468',
    'http://www.wikidata.org/entity/Q27477478',
    'http://www.wikidata.org/entity/Q27477543',
    'http://www.wikidata.org/entity/Q27477546',
    'http://www.wikidata.org/entity/Q27477548',
    'http://www.wikidata.org/entity/Q27477554',
    'http://www.wikidata.org/entity/Q27477600',
    'http://www.wikidata.org/entity/Q27477625',
    'http://www.wikidata.org/entity/Q27477628',
    'http://www.wikidata.org/entity/Q27477646',
    'http://www.wikidata.org/entity/Q27477652',
    'http://www.wikidata.org/entity/Q27477685',
    'http://www.wikidata.org/entity/Q27477687',
    'http://www.wikidata.org/entity/Q27477718',
    'http://www.wikidata.org/entity/Q27477735',
    'http://www.wikidata.org/entity/Q27478033',
    'http://www.wikidata.org/entity/Q27478044',
    'http://www.wikidata.org/entity/Q27478080',
    'http://www.wikidata.org/entity/Q27478188',
    'http://www.wikidata.org/entity/Q27478245',
    'http://www.wikidata.org/entity/Q27478257',
    'http://www.wikidata.org/entity/Q27478292',
    'http://www.wikidata.org/entity/Q27478359',
    'http://www.wikidata.org/entity/Q27478364',
    'http://www.wikidata.org/entity/Q27480348',
    'http://www.wikidata.org/entity/Q27480349',
    'http://www.wikidata.org/entity/Q27480369',
    'http://www.wikidata.org/entity/Q27480373',
    'http://www.wikidata.org/entity/Q27480384',
    'http://www.wikidata.org/entity/Q27480875',
    'http://www.wikidata.org/entity/Q27480890',
    'http://www.wikidata.org/entity/Q27480892',
    'http://www.wikidata.org/entity/Q27480902',
    'http://www.wikidata.org/entity/Q27481018',
    'http://www.wikidata.org/entity/Q27481061',
    'http://www.wikidata.org/entity/Q27481085',
    'http://www.wikidata.org/entity/Q27481401',
    'http://www.wikidata.org/entity/Q27481484',
    'http://www.wikidata.org/entity/Q27481508',
    'http://www.wikidata.org/entity/Q27482900',
    'http://www.wikidata.org/entity/Q27484980',
    'http://www.wikidata.org/entity/Q27484985',
    'http://www.wikidata.org/entity/Q27485012',
    'http://www.wikidata.org/entity/Q27485031',
    'http://www.wikidata.org/entity/Q27485033',
    'http://www.wikidata.org/entity/Q27485050',
    'http://www.wikidata.org/entity/Q27485119',
    'http://www.wikidata.org/entity/Q27485121',
    'http://www.wikidata.org/entity/Q27485124',
    'http://www.wikidata.org/entity/Q27485131',
    'http://www.wikidata.org/entity/Q27485189',
    'http://www.wikidata.org/entity/Q27485216',
    'http://www.wikidata.org/entity/Q27485219',
    'http://www.wikidata.org/entity/Q27485222',
    'http://www.wikidata.org/entity/Q27485301',
    'http://www.wikidata.org/entity/Q27485306',
    'http://www.wikidata.org/entity/Q27485386',
    'http://www.wikidata.org/entity/Q27485447',
    'http://www.wikidata.org/entity/Q27485476',
    'http://www.wikidata.org/entity/Q27485484',
    'http://www.wikidata.org/entity/Q27485485',
    'http://www.wikidata.org/entity/Q27485487',
    'http://www.wikidata.org/entity/Q27485634',
    'http://www.wikidata.org/entity/Q27485867',
    'http://www.wikidata.org/entity/Q27485871',
    'http://www.wikidata.org/entity/Q27485872',
    'http://www.wikidata.org/entity/Q27485926',
    'http://www.wikidata.org/entity/Q27485996',
    'http://www.wikidata.org/entity/Q27486022',
    'http://www.wikidata.org/entity/Q27486083',
    'http://www.wikidata.org/entity/Q27486092',
    'http://www.wikidata.org/entity/Q27486103',
    'http://www.wikidata.org/entity/Q27486121',
    'http://www.wikidata.org/entity/Q27486195',
    'http://www.wikidata.org/entity/Q27486210',
    'http://www.wikidata.org/entity/Q27486220',
    'http://www.wikidata.org/entity/Q27486234',
    'http://www.wikidata.org/entity/Q27486375',
    'http://www.wikidata.org/entity/Q27486384',
    'http://www.wikidata.org/entity/Q27486388',
    'http://www.wikidata.org/entity/Q27486409',
    'http://www.wikidata.org/entity/Q27486434',
    'http://www.wikidata.org/entity/Q27486541',
    'http://www.wikidata.org/entity/Q27486581',
    'http://www.wikidata.org/entity/Q27486606',
    'http://www.wikidata.org/entity/Q27486638',
    'http://www.wikidata.org/entity/Q27486639',
    'http://www.wikidata.org/entity/Q27486640',
    'http://www.wikidata.org/entity/Q27486780',
    'http://www.wikidata.org/entity/Q27486783',
    'http://www.wikidata.org/entity/Q27486788',
    'http://www.wikidata.org/entity/Q27486790',
    'http://www.wikidata.org/entity/Q27486828',
    'http://www.wikidata.org/entity/Q27486832',
    'http://www.wikidata.org/entity/Q27486912',
    'http://www.wikidata.org/entity/Q27486915',
    'http://www.wikidata.org/entity/Q27486997',
    'http://www.wikidata.org/entity/Q27487003',
    'http://www.wikidata.org/entity/Q27487105',
    'http://www.wikidata.org/entity/Q27487120',
    'http://www.wikidata.org/entity/Q27487310',
    'http://www.wikidata.org/entity/Q27487319',
    'http://www.wikidata.org/entity/Q27487321',
    'http://www.wikidata.org/entity/Q27487327',
    'http://www.wikidata.org/entity/Q27487347',
    'http://www.wikidata.org/entity/Q27487385',
    'http://www.wikidata.org/entity/Q27487567',
    'http://www.wikidata.org/entity/Q27487580',
    'http://www.wikidata.org/entity/Q27487590',
    'http://www.wikidata.org/entity/Q27487726',
    'http://www.wikidata.org/entity/Q27487748',
    'http://www.wikidata.org/entity/Q27487794',
    'http://www.wikidata.org/entity/Q27487801',
    'http://www.wikidata.org/entity/Q27487802',
    'http://www.wikidata.org/entity/Q27487819',
    'http://www.wikidata.org/entity/Q27487848',
    'http://www.wikidata.org/entity/Q27487869',
    'http://www.wikidata.org/entity/Q27487874',
    'http://www.wikidata.org/entity/Q27487933',
    'http://www.wikidata.org/entity/Q27487947',
    'http://www.wikidata.org/entity/Q27487974',
    'http://www.wikidata.org/entity/Q27488224',
    'http://www.wikidata.org/entity/Q27488252',
    'http://www.wikidata.org/entity/Q27488278',
    'http://www.wikidata.org/entity/Q27488324',
    'http://www.wikidata.org/entity/Q27488360',
    'http://www.wikidata.org/entity/Q27488364',
    'http://www.wikidata.org/entity/Q27488536',
    'http://www.wikidata.org/entity/Q27488844',
    'http://www.wikidata.org/entity/Q27489075',
    'http://www.wikidata.org/entity/Q27489120',
    'http://www.wikidata.org/entity/Q27489377',
    'http://www.wikidata.org/entity/Q27489411',
    'http://www.wikidata.org/entity/Q27489547',
    'http://www.wikidata.org/entity/Q27489550',
    'http://www.wikidata.org/entity/Q27489654',
    'http://www.wikidata.org/entity/Q27489711',
    'http://www.wikidata.org/entity/Q27489773',
    'http://www.wikidata.org/entity/Q27489843',
    'http://www.wikidata.org/entity/Q27489852',
    'http://www.wikidata.org/entity/Q27489888',
    'http://www.wikidata.org/entity/Q27490169',
    'http://www.wikidata.org/entity/Q27490202',
    'http://www.wikidata.org/entity/Q27490244',
    'http://www.wikidata.org/entity/Q27490273',
    'http://www.wikidata.org/entity/Q27490467',
    'http://www.wikidata.org/entity/Q27490474',
    'http://www.wikidata.org/entity/Q27490481',
    'http://www.wikidata.org/entity/Q27490520',
    'http://www.wikidata.org/entity/Q27490592',
    'http://www.wikidata.org/entity/Q27490746',
    'http://www.wikidata.org/entity/Q27490789',
    'http://www.wikidata.org/entity/Q27490947',
    'http://www.wikidata.org/entity/Q27490948',
    'http://www.wikidata.org/entity/Q27490962',
    'http://www.wikidata.org/entity/Q27490982',
    'http://www.wikidata.org/entity/Q27490991',
    'http://www.wikidata.org/entity/Q27491029',
    'http://www.wikidata.org/entity/Q27491036',
    'http://www.wikidata.org/entity/Q27491317',
    'http://www.wikidata.org/entity/Q27491318',
    'http://www.wikidata.org/entity/Q27496468',
    'http://www.wikidata.org/entity/Q27496507',
    'http://www.wikidata.org/entity/Q27496627',
    'http://www.wikidata.org/entity/Q27497347',
    'http://www.wikidata.org/entity/Q27497968',
    'http://www.wikidata.org/entity/Q27498993',
    'http://www.wikidata.org/entity/Q27499374',
    'http://www.wikidata.org/entity/Q27499384',
    'http://www.wikidata.org/entity/Q27499675',
    'http://www.wikidata.org/entity/Q27500386',
    'http://www.wikidata.org/entity/Q27500451',
    'http://www.wikidata.org/entity/Q27559610',
    'http://www.wikidata.org/entity/Q27575818',
    'http://www.wikidata.org/entity/Q27617913',
    'http://www.wikidata.org/entity/Q27618141',
    'http://www.wikidata.org/entity/Q27618244',
    'http://www.wikidata.org/entity/Q27618504',
    'http://www.wikidata.org/entity/Q27618957',
    'http://www.wikidata.org/entity/Q27619358',
    'http://www.wikidata.org/entity/Q27619483',
    'http://www.wikidata.org/entity/Q27619648',
    'http://www.wikidata.org/entity/Q27619751',
    'http://www.wikidata.org/entity/Q27619753',
    'http://www.wikidata.org/entity/Q27619818',
    'http://www.wikidata.org/entity/Q27619935',
    'http://www.wikidata.org/entity/Q27619994',
    'http://www.wikidata.org/entity/Q27620298',
    'http://www.wikidata.org/entity/Q27620360',
    'http://www.wikidata.org/entity/Q27620424',
    'http://www.wikidata.org/entity/Q27620480',
    'http://www.wikidata.org/entity/Q27620845',
    'http://www.wikidata.org/entity/Q27621012',
    'http://www.wikidata.org/entity/Q27621166',
    'http://www.wikidata.org/entity/Q27621547',
    'http://www.wikidata.org/entity/Q27621595',
    'http://www.wikidata.org/entity/Q27621605',
    'http://www.wikidata.org/entity/Q27621681',
    'http://www.wikidata.org/entity/Q27622657',
    'http://www.wikidata.org/entity/Q27625023',
    'http://www.wikidata.org/entity/Q27625163',
    'http://www.wikidata.org/entity/Q27625224',
    'http://www.wikidata.org/entity/Q27625390',
    'http://www.wikidata.org/entity/Q27625570',
    'http://www.wikidata.org/entity/Q27625936',
    'http://www.wikidata.org/entity/Q27625972',
    'http://www.wikidata.org/entity/Q27626400',
    'http://www.wikidata.org/entity/Q27626414',
    'http://www.wikidata.org/entity/Q27626747',
    'http://www.wikidata.org/entity/Q27626911',
    'http://www.wikidata.org/entity/Q27627220',
    'http://www.wikidata.org/entity/Q27627261',
    'http://www.wikidata.org/entity/Q27627265',
    'http://www.wikidata.org/entity/Q27627493',
    'http://www.wikidata.org/entity/Q27627664',
    'http://www.wikidata.org/entity/Q27627919',
    'http://www.wikidata.org/entity/Q27627995',
    'http://www.wikidata.org/entity/Q27628650',
    'http://www.wikidata.org/entity/Q27628839',
    'http://www.wikidata.org/entity/Q27629039',
    'http://www.wikidata.org/entity/Q27629536',
    'http://www.wikidata.org/entity/Q27629975',
    'http://www.wikidata.org/entity/Q27630442',
    'http://www.wikidata.org/entity/Q27630949',
    'http://www.wikidata.org/entity/Q27631047',
    'http://www.wikidata.org/entity/Q27631190',
    'http://www.wikidata.org/entity/Q27631276',
    'http://www.wikidata.org/entity/Q27631606',
    'http://www.wikidata.org/entity/Q27631717',
    'http://www.wikidata.org/entity/Q27631812',
    'http://www.wikidata.org/entity/Q27632025',
    'http://www.wikidata.org/entity/Q27632278',
    'http://www.wikidata.org/entity/Q27632715',
    'http://www.wikidata.org/entity/Q27633064',
    'http://www.wikidata.org/entity/Q27634006',
    'http://www.wikidata.org/entity/Q27634018',
    'http://www.wikidata.org/entity/Q27634441',
    'http://www.wikidata.org/entity/Q27634702',
    'http://www.wikidata.org/entity/Q27635167',
    'http://www.wikidata.org/entity/Q27636088',
    'http://www.wikidata.org/entity/Q27636568',
    'http://www.wikidata.org/entity/Q27636709',
    'http://www.wikidata.org/entity/Q27636713',
    'http://www.wikidata.org/entity/Q27637565',
    'http://www.wikidata.org/entity/Q27637899',
    'http://www.wikidata.org/entity/Q27638012',
    'http://www.wikidata.org/entity/Q27638626',
    'http://www.wikidata.org/entity/Q27638895',
    'http://www.wikidata.org/entity/Q27638951',
    'http://www.wikidata.org/entity/Q27639007',
    'http://www.wikidata.org/entity/Q27639051',
    'http://www.wikidata.org/entity/Q27639064',
    'http://www.wikidata.org/entity/Q27639261',
    'http://www.wikidata.org/entity/Q27639290',
    'http://www.wikidata.org/entity/Q27639472',
    'http://www.wikidata.org/entity/Q27639552',
    'http://www.wikidata.org/entity/Q27639649',
    'http://www.wikidata.org/entity/Q27639651',
    'http://www.wikidata.org/entity/Q27639761',
    'http://www.wikidata.org/entity/Q27639790',
    'http://www.wikidata.org/entity/Q27639794',
    'http://www.wikidata.org/entity/Q27639903',
    'http://www.wikidata.org/entity/Q27640027',
    'http://www.wikidata.org/entity/Q27640257',
    'http://www.wikidata.org/entity/Q27640370',
    'http://www.wikidata.org/entity/Q27640501',
    'http://www.wikidata.org/entity/Q27640592',
    'http://www.wikidata.org/entity/Q27640593',
    'http://www.wikidata.org/entity/Q27640773',
    'http://www.wikidata.org/entity/Q27641191',
    'http://www.wikidata.org/entity/Q27641252',
    'http://www.wikidata.org/entity/Q27641514',
    'http://www.wikidata.org/entity/Q27641517',
    'http://www.wikidata.org/entity/Q27641768',
    'http://www.wikidata.org/entity/Q27641772',
    'http://www.wikidata.org/entity/Q27641789',
    'http://www.wikidata.org/entity/Q27642119',
    'http://www.wikidata.org/entity/Q27642164',
    'http://www.wikidata.org/entity/Q27642288',
    'http://www.wikidata.org/entity/Q27642308',
    'http://www.wikidata.org/entity/Q27642450',
    'http://www.wikidata.org/entity/Q27642663',
    'http://www.wikidata.org/entity/Q27642744',
    'http://www.wikidata.org/entity/Q27642888',
    'http://www.wikidata.org/entity/Q27642940',
    'http://www.wikidata.org/entity/Q27643009',
    'http://www.wikidata.org/entity/Q27643091',
    'http://www.wikidata.org/entity/Q27643093',
    'http://www.wikidata.org/entity/Q27643137',
    'http://www.wikidata.org/entity/Q27643140',
    'http://www.wikidata.org/entity/Q27643185',
    'http://www.wikidata.org/entity/Q27643981',
    'http://www.wikidata.org/entity/Q27644014',
    'http://www.wikidata.org/entity/Q27644346',
    'http://www.wikidata.org/entity/Q27644361',
    'http://www.wikidata.org/entity/Q27644375',
    'http://www.wikidata.org/entity/Q27644383',
    'http://www.wikidata.org/entity/Q27644398',
    'http://www.wikidata.org/entity/Q27644478',
    'http://www.wikidata.org/entity/Q27644494',
    'http://www.wikidata.org/entity/Q27644501',
    'http://www.wikidata.org/entity/Q27644515',
    'http://www.wikidata.org/entity/Q27644644',
    'http://www.wikidata.org/entity/Q27645881',
    'http://www.wikidata.org/entity/Q27645978',
    'http://www.wikidata.org/entity/Q27646101',
    'http://www.wikidata.org/entity/Q27646556',
    'http://www.wikidata.org/entity/Q27647341',
    'http://www.wikidata.org/entity/Q27647812',
    'http://www.wikidata.org/entity/Q27648371',
    'http://www.wikidata.org/entity/Q27648640',
    'http://www.wikidata.org/entity/Q27648868',
    'http://www.wikidata.org/entity/Q27649044',
    'http://www.wikidata.org/entity/Q27649108',
    'http://www.wikidata.org/entity/Q27649127',
    'http://www.wikidata.org/entity/Q27649375',
    'http://www.wikidata.org/entity/Q27649531',
    'http://www.wikidata.org/entity/Q27649830',
    'http://www.wikidata.org/entity/Q27650075',
    'http://www.wikidata.org/entity/Q27650119',
    'http://www.wikidata.org/entity/Q27650164',
    'http://www.wikidata.org/entity/Q27650165',
    'http://www.wikidata.org/entity/Q27650381',
    'http://www.wikidata.org/entity/Q27650659',
    'http://www.wikidata.org/entity/Q27650663',
    'http://www.wikidata.org/entity/Q27650664',
    'http://www.wikidata.org/entity/Q27650745',
    'http://www.wikidata.org/entity/Q27650801',
    'http://www.wikidata.org/entity/Q27650851',
    'http://www.wikidata.org/entity/Q27650885',
    'http://www.wikidata.org/entity/Q27650997',
    'http://www.wikidata.org/entity/Q27651011',
    'http://www.wikidata.org/entity/Q27651016',
    'http://www.wikidata.org/entity/Q27651029',
    'http://www.wikidata.org/entity/Q27651112',
    'http://www.wikidata.org/entity/Q27651185',
    'http://www.wikidata.org/entity/Q27651214',
    'http://www.wikidata.org/entity/Q27651385',
    'http://www.wikidata.org/entity/Q27651780',
    'http://www.wikidata.org/entity/Q27651854',
    'http://www.wikidata.org/entity/Q27651993',
    'http://www.wikidata.org/entity/Q27651995',
    'http://www.wikidata.org/entity/Q27652301',
    'http://www.wikidata.org/entity/Q27652502',
    'http://www.wikidata.org/entity/Q27652635',
    'http://www.wikidata.org/entity/Q27652900',
    'http://www.wikidata.org/entity/Q27652925',
    'http://www.wikidata.org/entity/Q27653089',
    'http://www.wikidata.org/entity/Q27653127',
    'http://www.wikidata.org/entity/Q27653139',
    'http://www.wikidata.org/entity/Q27653417',
    'http://www.wikidata.org/entity/Q27653817',
    'http://www.wikidata.org/entity/Q27653962',
    'http://www.wikidata.org/entity/Q27653963',
    'http://www.wikidata.org/entity/Q27653964',
    'http://www.wikidata.org/entity/Q27653976',
    'http://www.wikidata.org/entity/Q27654230',
    'http://www.wikidata.org/entity/Q27654868',
    'http://www.wikidata.org/entity/Q27655556',
    'http://www.wikidata.org/entity/Q27656255',
    'http://www.wikidata.org/entity/Q27658064',
    'http://www.wikidata.org/entity/Q27658257',
    'http://www.wikidata.org/entity/Q27658351',
    'http://www.wikidata.org/entity/Q27658372',
    'http://www.wikidata.org/entity/Q27658415',
    'http://www.wikidata.org/entity/Q27658911',
    'http://www.wikidata.org/entity/Q27658921',
    'http://www.wikidata.org/entity/Q27658989',
    'http://www.wikidata.org/entity/Q27659500',
    'http://www.wikidata.org/entity/Q27659762',
    'http://www.wikidata.org/entity/Q27660236',
    'http://www.wikidata.org/entity/Q27660274',
    'http://www.wikidata.org/entity/Q27660330',
    'http://www.wikidata.org/entity/Q27661190',
    'http://www.wikidata.org/entity/Q27661754',
    'http://www.wikidata.org/entity/Q27661958',
    'http://www.wikidata.org/entity/Q27663126',
    'http://www.wikidata.org/entity/Q27663293',
    'http://www.wikidata.org/entity/Q27663580',
    'http://www.wikidata.org/entity/Q27663583',
    'http://www.wikidata.org/entity/Q27664365',
    'http://www.wikidata.org/entity/Q27664403',
    'http://www.wikidata.org/entity/Q27664711',
    'http://www.wikidata.org/entity/Q27665013',
    'http://www.wikidata.org/entity/Q27665789',
    'http://www.wikidata.org/entity/Q27666030',
    'http://www.wikidata.org/entity/Q27666911',
    'http://www.wikidata.org/entity/Q27667233',
    'http://www.wikidata.org/entity/Q27667245',
    'http://www.wikidata.org/entity/Q27667409',
    'http://www.wikidata.org/entity/Q27667493',
    'http://www.wikidata.org/entity/Q27667831',
    'http://www.wikidata.org/entity/Q27667849',
    'http://www.wikidata.org/entity/Q27667851',
    'http://www.wikidata.org/entity/Q27670409',
    'http://www.wikidata.org/entity/Q27670411',
    'http://www.wikidata.org/entity/Q27670829',
    'http://www.wikidata.org/entity/Q27670940',
    'http://www.wikidata.org/entity/Q27670947',
    'http://www.wikidata.org/entity/Q27671165',
    'http://www.wikidata.org/entity/Q27671404',
    'http://www.wikidata.org/entity/Q27671432',
    'http://www.wikidata.org/entity/Q27671696',
    'http://www.wikidata.org/entity/Q27672444',
    'http://www.wikidata.org/entity/Q27674109',
    'http://www.wikidata.org/entity/Q27674661',
    'http://www.wikidata.org/entity/Q27674674',
    'http://www.wikidata.org/entity/Q27674878',
    'http://www.wikidata.org/entity/Q27675027',
    'http://www.wikidata.org/entity/Q27675032',
    'http://www.wikidata.org/entity/Q27675131',
    'http://www.wikidata.org/entity/Q27675416',
    'http://www.wikidata.org/entity/Q27675498',
    'http://www.wikidata.org/entity/Q27675638',
    'http://www.wikidata.org/entity/Q27675879',
    'http://www.wikidata.org/entity/Q27676393',
    'http://www.wikidata.org/entity/Q27676596',
    'http://www.wikidata.org/entity/Q27676627',
    'http://www.wikidata.org/entity/Q27677104',
    'http://www.wikidata.org/entity/Q27677570',
    'http://www.wikidata.org/entity/Q27677990',
    'http://www.wikidata.org/entity/Q27678055',
    'http://www.wikidata.org/entity/Q27678133',
    'http://www.wikidata.org/entity/Q27678383',
    'http://www.wikidata.org/entity/Q27678455',
    'http://www.wikidata.org/entity/Q27678540',
    'http://www.wikidata.org/entity/Q27678641',
    'http://www.wikidata.org/entity/Q27678770',
    'http://www.wikidata.org/entity/Q27678973',
    'http://www.wikidata.org/entity/Q27679935',
    'http://www.wikidata.org/entity/Q27680496',
    'http://www.wikidata.org/entity/Q27680497',
    'http://www.wikidata.org/entity/Q27680522',
    'http://www.wikidata.org/entity/Q27680759',
    'http://www.wikidata.org/entity/Q27680762',
    'http://www.wikidata.org/entity/Q27681306',
    'http://www.wikidata.org/entity/Q27681624',
    'http://www.wikidata.org/entity/Q27681727',
    'http://www.wikidata.org/entity/Q27681837',
    'http://www.wikidata.org/entity/Q27681877',
    'http://www.wikidata.org/entity/Q27682565',
    'http://www.wikidata.org/entity/Q27683553',
    'http://www.wikidata.org/entity/Q27683708',
    'http://www.wikidata.org/entity/Q27684088',
    'http://www.wikidata.org/entity/Q27684259',
    'http://www.wikidata.org/entity/Q27684332',
    'http://www.wikidata.org/entity/Q27684576',
    'http://www.wikidata.org/entity/Q27684893',
    'http://www.wikidata.org/entity/Q27685461',
    'http://www.wikidata.org/entity/Q27685465',
    'http://www.wikidata.org/entity/Q27686837',
    'http://www.wikidata.org/entity/Q27686977',
    'http://www.wikidata.org/entity/Q27687028',
    'http://www.wikidata.org/entity/Q27687068',
    'http://www.wikidata.org/entity/Q27687577',
    'http://www.wikidata.org/entity/Q27690274',
    'http://www.wikidata.org/entity/Q27691288',
    'http://www.wikidata.org/entity/Q27691299',
    'http://www.wikidata.org/entity/Q27691812',
    'http://www.wikidata.org/entity/Q27692611',
    'http://www.wikidata.org/entity/Q27694249',
    'http://www.wikidata.org/entity/Q27696306',
    'http://www.wikidata.org/entity/Q27697333',
    'http://www.wikidata.org/entity/Q27698054',
    'http://www.wikidata.org/entity/Q27700189',
    'http://www.wikidata.org/entity/Q27700202',
    'http://www.wikidata.org/entity/Q27702050',
    'http://www.wikidata.org/entity/Q27728512',
    'http://www.wikidata.org/entity/Q27728594',
    'http://www.wikidata.org/entity/Q27729288',
    'http://www.wikidata.org/entity/Q27729310',
    'http://www.wikidata.org/entity/Q27729369',
    'http://www.wikidata.org/entity/Q27729754',
    'http://www.wikidata.org/entity/Q27729793',
    'http://www.wikidata.org/entity/Q27729943',
    'http://www.wikidata.org/entity/Q27730234',
    'http://www.wikidata.org/entity/Q27730299',
    'http://www.wikidata.org/entity/Q27730408',
    'http://www.wikidata.org/entity/Q27730725',
    'http://www.wikidata.org/entity/Q27730774',
    'http://www.wikidata.org/entity/Q27730785',
    'http://www.wikidata.org/entity/Q27730815',
    'http://www.wikidata.org/entity/Q27730830',
    'http://www.wikidata.org/entity/Q27730848',
    'http://www.wikidata.org/entity/Q27730888',
    'http://www.wikidata.org/entity/Q27731470',
    'http://www.wikidata.org/entity/Q27731976',
    'http://www.wikidata.org/entity/Q27732719',
    'http://www.wikidata.org/entity/Q27732721',
    'http://www.wikidata.org/entity/Q27732810',
    'http://www.wikidata.org/entity/Q27732927',
    'http://www.wikidata.org/entity/Q27733156',
    'http://www.wikidata.org/entity/Q27733163',
    'http://www.wikidata.org/entity/Q27733214',
    'http://www.wikidata.org/entity/Q27733704',
    'http://www.wikidata.org/entity/Q27733705',
    'http://www.wikidata.org/entity/Q27733707',
    'http://www.wikidata.org/entity/Q27734044',
    'http://www.wikidata.org/entity/Q27734207',
    'http://www.wikidata.org/entity/Q27734262',
    'http://www.wikidata.org/entity/Q27734734',
    'http://www.wikidata.org/entity/Q27734749',
    'http://www.wikidata.org/entity/Q27734750',
    'http://www.wikidata.org/entity/Q27735013',
    'http://www.wikidata.org/entity/Q27735081',
    'http://www.wikidata.org/entity/Q27736012',
    'http://www.wikidata.org/entity/Q27736064',
    'http://www.wikidata.org/entity/Q27737008',
    'http://www.wikidata.org/entity/Q27738021',
    'http://www.wikidata.org/entity/Q27739958',
    'http://www.wikidata.org/entity/Q27742747',
    'http://www.wikidata.org/entity/Q27743024',
    'http://www.wikidata.org/entity/Q27744366',
    'http://www.wikidata.org/entity/Q27744401',
    'http://www.wikidata.org/entity/Q27746278',
    'http://www.wikidata.org/entity/Q27746461',
    'http://www.wikidata.org/entity/Q27748759',
    'http://www.wikidata.org/entity/Q27748784',
    'http://www.wikidata.org/entity/Q27748785',
    'http://www.wikidata.org/entity/Q27748786',
    'http://www.wikidata.org/entity/Q27748814',
    'http://www.wikidata.org/entity/Q27748908',
    'http://www.wikidata.org/entity/Q27748910',
    'http://www.wikidata.org/entity/Q27759364',
    'http://www.wikidata.org/entity/Q27764929',
    'http://www.wikidata.org/entity/Q27765353',
    'http://www.wikidata.org/entity/Q27765619',
    'http://www.wikidata.org/entity/Q27765694',
    'http://www.wikidata.org/entity/Q27765991',
    'http://www.wikidata.org/entity/Q27766009',
    'http://www.wikidata.org/entity/Q27766051',
    'http://www.wikidata.org/entity/Q27766086',
    'http://www.wikidata.org/entity/Q27766417',
    'http://www.wikidata.org/entity/Q27777800',
    'http://www.wikidata.org/entity/Q27807494',
    'http://www.wikidata.org/entity/Q27809667',
    'http://www.wikidata.org/entity/Q27818909',
    'http://www.wikidata.org/entity/Q27824766',
    'http://www.wikidata.org/entity/Q27824769',
    'http://www.wikidata.org/entity/Q27824772',
    'http://www.wikidata.org/entity/Q27824774',
    'http://www.wikidata.org/entity/Q27824784',
    'http://www.wikidata.org/entity/Q27824793',
    'http://www.wikidata.org/entity/Q27824806',
    'http://www.wikidata.org/entity/Q27824811',
    'http://www.wikidata.org/entity/Q27824812',
    'http://www.wikidata.org/entity/Q27824819',
    'http://www.wikidata.org/entity/Q27824827',
    'http://www.wikidata.org/entity/Q27824829',
    'http://www.wikidata.org/entity/Q27824832',
    'http://www.wikidata.org/entity/Q27824835',
    'http://www.wikidata.org/entity/Q27824843',
    'http://www.wikidata.org/entity/Q27824847',
    'http://www.wikidata.org/entity/Q27824849',
    'http://www.wikidata.org/entity/Q27824861',
    'http://www.wikidata.org/entity/Q27824867',
    'http://www.wikidata.org/entity/Q27826357',
    'http://www.wikidata.org/entity/Q27826378',
    'http://www.wikidata.org/entity/Q27851403',
    'http://www.wikidata.org/entity/Q27851406',
    'http://www.wikidata.org/entity/Q27851407',
    'http://www.wikidata.org/entity/Q27851408',
    'http://www.wikidata.org/entity/Q27851410',
    'http://www.wikidata.org/entity/Q27851414',
    'http://www.wikidata.org/entity/Q27851415',
    'http://www.wikidata.org/entity/Q27851419',
    'http://www.wikidata.org/entity/Q27851422',
    'http://www.wikidata.org/entity/Q27851430',
    'http://www.wikidata.org/entity/Q27851440',
    'http://www.wikidata.org/entity/Q27851448',
    'http://www.wikidata.org/entity/Q27851454',
    'http://www.wikidata.org/entity/Q27851456',
    'http://www.wikidata.org/entity/Q27851465',
    'http://www.wikidata.org/entity/Q27851466',
    'http://www.wikidata.org/entity/Q27851474',
    'http://www.wikidata.org/entity/Q27851485',
    'http://www.wikidata.org/entity/Q27851545',
    'http://www.wikidata.org/entity/Q27851546',
    'http://www.wikidata.org/entity/Q27851567',
    'http://www.wikidata.org/entity/Q27851571',
    'http://www.wikidata.org/entity/Q27851573',
    'http://www.wikidata.org/entity/Q27851578',
    'http://www.wikidata.org/entity/Q27851587',
    'http://www.wikidata.org/entity/Q27851588',
    'http://www.wikidata.org/entity/Q27851590',
    'http://www.wikidata.org/entity/Q27851628',
    'http://www.wikidata.org/entity/Q27851629',
    'http://www.wikidata.org/entity/Q27851633',
    'http://www.wikidata.org/entity/Q27851655',
    'http://www.wikidata.org/entity/Q27851660',
    'http://www.wikidata.org/entity/Q27851671',
    'http://www.wikidata.org/entity/Q27851691',
    'http://www.wikidata.org/entity/Q27851700',
    'http://www.wikidata.org/entity/Q27851708',
    'http://www.wikidata.org/entity/Q27851711',
    'http://www.wikidata.org/entity/Q27851712',
    'http://www.wikidata.org/entity/Q27851726',
    'http://www.wikidata.org/entity/Q27851767',
    'http://www.wikidata.org/entity/Q27851787',
    'http://www.wikidata.org/entity/Q27851917',
    'http://www.wikidata.org/entity/Q27851967',
    'http://www.wikidata.org/entity/Q27852028',
    'http://www.wikidata.org/entity/Q27852310',
    'http://www.wikidata.org/entity/Q27852316',
    'http://www.wikidata.org/entity/Q27852374',
    'http://www.wikidata.org/entity/Q27852382',
    'http://www.wikidata.org/entity/Q27852408',
    'http://www.wikidata.org/entity/Q27852856',
    'http://www.wikidata.org/entity/Q27852989',
    'http://www.wikidata.org/entity/Q27853022',
    'http://www.wikidata.org/entity/Q27853101',
    'http://www.wikidata.org/entity/Q27853175',
    'http://www.wikidata.org/entity/Q27853199',
    'http://www.wikidata.org/entity/Q27853359',
    'http://www.wikidata.org/entity/Q27853375',
    'http://www.wikidata.org/entity/Q27853389',
    'http://www.wikidata.org/entity/Q27860350',
    'http://www.wikidata.org/entity/Q27860453',
    'http://www.wikidata.org/entity/Q27860455',
    'http://www.wikidata.org/entity/Q27860456',
    'http://www.wikidata.org/entity/Q27860457',
    'http://www.wikidata.org/entity/Q27860458',
    'http://www.wikidata.org/entity/Q27860459',
    'http://www.wikidata.org/entity/Q27860460',
    'http://www.wikidata.org/entity/Q27860461',
    'http://www.wikidata.org/entity/Q27860462',
    'http://www.wikidata.org/entity/Q27860463',
    'http://www.wikidata.org/entity/Q27860465',
    'http://www.wikidata.org/entity/Q27860466',
    'http://www.wikidata.org/entity/Q27860467',
    'http://www.wikidata.org/entity/Q27860468',
    'http://www.wikidata.org/entity/Q27860469',
    'http://www.wikidata.org/entity/Q27860470',
    'http://www.wikidata.org/entity/Q27860471',
    'http://www.wikidata.org/entity/Q27860472',
    'http://www.wikidata.org/entity/Q27860473',
    'http://www.wikidata.org/entity/Q27860474',
    'http://www.wikidata.org/entity/Q27860475',
    'http://www.wikidata.org/entity/Q27860476',
    'http://www.wikidata.org/entity/Q27860477',
    'http://www.wikidata.org/entity/Q27860478',
    'http://www.wikidata.org/entity/Q27860479',
    'http://www.wikidata.org/entity/Q27860480',
    'http://www.wikidata.org/entity/Q27860481',
    'http://www.wikidata.org/entity/Q27860482',
    'http://www.wikidata.org/entity/Q27860483',
    'http://www.wikidata.org/entity/Q27860484',
    'http://www.wikidata.org/entity/Q27860485',
    'http://www.wikidata.org/entity/Q27860486',
    'http://www.wikidata.org/entity/Q27860487',
    'http://www.wikidata.org/entity/Q27860488',
    'http://www.wikidata.org/entity/Q27860489',
    'http://www.wikidata.org/entity/Q27860490',
    'http://www.wikidata.org/entity/Q27860491',
    'http://www.wikidata.org/entity/Q27860492',
    'http://www.wikidata.org/entity/Q27860495',
    'http://www.wikidata.org/entity/Q27860496',
    'http://www.wikidata.org/entity/Q27860498',
    'http://www.wikidata.org/entity/Q27860499',
    'http://www.wikidata.org/entity/Q27860500',
    'http://www.wikidata.org/entity/Q27860501',
    'http://www.wikidata.org/entity/Q27860502',
    'http://www.wikidata.org/entity/Q27860503',
    'http://www.wikidata.org/entity/Q27860504',
    'http://www.wikidata.org/entity/Q27860505',
    'http://www.wikidata.org/entity/Q27860506',
    'http://www.wikidata.org/entity/Q27860507',
    'http://www.wikidata.org/entity/Q27860508',
    'http://www.wikidata.org/entity/Q27860509',
    'http://www.wikidata.org/entity/Q27860510',
    'http://www.wikidata.org/entity/Q27860511',
    'http://www.wikidata.org/entity/Q27860512',
    'http://www.wikidata.org/entity/Q27860513',
    'http://www.wikidata.org/entity/Q27860514',
    'http://www.wikidata.org/entity/Q27860515',
    'http://www.wikidata.org/entity/Q27860516',
    'http://www.wikidata.org/entity/Q27860517',
    'http://www.wikidata.org/entity/Q27860518',
    'http://www.wikidata.org/entity/Q27860519',
    'http://www.wikidata.org/entity/Q27860520',
    'http://www.wikidata.org/entity/Q27860521',
    'http://www.wikidata.org/entity/Q27860522',
    'http://www.wikidata.org/entity/Q27860523',
    'http://www.wikidata.org/entity/Q27860524',
    'http://www.wikidata.org/entity/Q27860525',
    'http://www.wikidata.org/entity/Q27860526',
    'http://www.wikidata.org/entity/Q27860527',
    'http://www.wikidata.org/entity/Q27860528',
    'http://www.wikidata.org/entity/Q27860529',
    'http://www.wikidata.org/entity/Q27860530',
    'http://www.wikidata.org/entity/Q27860531',
    'http://www.wikidata.org/entity/Q27860532',
    'http://www.wikidata.org/entity/Q27860533',
    'http://www.wikidata.org/entity/Q27860534',
    'http://www.wikidata.org/entity/Q27860535',
    'http://www.wikidata.org/entity/Q27860536',
    'http://www.wikidata.org/entity/Q27860537',
    'http://www.wikidata.org/entity/Q27860538',
    'http://www.wikidata.org/entity/Q27860539',
    'http://www.wikidata.org/entity/Q27860540',
    'http://www.wikidata.org/entity/Q27860541',
    'http://www.wikidata.org/entity/Q27860542',
    'http://www.wikidata.org/entity/Q27860544',
    'http://www.wikidata.org/entity/Q27860545',
    'http://www.wikidata.org/entity/Q27860546',
    'http://www.wikidata.org/entity/Q27860547',
    'http://www.wikidata.org/entity/Q27860548',
    'http://www.wikidata.org/entity/Q27860549',
    'http://www.wikidata.org/entity/Q27860550',
    'http://www.wikidata.org/entity/Q27860551',
    'http://www.wikidata.org/entity/Q27860552',
    'http://www.wikidata.org/entity/Q27860553',
    'http://www.wikidata.org/entity/Q27860554',
    'http://www.wikidata.org/entity/Q27860555',
    'http://www.wikidata.org/entity/Q27860556',
    'http://www.wikidata.org/entity/Q27860557',
    'http://www.wikidata.org/entity/Q27860558',
    'http://www.wikidata.org/entity/Q27860559',
    'http://www.wikidata.org/entity/Q27860560',
    'http://www.wikidata.org/entity/Q27860561',
    'http://www.wikidata.org/entity/Q27860562',
    'http://www.wikidata.org/entity/Q27860563',
    'http://www.wikidata.org/entity/Q27860564',
    'http://www.wikidata.org/entity/Q27860566',
    'http://www.wikidata.org/entity/Q27860567',
    'http://www.wikidata.org/entity/Q27860568',
    'http://www.wikidata.org/entity/Q27860569',
    'http://www.wikidata.org/entity/Q27860570',
    'http://www.wikidata.org/entity/Q27860571',
    'http://www.wikidata.org/entity/Q27860572',
    'http://www.wikidata.org/entity/Q27860573',
    'http://www.wikidata.org/entity/Q27860574',
    'http://www.wikidata.org/entity/Q27860575',
    'http://www.wikidata.org/entity/Q27860576',
    'http://www.wikidata.org/entity/Q27860577',
    'http://www.wikidata.org/entity/Q27860578',
    'http://www.wikidata.org/entity/Q27860579',
    'http://www.wikidata.org/entity/Q27860580',
    'http://www.wikidata.org/entity/Q27860581',
    'http://www.wikidata.org/entity/Q27860582',
    'http://www.wikidata.org/entity/Q27860583',
    'http://www.wikidata.org/entity/Q27860584',
    'http://www.wikidata.org/entity/Q27860585',
    'http://www.wikidata.org/entity/Q27860586',
    'http://www.wikidata.org/entity/Q27860587',
    'http://www.wikidata.org/entity/Q27860588',
    'http://www.wikidata.org/entity/Q27860589',
    'http://www.wikidata.org/entity/Q27860590',
    'http://www.wikidata.org/entity/Q27860591',
    'http://www.wikidata.org/entity/Q27860592',
    'http://www.wikidata.org/entity/Q27860593',
    'http://www.wikidata.org/entity/Q27860594',
    'http://www.wikidata.org/entity/Q27860595',
    'http://www.wikidata.org/entity/Q27860596',
    'http://www.wikidata.org/entity/Q27860597',
    'http://www.wikidata.org/entity/Q27860598',
    'http://www.wikidata.org/entity/Q27860599',
    'http://www.wikidata.org/entity/Q27860600',
    'http://www.wikidata.org/entity/Q27860601',
    'http://www.wikidata.org/entity/Q27860602',
    'http://www.wikidata.org/entity/Q27860603',
    'http://www.wikidata.org/entity/Q27860605',
    'http://www.wikidata.org/entity/Q27860606',
    'http://www.wikidata.org/entity/Q27860607',
    'http://www.wikidata.org/entity/Q27860608',
    'http://www.wikidata.org/entity/Q27860609',
    'http://www.wikidata.org/entity/Q27860610',
    'http://www.wikidata.org/entity/Q27860611',
    'http://www.wikidata.org/entity/Q27860612',
    'http://www.wikidata.org/entity/Q27860614',
    'http://www.wikidata.org/entity/Q27860615',
    'http://www.wikidata.org/entity/Q27860616',
    'http://www.wikidata.org/entity/Q27860617',
    'http://www.wikidata.org/entity/Q27860618',
    'http://www.wikidata.org/entity/Q27860619',
    'http://www.wikidata.org/entity/Q27860620',
    'http://www.wikidata.org/entity/Q27860621',
    'http://www.wikidata.org/entity/Q27860622',
    'http://www.wikidata.org/entity/Q27860623',
    'http://www.wikidata.org/entity/Q27860624',
    'http://www.wikidata.org/entity/Q27860625',
    'http://www.wikidata.org/entity/Q27860626',
    'http://www.wikidata.org/entity/Q27860627',
    'http://www.wikidata.org/entity/Q27860628',
    'http://www.wikidata.org/entity/Q27860630',
    'http://www.wikidata.org/entity/Q27860631',
    'http://www.wikidata.org/entity/Q27860632',
    'http://www.wikidata.org/entity/Q27860633',
    'http://www.wikidata.org/entity/Q27860634',
    'http://www.wikidata.org/entity/Q27860635',
    'http://www.wikidata.org/entity/Q27860636',
    'http://www.wikidata.org/entity/Q27860637',
    'http://www.wikidata.org/entity/Q27860638',
    'http://www.wikidata.org/entity/Q27860639',
    'http://www.wikidata.org/entity/Q27860640',
    'http://www.wikidata.org/entity/Q27860642',
    'http://www.wikidata.org/entity/Q27860643',
    'http://www.wikidata.org/entity/Q27860644',
    'http://www.wikidata.org/entity/Q27860645',
    'http://www.wikidata.org/entity/Q27860646',
    'http://www.wikidata.org/entity/Q27860647',
    'http://www.wikidata.org/entity/Q27860648',
    'http://www.wikidata.org/entity/Q27860650',
    'http://www.wikidata.org/entity/Q27860652',
    'http://www.wikidata.org/entity/Q27860653',
    'http://www.wikidata.org/entity/Q27860655',
    'http://www.wikidata.org/entity/Q27860656',
    'http://www.wikidata.org/entity/Q27860657',
    'http://www.wikidata.org/entity/Q27860658',
    'http://www.wikidata.org/entity/Q27860659',
    'http://www.wikidata.org/entity/Q27860660',
    'http://www.wikidata.org/entity/Q27860661',
    'http://www.wikidata.org/entity/Q27860662',
    'http://www.wikidata.org/entity/Q27860664',
    'http://www.wikidata.org/entity/Q27860665',
    'http://www.wikidata.org/entity/Q27860666',
    'http://www.wikidata.org/entity/Q27860668',
    'http://www.wikidata.org/entity/Q27860669',
    'http://www.wikidata.org/entity/Q27860670',
    'http://www.wikidata.org/entity/Q27860671',
    'http://www.wikidata.org/entity/Q27860672',
    'http://www.wikidata.org/entity/Q27860673',
    'http://www.wikidata.org/entity/Q27860674',
    'http://www.wikidata.org/entity/Q27860675',
    'http://www.wikidata.org/entity/Q27860676',
    'http://www.wikidata.org/entity/Q27860677',
    'http://www.wikidata.org/entity/Q27860678',
    'http://www.wikidata.org/entity/Q27860680',
    'http://www.wikidata.org/entity/Q27860681',
    'http://www.wikidata.org/entity/Q27860682',
    'http://www.wikidata.org/entity/Q27860684',
    'http://www.wikidata.org/entity/Q27860685',
    'http://www.wikidata.org/entity/Q27860686',
    'http://www.wikidata.org/entity/Q27860687',
    'http://www.wikidata.org/entity/Q27860688',
    'http://www.wikidata.org/entity/Q27860689',
    'http://www.wikidata.org/entity/Q27860690',
    'http://www.wikidata.org/entity/Q27860691',
    'http://www.wikidata.org/entity/Q27860692',
    'http://www.wikidata.org/entity/Q27860693',
    'http://www.wikidata.org/entity/Q27860694',
    'http://www.wikidata.org/entity/Q27860695',
    'http://www.wikidata.org/entity/Q27860697',
    'http://www.wikidata.org/entity/Q27860698',
    'http://www.wikidata.org/entity/Q27860699',
    'http://www.wikidata.org/entity/Q27860700',
    'http://www.wikidata.org/entity/Q27860702',
    'http://www.wikidata.org/entity/Q27860703',
    'http://www.wikidata.org/entity/Q27860704',
    'http://www.wikidata.org/entity/Q27860705',
    'http://www.wikidata.org/entity/Q27860707',
    'http://www.wikidata.org/entity/Q27860708',
    'http://www.wikidata.org/entity/Q27860709',
    'http://www.wikidata.org/entity/Q27860710',
    'http://www.wikidata.org/entity/Q27860711',
    'http://www.wikidata.org/entity/Q27860712',
    'http://www.wikidata.org/entity/Q27860713',
    'http://www.wikidata.org/entity/Q27860714',
    'http://www.wikidata.org/entity/Q27860715',
    'http://www.wikidata.org/entity/Q27860716',
    'http://www.wikidata.org/entity/Q27860717',
    'http://www.wikidata.org/entity/Q27860718',
    'http://www.wikidata.org/entity/Q27860719',
    'http://www.wikidata.org/entity/Q27860720',
    'http://www.wikidata.org/entity/Q27860721',
    'http://www.wikidata.org/entity/Q27860722',
    'http://www.wikidata.org/entity/Q27860723',
    'http://www.wikidata.org/entity/Q27860724',
    'http://www.wikidata.org/entity/Q27860725',
    'http://www.wikidata.org/entity/Q27860726',
    'http://www.wikidata.org/entity/Q27860727',
    'http://www.wikidata.org/entity/Q27860728',
    'http://www.wikidata.org/entity/Q27860729',
    'http://www.wikidata.org/entity/Q27860731',
    'http://www.wikidata.org/entity/Q27860732',
    'http://www.wikidata.org/entity/Q27860733',
    'http://www.wikidata.org/entity/Q27860734',
    'http://www.wikidata.org/entity/Q27860735',
    'http://www.wikidata.org/entity/Q27860736',
    'http://www.wikidata.org/entity/Q27860737',
    'http://www.wikidata.org/entity/Q27860738',
    'http://www.wikidata.org/entity/Q27860739',
    'http://www.wikidata.org/entity/Q27860740',
    'http://www.wikidata.org/entity/Q27860742',
    'http://www.wikidata.org/entity/Q27860743',
    'http://www.wikidata.org/entity/Q27860744',
    'http://www.wikidata.org/entity/Q27860745',
    'http://www.wikidata.org/entity/Q27860746',
    'http://www.wikidata.org/entity/Q27860747',
    'http://www.wikidata.org/entity/Q27860748',
    'http://www.wikidata.org/entity/Q27860749',
    'http://www.wikidata.org/entity/Q27860750',
    'http://www.wikidata.org/entity/Q27860751',
    'http://www.wikidata.org/entity/Q27860753',
    'http://www.wikidata.org/entity/Q27860754',
    'http://www.wikidata.org/entity/Q27860755',
    'http://www.wikidata.org/entity/Q27860757',
    'http://www.wikidata.org/entity/Q27860758',
    'http://www.wikidata.org/entity/Q27860759',
    'http://www.wikidata.org/entity/Q27860760',
    'http://www.wikidata.org/entity/Q27860761',
    'http://www.wikidata.org/entity/Q27860762',
    'http://www.wikidata.org/entity/Q27860763',
    'http://www.wikidata.org/entity/Q27860764',
    'http://www.wikidata.org/entity/Q27860765',
    'http://www.wikidata.org/entity/Q27860766',
    'http://www.wikidata.org/entity/Q27860767',
    'http://www.wikidata.org/entity/Q27860768',
    'http://www.wikidata.org/entity/Q27860769',
    'http://www.wikidata.org/entity/Q27860771',
    'http://www.wikidata.org/entity/Q27860772',
    'http://www.wikidata.org/entity/Q27860773',
    'http://www.wikidata.org/entity/Q27860776',
    'http://www.wikidata.org/entity/Q27860777',
    'http://www.wikidata.org/entity/Q27860778',
    'http://www.wikidata.org/entity/Q27860779',
    'http://www.wikidata.org/entity/Q27860780',
    'http://www.wikidata.org/entity/Q27860781',
    'http://www.wikidata.org/entity/Q27860782',
    'http://www.wikidata.org/entity/Q27860783',
    'http://www.wikidata.org/entity/Q27860784',
    'http://www.wikidata.org/entity/Q27860785',
    'http://www.wikidata.org/entity/Q27860788',
    'http://www.wikidata.org/entity/Q27860789',
    'http://www.wikidata.org/entity/Q27860790',
    'http://www.wikidata.org/entity/Q27860791',
    'http://www.wikidata.org/entity/Q27860792',
    'http://www.wikidata.org/entity/Q27860793',
    'http://www.wikidata.org/entity/Q27860794',
    'http://www.wikidata.org/entity/Q27860795',
    'http://www.wikidata.org/entity/Q27860796',
    'http://www.wikidata.org/entity/Q27860797',
    'http://www.wikidata.org/entity/Q27860798',
    'http://www.wikidata.org/entity/Q27860799',
    'http://www.wikidata.org/entity/Q27860800',
    'http://www.wikidata.org/entity/Q27860801',
    'http://www.wikidata.org/entity/Q27860802',
    'http://www.wikidata.org/entity/Q27860803',
    'http://www.wikidata.org/entity/Q27860804',
    'http://www.wikidata.org/entity/Q27860805',
    'http://www.wikidata.org/entity/Q27860806',
    'http://www.wikidata.org/entity/Q27860807',
    'http://www.wikidata.org/entity/Q27860808',
    'http://www.wikidata.org/entity/Q27860809',
    'http://www.wikidata.org/entity/Q27860810',
    'http://www.wikidata.org/entity/Q27860811',
    'http://www.wikidata.org/entity/Q27860812',
    'http://www.wikidata.org/entity/Q27860813',
    'http://www.wikidata.org/entity/Q27860814',
    'http://www.wikidata.org/entity/Q27860815',
    'http://www.wikidata.org/entity/Q27860816',
    'http://www.wikidata.org/entity/Q27860817',
    'http://www.wikidata.org/entity/Q27860818',
    'http://www.wikidata.org/entity/Q27860819',
    'http://www.wikidata.org/entity/Q27860820',
    'http://www.wikidata.org/entity/Q27860821',
    'http://www.wikidata.org/entity/Q27860822',
    'http://www.wikidata.org/entity/Q27860823',
    'http://www.wikidata.org/entity/Q27860824',
    'http://www.wikidata.org/entity/Q27860825',
    'http://www.wikidata.org/entity/Q27860826',
    'http://www.wikidata.org/entity/Q27860828',
    'http://www.wikidata.org/entity/Q27860829',
    'http://www.wikidata.org/entity/Q27860830',
    'http://www.wikidata.org/entity/Q27860831',
    'http://www.wikidata.org/entity/Q27860832',
    'http://www.wikidata.org/entity/Q27860833',
    'http://www.wikidata.org/entity/Q27860834',
    'http://www.wikidata.org/entity/Q27860835',
    'http://www.wikidata.org/entity/Q27860836',
    'http://www.wikidata.org/entity/Q27860837',
    'http://www.wikidata.org/entity/Q27860838',
    'http://www.wikidata.org/entity/Q27860839',
    'http://www.wikidata.org/entity/Q27860840',
    'http://www.wikidata.org/entity/Q27860841',
    'http://www.wikidata.org/entity/Q27860842',
    'http://www.wikidata.org/entity/Q27860843',
    'http://www.wikidata.org/entity/Q27860844',
    'http://www.wikidata.org/entity/Q27860845',
    'http://www.wikidata.org/entity/Q27860846',
    'http://www.wikidata.org/entity/Q27860847',
    'http://www.wikidata.org/entity/Q27860848',
    'http://www.wikidata.org/entity/Q27860849',
    'http://www.wikidata.org/entity/Q27860850',
    'http://www.wikidata.org/entity/Q27860851',
    'http://www.wikidata.org/entity/Q27860852',
    'http://www.wikidata.org/entity/Q27860853',
    'http://www.wikidata.org/entity/Q27860854',
    'http://www.wikidata.org/entity/Q27860855',
    'http://www.wikidata.org/entity/Q27860856',
    'http://www.wikidata.org/entity/Q27860857',
    'http://www.wikidata.org/entity/Q27860859',
    'http://www.wikidata.org/entity/Q27860860',
    'http://www.wikidata.org/entity/Q27860861',
    'http://www.wikidata.org/entity/Q27860862',
    'http://www.wikidata.org/entity/Q27860863',
    'http://www.wikidata.org/entity/Q27860864',
    'http://www.wikidata.org/entity/Q27860865',
    'http://www.wikidata.org/entity/Q27860866',
    'http://www.wikidata.org/entity/Q27860867',
    'http://www.wikidata.org/entity/Q27860868',
    'http://www.wikidata.org/entity/Q27860869',
    'http://www.wikidata.org/entity/Q27860870',
    'http://www.wikidata.org/entity/Q27860871',
    'http://www.wikidata.org/entity/Q27860872',
    'http://www.wikidata.org/entity/Q27860873',
    'http://www.wikidata.org/entity/Q27860874',
    'http://www.wikidata.org/entity/Q27860875',
    'http://www.wikidata.org/entity/Q27860876',
    'http://www.wikidata.org/entity/Q27860877',
    'http://www.wikidata.org/entity/Q27860878',
    'http://www.wikidata.org/entity/Q27860879',
    'http://www.wikidata.org/entity/Q27860880',
    'http://www.wikidata.org/entity/Q27860881',
    'http://www.wikidata.org/entity/Q27860882',
    'http://www.wikidata.org/entity/Q27860883',
    'http://www.wikidata.org/entity/Q27860884',
    'http://www.wikidata.org/entity/Q27860885',
    'http://www.wikidata.org/entity/Q27860886',
    'http://www.wikidata.org/entity/Q27860887',
    'http://www.wikidata.org/entity/Q27860888',
    'http://www.wikidata.org/entity/Q27860890',
    'http://www.wikidata.org/entity/Q27860891',
    'http://www.wikidata.org/entity/Q27860892',
    'http://www.wikidata.org/entity/Q27860893',
    'http://www.wikidata.org/entity/Q27860894',
    'http://www.wikidata.org/entity/Q27860895',
    'http://www.wikidata.org/entity/Q27860896',
    'http://www.wikidata.org/entity/Q27860897',
    'http://www.wikidata.org/entity/Q27860898',
    'http://www.wikidata.org/entity/Q27860899',
    'http://www.wikidata.org/entity/Q27860900',
    'http://www.wikidata.org/entity/Q27860901',
    'http://www.wikidata.org/entity/Q27860902',
    'http://www.wikidata.org/entity/Q27860903',
    'http://www.wikidata.org/entity/Q27860904',
    'http://www.wikidata.org/entity/Q27860905',
    'http://www.wikidata.org/entity/Q27860906',
    'http://www.wikidata.org/entity/Q27860907',
    'http://www.wikidata.org/entity/Q27860908',
    'http://www.wikidata.org/entity/Q27860909',
    'http://www.wikidata.org/entity/Q27860910',
    'http://www.wikidata.org/entity/Q27860911',
    'http://www.wikidata.org/entity/Q27860912',
    'http://www.wikidata.org/entity/Q27860913',
    'http://www.wikidata.org/entity/Q27860914',
    'http://www.wikidata.org/entity/Q27860915',
    'http://www.wikidata.org/entity/Q27860916',
    'http://www.wikidata.org/entity/Q27860917',
    'http://www.wikidata.org/entity/Q27860918',
    'http://www.wikidata.org/entity/Q27860919',
    'http://www.wikidata.org/entity/Q27860920',
    'http://www.wikidata.org/entity/Q27860921',
    'http://www.wikidata.org/entity/Q27860922',
    'http://www.wikidata.org/entity/Q27860923',
    'http://www.wikidata.org/entity/Q27860925',
    'http://www.wikidata.org/entity/Q27860926',
    'http://www.wikidata.org/entity/Q27860928',
    'http://www.wikidata.org/entity/Q27860929',
    'http://www.wikidata.org/entity/Q27860930',
    'http://www.wikidata.org/entity/Q27860931',
    'http://www.wikidata.org/entity/Q27860932',
    'http://www.wikidata.org/entity/Q27860933',
    'http://www.wikidata.org/entity/Q27860934',
    'http://www.wikidata.org/entity/Q27860935',
    'http://www.wikidata.org/entity/Q27860936',
    'http://www.wikidata.org/entity/Q27860937',
    'http://www.wikidata.org/entity/Q27860938',
    'http://www.wikidata.org/entity/Q27860939',
    'http://www.wikidata.org/entity/Q27860940',
    'http://www.wikidata.org/entity/Q27860941',
    'http://www.wikidata.org/entity/Q27860942',
    'http://www.wikidata.org/entity/Q27860943',
    'http://www.wikidata.org/entity/Q27860944',
    'http://www.wikidata.org/entity/Q27860945',
    'http://www.wikidata.org/entity/Q27860946',
    'http://www.wikidata.org/entity/Q27860947',
    'http://www.wikidata.org/entity/Q27860948',
    'http://www.wikidata.org/entity/Q27860949',
    'http://www.wikidata.org/entity/Q27860950',
    'http://www.wikidata.org/entity/Q27860951',
    'http://www.wikidata.org/entity/Q27860952',
    'http://www.wikidata.org/entity/Q27860953',
    'http://www.wikidata.org/entity/Q27860954',
    'http://www.wikidata.org/entity/Q27860955',
    'http://www.wikidata.org/entity/Q27860956',
    'http://www.wikidata.org/entity/Q27860957',
    'http://www.wikidata.org/entity/Q27860958',
    'http://www.wikidata.org/entity/Q27860959',
    'http://www.wikidata.org/entity/Q27860960',
    'http://www.wikidata.org/entity/Q27860961',
    'http://www.wikidata.org/entity/Q27860962',
    'http://www.wikidata.org/entity/Q27860963',
    'http://www.wikidata.org/entity/Q27860964',
    'http://www.wikidata.org/entity/Q27860965',
    'http://www.wikidata.org/entity/Q27860966',
    'http://www.wikidata.org/entity/Q27860967',
    'http://www.wikidata.org/entity/Q27860968',
    'http://www.wikidata.org/entity/Q27860969',
    'http://www.wikidata.org/entity/Q27860970',
    'http://www.wikidata.org/entity/Q27860971',
    'http://www.wikidata.org/entity/Q27860972',
    'http://www.wikidata.org/entity/Q27860973',
    'http://www.wikidata.org/entity/Q27860975',
    'http://www.wikidata.org/entity/Q27860976',
    'http://www.wikidata.org/entity/Q27860977',
    'http://www.wikidata.org/entity/Q27860978',
    'http://www.wikidata.org/entity/Q27860979',
    'http://www.wikidata.org/entity/Q27860981',
    'http://www.wikidata.org/entity/Q27860983',
    'http://www.wikidata.org/entity/Q27860985',
    'http://www.wikidata.org/entity/Q27860986',
    'http://www.wikidata.org/entity/Q27860987',
    'http://www.wikidata.org/entity/Q27860988',
    'http://www.wikidata.org/entity/Q27860989',
    'http://www.wikidata.org/entity/Q27860990',
    'http://www.wikidata.org/entity/Q27860991',
    'http://www.wikidata.org/entity/Q27860992',
    'http://www.wikidata.org/entity/Q27860993',
    'http://www.wikidata.org/entity/Q27860994',
    'http://www.wikidata.org/entity/Q27860995',
    'http://www.wikidata.org/entity/Q27860996',
    'http://www.wikidata.org/entity/Q27860997',
    'http://www.wikidata.org/entity/Q27860998',
    'http://www.wikidata.org/entity/Q27860999',
    'http://www.wikidata.org/entity/Q27861000',
    'http://www.wikidata.org/entity/Q27861001',
    'http://www.wikidata.org/entity/Q27861002',
    'http://www.wikidata.org/entity/Q27861003',
    'http://www.wikidata.org/entity/Q27861004',
    'http://www.wikidata.org/entity/Q27861005',
    'http://www.wikidata.org/entity/Q27861006',
    'http://www.wikidata.org/entity/Q27861007',
    'http://www.wikidata.org/entity/Q27861008',
    'http://www.wikidata.org/entity/Q27861010',
    'http://www.wikidata.org/entity/Q27861011',
    'http://www.wikidata.org/entity/Q27861012',
    'http://www.wikidata.org/entity/Q27861013',
    'http://www.wikidata.org/entity/Q27861014',
    'http://www.wikidata.org/entity/Q27861015',
    'http://www.wikidata.org/entity/Q27861016',
    'http://www.wikidata.org/entity/Q27861017',
    'http://www.wikidata.org/entity/Q27861018',
    'http://www.wikidata.org/entity/Q27861019',
    'http://www.wikidata.org/entity/Q27861020',
    'http://www.wikidata.org/entity/Q27861021',
    'http://www.wikidata.org/entity/Q27861023',
    'http://www.wikidata.org/entity/Q27861024',
    'http://www.wikidata.org/entity/Q27861025',
    'http://www.wikidata.org/entity/Q27861026',
    'http://www.wikidata.org/entity/Q27861027',
    'http://www.wikidata.org/entity/Q27861028',
    'http://www.wikidata.org/entity/Q27861029',
    'http://www.wikidata.org/entity/Q27861030',
    'http://www.wikidata.org/entity/Q27861031',
    'http://www.wikidata.org/entity/Q27861033',
    'http://www.wikidata.org/entity/Q27861034',
    'http://www.wikidata.org/entity/Q27861035',
    'http://www.wikidata.org/entity/Q27861036',
    'http://www.wikidata.org/entity/Q27861037',
    'http://www.wikidata.org/entity/Q27861038',
    'http://www.wikidata.org/entity/Q27861039',
    'http://www.wikidata.org/entity/Q27861040',
    'http://www.wikidata.org/entity/Q27861042',
    'http://www.wikidata.org/entity/Q27861043',
    'http://www.wikidata.org/entity/Q27861044',
    'http://www.wikidata.org/entity/Q27861045',
    'http://www.wikidata.org/entity/Q27861046',
    'http://www.wikidata.org/entity/Q27861047',
    'http://www.wikidata.org/entity/Q27861048',
    'http://www.wikidata.org/entity/Q27861049',
    'http://www.wikidata.org/entity/Q27861050',
    'http://www.wikidata.org/entity/Q27861051',
    'http://www.wikidata.org/entity/Q27861052',
    'http://www.wikidata.org/entity/Q27861053',
    'http://www.wikidata.org/entity/Q27861054',
    'http://www.wikidata.org/entity/Q27861055',
    'http://www.wikidata.org/entity/Q27861056',
    'http://www.wikidata.org/entity/Q27861057',
    'http://www.wikidata.org/entity/Q27861059',
    'http://www.wikidata.org/entity/Q27861060',
    'http://www.wikidata.org/entity/Q27861061',
    'http://www.wikidata.org/entity/Q27861062',
    'http://www.wikidata.org/entity/Q27861063',
    'http://www.wikidata.org/entity/Q27861064',
    'http://www.wikidata.org/entity/Q27861065',
    'http://www.wikidata.org/entity/Q27861066',
    'http://www.wikidata.org/entity/Q27861067',
    'http://www.wikidata.org/entity/Q27861068',
    'http://www.wikidata.org/entity/Q27861069',
    'http://www.wikidata.org/entity/Q27861070',
    'http://www.wikidata.org/entity/Q27861071',
    'http://www.wikidata.org/entity/Q27861072',
    'http://www.wikidata.org/entity/Q27861073',
    'http://www.wikidata.org/entity/Q27861074',
    'http://www.wikidata.org/entity/Q27861075',
    'http://www.wikidata.org/entity/Q27861076',
    'http://www.wikidata.org/entity/Q27861077',
    'http://www.wikidata.org/entity/Q27861078',
    'http://www.wikidata.org/entity/Q27861079',
    'http://www.wikidata.org/entity/Q27861080',
    'http://www.wikidata.org/entity/Q27861082',
    'http://www.wikidata.org/entity/Q27861083',
    'http://www.wikidata.org/entity/Q27861084',
    'http://www.wikidata.org/entity/Q27861085',
    'http://www.wikidata.org/entity/Q27861086',
    'http://www.wikidata.org/entity/Q27861087',
    'http://www.wikidata.org/entity/Q27861088',
    'http://www.wikidata.org/entity/Q27861089',
    'http://www.wikidata.org/entity/Q27861090',
    'http://www.wikidata.org/entity/Q27861091',
    'http://www.wikidata.org/entity/Q27861092',
    'http://www.wikidata.org/entity/Q27861093',
    'http://www.wikidata.org/entity/Q27861094',
    'http://www.wikidata.org/entity/Q27861095',
    'http://www.wikidata.org/entity/Q27861096',
    'http://www.wikidata.org/entity/Q27861097',
    'http://www.wikidata.org/entity/Q27861098',
    'http://www.wikidata.org/entity/Q27861099',
    'http://www.wikidata.org/entity/Q27861100',
    'http://www.wikidata.org/entity/Q27861101',
    'http://www.wikidata.org/entity/Q27861102',
    'http://www.wikidata.org/entity/Q27861103',
    'http://www.wikidata.org/entity/Q27861104',
    'http://www.wikidata.org/entity/Q27861105',
    'http://www.wikidata.org/entity/Q27861106',
    'http://www.wikidata.org/entity/Q27861107',
    'http://www.wikidata.org/entity/Q27861108',
    'http://www.wikidata.org/entity/Q27861109',
    'http://www.wikidata.org/entity/Q27861110',
    'http://www.wikidata.org/entity/Q27861111',
    'http://www.wikidata.org/entity/Q27861112',
    'http://www.wikidata.org/entity/Q27861113',
    'http://www.wikidata.org/entity/Q27861114',
    'http://www.wikidata.org/entity/Q27861115',
    'http://www.wikidata.org/entity/Q27861116',
    'http://www.wikidata.org/entity/Q27861117',
    'http://www.wikidata.org/entity/Q27861118',
    'http://www.wikidata.org/entity/Q27861119',
    'http://www.wikidata.org/entity/Q27861120',
    'http://www.wikidata.org/entity/Q27861121',
    'http://www.wikidata.org/entity/Q27861123',
    'http://www.wikidata.org/entity/Q27861124',
    'http://www.wikidata.org/entity/Q27861125',
    'http://www.wikidata.org/entity/Q27861126',
    'http://www.wikidata.org/entity/Q27861127',
    'http://www.wikidata.org/entity/Q27861128',
    'http://www.wikidata.org/entity/Q27861931',
    'http://www.wikidata.org/entity/Q27861941',
    'http://www.wikidata.org/entity/Q27861947',
    'http://www.wikidata.org/entity/Q27861956',
    'http://www.wikidata.org/entity/Q27863319',
    'http://www.wikidata.org/entity/Q27863328',
    'http://www.wikidata.org/entity/Q27863346',
    'http://www.wikidata.org/entity/Q27863369',
    'http://www.wikidata.org/entity/Q27863380',
    'http://www.wikidata.org/entity/Q27863386',
    'http://www.wikidata.org/entity/Q27863392',
    'http://www.wikidata.org/entity/Q27863439',
    'http://www.wikidata.org/entity/Q27863659',
    'http://www.wikidata.org/entity/Q27863677',
    'http://www.wikidata.org/entity/Q27863679',
    'http://www.wikidata.org/entity/Q27863695',
    'http://www.wikidata.org/entity/Q27863703',
    'http://www.wikidata.org/entity/Q27863710',
    'http://www.wikidata.org/entity/Q27863762',
    'http://www.wikidata.org/entity/Q27863806',
    'http://www.wikidata.org/entity/Q27863810',
    'http://www.wikidata.org/entity/Q27863915',
    'http://www.wikidata.org/entity/Q27864122',
    'http://www.wikidata.org/entity/Q27864128',
    'http://www.wikidata.org/entity/Q27865236',
    'http://www.wikidata.org/entity/Q27865246',
    'http://www.wikidata.org/entity/Q27865256',
    'http://www.wikidata.org/entity/Q27865268',
    'http://www.wikidata.org/entity/Q27865318',
    'http://www.wikidata.org/entity/Q27867710',
    'http://www.wikidata.org/entity/Q27876223',
    'http://www.wikidata.org/entity/Q27907579',
    'http://www.wikidata.org/entity/Q27910569',
    'http://www.wikidata.org/entity/Q27919616',
    'http://www.wikidata.org/entity/Q27919623',
    'http://www.wikidata.org/entity/Q27919636',
    'http://www.wikidata.org/entity/Q27919638',
    'http://www.wikidata.org/entity/Q27919643',
    'http://www.wikidata.org/entity/Q27919669',
    'http://www.wikidata.org/entity/Q27919675',
    'http://www.wikidata.org/entity/Q27919679',
    'http://www.wikidata.org/entity/Q27919682',
    'http://www.wikidata.org/entity/Q27919704',
    'http://www.wikidata.org/entity/Q27921271',
    'http://www.wikidata.org/entity/Q27921795',
    'http://www.wikidata.org/entity/Q27921801',
    'http://www.wikidata.org/entity/Q27921845',
    'http://www.wikidata.org/entity/Q27927580',
    'http://www.wikidata.org/entity/Q27929510',
    'http://www.wikidata.org/entity/Q27929526',
    'http://www.wikidata.org/entity/Q27929772',
    'http://www.wikidata.org/entity/Q27929786',
    'http://www.wikidata.org/entity/Q27929794',
    'http://www.wikidata.org/entity/Q27929879',
    'http://www.wikidata.org/entity/Q27929897',
    'http://www.wikidata.org/entity/Q27929925',
    'http://www.wikidata.org/entity/Q27930009',
    'http://www.wikidata.org/entity/Q27930023',
    'http://www.wikidata.org/entity/Q27930079',
    'http://www.wikidata.org/entity/Q27930080',
    'http://www.wikidata.org/entity/Q27930150',
    'http://www.wikidata.org/entity/Q27930175',
    'http://www.wikidata.org/entity/Q27930198',
    'http://www.wikidata.org/entity/Q27930326',
    'http://www.wikidata.org/entity/Q27930358',
    'http://www.wikidata.org/entity/Q27930372',
    'http://www.wikidata.org/entity/Q27930407',
    'http://www.wikidata.org/entity/Q27930427',
    'http://www.wikidata.org/entity/Q27930429',
    'http://www.wikidata.org/entity/Q27930448',
    'http://www.wikidata.org/entity/Q27930471',
    'http://www.wikidata.org/entity/Q27930492',
    'http://www.wikidata.org/entity/Q27930550',
    'http://www.wikidata.org/entity/Q27930579',
    'http://www.wikidata.org/entity/Q27930650',
    'http://www.wikidata.org/entity/Q27930674',
    'http://www.wikidata.org/entity/Q27930690',
    'http://www.wikidata.org/entity/Q27930706',
    'http://www.wikidata.org/entity/Q27930757',
    'http://www.wikidata.org/entity/Q27930804',
    'http://www.wikidata.org/entity/Q27930818',
    'http://www.wikidata.org/entity/Q27930849',
    'http://www.wikidata.org/entity/Q27930850',
    'http://www.wikidata.org/entity/Q27930871',
    'http://www.wikidata.org/entity/Q27930884',
    'http://www.wikidata.org/entity/Q27930894',
    'http://www.wikidata.org/entity/Q27930922',
    'http://www.wikidata.org/entity/Q27930939',
    'http://www.wikidata.org/entity/Q27931100',
    'http://www.wikidata.org/entity/Q27931143',
    'http://www.wikidata.org/entity/Q27931231',
    'http://www.wikidata.org/entity/Q27931237',
    'http://www.wikidata.org/entity/Q27931244',
    'http://www.wikidata.org/entity/Q27931286',
    'http://www.wikidata.org/entity/Q27931299',
    'http://www.wikidata.org/entity/Q27931310',
    'http://www.wikidata.org/entity/Q27931359',
    'http://www.wikidata.org/entity/Q27931364',
    'http://www.wikidata.org/entity/Q27931408',
    'http://www.wikidata.org/entity/Q27931414',
    'http://www.wikidata.org/entity/Q27931418',
    'http://www.wikidata.org/entity/Q27931425',
    'http://www.wikidata.org/entity/Q27931475',
    'http://www.wikidata.org/entity/Q27931516',
    'http://www.wikidata.org/entity/Q27931576',
    'http://www.wikidata.org/entity/Q27931583',
    'http://www.wikidata.org/entity/Q27931717',
    'http://www.wikidata.org/entity/Q27931724',
    'http://www.wikidata.org/entity/Q27931804',
    'http://www.wikidata.org/entity/Q27931858',
    'http://www.wikidata.org/entity/Q27931884',
    'http://www.wikidata.org/entity/Q27931961',
    'http://www.wikidata.org/entity/Q27932045',
    'http://www.wikidata.org/entity/Q27932114',
    'http://www.wikidata.org/entity/Q27932206',
    'http://www.wikidata.org/entity/Q27932302',
    'http://www.wikidata.org/entity/Q27932356',
    'http://www.wikidata.org/entity/Q27932376',
    'http://www.wikidata.org/entity/Q27932399',
    'http://www.wikidata.org/entity/Q27932401',
    'http://www.wikidata.org/entity/Q27932406',
    'http://www.wikidata.org/entity/Q27932416',
    'http://www.wikidata.org/entity/Q27932438',
    'http://www.wikidata.org/entity/Q27932607',
    'http://www.wikidata.org/entity/Q27932611',
    'http://www.wikidata.org/entity/Q27932697',
    'http://www.wikidata.org/entity/Q27932740',
    'http://www.wikidata.org/entity/Q27932745',
    'http://www.wikidata.org/entity/Q27932774',
    'http://www.wikidata.org/entity/Q27932807',
    'http://www.wikidata.org/entity/Q27932810',
    'http://www.wikidata.org/entity/Q27932822',
    'http://www.wikidata.org/entity/Q27933115',
    'http://www.wikidata.org/entity/Q27933130',
    'http://www.wikidata.org/entity/Q27933279',
    'http://www.wikidata.org/entity/Q27933294',
    'http://www.wikidata.org/entity/Q27933337',
    'http://www.wikidata.org/entity/Q27933354',
    'http://www.wikidata.org/entity/Q27933365',
    'http://www.wikidata.org/entity/Q27933366',
    'http://www.wikidata.org/entity/Q27933425',
    'http://www.wikidata.org/entity/Q27933479',
    'http://www.wikidata.org/entity/Q27933494',
    'http://www.wikidata.org/entity/Q27933537',
    'http://www.wikidata.org/entity/Q27933556',
    'http://www.wikidata.org/entity/Q27933576',
    'http://www.wikidata.org/entity/Q27933699',
    'http://www.wikidata.org/entity/Q27933717',
    'http://www.wikidata.org/entity/Q27933843',
    'http://www.wikidata.org/entity/Q27933887',
    'http://www.wikidata.org/entity/Q27933914',
    'http://www.wikidata.org/entity/Q27933975',
    'http://www.wikidata.org/entity/Q27933988',
    'http://www.wikidata.org/entity/Q27933991',
    'http://www.wikidata.org/entity/Q27933995',
    'http://www.wikidata.org/entity/Q27934009',
    'http://www.wikidata.org/entity/Q27934020',
    'http://www.wikidata.org/entity/Q27934072',
    'http://www.wikidata.org/entity/Q27934075',
    'http://www.wikidata.org/entity/Q27934108',
    'http://www.wikidata.org/entity/Q27934137',
    'http://www.wikidata.org/entity/Q27934144',
    'http://www.wikidata.org/entity/Q27934146',
    'http://www.wikidata.org/entity/Q27934199',
    'http://www.wikidata.org/entity/Q27934232',
    'http://www.wikidata.org/entity/Q27934275',
    'http://www.wikidata.org/entity/Q27934337',
    'http://www.wikidata.org/entity/Q27934464',
    'http://www.wikidata.org/entity/Q27934527',
    'http://www.wikidata.org/entity/Q27934608',
    'http://www.wikidata.org/entity/Q27934638',
    'http://www.wikidata.org/entity/Q27934812',
    'http://www.wikidata.org/entity/Q27934842',
    'http://www.wikidata.org/entity/Q27934845',
    'http://www.wikidata.org/entity/Q27934889',
    'http://www.wikidata.org/entity/Q27934927',
    'http://www.wikidata.org/entity/Q27934931',
    'http://www.wikidata.org/entity/Q27934965',
    'http://www.wikidata.org/entity/Q27934968',
    'http://www.wikidata.org/entity/Q27934987',
    'http://www.wikidata.org/entity/Q27934988',
    'http://www.wikidata.org/entity/Q27935229',
    'http://www.wikidata.org/entity/Q27935237',
    'http://www.wikidata.org/entity/Q27935265',
    'http://www.wikidata.org/entity/Q27935315',
    'http://www.wikidata.org/entity/Q27935340',
    'http://www.wikidata.org/entity/Q27935371',
    'http://www.wikidata.org/entity/Q27935410',
    'http://www.wikidata.org/entity/Q27935442',
    'http://www.wikidata.org/entity/Q27935521',
    'http://www.wikidata.org/entity/Q27935548',
    'http://www.wikidata.org/entity/Q27935666',
    'http://www.wikidata.org/entity/Q27935734',
    'http://www.wikidata.org/entity/Q27935765',
    'http://www.wikidata.org/entity/Q27935788',
    'http://www.wikidata.org/entity/Q27935789',
    'http://www.wikidata.org/entity/Q27935809',
    'http://www.wikidata.org/entity/Q27935813',
    'http://www.wikidata.org/entity/Q27935838',
    'http://www.wikidata.org/entity/Q27935856',
    'http://www.wikidata.org/entity/Q27935902',
    'http://www.wikidata.org/entity/Q27935997',
    'http://www.wikidata.org/entity/Q27936009',
    'http://www.wikidata.org/entity/Q27936133',
    'http://www.wikidata.org/entity/Q27936161',
    'http://www.wikidata.org/entity/Q27936180',
    'http://www.wikidata.org/entity/Q27936188',
    'http://www.wikidata.org/entity/Q27936197',
    'http://www.wikidata.org/entity/Q27936299',
    'http://www.wikidata.org/entity/Q27936300',
    'http://www.wikidata.org/entity/Q27936317',
    'http://www.wikidata.org/entity/Q27936322',
    'http://www.wikidata.org/entity/Q27936356',
    'http://www.wikidata.org/entity/Q27936367',
    'http://www.wikidata.org/entity/Q27936370',
    'http://www.wikidata.org/entity/Q27936377',
    'http://www.wikidata.org/entity/Q27936478',
    'http://www.wikidata.org/entity/Q27936509',
    'http://www.wikidata.org/entity/Q27936514',
    'http://www.wikidata.org/entity/Q27936533',
    'http://www.wikidata.org/entity/Q27936543',
    'http://www.wikidata.org/entity/Q27936594',
    'http://www.wikidata.org/entity/Q27936618',
    'http://www.wikidata.org/entity/Q27936664',
    'http://www.wikidata.org/entity/Q27936680',
    'http://www.wikidata.org/entity/Q27936710',
    'http://www.wikidata.org/entity/Q27936716',
    'http://www.wikidata.org/entity/Q27936726',
    'http://www.wikidata.org/entity/Q27936734',
    'http://www.wikidata.org/entity/Q27936745',
    'http://www.wikidata.org/entity/Q27936750',
    'http://www.wikidata.org/entity/Q27936756',
    'http://www.wikidata.org/entity/Q27936843',
    'http://www.wikidata.org/entity/Q27936883',
    'http://www.wikidata.org/entity/Q27936923',
    'http://www.wikidata.org/entity/Q27937072',
    'http://www.wikidata.org/entity/Q27937256',
    'http://www.wikidata.org/entity/Q27937265',
    'http://www.wikidata.org/entity/Q27937306',
    'http://www.wikidata.org/entity/Q27937328',
    'http://www.wikidata.org/entity/Q27937364',
    'http://www.wikidata.org/entity/Q27937387',
    'http://www.wikidata.org/entity/Q27937388',
    'http://www.wikidata.org/entity/Q27937465',
    'http://www.wikidata.org/entity/Q27937502',
    'http://www.wikidata.org/entity/Q27937521',
    'http://www.wikidata.org/entity/Q27937531',
    'http://www.wikidata.org/entity/Q27937556',
    'http://www.wikidata.org/entity/Q27937565',
    'http://www.wikidata.org/entity/Q27937577',
    'http://www.wikidata.org/entity/Q27937584',
    'http://www.wikidata.org/entity/Q27937629',
    'http://www.wikidata.org/entity/Q27937632',
    'http://www.wikidata.org/entity/Q27937695',
    'http://www.wikidata.org/entity/Q27937778',
    'http://www.wikidata.org/entity/Q27937800',
    'http://www.wikidata.org/entity/Q27937857',
    'http://www.wikidata.org/entity/Q27937863',
    'http://www.wikidata.org/entity/Q27937880',
    'http://www.wikidata.org/entity/Q27937915',
    'http://www.wikidata.org/entity/Q27937927',
    'http://www.wikidata.org/entity/Q27937990',
    'http://www.wikidata.org/entity/Q27937993',
    'http://www.wikidata.org/entity/Q27938063',
    'http://www.wikidata.org/entity/Q27938081',
    'http://www.wikidata.org/entity/Q27938344',
    'http://www.wikidata.org/entity/Q27938405',
    'http://www.wikidata.org/entity/Q27938474',
    'http://www.wikidata.org/entity/Q27938488',
    'http://www.wikidata.org/entity/Q27938493',
    'http://www.wikidata.org/entity/Q27938580',
    'http://www.wikidata.org/entity/Q27938617',
    'http://www.wikidata.org/entity/Q27938654',
    'http://www.wikidata.org/entity/Q27938681',
    'http://www.wikidata.org/entity/Q27938718',
    'http://www.wikidata.org/entity/Q27938796',
    'http://www.wikidata.org/entity/Q27938834',
    'http://www.wikidata.org/entity/Q27938837',
    'http://www.wikidata.org/entity/Q27938863',
    'http://www.wikidata.org/entity/Q27938902',
    'http://www.wikidata.org/entity/Q27938906',
    'http://www.wikidata.org/entity/Q27938943',
    'http://www.wikidata.org/entity/Q27938962',
    'http://www.wikidata.org/entity/Q27939053',
    'http://www.wikidata.org/entity/Q27939071',
    'http://www.wikidata.org/entity/Q27939116',
    'http://www.wikidata.org/entity/Q27939128',
    'http://www.wikidata.org/entity/Q27939158',
    'http://www.wikidata.org/entity/Q27939191',
    'http://www.wikidata.org/entity/Q27939216',
    'http://www.wikidata.org/entity/Q27939221',
    'http://www.wikidata.org/entity/Q27939224',
    'http://www.wikidata.org/entity/Q27939235',
    'http://www.wikidata.org/entity/Q27939297',
    'http://www.wikidata.org/entity/Q27939365',
    'http://www.wikidata.org/entity/Q27939386',
    'http://www.wikidata.org/entity/Q27939392',
    'http://www.wikidata.org/entity/Q27939524',
    'http://www.wikidata.org/entity/Q27939550',
    'http://www.wikidata.org/entity/Q27939560',
    'http://www.wikidata.org/entity/Q27939696',
    'http://www.wikidata.org/entity/Q27939735',
    'http://www.wikidata.org/entity/Q27939822',
    'http://www.wikidata.org/entity/Q27939854',
    'http://www.wikidata.org/entity/Q27939933',
    'http://www.wikidata.org/entity/Q27939948',
    'http://www.wikidata.org/entity/Q27939971',
    'http://www.wikidata.org/entity/Q27939982',
    'http://www.wikidata.org/entity/Q27940016',
    'http://www.wikidata.org/entity/Q27940050',
    'http://www.wikidata.org/entity/Q27940105',
    'http://www.wikidata.org/entity/Q27940116',
    'http://www.wikidata.org/entity/Q27940154',
    'http://www.wikidata.org/entity/Q27940194',
    'http://www.wikidata.org/entity/Q27940314',
    'http://www.wikidata.org/entity/Q27940322',
    'http://www.wikidata.org/entity/Q27940327',
    'http://www.wikidata.org/entity/Q27940363',
    'http://www.wikidata.org/entity/Q27942822',
    'http://www.wikidata.org/entity/Q27949361',
    'http://www.wikidata.org/entity/Q27967638',
    'http://www.wikidata.org/entity/Q27968117',
    'http://www.wikidata.org/entity/Q27972160',
    'http://www.wikidata.org/entity/Q27972199',
    'http://www.wikidata.org/entity/Q27972540',
    'http://www.wikidata.org/entity/Q27972541',
    'http://www.wikidata.org/entity/Q27972544',
    'http://www.wikidata.org/entity/Q27972602',
    'http://www.wikidata.org/entity/Q27972708',
    'http://www.wikidata.org/entity/Q27973422',
    'http://www.wikidata.org/entity/Q27973498',
    'http://www.wikidata.org/entity/Q27973501',
    'http://www.wikidata.org/entity/Q27973516',
    'http://www.wikidata.org/entity/Q27973519',
    'http://www.wikidata.org/entity/Q27973620',
    'http://www.wikidata.org/entity/Q27973732',
    'http://www.wikidata.org/entity/Q27973983',
    'http://www.wikidata.org/entity/Q27974123',
    'http://www.wikidata.org/entity/Q27974482',
    'http://www.wikidata.org/entity/Q27976474',
    'http://www.wikidata.org/entity/Q27976509',
    'http://www.wikidata.org/entity/Q27976511',
    'http://www.wikidata.org/entity/Q27976512',
    'http://www.wikidata.org/entity/Q27976514',
    'http://www.wikidata.org/entity/Q27976516',
    'http://www.wikidata.org/entity/Q27976517',
    'http://www.wikidata.org/entity/Q27976518',
    'http://www.wikidata.org/entity/Q27978521',
    'http://www.wikidata.org/entity/Q27987775',
    'http://www.wikidata.org/entity/Q28000047',
    'http://www.wikidata.org/entity/Q28000121',
    'http://www.wikidata.org/entity/Q28005460',
    'http://www.wikidata.org/entity/Q28005463',
    'http://www.wikidata.org/entity/Q28005523',
    'http://www.wikidata.org/entity/Q28005554',
    'http://www.wikidata.org/entity/Q28005564',
    'http://www.wikidata.org/entity/Q28005781',
    'http://www.wikidata.org/entity/Q28018765',
    'http://www.wikidata.org/entity/Q28020278',
    'http://www.wikidata.org/entity/Q28026612',
    'http://www.wikidata.org/entity/Q28030935',
    'http://www.wikidata.org/entity/Q28032455',
    'http://www.wikidata.org/entity/Q28032457',
    'http://www.wikidata.org/entity/Q28032458',
    'http://www.wikidata.org/entity/Q28032461',
    'http://www.wikidata.org/entity/Q28032466',
    'http://www.wikidata.org/entity/Q28032481',
    'http://www.wikidata.org/entity/Q28032484',
    'http://www.wikidata.org/entity/Q28036738',
    'http://www.wikidata.org/entity/Q28036740',
    'http://www.wikidata.org/entity/Q28036741',
    'http://www.wikidata.org/entity/Q28036743',
    'http://www.wikidata.org/entity/Q28036747',
    'http://www.wikidata.org/entity/Q28036749',
    'http://www.wikidata.org/entity/Q28036756',
    'http://www.wikidata.org/entity/Q28036762',
    'http://www.wikidata.org/entity/Q28044562',
    'http://www.wikidata.org/entity/Q28044576',
    'http://www.wikidata.org/entity/Q28049391',
    'http://www.wikidata.org/entity/Q28062241',
    'http://www.wikidata.org/entity/Q28069757',
    'http://www.wikidata.org/entity/Q28071394',
    'http://www.wikidata.org/entity/Q28080815',
    'http://www.wikidata.org/entity/Q28081930',
    'http://www.wikidata.org/entity/Q28081960',
    'http://www.wikidata.org/entity/Q28082461',
    'http://www.wikidata.org/entity/Q28083164',
    'http://www.wikidata.org/entity/Q28083357',
    'http://www.wikidata.org/entity/Q28083981',
    'http://www.wikidata.org/entity/Q28084527',
    'http://www.wikidata.org/entity/Q28084654',
    'http://www.wikidata.org/entity/Q28085018',
    'http://www.wikidata.org/entity/Q28085455',
    'http://www.wikidata.org/entity/Q28088806',
    'http://www.wikidata.org/entity/Q28090832',
    'http://www.wikidata.org/entity/Q28090939',
    'http://www.wikidata.org/entity/Q28096294',
    'http://www.wikidata.org/entity/Q28109330',
    'http://www.wikidata.org/entity/Q28111693',
    'http://www.wikidata.org/entity/Q28111696',
    'http://www.wikidata.org/entity/Q28111758',
    'http://www.wikidata.org/entity/Q28111792',
    'http://www.wikidata.org/entity/Q28111898',
    'http://www.wikidata.org/entity/Q28111908',
    'http://www.wikidata.org/entity/Q28111913',
    'http://www.wikidata.org/entity/Q28111930',
    'http://www.wikidata.org/entity/Q28111969',
    'http://www.wikidata.org/entity/Q28114789',
    'http://www.wikidata.org/entity/Q28114795',
    'http://www.wikidata.org/entity/Q28114818',
    'http://www.wikidata.org/entity/Q28114859',
    'http://www.wikidata.org/entity/Q28114920',
    'http://www.wikidata.org/entity/Q28114923',
    'http://www.wikidata.org/entity/Q28114939',
    'http://www.wikidata.org/entity/Q28114972',
    'http://www.wikidata.org/entity/Q28115025',
    'http://www.wikidata.org/entity/Q28115026',
    'http://www.wikidata.org/entity/Q28115048',
    'http://www.wikidata.org/entity/Q28115106',
    'http://www.wikidata.org/entity/Q28115131',
    'http://www.wikidata.org/entity/Q28115147',
    'http://www.wikidata.org/entity/Q28115189',
    'http://www.wikidata.org/entity/Q28115206',
    'http://www.wikidata.org/entity/Q28115232',
    'http://www.wikidata.org/entity/Q28115238',
    'http://www.wikidata.org/entity/Q28115423',
    'http://www.wikidata.org/entity/Q28115656',
    'http://www.wikidata.org/entity/Q28115687',
    'http://www.wikidata.org/entity/Q28115751',
    'http://www.wikidata.org/entity/Q28115843',
    'http://www.wikidata.org/entity/Q28116040',
    'http://www.wikidata.org/entity/Q28116107',
    'http://www.wikidata.org/entity/Q28116120',
    'http://www.wikidata.org/entity/Q28116208',
    'http://www.wikidata.org/entity/Q28116213',
    'http://www.wikidata.org/entity/Q28116308',
    'http://www.wikidata.org/entity/Q28116395',
    'http://www.wikidata.org/entity/Q28116470',
    'http://www.wikidata.org/entity/Q28116571',
    'http://www.wikidata.org/entity/Q28116607',
    'http://www.wikidata.org/entity/Q28116980',
    'http://www.wikidata.org/entity/Q28117072',
    'http://www.wikidata.org/entity/Q28117494',
    'http://www.wikidata.org/entity/Q28117650',
    'http://www.wikidata.org/entity/Q28117842',
    'http://www.wikidata.org/entity/Q28117866',
    'http://www.wikidata.org/entity/Q28117922',
    'http://www.wikidata.org/entity/Q28117928',
    'http://www.wikidata.org/entity/Q28117931',
    'http://www.wikidata.org/entity/Q28118022',
    'http://www.wikidata.org/entity/Q28118068',
    'http://www.wikidata.org/entity/Q28118215',
    'http://www.wikidata.org/entity/Q28118262',
    'http://www.wikidata.org/entity/Q28118296',
    'http://www.wikidata.org/entity/Q28118304',
    'http://www.wikidata.org/entity/Q28118306',
    'http://www.wikidata.org/entity/Q28118359',
    'http://www.wikidata.org/entity/Q28118386',
    'http://www.wikidata.org/entity/Q28118466',
    'http://www.wikidata.org/entity/Q28118562',
    'http://www.wikidata.org/entity/Q28118718',
    'http://www.wikidata.org/entity/Q28118823',
    'http://www.wikidata.org/entity/Q28118826',
    'http://www.wikidata.org/entity/Q28118852',
    'http://www.wikidata.org/entity/Q28118875',
    'http://www.wikidata.org/entity/Q28118928',
    'http://www.wikidata.org/entity/Q28118966',
    'http://www.wikidata.org/entity/Q28118975',
    'http://www.wikidata.org/entity/Q28118980',
    'http://www.wikidata.org/entity/Q28119018',
    'http://www.wikidata.org/entity/Q28119049',
    'http://www.wikidata.org/entity/Q28119124',
    'http://www.wikidata.org/entity/Q28119146',
    'http://www.wikidata.org/entity/Q28119154',
    'http://www.wikidata.org/entity/Q28119185',
    'http://www.wikidata.org/entity/Q28119190',
    'http://www.wikidata.org/entity/Q28119192',
    'http://www.wikidata.org/entity/Q28119198',
    'http://www.wikidata.org/entity/Q28119685',
    'http://www.wikidata.org/entity/Q28124697',
    'http://www.wikidata.org/entity/Q28124699',
    'http://www.wikidata.org/entity/Q28131414',
    'http://www.wikidata.org/entity/Q28131597',
    'http://www.wikidata.org/entity/Q28131598',
    'http://www.wikidata.org/entity/Q28131599',
    'http://www.wikidata.org/entity/Q28131600',
    'http://www.wikidata.org/entity/Q28131601',
    'http://www.wikidata.org/entity/Q28131602',
    'http://www.wikidata.org/entity/Q28131603',
    'http://www.wikidata.org/entity/Q28131604',
    'http://www.wikidata.org/entity/Q28131605',
    'http://www.wikidata.org/entity/Q28131606',
    'http://www.wikidata.org/entity/Q28131608',
    'http://www.wikidata.org/entity/Q28131610',
    'http://www.wikidata.org/entity/Q28131611',
    'http://www.wikidata.org/entity/Q28131612',
    'http://www.wikidata.org/entity/Q28131613',
    'http://www.wikidata.org/entity/Q28131614',
    'http://www.wikidata.org/entity/Q28131615',
    'http://www.wikidata.org/entity/Q28131616',
    'http://www.wikidata.org/entity/Q28131618',
    'http://www.wikidata.org/entity/Q28131620',
    'http://www.wikidata.org/entity/Q28131621',
    'http://www.wikidata.org/entity/Q28131622',
    'http://www.wikidata.org/entity/Q28131625',
    'http://www.wikidata.org/entity/Q28131626',
    'http://www.wikidata.org/entity/Q28131628',
    'http://www.wikidata.org/entity/Q28131632',
    'http://www.wikidata.org/entity/Q28131633',
    'http://www.wikidata.org/entity/Q28131634',
    'http://www.wikidata.org/entity/Q28131636',
    'http://www.wikidata.org/entity/Q28131637',
    'http://www.wikidata.org/entity/Q28131638',
    'http://www.wikidata.org/entity/Q28131641',
    'http://www.wikidata.org/entity/Q28131643',
    'http://www.wikidata.org/entity/Q28131645',
    'http://www.wikidata.org/entity/Q28131646',
    'http://www.wikidata.org/entity/Q28131647',
    'http://www.wikidata.org/entity/Q28131648',
    'http://www.wikidata.org/entity/Q28131650',
    'http://www.wikidata.org/entity/Q28131652',
    'http://www.wikidata.org/entity/Q28131653',
    'http://www.wikidata.org/entity/Q28131654',
    'http://www.wikidata.org/entity/Q28131658',
    'http://www.wikidata.org/entity/Q28131660',
    'http://www.wikidata.org/entity/Q28131661',
    'http://www.wikidata.org/entity/Q28131662',
    'http://www.wikidata.org/entity/Q28131663',
    'http://www.wikidata.org/entity/Q28131668',
    'http://www.wikidata.org/entity/Q28131669',
    'http://www.wikidata.org/entity/Q28131672',
    'http://www.wikidata.org/entity/Q28131675',
    'http://www.wikidata.org/entity/Q28131676',
    'http://www.wikidata.org/entity/Q28131683',
    'http://www.wikidata.org/entity/Q28131684',
    'http://www.wikidata.org/entity/Q28131686',
    'http://www.wikidata.org/entity/Q28131688',
    'http://www.wikidata.org/entity/Q28131689',
    'http://www.wikidata.org/entity/Q28131690',
    'http://www.wikidata.org/entity/Q28131694',
    'http://www.wikidata.org/entity/Q28131695',
    'http://www.wikidata.org/entity/Q28131697',
    'http://www.wikidata.org/entity/Q28131699',
    'http://www.wikidata.org/entity/Q28131701',
    'http://www.wikidata.org/entity/Q28131702',
    'http://www.wikidata.org/entity/Q28131703',
    'http://www.wikidata.org/entity/Q28131704',
    'http://www.wikidata.org/entity/Q28131705',
    'http://www.wikidata.org/entity/Q28131706',
    'http://www.wikidata.org/entity/Q28131707',
    'http://www.wikidata.org/entity/Q28131709',
    'http://www.wikidata.org/entity/Q28131710',
    'http://www.wikidata.org/entity/Q28131711',
    'http://www.wikidata.org/entity/Q28131712',
    'http://www.wikidata.org/entity/Q28131713',
    'http://www.wikidata.org/entity/Q28131715',
    'http://www.wikidata.org/entity/Q28131718',
    'http://www.wikidata.org/entity/Q28131720',
    'http://www.wikidata.org/entity/Q28131723',
    'http://www.wikidata.org/entity/Q28131725',
    'http://www.wikidata.org/entity/Q28131726',
    'http://www.wikidata.org/entity/Q28131727',
    'http://www.wikidata.org/entity/Q28131730',
    'http://www.wikidata.org/entity/Q28131732',
    'http://www.wikidata.org/entity/Q28131735',
    'http://www.wikidata.org/entity/Q28131736',
    'http://www.wikidata.org/entity/Q28131737',
    'http://www.wikidata.org/entity/Q28131738',
    'http://www.wikidata.org/entity/Q28131740',
    'http://www.wikidata.org/entity/Q28131742',
    'http://www.wikidata.org/entity/Q28131744',
    'http://www.wikidata.org/entity/Q28131746',
    'http://www.wikidata.org/entity/Q28131747',
    'http://www.wikidata.org/entity/Q28131748',
    'http://www.wikidata.org/entity/Q28131749',
    'http://www.wikidata.org/entity/Q28131750',
    'http://www.wikidata.org/entity/Q28131751',
    'http://www.wikidata.org/entity/Q28131753',
    'http://www.wikidata.org/entity/Q28131754',
    'http://www.wikidata.org/entity/Q28131755',
    'http://www.wikidata.org/entity/Q28131756',
    'http://www.wikidata.org/entity/Q28131757',
    'http://www.wikidata.org/entity/Q28131760',
    'http://www.wikidata.org/entity/Q28131763',
    'http://www.wikidata.org/entity/Q28131764',
    'http://www.wikidata.org/entity/Q28131765',
    'http://www.wikidata.org/entity/Q28131769',
    'http://www.wikidata.org/entity/Q28131770',
    'http://www.wikidata.org/entity/Q28131772',
    'http://www.wikidata.org/entity/Q28131773',
    'http://www.wikidata.org/entity/Q28131775',
    'http://www.wikidata.org/entity/Q28131776',
    'http://www.wikidata.org/entity/Q28131777',
    'http://www.wikidata.org/entity/Q28131778',
    'http://www.wikidata.org/entity/Q28131779',
    'http://www.wikidata.org/entity/Q28131780',
    'http://www.wikidata.org/entity/Q28131781',
    'http://www.wikidata.org/entity/Q28131782',
    'http://www.wikidata.org/entity/Q28131783',
    'http://www.wikidata.org/entity/Q28131784',
    'http://www.wikidata.org/entity/Q28131785',
    'http://www.wikidata.org/entity/Q28131787',
    'http://www.wikidata.org/entity/Q28131788',
    'http://www.wikidata.org/entity/Q28131789',
    'http://www.wikidata.org/entity/Q28131790',
    'http://www.wikidata.org/entity/Q28131791',
    'http://www.wikidata.org/entity/Q28131792',
    'http://www.wikidata.org/entity/Q28131793',
    'http://www.wikidata.org/entity/Q28131794',
    'http://www.wikidata.org/entity/Q28131795',
    'http://www.wikidata.org/entity/Q28131796',
    'http://www.wikidata.org/entity/Q28131797',
    'http://www.wikidata.org/entity/Q28131798',
    'http://www.wikidata.org/entity/Q28131800',
    'http://www.wikidata.org/entity/Q28131801',
    'http://www.wikidata.org/entity/Q28131802',
    'http://www.wikidata.org/entity/Q28131803',
    'http://www.wikidata.org/entity/Q28131804',
    'http://www.wikidata.org/entity/Q28131805',
    'http://www.wikidata.org/entity/Q28131806',
    'http://www.wikidata.org/entity/Q28131807',
    'http://www.wikidata.org/entity/Q28131808',
    'http://www.wikidata.org/entity/Q28131809',
    'http://www.wikidata.org/entity/Q28131810',
    'http://www.wikidata.org/entity/Q28131811',
    'http://www.wikidata.org/entity/Q28131812',
    'http://www.wikidata.org/entity/Q28131814',
    'http://www.wikidata.org/entity/Q28131815',
    'http://www.wikidata.org/entity/Q28131816',
    'http://www.wikidata.org/entity/Q28131817',
    'http://www.wikidata.org/entity/Q28131818',
    'http://www.wikidata.org/entity/Q28131819',
    'http://www.wikidata.org/entity/Q28131820',
    'http://www.wikidata.org/entity/Q28131821',
    'http://www.wikidata.org/entity/Q28131822',
    'http://www.wikidata.org/entity/Q28131824',
    'http://www.wikidata.org/entity/Q28131826',
    'http://www.wikidata.org/entity/Q28131827',
    'http://www.wikidata.org/entity/Q28131828',
    'http://www.wikidata.org/entity/Q28131829',
    'http://www.wikidata.org/entity/Q28131830',
    'http://www.wikidata.org/entity/Q28131831',
    'http://www.wikidata.org/entity/Q28131832',
    'http://www.wikidata.org/entity/Q28131833',
    'http://www.wikidata.org/entity/Q28131834',
    'http://www.wikidata.org/entity/Q28131835',
    'http://www.wikidata.org/entity/Q28131836',
    'http://www.wikidata.org/entity/Q28131837',
    'http://www.wikidata.org/entity/Q28131838',
    'http://www.wikidata.org/entity/Q28137554',
    'http://www.wikidata.org/entity/Q28137622',
    'http://www.wikidata.org/entity/Q28137774',
    'http://www.wikidata.org/entity/Q28137803',
    'http://www.wikidata.org/entity/Q28137851',
    'http://www.wikidata.org/entity/Q28137860',
    'http://www.wikidata.org/entity/Q28137904',
    'http://www.wikidata.org/entity/Q28137916',
    'http://www.wikidata.org/entity/Q28137965',
    'http://www.wikidata.org/entity/Q28138001',
    'http://www.wikidata.org/entity/Q28138016',
    'http://www.wikidata.org/entity/Q28138029',
    'http://www.wikidata.org/entity/Q28138068',
    'http://www.wikidata.org/entity/Q28138083',
    'http://www.wikidata.org/entity/Q28138085',
    'http://www.wikidata.org/entity/Q28138096',
    'http://www.wikidata.org/entity/Q28138151',
    'http://www.wikidata.org/entity/Q28138201',
    'http://www.wikidata.org/entity/Q28138248',
    'http://www.wikidata.org/entity/Q28138274',
    'http://www.wikidata.org/entity/Q28138338',
    'http://www.wikidata.org/entity/Q28138378',
    'http://www.wikidata.org/entity/Q28138410',
    'http://www.wikidata.org/entity/Q28138415',
    'http://www.wikidata.org/entity/Q28138437',
    'http://www.wikidata.org/entity/Q28138449',
    'http://www.wikidata.org/entity/Q28138465',
    'http://www.wikidata.org/entity/Q28138510',
    'http://www.wikidata.org/entity/Q28138556',
    'http://www.wikidata.org/entity/Q28138557',
    'http://www.wikidata.org/entity/Q28138570',
    'http://www.wikidata.org/entity/Q28138580',
    'http://www.wikidata.org/entity/Q28138604',
    'http://www.wikidata.org/entity/Q28138607',
    'http://www.wikidata.org/entity/Q28138617',
    'http://www.wikidata.org/entity/Q28138655',
    'http://www.wikidata.org/entity/Q28138780',
    'http://www.wikidata.org/entity/Q28138782',
    'http://www.wikidata.org/entity/Q28138792',
    'http://www.wikidata.org/entity/Q28138817',
    'http://www.wikidata.org/entity/Q28138834',
    'http://www.wikidata.org/entity/Q28138839',
    'http://www.wikidata.org/entity/Q28138850',
    'http://www.wikidata.org/entity/Q28138855',
    'http://www.wikidata.org/entity/Q28138890',
    'http://www.wikidata.org/entity/Q28138918',
    'http://www.wikidata.org/entity/Q28138923',
    'http://www.wikidata.org/entity/Q28138953',
    'http://www.wikidata.org/entity/Q28138955',
    'http://www.wikidata.org/entity/Q28138956',
    'http://www.wikidata.org/entity/Q28138968',
    'http://www.wikidata.org/entity/Q28138979',
    'http://www.wikidata.org/entity/Q28138991',
    'http://www.wikidata.org/entity/Q28138996',
    'http://www.wikidata.org/entity/Q28139001',
    'http://www.wikidata.org/entity/Q28139056',
    'http://www.wikidata.org/entity/Q28139116',
    'http://www.wikidata.org/entity/Q28139151',
    'http://www.wikidata.org/entity/Q28139166',
    'http://www.wikidata.org/entity/Q28139176',
    'http://www.wikidata.org/entity/Q28139177',
    'http://www.wikidata.org/entity/Q28139253',
    'http://www.wikidata.org/entity/Q28139257',
    'http://www.wikidata.org/entity/Q28139317',
    'http://www.wikidata.org/entity/Q28139371',
    'http://www.wikidata.org/entity/Q28139415',
    'http://www.wikidata.org/entity/Q28139429',
    'http://www.wikidata.org/entity/Q28139447',
    'http://www.wikidata.org/entity/Q28139459',
    'http://www.wikidata.org/entity/Q28139487',
    'http://www.wikidata.org/entity/Q28139504',
    'http://www.wikidata.org/entity/Q28139530',
    'http://www.wikidata.org/entity/Q28139536',
    'http://www.wikidata.org/entity/Q28139564',
    'http://www.wikidata.org/entity/Q28139621',
    'http://www.wikidata.org/entity/Q28139627',
    'http://www.wikidata.org/entity/Q28139637',
    'http://www.wikidata.org/entity/Q28139683',
    'http://www.wikidata.org/entity/Q28139691',
    'http://www.wikidata.org/entity/Q28139696',
    'http://www.wikidata.org/entity/Q28139717',
    'http://www.wikidata.org/entity/Q28139722',
    'http://www.wikidata.org/entity/Q28139787',
    'http://www.wikidata.org/entity/Q28139868',
    'http://www.wikidata.org/entity/Q28139874',
    'http://www.wikidata.org/entity/Q28139876',
    'http://www.wikidata.org/entity/Q28139910',
    'http://www.wikidata.org/entity/Q28139919',
    'http://www.wikidata.org/entity/Q28139982',
    'http://www.wikidata.org/entity/Q28139987',
    'http://www.wikidata.org/entity/Q28139998',
    'http://www.wikidata.org/entity/Q28140006',
    'http://www.wikidata.org/entity/Q28140008',
    'http://www.wikidata.org/entity/Q28140019',
    'http://www.wikidata.org/entity/Q28140038',
    'http://www.wikidata.org/entity/Q28140044',
    'http://www.wikidata.org/entity/Q28140045',
    'http://www.wikidata.org/entity/Q28140062',
    'http://www.wikidata.org/entity/Q28140129',
    'http://www.wikidata.org/entity/Q28140136',
    'http://www.wikidata.org/entity/Q28140155',
    'http://www.wikidata.org/entity/Q28140156',
    'http://www.wikidata.org/entity/Q28140163',
    'http://www.wikidata.org/entity/Q28140216',
    'http://www.wikidata.org/entity/Q28140220',
    'http://www.wikidata.org/entity/Q28140223',
    'http://www.wikidata.org/entity/Q28140238',
    'http://www.wikidata.org/entity/Q28140286',
    'http://www.wikidata.org/entity/Q28140313',
    'http://www.wikidata.org/entity/Q28140369',
    'http://www.wikidata.org/entity/Q28140397',
    'http://www.wikidata.org/entity/Q28140401',
    'http://www.wikidata.org/entity/Q28140428',
    'http://www.wikidata.org/entity/Q28140445',
    'http://www.wikidata.org/entity/Q28140447',
    'http://www.wikidata.org/entity/Q28140451',
    'http://www.wikidata.org/entity/Q28140456',
    'http://www.wikidata.org/entity/Q28140495',
    'http://www.wikidata.org/entity/Q28140520',
    'http://www.wikidata.org/entity/Q28140534',
    'http://www.wikidata.org/entity/Q28140578',
    'http://www.wikidata.org/entity/Q28140600',
    'http://www.wikidata.org/entity/Q28140626',
    'http://www.wikidata.org/entity/Q28140631',
    'http://www.wikidata.org/entity/Q28140722',
    'http://www.wikidata.org/entity/Q28140726',
    'http://www.wikidata.org/entity/Q28140740',
    'http://www.wikidata.org/entity/Q28140761',
    'http://www.wikidata.org/entity/Q28140788',
    'http://www.wikidata.org/entity/Q28140789',
    'http://www.wikidata.org/entity/Q28140796',
    'http://www.wikidata.org/entity/Q28140835',
    'http://www.wikidata.org/entity/Q28140844',
    'http://www.wikidata.org/entity/Q28140847',
    'http://www.wikidata.org/entity/Q28140862',
    'http://www.wikidata.org/entity/Q28140863',
    'http://www.wikidata.org/entity/Q28140867',
    'http://www.wikidata.org/entity/Q28140874',
    'http://www.wikidata.org/entity/Q28140878',
    'http://www.wikidata.org/entity/Q28140901',
    'http://www.wikidata.org/entity/Q28140932',
    'http://www.wikidata.org/entity/Q28140978',
    'http://www.wikidata.org/entity/Q28140985',
    'http://www.wikidata.org/entity/Q28141023',
    'http://www.wikidata.org/entity/Q28141040',
    'http://www.wikidata.org/entity/Q28141056',
    'http://www.wikidata.org/entity/Q28141080',
    'http://www.wikidata.org/entity/Q28141105',
    'http://www.wikidata.org/entity/Q28141108',
    'http://www.wikidata.org/entity/Q28141138',
    'http://www.wikidata.org/entity/Q28141143',
    'http://www.wikidata.org/entity/Q28141190',
    'http://www.wikidata.org/entity/Q28141227',
    'http://www.wikidata.org/entity/Q28141249',
    'http://www.wikidata.org/entity/Q28141339',
    'http://www.wikidata.org/entity/Q28141355',
    'http://www.wikidata.org/entity/Q28141411',
    'http://www.wikidata.org/entity/Q28141417',
    'http://www.wikidata.org/entity/Q28141424',
    'http://www.wikidata.org/entity/Q28141442',
    'http://www.wikidata.org/entity/Q28141447',
    'http://www.wikidata.org/entity/Q28141458',
    'http://www.wikidata.org/entity/Q28141498',
    'http://www.wikidata.org/entity/Q28141499',
    'http://www.wikidata.org/entity/Q28141500',
    'http://www.wikidata.org/entity/Q28141503',
    'http://www.wikidata.org/entity/Q28141504',
    'http://www.wikidata.org/entity/Q28141518',
    'http://www.wikidata.org/entity/Q28141589',
    'http://www.wikidata.org/entity/Q28141602',
    'http://www.wikidata.org/entity/Q28141645',
    'http://www.wikidata.org/entity/Q28141682',
    'http://www.wikidata.org/entity/Q28141690',
    'http://www.wikidata.org/entity/Q28141707',
    'http://www.wikidata.org/entity/Q28141718',
    'http://www.wikidata.org/entity/Q28141785',
    'http://www.wikidata.org/entity/Q28141817',
    'http://www.wikidata.org/entity/Q28141851',
    'http://www.wikidata.org/entity/Q28141852',
    'http://www.wikidata.org/entity/Q28141901',
    'http://www.wikidata.org/entity/Q28142010',
    'http://www.wikidata.org/entity/Q28142034',
    'http://www.wikidata.org/entity/Q28142041',
    'http://www.wikidata.org/entity/Q28142072',
    'http://www.wikidata.org/entity/Q28142133',
    'http://www.wikidata.org/entity/Q28142142',
    'http://www.wikidata.org/entity/Q28142180',
    'http://www.wikidata.org/entity/Q28142184',
    'http://www.wikidata.org/entity/Q28142488',
    'http://www.wikidata.org/entity/Q28142501',
    'http://www.wikidata.org/entity/Q28142534',
    'http://www.wikidata.org/entity/Q28142592',
    'http://www.wikidata.org/entity/Q28142605',
    'http://www.wikidata.org/entity/Q28142612',
    'http://www.wikidata.org/entity/Q28142613',
    'http://www.wikidata.org/entity/Q28142672',
    'http://www.wikidata.org/entity/Q28142731',
    'http://www.wikidata.org/entity/Q28142746',
    'http://www.wikidata.org/entity/Q28142783',
    'http://www.wikidata.org/entity/Q28142796',
    'http://www.wikidata.org/entity/Q28142811',
    'http://www.wikidata.org/entity/Q28142917',
    'http://www.wikidata.org/entity/Q28142922',
    'http://www.wikidata.org/entity/Q28142963',
    'http://www.wikidata.org/entity/Q28142979',
    'http://www.wikidata.org/entity/Q28142981',
    'http://www.wikidata.org/entity/Q28142998',
    'http://www.wikidata.org/entity/Q28143010',
    'http://www.wikidata.org/entity/Q28143046',
    'http://www.wikidata.org/entity/Q28143051',
    'http://www.wikidata.org/entity/Q28143064',
    'http://www.wikidata.org/entity/Q28143066',
    'http://www.wikidata.org/entity/Q28143077',
    'http://www.wikidata.org/entity/Q28143118',
    'http://www.wikidata.org/entity/Q28143121',
    'http://www.wikidata.org/entity/Q28143123',
    'http://www.wikidata.org/entity/Q28143139',
    'http://www.wikidata.org/entity/Q28143206',
    'http://www.wikidata.org/entity/Q28143207',
    'http://www.wikidata.org/entity/Q28143355',
    'http://www.wikidata.org/entity/Q28143393',
    'http://www.wikidata.org/entity/Q28143399',
    'http://www.wikidata.org/entity/Q28143405',
    'http://www.wikidata.org/entity/Q28143408',
    'http://www.wikidata.org/entity/Q28143430',
    'http://www.wikidata.org/entity/Q28143448',
    'http://www.wikidata.org/entity/Q28143450',
    'http://www.wikidata.org/entity/Q28143452',
    'http://www.wikidata.org/entity/Q28143505',
    'http://www.wikidata.org/entity/Q28143530',
    'http://www.wikidata.org/entity/Q28143578',
    'http://www.wikidata.org/entity/Q28143588',
    'http://www.wikidata.org/entity/Q28143658',
    'http://www.wikidata.org/entity/Q28143666',
    'http://www.wikidata.org/entity/Q28143714',
    'http://www.wikidata.org/entity/Q28143767',
    'http://www.wikidata.org/entity/Q28143793',
    'http://www.wikidata.org/entity/Q28143799',
    'http://www.wikidata.org/entity/Q28143822',
    'http://www.wikidata.org/entity/Q28143827',
    'http://www.wikidata.org/entity/Q28143833',
    'http://www.wikidata.org/entity/Q28143877',
    'http://www.wikidata.org/entity/Q28143881',
    'http://www.wikidata.org/entity/Q28143905',
    'http://www.wikidata.org/entity/Q28143998',
    'http://www.wikidata.org/entity/Q28144084',
    'http://www.wikidata.org/entity/Q28144086',
    'http://www.wikidata.org/entity/Q28144090',
    'http://www.wikidata.org/entity/Q28144100',
    'http://www.wikidata.org/entity/Q28144113',
    'http://www.wikidata.org/entity/Q28144133',
    'http://www.wikidata.org/entity/Q28144179',
    'http://www.wikidata.org/entity/Q28144211',
    'http://www.wikidata.org/entity/Q28144256',
    'http://www.wikidata.org/entity/Q28144319',
    'http://www.wikidata.org/entity/Q28144326',
    'http://www.wikidata.org/entity/Q28144330',
    'http://www.wikidata.org/entity/Q28144339',
    'http://www.wikidata.org/entity/Q28144345',
    'http://www.wikidata.org/entity/Q28144347',
    'http://www.wikidata.org/entity/Q28144351',
    'http://www.wikidata.org/entity/Q28144403',
    'http://www.wikidata.org/entity/Q28144408',
    'http://www.wikidata.org/entity/Q28144459',
    'http://www.wikidata.org/entity/Q28144497',
    'http://www.wikidata.org/entity/Q28144517',
    'http://www.wikidata.org/entity/Q28144522',
    'http://www.wikidata.org/entity/Q28144546',
    'http://www.wikidata.org/entity/Q28144559',
    'http://www.wikidata.org/entity/Q28144567',
    'http://www.wikidata.org/entity/Q28144576',
    'http://www.wikidata.org/entity/Q28144621',
    'http://www.wikidata.org/entity/Q28144698',
    'http://www.wikidata.org/entity/Q28144741',
    'http://www.wikidata.org/entity/Q28144748',
    'http://www.wikidata.org/entity/Q28144781',
    'http://www.wikidata.org/entity/Q28144797',
    'http://www.wikidata.org/entity/Q28144833',
    'http://www.wikidata.org/entity/Q28144870',
    'http://www.wikidata.org/entity/Q28144934',
    'http://www.wikidata.org/entity/Q28145002',
    'http://www.wikidata.org/entity/Q28145018',
    'http://www.wikidata.org/entity/Q28145154',
    'http://www.wikidata.org/entity/Q28145169',
    'http://www.wikidata.org/entity/Q28145172',
    'http://www.wikidata.org/entity/Q28145177',
    'http://www.wikidata.org/entity/Q28145208',
    'http://www.wikidata.org/entity/Q28145297',
    'http://www.wikidata.org/entity/Q28145306',
    'http://www.wikidata.org/entity/Q28145324',
    'http://www.wikidata.org/entity/Q28145358',
    'http://www.wikidata.org/entity/Q28145361',
    'http://www.wikidata.org/entity/Q28145367',
    'http://www.wikidata.org/entity/Q28145382',
    'http://www.wikidata.org/entity/Q28145391',
    'http://www.wikidata.org/entity/Q28145423',
    'http://www.wikidata.org/entity/Q28145434',
    'http://www.wikidata.org/entity/Q28145476',
    'http://www.wikidata.org/entity/Q28145507',
    'http://www.wikidata.org/entity/Q28145545',
    'http://www.wikidata.org/entity/Q28145559',
    'http://www.wikidata.org/entity/Q28145560',
    'http://www.wikidata.org/entity/Q28145614',
    'http://www.wikidata.org/entity/Q28145635',
    'http://www.wikidata.org/entity/Q28145651',
    'http://www.wikidata.org/entity/Q28145700',
    'http://www.wikidata.org/entity/Q28145705',
    'http://www.wikidata.org/entity/Q28145712',
    'http://www.wikidata.org/entity/Q28145723',
    'http://www.wikidata.org/entity/Q28145744',
    'http://www.wikidata.org/entity/Q28145745',
    'http://www.wikidata.org/entity/Q28145747',
    'http://www.wikidata.org/entity/Q28145752',
    'http://www.wikidata.org/entity/Q28145754',
    'http://www.wikidata.org/entity/Q28145755',
    'http://www.wikidata.org/entity/Q28145756',
    'http://www.wikidata.org/entity/Q28145807',
    'http://www.wikidata.org/entity/Q28145880',
    'http://www.wikidata.org/entity/Q28145893',
    'http://www.wikidata.org/entity/Q28145964',
    'http://www.wikidata.org/entity/Q28145970',
    'http://www.wikidata.org/entity/Q28146072',
    'http://www.wikidata.org/entity/Q28146107',
    'http://www.wikidata.org/entity/Q28146108',
    'http://www.wikidata.org/entity/Q28146167',
    'http://www.wikidata.org/entity/Q28146173',
    'http://www.wikidata.org/entity/Q28146187',
    'http://www.wikidata.org/entity/Q28146256',
    'http://www.wikidata.org/entity/Q28155799',
    'http://www.wikidata.org/entity/Q28155804',
    'http://www.wikidata.org/entity/Q28155817',
    'http://www.wikidata.org/entity/Q28155919',
    'http://www.wikidata.org/entity/Q28156047',
    'http://www.wikidata.org/entity/Q28156084',
    'http://www.wikidata.org/entity/Q28156208',
    'http://www.wikidata.org/entity/Q28160135',
    'http://www.wikidata.org/entity/Q28165115',
    'http://www.wikidata.org/entity/Q28166649',
    'http://www.wikidata.org/entity/Q28167733',
    'http://www.wikidata.org/entity/Q28168881',
    'http://www.wikidata.org/entity/Q28169189',
    'http://www.wikidata.org/entity/Q28174568',
    'http://www.wikidata.org/entity/Q28174787',
    'http://www.wikidata.org/entity/Q28175733',
    'http://www.wikidata.org/entity/Q28175802',
    'http://www.wikidata.org/entity/Q28176142',
    'http://www.wikidata.org/entity/Q28176663',
    'http://www.wikidata.org/entity/Q28176681',
    'http://www.wikidata.org/entity/Q28177348',
    'http://www.wikidata.org/entity/Q28178021',
    'http://www.wikidata.org/entity/Q28179415',
    'http://www.wikidata.org/entity/Q28179876',
    'http://www.wikidata.org/entity/Q28180100',
    'http://www.wikidata.org/entity/Q28180324',
    'http://www.wikidata.org/entity/Q28180348',
    'http://www.wikidata.org/entity/Q28180357',
    'http://www.wikidata.org/entity/Q28180426',
    'http://www.wikidata.org/entity/Q28180741',
    'http://www.wikidata.org/entity/Q28180834',
    'http://www.wikidata.org/entity/Q28181133',
    'http://www.wikidata.org/entity/Q28181305',
    'http://www.wikidata.org/entity/Q28181517',
    'http://www.wikidata.org/entity/Q28181571',
    'http://www.wikidata.org/entity/Q28181605',
    'http://www.wikidata.org/entity/Q28181608',
    'http://www.wikidata.org/entity/Q28181663',
    'http://www.wikidata.org/entity/Q28181676',
    'http://www.wikidata.org/entity/Q28181688',
    'http://www.wikidata.org/entity/Q28181692',
    'http://www.wikidata.org/entity/Q28181828',
    'http://www.wikidata.org/entity/Q28181875',
    'http://www.wikidata.org/entity/Q28181979',
    'http://www.wikidata.org/entity/Q28181984',
    'http://www.wikidata.org/entity/Q28182033',
    'http://www.wikidata.org/entity/Q28182148',
    'http://www.wikidata.org/entity/Q28182301',
    'http://www.wikidata.org/entity/Q28182767',
    'http://www.wikidata.org/entity/Q28182798',
    'http://www.wikidata.org/entity/Q28182890',
    'http://www.wikidata.org/entity/Q28182933',
    'http://www.wikidata.org/entity/Q28182969',
    'http://www.wikidata.org/entity/Q28182995',
    'http://www.wikidata.org/entity/Q28183021',
    'http://www.wikidata.org/entity/Q28183131',
    'http://www.wikidata.org/entity/Q28183279',
    'http://www.wikidata.org/entity/Q28183380',
    'http://www.wikidata.org/entity/Q28183411',
    'http://www.wikidata.org/entity/Q28183531',
    'http://www.wikidata.org/entity/Q28183597',
    'http://www.wikidata.org/entity/Q28183707',
    'http://www.wikidata.org/entity/Q28183749',
    'http://www.wikidata.org/entity/Q28183834',
    'http://www.wikidata.org/entity/Q28183992',
    'http://www.wikidata.org/entity/Q28184074',
    'http://www.wikidata.org/entity/Q28184265',
    'http://www.wikidata.org/entity/Q28184312',
    'http://www.wikidata.org/entity/Q28184343',
    'http://www.wikidata.org/entity/Q28184356',
    'http://www.wikidata.org/entity/Q28184760',
    'http://www.wikidata.org/entity/Q28184842',
    'http://www.wikidata.org/entity/Q28184983',
    'http://www.wikidata.org/entity/Q28185036',
    'http://www.wikidata.org/entity/Q28185062',
    'http://www.wikidata.org/entity/Q28185075',
    'http://www.wikidata.org/entity/Q28185218',
    'http://www.wikidata.org/entity/Q28185323',
    'http://www.wikidata.org/entity/Q28185439',
    'http://www.wikidata.org/entity/Q28185453',
    'http://www.wikidata.org/entity/Q28185475',
    'http://www.wikidata.org/entity/Q28185502',
    'http://www.wikidata.org/entity/Q28185515',
    'http://www.wikidata.org/entity/Q28185520',
    'http://www.wikidata.org/entity/Q28185637',
    'http://www.wikidata.org/entity/Q28185677',
    'http://www.wikidata.org/entity/Q28185761',
    'http://www.wikidata.org/entity/Q28185783',
    'http://www.wikidata.org/entity/Q28185796',
    'http://www.wikidata.org/entity/Q28185845',
    'http://www.wikidata.org/entity/Q28185944',
    'http://www.wikidata.org/entity/Q28185988',
    'http://www.wikidata.org/entity/Q28186001',
    'http://www.wikidata.org/entity/Q28186096',
    'http://www.wikidata.org/entity/Q28186173',
    'http://www.wikidata.org/entity/Q28186251',
    'http://www.wikidata.org/entity/Q28186303',
    'http://www.wikidata.org/entity/Q28186509',
    'http://www.wikidata.org/entity/Q28186592',
    'http://www.wikidata.org/entity/Q28186603',
    'http://www.wikidata.org/entity/Q28186749',
    'http://www.wikidata.org/entity/Q28186765',
    'http://www.wikidata.org/entity/Q28186803',
    'http://www.wikidata.org/entity/Q28186874',
    'http://www.wikidata.org/entity/Q28186993',
    'http://www.wikidata.org/entity/Q28187196',
    'http://www.wikidata.org/entity/Q28187266',
    'http://www.wikidata.org/entity/Q28187368',
    'http://www.wikidata.org/entity/Q28187453',
    'http://www.wikidata.org/entity/Q28187604',
    'http://www.wikidata.org/entity/Q28187744',
    'http://www.wikidata.org/entity/Q28187783',
    'http://www.wikidata.org/entity/Q28187867',
    'http://www.wikidata.org/entity/Q28187904',
    'http://www.wikidata.org/entity/Q28188025',
    'http://www.wikidata.org/entity/Q28188098',
    'http://www.wikidata.org/entity/Q28188106',
    'http://www.wikidata.org/entity/Q28188162',
    'http://www.wikidata.org/entity/Q28188169',
    'http://www.wikidata.org/entity/Q28188182',
    'http://www.wikidata.org/entity/Q28188233',
    'http://www.wikidata.org/entity/Q28188266',
    'http://www.wikidata.org/entity/Q28188284',
    'http://www.wikidata.org/entity/Q28188357',
    'http://www.wikidata.org/entity/Q28188380',
    'http://www.wikidata.org/entity/Q28188430',
    'http://www.wikidata.org/entity/Q28188474',
    'http://www.wikidata.org/entity/Q28188496',
    'http://www.wikidata.org/entity/Q28188643',
    'http://www.wikidata.org/entity/Q28188651',
    'http://www.wikidata.org/entity/Q28188763',
    'http://www.wikidata.org/entity/Q28188775',
    'http://www.wikidata.org/entity/Q28188949',
    'http://www.wikidata.org/entity/Q28189245',
    'http://www.wikidata.org/entity/Q28189338',
    'http://www.wikidata.org/entity/Q28189339',
    'http://www.wikidata.org/entity/Q28189472',
    'http://www.wikidata.org/entity/Q28189476',
    'http://www.wikidata.org/entity/Q28189493',
    'http://www.wikidata.org/entity/Q28189500',
    'http://www.wikidata.org/entity/Q28189514',
    'http://www.wikidata.org/entity/Q28189614',
    'http://www.wikidata.org/entity/Q28189635',
    'http://www.wikidata.org/entity/Q28189644',
    'http://www.wikidata.org/entity/Q28189911',
    'http://www.wikidata.org/entity/Q28189945',
    'http://www.wikidata.org/entity/Q28190036',
    'http://www.wikidata.org/entity/Q28190053',
    'http://www.wikidata.org/entity/Q28190066',
    'http://www.wikidata.org/entity/Q28190070',
    'http://www.wikidata.org/entity/Q28190084',
    'http://www.wikidata.org/entity/Q28190140',
    'http://www.wikidata.org/entity/Q28190223',
    'http://www.wikidata.org/entity/Q28190263',
    'http://www.wikidata.org/entity/Q28190300',
    'http://www.wikidata.org/entity/Q28190307',
    'http://www.wikidata.org/entity/Q28190343',
    'http://www.wikidata.org/entity/Q28190379',
    'http://www.wikidata.org/entity/Q28190392',
    'http://www.wikidata.org/entity/Q28190470',
    'http://www.wikidata.org/entity/Q28190475',
    'http://www.wikidata.org/entity/Q28190508',
    'http://www.wikidata.org/entity/Q28190513',
    'http://www.wikidata.org/entity/Q28190526',
    'http://www.wikidata.org/entity/Q28190600',
    'http://www.wikidata.org/entity/Q28190632',
    'http://www.wikidata.org/entity/Q28190653',
    'http://www.wikidata.org/entity/Q28190704',
    'http://www.wikidata.org/entity/Q28190708',
    'http://www.wikidata.org/entity/Q28190916',
    'http://www.wikidata.org/entity/Q28190938',
    'http://www.wikidata.org/entity/Q28191062',
    'http://www.wikidata.org/entity/Q28191365',
    'http://www.wikidata.org/entity/Q28191390',
    'http://www.wikidata.org/entity/Q28191444',
    'http://www.wikidata.org/entity/Q28191456',
    'http://www.wikidata.org/entity/Q28191546',
    'http://www.wikidata.org/entity/Q28191656',
    'http://www.wikidata.org/entity/Q28191696',
    'http://www.wikidata.org/entity/Q28191713',
    'http://www.wikidata.org/entity/Q28191761',
    'http://www.wikidata.org/entity/Q28191873',
    'http://www.wikidata.org/entity/Q28192400',
    'http://www.wikidata.org/entity/Q28192518',
    'http://www.wikidata.org/entity/Q28192620',
    'http://www.wikidata.org/entity/Q28192834',
    'http://www.wikidata.org/entity/Q28193186',
    'http://www.wikidata.org/entity/Q28193340',
    'http://www.wikidata.org/entity/Q28193388',
    'http://www.wikidata.org/entity/Q28193680',
    'http://www.wikidata.org/entity/Q28194232',
    'http://www.wikidata.org/entity/Q28194924',
    'http://www.wikidata.org/entity/Q28195274',
    'http://www.wikidata.org/entity/Q28195296',
    'http://www.wikidata.org/entity/Q28195357',
    'http://www.wikidata.org/entity/Q28195772',
    'http://www.wikidata.org/entity/Q28195986',
    'http://www.wikidata.org/entity/Q28196405',
    'http://www.wikidata.org/entity/Q28196661',
    'http://www.wikidata.org/entity/Q28196696',
    'http://www.wikidata.org/entity/Q28198051',
    'http://www.wikidata.org/entity/Q28198054',
    'http://www.wikidata.org/entity/Q28198097',
    'http://www.wikidata.org/entity/Q28198119',
    'http://www.wikidata.org/entity/Q28198161',
    'http://www.wikidata.org/entity/Q28198177',
    'http://www.wikidata.org/entity/Q28198237',
    'http://www.wikidata.org/entity/Q28198287',
    'http://www.wikidata.org/entity/Q28198374',
    'http://www.wikidata.org/entity/Q28198401',
    'http://www.wikidata.org/entity/Q28198471',
    'http://www.wikidata.org/entity/Q28198707',
    'http://www.wikidata.org/entity/Q28199043',
    'http://www.wikidata.org/entity/Q28199055',
    'http://www.wikidata.org/entity/Q28199080',
    'http://www.wikidata.org/entity/Q28199220',
    'http://www.wikidata.org/entity/Q28199222',
    'http://www.wikidata.org/entity/Q28199385',
    'http://www.wikidata.org/entity/Q28199445',
    'http://www.wikidata.org/entity/Q28199468',
    'http://www.wikidata.org/entity/Q28199900',
    'http://www.wikidata.org/entity/Q28199913',
    'http://www.wikidata.org/entity/Q28200068',
    'http://www.wikidata.org/entity/Q28200072',
    'http://www.wikidata.org/entity/Q28200083',
    'http://www.wikidata.org/entity/Q28200101',
    'http://www.wikidata.org/entity/Q28200181',
    'http://www.wikidata.org/entity/Q28200368',
    'http://www.wikidata.org/entity/Q28200375',
    'http://www.wikidata.org/entity/Q28200684',
    'http://www.wikidata.org/entity/Q28200704',
    'http://www.wikidata.org/entity/Q28200755',
    'http://www.wikidata.org/entity/Q28200763',
    'http://www.wikidata.org/entity/Q28200844',
    'http://www.wikidata.org/entity/Q28200848',
    'http://www.wikidata.org/entity/Q28200878',
    'http://www.wikidata.org/entity/Q28200972',
    'http://www.wikidata.org/entity/Q28201088',
    'http://www.wikidata.org/entity/Q28201183',
    'http://www.wikidata.org/entity/Q28201187',
    'http://www.wikidata.org/entity/Q28201199',
    'http://www.wikidata.org/entity/Q28201310',
    'http://www.wikidata.org/entity/Q28201332',
    'http://www.wikidata.org/entity/Q28201363',
    'http://www.wikidata.org/entity/Q28201380',
    'http://www.wikidata.org/entity/Q28201389',
    'http://www.wikidata.org/entity/Q28201396',
    'http://www.wikidata.org/entity/Q28201415',
    'http://www.wikidata.org/entity/Q28201431',
    'http://www.wikidata.org/entity/Q28201472',
    'http://www.wikidata.org/entity/Q28201509',
    'http://www.wikidata.org/entity/Q28201517',
    'http://www.wikidata.org/entity/Q28201532',
    'http://www.wikidata.org/entity/Q28201545',
    'http://www.wikidata.org/entity/Q28201555',
    'http://www.wikidata.org/entity/Q28201568',
    'http://www.wikidata.org/entity/Q28201576',
    'http://www.wikidata.org/entity/Q28201591',
    'http://www.wikidata.org/entity/Q28201606',
    'http://www.wikidata.org/entity/Q28201627',
    'http://www.wikidata.org/entity/Q28201637',
    'http://www.wikidata.org/entity/Q28201656',
    'http://www.wikidata.org/entity/Q28201682',
    'http://www.wikidata.org/entity/Q28201691',
    'http://www.wikidata.org/entity/Q28201693',
    'http://www.wikidata.org/entity/Q28201701',
    'http://www.wikidata.org/entity/Q28201706',
    'http://www.wikidata.org/entity/Q28201713',
    'http://www.wikidata.org/entity/Q28201716',
    'http://www.wikidata.org/entity/Q28201717',
    'http://www.wikidata.org/entity/Q28201750',
    'http://www.wikidata.org/entity/Q28201784',
    'http://www.wikidata.org/entity/Q28201828',
    'http://www.wikidata.org/entity/Q28201834',
    'http://www.wikidata.org/entity/Q28201841',
    'http://www.wikidata.org/entity/Q28201844',
    'http://www.wikidata.org/entity/Q28201846',
    'http://www.wikidata.org/entity/Q28201864',
    'http://www.wikidata.org/entity/Q28201876',
    'http://www.wikidata.org/entity/Q28201892',
    'http://www.wikidata.org/entity/Q28201906',
    'http://www.wikidata.org/entity/Q28201937',
    'http://www.wikidata.org/entity/Q28201944',
    'http://www.wikidata.org/entity/Q28201947',
    'http://www.wikidata.org/entity/Q28201970',
    'http://www.wikidata.org/entity/Q28201978',
    'http://www.wikidata.org/entity/Q28201981',
    'http://www.wikidata.org/entity/Q28202050',
    'http://www.wikidata.org/entity/Q28202069',
    'http://www.wikidata.org/entity/Q28202080',
    'http://www.wikidata.org/entity/Q28202112',
    'http://www.wikidata.org/entity/Q28202120',
    'http://www.wikidata.org/entity/Q28202129',
    'http://www.wikidata.org/entity/Q28202134',
    'http://www.wikidata.org/entity/Q28202146',
    'http://www.wikidata.org/entity/Q28202214',
    'http://www.wikidata.org/entity/Q28202234',
    'http://www.wikidata.org/entity/Q28202269',
    'http://www.wikidata.org/entity/Q28202279',
    'http://www.wikidata.org/entity/Q28202311',
    'http://www.wikidata.org/entity/Q28202328',
    'http://www.wikidata.org/entity/Q28202372',
    'http://www.wikidata.org/entity/Q28202375',
    'http://www.wikidata.org/entity/Q28202393',
    'http://www.wikidata.org/entity/Q28202401',
    'http://www.wikidata.org/entity/Q28202403',
    'http://www.wikidata.org/entity/Q28202449',
    'http://www.wikidata.org/entity/Q28202471',
    'http://www.wikidata.org/entity/Q28202486',
    'http://www.wikidata.org/entity/Q28202501',
    'http://www.wikidata.org/entity/Q28202504',
    'http://www.wikidata.org/entity/Q28202515',
    'http://www.wikidata.org/entity/Q28202516',
    'http://www.wikidata.org/entity/Q28202519',
    'http://www.wikidata.org/entity/Q28202545',
    'http://www.wikidata.org/entity/Q28202556',
    'http://www.wikidata.org/entity/Q28202655',
    'http://www.wikidata.org/entity/Q28202698',
    'http://www.wikidata.org/entity/Q28202763',
    'http://www.wikidata.org/entity/Q28202768',
    'http://www.wikidata.org/entity/Q28202771',
    'http://www.wikidata.org/entity/Q28202807',
    'http://www.wikidata.org/entity/Q28202812',
    'http://www.wikidata.org/entity/Q28202846',
    'http://www.wikidata.org/entity/Q28202903',
    'http://www.wikidata.org/entity/Q28202993',
    'http://www.wikidata.org/entity/Q28203006',
    'http://www.wikidata.org/entity/Q28203073',
    'http://www.wikidata.org/entity/Q28203085',
    'http://www.wikidata.org/entity/Q28203094',
    'http://www.wikidata.org/entity/Q28203095',
    'http://www.wikidata.org/entity/Q28203140',
    'http://www.wikidata.org/entity/Q28203149',
    'http://www.wikidata.org/entity/Q28203167',
    'http://www.wikidata.org/entity/Q28203195',
    'http://www.wikidata.org/entity/Q28203206',
    'http://www.wikidata.org/entity/Q28203210',
    'http://www.wikidata.org/entity/Q28203288',
    'http://www.wikidata.org/entity/Q28203327',
    'http://www.wikidata.org/entity/Q28203348',
    'http://www.wikidata.org/entity/Q28203477',
    'http://www.wikidata.org/entity/Q28203499',
    'http://www.wikidata.org/entity/Q28203549',
    'http://www.wikidata.org/entity/Q28203552',
    'http://www.wikidata.org/entity/Q28203572',
    'http://www.wikidata.org/entity/Q28203641',
    'http://www.wikidata.org/entity/Q28203658',
    'http://www.wikidata.org/entity/Q28203717',
    'http://www.wikidata.org/entity/Q28203723',
    'http://www.wikidata.org/entity/Q28203726',
    'http://www.wikidata.org/entity/Q28203762',
    'http://www.wikidata.org/entity/Q28203766',
    'http://www.wikidata.org/entity/Q28203769',
    'http://www.wikidata.org/entity/Q28203777',
    'http://www.wikidata.org/entity/Q28203920',
    'http://www.wikidata.org/entity/Q28203935',
    'http://www.wikidata.org/entity/Q28203971',
    'http://www.wikidata.org/entity/Q28204066',
    'http://www.wikidata.org/entity/Q28204091',
    'http://www.wikidata.org/entity/Q28204140',
    'http://www.wikidata.org/entity/Q28204147',
    'http://www.wikidata.org/entity/Q28204158',
    'http://www.wikidata.org/entity/Q28204166',
    'http://www.wikidata.org/entity/Q28204177',
    'http://www.wikidata.org/entity/Q28204189',
    'http://www.wikidata.org/entity/Q28204197',
    'http://www.wikidata.org/entity/Q28204205',
    'http://www.wikidata.org/entity/Q28204209',
    'http://www.wikidata.org/entity/Q28204231',
    'http://www.wikidata.org/entity/Q28204259',
    'http://www.wikidata.org/entity/Q28204282',
    'http://www.wikidata.org/entity/Q28204295',
    'http://www.wikidata.org/entity/Q28204313',
    'http://www.wikidata.org/entity/Q28204326',
    'http://www.wikidata.org/entity/Q28204378',
    'http://www.wikidata.org/entity/Q28204386',
    'http://www.wikidata.org/entity/Q28204393',
    'http://www.wikidata.org/entity/Q28204398',
    'http://www.wikidata.org/entity/Q28204406',
    'http://www.wikidata.org/entity/Q28204434',
    'http://www.wikidata.org/entity/Q28204447',
    'http://www.wikidata.org/entity/Q28204448',
    'http://www.wikidata.org/entity/Q28204453',
    'http://www.wikidata.org/entity/Q28204460',
    'http://www.wikidata.org/entity/Q28204471',
    'http://www.wikidata.org/entity/Q28204487',
    'http://www.wikidata.org/entity/Q28204548',
    'http://www.wikidata.org/entity/Q28204614',
    'http://www.wikidata.org/entity/Q28204726',
    'http://www.wikidata.org/entity/Q28204734',
    'http://www.wikidata.org/entity/Q28204926',
    'http://www.wikidata.org/entity/Q28204928',
    'http://www.wikidata.org/entity/Q28204938',
    'http://www.wikidata.org/entity/Q28204942',
    'http://www.wikidata.org/entity/Q28204943',
    'http://www.wikidata.org/entity/Q28204967',
    'http://www.wikidata.org/entity/Q28205026',
    'http://www.wikidata.org/entity/Q28205043',
    'http://www.wikidata.org/entity/Q28205055',
    'http://www.wikidata.org/entity/Q28205057',
    'http://www.wikidata.org/entity/Q28205076',
    'http://www.wikidata.org/entity/Q28205094',
    'http://www.wikidata.org/entity/Q28205096',
    'http://www.wikidata.org/entity/Q28205099',
    'http://www.wikidata.org/entity/Q28205103',
    'http://www.wikidata.org/entity/Q28205111',
    'http://www.wikidata.org/entity/Q28205192',
    'http://www.wikidata.org/entity/Q28205193',
    'http://www.wikidata.org/entity/Q28205194',
    'http://www.wikidata.org/entity/Q28205222',
    'http://www.wikidata.org/entity/Q28205257',
    'http://www.wikidata.org/entity/Q28205305',
    'http://www.wikidata.org/entity/Q28205315',
    'http://www.wikidata.org/entity/Q28205323',
    'http://www.wikidata.org/entity/Q28205343',
    'http://www.wikidata.org/entity/Q28205388',
    'http://www.wikidata.org/entity/Q28205462',
    'http://www.wikidata.org/entity/Q28205472',
    'http://www.wikidata.org/entity/Q28205534',
    'http://www.wikidata.org/entity/Q28205551',
    'http://www.wikidata.org/entity/Q28205599',
    'http://www.wikidata.org/entity/Q28205635',
    'http://www.wikidata.org/entity/Q28205648',
    'http://www.wikidata.org/entity/Q28205677',
    'http://www.wikidata.org/entity/Q28205764',
    'http://www.wikidata.org/entity/Q28205799',
    'http://www.wikidata.org/entity/Q28205840',
    'http://www.wikidata.org/entity/Q28205881',
    'http://www.wikidata.org/entity/Q28205899',
    'http://www.wikidata.org/entity/Q28205903',
    'http://www.wikidata.org/entity/Q28205921',
    'http://www.wikidata.org/entity/Q28205953',
    'http://www.wikidata.org/entity/Q28205969',
    'http://www.wikidata.org/entity/Q28205991',
    'http://www.wikidata.org/entity/Q28206012',
    'http://www.wikidata.org/entity/Q28206018',
    'http://www.wikidata.org/entity/Q28206029',
    'http://www.wikidata.org/entity/Q28206145',
    'http://www.wikidata.org/entity/Q28206180',
    'http://www.wikidata.org/entity/Q28206225',
    'http://www.wikidata.org/entity/Q28206290',
    'http://www.wikidata.org/entity/Q28206303',
    'http://www.wikidata.org/entity/Q28206345',
    'http://www.wikidata.org/entity/Q28206361',
    'http://www.wikidata.org/entity/Q28206380',
    'http://www.wikidata.org/entity/Q28206406',
    'http://www.wikidata.org/entity/Q28206411',
    'http://www.wikidata.org/entity/Q28206420',
    'http://www.wikidata.org/entity/Q28206542',
    'http://www.wikidata.org/entity/Q28206543',
    'http://www.wikidata.org/entity/Q28206549',
    'http://www.wikidata.org/entity/Q28206693',
    'http://www.wikidata.org/entity/Q28206764',
    'http://www.wikidata.org/entity/Q28206790',
    'http://www.wikidata.org/entity/Q28206868',
    'http://www.wikidata.org/entity/Q28206967',
    'http://www.wikidata.org/entity/Q28207072',
    'http://www.wikidata.org/entity/Q28207081',
    'http://www.wikidata.org/entity/Q28207107',
    'http://www.wikidata.org/entity/Q28207143',
    'http://www.wikidata.org/entity/Q28207164',
    'http://www.wikidata.org/entity/Q28207179',
    'http://www.wikidata.org/entity/Q28207244',
    'http://www.wikidata.org/entity/Q28207262',
    'http://www.wikidata.org/entity/Q28207285',
    'http://www.wikidata.org/entity/Q28207289',
    'http://www.wikidata.org/entity/Q28207331',
    'http://www.wikidata.org/entity/Q28207377',
    'http://www.wikidata.org/entity/Q28207468',
    'http://www.wikidata.org/entity/Q28207471',
    'http://www.wikidata.org/entity/Q28207565',
    'http://www.wikidata.org/entity/Q28207586',
    'http://www.wikidata.org/entity/Q28207617',
    'http://www.wikidata.org/entity/Q28207628',
    'http://www.wikidata.org/entity/Q28207647',
    'http://www.wikidata.org/entity/Q28207668',
    'http://www.wikidata.org/entity/Q28207673',
    'http://www.wikidata.org/entity/Q28207698',
    'http://www.wikidata.org/entity/Q28207706',
    'http://www.wikidata.org/entity/Q28207748',
    'http://www.wikidata.org/entity/Q28207758',
    'http://www.wikidata.org/entity/Q28207789',
    'http://www.wikidata.org/entity/Q28207794',
    'http://www.wikidata.org/entity/Q28207852',
    'http://www.wikidata.org/entity/Q28207854',
    'http://www.wikidata.org/entity/Q28207855',
    'http://www.wikidata.org/entity/Q28207865',
    'http://www.wikidata.org/entity/Q28207872',
    'http://www.wikidata.org/entity/Q28207880',
    'http://www.wikidata.org/entity/Q28207898',
    'http://www.wikidata.org/entity/Q28207899',
    'http://www.wikidata.org/entity/Q28207902',
    'http://www.wikidata.org/entity/Q28207922',
    'http://www.wikidata.org/entity/Q28207942',
    'http://www.wikidata.org/entity/Q28207975',
    'http://www.wikidata.org/entity/Q28207984',
    'http://www.wikidata.org/entity/Q28207985',
    'http://www.wikidata.org/entity/Q28207991',
    'http://www.wikidata.org/entity/Q28207996',
    'http://www.wikidata.org/entity/Q28208049',
    'http://www.wikidata.org/entity/Q28208107',
    'http://www.wikidata.org/entity/Q28208212',
    'http://www.wikidata.org/entity/Q28208246',
    'http://www.wikidata.org/entity/Q28208250',
    'http://www.wikidata.org/entity/Q28208274',
    'http://www.wikidata.org/entity/Q28208405',
    'http://www.wikidata.org/entity/Q28208414',
    'http://www.wikidata.org/entity/Q28208432',
    'http://www.wikidata.org/entity/Q28208463',
    'http://www.wikidata.org/entity/Q28208563',
    'http://www.wikidata.org/entity/Q28208568',
    'http://www.wikidata.org/entity/Q28208692',
    'http://www.wikidata.org/entity/Q28208772',
    'http://www.wikidata.org/entity/Q28208778',
    'http://www.wikidata.org/entity/Q28208863',
    'http://www.wikidata.org/entity/Q28208908',
    'http://www.wikidata.org/entity/Q28209011',
    'http://www.wikidata.org/entity/Q28209029',
    'http://www.wikidata.org/entity/Q28209077',
    'http://www.wikidata.org/entity/Q28209082',
    'http://www.wikidata.org/entity/Q28209095',
    'http://www.wikidata.org/entity/Q28209121',
    'http://www.wikidata.org/entity/Q28209183',
    'http://www.wikidata.org/entity/Q28209232',
    'http://www.wikidata.org/entity/Q28209239',
    'http://www.wikidata.org/entity/Q28209282',
    'http://www.wikidata.org/entity/Q28209340',
    'http://www.wikidata.org/entity/Q28209458',
    'http://www.wikidata.org/entity/Q28209556',
    'http://www.wikidata.org/entity/Q28209679',
    'http://www.wikidata.org/entity/Q28209802',
    'http://www.wikidata.org/entity/Q28209814',
    'http://www.wikidata.org/entity/Q28209906',
    'http://www.wikidata.org/entity/Q28209943',
    'http://www.wikidata.org/entity/Q28209948',
    'http://www.wikidata.org/entity/Q28210013',
    'http://www.wikidata.org/entity/Q28210028',
    'http://www.wikidata.org/entity/Q28210032',
    'http://www.wikidata.org/entity/Q28210051',
    'http://www.wikidata.org/entity/Q28210063',
    'http://www.wikidata.org/entity/Q28210081',
    'http://www.wikidata.org/entity/Q28210094',
    'http://www.wikidata.org/entity/Q28210226',
    'http://www.wikidata.org/entity/Q28210268',
    'http://www.wikidata.org/entity/Q28210379',
    'http://www.wikidata.org/entity/Q28210390',
    'http://www.wikidata.org/entity/Q28210511',
    'http://www.wikidata.org/entity/Q28210584',
    'http://www.wikidata.org/entity/Q28210604',
    'http://www.wikidata.org/entity/Q28210611',
    'http://www.wikidata.org/entity/Q28210623',
    'http://www.wikidata.org/entity/Q28210640',
    'http://www.wikidata.org/entity/Q28210663',
    'http://www.wikidata.org/entity/Q28210733',
    'http://www.wikidata.org/entity/Q28210745',
    'http://www.wikidata.org/entity/Q28210917',
    'http://www.wikidata.org/entity/Q28211064',
    'http://www.wikidata.org/entity/Q28211105',
    'http://www.wikidata.org/entity/Q28211132',
    'http://www.wikidata.org/entity/Q28211178',
    'http://www.wikidata.org/entity/Q28211190',
    'http://www.wikidata.org/entity/Q28211207',
    'http://www.wikidata.org/entity/Q28211215',
    'http://www.wikidata.org/entity/Q28211321',
    'http://www.wikidata.org/entity/Q28211349',
    'http://www.wikidata.org/entity/Q28211358',
    'http://www.wikidata.org/entity/Q28211385',
    'http://www.wikidata.org/entity/Q28211413',
    'http://www.wikidata.org/entity/Q28211574',
    'http://www.wikidata.org/entity/Q28211607',
    'http://www.wikidata.org/entity/Q28211721',
    'http://www.wikidata.org/entity/Q28211878',
    'http://www.wikidata.org/entity/Q28211911',
    'http://www.wikidata.org/entity/Q28211969',
    'http://www.wikidata.org/entity/Q28211976',
    'http://www.wikidata.org/entity/Q28211980',
    'http://www.wikidata.org/entity/Q28211999',
    'http://www.wikidata.org/entity/Q28212039',
    'http://www.wikidata.org/entity/Q28212071',
    'http://www.wikidata.org/entity/Q28212140',
    'http://www.wikidata.org/entity/Q28212171',
    'http://www.wikidata.org/entity/Q28212180',
    'http://www.wikidata.org/entity/Q28212182',
    'http://www.wikidata.org/entity/Q28212213',
    'http://www.wikidata.org/entity/Q28212229',
    'http://www.wikidata.org/entity/Q28212245',
    'http://www.wikidata.org/entity/Q28212251',
    'http://www.wikidata.org/entity/Q28212263',
    'http://www.wikidata.org/entity/Q28212276',
    'http://www.wikidata.org/entity/Q28212394',
    'http://www.wikidata.org/entity/Q28212413',
    'http://www.wikidata.org/entity/Q28212461',
    'http://www.wikidata.org/entity/Q28212476',
    'http://www.wikidata.org/entity/Q28212593',
    'http://www.wikidata.org/entity/Q28212615',
    'http://www.wikidata.org/entity/Q28212746',
    'http://www.wikidata.org/entity/Q28212788',
    'http://www.wikidata.org/entity/Q28212826',
    'http://www.wikidata.org/entity/Q28212882',
    'http://www.wikidata.org/entity/Q28212902',
    'http://www.wikidata.org/entity/Q28212947',
    'http://www.wikidata.org/entity/Q28212990',
    'http://www.wikidata.org/entity/Q28213000',
    'http://www.wikidata.org/entity/Q28213169',
    'http://www.wikidata.org/entity/Q28213193',
    'http://www.wikidata.org/entity/Q28213265',
    'http://www.wikidata.org/entity/Q28213313',
    'http://www.wikidata.org/entity/Q28213363',
    'http://www.wikidata.org/entity/Q28213383',
    'http://www.wikidata.org/entity/Q28213389',
    'http://www.wikidata.org/entity/Q28213431',
    'http://www.wikidata.org/entity/Q28213597',
    'http://www.wikidata.org/entity/Q28213628',
    'http://www.wikidata.org/entity/Q28213632',
    'http://www.wikidata.org/entity/Q28213675',
    'http://www.wikidata.org/entity/Q28213820',
    'http://www.wikidata.org/entity/Q28213946',
    'http://www.wikidata.org/entity/Q28213950',
    'http://www.wikidata.org/entity/Q28213978',
    'http://www.wikidata.org/entity/Q28214017',
    'http://www.wikidata.org/entity/Q28214089',
    'http://www.wikidata.org/entity/Q28214252',
    'http://www.wikidata.org/entity/Q28214324',
    'http://www.wikidata.org/entity/Q28214353',
    'http://www.wikidata.org/entity/Q28214369',
    'http://www.wikidata.org/entity/Q28214393',
    'http://www.wikidata.org/entity/Q28214440',
    'http://www.wikidata.org/entity/Q28214478',
    'http://www.wikidata.org/entity/Q28214524',
    'http://www.wikidata.org/entity/Q28214546',
    'http://www.wikidata.org/entity/Q28214553',
    'http://www.wikidata.org/entity/Q28214585',
    'http://www.wikidata.org/entity/Q28214588',
    'http://www.wikidata.org/entity/Q28214592',
    'http://www.wikidata.org/entity/Q28214613',
    'http://www.wikidata.org/entity/Q28214633',
    'http://www.wikidata.org/entity/Q28214699',
    'http://www.wikidata.org/entity/Q28214714',
    'http://www.wikidata.org/entity/Q28214742',
    'http://www.wikidata.org/entity/Q28214771',
    'http://www.wikidata.org/entity/Q28214774',
    'http://www.wikidata.org/entity/Q28214785',
    'http://www.wikidata.org/entity/Q28214797',
    'http://www.wikidata.org/entity/Q28214799',
    'http://www.wikidata.org/entity/Q28214814',
    'http://www.wikidata.org/entity/Q28214829',
    'http://www.wikidata.org/entity/Q28214882',
    'http://www.wikidata.org/entity/Q28214969',
    'http://www.wikidata.org/entity/Q28214973',
    'http://www.wikidata.org/entity/Q28214975',
    'http://www.wikidata.org/entity/Q28215061',
    'http://www.wikidata.org/entity/Q28215069',
    'http://www.wikidata.org/entity/Q28215080',
    'http://www.wikidata.org/entity/Q28215112',
    'http://www.wikidata.org/entity/Q28215115',
    'http://www.wikidata.org/entity/Q28215146',
    'http://www.wikidata.org/entity/Q28215161',
    'http://www.wikidata.org/entity/Q28215190',
    'http://www.wikidata.org/entity/Q28215200',
    'http://www.wikidata.org/entity/Q28215218',
    'http://www.wikidata.org/entity/Q28215248',
    'http://www.wikidata.org/entity/Q28215274',
    'http://www.wikidata.org/entity/Q28215309',
    'http://www.wikidata.org/entity/Q28215372',
    'http://www.wikidata.org/entity/Q28215404',
    'http://www.wikidata.org/entity/Q28215427',
    'http://www.wikidata.org/entity/Q28215495',
    'http://www.wikidata.org/entity/Q28215527',
    'http://www.wikidata.org/entity/Q28215545',
    'http://www.wikidata.org/entity/Q28215562',
    'http://www.wikidata.org/entity/Q28215577',
    'http://www.wikidata.org/entity/Q28215606',
    'http://www.wikidata.org/entity/Q28215660',
    'http://www.wikidata.org/entity/Q28215716',
    'http://www.wikidata.org/entity/Q28215767',
    'http://www.wikidata.org/entity/Q28215773',
    'http://www.wikidata.org/entity/Q28215775',
    'http://www.wikidata.org/entity/Q28215837',
    'http://www.wikidata.org/entity/Q28215842',
    'http://www.wikidata.org/entity/Q28215845',
    'http://www.wikidata.org/entity/Q28215855',
    'http://www.wikidata.org/entity/Q28215916',
    'http://www.wikidata.org/entity/Q28215944',
    'http://www.wikidata.org/entity/Q28216043',
    'http://www.wikidata.org/entity/Q28216129',
    'http://www.wikidata.org/entity/Q28216157',
    'http://www.wikidata.org/entity/Q28216245',
    'http://www.wikidata.org/entity/Q28216253',
    'http://www.wikidata.org/entity/Q28216275',
    'http://www.wikidata.org/entity/Q28216281',
    'http://www.wikidata.org/entity/Q28216285',
    'http://www.wikidata.org/entity/Q28216291',
    'http://www.wikidata.org/entity/Q28216308',
    'http://www.wikidata.org/entity/Q28216313',
    'http://www.wikidata.org/entity/Q28216347',
    'http://www.wikidata.org/entity/Q28216384',
    'http://www.wikidata.org/entity/Q28216394',
    'http://www.wikidata.org/entity/Q28216450',
    'http://www.wikidata.org/entity/Q28216456',
    'http://www.wikidata.org/entity/Q28216457',
    'http://www.wikidata.org/entity/Q28216468',
    'http://www.wikidata.org/entity/Q28216478',
    'http://www.wikidata.org/entity/Q28216485',
    'http://www.wikidata.org/entity/Q28216502',
    'http://www.wikidata.org/entity/Q28216583',
    'http://www.wikidata.org/entity/Q28216586',
    'http://www.wikidata.org/entity/Q28216587',
    'http://www.wikidata.org/entity/Q28216590',
    'http://www.wikidata.org/entity/Q28216601',
    'http://www.wikidata.org/entity/Q28216659',
    'http://www.wikidata.org/entity/Q28216666',
    'http://www.wikidata.org/entity/Q28216755',
    'http://www.wikidata.org/entity/Q28216760',
    'http://www.wikidata.org/entity/Q28216765',
    'http://www.wikidata.org/entity/Q28216784',
    'http://www.wikidata.org/entity/Q28216788',
    'http://www.wikidata.org/entity/Q28216843',
    'http://www.wikidata.org/entity/Q28216871',
    'http://www.wikidata.org/entity/Q28216899',
    'http://www.wikidata.org/entity/Q28216942',
    'http://www.wikidata.org/entity/Q28216953',
    'http://www.wikidata.org/entity/Q28216990',
    'http://www.wikidata.org/entity/Q28217034',
    'http://www.wikidata.org/entity/Q28217065',
    'http://www.wikidata.org/entity/Q28217085',
    'http://www.wikidata.org/entity/Q28217179',
    'http://www.wikidata.org/entity/Q28217194',
    'http://www.wikidata.org/entity/Q28217212',
    'http://www.wikidata.org/entity/Q28217255',
    'http://www.wikidata.org/entity/Q28217265',
    'http://www.wikidata.org/entity/Q28217269',
    'http://www.wikidata.org/entity/Q28217270',
    'http://www.wikidata.org/entity/Q28217318',
    'http://www.wikidata.org/entity/Q28217336',
    'http://www.wikidata.org/entity/Q28217342',
    'http://www.wikidata.org/entity/Q28217344',
    'http://www.wikidata.org/entity/Q28217410',
    'http://www.wikidata.org/entity/Q28217600',
    'http://www.wikidata.org/entity/Q28217666',
    'http://www.wikidata.org/entity/Q28217784',
    'http://www.wikidata.org/entity/Q28217790',
    'http://www.wikidata.org/entity/Q28217796',
    'http://www.wikidata.org/entity/Q28217835',
    'http://www.wikidata.org/entity/Q28217891',
    'http://www.wikidata.org/entity/Q28217956',
    'http://www.wikidata.org/entity/Q28217964',
    'http://www.wikidata.org/entity/Q28217978',
    'http://www.wikidata.org/entity/Q28218032',
    'http://www.wikidata.org/entity/Q28218126',
    'http://www.wikidata.org/entity/Q28218148',
    'http://www.wikidata.org/entity/Q28218190',
    'http://www.wikidata.org/entity/Q28218564',
    'http://www.wikidata.org/entity/Q28218637',
    'http://www.wikidata.org/entity/Q28218654',
    'http://www.wikidata.org/entity/Q28218670',
    'http://www.wikidata.org/entity/Q28218789',
    'http://www.wikidata.org/entity/Q28218870',
    'http://www.wikidata.org/entity/Q28218883',
    'http://www.wikidata.org/entity/Q28218970',
    'http://www.wikidata.org/entity/Q28219196',
    'http://www.wikidata.org/entity/Q28219363',
    'http://www.wikidata.org/entity/Q28219372',
    'http://www.wikidata.org/entity/Q28219379',
    'http://www.wikidata.org/entity/Q28219387',
    'http://www.wikidata.org/entity/Q28219424',
    'http://www.wikidata.org/entity/Q28219427',
    'http://www.wikidata.org/entity/Q28219495',
    'http://www.wikidata.org/entity/Q28219755',
    'http://www.wikidata.org/entity/Q28219802',
    'http://www.wikidata.org/entity/Q28220372',
    'http://www.wikidata.org/entity/Q28220397',
    'http://www.wikidata.org/entity/Q28220462',
    'http://www.wikidata.org/entity/Q28221115',
    'http://www.wikidata.org/entity/Q28221448',
    'http://www.wikidata.org/entity/Q28222847',
    'http://www.wikidata.org/entity/Q28223043',
    'http://www.wikidata.org/entity/Q28234998',
    'http://www.wikidata.org/entity/Q28235006',
    'http://www.wikidata.org/entity/Q28235024',
    'http://www.wikidata.org/entity/Q28235091',
    'http://www.wikidata.org/entity/Q28235102',
    'http://www.wikidata.org/entity/Q28235115',
    'http://www.wikidata.org/entity/Q28235126',
    'http://www.wikidata.org/entity/Q28235146',
    'http://www.wikidata.org/entity/Q28235183',
    'http://www.wikidata.org/entity/Q28235199',
    'http://www.wikidata.org/entity/Q28235206',
    'http://www.wikidata.org/entity/Q28235214',
    'http://www.wikidata.org/entity/Q28235281',
    'http://www.wikidata.org/entity/Q28235330',
    'http://www.wikidata.org/entity/Q28235431',
    'http://www.wikidata.org/entity/Q28235451',
    'http://www.wikidata.org/entity/Q28235481',
    'http://www.wikidata.org/entity/Q28235483',
    'http://www.wikidata.org/entity/Q28235526',
    'http://www.wikidata.org/entity/Q28235550',
    'http://www.wikidata.org/entity/Q28235565',
    'http://www.wikidata.org/entity/Q28235603',
    'http://www.wikidata.org/entity/Q28235641',
    'http://www.wikidata.org/entity/Q28235648',
    'http://www.wikidata.org/entity/Q28235731',
    'http://www.wikidata.org/entity/Q28235733',
    'http://www.wikidata.org/entity/Q28235782',
    'http://www.wikidata.org/entity/Q28235814',
    'http://www.wikidata.org/entity/Q28235841',
    'http://www.wikidata.org/entity/Q28235849',
    'http://www.wikidata.org/entity/Q28235858',
    'http://www.wikidata.org/entity/Q28235865',
    'http://www.wikidata.org/entity/Q28235866',
    'http://www.wikidata.org/entity/Q28235875',
    'http://www.wikidata.org/entity/Q28235948',
    'http://www.wikidata.org/entity/Q28235956',
    'http://www.wikidata.org/entity/Q28235998',
    'http://www.wikidata.org/entity/Q28236008',
    'http://www.wikidata.org/entity/Q28236042',
    'http://www.wikidata.org/entity/Q28236113',
    'http://www.wikidata.org/entity/Q28236144',
    'http://www.wikidata.org/entity/Q28236154',
    'http://www.wikidata.org/entity/Q28236171',
    'http://www.wikidata.org/entity/Q28236209',
    'http://www.wikidata.org/entity/Q28236229',
    'http://www.wikidata.org/entity/Q28236283',
    'http://www.wikidata.org/entity/Q28236401',
    'http://www.wikidata.org/entity/Q28236445',
    'http://www.wikidata.org/entity/Q28236450',
    'http://www.wikidata.org/entity/Q28236560',
    'http://www.wikidata.org/entity/Q28236574',
    'http://www.wikidata.org/entity/Q28236621',
    'http://www.wikidata.org/entity/Q28236652',
    'http://www.wikidata.org/entity/Q28236671',
    'http://www.wikidata.org/entity/Q28236678',
    'http://www.wikidata.org/entity/Q28236746',
    'http://www.wikidata.org/entity/Q28236767',
    'http://www.wikidata.org/entity/Q28236784',
    'http://www.wikidata.org/entity/Q28236792',
    'http://www.wikidata.org/entity/Q28236796',
    'http://www.wikidata.org/entity/Q28236805',
    'http://www.wikidata.org/entity/Q28236828',
    'http://www.wikidata.org/entity/Q28236839',
    'http://www.wikidata.org/entity/Q28236848',
    'http://www.wikidata.org/entity/Q28236857',
    'http://www.wikidata.org/entity/Q28236872',
    'http://www.wikidata.org/entity/Q28236905',
    'http://www.wikidata.org/entity/Q28236937',
    'http://www.wikidata.org/entity/Q28236938',
    'http://www.wikidata.org/entity/Q28236951',
    'http://www.wikidata.org/entity/Q28236982',
    'http://www.wikidata.org/entity/Q28236994',
    'http://www.wikidata.org/entity/Q28237161',
    'http://www.wikidata.org/entity/Q28237197',
    'http://www.wikidata.org/entity/Q28237200',
    'http://www.wikidata.org/entity/Q28237268',
    'http://www.wikidata.org/entity/Q28237287',
    'http://www.wikidata.org/entity/Q28237307',
    'http://www.wikidata.org/entity/Q28237338',
    'http://www.wikidata.org/entity/Q28237362',
    'http://www.wikidata.org/entity/Q28237370',
    'http://www.wikidata.org/entity/Q28237394',
    'http://www.wikidata.org/entity/Q28237417',
    'http://www.wikidata.org/entity/Q28237471',
    'http://www.wikidata.org/entity/Q28237493',
    'http://www.wikidata.org/entity/Q28237528',
    'http://www.wikidata.org/entity/Q28237555',
    'http://www.wikidata.org/entity/Q28237565',
    'http://www.wikidata.org/entity/Q28237577',
    'http://www.wikidata.org/entity/Q28237583',
    'http://www.wikidata.org/entity/Q28237623',
    'http://www.wikidata.org/entity/Q28237645',
    'http://www.wikidata.org/entity/Q28237653',
    'http://www.wikidata.org/entity/Q28237789',
    'http://www.wikidata.org/entity/Q28237795',
    'http://www.wikidata.org/entity/Q28237797',
    'http://www.wikidata.org/entity/Q28237805',
    'http://www.wikidata.org/entity/Q28237830',
    'http://www.wikidata.org/entity/Q28237934',
    'http://www.wikidata.org/entity/Q28237948',
    'http://www.wikidata.org/entity/Q28238054',
    'http://www.wikidata.org/entity/Q28238069',
    'http://www.wikidata.org/entity/Q28238076',
    'http://www.wikidata.org/entity/Q28238078',
    'http://www.wikidata.org/entity/Q28238103',
    'http://www.wikidata.org/entity/Q28238200',
    'http://www.wikidata.org/entity/Q28238243',
    'http://www.wikidata.org/entity/Q28238269',
    'http://www.wikidata.org/entity/Q28238288',
    'http://www.wikidata.org/entity/Q28238302',
    'http://www.wikidata.org/entity/Q28238308',
    'http://www.wikidata.org/entity/Q28238322',
    'http://www.wikidata.org/entity/Q28238339',
    'http://www.wikidata.org/entity/Q28238425',
    'http://www.wikidata.org/entity/Q28238467',
    'http://www.wikidata.org/entity/Q28238516',
    'http://www.wikidata.org/entity/Q28238570',
    'http://www.wikidata.org/entity/Q28238578',
    'http://www.wikidata.org/entity/Q28238584',
    'http://www.wikidata.org/entity/Q28238635',
    'http://www.wikidata.org/entity/Q28238644',
    'http://www.wikidata.org/entity/Q28238659',
    'http://www.wikidata.org/entity/Q28238669',
    'http://www.wikidata.org/entity/Q28238685',
    'http://www.wikidata.org/entity/Q28238687',
    'http://www.wikidata.org/entity/Q28238731',
    'http://www.wikidata.org/entity/Q28238795',
    'http://www.wikidata.org/entity/Q28238800',
    'http://www.wikidata.org/entity/Q28238809',
    'http://www.wikidata.org/entity/Q28238867',
    'http://www.wikidata.org/entity/Q28238872',
    'http://www.wikidata.org/entity/Q28238880',
    'http://www.wikidata.org/entity/Q28238881',
    'http://www.wikidata.org/entity/Q28238886',
    'http://www.wikidata.org/entity/Q28239120',
    'http://www.wikidata.org/entity/Q28239197',
    'http://www.wikidata.org/entity/Q28239215',
    'http://www.wikidata.org/entity/Q28239239',
    'http://www.wikidata.org/entity/Q28239249',
    'http://www.wikidata.org/entity/Q28239257',
    'http://www.wikidata.org/entity/Q28239283',
    'http://www.wikidata.org/entity/Q28239287',
    'http://www.wikidata.org/entity/Q28239292',
    'http://www.wikidata.org/entity/Q28239361',
    'http://www.wikidata.org/entity/Q28239415',
    'http://www.wikidata.org/entity/Q28239456',
    'http://www.wikidata.org/entity/Q28239484',
    'http://www.wikidata.org/entity/Q28239499',
    'http://www.wikidata.org/entity/Q28239567',
    'http://www.wikidata.org/entity/Q28239579',
    'http://www.wikidata.org/entity/Q28239595',
    'http://www.wikidata.org/entity/Q28239639',
    'http://www.wikidata.org/entity/Q28239642',
    'http://www.wikidata.org/entity/Q28239651',
    'http://www.wikidata.org/entity/Q28239710',
    'http://www.wikidata.org/entity/Q28239714',
    'http://www.wikidata.org/entity/Q28239787',
    'http://www.wikidata.org/entity/Q28239848',
    'http://www.wikidata.org/entity/Q28239857',
    'http://www.wikidata.org/entity/Q28239864',
    'http://www.wikidata.org/entity/Q28239890',
    'http://www.wikidata.org/entity/Q28239895',
    'http://www.wikidata.org/entity/Q28239907',
    'http://www.wikidata.org/entity/Q28239915',
    'http://www.wikidata.org/entity/Q28239966',
    'http://www.wikidata.org/entity/Q28239972',
    'http://www.wikidata.org/entity/Q28239977',
    'http://www.wikidata.org/entity/Q28239985',
    'http://www.wikidata.org/entity/Q28240029',
    'http://www.wikidata.org/entity/Q28240039',
    'http://www.wikidata.org/entity/Q28240053',
    'http://www.wikidata.org/entity/Q28240056',
    'http://www.wikidata.org/entity/Q28240070',
    'http://www.wikidata.org/entity/Q28240076',
    'http://www.wikidata.org/entity/Q28240089',
    'http://www.wikidata.org/entity/Q28240095',
    'http://www.wikidata.org/entity/Q28240174',
    'http://www.wikidata.org/entity/Q28240220',
    'http://www.wikidata.org/entity/Q28240230',
    'http://www.wikidata.org/entity/Q28240232',
    'http://www.wikidata.org/entity/Q28240241',
    'http://www.wikidata.org/entity/Q28240246',
    'http://www.wikidata.org/entity/Q28240249',
    'http://www.wikidata.org/entity/Q28240354',
    'http://www.wikidata.org/entity/Q28240355',
    'http://www.wikidata.org/entity/Q28240393',
    'http://www.wikidata.org/entity/Q28240596',
    'http://www.wikidata.org/entity/Q28240607',
    'http://www.wikidata.org/entity/Q28240611',
    'http://www.wikidata.org/entity/Q28240653',
    'http://www.wikidata.org/entity/Q28240711',
    'http://www.wikidata.org/entity/Q28240722',
    'http://www.wikidata.org/entity/Q28240727',
    'http://www.wikidata.org/entity/Q28240733',
    'http://www.wikidata.org/entity/Q28240752',
    'http://www.wikidata.org/entity/Q28240758',
    'http://www.wikidata.org/entity/Q28240764',
    'http://www.wikidata.org/entity/Q28240815',
    'http://www.wikidata.org/entity/Q28240820',
    'http://www.wikidata.org/entity/Q28240833',
    'http://www.wikidata.org/entity/Q28240882',
    'http://www.wikidata.org/entity/Q28240901',
    'http://www.wikidata.org/entity/Q28241049',
    'http://www.wikidata.org/entity/Q28241070',
    'http://www.wikidata.org/entity/Q28241127',
    'http://www.wikidata.org/entity/Q28241130',
    'http://www.wikidata.org/entity/Q28241142',
    'http://www.wikidata.org/entity/Q28241157',
    'http://www.wikidata.org/entity/Q28241260',
    'http://www.wikidata.org/entity/Q28241267',
    'http://www.wikidata.org/entity/Q28241296',
    'http://www.wikidata.org/entity/Q28241336',
    'http://www.wikidata.org/entity/Q28241350',
    'http://www.wikidata.org/entity/Q28241395',
    'http://www.wikidata.org/entity/Q28241397',
    'http://www.wikidata.org/entity/Q28241412',
    'http://www.wikidata.org/entity/Q28241418',
    'http://www.wikidata.org/entity/Q28241458',
    'http://www.wikidata.org/entity/Q28241473',
    'http://www.wikidata.org/entity/Q28241500',
    'http://www.wikidata.org/entity/Q28241514',
    'http://www.wikidata.org/entity/Q28241526',
    'http://www.wikidata.org/entity/Q28241540',
    'http://www.wikidata.org/entity/Q28241545',
    'http://www.wikidata.org/entity/Q28241553',
    'http://www.wikidata.org/entity/Q28241574',
    'http://www.wikidata.org/entity/Q28241661',
    'http://www.wikidata.org/entity/Q28241675',
    'http://www.wikidata.org/entity/Q28241720',
    'http://www.wikidata.org/entity/Q28241721',
    'http://www.wikidata.org/entity/Q28241731',
    'http://www.wikidata.org/entity/Q28241735',
    'http://www.wikidata.org/entity/Q28241772',
    'http://www.wikidata.org/entity/Q28241786',
    'http://www.wikidata.org/entity/Q28241824',
    'http://www.wikidata.org/entity/Q28241826',
    'http://www.wikidata.org/entity/Q28241852',
    'http://www.wikidata.org/entity/Q28241874',
    'http://www.wikidata.org/entity/Q28241887',
    'http://www.wikidata.org/entity/Q28241954',
    'http://www.wikidata.org/entity/Q28241968',
    'http://www.wikidata.org/entity/Q28242032',
    'http://www.wikidata.org/entity/Q28242050',
    'http://www.wikidata.org/entity/Q28242060',
    'http://www.wikidata.org/entity/Q28242072',
    'http://www.wikidata.org/entity/Q28242092',
    'http://www.wikidata.org/entity/Q28242135',
    'http://www.wikidata.org/entity/Q28242169',
    'http://www.wikidata.org/entity/Q28242176',
    'http://www.wikidata.org/entity/Q28242189',
    'http://www.wikidata.org/entity/Q28242203',
    'http://www.wikidata.org/entity/Q28242221',
    'http://www.wikidata.org/entity/Q28242222',
    'http://www.wikidata.org/entity/Q28242281',
    'http://www.wikidata.org/entity/Q28242317',
    'http://www.wikidata.org/entity/Q28242324',
    'http://www.wikidata.org/entity/Q28242332',
    'http://www.wikidata.org/entity/Q28242400',
    'http://www.wikidata.org/entity/Q28242406',
    'http://www.wikidata.org/entity/Q28242453',
    'http://www.wikidata.org/entity/Q28242462',
    'http://www.wikidata.org/entity/Q28242466',
    'http://www.wikidata.org/entity/Q28242505',
    'http://www.wikidata.org/entity/Q28242537',
    'http://www.wikidata.org/entity/Q28242547',
    'http://www.wikidata.org/entity/Q28242592',
    'http://www.wikidata.org/entity/Q28242612',
    'http://www.wikidata.org/entity/Q28242623',
    'http://www.wikidata.org/entity/Q28242641',
    'http://www.wikidata.org/entity/Q28242642',
    'http://www.wikidata.org/entity/Q28242645',
    'http://www.wikidata.org/entity/Q28242653',
    'http://www.wikidata.org/entity/Q28242666',
    'http://www.wikidata.org/entity/Q28242708',
    'http://www.wikidata.org/entity/Q28242717',
    'http://www.wikidata.org/entity/Q28242719',
    'http://www.wikidata.org/entity/Q28242854',
    'http://www.wikidata.org/entity/Q28242907',
    'http://www.wikidata.org/entity/Q28242916',
    'http://www.wikidata.org/entity/Q28242935',
    'http://www.wikidata.org/entity/Q28242954',
    'http://www.wikidata.org/entity/Q28242984',
    'http://www.wikidata.org/entity/Q28243044',
    'http://www.wikidata.org/entity/Q28243068',
    'http://www.wikidata.org/entity/Q28243121',
    'http://www.wikidata.org/entity/Q28243131',
    'http://www.wikidata.org/entity/Q28243157',
    'http://www.wikidata.org/entity/Q28243160',
    'http://www.wikidata.org/entity/Q28243166',
    'http://www.wikidata.org/entity/Q28243215',
    'http://www.wikidata.org/entity/Q28243325',
    'http://www.wikidata.org/entity/Q28243334',
    'http://www.wikidata.org/entity/Q28243336',
    'http://www.wikidata.org/entity/Q28243477',
    'http://www.wikidata.org/entity/Q28243511',
    'http://www.wikidata.org/entity/Q28243512',
    'http://www.wikidata.org/entity/Q28243540',
    'http://www.wikidata.org/entity/Q28243647',
    'http://www.wikidata.org/entity/Q28243710',
    'http://www.wikidata.org/entity/Q28243712',
    'http://www.wikidata.org/entity/Q28243956',
    'http://www.wikidata.org/entity/Q28243974',
    'http://www.wikidata.org/entity/Q28243976',
    'http://www.wikidata.org/entity/Q28243996',
    'http://www.wikidata.org/entity/Q28244053',
    'http://www.wikidata.org/entity/Q28244071',
    'http://www.wikidata.org/entity/Q28244085',
    'http://www.wikidata.org/entity/Q28244097',
    'http://www.wikidata.org/entity/Q28244161',
    'http://www.wikidata.org/entity/Q28244166',
    'http://www.wikidata.org/entity/Q28244193',
    'http://www.wikidata.org/entity/Q28244203',
    'http://www.wikidata.org/entity/Q28244221',
    'http://www.wikidata.org/entity/Q28244243',
    'http://www.wikidata.org/entity/Q28244250',
    'http://www.wikidata.org/entity/Q28244252',
    'http://www.wikidata.org/entity/Q28244299',
    'http://www.wikidata.org/entity/Q28244307',
    'http://www.wikidata.org/entity/Q28244314',
    'http://www.wikidata.org/entity/Q28244320',
    'http://www.wikidata.org/entity/Q28244377',
    'http://www.wikidata.org/entity/Q28244381',
    'http://www.wikidata.org/entity/Q28244389',
    'http://www.wikidata.org/entity/Q28244392',
    'http://www.wikidata.org/entity/Q28244397',
    'http://www.wikidata.org/entity/Q28244404',
    'http://www.wikidata.org/entity/Q28244449',
    'http://www.wikidata.org/entity/Q28244462',
    'http://www.wikidata.org/entity/Q28244530',
    'http://www.wikidata.org/entity/Q28244563',
    'http://www.wikidata.org/entity/Q28244731',
    'http://www.wikidata.org/entity/Q28244734',
    'http://www.wikidata.org/entity/Q28244809',
    'http://www.wikidata.org/entity/Q28244815',
    'http://www.wikidata.org/entity/Q28244853',
    'http://www.wikidata.org/entity/Q28244864',
    'http://www.wikidata.org/entity/Q28244877',
    'http://www.wikidata.org/entity/Q28244898',
    'http://www.wikidata.org/entity/Q28244968',
    'http://www.wikidata.org/entity/Q28244982',
    'http://www.wikidata.org/entity/Q28244985',
    'http://www.wikidata.org/entity/Q28244995',
    'http://www.wikidata.org/entity/Q28245016',
    'http://www.wikidata.org/entity/Q28245045',
    'http://www.wikidata.org/entity/Q28245141',
    'http://www.wikidata.org/entity/Q28245143',
    'http://www.wikidata.org/entity/Q28245144',
    'http://www.wikidata.org/entity/Q28245149',
    'http://www.wikidata.org/entity/Q28245159',
    'http://www.wikidata.org/entity/Q28245164',
    'http://www.wikidata.org/entity/Q28245188',
    'http://www.wikidata.org/entity/Q28245231',
    'http://www.wikidata.org/entity/Q28245251',
    'http://www.wikidata.org/entity/Q28245289',
    'http://www.wikidata.org/entity/Q28245307',
    'http://www.wikidata.org/entity/Q28245338',
    'http://www.wikidata.org/entity/Q28245341',
    'http://www.wikidata.org/entity/Q28245344',
    'http://www.wikidata.org/entity/Q28245355',
    'http://www.wikidata.org/entity/Q28245431',
    'http://www.wikidata.org/entity/Q28245479',
    'http://www.wikidata.org/entity/Q28245526',
    'http://www.wikidata.org/entity/Q28245528',
    'http://www.wikidata.org/entity/Q28245569',
    'http://www.wikidata.org/entity/Q28245573',
    'http://www.wikidata.org/entity/Q28245627',
    'http://www.wikidata.org/entity/Q28245647',
    'http://www.wikidata.org/entity/Q28245679',
    'http://www.wikidata.org/entity/Q28245694',
    'http://www.wikidata.org/entity/Q28245701',
    'http://www.wikidata.org/entity/Q28245704',
    'http://www.wikidata.org/entity/Q28245737',
    'http://www.wikidata.org/entity/Q28245795',
    'http://www.wikidata.org/entity/Q28245865',
    'http://www.wikidata.org/entity/Q28245873',
    'http://www.wikidata.org/entity/Q28245876',
    'http://www.wikidata.org/entity/Q28245909',
    'http://www.wikidata.org/entity/Q28245948',
    'http://www.wikidata.org/entity/Q28246097',
    'http://www.wikidata.org/entity/Q28246110',
    'http://www.wikidata.org/entity/Q28246120',
    'http://www.wikidata.org/entity/Q28246128',
    'http://www.wikidata.org/entity/Q28246161',
    'http://www.wikidata.org/entity/Q28246193',
    'http://www.wikidata.org/entity/Q28246204',
    'http://www.wikidata.org/entity/Q28246229',
    'http://www.wikidata.org/entity/Q28246239',
    'http://www.wikidata.org/entity/Q28246252',
    'http://www.wikidata.org/entity/Q28246321',
    'http://www.wikidata.org/entity/Q28246349',
    'http://www.wikidata.org/entity/Q28246395',
    'http://www.wikidata.org/entity/Q28246401',
    'http://www.wikidata.org/entity/Q28246430',
    'http://www.wikidata.org/entity/Q28246520',
    'http://www.wikidata.org/entity/Q28246526',
    'http://www.wikidata.org/entity/Q28246552',
    'http://www.wikidata.org/entity/Q28246556',
    'http://www.wikidata.org/entity/Q28246613',
    'http://www.wikidata.org/entity/Q28246677',
    'http://www.wikidata.org/entity/Q28246681',
    'http://www.wikidata.org/entity/Q28246694',
    'http://www.wikidata.org/entity/Q28246731',
    'http://www.wikidata.org/entity/Q28246794',
    'http://www.wikidata.org/entity/Q28246797',
    'http://www.wikidata.org/entity/Q28246808',
    'http://www.wikidata.org/entity/Q28246858',
    'http://www.wikidata.org/entity/Q28246957',
    'http://www.wikidata.org/entity/Q28246968',
    'http://www.wikidata.org/entity/Q28246982',
    'http://www.wikidata.org/entity/Q28246986',
    'http://www.wikidata.org/entity/Q28246991',
    'http://www.wikidata.org/entity/Q28247002',
    'http://www.wikidata.org/entity/Q28247024',
    'http://www.wikidata.org/entity/Q28247026',
    'http://www.wikidata.org/entity/Q28247033',
    'http://www.wikidata.org/entity/Q28247041',
    'http://www.wikidata.org/entity/Q28247046',
    'http://www.wikidata.org/entity/Q28247080',
    'http://www.wikidata.org/entity/Q28247091',
    'http://www.wikidata.org/entity/Q28247092',
    'http://www.wikidata.org/entity/Q28247137',
    'http://www.wikidata.org/entity/Q28247306',
    'http://www.wikidata.org/entity/Q28247333',
    'http://www.wikidata.org/entity/Q28247385',
    'http://www.wikidata.org/entity/Q28247386',
    'http://www.wikidata.org/entity/Q28247469',
    'http://www.wikidata.org/entity/Q28247489',
    'http://www.wikidata.org/entity/Q28247492',
    'http://www.wikidata.org/entity/Q28247536',
    'http://www.wikidata.org/entity/Q28247567',
    'http://www.wikidata.org/entity/Q28247594',
    'http://www.wikidata.org/entity/Q28247617',
    'http://www.wikidata.org/entity/Q28247624',
    'http://www.wikidata.org/entity/Q28247650',
    'http://www.wikidata.org/entity/Q28247652',
    'http://www.wikidata.org/entity/Q28247666',
    'http://www.wikidata.org/entity/Q28247673',
    'http://www.wikidata.org/entity/Q28247684',
    'http://www.wikidata.org/entity/Q28247685',
    'http://www.wikidata.org/entity/Q28247710',
    'http://www.wikidata.org/entity/Q28247727',
    'http://www.wikidata.org/entity/Q28247739',
    'http://www.wikidata.org/entity/Q28247746',
    'http://www.wikidata.org/entity/Q28247757',
    'http://www.wikidata.org/entity/Q28247761',
    'http://www.wikidata.org/entity/Q28247771',
    'http://www.wikidata.org/entity/Q28247791',
    'http://www.wikidata.org/entity/Q28247893',
    'http://www.wikidata.org/entity/Q28247928',
    'http://www.wikidata.org/entity/Q28247990',
    'http://www.wikidata.org/entity/Q28248011',
    'http://www.wikidata.org/entity/Q28248073',
    'http://www.wikidata.org/entity/Q28248075',
    'http://www.wikidata.org/entity/Q28248087',
    'http://www.wikidata.org/entity/Q28248101',
    'http://www.wikidata.org/entity/Q28248180',
    'http://www.wikidata.org/entity/Q28248195',
    'http://www.wikidata.org/entity/Q28248202',
    'http://www.wikidata.org/entity/Q28248260',
    'http://www.wikidata.org/entity/Q28248366',
    'http://www.wikidata.org/entity/Q28248384',
    'http://www.wikidata.org/entity/Q28248395',
    'http://www.wikidata.org/entity/Q28248431',
    'http://www.wikidata.org/entity/Q28248486',
    'http://www.wikidata.org/entity/Q28248489',
    'http://www.wikidata.org/entity/Q28248500',
    'http://www.wikidata.org/entity/Q28248503',
    'http://www.wikidata.org/entity/Q28248516',
    'http://www.wikidata.org/entity/Q28248601',
    'http://www.wikidata.org/entity/Q28248603',
    'http://www.wikidata.org/entity/Q28248660',
    'http://www.wikidata.org/entity/Q28248676',
    'http://www.wikidata.org/entity/Q28248760',
    'http://www.wikidata.org/entity/Q28248794',
    'http://www.wikidata.org/entity/Q28248823',
    'http://www.wikidata.org/entity/Q28248838',
    'http://www.wikidata.org/entity/Q28248848',
    'http://www.wikidata.org/entity/Q28248858',
    'http://www.wikidata.org/entity/Q28248919',
    'http://www.wikidata.org/entity/Q28248931',
    'http://www.wikidata.org/entity/Q28249001',
    'http://www.wikidata.org/entity/Q28249105',
    'http://www.wikidata.org/entity/Q28249108',
    'http://www.wikidata.org/entity/Q28249175',
    'http://www.wikidata.org/entity/Q28249185',
    'http://www.wikidata.org/entity/Q28249211',
    'http://www.wikidata.org/entity/Q28249217',
    'http://www.wikidata.org/entity/Q28249223',
    'http://www.wikidata.org/entity/Q28249238',
    'http://www.wikidata.org/entity/Q28249275',
    'http://www.wikidata.org/entity/Q28249276',
    'http://www.wikidata.org/entity/Q28249363',
    'http://www.wikidata.org/entity/Q28249437',
    'http://www.wikidata.org/entity/Q28249458',
    'http://www.wikidata.org/entity/Q28249478',
    'http://www.wikidata.org/entity/Q28249487',
    'http://www.wikidata.org/entity/Q28249490',
    'http://www.wikidata.org/entity/Q28249509',
    'http://www.wikidata.org/entity/Q28249527',
    'http://www.wikidata.org/entity/Q28249536',
    'http://www.wikidata.org/entity/Q28249543',
    'http://www.wikidata.org/entity/Q28249559',
    'http://www.wikidata.org/entity/Q28249561',
    'http://www.wikidata.org/entity/Q28249564',
    'http://www.wikidata.org/entity/Q28249570',
    'http://www.wikidata.org/entity/Q28249575',
    'http://www.wikidata.org/entity/Q28249594',
    'http://www.wikidata.org/entity/Q28249658',
    'http://www.wikidata.org/entity/Q28249676',
    'http://www.wikidata.org/entity/Q28249770',
    'http://www.wikidata.org/entity/Q28249783',
    'http://www.wikidata.org/entity/Q28249785',
    'http://www.wikidata.org/entity/Q28249953',
    'http://www.wikidata.org/entity/Q28250035',
    'http://www.wikidata.org/entity/Q28250131',
    'http://www.wikidata.org/entity/Q28250167',
    'http://www.wikidata.org/entity/Q28250200',
    'http://www.wikidata.org/entity/Q28250257',
    'http://www.wikidata.org/entity/Q28250305',
    'http://www.wikidata.org/entity/Q28250347',
    'http://www.wikidata.org/entity/Q28250444',
    'http://www.wikidata.org/entity/Q28250476',
    'http://www.wikidata.org/entity/Q28250518',
    'http://www.wikidata.org/entity/Q28250542',
    'http://www.wikidata.org/entity/Q28250561',
    'http://www.wikidata.org/entity/Q28250587',
    'http://www.wikidata.org/entity/Q28250609',
    'http://www.wikidata.org/entity/Q28250660',
    'http://www.wikidata.org/entity/Q28250671',
    'http://www.wikidata.org/entity/Q28250679',
    'http://www.wikidata.org/entity/Q28250737',
    'http://www.wikidata.org/entity/Q28250800',
    'http://www.wikidata.org/entity/Q28250812',
    'http://www.wikidata.org/entity/Q28250846',
    'http://www.wikidata.org/entity/Q28250869',
    'http://www.wikidata.org/entity/Q28250973',
    'http://www.wikidata.org/entity/Q28250989',
    'http://www.wikidata.org/entity/Q28251015',
    'http://www.wikidata.org/entity/Q28251042',
    'http://www.wikidata.org/entity/Q28251102',
    'http://www.wikidata.org/entity/Q28251216',
    'http://www.wikidata.org/entity/Q28251260',
    'http://www.wikidata.org/entity/Q28251375',
    'http://www.wikidata.org/entity/Q28251400',
    'http://www.wikidata.org/entity/Q28251443',
    'http://www.wikidata.org/entity/Q28251449',
    'http://www.wikidata.org/entity/Q28251461',
    'http://www.wikidata.org/entity/Q28251475',
    'http://www.wikidata.org/entity/Q28251488',
    'http://www.wikidata.org/entity/Q28251518',
    'http://www.wikidata.org/entity/Q28251528',
    'http://www.wikidata.org/entity/Q28251545',
    'http://www.wikidata.org/entity/Q28251567',
    'http://www.wikidata.org/entity/Q28251589',
    'http://www.wikidata.org/entity/Q28251621',
    'http://www.wikidata.org/entity/Q28251714',
    'http://www.wikidata.org/entity/Q28251731',
    'http://www.wikidata.org/entity/Q28251735',
    'http://www.wikidata.org/entity/Q28251743',
    'http://www.wikidata.org/entity/Q28251778',
    'http://www.wikidata.org/entity/Q28251800',
    'http://www.wikidata.org/entity/Q28251805',
    'http://www.wikidata.org/entity/Q28251818',
    'http://www.wikidata.org/entity/Q28251846',
    'http://www.wikidata.org/entity/Q28251863',
    'http://www.wikidata.org/entity/Q28251868',
    'http://www.wikidata.org/entity/Q28251897',
    'http://www.wikidata.org/entity/Q28251899',
    'http://www.wikidata.org/entity/Q28251918',
    'http://www.wikidata.org/entity/Q28251939',
    'http://www.wikidata.org/entity/Q28251977',
    'http://www.wikidata.org/entity/Q28251989',
    'http://www.wikidata.org/entity/Q28251995',
    'http://www.wikidata.org/entity/Q28252070',
    'http://www.wikidata.org/entity/Q28252088',
    'http://www.wikidata.org/entity/Q28252102',
    'http://www.wikidata.org/entity/Q28252147',
    'http://www.wikidata.org/entity/Q28252216',
    'http://www.wikidata.org/entity/Q28252221',
    'http://www.wikidata.org/entity/Q28252247',
    'http://www.wikidata.org/entity/Q28252251',
    'http://www.wikidata.org/entity/Q28252268',
    'http://www.wikidata.org/entity/Q28252291',
    'http://www.wikidata.org/entity/Q28252295',
    'http://www.wikidata.org/entity/Q28252298',
    'http://www.wikidata.org/entity/Q28252340',
    'http://www.wikidata.org/entity/Q28252389',
    'http://www.wikidata.org/entity/Q28252404',
    'http://www.wikidata.org/entity/Q28252425',
    'http://www.wikidata.org/entity/Q28252435',
    'http://www.wikidata.org/entity/Q28252462',
    'http://www.wikidata.org/entity/Q28252477',
    'http://www.wikidata.org/entity/Q28252549',
    'http://www.wikidata.org/entity/Q28252669',
    'http://www.wikidata.org/entity/Q28252678',
    'http://www.wikidata.org/entity/Q28252722',
    'http://www.wikidata.org/entity/Q28252726',
    'http://www.wikidata.org/entity/Q28252805',
    'http://www.wikidata.org/entity/Q28252825',
    'http://www.wikidata.org/entity/Q28252857',
    'http://www.wikidata.org/entity/Q28252919',
    'http://www.wikidata.org/entity/Q28252937',
    'http://www.wikidata.org/entity/Q28252947',
    'http://www.wikidata.org/entity/Q28253006',
    'http://www.wikidata.org/entity/Q28253048',
    'http://www.wikidata.org/entity/Q28253052',
    'http://www.wikidata.org/entity/Q28253058',
    'http://www.wikidata.org/entity/Q28253062',
    'http://www.wikidata.org/entity/Q28253074',
    'http://www.wikidata.org/entity/Q28253118',
    'http://www.wikidata.org/entity/Q28253124',
    'http://www.wikidata.org/entity/Q28253126',
    'http://www.wikidata.org/entity/Q28253146',
    'http://www.wikidata.org/entity/Q28253246',
    'http://www.wikidata.org/entity/Q28253247',
    'http://www.wikidata.org/entity/Q28253248',
    'http://www.wikidata.org/entity/Q28253317',
    'http://www.wikidata.org/entity/Q28253333',
    'http://www.wikidata.org/entity/Q28253391',
    'http://www.wikidata.org/entity/Q28253399',
    'http://www.wikidata.org/entity/Q28253408',
    'http://www.wikidata.org/entity/Q28253424',
    'http://www.wikidata.org/entity/Q28253429',
    'http://www.wikidata.org/entity/Q28253495',
    'http://www.wikidata.org/entity/Q28253554',
    'http://www.wikidata.org/entity/Q28253558',
    'http://www.wikidata.org/entity/Q28253639',
    'http://www.wikidata.org/entity/Q28253651',
    'http://www.wikidata.org/entity/Q28253753',
    'http://www.wikidata.org/entity/Q28253761',
    'http://www.wikidata.org/entity/Q28253823',
    'http://www.wikidata.org/entity/Q28253919',
    'http://www.wikidata.org/entity/Q28253941',
    'http://www.wikidata.org/entity/Q28253993',
    'http://www.wikidata.org/entity/Q28254001',
    'http://www.wikidata.org/entity/Q28254031',
    'http://www.wikidata.org/entity/Q28254047',
    'http://www.wikidata.org/entity/Q28254056',
    'http://www.wikidata.org/entity/Q28254095',
    'http://www.wikidata.org/entity/Q28254108',
    'http://www.wikidata.org/entity/Q28254114',
    'http://www.wikidata.org/entity/Q28254150',
    'http://www.wikidata.org/entity/Q28254206',
    'http://www.wikidata.org/entity/Q28254263',
    'http://www.wikidata.org/entity/Q28254266',
    'http://www.wikidata.org/entity/Q28254283',
    'http://www.wikidata.org/entity/Q28254349',
    'http://www.wikidata.org/entity/Q28254365',
    'http://www.wikidata.org/entity/Q28254406',
    'http://www.wikidata.org/entity/Q28254528',
    'http://www.wikidata.org/entity/Q28254549',
    'http://www.wikidata.org/entity/Q28254584',
    'http://www.wikidata.org/entity/Q28254604',
    'http://www.wikidata.org/entity/Q28254606',
    'http://www.wikidata.org/entity/Q28254628',
    'http://www.wikidata.org/entity/Q28254705',
    'http://www.wikidata.org/entity/Q28254763',
    'http://www.wikidata.org/entity/Q28254836',
    'http://www.wikidata.org/entity/Q28254858',
    'http://www.wikidata.org/entity/Q28254867',
    'http://www.wikidata.org/entity/Q28254935',
    'http://www.wikidata.org/entity/Q28254978',
    'http://www.wikidata.org/entity/Q28254986',
    'http://www.wikidata.org/entity/Q28254991',
    'http://www.wikidata.org/entity/Q28255064',
    'http://www.wikidata.org/entity/Q28255103',
    'http://www.wikidata.org/entity/Q28255115',
    'http://www.wikidata.org/entity/Q28255124',
    'http://www.wikidata.org/entity/Q28255137',
    'http://www.wikidata.org/entity/Q28255147',
    'http://www.wikidata.org/entity/Q28255148',
    'http://www.wikidata.org/entity/Q28255215',
    'http://www.wikidata.org/entity/Q28255243',
    'http://www.wikidata.org/entity/Q28255255',
    'http://www.wikidata.org/entity/Q28255257',
    'http://www.wikidata.org/entity/Q28255343',
    'http://www.wikidata.org/entity/Q28255366',
    'http://www.wikidata.org/entity/Q28255373',
    'http://www.wikidata.org/entity/Q28255377',
    'http://www.wikidata.org/entity/Q28255391',
    'http://www.wikidata.org/entity/Q28255399',
    'http://www.wikidata.org/entity/Q28255432',
    'http://www.wikidata.org/entity/Q28255435',
    'http://www.wikidata.org/entity/Q28255466',
    'http://www.wikidata.org/entity/Q28255529',
    'http://www.wikidata.org/entity/Q28255536',
    'http://www.wikidata.org/entity/Q28255548',
    'http://www.wikidata.org/entity/Q28255554',
    'http://www.wikidata.org/entity/Q28255557',
    'http://www.wikidata.org/entity/Q28255574',
    'http://www.wikidata.org/entity/Q28255590',
    'http://www.wikidata.org/entity/Q28255665',
    'http://www.wikidata.org/entity/Q28255669',
    'http://www.wikidata.org/entity/Q28255714',
    'http://www.wikidata.org/entity/Q28255756',
    'http://www.wikidata.org/entity/Q28255797',
    'http://www.wikidata.org/entity/Q28255842',
    'http://www.wikidata.org/entity/Q28255867',
    'http://www.wikidata.org/entity/Q28255949',
    'http://www.wikidata.org/entity/Q28255959',
    'http://www.wikidata.org/entity/Q28255974',
    'http://www.wikidata.org/entity/Q28255981',
    'http://www.wikidata.org/entity/Q28256001',
    'http://www.wikidata.org/entity/Q28256069',
    'http://www.wikidata.org/entity/Q28256078',
    'http://www.wikidata.org/entity/Q28256121',
    'http://www.wikidata.org/entity/Q28256122',
    'http://www.wikidata.org/entity/Q28256150',
    'http://www.wikidata.org/entity/Q28256153',
    'http://www.wikidata.org/entity/Q28256186',
    'http://www.wikidata.org/entity/Q28256189',
    'http://www.wikidata.org/entity/Q28256190',
    'http://www.wikidata.org/entity/Q28256254',
    'http://www.wikidata.org/entity/Q28256332',
    'http://www.wikidata.org/entity/Q28256381',
    'http://www.wikidata.org/entity/Q28256420',
    'http://www.wikidata.org/entity/Q28256434',
    'http://www.wikidata.org/entity/Q28256451',
    'http://www.wikidata.org/entity/Q28256462',
    'http://www.wikidata.org/entity/Q28256503',
    'http://www.wikidata.org/entity/Q28256510',
    'http://www.wikidata.org/entity/Q28256549',
    'http://www.wikidata.org/entity/Q28256558',
    'http://www.wikidata.org/entity/Q28256570',
    'http://www.wikidata.org/entity/Q28256580',
    'http://www.wikidata.org/entity/Q28256592',
    'http://www.wikidata.org/entity/Q28256604',
    'http://www.wikidata.org/entity/Q28256614',
    'http://www.wikidata.org/entity/Q28256703',
    'http://www.wikidata.org/entity/Q28256736',
    'http://www.wikidata.org/entity/Q28256740',
    'http://www.wikidata.org/entity/Q28256741',
    'http://www.wikidata.org/entity/Q28256770',
    'http://www.wikidata.org/entity/Q28256786',
    'http://www.wikidata.org/entity/Q28256854',
    'http://www.wikidata.org/entity/Q28256859',
    'http://www.wikidata.org/entity/Q28256861',
    'http://www.wikidata.org/entity/Q28256864',
    'http://www.wikidata.org/entity/Q28256872',
    'http://www.wikidata.org/entity/Q28256892',
    'http://www.wikidata.org/entity/Q28256895',
    'http://www.wikidata.org/entity/Q28256968',
    'http://www.wikidata.org/entity/Q28256988',
    'http://www.wikidata.org/entity/Q28257011',
    'http://www.wikidata.org/entity/Q28257028',
    'http://www.wikidata.org/entity/Q28257083',
    'http://www.wikidata.org/entity/Q28257086',
    'http://www.wikidata.org/entity/Q28257125',
    'http://www.wikidata.org/entity/Q28257134',
    'http://www.wikidata.org/entity/Q28257199',
    'http://www.wikidata.org/entity/Q28257220',
    'http://www.wikidata.org/entity/Q28257305',
    'http://www.wikidata.org/entity/Q28257360',
    'http://www.wikidata.org/entity/Q28257389',
    'http://www.wikidata.org/entity/Q28257443',
    'http://www.wikidata.org/entity/Q28257459',
    'http://www.wikidata.org/entity/Q28257476',
    'http://www.wikidata.org/entity/Q28257480',
    'http://www.wikidata.org/entity/Q28257541',
    'http://www.wikidata.org/entity/Q28257571',
    'http://www.wikidata.org/entity/Q28257612',
    'http://www.wikidata.org/entity/Q28257618',
    'http://www.wikidata.org/entity/Q28257649',
    'http://www.wikidata.org/entity/Q28257700',
    'http://www.wikidata.org/entity/Q28257710',
    'http://www.wikidata.org/entity/Q28257717',
    'http://www.wikidata.org/entity/Q28257738',
    'http://www.wikidata.org/entity/Q28257776',
    'http://www.wikidata.org/entity/Q28257861',
    'http://www.wikidata.org/entity/Q28257888',
    'http://www.wikidata.org/entity/Q28258027',
    'http://www.wikidata.org/entity/Q28258045',
    'http://www.wikidata.org/entity/Q28258118',
    'http://www.wikidata.org/entity/Q28258127',
    'http://www.wikidata.org/entity/Q28258134',
    'http://www.wikidata.org/entity/Q28258212',
    'http://www.wikidata.org/entity/Q28258215',
    'http://www.wikidata.org/entity/Q28258266',
    'http://www.wikidata.org/entity/Q28258300',
    'http://www.wikidata.org/entity/Q28258328',
    'http://www.wikidata.org/entity/Q28258335',
    'http://www.wikidata.org/entity/Q28258349',
    'http://www.wikidata.org/entity/Q28258384',
    'http://www.wikidata.org/entity/Q28258404',
    'http://www.wikidata.org/entity/Q28258410',
    'http://www.wikidata.org/entity/Q28258422',
    'http://www.wikidata.org/entity/Q28258427',
    'http://www.wikidata.org/entity/Q28258433',
    'http://www.wikidata.org/entity/Q28258445',
    'http://www.wikidata.org/entity/Q28258448',
    'http://www.wikidata.org/entity/Q28258462',
    'http://www.wikidata.org/entity/Q28258490',
    'http://www.wikidata.org/entity/Q28258560',
    'http://www.wikidata.org/entity/Q28258638',
    'http://www.wikidata.org/entity/Q28258681',
    'http://www.wikidata.org/entity/Q28258706',
    'http://www.wikidata.org/entity/Q28258938',
    'http://www.wikidata.org/entity/Q28258948',
    'http://www.wikidata.org/entity/Q28258959',
    'http://www.wikidata.org/entity/Q28258965',
    'http://www.wikidata.org/entity/Q28258984',
    'http://www.wikidata.org/entity/Q28258994',
    'http://www.wikidata.org/entity/Q28258997',
    'http://www.wikidata.org/entity/Q28259011',
    'http://www.wikidata.org/entity/Q28259012',
    'http://www.wikidata.org/entity/Q28259033',
    'http://www.wikidata.org/entity/Q28259055',
    'http://www.wikidata.org/entity/Q28259080',
    'http://www.wikidata.org/entity/Q28259109',
    'http://www.wikidata.org/entity/Q28259134',
    'http://www.wikidata.org/entity/Q28259147',
    'http://www.wikidata.org/entity/Q28259151',
    'http://www.wikidata.org/entity/Q28259222',
    'http://www.wikidata.org/entity/Q28259238',
    'http://www.wikidata.org/entity/Q28259255',
    'http://www.wikidata.org/entity/Q28259293',
    'http://www.wikidata.org/entity/Q28259309',
    'http://www.wikidata.org/entity/Q28259332',
    'http://www.wikidata.org/entity/Q28259349',
    'http://www.wikidata.org/entity/Q28259380',
    'http://www.wikidata.org/entity/Q28259416',
    'http://www.wikidata.org/entity/Q28259513',
    'http://www.wikidata.org/entity/Q28259521',
    'http://www.wikidata.org/entity/Q28259546',
    'http://www.wikidata.org/entity/Q28259549',
    'http://www.wikidata.org/entity/Q28259572',
    'http://www.wikidata.org/entity/Q28259598',
    'http://www.wikidata.org/entity/Q28259615',
    'http://www.wikidata.org/entity/Q28259624',
    'http://www.wikidata.org/entity/Q28259654',
    'http://www.wikidata.org/entity/Q28259668',
    'http://www.wikidata.org/entity/Q28259677',
    'http://www.wikidata.org/entity/Q28259862',
    'http://www.wikidata.org/entity/Q28259898',
    'http://www.wikidata.org/entity/Q28259930',
    'http://www.wikidata.org/entity/Q28259993',
    'http://www.wikidata.org/entity/Q28260037',
    'http://www.wikidata.org/entity/Q28260062',
    'http://www.wikidata.org/entity/Q28260114',
    'http://www.wikidata.org/entity/Q28260215',
    'http://www.wikidata.org/entity/Q28260227',
    'http://www.wikidata.org/entity/Q28260326',
    'http://www.wikidata.org/entity/Q28260421',
    'http://www.wikidata.org/entity/Q28260454',
    'http://www.wikidata.org/entity/Q28260479',
    'http://www.wikidata.org/entity/Q28260514',
    'http://www.wikidata.org/entity/Q28260517',
    'http://www.wikidata.org/entity/Q28260550',
    'http://www.wikidata.org/entity/Q28260573',
    'http://www.wikidata.org/entity/Q28260621',
    'http://www.wikidata.org/entity/Q28260686',
    'http://www.wikidata.org/entity/Q28260702',
    'http://www.wikidata.org/entity/Q28260771',
    'http://www.wikidata.org/entity/Q28260798',
    'http://www.wikidata.org/entity/Q28260803',
    'http://www.wikidata.org/entity/Q28260833',
    'http://www.wikidata.org/entity/Q28260929',
    'http://www.wikidata.org/entity/Q28260987',
    'http://www.wikidata.org/entity/Q28261071',
    'http://www.wikidata.org/entity/Q28261130',
    'http://www.wikidata.org/entity/Q28261151',
    'http://www.wikidata.org/entity/Q28261200',
    'http://www.wikidata.org/entity/Q28261205',
    'http://www.wikidata.org/entity/Q28261230',
    'http://www.wikidata.org/entity/Q28261260',
    'http://www.wikidata.org/entity/Q28261263',
    'http://www.wikidata.org/entity/Q28261264',
    'http://www.wikidata.org/entity/Q28261273',
    'http://www.wikidata.org/entity/Q28261279',
    'http://www.wikidata.org/entity/Q28261309',
    'http://www.wikidata.org/entity/Q28261335',
    'http://www.wikidata.org/entity/Q28261365',
    'http://www.wikidata.org/entity/Q28261376',
    'http://www.wikidata.org/entity/Q28261458',
    'http://www.wikidata.org/entity/Q28261534',
    'http://www.wikidata.org/entity/Q28261537',
    'http://www.wikidata.org/entity/Q28261550',
    'http://www.wikidata.org/entity/Q28261556',
    'http://www.wikidata.org/entity/Q28261558',
    'http://www.wikidata.org/entity/Q28261561',
    'http://www.wikidata.org/entity/Q28261689',
    'http://www.wikidata.org/entity/Q28261694',
    'http://www.wikidata.org/entity/Q28261746',
    'http://www.wikidata.org/entity/Q28261756',
    'http://www.wikidata.org/entity/Q28261784',
    'http://www.wikidata.org/entity/Q28261794',
    'http://www.wikidata.org/entity/Q28261882',
    'http://www.wikidata.org/entity/Q28261899',
    'http://www.wikidata.org/entity/Q28261936',
    'http://www.wikidata.org/entity/Q28261987',
    'http://www.wikidata.org/entity/Q28261993',
    'http://www.wikidata.org/entity/Q28262025',
    'http://www.wikidata.org/entity/Q28262090',
    'http://www.wikidata.org/entity/Q28262094',
    'http://www.wikidata.org/entity/Q28262120',
    'http://www.wikidata.org/entity/Q28262214',
    'http://www.wikidata.org/entity/Q28262230',
    'http://www.wikidata.org/entity/Q28262326',
    'http://www.wikidata.org/entity/Q28262401',
    'http://www.wikidata.org/entity/Q28262431',
    'http://www.wikidata.org/entity/Q28262499',
    'http://www.wikidata.org/entity/Q28262523',
    'http://www.wikidata.org/entity/Q28262538',
    'http://www.wikidata.org/entity/Q28262541',
    'http://www.wikidata.org/entity/Q28262548',
    'http://www.wikidata.org/entity/Q28262594',
    'http://www.wikidata.org/entity/Q28262619',
    'http://www.wikidata.org/entity/Q28262641',
    'http://www.wikidata.org/entity/Q28262642',
    'http://www.wikidata.org/entity/Q28262647',
    'http://www.wikidata.org/entity/Q28262679',
    'http://www.wikidata.org/entity/Q28262710',
    'http://www.wikidata.org/entity/Q28262730',
    'http://www.wikidata.org/entity/Q28262747',
    'http://www.wikidata.org/entity/Q28262782',
    'http://www.wikidata.org/entity/Q28262793',
    'http://www.wikidata.org/entity/Q28262802',
    'http://www.wikidata.org/entity/Q28262856',
    'http://www.wikidata.org/entity/Q28262858',
    'http://www.wikidata.org/entity/Q28262859',
    'http://www.wikidata.org/entity/Q28262867',
    'http://www.wikidata.org/entity/Q28262914',
    'http://www.wikidata.org/entity/Q28262938',
    'http://www.wikidata.org/entity/Q28263038',
    'http://www.wikidata.org/entity/Q28263182',
    'http://www.wikidata.org/entity/Q28263191',
    'http://www.wikidata.org/entity/Q28263210',
    'http://www.wikidata.org/entity/Q28263225',
    'http://www.wikidata.org/entity/Q28263238',
    'http://www.wikidata.org/entity/Q28263273',
    'http://www.wikidata.org/entity/Q28263277',
    'http://www.wikidata.org/entity/Q28263292',
    'http://www.wikidata.org/entity/Q28263307',
    'http://www.wikidata.org/entity/Q28263314',
    'http://www.wikidata.org/entity/Q28263425',
    'http://www.wikidata.org/entity/Q28263484',
    'http://www.wikidata.org/entity/Q28263511',
    'http://www.wikidata.org/entity/Q28263551',
    'http://www.wikidata.org/entity/Q28263573',
    'http://www.wikidata.org/entity/Q28263589',
    'http://www.wikidata.org/entity/Q28263594',
    'http://www.wikidata.org/entity/Q28263676',
    'http://www.wikidata.org/entity/Q28263689',
    'http://www.wikidata.org/entity/Q28263721',
    'http://www.wikidata.org/entity/Q28263722',
    'http://www.wikidata.org/entity/Q28263725',
    'http://www.wikidata.org/entity/Q28263735',
    'http://www.wikidata.org/entity/Q28263757',
    'http://www.wikidata.org/entity/Q28263759',
    'http://www.wikidata.org/entity/Q28263787',
    'http://www.wikidata.org/entity/Q28263802',
    'http://www.wikidata.org/entity/Q28263829',
    'http://www.wikidata.org/entity/Q28263840',
    'http://www.wikidata.org/entity/Q28263850',
    'http://www.wikidata.org/entity/Q28263865',
    'http://www.wikidata.org/entity/Q28263905',
    'http://www.wikidata.org/entity/Q28263907',
    'http://www.wikidata.org/entity/Q28264011',
    'http://www.wikidata.org/entity/Q28264016',
    'http://www.wikidata.org/entity/Q28264038',
    'http://www.wikidata.org/entity/Q28264077',
    'http://www.wikidata.org/entity/Q28264120',
    'http://www.wikidata.org/entity/Q28264134',
    'http://www.wikidata.org/entity/Q28264146',
    'http://www.wikidata.org/entity/Q28264155',
    'http://www.wikidata.org/entity/Q28264163',
    'http://www.wikidata.org/entity/Q28264205',
    'http://www.wikidata.org/entity/Q28264215',
    'http://www.wikidata.org/entity/Q28264221',
    'http://www.wikidata.org/entity/Q28264225',
    'http://www.wikidata.org/entity/Q28264234',
    'http://www.wikidata.org/entity/Q28264242',
    'http://www.wikidata.org/entity/Q28264273',
    'http://www.wikidata.org/entity/Q28264400',
    'http://www.wikidata.org/entity/Q28264479',
    'http://www.wikidata.org/entity/Q28264518',
    'http://www.wikidata.org/entity/Q28264527',
    'http://www.wikidata.org/entity/Q28264535',
    'http://www.wikidata.org/entity/Q28264540',
    'http://www.wikidata.org/entity/Q28264555',
    'http://www.wikidata.org/entity/Q28264588',
    'http://www.wikidata.org/entity/Q28264602',
    'http://www.wikidata.org/entity/Q28264653',
    'http://www.wikidata.org/entity/Q28264690',
    'http://www.wikidata.org/entity/Q28264741',
    'http://www.wikidata.org/entity/Q28264748',
    'http://www.wikidata.org/entity/Q28264762',
    'http://www.wikidata.org/entity/Q28264776',
    'http://www.wikidata.org/entity/Q28264780',
    'http://www.wikidata.org/entity/Q28264800',
    'http://www.wikidata.org/entity/Q28264813',
    'http://www.wikidata.org/entity/Q28264821',
    'http://www.wikidata.org/entity/Q28264823',
    'http://www.wikidata.org/entity/Q28264852',
    'http://www.wikidata.org/entity/Q28264861',
    'http://www.wikidata.org/entity/Q28264906',
    'http://www.wikidata.org/entity/Q28264918',
    'http://www.wikidata.org/entity/Q28264923',
    'http://www.wikidata.org/entity/Q28264933',
    'http://www.wikidata.org/entity/Q28264999',
    'http://www.wikidata.org/entity/Q28265001',
    'http://www.wikidata.org/entity/Q28265011',
    'http://www.wikidata.org/entity/Q28265019',
    'http://www.wikidata.org/entity/Q28265101',
    'http://www.wikidata.org/entity/Q28265104',
    'http://www.wikidata.org/entity/Q28265188',
    'http://www.wikidata.org/entity/Q28265206',
    'http://www.wikidata.org/entity/Q28265233',
    'http://www.wikidata.org/entity/Q28265278',
    'http://www.wikidata.org/entity/Q28265420',
    'http://www.wikidata.org/entity/Q28265477',
    'http://www.wikidata.org/entity/Q28265506',
    'http://www.wikidata.org/entity/Q28265515',
    'http://www.wikidata.org/entity/Q28265573',
    'http://www.wikidata.org/entity/Q28265610',
    'http://www.wikidata.org/entity/Q28265616',
    'http://www.wikidata.org/entity/Q28265708',
    'http://www.wikidata.org/entity/Q28265743',
    'http://www.wikidata.org/entity/Q28265784',
    'http://www.wikidata.org/entity/Q28265811',
    'http://www.wikidata.org/entity/Q28265842',
    'http://www.wikidata.org/entity/Q28265850',
    'http://www.wikidata.org/entity/Q28265852',
    'http://www.wikidata.org/entity/Q28265871',
    'http://www.wikidata.org/entity/Q28265876',
    'http://www.wikidata.org/entity/Q28265884',
    'http://www.wikidata.org/entity/Q28265888',
    'http://www.wikidata.org/entity/Q28265917',
    'http://www.wikidata.org/entity/Q28265924',
    'http://www.wikidata.org/entity/Q28266156',
    'http://www.wikidata.org/entity/Q28266170',
    'http://www.wikidata.org/entity/Q28266175',
    'http://www.wikidata.org/entity/Q28266179',
    'http://www.wikidata.org/entity/Q28266193',
    'http://www.wikidata.org/entity/Q28266228',
    'http://www.wikidata.org/entity/Q28266250',
    'http://www.wikidata.org/entity/Q28266311',
    'http://www.wikidata.org/entity/Q28266324',
    'http://www.wikidata.org/entity/Q28266358',
    'http://www.wikidata.org/entity/Q28266417',
    'http://www.wikidata.org/entity/Q28266437',
    'http://www.wikidata.org/entity/Q28266446',
    'http://www.wikidata.org/entity/Q28266637',
    'http://www.wikidata.org/entity/Q28266658',
    'http://www.wikidata.org/entity/Q28266682',
    'http://www.wikidata.org/entity/Q28266830',
    'http://www.wikidata.org/entity/Q28266862',
    'http://www.wikidata.org/entity/Q28266863',
    'http://www.wikidata.org/entity/Q28266933',
    'http://www.wikidata.org/entity/Q28266995',
    'http://www.wikidata.org/entity/Q28267023',
    'http://www.wikidata.org/entity/Q28267062',
    'http://www.wikidata.org/entity/Q28267072',
    'http://www.wikidata.org/entity/Q28267083',
    'http://www.wikidata.org/entity/Q28267117',
    'http://www.wikidata.org/entity/Q28267194',
    'http://www.wikidata.org/entity/Q28267220',
    'http://www.wikidata.org/entity/Q28267229',
    'http://www.wikidata.org/entity/Q28267244',
    'http://www.wikidata.org/entity/Q28267254',
    'http://www.wikidata.org/entity/Q28267259',
    'http://www.wikidata.org/entity/Q28267295',
    'http://www.wikidata.org/entity/Q28267300',
    'http://www.wikidata.org/entity/Q28267385',
    'http://www.wikidata.org/entity/Q28267397',
    'http://www.wikidata.org/entity/Q28267425',
    'http://www.wikidata.org/entity/Q28267444',
    'http://www.wikidata.org/entity/Q28267447',
    'http://www.wikidata.org/entity/Q28267457',
    'http://www.wikidata.org/entity/Q28267497',
    'http://www.wikidata.org/entity/Q28267499',
    'http://www.wikidata.org/entity/Q28267500',
    'http://www.wikidata.org/entity/Q28267544',
    'http://www.wikidata.org/entity/Q28267545',
    'http://www.wikidata.org/entity/Q28267577',
    'http://www.wikidata.org/entity/Q28267580',
    'http://www.wikidata.org/entity/Q28267626',
    'http://www.wikidata.org/entity/Q28267700',
    'http://www.wikidata.org/entity/Q28267713',
    'http://www.wikidata.org/entity/Q28267721',
    'http://www.wikidata.org/entity/Q28267753',
    'http://www.wikidata.org/entity/Q28267764',
    'http://www.wikidata.org/entity/Q28267772',
    'http://www.wikidata.org/entity/Q28267807',
    'http://www.wikidata.org/entity/Q28267829',
    'http://www.wikidata.org/entity/Q28267865',
    'http://www.wikidata.org/entity/Q28267877',
    'http://www.wikidata.org/entity/Q28267878',
    'http://www.wikidata.org/entity/Q28267900',
    'http://www.wikidata.org/entity/Q28267921',
    'http://www.wikidata.org/entity/Q28267929',
    'http://www.wikidata.org/entity/Q28267939',
    'http://www.wikidata.org/entity/Q28267991',
    'http://www.wikidata.org/entity/Q28268014',
    'http://www.wikidata.org/entity/Q28268048',
    'http://www.wikidata.org/entity/Q28268052',
    'http://www.wikidata.org/entity/Q28268061',
    'http://www.wikidata.org/entity/Q28268076',
    'http://www.wikidata.org/entity/Q28268084',
    'http://www.wikidata.org/entity/Q28268088',
    'http://www.wikidata.org/entity/Q28268180',
    'http://www.wikidata.org/entity/Q28268208',
    'http://www.wikidata.org/entity/Q28268248',
    'http://www.wikidata.org/entity/Q28268329',
    'http://www.wikidata.org/entity/Q28268399',
    'http://www.wikidata.org/entity/Q28268502',
    'http://www.wikidata.org/entity/Q28268592',
    'http://www.wikidata.org/entity/Q28268626',
    'http://www.wikidata.org/entity/Q28268636',
    'http://www.wikidata.org/entity/Q28268807',
    'http://www.wikidata.org/entity/Q28268818',
    'http://www.wikidata.org/entity/Q28268831',
    'http://www.wikidata.org/entity/Q28268847',
    'http://www.wikidata.org/entity/Q28268881',
    'http://www.wikidata.org/entity/Q28268884',
    'http://www.wikidata.org/entity/Q28268899',
    'http://www.wikidata.org/entity/Q28268902',
    'http://www.wikidata.org/entity/Q28268930',
    'http://www.wikidata.org/entity/Q28268984',
    'http://www.wikidata.org/entity/Q28269082',
    'http://www.wikidata.org/entity/Q28269086',
    'http://www.wikidata.org/entity/Q28269089',
    'http://www.wikidata.org/entity/Q28269158',
    'http://www.wikidata.org/entity/Q28269187',
    'http://www.wikidata.org/entity/Q28269300',
    'http://www.wikidata.org/entity/Q28269322',
    'http://www.wikidata.org/entity/Q28269333',
    'http://www.wikidata.org/entity/Q28269343',
    'http://www.wikidata.org/entity/Q28269350',
    'http://www.wikidata.org/entity/Q28269379',
    'http://www.wikidata.org/entity/Q28269394',
    'http://www.wikidata.org/entity/Q28269528',
    'http://www.wikidata.org/entity/Q28269561',
    'http://www.wikidata.org/entity/Q28269583',
    'http://www.wikidata.org/entity/Q28269589',
    'http://www.wikidata.org/entity/Q28269611',
    'http://www.wikidata.org/entity/Q28269663',
    'http://www.wikidata.org/entity/Q28269708',
    'http://www.wikidata.org/entity/Q28269714',
    'http://www.wikidata.org/entity/Q28269717',
    'http://www.wikidata.org/entity/Q28269751',
    'http://www.wikidata.org/entity/Q28269762',
    'http://www.wikidata.org/entity/Q28269786',
    'http://www.wikidata.org/entity/Q28269827',
    'http://www.wikidata.org/entity/Q28269846',
    'http://www.wikidata.org/entity/Q28269894',
    'http://www.wikidata.org/entity/Q28269961',
    'http://www.wikidata.org/entity/Q28269989',
    'http://www.wikidata.org/entity/Q28270032',
    'http://www.wikidata.org/entity/Q28270111',
    'http://www.wikidata.org/entity/Q28270155',
    'http://www.wikidata.org/entity/Q28270163',
    'http://www.wikidata.org/entity/Q28270237',
    'http://www.wikidata.org/entity/Q28270244',
    'http://www.wikidata.org/entity/Q28270252',
    'http://www.wikidata.org/entity/Q28270307',
    'http://www.wikidata.org/entity/Q28270336',
    'http://www.wikidata.org/entity/Q28270341',
    'http://www.wikidata.org/entity/Q28270473',
    'http://www.wikidata.org/entity/Q28270478',
    'http://www.wikidata.org/entity/Q28270481',
    'http://www.wikidata.org/entity/Q28270512',
    'http://www.wikidata.org/entity/Q28270550',
    'http://www.wikidata.org/entity/Q28270553',
    'http://www.wikidata.org/entity/Q28270603',
    'http://www.wikidata.org/entity/Q28270614',
    'http://www.wikidata.org/entity/Q28270638',
    'http://www.wikidata.org/entity/Q28270657',
    'http://www.wikidata.org/entity/Q28270671',
    'http://www.wikidata.org/entity/Q28270680',
    'http://www.wikidata.org/entity/Q28270700',
    'http://www.wikidata.org/entity/Q28270779',
    'http://www.wikidata.org/entity/Q28270788',
    'http://www.wikidata.org/entity/Q28270799',
    'http://www.wikidata.org/entity/Q28270868',
    'http://www.wikidata.org/entity/Q28270924',
    'http://www.wikidata.org/entity/Q28270933',
    'http://www.wikidata.org/entity/Q28270975',
    'http://www.wikidata.org/entity/Q28270979',
    'http://www.wikidata.org/entity/Q28270998',
    'http://www.wikidata.org/entity/Q28271008',
    'http://www.wikidata.org/entity/Q28271018',
    'http://www.wikidata.org/entity/Q28271022',
    'http://www.wikidata.org/entity/Q28271032',
    'http://www.wikidata.org/entity/Q28271108',
    'http://www.wikidata.org/entity/Q28271119',
    'http://www.wikidata.org/entity/Q28271140',
    'http://www.wikidata.org/entity/Q28271167',
    'http://www.wikidata.org/entity/Q28271211',
    'http://www.wikidata.org/entity/Q28271235',
    'http://www.wikidata.org/entity/Q28271255',
    'http://www.wikidata.org/entity/Q28271256',
    'http://www.wikidata.org/entity/Q28271274',
    'http://www.wikidata.org/entity/Q28271283',
    'http://www.wikidata.org/entity/Q28271291',
    'http://www.wikidata.org/entity/Q28271313',
    'http://www.wikidata.org/entity/Q28271324',
    'http://www.wikidata.org/entity/Q28271344',
    'http://www.wikidata.org/entity/Q28271379',
    'http://www.wikidata.org/entity/Q28271409',
    'http://www.wikidata.org/entity/Q28271419',
    'http://www.wikidata.org/entity/Q28271422',
    'http://www.wikidata.org/entity/Q28271433',
    'http://www.wikidata.org/entity/Q28271470',
    'http://www.wikidata.org/entity/Q28271546',
    'http://www.wikidata.org/entity/Q28271559',
    'http://www.wikidata.org/entity/Q28271571',
    'http://www.wikidata.org/entity/Q28271647',
    'http://www.wikidata.org/entity/Q28271669',
    'http://www.wikidata.org/entity/Q28271670',
    'http://www.wikidata.org/entity/Q28271671',
    'http://www.wikidata.org/entity/Q28271805',
    'http://www.wikidata.org/entity/Q28271877',
    'http://www.wikidata.org/entity/Q28271899',
    'http://www.wikidata.org/entity/Q28271912',
    'http://www.wikidata.org/entity/Q28271947',
    'http://www.wikidata.org/entity/Q28271985',
    'http://www.wikidata.org/entity/Q28271998',
    'http://www.wikidata.org/entity/Q28272011',
    'http://www.wikidata.org/entity/Q28272062',
    'http://www.wikidata.org/entity/Q28272293',
    'http://www.wikidata.org/entity/Q28272313',
    'http://www.wikidata.org/entity/Q28272330',
    'http://www.wikidata.org/entity/Q28272340',
    'http://www.wikidata.org/entity/Q28272350',
    'http://www.wikidata.org/entity/Q28272367',
    'http://www.wikidata.org/entity/Q28272379',
    'http://www.wikidata.org/entity/Q28272380',
    'http://www.wikidata.org/entity/Q28272474',
    'http://www.wikidata.org/entity/Q28272481',
    'http://www.wikidata.org/entity/Q28272505',
    'http://www.wikidata.org/entity/Q28272533',
    'http://www.wikidata.org/entity/Q28272545',
    'http://www.wikidata.org/entity/Q28272546',
    'http://www.wikidata.org/entity/Q28272621',
    'http://www.wikidata.org/entity/Q28272728',
    'http://www.wikidata.org/entity/Q28272772',
    'http://www.wikidata.org/entity/Q28272777',
    'http://www.wikidata.org/entity/Q28272817',
    'http://www.wikidata.org/entity/Q28272888',
    'http://www.wikidata.org/entity/Q28272890',
    'http://www.wikidata.org/entity/Q28272915',
    'http://www.wikidata.org/entity/Q28272940',
    'http://www.wikidata.org/entity/Q28273024',
    'http://www.wikidata.org/entity/Q28273046',
    'http://www.wikidata.org/entity/Q28273052',
    'http://www.wikidata.org/entity/Q28273134',
    'http://www.wikidata.org/entity/Q28273164',
    'http://www.wikidata.org/entity/Q28273182',
    'http://www.wikidata.org/entity/Q28273219',
    'http://www.wikidata.org/entity/Q28273268',
    'http://www.wikidata.org/entity/Q28273335',
    'http://www.wikidata.org/entity/Q28273478',
    'http://www.wikidata.org/entity/Q28273481',
    'http://www.wikidata.org/entity/Q28273485',
    'http://www.wikidata.org/entity/Q28273492',
    'http://www.wikidata.org/entity/Q28273497',
    'http://www.wikidata.org/entity/Q28273526',
    'http://www.wikidata.org/entity/Q28273539',
    'http://www.wikidata.org/entity/Q28273545',
    'http://www.wikidata.org/entity/Q28273549',
    'http://www.wikidata.org/entity/Q28273600',
    'http://www.wikidata.org/entity/Q28273657',
    'http://www.wikidata.org/entity/Q28273690',
    'http://www.wikidata.org/entity/Q28273716',
    'http://www.wikidata.org/entity/Q28273726',
    'http://www.wikidata.org/entity/Q28273764',
    'http://www.wikidata.org/entity/Q28273769',
    'http://www.wikidata.org/entity/Q28273791',
    'http://www.wikidata.org/entity/Q28273794',
    'http://www.wikidata.org/entity/Q28273842',
    'http://www.wikidata.org/entity/Q28273919',
    'http://www.wikidata.org/entity/Q28273937',
    'http://www.wikidata.org/entity/Q28273955',
    'http://www.wikidata.org/entity/Q28273977',
    'http://www.wikidata.org/entity/Q28274000',
    'http://www.wikidata.org/entity/Q28274009',
    'http://www.wikidata.org/entity/Q28274012',
    'http://www.wikidata.org/entity/Q28274024',
    'http://www.wikidata.org/entity/Q28274063',
    'http://www.wikidata.org/entity/Q28274064',
    'http://www.wikidata.org/entity/Q28274089',
    'http://www.wikidata.org/entity/Q28274091',
    'http://www.wikidata.org/entity/Q28274123',
    'http://www.wikidata.org/entity/Q28274172',
    'http://www.wikidata.org/entity/Q28274188',
    'http://www.wikidata.org/entity/Q28274239',
    'http://www.wikidata.org/entity/Q28274262',
    'http://www.wikidata.org/entity/Q28274269',
    'http://www.wikidata.org/entity/Q28274279',
    'http://www.wikidata.org/entity/Q28274307',
    'http://www.wikidata.org/entity/Q28274312',
    'http://www.wikidata.org/entity/Q28274321',
    'http://www.wikidata.org/entity/Q28274344',
    'http://www.wikidata.org/entity/Q28274352',
    'http://www.wikidata.org/entity/Q28274375',
    'http://www.wikidata.org/entity/Q28274387',
    'http://www.wikidata.org/entity/Q28274429',
    'http://www.wikidata.org/entity/Q28274448',
    'http://www.wikidata.org/entity/Q28274454',
    'http://www.wikidata.org/entity/Q28274481',
    'http://www.wikidata.org/entity/Q28274500',
    'http://www.wikidata.org/entity/Q28274520',
    'http://www.wikidata.org/entity/Q28274559',
    'http://www.wikidata.org/entity/Q28274603',
    'http://www.wikidata.org/entity/Q28274610',
    'http://www.wikidata.org/entity/Q28274621',
    'http://www.wikidata.org/entity/Q28274647',
    'http://www.wikidata.org/entity/Q28274651',
    'http://www.wikidata.org/entity/Q28274666',
    'http://www.wikidata.org/entity/Q28274676',
    'http://www.wikidata.org/entity/Q28274682',
    'http://www.wikidata.org/entity/Q28274687',
    'http://www.wikidata.org/entity/Q28274698',
    'http://www.wikidata.org/entity/Q28274701',
    'http://www.wikidata.org/entity/Q28274751',
    'http://www.wikidata.org/entity/Q28274764',
    'http://www.wikidata.org/entity/Q28274778',
    'http://www.wikidata.org/entity/Q28274786',
    'http://www.wikidata.org/entity/Q28274796',
    'http://www.wikidata.org/entity/Q28274810',
    'http://www.wikidata.org/entity/Q28274848',
    'http://www.wikidata.org/entity/Q28274937',
    'http://www.wikidata.org/entity/Q28274950',
    'http://www.wikidata.org/entity/Q28274959',
    'http://www.wikidata.org/entity/Q28275010',
    'http://www.wikidata.org/entity/Q28275011',
    'http://www.wikidata.org/entity/Q28275021',
    'http://www.wikidata.org/entity/Q28275029',
    'http://www.wikidata.org/entity/Q28275042',
    'http://www.wikidata.org/entity/Q28275089',
    'http://www.wikidata.org/entity/Q28275103',
    'http://www.wikidata.org/entity/Q28275174',
    'http://www.wikidata.org/entity/Q28275206',
    'http://www.wikidata.org/entity/Q28275220',
    'http://www.wikidata.org/entity/Q28275237',
    'http://www.wikidata.org/entity/Q28275246',
    'http://www.wikidata.org/entity/Q28275257',
    'http://www.wikidata.org/entity/Q28275268',
    'http://www.wikidata.org/entity/Q28275277',
    'http://www.wikidata.org/entity/Q28275278',
    'http://www.wikidata.org/entity/Q28275343',
    'http://www.wikidata.org/entity/Q28275348',
    'http://www.wikidata.org/entity/Q28275399',
    'http://www.wikidata.org/entity/Q28275410',
    'http://www.wikidata.org/entity/Q28275478',
    'http://www.wikidata.org/entity/Q28275504',
    'http://www.wikidata.org/entity/Q28275527',
    'http://www.wikidata.org/entity/Q28275622',
    'http://www.wikidata.org/entity/Q28275663',
    'http://www.wikidata.org/entity/Q28275678',
    'http://www.wikidata.org/entity/Q28275699',
    'http://www.wikidata.org/entity/Q28275730',
    'http://www.wikidata.org/entity/Q28275735',
    'http://www.wikidata.org/entity/Q28275749',
    'http://www.wikidata.org/entity/Q28275792',
    'http://www.wikidata.org/entity/Q28275839',
    'http://www.wikidata.org/entity/Q28275844',
    'http://www.wikidata.org/entity/Q28275885',
    'http://www.wikidata.org/entity/Q28275907',
    'http://www.wikidata.org/entity/Q28275929',
    'http://www.wikidata.org/entity/Q28275931',
    'http://www.wikidata.org/entity/Q28275946',
    'http://www.wikidata.org/entity/Q28275966',
    'http://www.wikidata.org/entity/Q28275978',
    'http://www.wikidata.org/entity/Q28276029',
    'http://www.wikidata.org/entity/Q28276063',
    'http://www.wikidata.org/entity/Q28276069',
    'http://www.wikidata.org/entity/Q28276146',
    'http://www.wikidata.org/entity/Q28276159',
    'http://www.wikidata.org/entity/Q28276183',
    'http://www.wikidata.org/entity/Q28276184',
    'http://www.wikidata.org/entity/Q28276199',
    'http://www.wikidata.org/entity/Q28276215',
    'http://www.wikidata.org/entity/Q28276247',
    'http://www.wikidata.org/entity/Q28276310',
    'http://www.wikidata.org/entity/Q28276335',
    'http://www.wikidata.org/entity/Q28276337',
    'http://www.wikidata.org/entity/Q28276397',
    'http://www.wikidata.org/entity/Q28276443',
    'http://www.wikidata.org/entity/Q28276447',
    'http://www.wikidata.org/entity/Q28276449',
    'http://www.wikidata.org/entity/Q28276454',
    'http://www.wikidata.org/entity/Q28276470',
    'http://www.wikidata.org/entity/Q28276506',
    'http://www.wikidata.org/entity/Q28276534',
    'http://www.wikidata.org/entity/Q28276538',
    'http://www.wikidata.org/entity/Q28276549',
    'http://www.wikidata.org/entity/Q28276567',
    'http://www.wikidata.org/entity/Q28276573',
    'http://www.wikidata.org/entity/Q28276589',
    'http://www.wikidata.org/entity/Q28276660',
    'http://www.wikidata.org/entity/Q28276671',
    'http://www.wikidata.org/entity/Q28276788',
    'http://www.wikidata.org/entity/Q28276801',
    'http://www.wikidata.org/entity/Q28276828',
    'http://www.wikidata.org/entity/Q28276850',
    'http://www.wikidata.org/entity/Q28276888',
    'http://www.wikidata.org/entity/Q28276961',
    'http://www.wikidata.org/entity/Q28276972',
    'http://www.wikidata.org/entity/Q28276992',
    'http://www.wikidata.org/entity/Q28277011',
    'http://www.wikidata.org/entity/Q28277014',
    'http://www.wikidata.org/entity/Q28277030',
    'http://www.wikidata.org/entity/Q28277124',
    'http://www.wikidata.org/entity/Q28277156',
    'http://www.wikidata.org/entity/Q28277182',
    'http://www.wikidata.org/entity/Q28277183',
    'http://www.wikidata.org/entity/Q28277205',
    'http://www.wikidata.org/entity/Q28277215',
    'http://www.wikidata.org/entity/Q28277258',
    'http://www.wikidata.org/entity/Q28277266',
    'http://www.wikidata.org/entity/Q28277346',
    'http://www.wikidata.org/entity/Q28277359',
    'http://www.wikidata.org/entity/Q28277365',
    'http://www.wikidata.org/entity/Q28277373',
    'http://www.wikidata.org/entity/Q28277400',
    'http://www.wikidata.org/entity/Q28277407',
    'http://www.wikidata.org/entity/Q28277482',
    'http://www.wikidata.org/entity/Q28277486',
    'http://www.wikidata.org/entity/Q28277489',
    'http://www.wikidata.org/entity/Q28277490',
    'http://www.wikidata.org/entity/Q28277510',
    'http://www.wikidata.org/entity/Q28277565',
    'http://www.wikidata.org/entity/Q28277578',
    'http://www.wikidata.org/entity/Q28277644',
    'http://www.wikidata.org/entity/Q28277704',
    'http://www.wikidata.org/entity/Q28277707',
    'http://www.wikidata.org/entity/Q28277749',
    'http://www.wikidata.org/entity/Q28277799',
    'http://www.wikidata.org/entity/Q28277824',
    'http://www.wikidata.org/entity/Q28277903',
    'http://www.wikidata.org/entity/Q28277921',
    'http://www.wikidata.org/entity/Q28277946',
    'http://www.wikidata.org/entity/Q28277961',
    'http://www.wikidata.org/entity/Q28277981',
    'http://www.wikidata.org/entity/Q28278037',
    'http://www.wikidata.org/entity/Q28278104',
    'http://www.wikidata.org/entity/Q28278166',
    'http://www.wikidata.org/entity/Q28278192',
    'http://www.wikidata.org/entity/Q28278296',
    'http://www.wikidata.org/entity/Q28278305',
    'http://www.wikidata.org/entity/Q28278334',
    'http://www.wikidata.org/entity/Q28278349',
    'http://www.wikidata.org/entity/Q28278448',
    'http://www.wikidata.org/entity/Q28278496',
    'http://www.wikidata.org/entity/Q28278500',
    'http://www.wikidata.org/entity/Q28278502',
    'http://www.wikidata.org/entity/Q28278561',
    'http://www.wikidata.org/entity/Q28278620',
    'http://www.wikidata.org/entity/Q28278645',
    'http://www.wikidata.org/entity/Q28278673',
    'http://www.wikidata.org/entity/Q28278682',
    'http://www.wikidata.org/entity/Q28278736',
    'http://www.wikidata.org/entity/Q28278739',
    'http://www.wikidata.org/entity/Q28278745',
    'http://www.wikidata.org/entity/Q28278747',
    'http://www.wikidata.org/entity/Q28278758',
    'http://www.wikidata.org/entity/Q28278789',
    'http://www.wikidata.org/entity/Q28278826',
    'http://www.wikidata.org/entity/Q28278852',
    'http://www.wikidata.org/entity/Q28278893',
    'http://www.wikidata.org/entity/Q28278902',
    'http://www.wikidata.org/entity/Q28278977',
    'http://www.wikidata.org/entity/Q28279053',
    'http://www.wikidata.org/entity/Q28279069',
    'http://www.wikidata.org/entity/Q28279096',
    'http://www.wikidata.org/entity/Q28279138',
    'http://www.wikidata.org/entity/Q28279141',
    'http://www.wikidata.org/entity/Q28279214',
    'http://www.wikidata.org/entity/Q28279229',
    'http://www.wikidata.org/entity/Q28279245',
    'http://www.wikidata.org/entity/Q28279276',
    'http://www.wikidata.org/entity/Q28279277',
    'http://www.wikidata.org/entity/Q28279403',
    'http://www.wikidata.org/entity/Q28279406',
    'http://www.wikidata.org/entity/Q28279421',
    'http://www.wikidata.org/entity/Q28279437',
    'http://www.wikidata.org/entity/Q28279450',
    'http://www.wikidata.org/entity/Q28279457',
    'http://www.wikidata.org/entity/Q28279460',
    'http://www.wikidata.org/entity/Q28279487',
    'http://www.wikidata.org/entity/Q28279527',
    'http://www.wikidata.org/entity/Q28279558',
    'http://www.wikidata.org/entity/Q28279570',
    'http://www.wikidata.org/entity/Q28279619',
    'http://www.wikidata.org/entity/Q28279671',
    'http://www.wikidata.org/entity/Q28279673',
    'http://www.wikidata.org/entity/Q28279719',
    'http://www.wikidata.org/entity/Q28279786',
    'http://www.wikidata.org/entity/Q28279924',
    'http://www.wikidata.org/entity/Q28279933',
    'http://www.wikidata.org/entity/Q28279936',
    'http://www.wikidata.org/entity/Q28279955',
    'http://www.wikidata.org/entity/Q28279959',
    'http://www.wikidata.org/entity/Q28279970',
    'http://www.wikidata.org/entity/Q28279993',
    'http://www.wikidata.org/entity/Q28280017',
    'http://www.wikidata.org/entity/Q28280022',
    'http://www.wikidata.org/entity/Q28280037',
    'http://www.wikidata.org/entity/Q28280058',
    'http://www.wikidata.org/entity/Q28280069',
    'http://www.wikidata.org/entity/Q28280072',
    'http://www.wikidata.org/entity/Q28280099',
    'http://www.wikidata.org/entity/Q28280100',
    'http://www.wikidata.org/entity/Q28280109',
    'http://www.wikidata.org/entity/Q28280228',
    'http://www.wikidata.org/entity/Q28280234',
    'http://www.wikidata.org/entity/Q28280242',
    'http://www.wikidata.org/entity/Q28280246',
    'http://www.wikidata.org/entity/Q28280251',
    'http://www.wikidata.org/entity/Q28280270',
    'http://www.wikidata.org/entity/Q28280302',
    'http://www.wikidata.org/entity/Q28280337',
    'http://www.wikidata.org/entity/Q28280353',
    'http://www.wikidata.org/entity/Q28280357',
    'http://www.wikidata.org/entity/Q28280359',
    'http://www.wikidata.org/entity/Q28280375',
    'http://www.wikidata.org/entity/Q28280379',
    'http://www.wikidata.org/entity/Q28280381',
    'http://www.wikidata.org/entity/Q28280404',
    'http://www.wikidata.org/entity/Q28280424',
    'http://www.wikidata.org/entity/Q28280427',
    'http://www.wikidata.org/entity/Q28280438',
    'http://www.wikidata.org/entity/Q28280445',
    'http://www.wikidata.org/entity/Q28280465',
    'http://www.wikidata.org/entity/Q28280494',
    'http://www.wikidata.org/entity/Q28280503',
    'http://www.wikidata.org/entity/Q28280603',
    'http://www.wikidata.org/entity/Q28280639',
    'http://www.wikidata.org/entity/Q28280647',
    'http://www.wikidata.org/entity/Q28280649',
    'http://www.wikidata.org/entity/Q28280659',
    'http://www.wikidata.org/entity/Q28280674',
    'http://www.wikidata.org/entity/Q28280693',
    'http://www.wikidata.org/entity/Q28280706',
    'http://www.wikidata.org/entity/Q28280767',
    'http://www.wikidata.org/entity/Q28280777',
    'http://www.wikidata.org/entity/Q28280842',
    'http://www.wikidata.org/entity/Q28280850',
    'http://www.wikidata.org/entity/Q28280888',
    'http://www.wikidata.org/entity/Q28280897',
    'http://www.wikidata.org/entity/Q28280906',
    'http://www.wikidata.org/entity/Q28280921',
    'http://www.wikidata.org/entity/Q28280923',
    'http://www.wikidata.org/entity/Q28280946',
    'http://www.wikidata.org/entity/Q28280957',
    'http://www.wikidata.org/entity/Q28280958',
    'http://www.wikidata.org/entity/Q28280965',
    'http://www.wikidata.org/entity/Q28281029',
    'http://www.wikidata.org/entity/Q28281056',
    'http://www.wikidata.org/entity/Q28281109',
    'http://www.wikidata.org/entity/Q28281112',
    'http://www.wikidata.org/entity/Q28281118',
    'http://www.wikidata.org/entity/Q28281142',
    'http://www.wikidata.org/entity/Q28281179',
    'http://www.wikidata.org/entity/Q28281200',
    'http://www.wikidata.org/entity/Q28281214',
    'http://www.wikidata.org/entity/Q28281328',
    'http://www.wikidata.org/entity/Q28281455',
    'http://www.wikidata.org/entity/Q28281500',
    'http://www.wikidata.org/entity/Q28281516',
    'http://www.wikidata.org/entity/Q28281570',
    'http://www.wikidata.org/entity/Q28281588',
    'http://www.wikidata.org/entity/Q28281590',
    'http://www.wikidata.org/entity/Q28281610',
    'http://www.wikidata.org/entity/Q28281645',
    'http://www.wikidata.org/entity/Q28281653',
    'http://www.wikidata.org/entity/Q28281662',
    'http://www.wikidata.org/entity/Q28281673',
    'http://www.wikidata.org/entity/Q28281686',
    'http://www.wikidata.org/entity/Q28281738',
    'http://www.wikidata.org/entity/Q28281749',
    'http://www.wikidata.org/entity/Q28281802',
    'http://www.wikidata.org/entity/Q28281870',
    'http://www.wikidata.org/entity/Q28281904',
    'http://www.wikidata.org/entity/Q28281905',
    'http://www.wikidata.org/entity/Q28281906',
    'http://www.wikidata.org/entity/Q28281932',
    'http://www.wikidata.org/entity/Q28281942',
    'http://www.wikidata.org/entity/Q28281952',
    'http://www.wikidata.org/entity/Q28282047',
    'http://www.wikidata.org/entity/Q28282094',
    'http://www.wikidata.org/entity/Q28282162',
    'http://www.wikidata.org/entity/Q28282227',
    'http://www.wikidata.org/entity/Q28282231',
    'http://www.wikidata.org/entity/Q28282250',
    'http://www.wikidata.org/entity/Q28282255',
    'http://www.wikidata.org/entity/Q28282268',
    'http://www.wikidata.org/entity/Q28282295',
    'http://www.wikidata.org/entity/Q28282369',
    'http://www.wikidata.org/entity/Q28282386',
    'http://www.wikidata.org/entity/Q28282412',
    'http://www.wikidata.org/entity/Q28282418',
    'http://www.wikidata.org/entity/Q28282424',
    'http://www.wikidata.org/entity/Q28282435',
    'http://www.wikidata.org/entity/Q28282444',
    'http://www.wikidata.org/entity/Q28282446',
    'http://www.wikidata.org/entity/Q28282463',
    'http://www.wikidata.org/entity/Q28282470',
    'http://www.wikidata.org/entity/Q28282519',
    'http://www.wikidata.org/entity/Q28282528',
    'http://www.wikidata.org/entity/Q28282539',
    'http://www.wikidata.org/entity/Q28282560',
    'http://www.wikidata.org/entity/Q28282572',
    'http://www.wikidata.org/entity/Q28282629',
    'http://www.wikidata.org/entity/Q28282675',
    'http://www.wikidata.org/entity/Q28282741',
    'http://www.wikidata.org/entity/Q28282750',
    'http://www.wikidata.org/entity/Q28282757',
    'http://www.wikidata.org/entity/Q28282767',
    'http://www.wikidata.org/entity/Q28282773',
    'http://www.wikidata.org/entity/Q28282776',
    'http://www.wikidata.org/entity/Q28282777',
    'http://www.wikidata.org/entity/Q28282813',
    'http://www.wikidata.org/entity/Q28282823',
    'http://www.wikidata.org/entity/Q28282826',
    'http://www.wikidata.org/entity/Q28282844',
    'http://www.wikidata.org/entity/Q28282845',
    'http://www.wikidata.org/entity/Q28282855',
    'http://www.wikidata.org/entity/Q28282895',
    'http://www.wikidata.org/entity/Q28282944',
    'http://www.wikidata.org/entity/Q28282959',
    'http://www.wikidata.org/entity/Q28283016',
    'http://www.wikidata.org/entity/Q28283062',
    'http://www.wikidata.org/entity/Q28283082',
    'http://www.wikidata.org/entity/Q28283086',
    'http://www.wikidata.org/entity/Q28283087',
    'http://www.wikidata.org/entity/Q28283104',
    'http://www.wikidata.org/entity/Q28283217',
    'http://www.wikidata.org/entity/Q28283294',
    'http://www.wikidata.org/entity/Q28283313',
    'http://www.wikidata.org/entity/Q28283317',
    'http://www.wikidata.org/entity/Q28283322',
    'http://www.wikidata.org/entity/Q28283323',
    'http://www.wikidata.org/entity/Q28283330',
    'http://www.wikidata.org/entity/Q28283333',
    'http://www.wikidata.org/entity/Q28283339',
    'http://www.wikidata.org/entity/Q28283389',
    'http://www.wikidata.org/entity/Q28283398',
    'http://www.wikidata.org/entity/Q28283430',
    'http://www.wikidata.org/entity/Q28283469',
    'http://www.wikidata.org/entity/Q28283499',
    'http://www.wikidata.org/entity/Q28283517',
    'http://www.wikidata.org/entity/Q28283549',
    'http://www.wikidata.org/entity/Q28283580',
    'http://www.wikidata.org/entity/Q28283615',
    'http://www.wikidata.org/entity/Q28283637',
    'http://www.wikidata.org/entity/Q28283679',
    'http://www.wikidata.org/entity/Q28283698',
    'http://www.wikidata.org/entity/Q28283776',
    'http://www.wikidata.org/entity/Q28283780',
    'http://www.wikidata.org/entity/Q28283786',
    'http://www.wikidata.org/entity/Q28283805',
    'http://www.wikidata.org/entity/Q28283814',
    'http://www.wikidata.org/entity/Q28283850',
    'http://www.wikidata.org/entity/Q28283860',
    'http://www.wikidata.org/entity/Q28283898',
    'http://www.wikidata.org/entity/Q28283928',
    'http://www.wikidata.org/entity/Q28283938',
    'http://www.wikidata.org/entity/Q28283941',
    'http://www.wikidata.org/entity/Q28283948',
    'http://www.wikidata.org/entity/Q28284032',
    'http://www.wikidata.org/entity/Q28284054',
    'http://www.wikidata.org/entity/Q28284074',
    'http://www.wikidata.org/entity/Q28284096',
    'http://www.wikidata.org/entity/Q28284165',
    'http://www.wikidata.org/entity/Q28284176',
    'http://www.wikidata.org/entity/Q28284177',
    'http://www.wikidata.org/entity/Q28284190',
    'http://www.wikidata.org/entity/Q28284204',
    'http://www.wikidata.org/entity/Q28284253',
    'http://www.wikidata.org/entity/Q28284276',
    'http://www.wikidata.org/entity/Q28284300',
    'http://www.wikidata.org/entity/Q28284355',
    'http://www.wikidata.org/entity/Q28284428',
    'http://www.wikidata.org/entity/Q28284436',
    'http://www.wikidata.org/entity/Q28284459',
    'http://www.wikidata.org/entity/Q28284509',
    'http://www.wikidata.org/entity/Q28284588',
    'http://www.wikidata.org/entity/Q28284645',
    'http://www.wikidata.org/entity/Q28284652',
    'http://www.wikidata.org/entity/Q28284699',
    'http://www.wikidata.org/entity/Q28284717',
    'http://www.wikidata.org/entity/Q28284721',
    'http://www.wikidata.org/entity/Q28284744',
    'http://www.wikidata.org/entity/Q28284755',
    'http://www.wikidata.org/entity/Q28284775',
    'http://www.wikidata.org/entity/Q28284820',
    'http://www.wikidata.org/entity/Q28284893',
    'http://www.wikidata.org/entity/Q28284902',
    'http://www.wikidata.org/entity/Q28284911',
    'http://www.wikidata.org/entity/Q28284944',
    'http://www.wikidata.org/entity/Q28284990',
    'http://www.wikidata.org/entity/Q28285027',
    'http://www.wikidata.org/entity/Q28285041',
    'http://www.wikidata.org/entity/Q28285066',
    'http://www.wikidata.org/entity/Q28285090',
    'http://www.wikidata.org/entity/Q28285094',
    'http://www.wikidata.org/entity/Q28285100',
    'http://www.wikidata.org/entity/Q28285105',
    'http://www.wikidata.org/entity/Q28285131',
    'http://www.wikidata.org/entity/Q28285140',
    'http://www.wikidata.org/entity/Q28285151',
    'http://www.wikidata.org/entity/Q28285162',
    'http://www.wikidata.org/entity/Q28285192',
    'http://www.wikidata.org/entity/Q28285200',
    'http://www.wikidata.org/entity/Q28285226',
    'http://www.wikidata.org/entity/Q28285286',
    'http://www.wikidata.org/entity/Q28285311',
    'http://www.wikidata.org/entity/Q28285334',
    'http://www.wikidata.org/entity/Q28285376',
    'http://www.wikidata.org/entity/Q28285397',
    'http://www.wikidata.org/entity/Q28285434',
    'http://www.wikidata.org/entity/Q28285437',
    'http://www.wikidata.org/entity/Q28285445',
    'http://www.wikidata.org/entity/Q28285467',
    'http://www.wikidata.org/entity/Q28285511',
    'http://www.wikidata.org/entity/Q28285612',
    'http://www.wikidata.org/entity/Q28285724',
    'http://www.wikidata.org/entity/Q28285743',
    'http://www.wikidata.org/entity/Q28285747',
    'http://www.wikidata.org/entity/Q28285750',
    'http://www.wikidata.org/entity/Q28285762',
    'http://www.wikidata.org/entity/Q28285796',
    'http://www.wikidata.org/entity/Q28285842',
    'http://www.wikidata.org/entity/Q28285876',
    'http://www.wikidata.org/entity/Q28285959',
    'http://www.wikidata.org/entity/Q28285965',
    'http://www.wikidata.org/entity/Q28285969',
    'http://www.wikidata.org/entity/Q28285993',
    'http://www.wikidata.org/entity/Q28286071',
    'http://www.wikidata.org/entity/Q28286102',
    'http://www.wikidata.org/entity/Q28286159',
    'http://www.wikidata.org/entity/Q28286161',
    'http://www.wikidata.org/entity/Q28286168',
    'http://www.wikidata.org/entity/Q28286203',
    'http://www.wikidata.org/entity/Q28286232',
    'http://www.wikidata.org/entity/Q28286240',
    'http://www.wikidata.org/entity/Q28286277',
    'http://www.wikidata.org/entity/Q28286390',
    'http://www.wikidata.org/entity/Q28286391',
    'http://www.wikidata.org/entity/Q28286419',
    'http://www.wikidata.org/entity/Q28286431',
    'http://www.wikidata.org/entity/Q28286437',
    'http://www.wikidata.org/entity/Q28286686',
    'http://www.wikidata.org/entity/Q28286690',
    'http://www.wikidata.org/entity/Q28286732',
    'http://www.wikidata.org/entity/Q28286743',
    'http://www.wikidata.org/entity/Q28286840',
    'http://www.wikidata.org/entity/Q28286857',
    'http://www.wikidata.org/entity/Q28286872',
    'http://www.wikidata.org/entity/Q28286874',
    'http://www.wikidata.org/entity/Q28286884',
    'http://www.wikidata.org/entity/Q28286936',
    'http://www.wikidata.org/entity/Q28286957',
    'http://www.wikidata.org/entity/Q28286967',
    'http://www.wikidata.org/entity/Q28286997',
    'http://www.wikidata.org/entity/Q28287034',
    'http://www.wikidata.org/entity/Q28287057',
    'http://www.wikidata.org/entity/Q28287093',
    'http://www.wikidata.org/entity/Q28287208',
    'http://www.wikidata.org/entity/Q28287313',
    'http://www.wikidata.org/entity/Q28287345',
    'http://www.wikidata.org/entity/Q28287373',
    'http://www.wikidata.org/entity/Q28287408',
    'http://www.wikidata.org/entity/Q28287436',
    'http://www.wikidata.org/entity/Q28287446',
    'http://www.wikidata.org/entity/Q28287540',
    'http://www.wikidata.org/entity/Q28287562',
    'http://www.wikidata.org/entity/Q28287610',
    'http://www.wikidata.org/entity/Q28287612',
    'http://www.wikidata.org/entity/Q28287619',
    'http://www.wikidata.org/entity/Q28287702',
    'http://www.wikidata.org/entity/Q28287727',
    'http://www.wikidata.org/entity/Q28287733',
    'http://www.wikidata.org/entity/Q28287736',
    'http://www.wikidata.org/entity/Q28287762',
    'http://www.wikidata.org/entity/Q28287764',
    'http://www.wikidata.org/entity/Q28287823',
    'http://www.wikidata.org/entity/Q28287824',
    'http://www.wikidata.org/entity/Q28287876',
    'http://www.wikidata.org/entity/Q28287974',
    'http://www.wikidata.org/entity/Q28287986',
    'http://www.wikidata.org/entity/Q28288003',
    'http://www.wikidata.org/entity/Q28288013',
    'http://www.wikidata.org/entity/Q28288018',
    'http://www.wikidata.org/entity/Q28288035',
    'http://www.wikidata.org/entity/Q28288068',
    'http://www.wikidata.org/entity/Q28288090',
    'http://www.wikidata.org/entity/Q28288117',
    'http://www.wikidata.org/entity/Q28288125',
    'http://www.wikidata.org/entity/Q28288177',
    'http://www.wikidata.org/entity/Q28288187',
    'http://www.wikidata.org/entity/Q28288196',
    'http://www.wikidata.org/entity/Q28288205',
    'http://www.wikidata.org/entity/Q28288206',
    'http://www.wikidata.org/entity/Q28288215',
    'http://www.wikidata.org/entity/Q28288245',
    'http://www.wikidata.org/entity/Q28288257',
    'http://www.wikidata.org/entity/Q28288328',
    'http://www.wikidata.org/entity/Q28288339',
    'http://www.wikidata.org/entity/Q28288354',
    'http://www.wikidata.org/entity/Q28288377',
    'http://www.wikidata.org/entity/Q28288380',
    'http://www.wikidata.org/entity/Q28288414',
    'http://www.wikidata.org/entity/Q28288431',
    'http://www.wikidata.org/entity/Q28288535',
    'http://www.wikidata.org/entity/Q28288542',
    'http://www.wikidata.org/entity/Q28288545',
    'http://www.wikidata.org/entity/Q28288602',
    'http://www.wikidata.org/entity/Q28288607',
    'http://www.wikidata.org/entity/Q28288683',
    'http://www.wikidata.org/entity/Q28288692',
    'http://www.wikidata.org/entity/Q28288693',
    'http://www.wikidata.org/entity/Q28288705',
    'http://www.wikidata.org/entity/Q28288734',
    'http://www.wikidata.org/entity/Q28288766',
    'http://www.wikidata.org/entity/Q28288783',
    'http://www.wikidata.org/entity/Q28288806',
    'http://www.wikidata.org/entity/Q28288841',
    'http://www.wikidata.org/entity/Q28288846',
    'http://www.wikidata.org/entity/Q28288866',
    'http://www.wikidata.org/entity/Q28288886',
    'http://www.wikidata.org/entity/Q28288892',
    'http://www.wikidata.org/entity/Q28288904',
    'http://www.wikidata.org/entity/Q28288914',
    'http://www.wikidata.org/entity/Q28288970',
    'http://www.wikidata.org/entity/Q28288981',
    'http://www.wikidata.org/entity/Q28289114',
    'http://www.wikidata.org/entity/Q28289121',
    'http://www.wikidata.org/entity/Q28289222',
    'http://www.wikidata.org/entity/Q28289332',
    'http://www.wikidata.org/entity/Q28289337',
    'http://www.wikidata.org/entity/Q28289377',
    'http://www.wikidata.org/entity/Q28289386',
    'http://www.wikidata.org/entity/Q28289392',
    'http://www.wikidata.org/entity/Q28289395',
    'http://www.wikidata.org/entity/Q28289648',
    'http://www.wikidata.org/entity/Q28289683',
    'http://www.wikidata.org/entity/Q28289686',
    'http://www.wikidata.org/entity/Q28289699',
    'http://www.wikidata.org/entity/Q28289703',
    'http://www.wikidata.org/entity/Q28289720',
    'http://www.wikidata.org/entity/Q28289764',
    'http://www.wikidata.org/entity/Q28289832',
    'http://www.wikidata.org/entity/Q28289854',
    'http://www.wikidata.org/entity/Q28289864',
    'http://www.wikidata.org/entity/Q28289888',
    'http://www.wikidata.org/entity/Q28289896',
    'http://www.wikidata.org/entity/Q28289922',
    'http://www.wikidata.org/entity/Q28289939',
    'http://www.wikidata.org/entity/Q28289949',
    'http://www.wikidata.org/entity/Q28289962',
    'http://www.wikidata.org/entity/Q28289975',
    'http://www.wikidata.org/entity/Q28289984',
    'http://www.wikidata.org/entity/Q28290043',
    'http://www.wikidata.org/entity/Q28290048',
    'http://www.wikidata.org/entity/Q28290055',
    'http://www.wikidata.org/entity/Q28290058',
    'http://www.wikidata.org/entity/Q28290076',
    'http://www.wikidata.org/entity/Q28290083',
    'http://www.wikidata.org/entity/Q28290085',
    'http://www.wikidata.org/entity/Q28290099',
    'http://www.wikidata.org/entity/Q28290118',
    'http://www.wikidata.org/entity/Q28290152',
    'http://www.wikidata.org/entity/Q28290169',
    'http://www.wikidata.org/entity/Q28290182',
    'http://www.wikidata.org/entity/Q28290214',
    'http://www.wikidata.org/entity/Q28290306',
    'http://www.wikidata.org/entity/Q28290341',
    'http://www.wikidata.org/entity/Q28290361',
    'http://www.wikidata.org/entity/Q28290395',
    'http://www.wikidata.org/entity/Q28290413',
    'http://www.wikidata.org/entity/Q28290440',
    'http://www.wikidata.org/entity/Q28290455',
    'http://www.wikidata.org/entity/Q28290479',
    'http://www.wikidata.org/entity/Q28290509',
    'http://www.wikidata.org/entity/Q28290512',
    'http://www.wikidata.org/entity/Q28290519',
    'http://www.wikidata.org/entity/Q28290611',
    'http://www.wikidata.org/entity/Q28290615',
    'http://www.wikidata.org/entity/Q28290658',
    'http://www.wikidata.org/entity/Q28290710',
    'http://www.wikidata.org/entity/Q28290773',
    'http://www.wikidata.org/entity/Q28290774',
    'http://www.wikidata.org/entity/Q28290795',
    'http://www.wikidata.org/entity/Q28290805',
    'http://www.wikidata.org/entity/Q28290854',
    'http://www.wikidata.org/entity/Q28290871',
    'http://www.wikidata.org/entity/Q28290898',
    'http://www.wikidata.org/entity/Q28290910',
    'http://www.wikidata.org/entity/Q28290930',
    'http://www.wikidata.org/entity/Q28290936',
    'http://www.wikidata.org/entity/Q28290999',
    'http://www.wikidata.org/entity/Q28291005',
    'http://www.wikidata.org/entity/Q28291012',
    'http://www.wikidata.org/entity/Q28291019',
    'http://www.wikidata.org/entity/Q28291033',
    'http://www.wikidata.org/entity/Q28291118',
    'http://www.wikidata.org/entity/Q28291143',
    'http://www.wikidata.org/entity/Q28291156',
    'http://www.wikidata.org/entity/Q28291172',
    'http://www.wikidata.org/entity/Q28291219',
    'http://www.wikidata.org/entity/Q28291266',
    'http://www.wikidata.org/entity/Q28291313',
    'http://www.wikidata.org/entity/Q28291334',
    'http://www.wikidata.org/entity/Q28291379',
    'http://www.wikidata.org/entity/Q28291434',
    'http://www.wikidata.org/entity/Q28291514',
    'http://www.wikidata.org/entity/Q28291554',
    'http://www.wikidata.org/entity/Q28291556',
    'http://www.wikidata.org/entity/Q28291584',
    'http://www.wikidata.org/entity/Q28291591',
    'http://www.wikidata.org/entity/Q28291599',
    'http://www.wikidata.org/entity/Q28291604',
    'http://www.wikidata.org/entity/Q28291637',
    'http://www.wikidata.org/entity/Q28291639',
    'http://www.wikidata.org/entity/Q28291640',
    'http://www.wikidata.org/entity/Q28291660',
    'http://www.wikidata.org/entity/Q28291671',
    'http://www.wikidata.org/entity/Q28291702',
    'http://www.wikidata.org/entity/Q28291712',
    'http://www.wikidata.org/entity/Q28291782',
    'http://www.wikidata.org/entity/Q28291895',
    'http://www.wikidata.org/entity/Q28291914',
    'http://www.wikidata.org/entity/Q28291920',
    'http://www.wikidata.org/entity/Q28291924',
    'http://www.wikidata.org/entity/Q28291934',
    'http://www.wikidata.org/entity/Q28291971',
    'http://www.wikidata.org/entity/Q28291983',
    'http://www.wikidata.org/entity/Q28291992',
    'http://www.wikidata.org/entity/Q28292031',
    'http://www.wikidata.org/entity/Q28292044',
    'http://www.wikidata.org/entity/Q28292093',
    'http://www.wikidata.org/entity/Q28292161',
    'http://www.wikidata.org/entity/Q28292190',
    'http://www.wikidata.org/entity/Q28292221',
    'http://www.wikidata.org/entity/Q28292223',
    'http://www.wikidata.org/entity/Q28292247',
    'http://www.wikidata.org/entity/Q28292256',
    'http://www.wikidata.org/entity/Q28292261',
    'http://www.wikidata.org/entity/Q28292275',
    'http://www.wikidata.org/entity/Q28292295',
    'http://www.wikidata.org/entity/Q28292299',
    'http://www.wikidata.org/entity/Q28292345',
    'http://www.wikidata.org/entity/Q28292418',
    'http://www.wikidata.org/entity/Q28292445',
    'http://www.wikidata.org/entity/Q28292500',
    'http://www.wikidata.org/entity/Q28292578',
    'http://www.wikidata.org/entity/Q28292588',
    'http://www.wikidata.org/entity/Q28292632',
    'http://www.wikidata.org/entity/Q28292696',
    'http://www.wikidata.org/entity/Q28292726',
    'http://www.wikidata.org/entity/Q28292772',
    'http://www.wikidata.org/entity/Q28292821',
    'http://www.wikidata.org/entity/Q28292876',
    'http://www.wikidata.org/entity/Q28292891',
    'http://www.wikidata.org/entity/Q28292900',
    'http://www.wikidata.org/entity/Q28292903',
    'http://www.wikidata.org/entity/Q28292914',
    'http://www.wikidata.org/entity/Q28292932',
    'http://www.wikidata.org/entity/Q28293089',
    'http://www.wikidata.org/entity/Q28293091',
    'http://www.wikidata.org/entity/Q28293181',
    'http://www.wikidata.org/entity/Q28293186',
    'http://www.wikidata.org/entity/Q28293198',
    'http://www.wikidata.org/entity/Q28293240',
    'http://www.wikidata.org/entity/Q28293364',
    'http://www.wikidata.org/entity/Q28293442',
    'http://www.wikidata.org/entity/Q28293460',
    'http://www.wikidata.org/entity/Q28293505',
    'http://www.wikidata.org/entity/Q28293535',
    'http://www.wikidata.org/entity/Q28293625',
    'http://www.wikidata.org/entity/Q28293630',
    'http://www.wikidata.org/entity/Q28293647',
    'http://www.wikidata.org/entity/Q28293713',
    'http://www.wikidata.org/entity/Q28293763',
    'http://www.wikidata.org/entity/Q28293769',
    'http://www.wikidata.org/entity/Q28293773',
    'http://www.wikidata.org/entity/Q28293854',
    'http://www.wikidata.org/entity/Q28293858',
    'http://www.wikidata.org/entity/Q28293867',
    'http://www.wikidata.org/entity/Q28293869',
    'http://www.wikidata.org/entity/Q28293885',
    'http://www.wikidata.org/entity/Q28293934',
    'http://www.wikidata.org/entity/Q28293947',
    'http://www.wikidata.org/entity/Q28293961',
    'http://www.wikidata.org/entity/Q28293967',
    'http://www.wikidata.org/entity/Q28293978',
    'http://www.wikidata.org/entity/Q28293996',
    'http://www.wikidata.org/entity/Q28294001',
    'http://www.wikidata.org/entity/Q28294011',
    'http://www.wikidata.org/entity/Q28294042',
    'http://www.wikidata.org/entity/Q28294058',
    'http://www.wikidata.org/entity/Q28294074',
    'http://www.wikidata.org/entity/Q28294122',
    'http://www.wikidata.org/entity/Q28294137',
    'http://www.wikidata.org/entity/Q28294206',
    'http://www.wikidata.org/entity/Q28294217',
    'http://www.wikidata.org/entity/Q28294373',
    'http://www.wikidata.org/entity/Q28294396',
    'http://www.wikidata.org/entity/Q28294403',
    'http://www.wikidata.org/entity/Q28294410',
    'http://www.wikidata.org/entity/Q28294420',
    'http://www.wikidata.org/entity/Q28294459',
    'http://www.wikidata.org/entity/Q28294460',
    'http://www.wikidata.org/entity/Q28294469',
    'http://www.wikidata.org/entity/Q28294477',
    'http://www.wikidata.org/entity/Q28294626',
    'http://www.wikidata.org/entity/Q28294631',
    'http://www.wikidata.org/entity/Q28294729',
    'http://www.wikidata.org/entity/Q28294780',
    'http://www.wikidata.org/entity/Q28294791',
    'http://www.wikidata.org/entity/Q28294807',
    'http://www.wikidata.org/entity/Q28294827',
    'http://www.wikidata.org/entity/Q28294906',
    'http://www.wikidata.org/entity/Q28294956',
    'http://www.wikidata.org/entity/Q28295010',
    'http://www.wikidata.org/entity/Q28295023',
    'http://www.wikidata.org/entity/Q28295033',
    'http://www.wikidata.org/entity/Q28295041',
    'http://www.wikidata.org/entity/Q28295048',
    'http://www.wikidata.org/entity/Q28295103',
    'http://www.wikidata.org/entity/Q28295115',
    'http://www.wikidata.org/entity/Q28295179',
    'http://www.wikidata.org/entity/Q28295213',
    'http://www.wikidata.org/entity/Q28295224',
    'http://www.wikidata.org/entity/Q28295247',
    'http://www.wikidata.org/entity/Q28295248',
    'http://www.wikidata.org/entity/Q28295314',
    'http://www.wikidata.org/entity/Q28295362',
    'http://www.wikidata.org/entity/Q28295371',
    'http://www.wikidata.org/entity/Q28295416',
    'http://www.wikidata.org/entity/Q28295424',
    'http://www.wikidata.org/entity/Q28295458',
    'http://www.wikidata.org/entity/Q28295466',
    'http://www.wikidata.org/entity/Q28295470',
    'http://www.wikidata.org/entity/Q28295474',
    'http://www.wikidata.org/entity/Q28295481',
    'http://www.wikidata.org/entity/Q28295486',
    'http://www.wikidata.org/entity/Q28295501',
    'http://www.wikidata.org/entity/Q28295658',
    'http://www.wikidata.org/entity/Q28295664',
    'http://www.wikidata.org/entity/Q28295708',
    'http://www.wikidata.org/entity/Q28295758',
    'http://www.wikidata.org/entity/Q28295796',
    'http://www.wikidata.org/entity/Q28295798',
    'http://www.wikidata.org/entity/Q28295800',
    'http://www.wikidata.org/entity/Q28295844',
    'http://www.wikidata.org/entity/Q28295992',
    'http://www.wikidata.org/entity/Q28295996',
    'http://www.wikidata.org/entity/Q28296081',
    'http://www.wikidata.org/entity/Q28296135',
    'http://www.wikidata.org/entity/Q28296169',
    'http://www.wikidata.org/entity/Q28296183',
    'http://www.wikidata.org/entity/Q28296225',
    'http://www.wikidata.org/entity/Q28296226',
    'http://www.wikidata.org/entity/Q28296274',
    'http://www.wikidata.org/entity/Q28296286',
    'http://www.wikidata.org/entity/Q28296322',
    'http://www.wikidata.org/entity/Q28296330',
    'http://www.wikidata.org/entity/Q28296342',
    'http://www.wikidata.org/entity/Q28296347',
    'http://www.wikidata.org/entity/Q28296349',
    'http://www.wikidata.org/entity/Q28296351',
    'http://www.wikidata.org/entity/Q28296363',
    'http://www.wikidata.org/entity/Q28296365',
    'http://www.wikidata.org/entity/Q28296375',
    'http://www.wikidata.org/entity/Q28296386',
    'http://www.wikidata.org/entity/Q28296408',
    'http://www.wikidata.org/entity/Q28296434',
    'http://www.wikidata.org/entity/Q28296496',
    'http://www.wikidata.org/entity/Q28296509',
    'http://www.wikidata.org/entity/Q28296520',
    'http://www.wikidata.org/entity/Q28296532',
    'http://www.wikidata.org/entity/Q28296559',
    'http://www.wikidata.org/entity/Q28296618',
    'http://www.wikidata.org/entity/Q28296635',
    'http://www.wikidata.org/entity/Q28296740',
    'http://www.wikidata.org/entity/Q28296759',
    'http://www.wikidata.org/entity/Q28296761',
    'http://www.wikidata.org/entity/Q28296771',
    'http://www.wikidata.org/entity/Q28296787',
    'http://www.wikidata.org/entity/Q28296802',
    'http://www.wikidata.org/entity/Q28296838',
    'http://www.wikidata.org/entity/Q28296841',
    'http://www.wikidata.org/entity/Q28296941',
    'http://www.wikidata.org/entity/Q28296956',
    'http://www.wikidata.org/entity/Q28297034',
    'http://www.wikidata.org/entity/Q28297061',
    'http://www.wikidata.org/entity/Q28297089',
    'http://www.wikidata.org/entity/Q28297113',
    'http://www.wikidata.org/entity/Q28297151',
    'http://www.wikidata.org/entity/Q28297152',
    'http://www.wikidata.org/entity/Q28297163',
    'http://www.wikidata.org/entity/Q28297257',
    'http://www.wikidata.org/entity/Q28297274',
    'http://www.wikidata.org/entity/Q28297287',
    'http://www.wikidata.org/entity/Q28297288',
    'http://www.wikidata.org/entity/Q28297290',
    'http://www.wikidata.org/entity/Q28297326',
    'http://www.wikidata.org/entity/Q28297343',
    'http://www.wikidata.org/entity/Q28297381',
    'http://www.wikidata.org/entity/Q28297391',
    'http://www.wikidata.org/entity/Q28297419',
    'http://www.wikidata.org/entity/Q28297458',
    'http://www.wikidata.org/entity/Q28297489',
    'http://www.wikidata.org/entity/Q28297514',
    'http://www.wikidata.org/entity/Q28297566',
    'http://www.wikidata.org/entity/Q28297605',
    'http://www.wikidata.org/entity/Q28297615',
    'http://www.wikidata.org/entity/Q28297634',
    'http://www.wikidata.org/entity/Q28297640',
    'http://www.wikidata.org/entity/Q28297680',
    'http://www.wikidata.org/entity/Q28297690',
    'http://www.wikidata.org/entity/Q28297705',
    'http://www.wikidata.org/entity/Q28297706',
    'http://www.wikidata.org/entity/Q28297712',
    'http://www.wikidata.org/entity/Q28297713',
    'http://www.wikidata.org/entity/Q28297716',
    'http://www.wikidata.org/entity/Q28297748',
    'http://www.wikidata.org/entity/Q28297786',
    'http://www.wikidata.org/entity/Q28297806',
    'http://www.wikidata.org/entity/Q28297812',
    'http://www.wikidata.org/entity/Q28297827',
    'http://www.wikidata.org/entity/Q28297859',
    'http://www.wikidata.org/entity/Q28297888',
    'http://www.wikidata.org/entity/Q28297958',
    'http://www.wikidata.org/entity/Q28297997',
    'http://www.wikidata.org/entity/Q28298018',
    'http://www.wikidata.org/entity/Q28298042',
    'http://www.wikidata.org/entity/Q28298056',
    'http://www.wikidata.org/entity/Q28298072',
    'http://www.wikidata.org/entity/Q28298141',
    'http://www.wikidata.org/entity/Q28298150',
    'http://www.wikidata.org/entity/Q28298160',
    'http://www.wikidata.org/entity/Q28298178',
    'http://www.wikidata.org/entity/Q28298260',
    'http://www.wikidata.org/entity/Q28298301',
    'http://www.wikidata.org/entity/Q28298305',
    'http://www.wikidata.org/entity/Q28298317',
    'http://www.wikidata.org/entity/Q28298327',
    'http://www.wikidata.org/entity/Q28298328',
    'http://www.wikidata.org/entity/Q28298336',
    'http://www.wikidata.org/entity/Q28298338',
    'http://www.wikidata.org/entity/Q28298371',
    'http://www.wikidata.org/entity/Q28298382',
    'http://www.wikidata.org/entity/Q28298407',
    'http://www.wikidata.org/entity/Q28298430',
    'http://www.wikidata.org/entity/Q28298435',
    'http://www.wikidata.org/entity/Q28298445',
    'http://www.wikidata.org/entity/Q28298464',
    'http://www.wikidata.org/entity/Q28298468',
    'http://www.wikidata.org/entity/Q28298475',
    'http://www.wikidata.org/entity/Q28298578',
    'http://www.wikidata.org/entity/Q28298616',
    'http://www.wikidata.org/entity/Q28298620',
    'http://www.wikidata.org/entity/Q28298636',
    'http://www.wikidata.org/entity/Q28298681',
    'http://www.wikidata.org/entity/Q28298689',
    'http://www.wikidata.org/entity/Q28298905',
    'http://www.wikidata.org/entity/Q28298920',
    'http://www.wikidata.org/entity/Q28298985',
    'http://www.wikidata.org/entity/Q28298987',
    'http://www.wikidata.org/entity/Q28299069',
    'http://www.wikidata.org/entity/Q28299078',
    'http://www.wikidata.org/entity/Q28299084',
    'http://www.wikidata.org/entity/Q28299119',
    'http://www.wikidata.org/entity/Q28299151',
    'http://www.wikidata.org/entity/Q28299215',
    'http://www.wikidata.org/entity/Q28299224',
    'http://www.wikidata.org/entity/Q28299244',
    'http://www.wikidata.org/entity/Q28299270',
    'http://www.wikidata.org/entity/Q28299280',
    'http://www.wikidata.org/entity/Q28299311',
    'http://www.wikidata.org/entity/Q28299361',
    'http://www.wikidata.org/entity/Q28299370',
    'http://www.wikidata.org/entity/Q28299429',
    'http://www.wikidata.org/entity/Q28299550',
    'http://www.wikidata.org/entity/Q28299554',
    'http://www.wikidata.org/entity/Q28299555',
    'http://www.wikidata.org/entity/Q28299566',
    'http://www.wikidata.org/entity/Q28299775',
    'http://www.wikidata.org/entity/Q28299776',
    'http://www.wikidata.org/entity/Q28299798',
    'http://www.wikidata.org/entity/Q28299834',
    'http://www.wikidata.org/entity/Q28299875',
    'http://www.wikidata.org/entity/Q28299929',
    'http://www.wikidata.org/entity/Q28299966',
    'http://www.wikidata.org/entity/Q28299969',
    'http://www.wikidata.org/entity/Q28300130',
    'http://www.wikidata.org/entity/Q28300132',
    'http://www.wikidata.org/entity/Q28300185',
    'http://www.wikidata.org/entity/Q28300233',
    'http://www.wikidata.org/entity/Q28300235',
    'http://www.wikidata.org/entity/Q28300236',
    'http://www.wikidata.org/entity/Q28300240',
    'http://www.wikidata.org/entity/Q28300247',
    'http://www.wikidata.org/entity/Q28300256',
    'http://www.wikidata.org/entity/Q28300258',
    'http://www.wikidata.org/entity/Q28300305',
    'http://www.wikidata.org/entity/Q28300310',
    'http://www.wikidata.org/entity/Q28300322',
    'http://www.wikidata.org/entity/Q28300353',
    'http://www.wikidata.org/entity/Q28300359',
    'http://www.wikidata.org/entity/Q28300376',
    'http://www.wikidata.org/entity/Q28300379',
    'http://www.wikidata.org/entity/Q28300406',
    'http://www.wikidata.org/entity/Q28300407',
    'http://www.wikidata.org/entity/Q28300415',
    'http://www.wikidata.org/entity/Q28300546',
    'http://www.wikidata.org/entity/Q28300555',
    'http://www.wikidata.org/entity/Q28300579',
    'http://www.wikidata.org/entity/Q28300616',
    'http://www.wikidata.org/entity/Q28300625',
    'http://www.wikidata.org/entity/Q28300658',
    'http://www.wikidata.org/entity/Q28300764',
    'http://www.wikidata.org/entity/Q28300777',
    'http://www.wikidata.org/entity/Q28300820',
    'http://www.wikidata.org/entity/Q28300884',
    'http://www.wikidata.org/entity/Q28300888',
    'http://www.wikidata.org/entity/Q28300893',
    'http://www.wikidata.org/entity/Q28300901',
    'http://www.wikidata.org/entity/Q28300934',
    'http://www.wikidata.org/entity/Q28300961',
    'http://www.wikidata.org/entity/Q28300983',
    'http://www.wikidata.org/entity/Q28301127',
    'http://www.wikidata.org/entity/Q28301165',
    'http://www.wikidata.org/entity/Q28301196',
    'http://www.wikidata.org/entity/Q28301232',
    'http://www.wikidata.org/entity/Q28301280',
    'http://www.wikidata.org/entity/Q28301329',
    'http://www.wikidata.org/entity/Q28301332',
    'http://www.wikidata.org/entity/Q28301393',
    'http://www.wikidata.org/entity/Q28301404',
    'http://www.wikidata.org/entity/Q28301412',
    'http://www.wikidata.org/entity/Q28301413',
    'http://www.wikidata.org/entity/Q28301418',
    'http://www.wikidata.org/entity/Q28301446',
    'http://www.wikidata.org/entity/Q28301463',
    'http://www.wikidata.org/entity/Q28301516',
    'http://www.wikidata.org/entity/Q28301519',
    'http://www.wikidata.org/entity/Q28301525',
    'http://www.wikidata.org/entity/Q28301594',
    'http://www.wikidata.org/entity/Q28301602',
    'http://www.wikidata.org/entity/Q28301613',
    'http://www.wikidata.org/entity/Q28301622',
    'http://www.wikidata.org/entity/Q28301648',
    'http://www.wikidata.org/entity/Q28301651',
    'http://www.wikidata.org/entity/Q28301656',
    'http://www.wikidata.org/entity/Q28301659',
    'http://www.wikidata.org/entity/Q28301685',
    'http://www.wikidata.org/entity/Q28301695',
    'http://www.wikidata.org/entity/Q28301704',
    'http://www.wikidata.org/entity/Q28301744',
    'http://www.wikidata.org/entity/Q28301751',
    'http://www.wikidata.org/entity/Q28301763',
    'http://www.wikidata.org/entity/Q28301776',
    'http://www.wikidata.org/entity/Q28301788',
    'http://www.wikidata.org/entity/Q28301797',
    'http://www.wikidata.org/entity/Q28301815',
    'http://www.wikidata.org/entity/Q28301842',
    'http://www.wikidata.org/entity/Q28301853',
    'http://www.wikidata.org/entity/Q28301922',
    'http://www.wikidata.org/entity/Q28301940',
    'http://www.wikidata.org/entity/Q28301973',
    'http://www.wikidata.org/entity/Q28301994',
    'http://www.wikidata.org/entity/Q28302107',
    'http://www.wikidata.org/entity/Q28302110',
    'http://www.wikidata.org/entity/Q28302118',
    'http://www.wikidata.org/entity/Q28302123',
    'http://www.wikidata.org/entity/Q28302244',
    'http://www.wikidata.org/entity/Q28302368',
    'http://www.wikidata.org/entity/Q28302373',
    'http://www.wikidata.org/entity/Q28302405',
    'http://www.wikidata.org/entity/Q28302478',
    'http://www.wikidata.org/entity/Q28302522',
    'http://www.wikidata.org/entity/Q28302536',
    'http://www.wikidata.org/entity/Q28302544',
    'http://www.wikidata.org/entity/Q28302545',
    'http://www.wikidata.org/entity/Q28302589',
    'http://www.wikidata.org/entity/Q28302612',
    'http://www.wikidata.org/entity/Q28302681',
    'http://www.wikidata.org/entity/Q28302692',
    'http://www.wikidata.org/entity/Q28302701',
    'http://www.wikidata.org/entity/Q28302729',
    'http://www.wikidata.org/entity/Q28302740',
    'http://www.wikidata.org/entity/Q28302762',
    'http://www.wikidata.org/entity/Q28302778',
    'http://www.wikidata.org/entity/Q28302830',
    'http://www.wikidata.org/entity/Q28302831',
    'http://www.wikidata.org/entity/Q28302850',
    'http://www.wikidata.org/entity/Q28302884',
    'http://www.wikidata.org/entity/Q28302903',
    'http://www.wikidata.org/entity/Q28302922',
    'http://www.wikidata.org/entity/Q28302936',
    'http://www.wikidata.org/entity/Q28302942',
    'http://www.wikidata.org/entity/Q28302973',
    'http://www.wikidata.org/entity/Q28302975',
    'http://www.wikidata.org/entity/Q28303009',
    'http://www.wikidata.org/entity/Q28303010',
    'http://www.wikidata.org/entity/Q28303016',
    'http://www.wikidata.org/entity/Q28303063',
    'http://www.wikidata.org/entity/Q28303091',
    'http://www.wikidata.org/entity/Q28303101',
    'http://www.wikidata.org/entity/Q28303115',
    'http://www.wikidata.org/entity/Q28303189',
    'http://www.wikidata.org/entity/Q28303204',
    'http://www.wikidata.org/entity/Q28303212',
    'http://www.wikidata.org/entity/Q28303213',
    'http://www.wikidata.org/entity/Q28303246',
    'http://www.wikidata.org/entity/Q28303277',
    'http://www.wikidata.org/entity/Q28303293',
    'http://www.wikidata.org/entity/Q28303344',
    'http://www.wikidata.org/entity/Q28303351',
    'http://www.wikidata.org/entity/Q28303404',
    'http://www.wikidata.org/entity/Q28303406',
    'http://www.wikidata.org/entity/Q28303437',
    'http://www.wikidata.org/entity/Q28303460',
    'http://www.wikidata.org/entity/Q28303557',
    'http://www.wikidata.org/entity/Q28303614',
    'http://www.wikidata.org/entity/Q28303631',
    'http://www.wikidata.org/entity/Q28303666',
    'http://www.wikidata.org/entity/Q28303693',
    'http://www.wikidata.org/entity/Q28303699',
    'http://www.wikidata.org/entity/Q28303718',
    'http://www.wikidata.org/entity/Q28303730',
    'http://www.wikidata.org/entity/Q28303742',
    'http://www.wikidata.org/entity/Q28303756',
    'http://www.wikidata.org/entity/Q28303765',
    'http://www.wikidata.org/entity/Q28303818',
    'http://www.wikidata.org/entity/Q28303865',
    'http://www.wikidata.org/entity/Q28303890',
    'http://www.wikidata.org/entity/Q28303894',
    'http://www.wikidata.org/entity/Q28303909',
    'http://www.wikidata.org/entity/Q28303915',
    'http://www.wikidata.org/entity/Q28303934',
    'http://www.wikidata.org/entity/Q28303994',
    'http://www.wikidata.org/entity/Q28304002',
    'http://www.wikidata.org/entity/Q28304014',
    'http://www.wikidata.org/entity/Q28304016',
    'http://www.wikidata.org/entity/Q28304038',
    'http://www.wikidata.org/entity/Q28304072',
    'http://www.wikidata.org/entity/Q28304307',
    'http://www.wikidata.org/entity/Q28304318',
    'http://www.wikidata.org/entity/Q28304347',
    'http://www.wikidata.org/entity/Q28304349',
    'http://www.wikidata.org/entity/Q28304418',
    'http://www.wikidata.org/entity/Q28304430',
    'http://www.wikidata.org/entity/Q28304435',
    'http://www.wikidata.org/entity/Q28304462',
    'http://www.wikidata.org/entity/Q28304469',
    'http://www.wikidata.org/entity/Q28304473',
    'http://www.wikidata.org/entity/Q28304540',
    'http://www.wikidata.org/entity/Q28304542',
    'http://www.wikidata.org/entity/Q28304595',
    'http://www.wikidata.org/entity/Q28304607',
    'http://www.wikidata.org/entity/Q28304611',
    'http://www.wikidata.org/entity/Q28304626',
    'http://www.wikidata.org/entity/Q28304656',
    'http://www.wikidata.org/entity/Q28304708',
    'http://www.wikidata.org/entity/Q28304725',
    'http://www.wikidata.org/entity/Q28304727',
    'http://www.wikidata.org/entity/Q28304744',
    'http://www.wikidata.org/entity/Q28304773',
    'http://www.wikidata.org/entity/Q28304798',
    'http://www.wikidata.org/entity/Q28304805',
    'http://www.wikidata.org/entity/Q28304809',
    'http://www.wikidata.org/entity/Q28304886',
    'http://www.wikidata.org/entity/Q28304897',
    'http://www.wikidata.org/entity/Q28304923',
    'http://www.wikidata.org/entity/Q28304935',
    'http://www.wikidata.org/entity/Q28304963',
    'http://www.wikidata.org/entity/Q28305026',
    'http://www.wikidata.org/entity/Q28305030',
    'http://www.wikidata.org/entity/Q28305038',
    'http://www.wikidata.org/entity/Q28305047',
    'http://www.wikidata.org/entity/Q28305097',
    'http://www.wikidata.org/entity/Q28305128',
    'http://www.wikidata.org/entity/Q28305186',
    'http://www.wikidata.org/entity/Q28305204',
    'http://www.wikidata.org/entity/Q28305247',
    'http://www.wikidata.org/entity/Q28305279',
    'http://www.wikidata.org/entity/Q28305286',
    'http://www.wikidata.org/entity/Q28305293',
    'http://www.wikidata.org/entity/Q28305330',
    'http://www.wikidata.org/entity/Q28305340',
    'http://www.wikidata.org/entity/Q28305378',
    'http://www.wikidata.org/entity/Q28305411',
    'http://www.wikidata.org/entity/Q28305437',
    'http://www.wikidata.org/entity/Q28305443',
    'http://www.wikidata.org/entity/Q28305453',
    'http://www.wikidata.org/entity/Q28305485',
    'http://www.wikidata.org/entity/Q28305486',
    'http://www.wikidata.org/entity/Q28305488',
    'http://www.wikidata.org/entity/Q28305519',
    'http://www.wikidata.org/entity/Q28305569',
    'http://www.wikidata.org/entity/Q28305585',
    'http://www.wikidata.org/entity/Q28305615',
    'http://www.wikidata.org/entity/Q28305755',
    'http://www.wikidata.org/entity/Q28305764',
    'http://www.wikidata.org/entity/Q28305811',
    'http://www.wikidata.org/entity/Q28305845',
    'http://www.wikidata.org/entity/Q28305869',
    'http://www.wikidata.org/entity/Q28305877',
    'http://www.wikidata.org/entity/Q28305931',
    'http://www.wikidata.org/entity/Q28306067',
    'http://www.wikidata.org/entity/Q28306186',
    'http://www.wikidata.org/entity/Q28306195',
    'http://www.wikidata.org/entity/Q28306201',
    'http://www.wikidata.org/entity/Q28306248',
    'http://www.wikidata.org/entity/Q28306261',
    'http://www.wikidata.org/entity/Q28306266',
    'http://www.wikidata.org/entity/Q28306277',
    'http://www.wikidata.org/entity/Q28306313',
    'http://www.wikidata.org/entity/Q28306347',
    'http://www.wikidata.org/entity/Q28306356',
    'http://www.wikidata.org/entity/Q28306363',
    'http://www.wikidata.org/entity/Q28306403',
    'http://www.wikidata.org/entity/Q28306405',
    'http://www.wikidata.org/entity/Q28306437',
    'http://www.wikidata.org/entity/Q28306440',
    'http://www.wikidata.org/entity/Q28306447',
    'http://www.wikidata.org/entity/Q28306496',
    'http://www.wikidata.org/entity/Q28306571',
    'http://www.wikidata.org/entity/Q28306592',
    'http://www.wikidata.org/entity/Q28306593',
    'http://www.wikidata.org/entity/Q28306666',
    'http://www.wikidata.org/entity/Q28306671',
    'http://www.wikidata.org/entity/Q28306678',
    'http://www.wikidata.org/entity/Q28306694',
    'http://www.wikidata.org/entity/Q28306719',
    'http://www.wikidata.org/entity/Q28306728',
    'http://www.wikidata.org/entity/Q28306745',
    'http://www.wikidata.org/entity/Q28306763',
    'http://www.wikidata.org/entity/Q28306774',
    'http://www.wikidata.org/entity/Q28306779',
    'http://www.wikidata.org/entity/Q28306783',
    'http://www.wikidata.org/entity/Q28306809',
    'http://www.wikidata.org/entity/Q28306815',
    'http://www.wikidata.org/entity/Q28306864',
    'http://www.wikidata.org/entity/Q28306907',
    'http://www.wikidata.org/entity/Q28306968',
    'http://www.wikidata.org/entity/Q28306995',
    'http://www.wikidata.org/entity/Q28306997',
    'http://www.wikidata.org/entity/Q28307044',
    'http://www.wikidata.org/entity/Q28307067',
    'http://www.wikidata.org/entity/Q28307113',
    'http://www.wikidata.org/entity/Q28307200',
    'http://www.wikidata.org/entity/Q28307219',
    'http://www.wikidata.org/entity/Q28307294',
    'http://www.wikidata.org/entity/Q28307335',
    'http://www.wikidata.org/entity/Q28307371',
    'http://www.wikidata.org/entity/Q28307394',
    'http://www.wikidata.org/entity/Q28307399',
    'http://www.wikidata.org/entity/Q28307404',
    'http://www.wikidata.org/entity/Q28307422',
    'http://www.wikidata.org/entity/Q28307477',
    'http://www.wikidata.org/entity/Q28307498',
    'http://www.wikidata.org/entity/Q28307506',
    'http://www.wikidata.org/entity/Q28307568',
    'http://www.wikidata.org/entity/Q28307577',
    'http://www.wikidata.org/entity/Q28307578',
    'http://www.wikidata.org/entity/Q28307624',
    'http://www.wikidata.org/entity/Q28307664',
    'http://www.wikidata.org/entity/Q28307679',
    'http://www.wikidata.org/entity/Q28307704',
    'http://www.wikidata.org/entity/Q28307762',
    'http://www.wikidata.org/entity/Q28307825',
    'http://www.wikidata.org/entity/Q28307869',
    'http://www.wikidata.org/entity/Q28307871',
    'http://www.wikidata.org/entity/Q28307886',
    'http://www.wikidata.org/entity/Q28307891',
    'http://www.wikidata.org/entity/Q28307938',
    'http://www.wikidata.org/entity/Q28307969',
    'http://www.wikidata.org/entity/Q28308156',
    'http://www.wikidata.org/entity/Q28308193',
    'http://www.wikidata.org/entity/Q28308221',
    'http://www.wikidata.org/entity/Q28308246',
    'http://www.wikidata.org/entity/Q28308247',
    'http://www.wikidata.org/entity/Q28308249',
    'http://www.wikidata.org/entity/Q28308276',
    'http://www.wikidata.org/entity/Q28310323',
    'http://www.wikidata.org/entity/Q28312218',
    'http://www.wikidata.org/entity/Q28314706',
    'http://www.wikidata.org/entity/Q28314798',
    'http://www.wikidata.org/entity/Q28314923',
    'http://www.wikidata.org/entity/Q28314992',
    'http://www.wikidata.org/entity/Q28315177',
    'http://www.wikidata.org/entity/Q28315179',
    'http://www.wikidata.org/entity/Q28315201',
    'http://www.wikidata.org/entity/Q28315221',
    'http://www.wikidata.org/entity/Q28315326',
    'http://www.wikidata.org/entity/Q28315406',
    'http://www.wikidata.org/entity/Q28315407',
    'http://www.wikidata.org/entity/Q28315414',
    'http://www.wikidata.org/entity/Q28315422',
    'http://www.wikidata.org/entity/Q28315731',
    'http://www.wikidata.org/entity/Q28315740',
    'http://www.wikidata.org/entity/Q28315762',
    'http://www.wikidata.org/entity/Q28315847',
    'http://www.wikidata.org/entity/Q28317749',
    'http://www.wikidata.org/entity/Q28317810',
    'http://www.wikidata.org/entity/Q28323919',
    'http://www.wikidata.org/entity/Q28326688',
    'http://www.wikidata.org/entity/Q28328155',
    'http://www.wikidata.org/entity/Q28328440',
    'http://www.wikidata.org/entity/Q28328461',
    'http://www.wikidata.org/entity/Q28334418',
    'http://www.wikidata.org/entity/Q28334425',
    'http://www.wikidata.org/entity/Q28335496',
    'http://www.wikidata.org/entity/Q28342438',
    'http://www.wikidata.org/entity/Q28342453',
    'http://www.wikidata.org/entity/Q28342496',
    'http://www.wikidata.org/entity/Q28343193',
    'http://www.wikidata.org/entity/Q28343321',
    'http://www.wikidata.org/entity/Q28343324',
    'http://www.wikidata.org/entity/Q28343409',
    'http://www.wikidata.org/entity/Q28343514',
    'http://www.wikidata.org/entity/Q28343682',
    'http://www.wikidata.org/entity/Q28343773',
    'http://www.wikidata.org/entity/Q28343956',
    'http://www.wikidata.org/entity/Q28343959',
    'http://www.wikidata.org/entity/Q28343961',
    'http://www.wikidata.org/entity/Q28344176',
    'http://www.wikidata.org/entity/Q28344371',
    'http://www.wikidata.org/entity/Q28344579',
    'http://www.wikidata.org/entity/Q28344659',
    'http://www.wikidata.org/entity/Q28344695',
    'http://www.wikidata.org/entity/Q28344741',
    'http://www.wikidata.org/entity/Q28344791',
    'http://www.wikidata.org/entity/Q28345027',
    'http://www.wikidata.org/entity/Q28345594',
    'http://www.wikidata.org/entity/Q28345600',
    'http://www.wikidata.org/entity/Q28345989',
    'http://www.wikidata.org/entity/Q28346109',
    'http://www.wikidata.org/entity/Q28346530',
    'http://www.wikidata.org/entity/Q28346555',
    'http://www.wikidata.org/entity/Q28346591',
    'http://www.wikidata.org/entity/Q28346651',
    'http://www.wikidata.org/entity/Q28346677',
    'http://www.wikidata.org/entity/Q28348036',
    'http://www.wikidata.org/entity/Q28348765',
    'http://www.wikidata.org/entity/Q28348809',
    'http://www.wikidata.org/entity/Q28349476',
    'http://www.wikidata.org/entity/Q28350945',
    'http://www.wikidata.org/entity/Q28360343',
    'http://www.wikidata.org/entity/Q28360406',
    'http://www.wikidata.org/entity/Q28361583',
    'http://www.wikidata.org/entity/Q28361995',
    'http://www.wikidata.org/entity/Q28362078',
    'http://www.wikidata.org/entity/Q28362211',
    'http://www.wikidata.org/entity/Q28362221',
    'http://www.wikidata.org/entity/Q28363018',
    'http://www.wikidata.org/entity/Q28363080',
    'http://www.wikidata.org/entity/Q28363492',
    'http://www.wikidata.org/entity/Q28363890',
    'http://www.wikidata.org/entity/Q28364366',
    'http://www.wikidata.org/entity/Q28364539',
    'http://www.wikidata.org/entity/Q28364720',
    'http://www.wikidata.org/entity/Q28364738',
    'http://www.wikidata.org/entity/Q28365153',
    'http://www.wikidata.org/entity/Q28365532',
    'http://www.wikidata.org/entity/Q28365635',
    'http://www.wikidata.org/entity/Q28365783',
    'http://www.wikidata.org/entity/Q28365826',
    'http://www.wikidata.org/entity/Q28365883',
    'http://www.wikidata.org/entity/Q28366058',
    'http://www.wikidata.org/entity/Q28366131',
    'http://www.wikidata.org/entity/Q28366303',
    'http://www.wikidata.org/entity/Q28366319',
    'http://www.wikidata.org/entity/Q28366329',
    'http://www.wikidata.org/entity/Q28366528',
    'http://www.wikidata.org/entity/Q28366751',
    'http://www.wikidata.org/entity/Q28366764',
    'http://www.wikidata.org/entity/Q28366850',
    'http://www.wikidata.org/entity/Q28367955',
    'http://www.wikidata.org/entity/Q28368373',
    'http://www.wikidata.org/entity/Q28369033',
    'http://www.wikidata.org/entity/Q28369295',
    'http://www.wikidata.org/entity/Q28369463',
    'http://www.wikidata.org/entity/Q28369526',
    'http://www.wikidata.org/entity/Q28369732',
    'http://www.wikidata.org/entity/Q28370245',
    'http://www.wikidata.org/entity/Q28370516',
    'http://www.wikidata.org/entity/Q28370564',
    'http://www.wikidata.org/entity/Q28370605',
    'http://www.wikidata.org/entity/Q28370656',
    'http://www.wikidata.org/entity/Q28370808',
    'http://www.wikidata.org/entity/Q28370885',
    'http://www.wikidata.org/entity/Q28371129',
    'http://www.wikidata.org/entity/Q28371563',
    'http://www.wikidata.org/entity/Q28372012',
    'http://www.wikidata.org/entity/Q28372016',
    'http://www.wikidata.org/entity/Q28372091',
    'http://www.wikidata.org/entity/Q28372162',
    'http://www.wikidata.org/entity/Q28373115',
    'http://www.wikidata.org/entity/Q28373514',
    'http://www.wikidata.org/entity/Q28373950',
    'http://www.wikidata.org/entity/Q28374684',
    'http://www.wikidata.org/entity/Q28376762',
    'http://www.wikidata.org/entity/Q28377121',
    'http://www.wikidata.org/entity/Q28378044',
    'http://www.wikidata.org/entity/Q28378462',
    'http://www.wikidata.org/entity/Q28378889',
    'http://www.wikidata.org/entity/Q28378895',
    'http://www.wikidata.org/entity/Q28379553',
    'http://www.wikidata.org/entity/Q28382782',
    'http://www.wikidata.org/entity/Q28383071',
    'http://www.wikidata.org/entity/Q28383168',
    'http://www.wikidata.org/entity/Q28383326',
    'http://www.wikidata.org/entity/Q28384223',
    'http://www.wikidata.org/entity/Q28384232',
    'http://www.wikidata.org/entity/Q28384598',
    'http://www.wikidata.org/entity/Q28384772',
    'http://www.wikidata.org/entity/Q28384783',
    'http://www.wikidata.org/entity/Q28385120',
    'http://www.wikidata.org/entity/Q28385440',
    'http://www.wikidata.org/entity/Q28385555',
    'http://www.wikidata.org/entity/Q28385712',
    'http://www.wikidata.org/entity/Q28385941',
    'http://www.wikidata.org/entity/Q28386602',
    'http://www.wikidata.org/entity/Q28387003',
    'http://www.wikidata.org/entity/Q28387131',
    'http://www.wikidata.org/entity/Q28387321',
    'http://www.wikidata.org/entity/Q28387661',
    'http://www.wikidata.org/entity/Q28387681',
    'http://www.wikidata.org/entity/Q28387805',
    'http://www.wikidata.org/entity/Q28387975',
    'http://www.wikidata.org/entity/Q28388148',
    'http://www.wikidata.org/entity/Q28388293',
    'http://www.wikidata.org/entity/Q28388425',
    'http://www.wikidata.org/entity/Q28388550',
    'http://www.wikidata.org/entity/Q28388551',
    'http://www.wikidata.org/entity/Q28388552',
    'http://www.wikidata.org/entity/Q28388682',
    'http://www.wikidata.org/entity/Q28388868',
    'http://www.wikidata.org/entity/Q28388989',
    'http://www.wikidata.org/entity/Q28389050',
    'http://www.wikidata.org/entity/Q28389258',
    'http://www.wikidata.org/entity/Q28389311',
    'http://www.wikidata.org/entity/Q28389421',
    'http://www.wikidata.org/entity/Q28389843',
    'http://www.wikidata.org/entity/Q28390200',
    'http://www.wikidata.org/entity/Q28390251',
    'http://www.wikidata.org/entity/Q28390288',
    'http://www.wikidata.org/entity/Q28390521',
    'http://www.wikidata.org/entity/Q28390545',
    'http://www.wikidata.org/entity/Q28390743',
    'http://www.wikidata.org/entity/Q28390807',
    'http://www.wikidata.org/entity/Q28390932',
    'http://www.wikidata.org/entity/Q28391477',
    'http://www.wikidata.org/entity/Q28392729',
    'http://www.wikidata.org/entity/Q28392757',
    'http://www.wikidata.org/entity/Q28393125',
    'http://www.wikidata.org/entity/Q28393146',
    'http://www.wikidata.org/entity/Q28393275',
    'http://www.wikidata.org/entity/Q28393651',
    'http://www.wikidata.org/entity/Q28393669',
    'http://www.wikidata.org/entity/Q28394141',
    'http://www.wikidata.org/entity/Q28394394',
    'http://www.wikidata.org/entity/Q28394721',
    'http://www.wikidata.org/entity/Q28395017',
    'http://www.wikidata.org/entity/Q28395157',
    'http://www.wikidata.org/entity/Q28395344',
    'http://www.wikidata.org/entity/Q28395637',
    'http://www.wikidata.org/entity/Q28396036',
    'http://www.wikidata.org/entity/Q28396069',
    'http://www.wikidata.org/entity/Q28396111',
    'http://www.wikidata.org/entity/Q28396234',
    'http://www.wikidata.org/entity/Q28396273',
    'http://www.wikidata.org/entity/Q28396307',
    'http://www.wikidata.org/entity/Q28397050',
    'http://www.wikidata.org/entity/Q28397153',
    'http://www.wikidata.org/entity/Q28397246',
    'http://www.wikidata.org/entity/Q28397378',
    'http://www.wikidata.org/entity/Q28397558',
    'http://www.wikidata.org/entity/Q28397739',
    'http://www.wikidata.org/entity/Q28468751',
    'http://www.wikidata.org/entity/Q28469011',
    'http://www.wikidata.org/entity/Q28469040',
    'http://www.wikidata.org/entity/Q28469051',
    'http://www.wikidata.org/entity/Q28469056',
    'http://www.wikidata.org/entity/Q28469073',
    'http://www.wikidata.org/entity/Q28469080',
    'http://www.wikidata.org/entity/Q28469099',
    'http://www.wikidata.org/entity/Q28469125',
    'http://www.wikidata.org/entity/Q28469168',
    'http://www.wikidata.org/entity/Q28469180',
    'http://www.wikidata.org/entity/Q28469184',
    'http://www.wikidata.org/entity/Q28469186',
    'http://www.wikidata.org/entity/Q28469217',
    'http://www.wikidata.org/entity/Q28469257',
    'http://www.wikidata.org/entity/Q28469315',
    'http://www.wikidata.org/entity/Q28469321',
    'http://www.wikidata.org/entity/Q28469322',
    'http://www.wikidata.org/entity/Q28469345',
    'http://www.wikidata.org/entity/Q28472146',
    'http://www.wikidata.org/entity/Q28472177',
    'http://www.wikidata.org/entity/Q28472191',
    'http://www.wikidata.org/entity/Q28472409',
    'http://www.wikidata.org/entity/Q28472448',
    'http://www.wikidata.org/entity/Q28472590',
    'http://www.wikidata.org/entity/Q28472641',
    'http://www.wikidata.org/entity/Q28472665',
    'http://www.wikidata.org/entity/Q28472693',
    'http://www.wikidata.org/entity/Q28472711',
    'http://www.wikidata.org/entity/Q28472810',
    'http://www.wikidata.org/entity/Q28472968',
    'http://www.wikidata.org/entity/Q28473095',
    'http://www.wikidata.org/entity/Q28473103',
    'http://www.wikidata.org/entity/Q28473192',
    'http://www.wikidata.org/entity/Q28473296',
    'http://www.wikidata.org/entity/Q28473603',
    'http://www.wikidata.org/entity/Q28473903',
    'http://www.wikidata.org/entity/Q28473943',
    'http://www.wikidata.org/entity/Q28473962',
    'http://www.wikidata.org/entity/Q28474080',
    'http://www.wikidata.org/entity/Q28474181',
    'http://www.wikidata.org/entity/Q28474661',
    'http://www.wikidata.org/entity/Q28474770',
    'http://www.wikidata.org/entity/Q28474813',
    'http://www.wikidata.org/entity/Q28474918',
    'http://www.wikidata.org/entity/Q28475036',
    'http://www.wikidata.org/entity/Q28475084',
    'http://www.wikidata.org/entity/Q28475100',
    'http://www.wikidata.org/entity/Q28475159',
    'http://www.wikidata.org/entity/Q28475205',
    'http://www.wikidata.org/entity/Q28475325',
    'http://www.wikidata.org/entity/Q28475540',
    'http://www.wikidata.org/entity/Q28475591',
    'http://www.wikidata.org/entity/Q28475595',
    'http://www.wikidata.org/entity/Q28475648',
    'http://www.wikidata.org/entity/Q28475724',
    'http://www.wikidata.org/entity/Q28475870',
    'http://www.wikidata.org/entity/Q28475901',
    'http://www.wikidata.org/entity/Q28475923',
    'http://www.wikidata.org/entity/Q28475935',
    'http://www.wikidata.org/entity/Q28476110',
    'http://www.wikidata.org/entity/Q28476176',
    'http://www.wikidata.org/entity/Q28476215',
    'http://www.wikidata.org/entity/Q28476294',
    'http://www.wikidata.org/entity/Q28476486',
    'http://www.wikidata.org/entity/Q28476548',
    'http://www.wikidata.org/entity/Q28476638',
    'http://www.wikidata.org/entity/Q28477359',
    'http://www.wikidata.org/entity/Q28477449',
    'http://www.wikidata.org/entity/Q28477804',
    'http://www.wikidata.org/entity/Q28477853',
    'http://www.wikidata.org/entity/Q28478251',
    'http://www.wikidata.org/entity/Q28478260',
    'http://www.wikidata.org/entity/Q28478716',
    'http://www.wikidata.org/entity/Q28479239',
    'http://www.wikidata.org/entity/Q28479309',
    'http://www.wikidata.org/entity/Q28480534',
    'http://www.wikidata.org/entity/Q28480979',
    'http://www.wikidata.org/entity/Q28480981',
    'http://www.wikidata.org/entity/Q28481283',
    'http://www.wikidata.org/entity/Q28481341',
    'http://www.wikidata.org/entity/Q28481813',
    'http://www.wikidata.org/entity/Q28482139',
    'http://www.wikidata.org/entity/Q28482174',
    'http://www.wikidata.org/entity/Q28482471',
    'http://www.wikidata.org/entity/Q28482730',
    'http://www.wikidata.org/entity/Q28483645',
    'http://www.wikidata.org/entity/Q28483647',
    'http://www.wikidata.org/entity/Q28484097',
    'http://www.wikidata.org/entity/Q28484217',
    'http://www.wikidata.org/entity/Q28484727',
    'http://www.wikidata.org/entity/Q28484787',
    'http://www.wikidata.org/entity/Q28485156',
    'http://www.wikidata.org/entity/Q28485349',
    'http://www.wikidata.org/entity/Q28485565',
    'http://www.wikidata.org/entity/Q28485570',
    'http://www.wikidata.org/entity/Q28485571',
    'http://www.wikidata.org/entity/Q28485574',
    'http://www.wikidata.org/entity/Q28486209',
    'http://www.wikidata.org/entity/Q28486345',
    'http://www.wikidata.org/entity/Q28486366',
    'http://www.wikidata.org/entity/Q28486372',
    'http://www.wikidata.org/entity/Q28486382',
    'http://www.wikidata.org/entity/Q28486427',
    'http://www.wikidata.org/entity/Q28486434',
    'http://www.wikidata.org/entity/Q28486470',
    'http://www.wikidata.org/entity/Q28486484',
    'http://www.wikidata.org/entity/Q28486552',
    'http://www.wikidata.org/entity/Q28486587',
    'http://www.wikidata.org/entity/Q28486589',
    'http://www.wikidata.org/entity/Q28486621',
    'http://www.wikidata.org/entity/Q28486647',
    'http://www.wikidata.org/entity/Q28486798',
    'http://www.wikidata.org/entity/Q28486822',
    'http://www.wikidata.org/entity/Q28486838',
    'http://www.wikidata.org/entity/Q28486880',
    'http://www.wikidata.org/entity/Q28486898',
    'http://www.wikidata.org/entity/Q28486974',
    'http://www.wikidata.org/entity/Q28487050',
    'http://www.wikidata.org/entity/Q28487067',
    'http://www.wikidata.org/entity/Q28487070',
    'http://www.wikidata.org/entity/Q28487095',
    'http://www.wikidata.org/entity/Q28487125',
    'http://www.wikidata.org/entity/Q28487127',
    'http://www.wikidata.org/entity/Q28487196',
    'http://www.wikidata.org/entity/Q28487215',
    'http://www.wikidata.org/entity/Q28487301',
    'http://www.wikidata.org/entity/Q28487304',
    'http://www.wikidata.org/entity/Q28487339',
    'http://www.wikidata.org/entity/Q28487401',
    'http://www.wikidata.org/entity/Q28487417',
    'http://www.wikidata.org/entity/Q28487431',
    'http://www.wikidata.org/entity/Q28487469',
    'http://www.wikidata.org/entity/Q28487482',
    'http://www.wikidata.org/entity/Q28487513',
    'http://www.wikidata.org/entity/Q28487527',
    'http://www.wikidata.org/entity/Q28487528',
    'http://www.wikidata.org/entity/Q28487534',
    'http://www.wikidata.org/entity/Q28487558',
    'http://www.wikidata.org/entity/Q28487576',
    'http://www.wikidata.org/entity/Q28487601',
    'http://www.wikidata.org/entity/Q28487629',
    'http://www.wikidata.org/entity/Q28488319',
    'http://www.wikidata.org/entity/Q28488857',
    'http://www.wikidata.org/entity/Q28488878',
    'http://www.wikidata.org/entity/Q28488966',
    'http://www.wikidata.org/entity/Q28492496',
    'http://www.wikidata.org/entity/Q28492507',
    'http://www.wikidata.org/entity/Q28492521',
    'http://www.wikidata.org/entity/Q28492602',
    'http://www.wikidata.org/entity/Q28492697',
    'http://www.wikidata.org/entity/Q28492742',
    'http://www.wikidata.org/entity/Q28492790',
    'http://www.wikidata.org/entity/Q28492868',
    'http://www.wikidata.org/entity/Q28492910',
    'http://www.wikidata.org/entity/Q28492942',
    'http://www.wikidata.org/entity/Q28493042',
    'http://www.wikidata.org/entity/Q28493072',
    'http://www.wikidata.org/entity/Q28493075',
    'http://www.wikidata.org/entity/Q28493090',
    'http://www.wikidata.org/entity/Q28493106',
    'http://www.wikidata.org/entity/Q28493110',
    'http://www.wikidata.org/entity/Q28493114',
    'http://www.wikidata.org/entity/Q28493121',
    'http://www.wikidata.org/entity/Q28493129',
    'http://www.wikidata.org/entity/Q28493136',
    'http://www.wikidata.org/entity/Q28493170',
    'http://www.wikidata.org/entity/Q28493195',
    'http://www.wikidata.org/entity/Q28493241',
    'http://www.wikidata.org/entity/Q28504458',
    'http://www.wikidata.org/entity/Q28504462',
    'http://www.wikidata.org/entity/Q28504488',
    'http://www.wikidata.org/entity/Q28504554',
    'http://www.wikidata.org/entity/Q28504584',
    'http://www.wikidata.org/entity/Q28504594',
    'http://www.wikidata.org/entity/Q28504641',
    'http://www.wikidata.org/entity/Q28504655',
    'http://www.wikidata.org/entity/Q28504686',
    'http://www.wikidata.org/entity/Q28504776',
    'http://www.wikidata.org/entity/Q28504785',
    'http://www.wikidata.org/entity/Q28504793',
    'http://www.wikidata.org/entity/Q28504884',
    'http://www.wikidata.org/entity/Q28504894',
    'http://www.wikidata.org/entity/Q28504980',
    'http://www.wikidata.org/entity/Q28505006',
    'http://www.wikidata.org/entity/Q28505110',
    'http://www.wikidata.org/entity/Q28505166',
    'http://www.wikidata.org/entity/Q28505173',
    'http://www.wikidata.org/entity/Q28505213',
    'http://www.wikidata.org/entity/Q28505224',
    'http://www.wikidata.org/entity/Q28505233',
    'http://www.wikidata.org/entity/Q28505336',
    'http://www.wikidata.org/entity/Q28505346',
    'http://www.wikidata.org/entity/Q28505391',
    'http://www.wikidata.org/entity/Q28505574',
    'http://www.wikidata.org/entity/Q28505596',
    'http://www.wikidata.org/entity/Q28505614',
    'http://www.wikidata.org/entity/Q28505636',
    'http://www.wikidata.org/entity/Q28505709',
    'http://www.wikidata.org/entity/Q28505738',
    'http://www.wikidata.org/entity/Q28505756',
    'http://www.wikidata.org/entity/Q28505765',
    'http://www.wikidata.org/entity/Q28505821',
    'http://www.wikidata.org/entity/Q28505838',
    'http://www.wikidata.org/entity/Q28505855',
    'http://www.wikidata.org/entity/Q28505908',
    'http://www.wikidata.org/entity/Q28505946',
    'http://www.wikidata.org/entity/Q28505987',
    'http://www.wikidata.org/entity/Q28506010',
    'http://www.wikidata.org/entity/Q28506068',
    'http://www.wikidata.org/entity/Q28506085',
    'http://www.wikidata.org/entity/Q28506124',
    'http://www.wikidata.org/entity/Q28506160',
    'http://www.wikidata.org/entity/Q28506254',
    'http://www.wikidata.org/entity/Q28506388',
    'http://www.wikidata.org/entity/Q28506402',
    'http://www.wikidata.org/entity/Q28506431',
    'http://www.wikidata.org/entity/Q28506496',
    'http://www.wikidata.org/entity/Q28506503',
    'http://www.wikidata.org/entity/Q28506506',
    'http://www.wikidata.org/entity/Q28506533',
    'http://www.wikidata.org/entity/Q28506575',
    'http://www.wikidata.org/entity/Q28506619',
    'http://www.wikidata.org/entity/Q28506630',
    'http://www.wikidata.org/entity/Q28506710',
    'http://www.wikidata.org/entity/Q28506732',
    'http://www.wikidata.org/entity/Q28506749',
    'http://www.wikidata.org/entity/Q28506782',
    'http://www.wikidata.org/entity/Q28506783',
    'http://www.wikidata.org/entity/Q28506831',
    'http://www.wikidata.org/entity/Q28506834',
    'http://www.wikidata.org/entity/Q28506886',
    'http://www.wikidata.org/entity/Q28506922',
    'http://www.wikidata.org/entity/Q28506943',
    'http://www.wikidata.org/entity/Q28506944',
    'http://www.wikidata.org/entity/Q28506981',
    'http://www.wikidata.org/entity/Q28506984',
    'http://www.wikidata.org/entity/Q28507005',
    'http://www.wikidata.org/entity/Q28507017',
    'http://www.wikidata.org/entity/Q28507051',
    'http://www.wikidata.org/entity/Q28507084',
    'http://www.wikidata.org/entity/Q28507231',
    'http://www.wikidata.org/entity/Q28507266',
    'http://www.wikidata.org/entity/Q28507338',
    'http://www.wikidata.org/entity/Q28507365',
    'http://www.wikidata.org/entity/Q28507400',
    'http://www.wikidata.org/entity/Q28507421',
    'http://www.wikidata.org/entity/Q28507423',
    'http://www.wikidata.org/entity/Q28507630',
    'http://www.wikidata.org/entity/Q28507690',
    'http://www.wikidata.org/entity/Q28507755',
    'http://www.wikidata.org/entity/Q28507768',
    'http://www.wikidata.org/entity/Q28507770',
    'http://www.wikidata.org/entity/Q28507784',
    'http://www.wikidata.org/entity/Q28507787',
    'http://www.wikidata.org/entity/Q28507847',
    'http://www.wikidata.org/entity/Q28507996',
    'http://www.wikidata.org/entity/Q28508005',
    'http://www.wikidata.org/entity/Q28508038',
    'http://www.wikidata.org/entity/Q28508047',
    'http://www.wikidata.org/entity/Q28508079',
    'http://www.wikidata.org/entity/Q28508120',
    'http://www.wikidata.org/entity/Q28508125',
    'http://www.wikidata.org/entity/Q28508162',
    'http://www.wikidata.org/entity/Q28508177',
    'http://www.wikidata.org/entity/Q28508179',
    'http://www.wikidata.org/entity/Q28508217',
    'http://www.wikidata.org/entity/Q28508225',
    'http://www.wikidata.org/entity/Q28508255',
    'http://www.wikidata.org/entity/Q28508302',
    'http://www.wikidata.org/entity/Q28508337',
    'http://www.wikidata.org/entity/Q28508347',
    'http://www.wikidata.org/entity/Q28508358',
    'http://www.wikidata.org/entity/Q28508403',
    'http://www.wikidata.org/entity/Q28508583',
    'http://www.wikidata.org/entity/Q28508630',
    'http://www.wikidata.org/entity/Q28508708',
    'http://www.wikidata.org/entity/Q28508765',
    'http://www.wikidata.org/entity/Q28508771',
    'http://www.wikidata.org/entity/Q28508775',
    'http://www.wikidata.org/entity/Q28508806',
    'http://www.wikidata.org/entity/Q28508815',
    'http://www.wikidata.org/entity/Q28508897',
    'http://www.wikidata.org/entity/Q28508907',
    'http://www.wikidata.org/entity/Q28508915',
    'http://www.wikidata.org/entity/Q28508976',
    'http://www.wikidata.org/entity/Q28509048',
    'http://www.wikidata.org/entity/Q28509078',
    'http://www.wikidata.org/entity/Q28509079',
    'http://www.wikidata.org/entity/Q28509130',
    'http://www.wikidata.org/entity/Q28509136',
    'http://www.wikidata.org/entity/Q28509140',
    'http://www.wikidata.org/entity/Q28509150',
    'http://www.wikidata.org/entity/Q28509189',
    'http://www.wikidata.org/entity/Q28509195',
    'http://www.wikidata.org/entity/Q28509224',
    'http://www.wikidata.org/entity/Q28509238',
    'http://www.wikidata.org/entity/Q28509255',
    'http://www.wikidata.org/entity/Q28509287',
    'http://www.wikidata.org/entity/Q28509328',
    'http://www.wikidata.org/entity/Q28509347',
    'http://www.wikidata.org/entity/Q28509385',
    'http://www.wikidata.org/entity/Q28509437',
    'http://www.wikidata.org/entity/Q28509438',
    'http://www.wikidata.org/entity/Q28509468',
    'http://www.wikidata.org/entity/Q28509539',
    'http://www.wikidata.org/entity/Q28509578',
    'http://www.wikidata.org/entity/Q28509611',
    'http://www.wikidata.org/entity/Q28509662',
    'http://www.wikidata.org/entity/Q28509769',
    'http://www.wikidata.org/entity/Q28509783',
    'http://www.wikidata.org/entity/Q28509922',
    'http://www.wikidata.org/entity/Q28510028',
    'http://www.wikidata.org/entity/Q28510145',
    'http://www.wikidata.org/entity/Q28510328',
    'http://www.wikidata.org/entity/Q28510360',
    'http://www.wikidata.org/entity/Q28510386',
    'http://www.wikidata.org/entity/Q28510479',
    'http://www.wikidata.org/entity/Q28510620',
    'http://www.wikidata.org/entity/Q28510657',
    'http://www.wikidata.org/entity/Q28510667',
    'http://www.wikidata.org/entity/Q28510751',
    'http://www.wikidata.org/entity/Q28510836',
    'http://www.wikidata.org/entity/Q28510887',
    'http://www.wikidata.org/entity/Q28510931',
    'http://www.wikidata.org/entity/Q28510934',
    'http://www.wikidata.org/entity/Q28510950',
    'http://www.wikidata.org/entity/Q28511032',
    'http://www.wikidata.org/entity/Q28511124',
    'http://www.wikidata.org/entity/Q28511142',
    'http://www.wikidata.org/entity/Q28511151',
    'http://www.wikidata.org/entity/Q28511197',
    'http://www.wikidata.org/entity/Q28511242',
    'http://www.wikidata.org/entity/Q28511370',
    'http://www.wikidata.org/entity/Q28511410',
    'http://www.wikidata.org/entity/Q28511471',
    'http://www.wikidata.org/entity/Q28511503',
    'http://www.wikidata.org/entity/Q28511506',
    'http://www.wikidata.org/entity/Q28511531',
    'http://www.wikidata.org/entity/Q28511573',
    'http://www.wikidata.org/entity/Q28511588',
    'http://www.wikidata.org/entity/Q28511593',
    'http://www.wikidata.org/entity/Q28511628',
    'http://www.wikidata.org/entity/Q28511655',
    'http://www.wikidata.org/entity/Q28511660',
    'http://www.wikidata.org/entity/Q28511673',
    'http://www.wikidata.org/entity/Q28511676',
    'http://www.wikidata.org/entity/Q28511729',
    'http://www.wikidata.org/entity/Q28511870',
    'http://www.wikidata.org/entity/Q28511908',
    'http://www.wikidata.org/entity/Q28512039',
    'http://www.wikidata.org/entity/Q28512134',
    'http://www.wikidata.org/entity/Q28512135',
    'http://www.wikidata.org/entity/Q28512142',
    'http://www.wikidata.org/entity/Q28512146',
    'http://www.wikidata.org/entity/Q28512170',
    'http://www.wikidata.org/entity/Q28512201',
    'http://www.wikidata.org/entity/Q28512214',
    'http://www.wikidata.org/entity/Q28512215',
    'http://www.wikidata.org/entity/Q28512249',
    'http://www.wikidata.org/entity/Q28512319',
    'http://www.wikidata.org/entity/Q28512341',
    'http://www.wikidata.org/entity/Q28512371',
    'http://www.wikidata.org/entity/Q28512488',
    'http://www.wikidata.org/entity/Q28512527',
    'http://www.wikidata.org/entity/Q28512624',
    'http://www.wikidata.org/entity/Q28512628',
    'http://www.wikidata.org/entity/Q28512778',
    'http://www.wikidata.org/entity/Q28512785',
    'http://www.wikidata.org/entity/Q28512803',
    'http://www.wikidata.org/entity/Q28512816',
    'http://www.wikidata.org/entity/Q28512852',
    'http://www.wikidata.org/entity/Q28512875',
    'http://www.wikidata.org/entity/Q28512879',
    'http://www.wikidata.org/entity/Q28512895',
    'http://www.wikidata.org/entity/Q28512994',
    'http://www.wikidata.org/entity/Q28513003',
    'http://www.wikidata.org/entity/Q28513095',
    'http://www.wikidata.org/entity/Q28513102',
    'http://www.wikidata.org/entity/Q28513149',
    'http://www.wikidata.org/entity/Q28513175',
    'http://www.wikidata.org/entity/Q28513215',
    'http://www.wikidata.org/entity/Q28513283',
    'http://www.wikidata.org/entity/Q28513302',
    'http://www.wikidata.org/entity/Q28513337',
    'http://www.wikidata.org/entity/Q28513388',
    'http://www.wikidata.org/entity/Q28513450',
    'http://www.wikidata.org/entity/Q28513471',
    'http://www.wikidata.org/entity/Q28513521',
    'http://www.wikidata.org/entity/Q28513537',
    'http://www.wikidata.org/entity/Q28513542',
    'http://www.wikidata.org/entity/Q28513569',
    'http://www.wikidata.org/entity/Q28513574',
    'http://www.wikidata.org/entity/Q28513582',
    'http://www.wikidata.org/entity/Q28513635',
    'http://www.wikidata.org/entity/Q28513737',
    'http://www.wikidata.org/entity/Q28513748',
    'http://www.wikidata.org/entity/Q28513759',
    'http://www.wikidata.org/entity/Q28513764',
    'http://www.wikidata.org/entity/Q28513802',
    'http://www.wikidata.org/entity/Q28513852',
    'http://www.wikidata.org/entity/Q28513856',
    'http://www.wikidata.org/entity/Q28513857',
    'http://www.wikidata.org/entity/Q28528865',
    'http://www.wikidata.org/entity/Q28530408',
    'http://www.wikidata.org/entity/Q28533297',
    'http://www.wikidata.org/entity/Q28533977',
    'http://www.wikidata.org/entity/Q28534608',
    'http://www.wikidata.org/entity/Q28535275',
    'http://www.wikidata.org/entity/Q28535706',
    'http://www.wikidata.org/entity/Q28536866',
    'http://www.wikidata.org/entity/Q28537704',
    'http://www.wikidata.org/entity/Q28538804',
    'http://www.wikidata.org/entity/Q28540154',
    'http://www.wikidata.org/entity/Q28540737',
    'http://www.wikidata.org/entity/Q28540942',
    'http://www.wikidata.org/entity/Q28540952',
    'http://www.wikidata.org/entity/Q28544739',
    'http://www.wikidata.org/entity/Q28546636',
    'http://www.wikidata.org/entity/Q28547921',
    'http://www.wikidata.org/entity/Q28552564',
    'http://www.wikidata.org/entity/Q28552567',
    'http://www.wikidata.org/entity/Q28564456',
    'http://www.wikidata.org/entity/Q28564615',
    'http://www.wikidata.org/entity/Q28565002',
    'http://www.wikidata.org/entity/Q28565012',
    'http://www.wikidata.org/entity/Q28565071',
    'http://www.wikidata.org/entity/Q28565411',
    'http://www.wikidata.org/entity/Q28565520',
    'http://www.wikidata.org/entity/Q28565591',
    'http://www.wikidata.org/entity/Q28565720',
    'http://www.wikidata.org/entity/Q28566114',
    'http://www.wikidata.org/entity/Q28566123',
    'http://www.wikidata.org/entity/Q28566820',
    'http://www.wikidata.org/entity/Q28566853',
    'http://www.wikidata.org/entity/Q28566984',
    'http://www.wikidata.org/entity/Q28567006',
    'http://www.wikidata.org/entity/Q28567029',
    'http://www.wikidata.org/entity/Q28567172',
    'http://www.wikidata.org/entity/Q28567229',
    'http://www.wikidata.org/entity/Q28567230',
    'http://www.wikidata.org/entity/Q28567263',
    'http://www.wikidata.org/entity/Q28567912',
    'http://www.wikidata.org/entity/Q28568039',
    'http://www.wikidata.org/entity/Q28568459',
    'http://www.wikidata.org/entity/Q28568567',
    'http://www.wikidata.org/entity/Q28568657',
    'http://www.wikidata.org/entity/Q28568803',
    'http://www.wikidata.org/entity/Q28568856',
    'http://www.wikidata.org/entity/Q28568956',
    'http://www.wikidata.org/entity/Q28569049',
    'http://www.wikidata.org/entity/Q28569622',
    'http://www.wikidata.org/entity/Q28570094',
    'http://www.wikidata.org/entity/Q28570164',
    'http://www.wikidata.org/entity/Q28570280',
    'http://www.wikidata.org/entity/Q28570361',
    'http://www.wikidata.org/entity/Q28570483',
    'http://www.wikidata.org/entity/Q28570529',
    'http://www.wikidata.org/entity/Q28570607',
    'http://www.wikidata.org/entity/Q28570615',
    'http://www.wikidata.org/entity/Q28571015',
    'http://www.wikidata.org/entity/Q28571359',
    'http://www.wikidata.org/entity/Q28571421',
    'http://www.wikidata.org/entity/Q28571562',
    'http://www.wikidata.org/entity/Q28571639',
    'http://www.wikidata.org/entity/Q28571824',
    'http://www.wikidata.org/entity/Q28572060',
    'http://www.wikidata.org/entity/Q28572472',
    'http://www.wikidata.org/entity/Q28572747',
    'http://www.wikidata.org/entity/Q28572782',
    'http://www.wikidata.org/entity/Q28572925',
    'http://www.wikidata.org/entity/Q28573016',
    'http://www.wikidata.org/entity/Q28573077',
    'http://www.wikidata.org/entity/Q28574005',
    'http://www.wikidata.org/entity/Q28574179',
    'http://www.wikidata.org/entity/Q28574285',
    'http://www.wikidata.org/entity/Q28574525',
    'http://www.wikidata.org/entity/Q28574686',
    'http://www.wikidata.org/entity/Q28574687',
    'http://www.wikidata.org/entity/Q28574732',
    'http://www.wikidata.org/entity/Q28574795',
    'http://www.wikidata.org/entity/Q28575190',
    'http://www.wikidata.org/entity/Q28575335',
    'http://www.wikidata.org/entity/Q28575514',
    'http://www.wikidata.org/entity/Q28575529',
    'http://www.wikidata.org/entity/Q28576101',
    'http://www.wikidata.org/entity/Q28576256',
    'http://www.wikidata.org/entity/Q28576438',
    'http://www.wikidata.org/entity/Q28576622',
    'http://www.wikidata.org/entity/Q28576647',
    'http://www.wikidata.org/entity/Q28577046',
    'http://www.wikidata.org/entity/Q28577209',
    'http://www.wikidata.org/entity/Q28577391',
    'http://www.wikidata.org/entity/Q28577668',
    'http://www.wikidata.org/entity/Q28578219',
    'http://www.wikidata.org/entity/Q28579011',
    'http://www.wikidata.org/entity/Q28579031',
    'http://www.wikidata.org/entity/Q28579420',
    'http://www.wikidata.org/entity/Q28579745',
    'http://www.wikidata.org/entity/Q28580759',
    'http://www.wikidata.org/entity/Q28581167',
    'http://www.wikidata.org/entity/Q28581447',
    'http://www.wikidata.org/entity/Q28582069',
    'http://www.wikidata.org/entity/Q28582211',
    'http://www.wikidata.org/entity/Q28582746',
    'http://www.wikidata.org/entity/Q28582783',
    'http://www.wikidata.org/entity/Q28583146',
    'http://www.wikidata.org/entity/Q28583240',
    'http://www.wikidata.org/entity/Q28583342',
    'http://www.wikidata.org/entity/Q28583457',
    'http://www.wikidata.org/entity/Q28583461',
    'http://www.wikidata.org/entity/Q28583531',
    'http://www.wikidata.org/entity/Q28583865',
    'http://www.wikidata.org/entity/Q28583917',
    'http://www.wikidata.org/entity/Q28583941',
    'http://www.wikidata.org/entity/Q28584284',
    'http://www.wikidata.org/entity/Q28584697',
    'http://www.wikidata.org/entity/Q28584723',
    'http://www.wikidata.org/entity/Q28584881',
    'http://www.wikidata.org/entity/Q28584936',
    'http://www.wikidata.org/entity/Q28584976',
    'http://www.wikidata.org/entity/Q28585023',
    'http://www.wikidata.org/entity/Q28585101',
    'http://www.wikidata.org/entity/Q28585138',
    'http://www.wikidata.org/entity/Q28585211',
    'http://www.wikidata.org/entity/Q28585220',
    'http://www.wikidata.org/entity/Q28585259',
    'http://www.wikidata.org/entity/Q28585312',
    'http://www.wikidata.org/entity/Q28585314',
    'http://www.wikidata.org/entity/Q28585347',
    'http://www.wikidata.org/entity/Q28585385',
    'http://www.wikidata.org/entity/Q28585415',
    'http://www.wikidata.org/entity/Q28585429',
    'http://www.wikidata.org/entity/Q28585446',
    'http://www.wikidata.org/entity/Q28585452',
    'http://www.wikidata.org/entity/Q28585466',
    'http://www.wikidata.org/entity/Q28585545',
    'http://www.wikidata.org/entity/Q28585613',
    'http://www.wikidata.org/entity/Q28585634',
    'http://www.wikidata.org/entity/Q28585666',
    'http://www.wikidata.org/entity/Q28585676',
    'http://www.wikidata.org/entity/Q28585684',
    'http://www.wikidata.org/entity/Q28585766',
    'http://www.wikidata.org/entity/Q28585931',
    'http://www.wikidata.org/entity/Q28585986',
    'http://www.wikidata.org/entity/Q28586040',
    'http://www.wikidata.org/entity/Q28586061',
    'http://www.wikidata.org/entity/Q28586090',
    'http://www.wikidata.org/entity/Q28586153',
    'http://www.wikidata.org/entity/Q28586297',
    'http://www.wikidata.org/entity/Q28586326',
    'http://www.wikidata.org/entity/Q28586423',
    'http://www.wikidata.org/entity/Q28586441',
    'http://www.wikidata.org/entity/Q28586461',
    'http://www.wikidata.org/entity/Q28586508',
    'http://www.wikidata.org/entity/Q28586576',
    'http://www.wikidata.org/entity/Q28586578',
    'http://www.wikidata.org/entity/Q28586621',
    'http://www.wikidata.org/entity/Q28586624',
    'http://www.wikidata.org/entity/Q28586702',
    'http://www.wikidata.org/entity/Q28586744',
    'http://www.wikidata.org/entity/Q28586791',
    'http://www.wikidata.org/entity/Q28586869',
    'http://www.wikidata.org/entity/Q28586884',
    'http://www.wikidata.org/entity/Q28586980',
    'http://www.wikidata.org/entity/Q28586981',
    'http://www.wikidata.org/entity/Q28587037',
    'http://www.wikidata.org/entity/Q28587044',
    'http://www.wikidata.org/entity/Q28587071',
    'http://www.wikidata.org/entity/Q28587075',
    'http://www.wikidata.org/entity/Q28587104',
    'http://www.wikidata.org/entity/Q28587109',
    'http://www.wikidata.org/entity/Q28587110',
    'http://www.wikidata.org/entity/Q28587112',
    'http://www.wikidata.org/entity/Q28587125',
    'http://www.wikidata.org/entity/Q28587212',
    'http://www.wikidata.org/entity/Q28587213',
    'http://www.wikidata.org/entity/Q28587224',
    'http://www.wikidata.org/entity/Q28587545',
    'http://www.wikidata.org/entity/Q28587604',
    'http://www.wikidata.org/entity/Q28587612',
    'http://www.wikidata.org/entity/Q28587620',
    'http://www.wikidata.org/entity/Q28587664',
    'http://www.wikidata.org/entity/Q28587672',
    'http://www.wikidata.org/entity/Q28587753',
    'http://www.wikidata.org/entity/Q28587785',
    'http://www.wikidata.org/entity/Q28587819',
    'http://www.wikidata.org/entity/Q28587823',
    'http://www.wikidata.org/entity/Q28587851',
    'http://www.wikidata.org/entity/Q28587914',
    'http://www.wikidata.org/entity/Q28587959',
    'http://www.wikidata.org/entity/Q28587974',
    'http://www.wikidata.org/entity/Q28588056',
    'http://www.wikidata.org/entity/Q28588080',
    'http://www.wikidata.org/entity/Q28588090',
    'http://www.wikidata.org/entity/Q28588147',
    'http://www.wikidata.org/entity/Q28588185',
    'http://www.wikidata.org/entity/Q28588206',
    'http://www.wikidata.org/entity/Q28588248',
    'http://www.wikidata.org/entity/Q28588314',
    'http://www.wikidata.org/entity/Q28588439',
    'http://www.wikidata.org/entity/Q28588440',
    'http://www.wikidata.org/entity/Q28588506',
    'http://www.wikidata.org/entity/Q28588540',
    'http://www.wikidata.org/entity/Q28588558',
    'http://www.wikidata.org/entity/Q28588628',
    'http://www.wikidata.org/entity/Q28588649',
    'http://www.wikidata.org/entity/Q28588695',
    'http://www.wikidata.org/entity/Q28588756',
    'http://www.wikidata.org/entity/Q28588768',
    'http://www.wikidata.org/entity/Q28588778',
    'http://www.wikidata.org/entity/Q28588809',
    'http://www.wikidata.org/entity/Q28588830',
    'http://www.wikidata.org/entity/Q28588847',
    'http://www.wikidata.org/entity/Q28588853',
    'http://www.wikidata.org/entity/Q28588877',
    'http://www.wikidata.org/entity/Q28588931',
    'http://www.wikidata.org/entity/Q28588941',
    'http://www.wikidata.org/entity/Q28589022',
    'http://www.wikidata.org/entity/Q28589034',
    'http://www.wikidata.org/entity/Q28589040',
    'http://www.wikidata.org/entity/Q28589108',
    'http://www.wikidata.org/entity/Q28589170',
    'http://www.wikidata.org/entity/Q28589192',
    'http://www.wikidata.org/entity/Q28589360',
    'http://www.wikidata.org/entity/Q28589430',
    'http://www.wikidata.org/entity/Q28589548',
    'http://www.wikidata.org/entity/Q28589593',
    'http://www.wikidata.org/entity/Q28589597',
    'http://www.wikidata.org/entity/Q28589618',
    'http://www.wikidata.org/entity/Q28589654',
    'http://www.wikidata.org/entity/Q28589737',
    'http://www.wikidata.org/entity/Q28589743',
    'http://www.wikidata.org/entity/Q28589797',
    'http://www.wikidata.org/entity/Q28589814',
    'http://www.wikidata.org/entity/Q28589826',
    'http://www.wikidata.org/entity/Q28589872',
    'http://www.wikidata.org/entity/Q28589924',
    'http://www.wikidata.org/entity/Q28589974',
    'http://www.wikidata.org/entity/Q28589994',
    'http://www.wikidata.org/entity/Q28590162',
    'http://www.wikidata.org/entity/Q28590188',
    'http://www.wikidata.org/entity/Q28590205',
    'http://www.wikidata.org/entity/Q28590252',
    'http://www.wikidata.org/entity/Q28590279',
    'http://www.wikidata.org/entity/Q28590335',
    'http://www.wikidata.org/entity/Q28590359',
    'http://www.wikidata.org/entity/Q28590391',
    'http://www.wikidata.org/entity/Q28590478',
    'http://www.wikidata.org/entity/Q28590486',
    'http://www.wikidata.org/entity/Q28590627',
    'http://www.wikidata.org/entity/Q28590634',
    'http://www.wikidata.org/entity/Q28590646',
    'http://www.wikidata.org/entity/Q28590677',
    'http://www.wikidata.org/entity/Q28590748',
    'http://www.wikidata.org/entity/Q28590950',
    'http://www.wikidata.org/entity/Q28591078',
    'http://www.wikidata.org/entity/Q28591122',
    'http://www.wikidata.org/entity/Q28591244',
    'http://www.wikidata.org/entity/Q28591262',
    'http://www.wikidata.org/entity/Q28591283',
    'http://www.wikidata.org/entity/Q28591459',
    'http://www.wikidata.org/entity/Q28591473',
    'http://www.wikidata.org/entity/Q28591557',
    'http://www.wikidata.org/entity/Q28591573',
    'http://www.wikidata.org/entity/Q28591575',
    'http://www.wikidata.org/entity/Q28591681',
    'http://www.wikidata.org/entity/Q28591717',
    'http://www.wikidata.org/entity/Q28591724',
    'http://www.wikidata.org/entity/Q28591800',
    'http://www.wikidata.org/entity/Q28591830',
    'http://www.wikidata.org/entity/Q28591880',
    'http://www.wikidata.org/entity/Q28591898',
    'http://www.wikidata.org/entity/Q28591939',
    'http://www.wikidata.org/entity/Q28591952',
    'http://www.wikidata.org/entity/Q28591976',
    'http://www.wikidata.org/entity/Q28591997',
    'http://www.wikidata.org/entity/Q28592044',
    'http://www.wikidata.org/entity/Q28592069',
    'http://www.wikidata.org/entity/Q28592087',
    'http://www.wikidata.org/entity/Q28592133',
    'http://www.wikidata.org/entity/Q28592141',
    'http://www.wikidata.org/entity/Q28592201',
    'http://www.wikidata.org/entity/Q28592217',
    'http://www.wikidata.org/entity/Q28592260',
    'http://www.wikidata.org/entity/Q28592313',
    'http://www.wikidata.org/entity/Q28592365',
    'http://www.wikidata.org/entity/Q28592426',
    'http://www.wikidata.org/entity/Q28592444',
    'http://www.wikidata.org/entity/Q28592483',
    'http://www.wikidata.org/entity/Q28592484',
    'http://www.wikidata.org/entity/Q28592519',
    'http://www.wikidata.org/entity/Q28592530',
    'http://www.wikidata.org/entity/Q28592689',
    'http://www.wikidata.org/entity/Q28592727',
    'http://www.wikidata.org/entity/Q28592777',
    'http://www.wikidata.org/entity/Q28592795',
    'http://www.wikidata.org/entity/Q28592809',
    'http://www.wikidata.org/entity/Q28592938',
    'http://www.wikidata.org/entity/Q28593010',
    'http://www.wikidata.org/entity/Q28593025',
    'http://www.wikidata.org/entity/Q28593071',
    'http://www.wikidata.org/entity/Q28593100',
    'http://www.wikidata.org/entity/Q28593119',
    'http://www.wikidata.org/entity/Q28593156',
    'http://www.wikidata.org/entity/Q28593175',
    'http://www.wikidata.org/entity/Q28593188',
    'http://www.wikidata.org/entity/Q28593201',
    'http://www.wikidata.org/entity/Q28593210',
    'http://www.wikidata.org/entity/Q28593218',
    'http://www.wikidata.org/entity/Q28593220',
    'http://www.wikidata.org/entity/Q28593246',
    'http://www.wikidata.org/entity/Q28593253',
    'http://www.wikidata.org/entity/Q28593258',
    'http://www.wikidata.org/entity/Q28593390',
    'http://www.wikidata.org/entity/Q28593397',
    'http://www.wikidata.org/entity/Q28593490',
    'http://www.wikidata.org/entity/Q28593536',
    'http://www.wikidata.org/entity/Q28593537',
    'http://www.wikidata.org/entity/Q28593600',
    'http://www.wikidata.org/entity/Q28593627',
    'http://www.wikidata.org/entity/Q28593668',
    'http://www.wikidata.org/entity/Q28593737',
    'http://www.wikidata.org/entity/Q28593817',
    'http://www.wikidata.org/entity/Q28593859',
    'http://www.wikidata.org/entity/Q28593865',
    'http://www.wikidata.org/entity/Q28593927',
    'http://www.wikidata.org/entity/Q28593960',
    'http://www.wikidata.org/entity/Q28593963',
    'http://www.wikidata.org/entity/Q28594000',
    'http://www.wikidata.org/entity/Q28594028',
    'http://www.wikidata.org/entity/Q28594052',
    'http://www.wikidata.org/entity/Q28594064',
    'http://www.wikidata.org/entity/Q28594101',
    'http://www.wikidata.org/entity/Q28594116',
    'http://www.wikidata.org/entity/Q28594121',
    'http://www.wikidata.org/entity/Q28594148',
    'http://www.wikidata.org/entity/Q28594182',
    'http://www.wikidata.org/entity/Q28594191',
    'http://www.wikidata.org/entity/Q28594241',
    'http://www.wikidata.org/entity/Q28594263',
    'http://www.wikidata.org/entity/Q28594321',
    'http://www.wikidata.org/entity/Q28594339',
    'http://www.wikidata.org/entity/Q28594408',
    'http://www.wikidata.org/entity/Q28594441',
    'http://www.wikidata.org/entity/Q28594452',
    'http://www.wikidata.org/entity/Q28594475',
    'http://www.wikidata.org/entity/Q28594485',
    'http://www.wikidata.org/entity/Q28594502',
    'http://www.wikidata.org/entity/Q28594513',
    'http://www.wikidata.org/entity/Q28594532',
    'http://www.wikidata.org/entity/Q28594572',
    'http://www.wikidata.org/entity/Q28594624',
    'http://www.wikidata.org/entity/Q28594648',
    'http://www.wikidata.org/entity/Q28594711',
    'http://www.wikidata.org/entity/Q28594748',
    'http://www.wikidata.org/entity/Q28594759',
    'http://www.wikidata.org/entity/Q28594763',
    'http://www.wikidata.org/entity/Q28594776',
    'http://www.wikidata.org/entity/Q28594803',
    'http://www.wikidata.org/entity/Q28594828',
    'http://www.wikidata.org/entity/Q28594830',
    'http://www.wikidata.org/entity/Q28594833',
    'http://www.wikidata.org/entity/Q28594834',
    'http://www.wikidata.org/entity/Q28594887',
    'http://www.wikidata.org/entity/Q28594915',
    'http://www.wikidata.org/entity/Q28594951',
    'http://www.wikidata.org/entity/Q28595004',
    'http://www.wikidata.org/entity/Q28595016',
    'http://www.wikidata.org/entity/Q28595042',
    'http://www.wikidata.org/entity/Q28595099',
    'http://www.wikidata.org/entity/Q28601116',
    'http://www.wikidata.org/entity/Q28601792',
    'http://www.wikidata.org/entity/Q28602441',
    'http://www.wikidata.org/entity/Q28602877',
    'http://www.wikidata.org/entity/Q28603051',
    'http://www.wikidata.org/entity/Q28603064',
    'http://www.wikidata.org/entity/Q28603093',
    'http://www.wikidata.org/entity/Q28603110',
    'http://www.wikidata.org/entity/Q28603128',
    'http://www.wikidata.org/entity/Q28606606',
    'http://www.wikidata.org/entity/Q28607608',
    'http://www.wikidata.org/entity/Q28608315',
    'http://www.wikidata.org/entity/Q28608410',
    'http://www.wikidata.org/entity/Q28608938',
    'http://www.wikidata.org/entity/Q28608950',
    'http://www.wikidata.org/entity/Q28608962',
    'http://www.wikidata.org/entity/Q28608969',
    'http://www.wikidata.org/entity/Q28609049',
    'http://www.wikidata.org/entity/Q28609056',
    'http://www.wikidata.org/entity/Q28609101',
    'http://www.wikidata.org/entity/Q28609169',
    'http://www.wikidata.org/entity/Q28609173',
    'http://www.wikidata.org/entity/Q28609356',
    'http://www.wikidata.org/entity/Q28609360',
    'http://www.wikidata.org/entity/Q28609366',
    'http://www.wikidata.org/entity/Q28609417',
    'http://www.wikidata.org/entity/Q28609454',
    'http://www.wikidata.org/entity/Q28609626',
    'http://www.wikidata.org/entity/Q28609686',
    'http://www.wikidata.org/entity/Q28609687',
    'http://www.wikidata.org/entity/Q28609700',
    'http://www.wikidata.org/entity/Q28609747',
    'http://www.wikidata.org/entity/Q28609749',
    'http://www.wikidata.org/entity/Q28609761',
    'http://www.wikidata.org/entity/Q28609771',
    'http://www.wikidata.org/entity/Q28609779',
    'http://www.wikidata.org/entity/Q28609811',
    'http://www.wikidata.org/entity/Q28609824',
    'http://www.wikidata.org/entity/Q28609825',
    'http://www.wikidata.org/entity/Q28609836',
    'http://www.wikidata.org/entity/Q28609838',
    'http://www.wikidata.org/entity/Q28609843',
    'http://www.wikidata.org/entity/Q28609847',
    'http://www.wikidata.org/entity/Q28609899',
    'http://www.wikidata.org/entity/Q28609900',
    'http://www.wikidata.org/entity/Q28609902',
    'http://www.wikidata.org/entity/Q28609903',
    'http://www.wikidata.org/entity/Q28609911',
    'http://www.wikidata.org/entity/Q28610064',
    'http://www.wikidata.org/entity/Q28610067',
    'http://www.wikidata.org/entity/Q28610089',
    'http://www.wikidata.org/entity/Q28610113',
    'http://www.wikidata.org/entity/Q28610124',
    'http://www.wikidata.org/entity/Q28610136',
    'http://www.wikidata.org/entity/Q28610313',
    'http://www.wikidata.org/entity/Q28610362',
    'http://www.wikidata.org/entity/Q28610414',
    'http://www.wikidata.org/entity/Q28610812',
    'http://www.wikidata.org/entity/Q28610826',
    'http://www.wikidata.org/entity/Q28610852',
    'http://www.wikidata.org/entity/Q28611181',
    'http://www.wikidata.org/entity/Q28611326',
    'http://www.wikidata.org/entity/Q28611331',
    'http://www.wikidata.org/entity/Q28611332',
    'http://www.wikidata.org/entity/Q28611335',
    'http://www.wikidata.org/entity/Q28611336',
    'http://www.wikidata.org/entity/Q28611337',
    'http://www.wikidata.org/entity/Q28611450',
    'http://www.wikidata.org/entity/Q28611502',
    'http://www.wikidata.org/entity/Q28611795',
    'http://www.wikidata.org/entity/Q28611930',
    'http://www.wikidata.org/entity/Q28613827',
    'http://www.wikidata.org/entity/Q28615601',
    'http://www.wikidata.org/entity/Q28615706',
    'http://www.wikidata.org/entity/Q28616168',
    'http://www.wikidata.org/entity/Q28616439',
    'http://www.wikidata.org/entity/Q28616569',
    'http://www.wikidata.org/entity/Q28616857',
    'http://www.wikidata.org/entity/Q28618608',
    'http://www.wikidata.org/entity/Q28618841',
    'http://www.wikidata.org/entity/Q28619032',
    'http://www.wikidata.org/entity/Q28619230',
    'http://www.wikidata.org/entity/Q28634082',
    'http://www.wikidata.org/entity/Q28637521',
    'http://www.wikidata.org/entity/Q28639770',
    'http://www.wikidata.org/entity/Q28640016',
    'http://www.wikidata.org/entity/Q28640887',
    'http://www.wikidata.org/entity/Q28640916',
    'http://www.wikidata.org/entity/Q28645084',
    'http://www.wikidata.org/entity/Q28645594',
    'http://www.wikidata.org/entity/Q28645742',
    'http://www.wikidata.org/entity/Q28645748',
    'http://www.wikidata.org/entity/Q28645791',
    'http://www.wikidata.org/entity/Q28645847',
    'http://www.wikidata.org/entity/Q28645867',
    'http://www.wikidata.org/entity/Q28645951',
    'http://www.wikidata.org/entity/Q28646106',
    'http://www.wikidata.org/entity/Q28646111',
    'http://www.wikidata.org/entity/Q28646129',
    'http://www.wikidata.org/entity/Q28646134',
    'http://www.wikidata.org/entity/Q28646137',
    'http://www.wikidata.org/entity/Q28646140',
    'http://www.wikidata.org/entity/Q28646192',
    'http://www.wikidata.org/entity/Q28646215',
    'http://www.wikidata.org/entity/Q28646286',
    'http://www.wikidata.org/entity/Q28646359',
    'http://www.wikidata.org/entity/Q28646376',
    'http://www.wikidata.org/entity/Q28646384',
    'http://www.wikidata.org/entity/Q28646388',
    'http://www.wikidata.org/entity/Q28646475',
    'http://www.wikidata.org/entity/Q28646554',
    'http://www.wikidata.org/entity/Q28646558',
    'http://www.wikidata.org/entity/Q28646673',
    'http://www.wikidata.org/entity/Q28646728',
    'http://www.wikidata.org/entity/Q28646817',
    'http://www.wikidata.org/entity/Q28646856',
    'http://www.wikidata.org/entity/Q28646859',
    'http://www.wikidata.org/entity/Q28646911',
    'http://www.wikidata.org/entity/Q28646919',
    'http://www.wikidata.org/entity/Q28646966',
    'http://www.wikidata.org/entity/Q28647225',
    'http://www.wikidata.org/entity/Q28647566',
    'http://www.wikidata.org/entity/Q28647586',
    'http://www.wikidata.org/entity/Q28647603',
    'http://www.wikidata.org/entity/Q28647710',
    'http://www.wikidata.org/entity/Q28648010',
    'http://www.wikidata.org/entity/Q28648173',
    'http://www.wikidata.org/entity/Q28649603',
    'http://www.wikidata.org/entity/Q28650086',
    'http://www.wikidata.org/entity/Q28650443',
    'http://www.wikidata.org/entity/Q28650460',
    'http://www.wikidata.org/entity/Q28650740',
    'http://www.wikidata.org/entity/Q28650801',
    'http://www.wikidata.org/entity/Q28651579',
    'http://www.wikidata.org/entity/Q28651642',
    'http://www.wikidata.org/entity/Q28651740',
    'http://www.wikidata.org/entity/Q28651814',
    'http://www.wikidata.org/entity/Q28651929',
    'http://www.wikidata.org/entity/Q28651997',
    'http://www.wikidata.org/entity/Q28651998',
    'http://www.wikidata.org/entity/Q28652071',
    'http://www.wikidata.org/entity/Q28654521',
    'http://www.wikidata.org/entity/Q28654606',
    'http://www.wikidata.org/entity/Q28655079',
    'http://www.wikidata.org/entity/Q28655218',
    'http://www.wikidata.org/entity/Q28655430',
    'http://www.wikidata.org/entity/Q28655857',
    'http://www.wikidata.org/entity/Q28655962',
    'http://www.wikidata.org/entity/Q28656188',
    'http://www.wikidata.org/entity/Q28656305',
    'http://www.wikidata.org/entity/Q28656365',
    'http://www.wikidata.org/entity/Q28657600',
    'http://www.wikidata.org/entity/Q28657661',
    'http://www.wikidata.org/entity/Q28657714',
    'http://www.wikidata.org/entity/Q28657968',
    'http://www.wikidata.org/entity/Q28658053',
    'http://www.wikidata.org/entity/Q28658254',
    'http://www.wikidata.org/entity/Q28658397',
    'http://www.wikidata.org/entity/Q28659075',
    'http://www.wikidata.org/entity/Q28659854',
    'http://www.wikidata.org/entity/Q28659915',
    'http://www.wikidata.org/entity/Q28660145',
    'http://www.wikidata.org/entity/Q28660551',
    'http://www.wikidata.org/entity/Q28660698',
    'http://www.wikidata.org/entity/Q28660701',
    'http://www.wikidata.org/entity/Q28660703',
    'http://www.wikidata.org/entity/Q28660709',
    'http://www.wikidata.org/entity/Q28660861',
    'http://www.wikidata.org/entity/Q28660873',
    'http://www.wikidata.org/entity/Q28661442',
    'http://www.wikidata.org/entity/Q28661470',
    'http://www.wikidata.org/entity/Q28662322',
    'http://www.wikidata.org/entity/Q28673229',
    'http://www.wikidata.org/entity/Q28673956',
    'http://www.wikidata.org/entity/Q28675852',
    'http://www.wikidata.org/entity/Q28678174',
    'http://www.wikidata.org/entity/Q28678375',
    'http://www.wikidata.org/entity/Q28678518',
    'http://www.wikidata.org/entity/Q28678662',
    'http://www.wikidata.org/entity/Q28679239',
    'http://www.wikidata.org/entity/Q28680760',
    'http://www.wikidata.org/entity/Q28681212',
    'http://www.wikidata.org/entity/Q28681323',
    'http://www.wikidata.org/entity/Q28681340',
    'http://www.wikidata.org/entity/Q28684920',
    'http://www.wikidata.org/entity/Q28686251',
    'http://www.wikidata.org/entity/Q28686521',
    'http://www.wikidata.org/entity/Q28705526',
    'http://www.wikidata.org/entity/Q28708794',
    'http://www.wikidata.org/entity/Q28709004',
    'http://www.wikidata.org/entity/Q28709104',
    'http://www.wikidata.org/entity/Q28709120',
    'http://www.wikidata.org/entity/Q28709200',
    'http://www.wikidata.org/entity/Q28709296',
    'http://www.wikidata.org/entity/Q28709304',
    'http://www.wikidata.org/entity/Q28709900',
    'http://www.wikidata.org/entity/Q28709939',
    'http://www.wikidata.org/entity/Q28710019',
    'http://www.wikidata.org/entity/Q28710185',
    'http://www.wikidata.org/entity/Q28710189',
    'http://www.wikidata.org/entity/Q28710191',
    'http://www.wikidata.org/entity/Q28710193',
    'http://www.wikidata.org/entity/Q28710290',
    'http://www.wikidata.org/entity/Q28710328',
    'http://www.wikidata.org/entity/Q28710463',
    'http://www.wikidata.org/entity/Q28710498',
    'http://www.wikidata.org/entity/Q28710518',
    'http://www.wikidata.org/entity/Q28717197',
    'http://www.wikidata.org/entity/Q28727170',
    'http://www.wikidata.org/entity/Q28727260',
    'http://www.wikidata.org/entity/Q28727801',
    'http://www.wikidata.org/entity/Q28728205',
    'http://www.wikidata.org/entity/Q28728276',
    'http://www.wikidata.org/entity/Q28728648',
    'http://www.wikidata.org/entity/Q28728728',
    'http://www.wikidata.org/entity/Q28728747',
    'http://www.wikidata.org/entity/Q28729195',
    'http://www.wikidata.org/entity/Q28729965',
    'http://www.wikidata.org/entity/Q28730039',
    'http://www.wikidata.org/entity/Q28730091',
    'http://www.wikidata.org/entity/Q28730137',
    'http://www.wikidata.org/entity/Q28730188',
    'http://www.wikidata.org/entity/Q28730482',
    'http://www.wikidata.org/entity/Q28730507',
    'http://www.wikidata.org/entity/Q28730539',
    'http://www.wikidata.org/entity/Q28730663',
    'http://www.wikidata.org/entity/Q28730666',
    'http://www.wikidata.org/entity/Q28730932',
    'http://www.wikidata.org/entity/Q28730963',
    'http://www.wikidata.org/entity/Q28731424',
    'http://www.wikidata.org/entity/Q28731830',
    'http://www.wikidata.org/entity/Q28731894',
    'http://www.wikidata.org/entity/Q28732089',
    'http://www.wikidata.org/entity/Q28732092',
    'http://www.wikidata.org/entity/Q28732240',
    'http://www.wikidata.org/entity/Q28732288',
    'http://www.wikidata.org/entity/Q28732355',
    'http://www.wikidata.org/entity/Q28740455',
    'http://www.wikidata.org/entity/Q28740551',
    'http://www.wikidata.org/entity/Q28740557',
    'http://www.wikidata.org/entity/Q28740624',
    'http://www.wikidata.org/entity/Q28740880',
    'http://www.wikidata.org/entity/Q28740888',
    'http://www.wikidata.org/entity/Q28740970',
    'http://www.wikidata.org/entity/Q28740978',
    'http://www.wikidata.org/entity/Q28741367',
    'http://www.wikidata.org/entity/Q28741441',
    'http://www.wikidata.org/entity/Q28741546',
    'http://www.wikidata.org/entity/Q28741551',
    'http://www.wikidata.org/entity/Q28741589',
    'http://www.wikidata.org/entity/Q28741691',
    'http://www.wikidata.org/entity/Q28741820',
    'http://www.wikidata.org/entity/Q28742152',
    'http://www.wikidata.org/entity/Q28742404',
    'http://www.wikidata.org/entity/Q28742740',
    'http://www.wikidata.org/entity/Q28742793',
    'http://www.wikidata.org/entity/Q28742887',
    'http://www.wikidata.org/entity/Q28743030',
    'http://www.wikidata.org/entity/Q28743127',
    'http://www.wikidata.org/entity/Q28743215',
    'http://www.wikidata.org/entity/Q28743340',
    'http://www.wikidata.org/entity/Q28743515',
    'http://www.wikidata.org/entity/Q28743618',
    'http://www.wikidata.org/entity/Q28743778',
    'http://www.wikidata.org/entity/Q28744282',
    'http://www.wikidata.org/entity/Q28744329',
    'http://www.wikidata.org/entity/Q28744515',
    'http://www.wikidata.org/entity/Q28744555',
    'http://www.wikidata.org/entity/Q28744595',
    'http://www.wikidata.org/entity/Q28744688',
    'http://www.wikidata.org/entity/Q28746102',
    'http://www.wikidata.org/entity/Q28748256',
    'http://www.wikidata.org/entity/Q28748266',
    'http://www.wikidata.org/entity/Q28748325',
    'http://www.wikidata.org/entity/Q28748392',
    'http://www.wikidata.org/entity/Q28748461',
    'http://www.wikidata.org/entity/Q28748492',
    'http://www.wikidata.org/entity/Q28748616',
    'http://www.wikidata.org/entity/Q28748699',
    'http://www.wikidata.org/entity/Q28748815',
    'http://www.wikidata.org/entity/Q28748849',
    'http://www.wikidata.org/entity/Q28748872',
    'http://www.wikidata.org/entity/Q28749030',
    'http://www.wikidata.org/entity/Q28749120',
    'http://www.wikidata.org/entity/Q28749183',
    'http://www.wikidata.org/entity/Q28749229',
    'http://www.wikidata.org/entity/Q28749230',
    'http://www.wikidata.org/entity/Q28749237',
    'http://www.wikidata.org/entity/Q28749244',
    'http://www.wikidata.org/entity/Q28749251',
    'http://www.wikidata.org/entity/Q28749315',
    'http://www.wikidata.org/entity/Q28749378',
    'http://www.wikidata.org/entity/Q28749402',
    'http://www.wikidata.org/entity/Q28749553',
    'http://www.wikidata.org/entity/Q28749585',
    'http://www.wikidata.org/entity/Q28749672',
    'http://www.wikidata.org/entity/Q28749802',
    'http://www.wikidata.org/entity/Q28749837',
    'http://www.wikidata.org/entity/Q28749981',
    'http://www.wikidata.org/entity/Q28750210',
    'http://www.wikidata.org/entity/Q28750235',
    'http://www.wikidata.org/entity/Q28750295',
    'http://www.wikidata.org/entity/Q28750315',
    'http://www.wikidata.org/entity/Q28750385',
    'http://www.wikidata.org/entity/Q28751090',
    'http://www.wikidata.org/entity/Q28751374',
    'http://www.wikidata.org/entity/Q28751778',
    'http://www.wikidata.org/entity/Q28751850',
    'http://www.wikidata.org/entity/Q28751965',
    'http://www.wikidata.org/entity/Q28752035',
    'http://www.wikidata.org/entity/Q28752094',
    'http://www.wikidata.org/entity/Q28752117',
    'http://www.wikidata.org/entity/Q28752220',
    'http://www.wikidata.org/entity/Q28752341',
    'http://www.wikidata.org/entity/Q28752401',
    'http://www.wikidata.org/entity/Q28752559',
    'http://www.wikidata.org/entity/Q28752649',
    'http://www.wikidata.org/entity/Q28754345',
    'http://www.wikidata.org/entity/Q28754376',
    'http://www.wikidata.org/entity/Q28754510',
    'http://www.wikidata.org/entity/Q28754543',
    'http://www.wikidata.org/entity/Q28754716',
    'http://www.wikidata.org/entity/Q28754723',
    'http://www.wikidata.org/entity/Q28754746',
    'http://www.wikidata.org/entity/Q28754782',
    'http://www.wikidata.org/entity/Q28754891',
    'http://www.wikidata.org/entity/Q28755127',
    'http://www.wikidata.org/entity/Q28755180',
    'http://www.wikidata.org/entity/Q28755288',
    'http://www.wikidata.org/entity/Q28755321',
    'http://www.wikidata.org/entity/Q28755323',
    'http://www.wikidata.org/entity/Q28755326',
    'http://www.wikidata.org/entity/Q28755618',
    'http://www.wikidata.org/entity/Q28755663',
    'http://www.wikidata.org/entity/Q28755863',
    'http://www.wikidata.org/entity/Q28755952',
    'http://www.wikidata.org/entity/Q28755978',
    'http://www.wikidata.org/entity/Q28756035',
    'http://www.wikidata.org/entity/Q28756349',
    'http://www.wikidata.org/entity/Q28756441',
    'http://www.wikidata.org/entity/Q28756480',
    'http://www.wikidata.org/entity/Q28756824',
    'http://www.wikidata.org/entity/Q28756889',
    'http://www.wikidata.org/entity/Q28756923',
    'http://www.wikidata.org/entity/Q28757173',
    'http://www.wikidata.org/entity/Q28757205',
    'http://www.wikidata.org/entity/Q28757473',
    'http://www.wikidata.org/entity/Q28757510',
    'http://www.wikidata.org/entity/Q28757601',
    'http://www.wikidata.org/entity/Q28757721',
    'http://www.wikidata.org/entity/Q28757729',
    'http://www.wikidata.org/entity/Q28757756',
    'http://www.wikidata.org/entity/Q28762162',
    'http://www.wikidata.org/entity/Q28763190',
    'http://www.wikidata.org/entity/Q28763211',
    'http://www.wikidata.org/entity/Q28763258',
    'http://www.wikidata.org/entity/Q28763406',
    'http://www.wikidata.org/entity/Q28763446',
    'http://www.wikidata.org/entity/Q28763700',
    'http://www.wikidata.org/entity/Q28763734',
    'http://www.wikidata.org/entity/Q28764028',
    'http://www.wikidata.org/entity/Q28764664',
    'http://www.wikidata.org/entity/Q28764826',
    'http://www.wikidata.org/entity/Q28764965',
    'http://www.wikidata.org/entity/Q28765821',
    'http://www.wikidata.org/entity/Q28766102',
    'http://www.wikidata.org/entity/Q28766710',
    'http://www.wikidata.org/entity/Q28767397',
    'http://www.wikidata.org/entity/Q28768050',
    'http://www.wikidata.org/entity/Q28768211',
    'http://www.wikidata.org/entity/Q28768257',
    'http://www.wikidata.org/entity/Q28768264',
    'http://www.wikidata.org/entity/Q28768296',
    'http://www.wikidata.org/entity/Q28768418',
    'http://www.wikidata.org/entity/Q28768423',
    'http://www.wikidata.org/entity/Q28768675',
    'http://www.wikidata.org/entity/Q28768706',
    'http://www.wikidata.org/entity/Q28768988',
    'http://www.wikidata.org/entity/Q28769495',
    'http://www.wikidata.org/entity/Q28770084',
    'http://www.wikidata.org/entity/Q28770137',
    'http://www.wikidata.org/entity/Q28770139',
    'http://www.wikidata.org/entity/Q28771379',
    'http://www.wikidata.org/entity/Q28771398',
    'http://www.wikidata.org/entity/Q28771769',
    'http://www.wikidata.org/entity/Q28775661',
    'http://www.wikidata.org/entity/Q28775786',
    'http://www.wikidata.org/entity/Q28775981',
    'http://www.wikidata.org/entity/Q28776093',
    'http://www.wikidata.org/entity/Q28776123',
    'http://www.wikidata.org/entity/Q28776125',
    'http://www.wikidata.org/entity/Q28776126',
    'http://www.wikidata.org/entity/Q28776205',
    'http://www.wikidata.org/entity/Q28776273',
    'http://www.wikidata.org/entity/Q28776336',
    'http://www.wikidata.org/entity/Q28776364',
    'http://www.wikidata.org/entity/Q28776428',
    'http://www.wikidata.org/entity/Q28776457',
    'http://www.wikidata.org/entity/Q28776463',
    'http://www.wikidata.org/entity/Q28776532',
    'http://www.wikidata.org/entity/Q28776549',
    'http://www.wikidata.org/entity/Q28776596',
    'http://www.wikidata.org/entity/Q28776636',
    'http://www.wikidata.org/entity/Q28776658',
    'http://www.wikidata.org/entity/Q28776682',
    'http://www.wikidata.org/entity/Q28830491',
    'http://www.wikidata.org/entity/Q28833608',
    'http://www.wikidata.org/entity/Q28842739',
    'http://www.wikidata.org/entity/Q28842768',
    'http://www.wikidata.org/entity/Q28842863',
    'http://www.wikidata.org/entity/Q28842973',
    'http://www.wikidata.org/entity/Q28854266',
    'http://www.wikidata.org/entity/Q28854318',
    'http://www.wikidata.org/entity/Q28854335',
    'http://www.wikidata.org/entity/Q28854562',
    'http://www.wikidata.org/entity/Q28854597',
    'http://www.wikidata.org/entity/Q28874041',
    'http://www.wikidata.org/entity/Q28909142',
    'http://www.wikidata.org/entity/Q28909710',
    'http://www.wikidata.org/entity/Q28910326',
    'http://www.wikidata.org/entity/Q28910345',
    'http://www.wikidata.org/entity/Q28914720',
    'http://www.wikidata.org/entity/Q28914753',
    'http://www.wikidata.org/entity/Q28914781',
    'http://www.wikidata.org/entity/Q28916750',
    'http://www.wikidata.org/entity/Q28922478',
    'http://www.wikidata.org/entity/Q28924381',
    'http://www.wikidata.org/entity/Q28925848',
    'http://www.wikidata.org/entity/Q28941210',
    'http://www.wikidata.org/entity/Q28941769',
    'http://www.wikidata.org/entity/Q28941771',
    'http://www.wikidata.org/entity/Q28943261',
    'http://www.wikidata.org/entity/Q28943262',
    'http://www.wikidata.org/entity/Q28943288',
    'http://www.wikidata.org/entity/Q28943293',
    'http://www.wikidata.org/entity/Q28943296',
    'http://www.wikidata.org/entity/Q28943305',
    'http://www.wikidata.org/entity/Q28943315',
    'http://www.wikidata.org/entity/Q28943322',
    'http://www.wikidata.org/entity/Q28943325',
    'http://www.wikidata.org/entity/Q28943327',
    'http://www.wikidata.org/entity/Q28943334',
    'http://www.wikidata.org/entity/Q28943340',
    'http://www.wikidata.org/entity/Q28943354',
    'http://www.wikidata.org/entity/Q28943415',
    'http://www.wikidata.org/entity/Q28943421',
    'http://www.wikidata.org/entity/Q28943440',
    'http://www.wikidata.org/entity/Q28943443',
    'http://www.wikidata.org/entity/Q28943480',
    'http://www.wikidata.org/entity/Q28943490',
    'http://www.wikidata.org/entity/Q28943505',
    'http://www.wikidata.org/entity/Q28943507',
    'http://www.wikidata.org/entity/Q28943508',
    'http://www.wikidata.org/entity/Q28943515',
    'http://www.wikidata.org/entity/Q28943525',
    'http://www.wikidata.org/entity/Q28943526',
    'http://www.wikidata.org/entity/Q28943545',
    'http://www.wikidata.org/entity/Q28943551',
    'http://www.wikidata.org/entity/Q28943554',
    'http://www.wikidata.org/entity/Q28972504',
    'http://www.wikidata.org/entity/Q28972526',
    'http://www.wikidata.org/entity/Q28973611',
    'http://www.wikidata.org/entity/Q28973619',
    'http://www.wikidata.org/entity/Q28975612',
    'http://www.wikidata.org/entity/Q28975767',
    'http://www.wikidata.org/entity/Q29010431',
    'http://www.wikidata.org/entity/Q29010534',
    'http://www.wikidata.org/entity/Q29010661',
    'http://www.wikidata.org/entity/Q29010822',
    'http://www.wikidata.org/entity/Q29011044',
    'http://www.wikidata.org/entity/Q29011672',
    'http://www.wikidata.org/entity/Q29011731',
    'http://www.wikidata.org/entity/Q29011961',
    'http://www.wikidata.org/entity/Q29011988',
    'http://www.wikidata.org/entity/Q29012064',
    'http://www.wikidata.org/entity/Q29012150',
    'http://www.wikidata.org/entity/Q29012156',
    'http://www.wikidata.org/entity/Q29012233',
    'http://www.wikidata.org/entity/Q29012342',
    'http://www.wikidata.org/entity/Q29012458',
    'http://www.wikidata.org/entity/Q29012704',
    'http://www.wikidata.org/entity/Q29012723',
    'http://www.wikidata.org/entity/Q29012757',
    'http://www.wikidata.org/entity/Q29012785',
    'http://www.wikidata.org/entity/Q29012835',
    'http://www.wikidata.org/entity/Q29012915',
    'http://www.wikidata.org/entity/Q29013152',
    'http://www.wikidata.org/entity/Q29013238',
    'http://www.wikidata.org/entity/Q29013264',
    'http://www.wikidata.org/entity/Q29013475',
    'http://www.wikidata.org/entity/Q29013643',
    'http://www.wikidata.org/entity/Q29013657',
    'http://www.wikidata.org/entity/Q29013670',
    'http://www.wikidata.org/entity/Q29013760',
    'http://www.wikidata.org/entity/Q29013788',
    'http://www.wikidata.org/entity/Q29013815',
    'http://www.wikidata.org/entity/Q29013831',
    'http://www.wikidata.org/entity/Q29014175',
    'http://www.wikidata.org/entity/Q29014320',
    'http://www.wikidata.org/entity/Q29014345',
    'http://www.wikidata.org/entity/Q29014502',
    'http://www.wikidata.org/entity/Q29014536',
    'http://www.wikidata.org/entity/Q29026666',
    'http://www.wikidata.org/entity/Q29026786',
    'http://www.wikidata.org/entity/Q29026879',
    'http://www.wikidata.org/entity/Q29026993',
    'http://www.wikidata.org/entity/Q29027476',
    'http://www.wikidata.org/entity/Q29028192',
    'http://www.wikidata.org/entity/Q29028208',
    'http://www.wikidata.org/entity/Q29028258',
    'http://www.wikidata.org/entity/Q29028284',
    'http://www.wikidata.org/entity/Q29028421',
    'http://www.wikidata.org/entity/Q29028446',
    'http://www.wikidata.org/entity/Q29028595',
    'http://www.wikidata.org/entity/Q29028874',
    'http://www.wikidata.org/entity/Q29028915',
    'http://www.wikidata.org/entity/Q29029006',
    'http://www.wikidata.org/entity/Q29029019',
    'http://www.wikidata.org/entity/Q29029259',
    'http://www.wikidata.org/entity/Q29029314',
    'http://www.wikidata.org/entity/Q29029315',
    'http://www.wikidata.org/entity/Q29029448',
    'http://www.wikidata.org/entity/Q29029582',
    'http://www.wikidata.org/entity/Q29029687',
    'http://www.wikidata.org/entity/Q29029757',
    'http://www.wikidata.org/entity/Q29030043',
    'http://www.wikidata.org/entity/Q29030077',
    'http://www.wikidata.org/entity/Q29030218',
    'http://www.wikidata.org/entity/Q29030232',
    'http://www.wikidata.org/entity/Q29030367',
    'http://www.wikidata.org/entity/Q29030555',
    'http://www.wikidata.org/entity/Q29030558',
    'http://www.wikidata.org/entity/Q29030604',
    'http://www.wikidata.org/entity/Q29030695',
    'http://www.wikidata.org/entity/Q29030727',
    'http://www.wikidata.org/entity/Q29030744',
    'http://www.wikidata.org/entity/Q29030969',
    'http://www.wikidata.org/entity/Q29031162',
    'http://www.wikidata.org/entity/Q29031455',
    'http://www.wikidata.org/entity/Q29031758',
    'http://www.wikidata.org/entity/Q29031769',
    'http://www.wikidata.org/entity/Q29031873',
    'http://www.wikidata.org/entity/Q29031966',
    'http://www.wikidata.org/entity/Q29032012',
    'http://www.wikidata.org/entity/Q29032095',
    'http://www.wikidata.org/entity/Q29032132',
    'http://www.wikidata.org/entity/Q29035699',
    'http://www.wikidata.org/entity/Q29035812',
    'http://www.wikidata.org/entity/Q29035814',
    'http://www.wikidata.org/entity/Q29036085',
    'http://www.wikidata.org/entity/Q29036127',
    'http://www.wikidata.org/entity/Q29036279',
    'http://www.wikidata.org/entity/Q29036580',
    'http://www.wikidata.org/entity/Q29036760',
    'http://www.wikidata.org/entity/Q29036830',
    'http://www.wikidata.org/entity/Q29036840',
    'http://www.wikidata.org/entity/Q29036858',
    'http://www.wikidata.org/entity/Q29036940',
    'http://www.wikidata.org/entity/Q29036992',
    'http://www.wikidata.org/entity/Q29037014',
    'http://www.wikidata.org/entity/Q29037307',
    'http://www.wikidata.org/entity/Q29037347',
    'http://www.wikidata.org/entity/Q29037518',
    'http://www.wikidata.org/entity/Q29037925',
    'http://www.wikidata.org/entity/Q29037949',
    'http://www.wikidata.org/entity/Q29038022',
    'http://www.wikidata.org/entity/Q29038108',
    'http://www.wikidata.org/entity/Q29038146',
    'http://www.wikidata.org/entity/Q29038323',
    'http://www.wikidata.org/entity/Q29038435',
    'http://www.wikidata.org/entity/Q29038554',
    'http://www.wikidata.org/entity/Q29038555',
    'http://www.wikidata.org/entity/Q29038606',
    'http://www.wikidata.org/entity/Q29038716',
    'http://www.wikidata.org/entity/Q29038941',
    'http://www.wikidata.org/entity/Q29039026',
    'http://www.wikidata.org/entity/Q29039052',
    'http://www.wikidata.org/entity/Q29039092',
    'http://www.wikidata.org/entity/Q29039105',
    'http://www.wikidata.org/entity/Q29039336',
    'http://www.wikidata.org/entity/Q29039487',
    'http://www.wikidata.org/entity/Q29039683',
    'http://www.wikidata.org/entity/Q29039690',
    'http://www.wikidata.org/entity/Q29039718',
    'http://www.wikidata.org/entity/Q29039768',
    'http://www.wikidata.org/entity/Q29039793',
    'http://www.wikidata.org/entity/Q29039910',
    'http://www.wikidata.org/entity/Q29040503',
    'http://www.wikidata.org/entity/Q29040561',
    'http://www.wikidata.org/entity/Q29041019',
    'http://www.wikidata.org/entity/Q29041098',
    'http://www.wikidata.org/entity/Q29041219',
    'http://www.wikidata.org/entity/Q29041244',
    'http://www.wikidata.org/entity/Q29041407',
    'http://www.wikidata.org/entity/Q29041443',
    'http://www.wikidata.org/entity/Q29041960',
    'http://www.wikidata.org/entity/Q29042046',
    'http://www.wikidata.org/entity/Q29042104',
    'http://www.wikidata.org/entity/Q29042252',
    'http://www.wikidata.org/entity/Q29042284',
    'http://www.wikidata.org/entity/Q29042326',
    'http://www.wikidata.org/entity/Q29042454',
    'http://www.wikidata.org/entity/Q29042458',
    'http://www.wikidata.org/entity/Q29042497',
    'http://www.wikidata.org/entity/Q29042507',
    'http://www.wikidata.org/entity/Q29042519',
    'http://www.wikidata.org/entity/Q29042710',
    'http://www.wikidata.org/entity/Q29043216',
    'http://www.wikidata.org/entity/Q29048140',
    'http://www.wikidata.org/entity/Q29048141',
    'http://www.wikidata.org/entity/Q29051526',
    'http://www.wikidata.org/entity/Q29147442',
    'http://www.wikidata.org/entity/Q29189750',
    'http://www.wikidata.org/entity/Q29196526',
    'http://www.wikidata.org/entity/Q29248363',
    'http://www.wikidata.org/entity/Q29299877',
    'http://www.wikidata.org/entity/Q29300155',
    'http://www.wikidata.org/entity/Q29300304',
    'http://www.wikidata.org/entity/Q29300741',
    'http://www.wikidata.org/entity/Q29300847',
    'http://www.wikidata.org/entity/Q29301027',
    'http://www.wikidata.org/entity/Q29301289',
    'http://www.wikidata.org/entity/Q29301392',
    'http://www.wikidata.org/entity/Q29301748',
    'http://www.wikidata.org/entity/Q29301793',
    'http://www.wikidata.org/entity/Q29301826',
    'http://www.wikidata.org/entity/Q29301836',
    'http://www.wikidata.org/entity/Q29301947',
    'http://www.wikidata.org/entity/Q29302169',
    'http://www.wikidata.org/entity/Q29302305',
    'http://www.wikidata.org/entity/Q29302307',
    'http://www.wikidata.org/entity/Q29302645',
    'http://www.wikidata.org/entity/Q29302686',
    'http://www.wikidata.org/entity/Q29302944',
    'http://www.wikidata.org/entity/Q29302951',
    'http://www.wikidata.org/entity/Q29303177',
    'http://www.wikidata.org/entity/Q29303487',
    'http://www.wikidata.org/entity/Q29303630',
    'http://www.wikidata.org/entity/Q29303646',
    'http://www.wikidata.org/entity/Q29303819',
    'http://www.wikidata.org/entity/Q29304271',
    'http://www.wikidata.org/entity/Q29304913',
    'http://www.wikidata.org/entity/Q29305058',
    'http://www.wikidata.org/entity/Q29305147',
    'http://www.wikidata.org/entity/Q29305377',
    'http://www.wikidata.org/entity/Q29305524',
    'http://www.wikidata.org/entity/Q29305711',
    'http://www.wikidata.org/entity/Q29305728',
    'http://www.wikidata.org/entity/Q29305818',
    'http://www.wikidata.org/entity/Q29307215',
    'http://www.wikidata.org/entity/Q29307487',
    'http://www.wikidata.org/entity/Q29308133',
    'http://www.wikidata.org/entity/Q29308426',
    'http://www.wikidata.org/entity/Q29308484',
    'http://www.wikidata.org/entity/Q29308526',
    'http://www.wikidata.org/entity/Q29346487',
    'http://www.wikidata.org/entity/Q29346491',
    'http://www.wikidata.org/entity/Q29346559',
    'http://www.wikidata.org/entity/Q29346774',
    'http://www.wikidata.org/entity/Q29347247',
    'http://www.wikidata.org/entity/Q29347250',
    'http://www.wikidata.org/entity/Q29349905',
    'http://www.wikidata.org/entity/Q29353865',
    'http://www.wikidata.org/entity/Q29353902',
    'http://www.wikidata.org/entity/Q29391144',
    'http://www.wikidata.org/entity/Q29391249',
    'http://www.wikidata.org/entity/Q29391257',
    'http://www.wikidata.org/entity/Q29391304',
    'http://www.wikidata.org/entity/Q29391363',
    'http://www.wikidata.org/entity/Q29391534',
    'http://www.wikidata.org/entity/Q29391553',
    'http://www.wikidata.org/entity/Q29391607',
    'http://www.wikidata.org/entity/Q29391683',
    'http://www.wikidata.org/entity/Q29391684',
    'http://www.wikidata.org/entity/Q29392153',
    'http://www.wikidata.org/entity/Q29392298',
    'http://www.wikidata.org/entity/Q29392338',
    'http://www.wikidata.org/entity/Q29392419',
    'http://www.wikidata.org/entity/Q29392696',
    'http://www.wikidata.org/entity/Q29392899',
    'http://www.wikidata.org/entity/Q29393008',
    'http://www.wikidata.org/entity/Q29393085',
    'http://www.wikidata.org/entity/Q29393314',
    'http://www.wikidata.org/entity/Q29393914',
    'http://www.wikidata.org/entity/Q29394090',
    'http://www.wikidata.org/entity/Q29394284',
    'http://www.wikidata.org/entity/Q29394444',
    'http://www.wikidata.org/entity/Q29394511',
    'http://www.wikidata.org/entity/Q29394534',
    'http://www.wikidata.org/entity/Q29394656',
    'http://www.wikidata.org/entity/Q29394687',
    'http://www.wikidata.org/entity/Q29394736',
    'http://www.wikidata.org/entity/Q29394898',
    'http://www.wikidata.org/entity/Q29394946',
    'http://www.wikidata.org/entity/Q29395028',
    'http://www.wikidata.org/entity/Q29395063',
    'http://www.wikidata.org/entity/Q29395121',
    'http://www.wikidata.org/entity/Q29395525',
    'http://www.wikidata.org/entity/Q29396027',
    'http://www.wikidata.org/entity/Q29396329',
    'http://www.wikidata.org/entity/Q29396371',
    'http://www.wikidata.org/entity/Q29396495',
    'http://www.wikidata.org/entity/Q29396595',
    'http://www.wikidata.org/entity/Q29396607',
    'http://www.wikidata.org/entity/Q29396727',
    'http://www.wikidata.org/entity/Q29396936',
    'http://www.wikidata.org/entity/Q29397010',
    'http://www.wikidata.org/entity/Q29397114',
    'http://www.wikidata.org/entity/Q29397287',
    'http://www.wikidata.org/entity/Q29397612',
    'http://www.wikidata.org/entity/Q29397661',
    'http://www.wikidata.org/entity/Q29397708',
    'http://www.wikidata.org/entity/Q29398219',
    'http://www.wikidata.org/entity/Q29398301',
    'http://www.wikidata.org/entity/Q29398392',
    'http://www.wikidata.org/entity/Q29398493',
    'http://www.wikidata.org/entity/Q29398514',
    'http://www.wikidata.org/entity/Q29398674',
    'http://www.wikidata.org/entity/Q29398818',
    'http://www.wikidata.org/entity/Q29399168',
    'http://www.wikidata.org/entity/Q29399404',
    'http://www.wikidata.org/entity/Q29399682',
    'http://www.wikidata.org/entity/Q29400253',
    'http://www.wikidata.org/entity/Q29400497',
    'http://www.wikidata.org/entity/Q29400573',
    'http://www.wikidata.org/entity/Q29400695',
    'http://www.wikidata.org/entity/Q29400817',
    'http://www.wikidata.org/entity/Q29400840',
    'http://www.wikidata.org/entity/Q29416989',
    'http://www.wikidata.org/entity/Q29416993',
    'http://www.wikidata.org/entity/Q29417000',
    'http://www.wikidata.org/entity/Q29417007',
    'http://www.wikidata.org/entity/Q29417009',
    'http://www.wikidata.org/entity/Q29417018',
    'http://www.wikidata.org/entity/Q29417023',
    'http://www.wikidata.org/entity/Q29417026',
    'http://www.wikidata.org/entity/Q29417032',
    'http://www.wikidata.org/entity/Q29417047',
    'http://www.wikidata.org/entity/Q29417081',
    'http://www.wikidata.org/entity/Q29417082',
    'http://www.wikidata.org/entity/Q29417084',
    'http://www.wikidata.org/entity/Q29417093',
    'http://www.wikidata.org/entity/Q29417104',
    'http://www.wikidata.org/entity/Q29417106',
    'http://www.wikidata.org/entity/Q29417111',
    'http://www.wikidata.org/entity/Q29417126',
    'http://www.wikidata.org/entity/Q29417130',
    'http://www.wikidata.org/entity/Q29417133',
    'http://www.wikidata.org/entity/Q29417138',
    'http://www.wikidata.org/entity/Q29417142',
    'http://www.wikidata.org/entity/Q29417143',
    'http://www.wikidata.org/entity/Q29417145',
    'http://www.wikidata.org/entity/Q29417150',
    'http://www.wikidata.org/entity/Q29465538',
    'http://www.wikidata.org/entity/Q29465775',
    'http://www.wikidata.org/entity/Q29465808',
    'http://www.wikidata.org/entity/Q29470864',
    'http://www.wikidata.org/entity/Q29540774',
    'http://www.wikidata.org/entity/Q29540789',
    'http://www.wikidata.org/entity/Q29540927',
    'http://www.wikidata.org/entity/Q29540951',
    'http://www.wikidata.org/entity/Q29541156',
    'http://www.wikidata.org/entity/Q29541186',
    'http://www.wikidata.org/entity/Q29541256',
    'http://www.wikidata.org/entity/Q29541281',
    'http://www.wikidata.org/entity/Q29541339',
    'http://www.wikidata.org/entity/Q29541502',
    'http://www.wikidata.org/entity/Q29541592',
    'http://www.wikidata.org/entity/Q29541719',
    'http://www.wikidata.org/entity/Q29542197',
    'http://www.wikidata.org/entity/Q29542272',
    'http://www.wikidata.org/entity/Q29542440',
    'http://www.wikidata.org/entity/Q29542481',
    'http://www.wikidata.org/entity/Q29542652',
    'http://www.wikidata.org/entity/Q29542681',
    'http://www.wikidata.org/entity/Q29543325',
    'http://www.wikidata.org/entity/Q29543370',
    'http://www.wikidata.org/entity/Q29543437',
    'http://www.wikidata.org/entity/Q29543452',
    'http://www.wikidata.org/entity/Q29543786',
    'http://www.wikidata.org/entity/Q29543923',
    'http://www.wikidata.org/entity/Q29544005',
    'http://www.wikidata.org/entity/Q29544271',
    'http://www.wikidata.org/entity/Q29544430',
    'http://www.wikidata.org/entity/Q29544435',
    'http://www.wikidata.org/entity/Q29544757',
    'http://www.wikidata.org/entity/Q29546512',
    'http://www.wikidata.org/entity/Q29546513',
    'http://www.wikidata.org/entity/Q29546515',
    'http://www.wikidata.org/entity/Q29546516',
    'http://www.wikidata.org/entity/Q29546517',
    'http://www.wikidata.org/entity/Q29546523',
    'http://www.wikidata.org/entity/Q29546524',
    'http://www.wikidata.org/entity/Q29547159',
    'http://www.wikidata.org/entity/Q29547160',
    'http://www.wikidata.org/entity/Q29547161',
    'http://www.wikidata.org/entity/Q29547162',
    'http://www.wikidata.org/entity/Q29547163',
    'http://www.wikidata.org/entity/Q29547164',
    'http://www.wikidata.org/entity/Q29547165',
    'http://www.wikidata.org/entity/Q29547166',
    'http://www.wikidata.org/entity/Q29547168',
    'http://www.wikidata.org/entity/Q29547169',
    'http://www.wikidata.org/entity/Q29547170',
    'http://www.wikidata.org/entity/Q29547172',
    'http://www.wikidata.org/entity/Q29547173',
    'http://www.wikidata.org/entity/Q29547174',
    'http://www.wikidata.org/entity/Q29547175',
    'http://www.wikidata.org/entity/Q29547177',
    'http://www.wikidata.org/entity/Q29547178',
    'http://www.wikidata.org/entity/Q29547179',
    'http://www.wikidata.org/entity/Q29547180',
    'http://www.wikidata.org/entity/Q29547181',
    'http://www.wikidata.org/entity/Q29547182',
    'http://www.wikidata.org/entity/Q29547183',
    'http://www.wikidata.org/entity/Q29547187',
    'http://www.wikidata.org/entity/Q29547188',
    'http://www.wikidata.org/entity/Q29547189',
    'http://www.wikidata.org/entity/Q29547190',
    'http://www.wikidata.org/entity/Q29547191',
    'http://www.wikidata.org/entity/Q29547192',
    'http://www.wikidata.org/entity/Q29547193',
    'http://www.wikidata.org/entity/Q29547194',
    'http://www.wikidata.org/entity/Q29547196',
    'http://www.wikidata.org/entity/Q29547197',
    'http://www.wikidata.org/entity/Q29547198',
    'http://www.wikidata.org/entity/Q29547199',
    'http://www.wikidata.org/entity/Q29547200',
    'http://www.wikidata.org/entity/Q29547201',
    'http://www.wikidata.org/entity/Q29547202',
    'http://www.wikidata.org/entity/Q29547203',
    'http://www.wikidata.org/entity/Q29547204',
    'http://www.wikidata.org/entity/Q29547206',
    'http://www.wikidata.org/entity/Q29547207',
    'http://www.wikidata.org/entity/Q29547208',
    'http://www.wikidata.org/entity/Q29547209',
    'http://www.wikidata.org/entity/Q29547210',
    'http://www.wikidata.org/entity/Q29547211',
    'http://www.wikidata.org/entity/Q29547213',
    'http://www.wikidata.org/entity/Q29547214',
    'http://www.wikidata.org/entity/Q29547215',
    'http://www.wikidata.org/entity/Q29547216',
    'http://www.wikidata.org/entity/Q29547217',
    'http://www.wikidata.org/entity/Q29547218',
    'http://www.wikidata.org/entity/Q29547219',
    'http://www.wikidata.org/entity/Q29547220',
    'http://www.wikidata.org/entity/Q29547221',
    'http://www.wikidata.org/entity/Q29547223',
    'http://www.wikidata.org/entity/Q29547224',
    'http://www.wikidata.org/entity/Q29547225',
    'http://www.wikidata.org/entity/Q29547226',
    'http://www.wikidata.org/entity/Q29547228',
    'http://www.wikidata.org/entity/Q29547229',
    'http://www.wikidata.org/entity/Q29547230',
    'http://www.wikidata.org/entity/Q29547231',
    'http://www.wikidata.org/entity/Q29547232',
    'http://www.wikidata.org/entity/Q29547234',
    'http://www.wikidata.org/entity/Q29547235',
    'http://www.wikidata.org/entity/Q29547236',
    'http://www.wikidata.org/entity/Q29547237',
    'http://www.wikidata.org/entity/Q29547239',
    'http://www.wikidata.org/entity/Q29547240',
    'http://www.wikidata.org/entity/Q29547242',
    'http://www.wikidata.org/entity/Q29547244',
    'http://www.wikidata.org/entity/Q29547245',
    'http://www.wikidata.org/entity/Q29547246',
    'http://www.wikidata.org/entity/Q29547247',
    'http://www.wikidata.org/entity/Q29547248',
    'http://www.wikidata.org/entity/Q29547249',
    'http://www.wikidata.org/entity/Q29547250',
    'http://www.wikidata.org/entity/Q29547251',
    'http://www.wikidata.org/entity/Q29547253',
    'http://www.wikidata.org/entity/Q29547254',
    'http://www.wikidata.org/entity/Q29547255',
    'http://www.wikidata.org/entity/Q29547256',
    'http://www.wikidata.org/entity/Q29547257',
    'http://www.wikidata.org/entity/Q29547258',
    'http://www.wikidata.org/entity/Q29547259',
    'http://www.wikidata.org/entity/Q29547260',
    'http://www.wikidata.org/entity/Q29547261',
    'http://www.wikidata.org/entity/Q29547262',
    'http://www.wikidata.org/entity/Q29547263',
    'http://www.wikidata.org/entity/Q29547265',
    'http://www.wikidata.org/entity/Q29547266',
    'http://www.wikidata.org/entity/Q29547267',
    'http://www.wikidata.org/entity/Q29547268',
    'http://www.wikidata.org/entity/Q29547269',
    'http://www.wikidata.org/entity/Q29547270',
    'http://www.wikidata.org/entity/Q29547271',
    'http://www.wikidata.org/entity/Q29547272',
    'http://www.wikidata.org/entity/Q29547273',
    'http://www.wikidata.org/entity/Q29547274',
    'http://www.wikidata.org/entity/Q29547276',
    'http://www.wikidata.org/entity/Q29547277',
    'http://www.wikidata.org/entity/Q29547278',
    'http://www.wikidata.org/entity/Q29547281',
    'http://www.wikidata.org/entity/Q29547282',
    'http://www.wikidata.org/entity/Q29547283',
    'http://www.wikidata.org/entity/Q29547284',
    'http://www.wikidata.org/entity/Q29547285',
    'http://www.wikidata.org/entity/Q29547286',
    'http://www.wikidata.org/entity/Q29547288',
    'http://www.wikidata.org/entity/Q29547289',
    'http://www.wikidata.org/entity/Q29547290',
    'http://www.wikidata.org/entity/Q29547292',
    'http://www.wikidata.org/entity/Q29547293',
    'http://www.wikidata.org/entity/Q29547294',
    'http://www.wikidata.org/entity/Q29547295',
    'http://www.wikidata.org/entity/Q29547296',
    'http://www.wikidata.org/entity/Q29547297',
    'http://www.wikidata.org/entity/Q29547299',
    'http://www.wikidata.org/entity/Q29547300',
    'http://www.wikidata.org/entity/Q29547301',
    'http://www.wikidata.org/entity/Q29547302',
    'http://www.wikidata.org/entity/Q29547303',
    'http://www.wikidata.org/entity/Q29547304',
    'http://www.wikidata.org/entity/Q29547305',
    'http://www.wikidata.org/entity/Q29547306',
    'http://www.wikidata.org/entity/Q29547307',
    'http://www.wikidata.org/entity/Q29547308',
    'http://www.wikidata.org/entity/Q29547310',
    'http://www.wikidata.org/entity/Q29547311',
    'http://www.wikidata.org/entity/Q29547312',
    'http://www.wikidata.org/entity/Q29547313',
    'http://www.wikidata.org/entity/Q29547314',
    'http://www.wikidata.org/entity/Q29547315',
    'http://www.wikidata.org/entity/Q29547316',
    'http://www.wikidata.org/entity/Q29547317',
    'http://www.wikidata.org/entity/Q29547318',
    'http://www.wikidata.org/entity/Q29547320',
    'http://www.wikidata.org/entity/Q29547321',
    'http://www.wikidata.org/entity/Q29547322',
    'http://www.wikidata.org/entity/Q29547323',
    'http://www.wikidata.org/entity/Q29547324',
    'http://www.wikidata.org/entity/Q29547325',
    'http://www.wikidata.org/entity/Q29547327',
    'http://www.wikidata.org/entity/Q29547330',
    'http://www.wikidata.org/entity/Q29547331',
    'http://www.wikidata.org/entity/Q29547332',
    'http://www.wikidata.org/entity/Q29547333',
    'http://www.wikidata.org/entity/Q29547334',
    'http://www.wikidata.org/entity/Q29547336',
    'http://www.wikidata.org/entity/Q29547337',
    'http://www.wikidata.org/entity/Q29547338',
    'http://www.wikidata.org/entity/Q29547339',
    'http://www.wikidata.org/entity/Q29547340',
    'http://www.wikidata.org/entity/Q29547343',
    'http://www.wikidata.org/entity/Q29547344',
    'http://www.wikidata.org/entity/Q29547345',
    'http://www.wikidata.org/entity/Q29547346',
    'http://www.wikidata.org/entity/Q29547347',
    'http://www.wikidata.org/entity/Q29547348',
    'http://www.wikidata.org/entity/Q29547349',
    'http://www.wikidata.org/entity/Q29547350',
    'http://www.wikidata.org/entity/Q29547351',
    'http://www.wikidata.org/entity/Q29547353',
    'http://www.wikidata.org/entity/Q29547354',
    'http://www.wikidata.org/entity/Q29547355',
    'http://www.wikidata.org/entity/Q29547356',
    'http://www.wikidata.org/entity/Q29547357',
    'http://www.wikidata.org/entity/Q29547358',
    'http://www.wikidata.org/entity/Q29547359',
    'http://www.wikidata.org/entity/Q29547360',
    'http://www.wikidata.org/entity/Q29547361',
    'http://www.wikidata.org/entity/Q29547362',
    'http://www.wikidata.org/entity/Q29547363',
    'http://www.wikidata.org/entity/Q29547365',
    'http://www.wikidata.org/entity/Q29547366',
    'http://www.wikidata.org/entity/Q29547367',
    'http://www.wikidata.org/entity/Q29547368',
    'http://www.wikidata.org/entity/Q29547369',
    'http://www.wikidata.org/entity/Q29547370',
    'http://www.wikidata.org/entity/Q29547371',
    'http://www.wikidata.org/entity/Q29547372',
    'http://www.wikidata.org/entity/Q29547374',
    'http://www.wikidata.org/entity/Q29547376',
    'http://www.wikidata.org/entity/Q29547377',
    'http://www.wikidata.org/entity/Q29547378',
    'http://www.wikidata.org/entity/Q29547379',
    'http://www.wikidata.org/entity/Q29547380',
    'http://www.wikidata.org/entity/Q29547381',
    'http://www.wikidata.org/entity/Q29547382',
    'http://www.wikidata.org/entity/Q29547383',
    'http://www.wikidata.org/entity/Q29547384',
    'http://www.wikidata.org/entity/Q29547385',
    'http://www.wikidata.org/entity/Q29547388',
    'http://www.wikidata.org/entity/Q29547389',
    'http://www.wikidata.org/entity/Q29547391',
    'http://www.wikidata.org/entity/Q29547392',
    'http://www.wikidata.org/entity/Q29547393',
    'http://www.wikidata.org/entity/Q29547394',
    'http://www.wikidata.org/entity/Q29547395',
    'http://www.wikidata.org/entity/Q29547396',
    'http://www.wikidata.org/entity/Q29547398',
    'http://www.wikidata.org/entity/Q29547400',
    'http://www.wikidata.org/entity/Q29547401',
    'http://www.wikidata.org/entity/Q29547402',
    'http://www.wikidata.org/entity/Q29547403',
    'http://www.wikidata.org/entity/Q29547404',
    'http://www.wikidata.org/entity/Q29547405',
    'http://www.wikidata.org/entity/Q29547406',
    'http://www.wikidata.org/entity/Q29547407',
    'http://www.wikidata.org/entity/Q29547408',
    'http://www.wikidata.org/entity/Q29547410',
    'http://www.wikidata.org/entity/Q29547413',
    'http://www.wikidata.org/entity/Q29547414',
    'http://www.wikidata.org/entity/Q29547415',
    'http://www.wikidata.org/entity/Q29547416',
    'http://www.wikidata.org/entity/Q29547417',
    'http://www.wikidata.org/entity/Q29547418',
    'http://www.wikidata.org/entity/Q29547419',
    'http://www.wikidata.org/entity/Q29547420',
    'http://www.wikidata.org/entity/Q29547421',
    'http://www.wikidata.org/entity/Q29547423',
    'http://www.wikidata.org/entity/Q29547424',
    'http://www.wikidata.org/entity/Q29547425',
    'http://www.wikidata.org/entity/Q29547426',
    'http://www.wikidata.org/entity/Q29547427',
    'http://www.wikidata.org/entity/Q29547428',
    'http://www.wikidata.org/entity/Q29547429',
    'http://www.wikidata.org/entity/Q29547430',
    'http://www.wikidata.org/entity/Q29547431',
    'http://www.wikidata.org/entity/Q29547432',
    'http://www.wikidata.org/entity/Q29547434',
    'http://www.wikidata.org/entity/Q29547435',
    'http://www.wikidata.org/entity/Q29547436',
    'http://www.wikidata.org/entity/Q29547437',
    'http://www.wikidata.org/entity/Q29547438',
    'http://www.wikidata.org/entity/Q29547439',
    'http://www.wikidata.org/entity/Q29547440',
    'http://www.wikidata.org/entity/Q29547441',
    'http://www.wikidata.org/entity/Q29547442',
    'http://www.wikidata.org/entity/Q29547443',
    'http://www.wikidata.org/entity/Q29547445',
    'http://www.wikidata.org/entity/Q29547446',
    'http://www.wikidata.org/entity/Q29547447',
    'http://www.wikidata.org/entity/Q29547448',
    'http://www.wikidata.org/entity/Q29547449',
    'http://www.wikidata.org/entity/Q29547450',
    'http://www.wikidata.org/entity/Q29547451',
    'http://www.wikidata.org/entity/Q29547452',
    'http://www.wikidata.org/entity/Q29547453',
    'http://www.wikidata.org/entity/Q29547454',
    'http://www.wikidata.org/entity/Q29547456',
    'http://www.wikidata.org/entity/Q29547457',
    'http://www.wikidata.org/entity/Q29547458',
    'http://www.wikidata.org/entity/Q29547460',
    'http://www.wikidata.org/entity/Q29547461',
    'http://www.wikidata.org/entity/Q29547462',
    'http://www.wikidata.org/entity/Q29547463',
    'http://www.wikidata.org/entity/Q29547464',
    'http://www.wikidata.org/entity/Q29547465',
    'http://www.wikidata.org/entity/Q29547467',
    'http://www.wikidata.org/entity/Q29547468',
    'http://www.wikidata.org/entity/Q29547469',
    'http://www.wikidata.org/entity/Q29547470',
    'http://www.wikidata.org/entity/Q29547471',
    'http://www.wikidata.org/entity/Q29547472',
    'http://www.wikidata.org/entity/Q29547473',
    'http://www.wikidata.org/entity/Q29547474',
    'http://www.wikidata.org/entity/Q29547475',
    'http://www.wikidata.org/entity/Q29547476',
    'http://www.wikidata.org/entity/Q29547478',
    'http://www.wikidata.org/entity/Q29547479',
    'http://www.wikidata.org/entity/Q29547480',
    'http://www.wikidata.org/entity/Q29547481',
    'http://www.wikidata.org/entity/Q29547482',
    'http://www.wikidata.org/entity/Q29547483',
    'http://www.wikidata.org/entity/Q29547484',
    'http://www.wikidata.org/entity/Q29547485',
    'http://www.wikidata.org/entity/Q29547486',
    'http://www.wikidata.org/entity/Q29547487',
    'http://www.wikidata.org/entity/Q29547489',
    'http://www.wikidata.org/entity/Q29547490',
    'http://www.wikidata.org/entity/Q29547491',
    'http://www.wikidata.org/entity/Q29547492',
    'http://www.wikidata.org/entity/Q29547493',
    'http://www.wikidata.org/entity/Q29547494',
    'http://www.wikidata.org/entity/Q29547495',
    'http://www.wikidata.org/entity/Q29547496',
    'http://www.wikidata.org/entity/Q29547497',
    'http://www.wikidata.org/entity/Q29547498',
    'http://www.wikidata.org/entity/Q29547500',
    'http://www.wikidata.org/entity/Q29547501',
    'http://www.wikidata.org/entity/Q29547502',
    'http://www.wikidata.org/entity/Q29547503',
    'http://www.wikidata.org/entity/Q29547504',
    'http://www.wikidata.org/entity/Q29547505',
    'http://www.wikidata.org/entity/Q29547506',
    'http://www.wikidata.org/entity/Q29547507',
    'http://www.wikidata.org/entity/Q29547508',
    'http://www.wikidata.org/entity/Q29547509',
    'http://www.wikidata.org/entity/Q29547511',
    'http://www.wikidata.org/entity/Q29547512',
    'http://www.wikidata.org/entity/Q29547513',
    'http://www.wikidata.org/entity/Q29547514',
    'http://www.wikidata.org/entity/Q29547515',
    'http://www.wikidata.org/entity/Q29547516',
    'http://www.wikidata.org/entity/Q29547517',
    'http://www.wikidata.org/entity/Q29547518',
    'http://www.wikidata.org/entity/Q29547519',
    'http://www.wikidata.org/entity/Q29547520',
    'http://www.wikidata.org/entity/Q29547522',
    'http://www.wikidata.org/entity/Q29547523',
    'http://www.wikidata.org/entity/Q29547524',
    'http://www.wikidata.org/entity/Q29547525',
    'http://www.wikidata.org/entity/Q29547526',
    'http://www.wikidata.org/entity/Q29547527',
    'http://www.wikidata.org/entity/Q29547528',
    'http://www.wikidata.org/entity/Q29547529',
    'http://www.wikidata.org/entity/Q29547530',
    'http://www.wikidata.org/entity/Q29547531',
    'http://www.wikidata.org/entity/Q29547532',
    'http://www.wikidata.org/entity/Q29547534',
    'http://www.wikidata.org/entity/Q29547535',
    'http://www.wikidata.org/entity/Q29547536',
    'http://www.wikidata.org/entity/Q29547537',
    'http://www.wikidata.org/entity/Q29547538',
    'http://www.wikidata.org/entity/Q29547539',
    'http://www.wikidata.org/entity/Q29547540',
    'http://www.wikidata.org/entity/Q29547541',
    'http://www.wikidata.org/entity/Q29547542',
    'http://www.wikidata.org/entity/Q29547544',
    'http://www.wikidata.org/entity/Q29547545',
    'http://www.wikidata.org/entity/Q29547546',
    'http://www.wikidata.org/entity/Q29547547',
    'http://www.wikidata.org/entity/Q29547548',
    'http://www.wikidata.org/entity/Q29547549',
    'http://www.wikidata.org/entity/Q29547550',
    'http://www.wikidata.org/entity/Q29547551',
    'http://www.wikidata.org/entity/Q29547552',
    'http://www.wikidata.org/entity/Q29547554',
    'http://www.wikidata.org/entity/Q29547555',
    'http://www.wikidata.org/entity/Q29547556',
    'http://www.wikidata.org/entity/Q29547557',
    'http://www.wikidata.org/entity/Q29547558',
    'http://www.wikidata.org/entity/Q29547559',
    'http://www.wikidata.org/entity/Q29547560',
    'http://www.wikidata.org/entity/Q29547561',
    'http://www.wikidata.org/entity/Q29547562',
    'http://www.wikidata.org/entity/Q29547564',
    'http://www.wikidata.org/entity/Q29547565',
    'http://www.wikidata.org/entity/Q29547566',
    'http://www.wikidata.org/entity/Q29547567',
    'http://www.wikidata.org/entity/Q29547568',
    'http://www.wikidata.org/entity/Q29547569',
    'http://www.wikidata.org/entity/Q29547570',
    'http://www.wikidata.org/entity/Q29547571',
    'http://www.wikidata.org/entity/Q29547572',
    'http://www.wikidata.org/entity/Q29547574',
    'http://www.wikidata.org/entity/Q29547575',
    'http://www.wikidata.org/entity/Q29547576',
    'http://www.wikidata.org/entity/Q29547577',
    'http://www.wikidata.org/entity/Q29547578',
    'http://www.wikidata.org/entity/Q29547581',
    'http://www.wikidata.org/entity/Q29547582',
    'http://www.wikidata.org/entity/Q29547583',
    'http://www.wikidata.org/entity/Q29547584',
    'http://www.wikidata.org/entity/Q29547585',
    'http://www.wikidata.org/entity/Q29547586',
    'http://www.wikidata.org/entity/Q29547589',
    'http://www.wikidata.org/entity/Q29547590',
    'http://www.wikidata.org/entity/Q29547591',
    'http://www.wikidata.org/entity/Q29547592',
    'http://www.wikidata.org/entity/Q29547593',
    'http://www.wikidata.org/entity/Q29547594',
    'http://www.wikidata.org/entity/Q29547595',
    'http://www.wikidata.org/entity/Q29547596',
    'http://www.wikidata.org/entity/Q29547598',
    'http://www.wikidata.org/entity/Q29547599',
    'http://www.wikidata.org/entity/Q29547600',
    'http://www.wikidata.org/entity/Q29547601',
    'http://www.wikidata.org/entity/Q29547603',
    'http://www.wikidata.org/entity/Q29547604',
    'http://www.wikidata.org/entity/Q29547605',
    'http://www.wikidata.org/entity/Q29547606',
    'http://www.wikidata.org/entity/Q29547607',
    'http://www.wikidata.org/entity/Q29547609',
    'http://www.wikidata.org/entity/Q29547610',
    'http://www.wikidata.org/entity/Q29547611',
    'http://www.wikidata.org/entity/Q29547612',
    'http://www.wikidata.org/entity/Q29547613',
    'http://www.wikidata.org/entity/Q29547614',
    'http://www.wikidata.org/entity/Q29547615',
    'http://www.wikidata.org/entity/Q29547616',
    'http://www.wikidata.org/entity/Q29547617',
    'http://www.wikidata.org/entity/Q29547619',
    'http://www.wikidata.org/entity/Q29547620',
    'http://www.wikidata.org/entity/Q29547621',
    'http://www.wikidata.org/entity/Q29547622',
    'http://www.wikidata.org/entity/Q29547623',
    'http://www.wikidata.org/entity/Q29547624',
    'http://www.wikidata.org/entity/Q29547625',
    'http://www.wikidata.org/entity/Q29547626',
    'http://www.wikidata.org/entity/Q29547627',
    'http://www.wikidata.org/entity/Q29547628',
    'http://www.wikidata.org/entity/Q29547630',
    'http://www.wikidata.org/entity/Q29547631',
    'http://www.wikidata.org/entity/Q29547632',
    'http://www.wikidata.org/entity/Q29547633',
    'http://www.wikidata.org/entity/Q29547634',
    'http://www.wikidata.org/entity/Q29547635',
    'http://www.wikidata.org/entity/Q29547637',
    'http://www.wikidata.org/entity/Q29547638',
    'http://www.wikidata.org/entity/Q29547639',
    'http://www.wikidata.org/entity/Q29547640',
    'http://www.wikidata.org/entity/Q29547642',
    'http://www.wikidata.org/entity/Q29547643',
    'http://www.wikidata.org/entity/Q29547645',
    'http://www.wikidata.org/entity/Q29547646',
    'http://www.wikidata.org/entity/Q29547647',
    'http://www.wikidata.org/entity/Q29547648',
    'http://www.wikidata.org/entity/Q29547649',
    'http://www.wikidata.org/entity/Q29547650',
    'http://www.wikidata.org/entity/Q29547651',
    'http://www.wikidata.org/entity/Q29547653',
    'http://www.wikidata.org/entity/Q29547654',
    'http://www.wikidata.org/entity/Q29547655',
    'http://www.wikidata.org/entity/Q29547656',
    'http://www.wikidata.org/entity/Q29547657',
    'http://www.wikidata.org/entity/Q29547658',
    'http://www.wikidata.org/entity/Q29547659',
    'http://www.wikidata.org/entity/Q29547660',
    'http://www.wikidata.org/entity/Q29547661',
    'http://www.wikidata.org/entity/Q29547663',
    'http://www.wikidata.org/entity/Q29547664',
    'http://www.wikidata.org/entity/Q29547665',
    'http://www.wikidata.org/entity/Q29547666',
    'http://www.wikidata.org/entity/Q29547667',
    'http://www.wikidata.org/entity/Q29547668',
    'http://www.wikidata.org/entity/Q29547669',
    'http://www.wikidata.org/entity/Q29547670',
    'http://www.wikidata.org/entity/Q29547671',
    'http://www.wikidata.org/entity/Q29547672',
    'http://www.wikidata.org/entity/Q29547673',
    'http://www.wikidata.org/entity/Q29547675',
    'http://www.wikidata.org/entity/Q29547676',
    'http://www.wikidata.org/entity/Q29547677',
    'http://www.wikidata.org/entity/Q29547678',
    'http://www.wikidata.org/entity/Q29547679',
    'http://www.wikidata.org/entity/Q29547680',
    'http://www.wikidata.org/entity/Q29547681',
    'http://www.wikidata.org/entity/Q29547682',
    'http://www.wikidata.org/entity/Q29547683',
    'http://www.wikidata.org/entity/Q29547684',
    'http://www.wikidata.org/entity/Q29547686',
    'http://www.wikidata.org/entity/Q29547687',
    'http://www.wikidata.org/entity/Q29547688',
    'http://www.wikidata.org/entity/Q29547689',
    'http://www.wikidata.org/entity/Q29547690',
    'http://www.wikidata.org/entity/Q29547691',
    'http://www.wikidata.org/entity/Q29547692',
    'http://www.wikidata.org/entity/Q29547693',
    'http://www.wikidata.org/entity/Q29547695',
    'http://www.wikidata.org/entity/Q29547696',
    'http://www.wikidata.org/entity/Q29547697',
    'http://www.wikidata.org/entity/Q29547698',
    'http://www.wikidata.org/entity/Q29547699',
    'http://www.wikidata.org/entity/Q29547700',
    'http://www.wikidata.org/entity/Q29547701',
    'http://www.wikidata.org/entity/Q29547702',
    'http://www.wikidata.org/entity/Q29547703',
    'http://www.wikidata.org/entity/Q29547704',
    'http://www.wikidata.org/entity/Q29547705',
    'http://www.wikidata.org/entity/Q29547708',
    'http://www.wikidata.org/entity/Q29547709',
    'http://www.wikidata.org/entity/Q29547711',
    'http://www.wikidata.org/entity/Q29547712',
    'http://www.wikidata.org/entity/Q29547713',
    'http://www.wikidata.org/entity/Q29547714',
    'http://www.wikidata.org/entity/Q29547715',
    'http://www.wikidata.org/entity/Q29547716',
    'http://www.wikidata.org/entity/Q29547718',
    'http://www.wikidata.org/entity/Q29547719',
    'http://www.wikidata.org/entity/Q29547720',
    'http://www.wikidata.org/entity/Q29547721',
    'http://www.wikidata.org/entity/Q29547722',
    'http://www.wikidata.org/entity/Q29547723',
    'http://www.wikidata.org/entity/Q29547724',
    'http://www.wikidata.org/entity/Q29547725',
    'http://www.wikidata.org/entity/Q29547726',
    'http://www.wikidata.org/entity/Q29547727',
    'http://www.wikidata.org/entity/Q29547729',
    'http://www.wikidata.org/entity/Q29547730',
    'http://www.wikidata.org/entity/Q29547731',
    'http://www.wikidata.org/entity/Q29547732',
    'http://www.wikidata.org/entity/Q29547733',
    'http://www.wikidata.org/entity/Q29547734',
    'http://www.wikidata.org/entity/Q29547735',
    'http://www.wikidata.org/entity/Q29547736',
    'http://www.wikidata.org/entity/Q29547737',
    'http://www.wikidata.org/entity/Q29547738',
    'http://www.wikidata.org/entity/Q29547740',
    'http://www.wikidata.org/entity/Q29547741',
    'http://www.wikidata.org/entity/Q29547743',
    'http://www.wikidata.org/entity/Q29547744',
    'http://www.wikidata.org/entity/Q29547745',
    'http://www.wikidata.org/entity/Q29547746',
    'http://www.wikidata.org/entity/Q29547748',
    'http://www.wikidata.org/entity/Q29547749',
    'http://www.wikidata.org/entity/Q29547751',
    'http://www.wikidata.org/entity/Q29547752',
    'http://www.wikidata.org/entity/Q29547753',
    'http://www.wikidata.org/entity/Q29547754',
    'http://www.wikidata.org/entity/Q29547755',
    'http://www.wikidata.org/entity/Q29547756',
    'http://www.wikidata.org/entity/Q29547757',
    'http://www.wikidata.org/entity/Q29547758',
    'http://www.wikidata.org/entity/Q29547759',
    'http://www.wikidata.org/entity/Q29547760',
    'http://www.wikidata.org/entity/Q29547763',
    'http://www.wikidata.org/entity/Q29547764',
    'http://www.wikidata.org/entity/Q29547765',
    'http://www.wikidata.org/entity/Q29547766',
    'http://www.wikidata.org/entity/Q29547767',
    'http://www.wikidata.org/entity/Q29547768',
    'http://www.wikidata.org/entity/Q29547769',
    'http://www.wikidata.org/entity/Q29547770',
    'http://www.wikidata.org/entity/Q29547771',
    'http://www.wikidata.org/entity/Q29547772',
    'http://www.wikidata.org/entity/Q29547773',
    'http://www.wikidata.org/entity/Q29547775',
    'http://www.wikidata.org/entity/Q29547776',
    'http://www.wikidata.org/entity/Q29547777',
    'http://www.wikidata.org/entity/Q29547778',
    'http://www.wikidata.org/entity/Q29547781',
    'http://www.wikidata.org/entity/Q29547785',
    'http://www.wikidata.org/entity/Q29547787',
    'http://www.wikidata.org/entity/Q29547788',
    'http://www.wikidata.org/entity/Q29547789',
    'http://www.wikidata.org/entity/Q29547790',
    'http://www.wikidata.org/entity/Q29547791',
    'http://www.wikidata.org/entity/Q29547792',
    'http://www.wikidata.org/entity/Q29547793',
    'http://www.wikidata.org/entity/Q29547794',
    'http://www.wikidata.org/entity/Q29547795',
    'http://www.wikidata.org/entity/Q29547796',
    'http://www.wikidata.org/entity/Q29547800',
    'http://www.wikidata.org/entity/Q29547802',
    'http://www.wikidata.org/entity/Q29547803',
    'http://www.wikidata.org/entity/Q29547804',
    'http://www.wikidata.org/entity/Q29547805',
    'http://www.wikidata.org/entity/Q29547806',
    'http://www.wikidata.org/entity/Q29547807',
    'http://www.wikidata.org/entity/Q29547808',
    'http://www.wikidata.org/entity/Q29547812',
    'http://www.wikidata.org/entity/Q29547813',
    'http://www.wikidata.org/entity/Q29547814',
    'http://www.wikidata.org/entity/Q29547815',
    'http://www.wikidata.org/entity/Q29547816',
    'http://www.wikidata.org/entity/Q29547818',
    'http://www.wikidata.org/entity/Q29547819',
    'http://www.wikidata.org/entity/Q29547820',
    'http://www.wikidata.org/entity/Q29547822',
    'http://www.wikidata.org/entity/Q29547823',
    'http://www.wikidata.org/entity/Q29547824',
    'http://www.wikidata.org/entity/Q29547825',
    'http://www.wikidata.org/entity/Q29547826',
    'http://www.wikidata.org/entity/Q29547827',
    'http://www.wikidata.org/entity/Q29547828',
    'http://www.wikidata.org/entity/Q29547830',
    'http://www.wikidata.org/entity/Q29547833',
    'http://www.wikidata.org/entity/Q29547834',
    'http://www.wikidata.org/entity/Q29547835',
    'http://www.wikidata.org/entity/Q29547836',
    'http://www.wikidata.org/entity/Q29547837',
    'http://www.wikidata.org/entity/Q29547838',
    'http://www.wikidata.org/entity/Q29547839',
    'http://www.wikidata.org/entity/Q29547840',
    'http://www.wikidata.org/entity/Q29547841',
    'http://www.wikidata.org/entity/Q29547842',
    'http://www.wikidata.org/entity/Q29547844',
    'http://www.wikidata.org/entity/Q29547845',
    'http://www.wikidata.org/entity/Q29547846',
    'http://www.wikidata.org/entity/Q29547847',
    'http://www.wikidata.org/entity/Q29547848',
    'http://www.wikidata.org/entity/Q29547849',
    'http://www.wikidata.org/entity/Q29547850',
    'http://www.wikidata.org/entity/Q29547851',
    'http://www.wikidata.org/entity/Q29547852',
    'http://www.wikidata.org/entity/Q29547853',
    'http://www.wikidata.org/entity/Q29547855',
    'http://www.wikidata.org/entity/Q29547856',
    'http://www.wikidata.org/entity/Q29547857',
    'http://www.wikidata.org/entity/Q29547859',
    'http://www.wikidata.org/entity/Q29547860',
    'http://www.wikidata.org/entity/Q29547861',
    'http://www.wikidata.org/entity/Q29547862',
    'http://www.wikidata.org/entity/Q29547863',
    'http://www.wikidata.org/entity/Q29547864',
    'http://www.wikidata.org/entity/Q29547865',
    'http://www.wikidata.org/entity/Q29547867',
    'http://www.wikidata.org/entity/Q29547868',
    'http://www.wikidata.org/entity/Q29547869',
    'http://www.wikidata.org/entity/Q29547870',
    'http://www.wikidata.org/entity/Q29547871',
    'http://www.wikidata.org/entity/Q29547872',
    'http://www.wikidata.org/entity/Q29547873',
    'http://www.wikidata.org/entity/Q29547874',
    'http://www.wikidata.org/entity/Q29547875',
    'http://www.wikidata.org/entity/Q29547876',
    'http://www.wikidata.org/entity/Q29547877',
    'http://www.wikidata.org/entity/Q29547879',
    'http://www.wikidata.org/entity/Q29547880',
    'http://www.wikidata.org/entity/Q29547881',
    'http://www.wikidata.org/entity/Q29547882',
    'http://www.wikidata.org/entity/Q29547883',
    'http://www.wikidata.org/entity/Q29547884',
    'http://www.wikidata.org/entity/Q29547885',
    'http://www.wikidata.org/entity/Q29547886',
    'http://www.wikidata.org/entity/Q29547887',
    'http://www.wikidata.org/entity/Q29547888',
    'http://www.wikidata.org/entity/Q29547889',
    'http://www.wikidata.org/entity/Q29547891',
    'http://www.wikidata.org/entity/Q29547892',
    'http://www.wikidata.org/entity/Q29547893',
    'http://www.wikidata.org/entity/Q29547894',
    'http://www.wikidata.org/entity/Q29547895',
    'http://www.wikidata.org/entity/Q29547896',
    'http://www.wikidata.org/entity/Q29547897',
    'http://www.wikidata.org/entity/Q29547900',
    'http://www.wikidata.org/entity/Q29547901',
    'http://www.wikidata.org/entity/Q29547902',
    'http://www.wikidata.org/entity/Q29547903',
    'http://www.wikidata.org/entity/Q29547905',
    'http://www.wikidata.org/entity/Q29547906',
    'http://www.wikidata.org/entity/Q29547907',
    'http://www.wikidata.org/entity/Q29547908',
    'http://www.wikidata.org/entity/Q29547909',
    'http://www.wikidata.org/entity/Q29547911',
    'http://www.wikidata.org/entity/Q29547912',
    'http://www.wikidata.org/entity/Q29547913',
    'http://www.wikidata.org/entity/Q29547914',
    'http://www.wikidata.org/entity/Q29547915',
    'http://www.wikidata.org/entity/Q29547917',
    'http://www.wikidata.org/entity/Q29547919',
    'http://www.wikidata.org/entity/Q29547922',
    'http://www.wikidata.org/entity/Q29547923',
    'http://www.wikidata.org/entity/Q29555842',
    'http://www.wikidata.org/entity/Q29555844',
    'http://www.wikidata.org/entity/Q29555845',
    'http://www.wikidata.org/entity/Q29555846',
    'http://www.wikidata.org/entity/Q29555850',
    'http://www.wikidata.org/entity/Q29555851',
    'http://www.wikidata.org/entity/Q29555853',
    'http://www.wikidata.org/entity/Q29577114',
    'http://www.wikidata.org/entity/Q29614171',
    'http://www.wikidata.org/entity/Q29614172',
    'http://www.wikidata.org/entity/Q29614173',
    'http://www.wikidata.org/entity/Q29614174',
    'http://www.wikidata.org/entity/Q29614175',
    'http://www.wikidata.org/entity/Q29614176',
    'http://www.wikidata.org/entity/Q29614177',
    'http://www.wikidata.org/entity/Q29614178',
    'http://www.wikidata.org/entity/Q29614179',
    'http://www.wikidata.org/entity/Q29614180',
    'http://www.wikidata.org/entity/Q29614181',
    'http://www.wikidata.org/entity/Q29614183',
    'http://www.wikidata.org/entity/Q29614184',
    'http://www.wikidata.org/entity/Q29614185',
    'http://www.wikidata.org/entity/Q29614187',
    'http://www.wikidata.org/entity/Q29614188',
    'http://www.wikidata.org/entity/Q29614189',
    'http://www.wikidata.org/entity/Q29614190',
    'http://www.wikidata.org/entity/Q29614191',
    'http://www.wikidata.org/entity/Q29614192',
    'http://www.wikidata.org/entity/Q29614193',
    'http://www.wikidata.org/entity/Q29614194',
    'http://www.wikidata.org/entity/Q29614195',
    'http://www.wikidata.org/entity/Q29614196',
    'http://www.wikidata.org/entity/Q29614197',
    'http://www.wikidata.org/entity/Q29614199',
    'http://www.wikidata.org/entity/Q29614200',
    'http://www.wikidata.org/entity/Q29614202',
    'http://www.wikidata.org/entity/Q29614203',
    'http://www.wikidata.org/entity/Q29614204',
    'http://www.wikidata.org/entity/Q29614205',
    'http://www.wikidata.org/entity/Q29614206',
    'http://www.wikidata.org/entity/Q29614207',
    'http://www.wikidata.org/entity/Q29614208',
    'http://www.wikidata.org/entity/Q29614209',
    'http://www.wikidata.org/entity/Q29614211',
    'http://www.wikidata.org/entity/Q29614212',
    'http://www.wikidata.org/entity/Q29614215',
    'http://www.wikidata.org/entity/Q29614216',
    'http://www.wikidata.org/entity/Q29614217',
    'http://www.wikidata.org/entity/Q29614218',
    'http://www.wikidata.org/entity/Q29614219',
    'http://www.wikidata.org/entity/Q29614225',
    'http://www.wikidata.org/entity/Q29614226',
    'http://www.wikidata.org/entity/Q29614227',
    'http://www.wikidata.org/entity/Q29614229',
    'http://www.wikidata.org/entity/Q29614230',
    'http://www.wikidata.org/entity/Q29614233',
    'http://www.wikidata.org/entity/Q29614234',
    'http://www.wikidata.org/entity/Q29614235',
    'http://www.wikidata.org/entity/Q29614237',
    'http://www.wikidata.org/entity/Q29614238',
    'http://www.wikidata.org/entity/Q29614239',
    'http://www.wikidata.org/entity/Q29614240',
    'http://www.wikidata.org/entity/Q29614241',
    'http://www.wikidata.org/entity/Q29614244',
    'http://www.wikidata.org/entity/Q29614245',
    'http://www.wikidata.org/entity/Q29614246',
    'http://www.wikidata.org/entity/Q29614247',
    'http://www.wikidata.org/entity/Q29614248',
    'http://www.wikidata.org/entity/Q29614256',
    'http://www.wikidata.org/entity/Q29614261',
    'http://www.wikidata.org/entity/Q29614262',
    'http://www.wikidata.org/entity/Q29614263',
    'http://www.wikidata.org/entity/Q29614264',
    'http://www.wikidata.org/entity/Q29614265',
    'http://www.wikidata.org/entity/Q29614266',
    'http://www.wikidata.org/entity/Q29614267',
    'http://www.wikidata.org/entity/Q29614268',
    'http://www.wikidata.org/entity/Q29614269',
    'http://www.wikidata.org/entity/Q29614271',
    'http://www.wikidata.org/entity/Q29614272',
    'http://www.wikidata.org/entity/Q29614273',
    'http://www.wikidata.org/entity/Q29614274',
    'http://www.wikidata.org/entity/Q29614275',
    'http://www.wikidata.org/entity/Q29614276',
    'http://www.wikidata.org/entity/Q29614277',
    'http://www.wikidata.org/entity/Q29614278',
    'http://www.wikidata.org/entity/Q29614280',
    'http://www.wikidata.org/entity/Q29614281',
    'http://www.wikidata.org/entity/Q29614283',
    'http://www.wikidata.org/entity/Q29614284',
    'http://www.wikidata.org/entity/Q29614285',
    'http://www.wikidata.org/entity/Q29614286',
    'http://www.wikidata.org/entity/Q29614287',
    'http://www.wikidata.org/entity/Q29614288',
    'http://www.wikidata.org/entity/Q29614289',
    'http://www.wikidata.org/entity/Q29614290',
    'http://www.wikidata.org/entity/Q29614291',
    'http://www.wikidata.org/entity/Q29614292',
    'http://www.wikidata.org/entity/Q29614293',
    'http://www.wikidata.org/entity/Q29614294',
    'http://www.wikidata.org/entity/Q29614295',
    'http://www.wikidata.org/entity/Q29614296',
    'http://www.wikidata.org/entity/Q29614298',
    'http://www.wikidata.org/entity/Q29614299',
    'http://www.wikidata.org/entity/Q29614300',
    'http://www.wikidata.org/entity/Q29614302',
    'http://www.wikidata.org/entity/Q29614303',
    'http://www.wikidata.org/entity/Q29614304',
    'http://www.wikidata.org/entity/Q29614305',
    'http://www.wikidata.org/entity/Q29614306',
    'http://www.wikidata.org/entity/Q29614307',
    'http://www.wikidata.org/entity/Q29614309',
    'http://www.wikidata.org/entity/Q29614310',
    'http://www.wikidata.org/entity/Q29614311',
    'http://www.wikidata.org/entity/Q29614312',
    'http://www.wikidata.org/entity/Q29614313',
    'http://www.wikidata.org/entity/Q29614314',
    'http://www.wikidata.org/entity/Q29614315',
    'http://www.wikidata.org/entity/Q29614316',
    'http://www.wikidata.org/entity/Q29614317',
    'http://www.wikidata.org/entity/Q29614318',
    'http://www.wikidata.org/entity/Q29614319',
    'http://www.wikidata.org/entity/Q29614320',
    'http://www.wikidata.org/entity/Q29614321',
    'http://www.wikidata.org/entity/Q29614322',
    'http://www.wikidata.org/entity/Q29614324',
    'http://www.wikidata.org/entity/Q29614325',
    'http://www.wikidata.org/entity/Q29614326',
    'http://www.wikidata.org/entity/Q29614327',
    'http://www.wikidata.org/entity/Q29614328',
    'http://www.wikidata.org/entity/Q29614329',
    'http://www.wikidata.org/entity/Q29614330',
    'http://www.wikidata.org/entity/Q29614331',
    'http://www.wikidata.org/entity/Q29614332',
    'http://www.wikidata.org/entity/Q29614333',
    'http://www.wikidata.org/entity/Q29614334',
    'http://www.wikidata.org/entity/Q29614335',
    'http://www.wikidata.org/entity/Q29614336',
    'http://www.wikidata.org/entity/Q29614337',
    'http://www.wikidata.org/entity/Q29614338',
    'http://www.wikidata.org/entity/Q29614339',
    'http://www.wikidata.org/entity/Q29614340',
    'http://www.wikidata.org/entity/Q29614341',
    'http://www.wikidata.org/entity/Q29614342',
    'http://www.wikidata.org/entity/Q29614343',
    'http://www.wikidata.org/entity/Q29614344',
    'http://www.wikidata.org/entity/Q29614346',
    'http://www.wikidata.org/entity/Q29614347',
    'http://www.wikidata.org/entity/Q29614348',
    'http://www.wikidata.org/entity/Q29614349',
    'http://www.wikidata.org/entity/Q29614350',
    'http://www.wikidata.org/entity/Q29614351',
    'http://www.wikidata.org/entity/Q29614352',
    'http://www.wikidata.org/entity/Q29614353',
    'http://www.wikidata.org/entity/Q29614354',
    'http://www.wikidata.org/entity/Q29614355',
    'http://www.wikidata.org/entity/Q29614356',
    'http://www.wikidata.org/entity/Q29614357',
    'http://www.wikidata.org/entity/Q29614359',
    'http://www.wikidata.org/entity/Q29614366',
    'http://www.wikidata.org/entity/Q29614367',
    'http://www.wikidata.org/entity/Q29614368',
    'http://www.wikidata.org/entity/Q29614369',
    'http://www.wikidata.org/entity/Q29614370',
    'http://www.wikidata.org/entity/Q29614371',
    'http://www.wikidata.org/entity/Q29614372',
    'http://www.wikidata.org/entity/Q29614373',
    'http://www.wikidata.org/entity/Q29614374',
    'http://www.wikidata.org/entity/Q29614375',
    'http://www.wikidata.org/entity/Q29614376',
    'http://www.wikidata.org/entity/Q29614377',
    'http://www.wikidata.org/entity/Q29614378',
    'http://www.wikidata.org/entity/Q29614381',
    'http://www.wikidata.org/entity/Q29614384',
    'http://www.wikidata.org/entity/Q29614386',
    'http://www.wikidata.org/entity/Q29614387',
    'http://www.wikidata.org/entity/Q29614388',
    'http://www.wikidata.org/entity/Q29614390',
    'http://www.wikidata.org/entity/Q29614391',
    'http://www.wikidata.org/entity/Q29614393',
    'http://www.wikidata.org/entity/Q29614394',
    'http://www.wikidata.org/entity/Q29614396',
    'http://www.wikidata.org/entity/Q29614397',
    'http://www.wikidata.org/entity/Q29614399',
    'http://www.wikidata.org/entity/Q29614401',
    'http://www.wikidata.org/entity/Q29614402',
    'http://www.wikidata.org/entity/Q29614403',
    'http://www.wikidata.org/entity/Q29614404',
    'http://www.wikidata.org/entity/Q29614405',
    'http://www.wikidata.org/entity/Q29614406',
    'http://www.wikidata.org/entity/Q29614407',
    'http://www.wikidata.org/entity/Q29614408',
    'http://www.wikidata.org/entity/Q29614409',
    'http://www.wikidata.org/entity/Q29614410',
    'http://www.wikidata.org/entity/Q29614411',
    'http://www.wikidata.org/entity/Q29614412',
    'http://www.wikidata.org/entity/Q29614413',
    'http://www.wikidata.org/entity/Q29614414',
    'http://www.wikidata.org/entity/Q29614417',
    'http://www.wikidata.org/entity/Q29614418',
    'http://www.wikidata.org/entity/Q29614419',
    'http://www.wikidata.org/entity/Q29614420',
    'http://www.wikidata.org/entity/Q29614421',
    'http://www.wikidata.org/entity/Q29614422',
    'http://www.wikidata.org/entity/Q29614423',
    'http://www.wikidata.org/entity/Q29614424',
    'http://www.wikidata.org/entity/Q29614426',
    'http://www.wikidata.org/entity/Q29614427',
    'http://www.wikidata.org/entity/Q29614428',
    'http://www.wikidata.org/entity/Q29614429',
    'http://www.wikidata.org/entity/Q29614431',
    'http://www.wikidata.org/entity/Q29614432',
    'http://www.wikidata.org/entity/Q29614437',
    'http://www.wikidata.org/entity/Q29614439',
    'http://www.wikidata.org/entity/Q29614440',
    'http://www.wikidata.org/entity/Q29614441',
    'http://www.wikidata.org/entity/Q29614442',
    'http://www.wikidata.org/entity/Q29614443',
    'http://www.wikidata.org/entity/Q29614445',
    'http://www.wikidata.org/entity/Q29614447',
    'http://www.wikidata.org/entity/Q29614448',
    'http://www.wikidata.org/entity/Q29614449',
    'http://www.wikidata.org/entity/Q29614450',
    'http://www.wikidata.org/entity/Q29614451',
    'http://www.wikidata.org/entity/Q29614452',
    'http://www.wikidata.org/entity/Q29614453',
    'http://www.wikidata.org/entity/Q29614454',
    'http://www.wikidata.org/entity/Q29614455',
    'http://www.wikidata.org/entity/Q29614456',
    'http://www.wikidata.org/entity/Q29614457',
    'http://www.wikidata.org/entity/Q29614458',
    'http://www.wikidata.org/entity/Q29614459',
    'http://www.wikidata.org/entity/Q29614461',
    'http://www.wikidata.org/entity/Q29614462',
    'http://www.wikidata.org/entity/Q29614465',
    'http://www.wikidata.org/entity/Q29614467',
    'http://www.wikidata.org/entity/Q29614468',
    'http://www.wikidata.org/entity/Q29614469',
    'http://www.wikidata.org/entity/Q29614470',
    'http://www.wikidata.org/entity/Q29614471',
    'http://www.wikidata.org/entity/Q29614472',
    'http://www.wikidata.org/entity/Q29614473',
    'http://www.wikidata.org/entity/Q29614474',
    'http://www.wikidata.org/entity/Q29614475',
    'http://www.wikidata.org/entity/Q29614476',
    'http://www.wikidata.org/entity/Q29614477',
    'http://www.wikidata.org/entity/Q29614478',
    'http://www.wikidata.org/entity/Q29614479',
    'http://www.wikidata.org/entity/Q29614480',
    'http://www.wikidata.org/entity/Q29614481',
    'http://www.wikidata.org/entity/Q29614482',
    'http://www.wikidata.org/entity/Q29614483',
    'http://www.wikidata.org/entity/Q29614484',
    'http://www.wikidata.org/entity/Q29614485',
    'http://www.wikidata.org/entity/Q29614486',
    'http://www.wikidata.org/entity/Q29614489',
    'http://www.wikidata.org/entity/Q29614490',
    'http://www.wikidata.org/entity/Q29614491',
    'http://www.wikidata.org/entity/Q29614492',
    'http://www.wikidata.org/entity/Q29614493',
    'http://www.wikidata.org/entity/Q29614494',
    'http://www.wikidata.org/entity/Q29614495',
    'http://www.wikidata.org/entity/Q29614496',
    'http://www.wikidata.org/entity/Q29614497',
    'http://www.wikidata.org/entity/Q29614498',
    'http://www.wikidata.org/entity/Q29614499',
    'http://www.wikidata.org/entity/Q29614500',
    'http://www.wikidata.org/entity/Q29614501',
    'http://www.wikidata.org/entity/Q29614502',
    'http://www.wikidata.org/entity/Q29614503',
    'http://www.wikidata.org/entity/Q29614504',
    'http://www.wikidata.org/entity/Q29614505',
    'http://www.wikidata.org/entity/Q29614506',
    'http://www.wikidata.org/entity/Q29614507',
    'http://www.wikidata.org/entity/Q29614509',
    'http://www.wikidata.org/entity/Q29614510',
    'http://www.wikidata.org/entity/Q29614511',
    'http://www.wikidata.org/entity/Q29614512',
    'http://www.wikidata.org/entity/Q29614513',
    'http://www.wikidata.org/entity/Q29614514',
    'http://www.wikidata.org/entity/Q29614515',
    'http://www.wikidata.org/entity/Q29614516',
    'http://www.wikidata.org/entity/Q29614519',
    'http://www.wikidata.org/entity/Q29614520',
    'http://www.wikidata.org/entity/Q29614521',
    'http://www.wikidata.org/entity/Q29614522',
    'http://www.wikidata.org/entity/Q29614523',
    'http://www.wikidata.org/entity/Q29614525',
    'http://www.wikidata.org/entity/Q29614529',
    'http://www.wikidata.org/entity/Q29614530',
    'http://www.wikidata.org/entity/Q29614531',
    'http://www.wikidata.org/entity/Q29614532',
    'http://www.wikidata.org/entity/Q29614535',
    'http://www.wikidata.org/entity/Q29614536',
    'http://www.wikidata.org/entity/Q29614537',
    'http://www.wikidata.org/entity/Q29614538',
    'http://www.wikidata.org/entity/Q29614539',
    'http://www.wikidata.org/entity/Q29614540',
    'http://www.wikidata.org/entity/Q29614541',
    'http://www.wikidata.org/entity/Q29614542',
    'http://www.wikidata.org/entity/Q29614544',
    'http://www.wikidata.org/entity/Q29614545',
    'http://www.wikidata.org/entity/Q29614546',
    'http://www.wikidata.org/entity/Q29614547',
    'http://www.wikidata.org/entity/Q29614548',
    'http://www.wikidata.org/entity/Q29614549',
    'http://www.wikidata.org/entity/Q29614550',
    'http://www.wikidata.org/entity/Q29614551',
    'http://www.wikidata.org/entity/Q29614552',
    'http://www.wikidata.org/entity/Q29614553',
    'http://www.wikidata.org/entity/Q29614554',
    'http://www.wikidata.org/entity/Q29614555',
    'http://www.wikidata.org/entity/Q29614556',
    'http://www.wikidata.org/entity/Q29614557',
    'http://www.wikidata.org/entity/Q29614558',
    'http://www.wikidata.org/entity/Q29614559',
    'http://www.wikidata.org/entity/Q29614560',
    'http://www.wikidata.org/entity/Q29614561',
    'http://www.wikidata.org/entity/Q29614562',
    'http://www.wikidata.org/entity/Q29614563',
    'http://www.wikidata.org/entity/Q29614564',
    'http://www.wikidata.org/entity/Q29614565',
    'http://www.wikidata.org/entity/Q29614566',
    'http://www.wikidata.org/entity/Q29614567',
    'http://www.wikidata.org/entity/Q29614568',
    'http://www.wikidata.org/entity/Q29614570',
    'http://www.wikidata.org/entity/Q29614572',
    'http://www.wikidata.org/entity/Q29614573',
    'http://www.wikidata.org/entity/Q29614574',
    'http://www.wikidata.org/entity/Q29614575',
    'http://www.wikidata.org/entity/Q29614576',
    'http://www.wikidata.org/entity/Q29614577',
    'http://www.wikidata.org/entity/Q29614578',
    'http://www.wikidata.org/entity/Q29614580',
    'http://www.wikidata.org/entity/Q29614582',
    'http://www.wikidata.org/entity/Q29614583',
    'http://www.wikidata.org/entity/Q29614584',
    'http://www.wikidata.org/entity/Q29614585',
    'http://www.wikidata.org/entity/Q29614586',
    'http://www.wikidata.org/entity/Q29614587',
    'http://www.wikidata.org/entity/Q29614589',
    'http://www.wikidata.org/entity/Q29614590',
    'http://www.wikidata.org/entity/Q29614591',
    'http://www.wikidata.org/entity/Q29614592',
    'http://www.wikidata.org/entity/Q29614593',
    'http://www.wikidata.org/entity/Q29614594',
    'http://www.wikidata.org/entity/Q29614595',
    'http://www.wikidata.org/entity/Q29614596',
    'http://www.wikidata.org/entity/Q29614597',
    'http://www.wikidata.org/entity/Q29614598',
    'http://www.wikidata.org/entity/Q29614599',
    'http://www.wikidata.org/entity/Q29614600',
    'http://www.wikidata.org/entity/Q29614601',
    'http://www.wikidata.org/entity/Q29614602',
    'http://www.wikidata.org/entity/Q29614603',
    'http://www.wikidata.org/entity/Q29614606',
    'http://www.wikidata.org/entity/Q29614609',
    'http://www.wikidata.org/entity/Q29614622',
    'http://www.wikidata.org/entity/Q29614624',
    'http://www.wikidata.org/entity/Q29614627',
    'http://www.wikidata.org/entity/Q29614630',
    'http://www.wikidata.org/entity/Q29614634',
    'http://www.wikidata.org/entity/Q29614637',
    'http://www.wikidata.org/entity/Q29614647',
    'http://www.wikidata.org/entity/Q29614651',
    'http://www.wikidata.org/entity/Q29614654',
    'http://www.wikidata.org/entity/Q29614659',
    'http://www.wikidata.org/entity/Q29614665',
    'http://www.wikidata.org/entity/Q29614669',
    'http://www.wikidata.org/entity/Q29614672',
    'http://www.wikidata.org/entity/Q29614678',
    'http://www.wikidata.org/entity/Q29614679',
    'http://www.wikidata.org/entity/Q29614682',
    'http://www.wikidata.org/entity/Q29614683',
    'http://www.wikidata.org/entity/Q29614684',
    'http://www.wikidata.org/entity/Q29614685',
    'http://www.wikidata.org/entity/Q29614686',
    'http://www.wikidata.org/entity/Q29614688',
    'http://www.wikidata.org/entity/Q29614689',
    'http://www.wikidata.org/entity/Q29614690',
    'http://www.wikidata.org/entity/Q29614691',
    'http://www.wikidata.org/entity/Q29614692',
    'http://www.wikidata.org/entity/Q29614693',
    'http://www.wikidata.org/entity/Q29614695',
    'http://www.wikidata.org/entity/Q29614696',
    'http://www.wikidata.org/entity/Q29614697',
    'http://www.wikidata.org/entity/Q29614698',
    'http://www.wikidata.org/entity/Q29614699',
    'http://www.wikidata.org/entity/Q29614700',
    'http://www.wikidata.org/entity/Q29614701',
    'http://www.wikidata.org/entity/Q29614702',
    'http://www.wikidata.org/entity/Q29614704',
    'http://www.wikidata.org/entity/Q29614705',
    'http://www.wikidata.org/entity/Q29614706',
    'http://www.wikidata.org/entity/Q29614707',
    'http://www.wikidata.org/entity/Q29614708',
    'http://www.wikidata.org/entity/Q29614709',
    'http://www.wikidata.org/entity/Q29614711',
    'http://www.wikidata.org/entity/Q29614712',
    'http://www.wikidata.org/entity/Q29614713',
    'http://www.wikidata.org/entity/Q29614714',
    'http://www.wikidata.org/entity/Q29614715',
    'http://www.wikidata.org/entity/Q29614716',
    'http://www.wikidata.org/entity/Q29614717',
    'http://www.wikidata.org/entity/Q29614719',
    'http://www.wikidata.org/entity/Q29614720',
    'http://www.wikidata.org/entity/Q29614721',
    'http://www.wikidata.org/entity/Q29614722',
    'http://www.wikidata.org/entity/Q29614723',
    'http://www.wikidata.org/entity/Q29614724',
    'http://www.wikidata.org/entity/Q29614725',
    'http://www.wikidata.org/entity/Q29614727',
    'http://www.wikidata.org/entity/Q29614728',
    'http://www.wikidata.org/entity/Q29614729',
    'http://www.wikidata.org/entity/Q29614730',
    'http://www.wikidata.org/entity/Q29614731',
    'http://www.wikidata.org/entity/Q29614732',
    'http://www.wikidata.org/entity/Q29614733',
    'http://www.wikidata.org/entity/Q29614734',
    'http://www.wikidata.org/entity/Q29614735',
    'http://www.wikidata.org/entity/Q29614736',
    'http://www.wikidata.org/entity/Q29614737',
    'http://www.wikidata.org/entity/Q29614738',
    'http://www.wikidata.org/entity/Q29614739',
    'http://www.wikidata.org/entity/Q29614740',
    'http://www.wikidata.org/entity/Q29614741',
    'http://www.wikidata.org/entity/Q29614742',
    'http://www.wikidata.org/entity/Q29614743',
    'http://www.wikidata.org/entity/Q29614745',
    'http://www.wikidata.org/entity/Q29614747',
    'http://www.wikidata.org/entity/Q29614750',
    'http://www.wikidata.org/entity/Q29614751',
    'http://www.wikidata.org/entity/Q29614752',
    'http://www.wikidata.org/entity/Q29614753',
    'http://www.wikidata.org/entity/Q29614754',
    'http://www.wikidata.org/entity/Q29614755',
    'http://www.wikidata.org/entity/Q29614756',
    'http://www.wikidata.org/entity/Q29614757',
    'http://www.wikidata.org/entity/Q29614758',
    'http://www.wikidata.org/entity/Q29614760',
    'http://www.wikidata.org/entity/Q29614761',
    'http://www.wikidata.org/entity/Q29614762',
    'http://www.wikidata.org/entity/Q29614763',
    'http://www.wikidata.org/entity/Q29614764',
    'http://www.wikidata.org/entity/Q29614765',
    'http://www.wikidata.org/entity/Q29614766',
    'http://www.wikidata.org/entity/Q29614769',
    'http://www.wikidata.org/entity/Q29614771',
    'http://www.wikidata.org/entity/Q29614774',
    'http://www.wikidata.org/entity/Q29614776',
    'http://www.wikidata.org/entity/Q29614777',
    'http://www.wikidata.org/entity/Q29614779',
    'http://www.wikidata.org/entity/Q29614780',
    'http://www.wikidata.org/entity/Q29614781',
    'http://www.wikidata.org/entity/Q29614782',
    'http://www.wikidata.org/entity/Q29614783',
    'http://www.wikidata.org/entity/Q29614784',
    'http://www.wikidata.org/entity/Q29614785',
    'http://www.wikidata.org/entity/Q29614786',
    'http://www.wikidata.org/entity/Q29614789',
    'http://www.wikidata.org/entity/Q29614793',
    'http://www.wikidata.org/entity/Q29614794',
    'http://www.wikidata.org/entity/Q29614796',
    'http://www.wikidata.org/entity/Q29614797',
    'http://www.wikidata.org/entity/Q29614798',
    'http://www.wikidata.org/entity/Q29614799',
    'http://www.wikidata.org/entity/Q29614801',
    'http://www.wikidata.org/entity/Q29614802',
    'http://www.wikidata.org/entity/Q29614803',
    'http://www.wikidata.org/entity/Q29614804',
    'http://www.wikidata.org/entity/Q29614805',
    'http://www.wikidata.org/entity/Q29614806',
    'http://www.wikidata.org/entity/Q29614807',
    'http://www.wikidata.org/entity/Q29614808',
    'http://www.wikidata.org/entity/Q29614810',
    'http://www.wikidata.org/entity/Q29614811',
    'http://www.wikidata.org/entity/Q29614812',
    'http://www.wikidata.org/entity/Q29614816',
    'http://www.wikidata.org/entity/Q29614817',
    'http://www.wikidata.org/entity/Q29614818',
    'http://www.wikidata.org/entity/Q29614819',
    'http://www.wikidata.org/entity/Q29614820',
    'http://www.wikidata.org/entity/Q29614821',
    'http://www.wikidata.org/entity/Q29614823',
    'http://www.wikidata.org/entity/Q29614824',
    'http://www.wikidata.org/entity/Q29614825',
    'http://www.wikidata.org/entity/Q29614826',
    'http://www.wikidata.org/entity/Q29614827',
    'http://www.wikidata.org/entity/Q29614828',
    'http://www.wikidata.org/entity/Q29614829',
    'http://www.wikidata.org/entity/Q29614830',
    'http://www.wikidata.org/entity/Q29614831',
    'http://www.wikidata.org/entity/Q29614833',
    'http://www.wikidata.org/entity/Q29614834',
    'http://www.wikidata.org/entity/Q29614835',
    'http://www.wikidata.org/entity/Q29614836',
    'http://www.wikidata.org/entity/Q29614837',
    'http://www.wikidata.org/entity/Q29614838',
    'http://www.wikidata.org/entity/Q29614839',
    'http://www.wikidata.org/entity/Q29614840',
    'http://www.wikidata.org/entity/Q29614841',
    'http://www.wikidata.org/entity/Q29614843',
    'http://www.wikidata.org/entity/Q29614844',
    'http://www.wikidata.org/entity/Q29614845',
    'http://www.wikidata.org/entity/Q29614846',
    'http://www.wikidata.org/entity/Q29614848',
    'http://www.wikidata.org/entity/Q29614849',
    'http://www.wikidata.org/entity/Q29614850',
    'http://www.wikidata.org/entity/Q29614851',
    'http://www.wikidata.org/entity/Q29614852',
    'http://www.wikidata.org/entity/Q29614854',
    'http://www.wikidata.org/entity/Q29614858',
    'http://www.wikidata.org/entity/Q29614859',
    'http://www.wikidata.org/entity/Q29614860',
    'http://www.wikidata.org/entity/Q29614861',
    'http://www.wikidata.org/entity/Q29614862',
    'http://www.wikidata.org/entity/Q29614867',
    'http://www.wikidata.org/entity/Q29614868',
    'http://www.wikidata.org/entity/Q29614869',
    'http://www.wikidata.org/entity/Q29614870',
    'http://www.wikidata.org/entity/Q29614871',
    'http://www.wikidata.org/entity/Q29614872',
    'http://www.wikidata.org/entity/Q29614873',
    'http://www.wikidata.org/entity/Q29614874',
    'http://www.wikidata.org/entity/Q29614875',
    'http://www.wikidata.org/entity/Q29614876',
    'http://www.wikidata.org/entity/Q29614877',
    'http://www.wikidata.org/entity/Q29614878',
    'http://www.wikidata.org/entity/Q29614879',
    'http://www.wikidata.org/entity/Q29614880',
    'http://www.wikidata.org/entity/Q29614881',
    'http://www.wikidata.org/entity/Q29614882',
    'http://www.wikidata.org/entity/Q29614883',
    'http://www.wikidata.org/entity/Q29614885',
    'http://www.wikidata.org/entity/Q29614886',
    'http://www.wikidata.org/entity/Q29614887',
    'http://www.wikidata.org/entity/Q29614888',
    'http://www.wikidata.org/entity/Q29614889',
    'http://www.wikidata.org/entity/Q29614890',
    'http://www.wikidata.org/entity/Q29614891',
    'http://www.wikidata.org/entity/Q29614892',
    'http://www.wikidata.org/entity/Q29614894',
    'http://www.wikidata.org/entity/Q29614895',
    'http://www.wikidata.org/entity/Q29614896',
    'http://www.wikidata.org/entity/Q29614897',
    'http://www.wikidata.org/entity/Q29614898',
    'http://www.wikidata.org/entity/Q29614900',
    'http://www.wikidata.org/entity/Q29614901',
    'http://www.wikidata.org/entity/Q29614902',
    'http://www.wikidata.org/entity/Q29614903',
    'http://www.wikidata.org/entity/Q29614904',
    'http://www.wikidata.org/entity/Q29614905',
    'http://www.wikidata.org/entity/Q29614906',
    'http://www.wikidata.org/entity/Q29614907',
    'http://www.wikidata.org/entity/Q29614908',
    'http://www.wikidata.org/entity/Q29614910',
    'http://www.wikidata.org/entity/Q29614911',
    'http://www.wikidata.org/entity/Q29614914',
    'http://www.wikidata.org/entity/Q29614917',
    'http://www.wikidata.org/entity/Q29614919',
    'http://www.wikidata.org/entity/Q29614920',
    'http://www.wikidata.org/entity/Q29614922',
    'http://www.wikidata.org/entity/Q29614923',
    'http://www.wikidata.org/entity/Q29614924',
    'http://www.wikidata.org/entity/Q29614925',
    'http://www.wikidata.org/entity/Q29614926',
    'http://www.wikidata.org/entity/Q29614927',
    'http://www.wikidata.org/entity/Q29614928',
    'http://www.wikidata.org/entity/Q29614929',
    'http://www.wikidata.org/entity/Q29614930',
    'http://www.wikidata.org/entity/Q29614931',
    'http://www.wikidata.org/entity/Q29614932',
    'http://www.wikidata.org/entity/Q29614933',
    'http://www.wikidata.org/entity/Q29614934',
    'http://www.wikidata.org/entity/Q29614936',
    'http://www.wikidata.org/entity/Q29614937',
    'http://www.wikidata.org/entity/Q29614938',
    'http://www.wikidata.org/entity/Q29614939',
    'http://www.wikidata.org/entity/Q29614940',
    'http://www.wikidata.org/entity/Q29614941',
    'http://www.wikidata.org/entity/Q29614942',
    'http://www.wikidata.org/entity/Q29614943',
    'http://www.wikidata.org/entity/Q29614944',
    'http://www.wikidata.org/entity/Q29614945',
    'http://www.wikidata.org/entity/Q29614946',
    'http://www.wikidata.org/entity/Q29614947',
    'http://www.wikidata.org/entity/Q29614948',
    'http://www.wikidata.org/entity/Q29614949',
    'http://www.wikidata.org/entity/Q29614950',
    'http://www.wikidata.org/entity/Q29614951',
    'http://www.wikidata.org/entity/Q29614952',
    'http://www.wikidata.org/entity/Q29614953',
    'http://www.wikidata.org/entity/Q29614954',
    'http://www.wikidata.org/entity/Q29614955',
    'http://www.wikidata.org/entity/Q29614956',
    'http://www.wikidata.org/entity/Q29614957',
    'http://www.wikidata.org/entity/Q29614960',
    'http://www.wikidata.org/entity/Q29614964',
    'http://www.wikidata.org/entity/Q29614967',
    'http://www.wikidata.org/entity/Q29614968',
    'http://www.wikidata.org/entity/Q29614969',
    'http://www.wikidata.org/entity/Q29614970',
    'http://www.wikidata.org/entity/Q29614971',
    'http://www.wikidata.org/entity/Q29614972',
    'http://www.wikidata.org/entity/Q29614973',
    'http://www.wikidata.org/entity/Q29614974',
    'http://www.wikidata.org/entity/Q29614975',
    'http://www.wikidata.org/entity/Q29614978',
    'http://www.wikidata.org/entity/Q29614979',
    'http://www.wikidata.org/entity/Q29614980',
    'http://www.wikidata.org/entity/Q29614981',
    'http://www.wikidata.org/entity/Q29614982',
    'http://www.wikidata.org/entity/Q29614983',
    'http://www.wikidata.org/entity/Q29614984',
    'http://www.wikidata.org/entity/Q29614985',
    'http://www.wikidata.org/entity/Q29614989',
    'http://www.wikidata.org/entity/Q29614990',
    'http://www.wikidata.org/entity/Q29614993',
    'http://www.wikidata.org/entity/Q29614994',
    'http://www.wikidata.org/entity/Q29614998',
    'http://www.wikidata.org/entity/Q29615000',
    'http://www.wikidata.org/entity/Q29615001',
    'http://www.wikidata.org/entity/Q29615003',
    'http://www.wikidata.org/entity/Q29615004',
    'http://www.wikidata.org/entity/Q29615006',
    'http://www.wikidata.org/entity/Q29615007',
    'http://www.wikidata.org/entity/Q29615008',
    'http://www.wikidata.org/entity/Q29615009',
    'http://www.wikidata.org/entity/Q29615010',
    'http://www.wikidata.org/entity/Q29615011',
    'http://www.wikidata.org/entity/Q29615012',
    'http://www.wikidata.org/entity/Q29615013',
    'http://www.wikidata.org/entity/Q29615014',
    'http://www.wikidata.org/entity/Q29615016',
    'http://www.wikidata.org/entity/Q29615017',
    'http://www.wikidata.org/entity/Q29615019',
    'http://www.wikidata.org/entity/Q29615020',
    'http://www.wikidata.org/entity/Q29615022',
    'http://www.wikidata.org/entity/Q29615024',
    'http://www.wikidata.org/entity/Q29615025',
    'http://www.wikidata.org/entity/Q29615026',
    'http://www.wikidata.org/entity/Q29615027',
    'http://www.wikidata.org/entity/Q29615028',
    'http://www.wikidata.org/entity/Q29615029',
    'http://www.wikidata.org/entity/Q29615030',
    'http://www.wikidata.org/entity/Q29615031',
    'http://www.wikidata.org/entity/Q29615032',
    'http://www.wikidata.org/entity/Q29615033',
    'http://www.wikidata.org/entity/Q29615034',
    'http://www.wikidata.org/entity/Q29615035',
    'http://www.wikidata.org/entity/Q29615036',
    'http://www.wikidata.org/entity/Q29615037',
    'http://www.wikidata.org/entity/Q29615038',
    'http://www.wikidata.org/entity/Q29615039',
    'http://www.wikidata.org/entity/Q29615040',
    'http://www.wikidata.org/entity/Q29615042',
    'http://www.wikidata.org/entity/Q29615044',
    'http://www.wikidata.org/entity/Q29615045',
    'http://www.wikidata.org/entity/Q29615050',
    'http://www.wikidata.org/entity/Q29615051',
    'http://www.wikidata.org/entity/Q29615052',
    'http://www.wikidata.org/entity/Q29615053',
    'http://www.wikidata.org/entity/Q29615054',
    'http://www.wikidata.org/entity/Q29615055',
    'http://www.wikidata.org/entity/Q29615056',
    'http://www.wikidata.org/entity/Q29615057',
    'http://www.wikidata.org/entity/Q29615058',
    'http://www.wikidata.org/entity/Q29615059',
    'http://www.wikidata.org/entity/Q29615060',
    'http://www.wikidata.org/entity/Q29615061',
    'http://www.wikidata.org/entity/Q29615062',
    'http://www.wikidata.org/entity/Q29615063',
    'http://www.wikidata.org/entity/Q29615064',
    'http://www.wikidata.org/entity/Q29615065',
    'http://www.wikidata.org/entity/Q29615066',
    'http://www.wikidata.org/entity/Q29615067',
    'http://www.wikidata.org/entity/Q29615068',
    'http://www.wikidata.org/entity/Q29615069',
    'http://www.wikidata.org/entity/Q29615070',
    'http://www.wikidata.org/entity/Q29615074',
    'http://www.wikidata.org/entity/Q29615075',
    'http://www.wikidata.org/entity/Q29615076',
    'http://www.wikidata.org/entity/Q29615077',
    'http://www.wikidata.org/entity/Q29615078',
    'http://www.wikidata.org/entity/Q29615079',
    'http://www.wikidata.org/entity/Q29615080',
    'http://www.wikidata.org/entity/Q29615081',
    'http://www.wikidata.org/entity/Q29615083',
    'http://www.wikidata.org/entity/Q29615084',
    'http://www.wikidata.org/entity/Q29615085',
    'http://www.wikidata.org/entity/Q29615089',
    'http://www.wikidata.org/entity/Q29615090',
    'http://www.wikidata.org/entity/Q29615091',
    'http://www.wikidata.org/entity/Q29615092',
    'http://www.wikidata.org/entity/Q29615094',
    'http://www.wikidata.org/entity/Q29615095',
    'http://www.wikidata.org/entity/Q29615096',
    'http://www.wikidata.org/entity/Q29615097',
    'http://www.wikidata.org/entity/Q29615098',
    'http://www.wikidata.org/entity/Q29615099',
    'http://www.wikidata.org/entity/Q29615102',
    'http://www.wikidata.org/entity/Q29615103',
    'http://www.wikidata.org/entity/Q29615104',
    'http://www.wikidata.org/entity/Q29615106',
    'http://www.wikidata.org/entity/Q29615107',
    'http://www.wikidata.org/entity/Q29615108',
    'http://www.wikidata.org/entity/Q29615109',
    'http://www.wikidata.org/entity/Q29615110',
    'http://www.wikidata.org/entity/Q29615111',
    'http://www.wikidata.org/entity/Q29615112',
    'http://www.wikidata.org/entity/Q29615113',
    'http://www.wikidata.org/entity/Q29615114',
    'http://www.wikidata.org/entity/Q29615115',
    'http://www.wikidata.org/entity/Q29615116',
    'http://www.wikidata.org/entity/Q29615117',
    'http://www.wikidata.org/entity/Q29615118',
    'http://www.wikidata.org/entity/Q29615119',
    'http://www.wikidata.org/entity/Q29615120',
    'http://www.wikidata.org/entity/Q29615121',
    'http://www.wikidata.org/entity/Q29615122',
    'http://www.wikidata.org/entity/Q29615123',
    'http://www.wikidata.org/entity/Q29615124',
    'http://www.wikidata.org/entity/Q29615125',
    'http://www.wikidata.org/entity/Q29615126',
    'http://www.wikidata.org/entity/Q29615127',
    'http://www.wikidata.org/entity/Q29615128',
    'http://www.wikidata.org/entity/Q29615131',
    'http://www.wikidata.org/entity/Q29615132',
    'http://www.wikidata.org/entity/Q29615133',
    'http://www.wikidata.org/entity/Q29615134',
    'http://www.wikidata.org/entity/Q29615135',
    'http://www.wikidata.org/entity/Q29615136',
    'http://www.wikidata.org/entity/Q29615137',
    'http://www.wikidata.org/entity/Q29615138',
    'http://www.wikidata.org/entity/Q29615139',
    'http://www.wikidata.org/entity/Q29615140',
    'http://www.wikidata.org/entity/Q29615141',
    'http://www.wikidata.org/entity/Q29615142',
    'http://www.wikidata.org/entity/Q29615143',
    'http://www.wikidata.org/entity/Q29615144',
    'http://www.wikidata.org/entity/Q29615145',
    'http://www.wikidata.org/entity/Q29615147',
    'http://www.wikidata.org/entity/Q29615148',
    'http://www.wikidata.org/entity/Q29615151',
    'http://www.wikidata.org/entity/Q29615152',
    'http://www.wikidata.org/entity/Q29615154',
    'http://www.wikidata.org/entity/Q29615155',
    'http://www.wikidata.org/entity/Q29615156',
    'http://www.wikidata.org/entity/Q29615157',
    'http://www.wikidata.org/entity/Q29615158',
    'http://www.wikidata.org/entity/Q29615159',
    'http://www.wikidata.org/entity/Q29615160',
    'http://www.wikidata.org/entity/Q29615161',
    'http://www.wikidata.org/entity/Q29615162',
    'http://www.wikidata.org/entity/Q29615163',
    'http://www.wikidata.org/entity/Q29615165',
    'http://www.wikidata.org/entity/Q29615166',
    'http://www.wikidata.org/entity/Q29615167',
    'http://www.wikidata.org/entity/Q29615168',
    'http://www.wikidata.org/entity/Q29615169',
    'http://www.wikidata.org/entity/Q29615170',
    'http://www.wikidata.org/entity/Q29615171',
    'http://www.wikidata.org/entity/Q29615173',
    'http://www.wikidata.org/entity/Q29615174',
    'http://www.wikidata.org/entity/Q29615176',
    'http://www.wikidata.org/entity/Q29615178',
    'http://www.wikidata.org/entity/Q29615180',
    'http://www.wikidata.org/entity/Q29615181',
    'http://www.wikidata.org/entity/Q29615183',
    'http://www.wikidata.org/entity/Q29615184',
    'http://www.wikidata.org/entity/Q29615185',
    'http://www.wikidata.org/entity/Q29615187',
    'http://www.wikidata.org/entity/Q29615188',
    'http://www.wikidata.org/entity/Q29615189',
    'http://www.wikidata.org/entity/Q29615190',
    'http://www.wikidata.org/entity/Q29615191',
    'http://www.wikidata.org/entity/Q29615192',
    'http://www.wikidata.org/entity/Q29615193',
    'http://www.wikidata.org/entity/Q29615194',
    'http://www.wikidata.org/entity/Q29615195',
    'http://www.wikidata.org/entity/Q29615196',
    'http://www.wikidata.org/entity/Q29615197',
    'http://www.wikidata.org/entity/Q29615199',
    'http://www.wikidata.org/entity/Q29615200',
    'http://www.wikidata.org/entity/Q29615201',
    'http://www.wikidata.org/entity/Q29615202',
    'http://www.wikidata.org/entity/Q29615203',
    'http://www.wikidata.org/entity/Q29615205',
    'http://www.wikidata.org/entity/Q29615206',
    'http://www.wikidata.org/entity/Q29615207',
    'http://www.wikidata.org/entity/Q29615208',
    'http://www.wikidata.org/entity/Q29615209',
    'http://www.wikidata.org/entity/Q29615210',
    'http://www.wikidata.org/entity/Q29615211',
    'http://www.wikidata.org/entity/Q29615212',
    'http://www.wikidata.org/entity/Q29615213',
    'http://www.wikidata.org/entity/Q29615214',
    'http://www.wikidata.org/entity/Q29615215',
    'http://www.wikidata.org/entity/Q29615216',
    'http://www.wikidata.org/entity/Q29615217',
    'http://www.wikidata.org/entity/Q29615219',
    'http://www.wikidata.org/entity/Q29615220',
    'http://www.wikidata.org/entity/Q29615221',
    'http://www.wikidata.org/entity/Q29615222',
    'http://www.wikidata.org/entity/Q29615223',
    'http://www.wikidata.org/entity/Q29615224',
    'http://www.wikidata.org/entity/Q29615225',
    'http://www.wikidata.org/entity/Q29615226',
    'http://www.wikidata.org/entity/Q29615227',
    'http://www.wikidata.org/entity/Q29615228',
    'http://www.wikidata.org/entity/Q29615229',
    'http://www.wikidata.org/entity/Q29615230',
    'http://www.wikidata.org/entity/Q29615231',
    'http://www.wikidata.org/entity/Q29615232',
    'http://www.wikidata.org/entity/Q29615233',
    'http://www.wikidata.org/entity/Q29615234',
    'http://www.wikidata.org/entity/Q29615235',
    'http://www.wikidata.org/entity/Q29615236',
    'http://www.wikidata.org/entity/Q29615237',
    'http://www.wikidata.org/entity/Q29615238',
    'http://www.wikidata.org/entity/Q29615239',
    'http://www.wikidata.org/entity/Q29615240',
    'http://www.wikidata.org/entity/Q29615241',
    'http://www.wikidata.org/entity/Q29615242',
    'http://www.wikidata.org/entity/Q29615243',
    'http://www.wikidata.org/entity/Q29615245',
    'http://www.wikidata.org/entity/Q29615248',
    'http://www.wikidata.org/entity/Q29615251',
    'http://www.wikidata.org/entity/Q29615252',
    'http://www.wikidata.org/entity/Q29615253',
    'http://www.wikidata.org/entity/Q29615255',
    'http://www.wikidata.org/entity/Q29615256',
    'http://www.wikidata.org/entity/Q29615257',
    'http://www.wikidata.org/entity/Q29615258',
    'http://www.wikidata.org/entity/Q29615259',
    'http://www.wikidata.org/entity/Q29615261',
    'http://www.wikidata.org/entity/Q29615262',
    'http://www.wikidata.org/entity/Q29615263',
    'http://www.wikidata.org/entity/Q29615264',
    'http://www.wikidata.org/entity/Q29615265',
    'http://www.wikidata.org/entity/Q29615268',
    'http://www.wikidata.org/entity/Q29615269',
    'http://www.wikidata.org/entity/Q29615270',
    'http://www.wikidata.org/entity/Q29615275',
    'http://www.wikidata.org/entity/Q29615277',
    'http://www.wikidata.org/entity/Q29615278',
    'http://www.wikidata.org/entity/Q29615279',
    'http://www.wikidata.org/entity/Q29615281',
    'http://www.wikidata.org/entity/Q29615282',
    'http://www.wikidata.org/entity/Q29615283',
    'http://www.wikidata.org/entity/Q29615284',
    'http://www.wikidata.org/entity/Q29615285',
    'http://www.wikidata.org/entity/Q29615286',
    'http://www.wikidata.org/entity/Q29615287',
    'http://www.wikidata.org/entity/Q29615288',
    'http://www.wikidata.org/entity/Q29615291',
    'http://www.wikidata.org/entity/Q29615292',
    'http://www.wikidata.org/entity/Q29615293',
    'http://www.wikidata.org/entity/Q29615294',
    'http://www.wikidata.org/entity/Q29615295',
    'http://www.wikidata.org/entity/Q29615296',
    'http://www.wikidata.org/entity/Q29615299',
    'http://www.wikidata.org/entity/Q29615301',
    'http://www.wikidata.org/entity/Q29615302',
    'http://www.wikidata.org/entity/Q29615303',
    'http://www.wikidata.org/entity/Q29615305',
    'http://www.wikidata.org/entity/Q29615307',
    'http://www.wikidata.org/entity/Q29615309',
    'http://www.wikidata.org/entity/Q29615311',
    'http://www.wikidata.org/entity/Q29615312',
    'http://www.wikidata.org/entity/Q29615313',
    'http://www.wikidata.org/entity/Q29615314',
    'http://www.wikidata.org/entity/Q29615315',
    'http://www.wikidata.org/entity/Q29615316',
    'http://www.wikidata.org/entity/Q29615317',
    'http://www.wikidata.org/entity/Q29615318',
    'http://www.wikidata.org/entity/Q29615319',
    'http://www.wikidata.org/entity/Q29615321',
    'http://www.wikidata.org/entity/Q29615322',
    'http://www.wikidata.org/entity/Q29615323',
    'http://www.wikidata.org/entity/Q29615324',
    'http://www.wikidata.org/entity/Q29615325',
    'http://www.wikidata.org/entity/Q29615327',
    'http://www.wikidata.org/entity/Q29615328',
    'http://www.wikidata.org/entity/Q29615329',
    'http://www.wikidata.org/entity/Q29615330',
    'http://www.wikidata.org/entity/Q29615331',
    'http://www.wikidata.org/entity/Q29615332',
    'http://www.wikidata.org/entity/Q29615333',
    'http://www.wikidata.org/entity/Q29615334',
    'http://www.wikidata.org/entity/Q29615335',
    'http://www.wikidata.org/entity/Q29615336',
    'http://www.wikidata.org/entity/Q29615337',
    'http://www.wikidata.org/entity/Q29615338',
    'http://www.wikidata.org/entity/Q29615339',
    'http://www.wikidata.org/entity/Q29615340',
    'http://www.wikidata.org/entity/Q29615341',
    'http://www.wikidata.org/entity/Q29615344',
    'http://www.wikidata.org/entity/Q29615345',
    'http://www.wikidata.org/entity/Q29615346',
    'http://www.wikidata.org/entity/Q29615348',
    'http://www.wikidata.org/entity/Q29615349',
    'http://www.wikidata.org/entity/Q29615352',
    'http://www.wikidata.org/entity/Q29615353',
    'http://www.wikidata.org/entity/Q29615354',
    'http://www.wikidata.org/entity/Q29615355',
    'http://www.wikidata.org/entity/Q29615356',
    'http://www.wikidata.org/entity/Q29615357',
    'http://www.wikidata.org/entity/Q29615358',
    'http://www.wikidata.org/entity/Q29615359',
    'http://www.wikidata.org/entity/Q29615361',
    'http://www.wikidata.org/entity/Q29615362',
    'http://www.wikidata.org/entity/Q29615363',
    'http://www.wikidata.org/entity/Q29615364',
    'http://www.wikidata.org/entity/Q29615365',
    'http://www.wikidata.org/entity/Q29615366',
    'http://www.wikidata.org/entity/Q29615367',
    'http://www.wikidata.org/entity/Q29615368',
    'http://www.wikidata.org/entity/Q29615371',
    'http://www.wikidata.org/entity/Q29615372',
    'http://www.wikidata.org/entity/Q29615373',
    'http://www.wikidata.org/entity/Q29615374',
    'http://www.wikidata.org/entity/Q29615375',
    'http://www.wikidata.org/entity/Q29615376',
    'http://www.wikidata.org/entity/Q29615377',
    'http://www.wikidata.org/entity/Q29615378',
    'http://www.wikidata.org/entity/Q29615379',
    'http://www.wikidata.org/entity/Q29615380',
    'http://www.wikidata.org/entity/Q29615381',
    'http://www.wikidata.org/entity/Q29615382',
    'http://www.wikidata.org/entity/Q29615383',
    'http://www.wikidata.org/entity/Q29615385',
    'http://www.wikidata.org/entity/Q29615386',
    'http://www.wikidata.org/entity/Q29615388',
    'http://www.wikidata.org/entity/Q29615389',
    'http://www.wikidata.org/entity/Q29615390',
    'http://www.wikidata.org/entity/Q29615391',
    'http://www.wikidata.org/entity/Q29615392',
    'http://www.wikidata.org/entity/Q29615393',
    'http://www.wikidata.org/entity/Q29615394',
    'http://www.wikidata.org/entity/Q29615395',
    'http://www.wikidata.org/entity/Q29615396',
    'http://www.wikidata.org/entity/Q29615397',
    'http://www.wikidata.org/entity/Q29615398',
    'http://www.wikidata.org/entity/Q29615399',
    'http://www.wikidata.org/entity/Q29615401',
    'http://www.wikidata.org/entity/Q29615403',
    'http://www.wikidata.org/entity/Q29615404',
    'http://www.wikidata.org/entity/Q29615406',
    'http://www.wikidata.org/entity/Q29615407',
    'http://www.wikidata.org/entity/Q29615408',
    'http://www.wikidata.org/entity/Q29615409',
    'http://www.wikidata.org/entity/Q29615410',
    'http://www.wikidata.org/entity/Q29615411',
    'http://www.wikidata.org/entity/Q29615412',
    'http://www.wikidata.org/entity/Q29615413',
    'http://www.wikidata.org/entity/Q29615414',
    'http://www.wikidata.org/entity/Q29615415',
    'http://www.wikidata.org/entity/Q29615416',
    'http://www.wikidata.org/entity/Q29615417',
    'http://www.wikidata.org/entity/Q29615418',
    'http://www.wikidata.org/entity/Q29615420',
    'http://www.wikidata.org/entity/Q29615421',
    'http://www.wikidata.org/entity/Q29615422',
    'http://www.wikidata.org/entity/Q29615423',
    'http://www.wikidata.org/entity/Q29615424',
    'http://www.wikidata.org/entity/Q29615427',
    'http://www.wikidata.org/entity/Q29615429',
    'http://www.wikidata.org/entity/Q29615430',
    'http://www.wikidata.org/entity/Q29615432',
    'http://www.wikidata.org/entity/Q29615433',
    'http://www.wikidata.org/entity/Q29615435',
    'http://www.wikidata.org/entity/Q29615436',
    'http://www.wikidata.org/entity/Q29615437',
    'http://www.wikidata.org/entity/Q29615438',
    'http://www.wikidata.org/entity/Q29615439',
    'http://www.wikidata.org/entity/Q29615441',
    'http://www.wikidata.org/entity/Q29615442',
    'http://www.wikidata.org/entity/Q29615443',
    'http://www.wikidata.org/entity/Q29615444',
    'http://www.wikidata.org/entity/Q29615445',
    'http://www.wikidata.org/entity/Q29615446',
    'http://www.wikidata.org/entity/Q29615447',
    'http://www.wikidata.org/entity/Q29615448',
    'http://www.wikidata.org/entity/Q29615449',
    'http://www.wikidata.org/entity/Q29615450',
    'http://www.wikidata.org/entity/Q29615451',
    'http://www.wikidata.org/entity/Q29615452',
    'http://www.wikidata.org/entity/Q29615453',
    'http://www.wikidata.org/entity/Q29615454',
    'http://www.wikidata.org/entity/Q29615455',
    'http://www.wikidata.org/entity/Q29615456',
    'http://www.wikidata.org/entity/Q29615457',
    'http://www.wikidata.org/entity/Q29615458',
    'http://www.wikidata.org/entity/Q29615459',
    'http://www.wikidata.org/entity/Q29615460',
    'http://www.wikidata.org/entity/Q29615461',
    'http://www.wikidata.org/entity/Q29615462',
    'http://www.wikidata.org/entity/Q29615463',
    'http://www.wikidata.org/entity/Q29615464',
    'http://www.wikidata.org/entity/Q29615465',
    'http://www.wikidata.org/entity/Q29615466',
    'http://www.wikidata.org/entity/Q29615467',
    'http://www.wikidata.org/entity/Q29615468',
    'http://www.wikidata.org/entity/Q29615469',
    'http://www.wikidata.org/entity/Q29615471',
    'http://www.wikidata.org/entity/Q29615473',
    'http://www.wikidata.org/entity/Q29615474',
    'http://www.wikidata.org/entity/Q29615475',
    'http://www.wikidata.org/entity/Q29615476',
    'http://www.wikidata.org/entity/Q29615477',
    'http://www.wikidata.org/entity/Q29615479',
    'http://www.wikidata.org/entity/Q29615480',
    'http://www.wikidata.org/entity/Q29615481',
    'http://www.wikidata.org/entity/Q29615482',
    'http://www.wikidata.org/entity/Q29615483',
    'http://www.wikidata.org/entity/Q29615484',
    'http://www.wikidata.org/entity/Q29615485',
    'http://www.wikidata.org/entity/Q29615486',
    'http://www.wikidata.org/entity/Q29615487',
    'http://www.wikidata.org/entity/Q29615488',
    'http://www.wikidata.org/entity/Q29615490',
    'http://www.wikidata.org/entity/Q29615491',
    'http://www.wikidata.org/entity/Q29615492',
    'http://www.wikidata.org/entity/Q29615493',
    'http://www.wikidata.org/entity/Q29615495',
    'http://www.wikidata.org/entity/Q29615496',
    'http://www.wikidata.org/entity/Q29615497',
    'http://www.wikidata.org/entity/Q29615498',
    'http://www.wikidata.org/entity/Q29615499',
    'http://www.wikidata.org/entity/Q29615500',
    'http://www.wikidata.org/entity/Q29615501',
    'http://www.wikidata.org/entity/Q29615502',
    'http://www.wikidata.org/entity/Q29615503',
    'http://www.wikidata.org/entity/Q29615504',
    'http://www.wikidata.org/entity/Q29615505',
    'http://www.wikidata.org/entity/Q29615506',
    'http://www.wikidata.org/entity/Q29615508',
    'http://www.wikidata.org/entity/Q29615509',
    'http://www.wikidata.org/entity/Q29615511',
    'http://www.wikidata.org/entity/Q29615512',
    'http://www.wikidata.org/entity/Q29615513',
    'http://www.wikidata.org/entity/Q29615514',
    'http://www.wikidata.org/entity/Q29615515',
    'http://www.wikidata.org/entity/Q29615516',
    'http://www.wikidata.org/entity/Q29615517',
    'http://www.wikidata.org/entity/Q29615518',
    'http://www.wikidata.org/entity/Q29615520',
    'http://www.wikidata.org/entity/Q29615521',
    'http://www.wikidata.org/entity/Q29615522',
    'http://www.wikidata.org/entity/Q29615523',
    'http://www.wikidata.org/entity/Q29615524',
    'http://www.wikidata.org/entity/Q29615526',
    'http://www.wikidata.org/entity/Q29615528',
    'http://www.wikidata.org/entity/Q29615529',
    'http://www.wikidata.org/entity/Q29615530',
    'http://www.wikidata.org/entity/Q29615531',
    'http://www.wikidata.org/entity/Q29615532',
    'http://www.wikidata.org/entity/Q29615533',
    'http://www.wikidata.org/entity/Q29615534',
    'http://www.wikidata.org/entity/Q29615535',
    'http://www.wikidata.org/entity/Q29615536',
    'http://www.wikidata.org/entity/Q29615537',
    'http://www.wikidata.org/entity/Q29615539',
    'http://www.wikidata.org/entity/Q29615540',
    'http://www.wikidata.org/entity/Q29615541',
    'http://www.wikidata.org/entity/Q29615542',
    'http://www.wikidata.org/entity/Q29615543',
    'http://www.wikidata.org/entity/Q29615544',
    'http://www.wikidata.org/entity/Q29615545',
    'http://www.wikidata.org/entity/Q29615546',
    'http://www.wikidata.org/entity/Q29615547',
    'http://www.wikidata.org/entity/Q29615548',
    'http://www.wikidata.org/entity/Q29615549',
    'http://www.wikidata.org/entity/Q29615550',
    'http://www.wikidata.org/entity/Q29615551',
    'http://www.wikidata.org/entity/Q29615552',
    'http://www.wikidata.org/entity/Q29615553',
    'http://www.wikidata.org/entity/Q29615554',
    'http://www.wikidata.org/entity/Q29615555',
    'http://www.wikidata.org/entity/Q29615556',
    'http://www.wikidata.org/entity/Q29615557',
    'http://www.wikidata.org/entity/Q29615559',
    'http://www.wikidata.org/entity/Q29615561',
    'http://www.wikidata.org/entity/Q29615562',
    'http://www.wikidata.org/entity/Q29615563',
    'http://www.wikidata.org/entity/Q29615564',
    'http://www.wikidata.org/entity/Q29615565',
    'http://www.wikidata.org/entity/Q29615567',
    'http://www.wikidata.org/entity/Q29615568',
    'http://www.wikidata.org/entity/Q29615569',
    'http://www.wikidata.org/entity/Q29615570',
    'http://www.wikidata.org/entity/Q29615571',
    'http://www.wikidata.org/entity/Q29615572',
    'http://www.wikidata.org/entity/Q29615573',
    'http://www.wikidata.org/entity/Q29615574',
    'http://www.wikidata.org/entity/Q29615575',
    'http://www.wikidata.org/entity/Q29615576',
    'http://www.wikidata.org/entity/Q29615577',
    'http://www.wikidata.org/entity/Q29615578',
    'http://www.wikidata.org/entity/Q29615579',
    'http://www.wikidata.org/entity/Q29615580',
    'http://www.wikidata.org/entity/Q29615581',
    'http://www.wikidata.org/entity/Q29615582',
    'http://www.wikidata.org/entity/Q29615583',
    'http://www.wikidata.org/entity/Q29615584',
    'http://www.wikidata.org/entity/Q29615585',
    'http://www.wikidata.org/entity/Q29615586',
    'http://www.wikidata.org/entity/Q29615588',
    'http://www.wikidata.org/entity/Q29615589',
    'http://www.wikidata.org/entity/Q29615590',
    'http://www.wikidata.org/entity/Q29615591',
    'http://www.wikidata.org/entity/Q29615592',
    'http://www.wikidata.org/entity/Q29615593',
    'http://www.wikidata.org/entity/Q29615594',
    'http://www.wikidata.org/entity/Q29615595',
    'http://www.wikidata.org/entity/Q29615596',
    'http://www.wikidata.org/entity/Q29615597',
    'http://www.wikidata.org/entity/Q29615598',
    'http://www.wikidata.org/entity/Q29615599',
    'http://www.wikidata.org/entity/Q29615600',
    'http://www.wikidata.org/entity/Q29615601',
    'http://www.wikidata.org/entity/Q29615602',
    'http://www.wikidata.org/entity/Q29615603',
    'http://www.wikidata.org/entity/Q29615604',
    'http://www.wikidata.org/entity/Q29615605',
    'http://www.wikidata.org/entity/Q29615607',
    'http://www.wikidata.org/entity/Q29615608',
    'http://www.wikidata.org/entity/Q29615609',
    'http://www.wikidata.org/entity/Q29615610',
    'http://www.wikidata.org/entity/Q29615612',
    'http://www.wikidata.org/entity/Q29615613',
    'http://www.wikidata.org/entity/Q29615614',
    'http://www.wikidata.org/entity/Q29615615',
    'http://www.wikidata.org/entity/Q29615616',
    'http://www.wikidata.org/entity/Q29615617',
    'http://www.wikidata.org/entity/Q29615618',
    'http://www.wikidata.org/entity/Q29615619',
    'http://www.wikidata.org/entity/Q29615620',
    'http://www.wikidata.org/entity/Q29615622',
    'http://www.wikidata.org/entity/Q29615623',
    'http://www.wikidata.org/entity/Q29615624',
    'http://www.wikidata.org/entity/Q29615625',
    'http://www.wikidata.org/entity/Q29615626',
    'http://www.wikidata.org/entity/Q29615627',
    'http://www.wikidata.org/entity/Q29615628',
    'http://www.wikidata.org/entity/Q29615629',
    'http://www.wikidata.org/entity/Q29615630',
    'http://www.wikidata.org/entity/Q29615631',
    'http://www.wikidata.org/entity/Q29615632',
    'http://www.wikidata.org/entity/Q29615633',
    'http://www.wikidata.org/entity/Q29615634',
    'http://www.wikidata.org/entity/Q29615635',
    'http://www.wikidata.org/entity/Q29615636',
    'http://www.wikidata.org/entity/Q29615637',
    'http://www.wikidata.org/entity/Q29615638',
    'http://www.wikidata.org/entity/Q29615639',
    'http://www.wikidata.org/entity/Q29615640',
    'http://www.wikidata.org/entity/Q29615641',
    'http://www.wikidata.org/entity/Q29615642',
    'http://www.wikidata.org/entity/Q29615643',
    'http://www.wikidata.org/entity/Q29615644',
    'http://www.wikidata.org/entity/Q29615646',
    'http://www.wikidata.org/entity/Q29615647',
    'http://www.wikidata.org/entity/Q29615648',
    'http://www.wikidata.org/entity/Q29615649',
    'http://www.wikidata.org/entity/Q29615650',
    'http://www.wikidata.org/entity/Q29615653',
    'http://www.wikidata.org/entity/Q29615654',
    'http://www.wikidata.org/entity/Q29615655',
    'http://www.wikidata.org/entity/Q29615656',
    'http://www.wikidata.org/entity/Q29615658',
    'http://www.wikidata.org/entity/Q29615659',
    'http://www.wikidata.org/entity/Q29615660',
    'http://www.wikidata.org/entity/Q29615661',
    'http://www.wikidata.org/entity/Q29615662',
    'http://www.wikidata.org/entity/Q29615663',
    'http://www.wikidata.org/entity/Q29615664',
    'http://www.wikidata.org/entity/Q29615665',
    'http://www.wikidata.org/entity/Q29615666',
    'http://www.wikidata.org/entity/Q29615667',
    'http://www.wikidata.org/entity/Q29615668',
    'http://www.wikidata.org/entity/Q29615669',
    'http://www.wikidata.org/entity/Q29615670',
    'http://www.wikidata.org/entity/Q29615673',
    'http://www.wikidata.org/entity/Q29615677',
    'http://www.wikidata.org/entity/Q29615678',
    'http://www.wikidata.org/entity/Q29615679',
    'http://www.wikidata.org/entity/Q29615680',
    'http://www.wikidata.org/entity/Q29615681',
    'http://www.wikidata.org/entity/Q29615682',
    'http://www.wikidata.org/entity/Q29615683',
    'http://www.wikidata.org/entity/Q29615684',
    'http://www.wikidata.org/entity/Q29615685',
    'http://www.wikidata.org/entity/Q29615686',
    'http://www.wikidata.org/entity/Q29615687',
    'http://www.wikidata.org/entity/Q29615688',
    'http://www.wikidata.org/entity/Q29615689',
    'http://www.wikidata.org/entity/Q29615690',
    'http://www.wikidata.org/entity/Q29615691',
    'http://www.wikidata.org/entity/Q29615692',
    'http://www.wikidata.org/entity/Q29615693',
    'http://www.wikidata.org/entity/Q29615694',
    'http://www.wikidata.org/entity/Q29615695',
    'http://www.wikidata.org/entity/Q29615696',
    'http://www.wikidata.org/entity/Q29615697',
    'http://www.wikidata.org/entity/Q29615698',
    'http://www.wikidata.org/entity/Q29615699',
    'http://www.wikidata.org/entity/Q29615701',
    'http://www.wikidata.org/entity/Q29615702',
    'http://www.wikidata.org/entity/Q29615703',
    'http://www.wikidata.org/entity/Q29615704',
    'http://www.wikidata.org/entity/Q29615705',
    'http://www.wikidata.org/entity/Q29615706',
    'http://www.wikidata.org/entity/Q29615707',
    'http://www.wikidata.org/entity/Q29615708',
    'http://www.wikidata.org/entity/Q29615709',
    'http://www.wikidata.org/entity/Q29615710',
    'http://www.wikidata.org/entity/Q29615712',
    'http://www.wikidata.org/entity/Q29615713',
    'http://www.wikidata.org/entity/Q29615714',
    'http://www.wikidata.org/entity/Q29615716',
    'http://www.wikidata.org/entity/Q29615717',
    'http://www.wikidata.org/entity/Q29615720',
    'http://www.wikidata.org/entity/Q29615721',
    'http://www.wikidata.org/entity/Q29615722',
    'http://www.wikidata.org/entity/Q29615723',
    'http://www.wikidata.org/entity/Q29615725',
    'http://www.wikidata.org/entity/Q29615726',
    'http://www.wikidata.org/entity/Q29615727',
    'http://www.wikidata.org/entity/Q29615728',
    'http://www.wikidata.org/entity/Q29615729',
    'http://www.wikidata.org/entity/Q29615730',
    'http://www.wikidata.org/entity/Q29615733',
    'http://www.wikidata.org/entity/Q29615735',
    'http://www.wikidata.org/entity/Q29615736',
    'http://www.wikidata.org/entity/Q29615737',
    'http://www.wikidata.org/entity/Q29615739',
    'http://www.wikidata.org/entity/Q29615740',
    'http://www.wikidata.org/entity/Q29615741',
    'http://www.wikidata.org/entity/Q29615742',
    'http://www.wikidata.org/entity/Q29615744',
    'http://www.wikidata.org/entity/Q29615745',
    'http://www.wikidata.org/entity/Q29615747',
    'http://www.wikidata.org/entity/Q29615748',
    'http://www.wikidata.org/entity/Q29615749',
    'http://www.wikidata.org/entity/Q29615751',
    'http://www.wikidata.org/entity/Q29615752',
    'http://www.wikidata.org/entity/Q29615753',
    'http://www.wikidata.org/entity/Q29615756',
    'http://www.wikidata.org/entity/Q29615757',
    'http://www.wikidata.org/entity/Q29615758',
    'http://www.wikidata.org/entity/Q29615759',
    'http://www.wikidata.org/entity/Q29615760',
    'http://www.wikidata.org/entity/Q29615762',
    'http://www.wikidata.org/entity/Q29615763',
    'http://www.wikidata.org/entity/Q29615764',
    'http://www.wikidata.org/entity/Q29615765',
    'http://www.wikidata.org/entity/Q29615766',
    'http://www.wikidata.org/entity/Q29615767',
    'http://www.wikidata.org/entity/Q29615770',
    'http://www.wikidata.org/entity/Q29615771',
    'http://www.wikidata.org/entity/Q29615772',
    'http://www.wikidata.org/entity/Q29615773',
    'http://www.wikidata.org/entity/Q29615775',
    'http://www.wikidata.org/entity/Q29615776',
    'http://www.wikidata.org/entity/Q29615777',
    'http://www.wikidata.org/entity/Q29615778',
    'http://www.wikidata.org/entity/Q29615780',
    'http://www.wikidata.org/entity/Q29615781',
    'http://www.wikidata.org/entity/Q29615782',
    'http://www.wikidata.org/entity/Q29615783',
    'http://www.wikidata.org/entity/Q29615784',
    'http://www.wikidata.org/entity/Q29615785',
    'http://www.wikidata.org/entity/Q29615786',
    'http://www.wikidata.org/entity/Q29615788',
    'http://www.wikidata.org/entity/Q29615790',
    'http://www.wikidata.org/entity/Q29615791',
    'http://www.wikidata.org/entity/Q29615792',
    'http://www.wikidata.org/entity/Q29615793',
    'http://www.wikidata.org/entity/Q29615794',
    'http://www.wikidata.org/entity/Q29615797',
    'http://www.wikidata.org/entity/Q29615798',
    'http://www.wikidata.org/entity/Q29615799',
    'http://www.wikidata.org/entity/Q29615800',
    'http://www.wikidata.org/entity/Q29615801',
    'http://www.wikidata.org/entity/Q29615802',
    'http://www.wikidata.org/entity/Q29615803',
    'http://www.wikidata.org/entity/Q29615804',
    'http://www.wikidata.org/entity/Q29615806',
    'http://www.wikidata.org/entity/Q29615807',
    'http://www.wikidata.org/entity/Q29615808',
    'http://www.wikidata.org/entity/Q29615809',
    'http://www.wikidata.org/entity/Q29615810',
    'http://www.wikidata.org/entity/Q29615811',
    'http://www.wikidata.org/entity/Q29615812',
    'http://www.wikidata.org/entity/Q29615813',
    'http://www.wikidata.org/entity/Q29615814',
    'http://www.wikidata.org/entity/Q29615815',
    'http://www.wikidata.org/entity/Q29615816',
    'http://www.wikidata.org/entity/Q29615817',
    'http://www.wikidata.org/entity/Q29615818',
    'http://www.wikidata.org/entity/Q29615821',
    'http://www.wikidata.org/entity/Q29615822',
    'http://www.wikidata.org/entity/Q29615823',
    'http://www.wikidata.org/entity/Q29615825',
    'http://www.wikidata.org/entity/Q29615826',
    'http://www.wikidata.org/entity/Q29615827',
    'http://www.wikidata.org/entity/Q29615828',
    'http://www.wikidata.org/entity/Q29615829',
    'http://www.wikidata.org/entity/Q29615830',
    'http://www.wikidata.org/entity/Q29615831',
    'http://www.wikidata.org/entity/Q29615832',
    'http://www.wikidata.org/entity/Q29615833',
    'http://www.wikidata.org/entity/Q29615834',
    'http://www.wikidata.org/entity/Q29615835',
    'http://www.wikidata.org/entity/Q29615836',
    'http://www.wikidata.org/entity/Q29615838',
    'http://www.wikidata.org/entity/Q29615839',
    'http://www.wikidata.org/entity/Q29615840',
    'http://www.wikidata.org/entity/Q29615841',
    'http://www.wikidata.org/entity/Q29615842',
    'http://www.wikidata.org/entity/Q29615843',
    'http://www.wikidata.org/entity/Q29615845',
    'http://www.wikidata.org/entity/Q29615847',
    'http://www.wikidata.org/entity/Q29615848',
    'http://www.wikidata.org/entity/Q29615849',
    'http://www.wikidata.org/entity/Q29615852',
    'http://www.wikidata.org/entity/Q29615853',
    'http://www.wikidata.org/entity/Q29615854',
    'http://www.wikidata.org/entity/Q29615855',
    'http://www.wikidata.org/entity/Q29615856',
    'http://www.wikidata.org/entity/Q29615857',
    'http://www.wikidata.org/entity/Q29615860',
    'http://www.wikidata.org/entity/Q29615861',
    'http://www.wikidata.org/entity/Q29615862',
    'http://www.wikidata.org/entity/Q29615863',
    'http://www.wikidata.org/entity/Q29615864',
    'http://www.wikidata.org/entity/Q29615865',
    'http://www.wikidata.org/entity/Q29615866',
    'http://www.wikidata.org/entity/Q29615867',
    'http://www.wikidata.org/entity/Q29615868',
    'http://www.wikidata.org/entity/Q29615869',
    'http://www.wikidata.org/entity/Q29615871',
    'http://www.wikidata.org/entity/Q29615872',
    'http://www.wikidata.org/entity/Q29615873',
    'http://www.wikidata.org/entity/Q29615874',
    'http://www.wikidata.org/entity/Q29615875',
    'http://www.wikidata.org/entity/Q29615877',
    'http://www.wikidata.org/entity/Q29615879',
    'http://www.wikidata.org/entity/Q29615880',
    'http://www.wikidata.org/entity/Q29615882',
    'http://www.wikidata.org/entity/Q29615885',
    'http://www.wikidata.org/entity/Q29615886',
    'http://www.wikidata.org/entity/Q29615888',
    'http://www.wikidata.org/entity/Q29615891',
    'http://www.wikidata.org/entity/Q29615892',
    'http://www.wikidata.org/entity/Q29615894',
    'http://www.wikidata.org/entity/Q29615896',
    'http://www.wikidata.org/entity/Q29615898',
    'http://www.wikidata.org/entity/Q29615901',
    'http://www.wikidata.org/entity/Q29615902',
    'http://www.wikidata.org/entity/Q29615904',
    'http://www.wikidata.org/entity/Q29615905',
    'http://www.wikidata.org/entity/Q29615906',
    'http://www.wikidata.org/entity/Q29615907',
    'http://www.wikidata.org/entity/Q29615908',
    'http://www.wikidata.org/entity/Q29615910',
    'http://www.wikidata.org/entity/Q29615912',
    'http://www.wikidata.org/entity/Q29615913',
    'http://www.wikidata.org/entity/Q29615914',
    'http://www.wikidata.org/entity/Q29615916',
    'http://www.wikidata.org/entity/Q29615917',
    'http://www.wikidata.org/entity/Q29615918',
    'http://www.wikidata.org/entity/Q29615919',
    'http://www.wikidata.org/entity/Q29615920',
    'http://www.wikidata.org/entity/Q29615922',
    'http://www.wikidata.org/entity/Q29615925',
    'http://www.wikidata.org/entity/Q29615928',
    'http://www.wikidata.org/entity/Q29615931',
    'http://www.wikidata.org/entity/Q29615934',
    'http://www.wikidata.org/entity/Q29615936',
    'http://www.wikidata.org/entity/Q29615937',
    'http://www.wikidata.org/entity/Q29615938',
    'http://www.wikidata.org/entity/Q29615939',
    'http://www.wikidata.org/entity/Q29615940',
    'http://www.wikidata.org/entity/Q29615941',
    'http://www.wikidata.org/entity/Q29615942',
    'http://www.wikidata.org/entity/Q29615943',
    'http://www.wikidata.org/entity/Q29615944',
    'http://www.wikidata.org/entity/Q29615946',
    'http://www.wikidata.org/entity/Q29615947',
    'http://www.wikidata.org/entity/Q29615949',
    'http://www.wikidata.org/entity/Q29615950',
    'http://www.wikidata.org/entity/Q29615951',
    'http://www.wikidata.org/entity/Q29615952',
    'http://www.wikidata.org/entity/Q29615953',
    'http://www.wikidata.org/entity/Q29615957',
    'http://www.wikidata.org/entity/Q29615959',
    'http://www.wikidata.org/entity/Q29615962',
    'http://www.wikidata.org/entity/Q29615965',
    'http://www.wikidata.org/entity/Q29615967',
    'http://www.wikidata.org/entity/Q29615968',
    'http://www.wikidata.org/entity/Q29615970',
    'http://www.wikidata.org/entity/Q29615972',
    'http://www.wikidata.org/entity/Q29615973',
    'http://www.wikidata.org/entity/Q29615974',
    'http://www.wikidata.org/entity/Q29615975',
    'http://www.wikidata.org/entity/Q29615976',
    'http://www.wikidata.org/entity/Q29615977',
    'http://www.wikidata.org/entity/Q29615979',
    'http://www.wikidata.org/entity/Q29615980',
    'http://www.wikidata.org/entity/Q29615982',
    'http://www.wikidata.org/entity/Q29615984',
    'http://www.wikidata.org/entity/Q29615985',
    'http://www.wikidata.org/entity/Q29615988',
    'http://www.wikidata.org/entity/Q29615989',
    'http://www.wikidata.org/entity/Q29615990',
    'http://www.wikidata.org/entity/Q29615991',
    'http://www.wikidata.org/entity/Q29615992',
    'http://www.wikidata.org/entity/Q29615993',
    'http://www.wikidata.org/entity/Q29615995',
    'http://www.wikidata.org/entity/Q29615996',
    'http://www.wikidata.org/entity/Q29615998',
    'http://www.wikidata.org/entity/Q29615999',
    'http://www.wikidata.org/entity/Q29616000',
    'http://www.wikidata.org/entity/Q29616001',
    'http://www.wikidata.org/entity/Q29616002',
    'http://www.wikidata.org/entity/Q29616003',
    'http://www.wikidata.org/entity/Q29616004',
    'http://www.wikidata.org/entity/Q29616005',
    'http://www.wikidata.org/entity/Q29616006',
    'http://www.wikidata.org/entity/Q29616008',
    'http://www.wikidata.org/entity/Q29616009',
    'http://www.wikidata.org/entity/Q29616010',
    'http://www.wikidata.org/entity/Q29616012',
    'http://www.wikidata.org/entity/Q29616013',
    'http://www.wikidata.org/entity/Q29616014',
    'http://www.wikidata.org/entity/Q29616015',
    'http://www.wikidata.org/entity/Q29616016',
    'http://www.wikidata.org/entity/Q29616017',
    'http://www.wikidata.org/entity/Q29616018',
    'http://www.wikidata.org/entity/Q29616019',
    'http://www.wikidata.org/entity/Q29616020',
    'http://www.wikidata.org/entity/Q29616021',
    'http://www.wikidata.org/entity/Q29616022',
    'http://www.wikidata.org/entity/Q29616024',
    'http://www.wikidata.org/entity/Q29616025',
    'http://www.wikidata.org/entity/Q29616026',
    'http://www.wikidata.org/entity/Q29616027',
    'http://www.wikidata.org/entity/Q29616029',
    'http://www.wikidata.org/entity/Q29616030',
    'http://www.wikidata.org/entity/Q29616031',
    'http://www.wikidata.org/entity/Q29616032',
    'http://www.wikidata.org/entity/Q29616033',
    'http://www.wikidata.org/entity/Q29616035',
    'http://www.wikidata.org/entity/Q29616036',
    'http://www.wikidata.org/entity/Q29616037',
    'http://www.wikidata.org/entity/Q29616038',
    'http://www.wikidata.org/entity/Q29616039',
    'http://www.wikidata.org/entity/Q29616042',
    'http://www.wikidata.org/entity/Q29616043',
    'http://www.wikidata.org/entity/Q29616044',
    'http://www.wikidata.org/entity/Q29616045',
    'http://www.wikidata.org/entity/Q29616047',
    'http://www.wikidata.org/entity/Q29616048',
    'http://www.wikidata.org/entity/Q29616049',
    'http://www.wikidata.org/entity/Q29616050',
    'http://www.wikidata.org/entity/Q29616051',
    'http://www.wikidata.org/entity/Q29616052',
    'http://www.wikidata.org/entity/Q29616053',
    'http://www.wikidata.org/entity/Q29616054',
    'http://www.wikidata.org/entity/Q29616055',
    'http://www.wikidata.org/entity/Q29616056',
    'http://www.wikidata.org/entity/Q29616057',
    'http://www.wikidata.org/entity/Q29616058',
    'http://www.wikidata.org/entity/Q29616059',
    'http://www.wikidata.org/entity/Q29616060',
    'http://www.wikidata.org/entity/Q29616061',
    'http://www.wikidata.org/entity/Q29616062',
    'http://www.wikidata.org/entity/Q29616063',
    'http://www.wikidata.org/entity/Q29616064',
    'http://www.wikidata.org/entity/Q29616065',
    'http://www.wikidata.org/entity/Q29616066',
    'http://www.wikidata.org/entity/Q29616067',
    'http://www.wikidata.org/entity/Q29616068',
    'http://www.wikidata.org/entity/Q29616071',
    'http://www.wikidata.org/entity/Q29616072',
    'http://www.wikidata.org/entity/Q29616073',
    'http://www.wikidata.org/entity/Q29616074',
    'http://www.wikidata.org/entity/Q29616075',
    'http://www.wikidata.org/entity/Q29616076',
    'http://www.wikidata.org/entity/Q29616077',
    'http://www.wikidata.org/entity/Q29616078',
    'http://www.wikidata.org/entity/Q29616079',
    'http://www.wikidata.org/entity/Q29616080',
    'http://www.wikidata.org/entity/Q29616081',
    'http://www.wikidata.org/entity/Q29616082',
    'http://www.wikidata.org/entity/Q29616083',
    'http://www.wikidata.org/entity/Q29616084',
    'http://www.wikidata.org/entity/Q29616085',
    'http://www.wikidata.org/entity/Q29616086',
    'http://www.wikidata.org/entity/Q29616087',
    'http://www.wikidata.org/entity/Q29616088',
    'http://www.wikidata.org/entity/Q29616089',
    'http://www.wikidata.org/entity/Q29616090',
    'http://www.wikidata.org/entity/Q29616092',
    'http://www.wikidata.org/entity/Q29616093',
    'http://www.wikidata.org/entity/Q29616094',
    'http://www.wikidata.org/entity/Q29616095',
    'http://www.wikidata.org/entity/Q29616096',
    'http://www.wikidata.org/entity/Q29616097',
    'http://www.wikidata.org/entity/Q29616098',
    'http://www.wikidata.org/entity/Q29616100',
    'http://www.wikidata.org/entity/Q29616101',
    'http://www.wikidata.org/entity/Q29616102',
    'http://www.wikidata.org/entity/Q29616103',
    'http://www.wikidata.org/entity/Q29616104',
    'http://www.wikidata.org/entity/Q29616105',
    'http://www.wikidata.org/entity/Q29616106',
    'http://www.wikidata.org/entity/Q29616108',
    'http://www.wikidata.org/entity/Q29616109',
    'http://www.wikidata.org/entity/Q29616110',
    'http://www.wikidata.org/entity/Q29616111',
    'http://www.wikidata.org/entity/Q29616112',
    'http://www.wikidata.org/entity/Q29616114',
    'http://www.wikidata.org/entity/Q29616115',
    'http://www.wikidata.org/entity/Q29616116',
    'http://www.wikidata.org/entity/Q29616117',
    'http://www.wikidata.org/entity/Q29616118',
    'http://www.wikidata.org/entity/Q29616119',
    'http://www.wikidata.org/entity/Q29616120',
    'http://www.wikidata.org/entity/Q29616121',
    'http://www.wikidata.org/entity/Q29616122',
    'http://www.wikidata.org/entity/Q29616123',
    'http://www.wikidata.org/entity/Q29616124',
    'http://www.wikidata.org/entity/Q29616126',
    'http://www.wikidata.org/entity/Q29616127',
    'http://www.wikidata.org/entity/Q29616128',
    'http://www.wikidata.org/entity/Q29616129',
    'http://www.wikidata.org/entity/Q29616130',
    'http://www.wikidata.org/entity/Q29616131',
    'http://www.wikidata.org/entity/Q29616132',
    'http://www.wikidata.org/entity/Q29616134',
    'http://www.wikidata.org/entity/Q29616135',
    'http://www.wikidata.org/entity/Q29616136',
    'http://www.wikidata.org/entity/Q29616139',
    'http://www.wikidata.org/entity/Q29616140',
    'http://www.wikidata.org/entity/Q29616141',
    'http://www.wikidata.org/entity/Q29616142',
    'http://www.wikidata.org/entity/Q29616143',
    'http://www.wikidata.org/entity/Q29616144',
    'http://www.wikidata.org/entity/Q29616145',
    'http://www.wikidata.org/entity/Q29616146',
    'http://www.wikidata.org/entity/Q29616149',
    'http://www.wikidata.org/entity/Q29616150',
    'http://www.wikidata.org/entity/Q29616151',
    'http://www.wikidata.org/entity/Q29616153',
    'http://www.wikidata.org/entity/Q29616154',
    'http://www.wikidata.org/entity/Q29616155',
    'http://www.wikidata.org/entity/Q29616156',
    'http://www.wikidata.org/entity/Q29616157',
    'http://www.wikidata.org/entity/Q29616158',
    'http://www.wikidata.org/entity/Q29616159',
    'http://www.wikidata.org/entity/Q29616160',
    'http://www.wikidata.org/entity/Q29616161',
    'http://www.wikidata.org/entity/Q29616162',
    'http://www.wikidata.org/entity/Q29616163',
    'http://www.wikidata.org/entity/Q29616164',
    'http://www.wikidata.org/entity/Q29616167',
    'http://www.wikidata.org/entity/Q29616169',
    'http://www.wikidata.org/entity/Q29616170',
    'http://www.wikidata.org/entity/Q29616171',
    'http://www.wikidata.org/entity/Q29616172',
    'http://www.wikidata.org/entity/Q29616174',
    'http://www.wikidata.org/entity/Q29616175',
    'http://www.wikidata.org/entity/Q29616176',
    'http://www.wikidata.org/entity/Q29616177',
    'http://www.wikidata.org/entity/Q29616178',
    'http://www.wikidata.org/entity/Q29616179',
    'http://www.wikidata.org/entity/Q29616180',
    'http://www.wikidata.org/entity/Q29616181',
    'http://www.wikidata.org/entity/Q29616182',
    'http://www.wikidata.org/entity/Q29616183',
    'http://www.wikidata.org/entity/Q29616185',
    'http://www.wikidata.org/entity/Q29616187',
    'http://www.wikidata.org/entity/Q29616188',
    'http://www.wikidata.org/entity/Q29616189',
    'http://www.wikidata.org/entity/Q29616190',
    'http://www.wikidata.org/entity/Q29616191',
    'http://www.wikidata.org/entity/Q29616192',
    'http://www.wikidata.org/entity/Q29616193',
    'http://www.wikidata.org/entity/Q29616194',
    'http://www.wikidata.org/entity/Q29616195',
    'http://www.wikidata.org/entity/Q29616196',
    'http://www.wikidata.org/entity/Q29616198',
    'http://www.wikidata.org/entity/Q29616199',
    'http://www.wikidata.org/entity/Q29616200',
    'http://www.wikidata.org/entity/Q29616202',
    'http://www.wikidata.org/entity/Q29616204',
    'http://www.wikidata.org/entity/Q29616205',
    'http://www.wikidata.org/entity/Q29616206',
    'http://www.wikidata.org/entity/Q29616207',
    'http://www.wikidata.org/entity/Q29616208',
    'http://www.wikidata.org/entity/Q29616209',
    'http://www.wikidata.org/entity/Q29616210',
    'http://www.wikidata.org/entity/Q29616212',
    'http://www.wikidata.org/entity/Q29616213',
    'http://www.wikidata.org/entity/Q29616214',
    'http://www.wikidata.org/entity/Q29616215',
    'http://www.wikidata.org/entity/Q29616216',
    'http://www.wikidata.org/entity/Q29616217',
    'http://www.wikidata.org/entity/Q29616218',
    'http://www.wikidata.org/entity/Q29616220',
    'http://www.wikidata.org/entity/Q29616221',
    'http://www.wikidata.org/entity/Q29616222',
    'http://www.wikidata.org/entity/Q29616225',
    'http://www.wikidata.org/entity/Q29616227',
    'http://www.wikidata.org/entity/Q29616228',
    'http://www.wikidata.org/entity/Q29616229',
    'http://www.wikidata.org/entity/Q29616230',
    'http://www.wikidata.org/entity/Q29616232',
    'http://www.wikidata.org/entity/Q29616233',
    'http://www.wikidata.org/entity/Q29616234',
    'http://www.wikidata.org/entity/Q29616235',
    'http://www.wikidata.org/entity/Q29616236',
    'http://www.wikidata.org/entity/Q29616238',
    'http://www.wikidata.org/entity/Q29616240',
    'http://www.wikidata.org/entity/Q29616241',
    'http://www.wikidata.org/entity/Q29616242',
    'http://www.wikidata.org/entity/Q29616243',
    'http://www.wikidata.org/entity/Q29616244',
    'http://www.wikidata.org/entity/Q29616245',
    'http://www.wikidata.org/entity/Q29616246',
    'http://www.wikidata.org/entity/Q29616247',
    'http://www.wikidata.org/entity/Q29616248',
    'http://www.wikidata.org/entity/Q29616249',
    'http://www.wikidata.org/entity/Q29616250',
    'http://www.wikidata.org/entity/Q29616252',
    'http://www.wikidata.org/entity/Q29616253',
    'http://www.wikidata.org/entity/Q29616254',
    'http://www.wikidata.org/entity/Q29616255',
    'http://www.wikidata.org/entity/Q29616258',
    'http://www.wikidata.org/entity/Q29616259',
    'http://www.wikidata.org/entity/Q29616260',
    'http://www.wikidata.org/entity/Q29616261',
    'http://www.wikidata.org/entity/Q29616262',
    'http://www.wikidata.org/entity/Q29616264',
    'http://www.wikidata.org/entity/Q29616266',
    'http://www.wikidata.org/entity/Q29616267',
    'http://www.wikidata.org/entity/Q29616268',
    'http://www.wikidata.org/entity/Q29616269',
    'http://www.wikidata.org/entity/Q29616270',
    'http://www.wikidata.org/entity/Q29616271',
    'http://www.wikidata.org/entity/Q29616272',
    'http://www.wikidata.org/entity/Q29616273',
    'http://www.wikidata.org/entity/Q29616274',
    'http://www.wikidata.org/entity/Q29616275',
    'http://www.wikidata.org/entity/Q29616276',
    'http://www.wikidata.org/entity/Q29616277',
    'http://www.wikidata.org/entity/Q29616279',
    'http://www.wikidata.org/entity/Q29616280',
    'http://www.wikidata.org/entity/Q29616281',
    'http://www.wikidata.org/entity/Q29616282',
    'http://www.wikidata.org/entity/Q29616283',
    'http://www.wikidata.org/entity/Q29616284',
    'http://www.wikidata.org/entity/Q29616285',
    'http://www.wikidata.org/entity/Q29616286',
    'http://www.wikidata.org/entity/Q29616287',
    'http://www.wikidata.org/entity/Q29616288',
    'http://www.wikidata.org/entity/Q29616289',
    'http://www.wikidata.org/entity/Q29616290',
    'http://www.wikidata.org/entity/Q29616291',
    'http://www.wikidata.org/entity/Q29616293',
    'http://www.wikidata.org/entity/Q29616294',
    'http://www.wikidata.org/entity/Q29616295',
    'http://www.wikidata.org/entity/Q29616296',
    'http://www.wikidata.org/entity/Q29616297',
    'http://www.wikidata.org/entity/Q29616298',
    'http://www.wikidata.org/entity/Q29616299',
    'http://www.wikidata.org/entity/Q29616300',
    'http://www.wikidata.org/entity/Q29616301',
    'http://www.wikidata.org/entity/Q29616302',
    'http://www.wikidata.org/entity/Q29616303',
    'http://www.wikidata.org/entity/Q29616305',
    'http://www.wikidata.org/entity/Q29616306',
    'http://www.wikidata.org/entity/Q29616307',
    'http://www.wikidata.org/entity/Q29616308',
    'http://www.wikidata.org/entity/Q29616309',
    'http://www.wikidata.org/entity/Q29616310',
    'http://www.wikidata.org/entity/Q29616311',
    'http://www.wikidata.org/entity/Q29616312',
    'http://www.wikidata.org/entity/Q29616314',
    'http://www.wikidata.org/entity/Q29616315',
    'http://www.wikidata.org/entity/Q29616316',
    'http://www.wikidata.org/entity/Q29616317',
    'http://www.wikidata.org/entity/Q29616318',
    'http://www.wikidata.org/entity/Q29616319',
    'http://www.wikidata.org/entity/Q29616320',
    'http://www.wikidata.org/entity/Q29616322',
    'http://www.wikidata.org/entity/Q29616324',
    'http://www.wikidata.org/entity/Q29616325',
    'http://www.wikidata.org/entity/Q29616326',
    'http://www.wikidata.org/entity/Q29616327',
    'http://www.wikidata.org/entity/Q29616328',
    'http://www.wikidata.org/entity/Q29616330',
    'http://www.wikidata.org/entity/Q29616331',
    'http://www.wikidata.org/entity/Q29616332',
    'http://www.wikidata.org/entity/Q29616333',
    'http://www.wikidata.org/entity/Q29616335',
    'http://www.wikidata.org/entity/Q29616338',
    'http://www.wikidata.org/entity/Q29616340',
    'http://www.wikidata.org/entity/Q29616341',
    'http://www.wikidata.org/entity/Q29616342',
    'http://www.wikidata.org/entity/Q29616343',
    'http://www.wikidata.org/entity/Q29616344',
    'http://www.wikidata.org/entity/Q29616345',
    'http://www.wikidata.org/entity/Q29616346',
    'http://www.wikidata.org/entity/Q29616347',
    'http://www.wikidata.org/entity/Q29616348',
    'http://www.wikidata.org/entity/Q29616349',
    'http://www.wikidata.org/entity/Q29616350',
    'http://www.wikidata.org/entity/Q29616351',
    'http://www.wikidata.org/entity/Q29616352',
    'http://www.wikidata.org/entity/Q29616353',
    'http://www.wikidata.org/entity/Q29616355',
    'http://www.wikidata.org/entity/Q29616356',
    'http://www.wikidata.org/entity/Q29616357',
    'http://www.wikidata.org/entity/Q29616359',
    'http://www.wikidata.org/entity/Q29616360',
    'http://www.wikidata.org/entity/Q29616361',
    'http://www.wikidata.org/entity/Q29616363',
    'http://www.wikidata.org/entity/Q29616364',
    'http://www.wikidata.org/entity/Q29616366',
    'http://www.wikidata.org/entity/Q29616367',
    'http://www.wikidata.org/entity/Q29616368',
    'http://www.wikidata.org/entity/Q29616369',
    'http://www.wikidata.org/entity/Q29616370',
    'http://www.wikidata.org/entity/Q29616371',
    'http://www.wikidata.org/entity/Q29616372',
    'http://www.wikidata.org/entity/Q29616373',
    'http://www.wikidata.org/entity/Q29616374',
    'http://www.wikidata.org/entity/Q29616375',
    'http://www.wikidata.org/entity/Q29616378',
    'http://www.wikidata.org/entity/Q29616380',
    'http://www.wikidata.org/entity/Q29616382',
    'http://www.wikidata.org/entity/Q29616383',
    'http://www.wikidata.org/entity/Q29616384',
    'http://www.wikidata.org/entity/Q29616385',
    'http://www.wikidata.org/entity/Q29616386',
    'http://www.wikidata.org/entity/Q29616387',
    'http://www.wikidata.org/entity/Q29616388',
    'http://www.wikidata.org/entity/Q29616389',
    'http://www.wikidata.org/entity/Q29616390',
    'http://www.wikidata.org/entity/Q29616391',
    'http://www.wikidata.org/entity/Q29616392',
    'http://www.wikidata.org/entity/Q29616393',
    'http://www.wikidata.org/entity/Q29616394',
    'http://www.wikidata.org/entity/Q29616396',
    'http://www.wikidata.org/entity/Q29616397',
    'http://www.wikidata.org/entity/Q29616398',
    'http://www.wikidata.org/entity/Q29616399',
    'http://www.wikidata.org/entity/Q29616401',
    'http://www.wikidata.org/entity/Q29616402',
    'http://www.wikidata.org/entity/Q29616404',
    'http://www.wikidata.org/entity/Q29616405',
    'http://www.wikidata.org/entity/Q29616406',
    'http://www.wikidata.org/entity/Q29616407',
    'http://www.wikidata.org/entity/Q29616408',
    'http://www.wikidata.org/entity/Q29616409',
    'http://www.wikidata.org/entity/Q29616410',
    'http://www.wikidata.org/entity/Q29616411',
    'http://www.wikidata.org/entity/Q29616412',
    'http://www.wikidata.org/entity/Q29616413',
    'http://www.wikidata.org/entity/Q29616415',
    'http://www.wikidata.org/entity/Q29616416',
    'http://www.wikidata.org/entity/Q29616417',
    'http://www.wikidata.org/entity/Q29616418',
    'http://www.wikidata.org/entity/Q29616419',
    'http://www.wikidata.org/entity/Q29616420',
    'http://www.wikidata.org/entity/Q29616421',
    'http://www.wikidata.org/entity/Q29616423',
    'http://www.wikidata.org/entity/Q29616426',
    'http://www.wikidata.org/entity/Q29616427',
    'http://www.wikidata.org/entity/Q29616428',
    'http://www.wikidata.org/entity/Q29616430',
    'http://www.wikidata.org/entity/Q29616431',
    'http://www.wikidata.org/entity/Q29616432',
    'http://www.wikidata.org/entity/Q29616433',
    'http://www.wikidata.org/entity/Q29616436',
    'http://www.wikidata.org/entity/Q29616437',
    'http://www.wikidata.org/entity/Q29616439',
    'http://www.wikidata.org/entity/Q29616440',
    'http://www.wikidata.org/entity/Q29616445',
    'http://www.wikidata.org/entity/Q29616446',
    'http://www.wikidata.org/entity/Q29616447',
    'http://www.wikidata.org/entity/Q29616448',
    'http://www.wikidata.org/entity/Q29616452',
    'http://www.wikidata.org/entity/Q29616453',
    'http://www.wikidata.org/entity/Q29616456',
    'http://www.wikidata.org/entity/Q29616458',
    'http://www.wikidata.org/entity/Q29616459',
    'http://www.wikidata.org/entity/Q29616460',
    'http://www.wikidata.org/entity/Q29616461',
    'http://www.wikidata.org/entity/Q29616462',
    'http://www.wikidata.org/entity/Q29616463',
    'http://www.wikidata.org/entity/Q29616464',
    'http://www.wikidata.org/entity/Q29616466',
    'http://www.wikidata.org/entity/Q29616467',
    'http://www.wikidata.org/entity/Q29616468',
    'http://www.wikidata.org/entity/Q29616471',
    'http://www.wikidata.org/entity/Q29616473',
    'http://www.wikidata.org/entity/Q29616474',
    'http://www.wikidata.org/entity/Q29616475',
    'http://www.wikidata.org/entity/Q29616476',
    'http://www.wikidata.org/entity/Q29616477',
    'http://www.wikidata.org/entity/Q29616478',
    'http://www.wikidata.org/entity/Q29616480',
    'http://www.wikidata.org/entity/Q29616481',
    'http://www.wikidata.org/entity/Q29616482',
    'http://www.wikidata.org/entity/Q29616483',
    'http://www.wikidata.org/entity/Q29616489',
    'http://www.wikidata.org/entity/Q29616490',
    'http://www.wikidata.org/entity/Q29616491',
    'http://www.wikidata.org/entity/Q29616492',
    'http://www.wikidata.org/entity/Q29616493',
    'http://www.wikidata.org/entity/Q29616495',
    'http://www.wikidata.org/entity/Q29616498',
    'http://www.wikidata.org/entity/Q29616499',
    'http://www.wikidata.org/entity/Q29616500',
    'http://www.wikidata.org/entity/Q29616501',
    'http://www.wikidata.org/entity/Q29616503',
    'http://www.wikidata.org/entity/Q29616506',
    'http://www.wikidata.org/entity/Q29616508',
    'http://www.wikidata.org/entity/Q29616509',
    'http://www.wikidata.org/entity/Q29616510',
    'http://www.wikidata.org/entity/Q29616511',
    'http://www.wikidata.org/entity/Q29616513',
    'http://www.wikidata.org/entity/Q29616514',
    'http://www.wikidata.org/entity/Q29616515',
    'http://www.wikidata.org/entity/Q29616516',
    'http://www.wikidata.org/entity/Q29616519',
    'http://www.wikidata.org/entity/Q29616520',
    'http://www.wikidata.org/entity/Q29616521',
    'http://www.wikidata.org/entity/Q29616523',
    'http://www.wikidata.org/entity/Q29616526',
    'http://www.wikidata.org/entity/Q29616527',
    'http://www.wikidata.org/entity/Q29616528',
    'http://www.wikidata.org/entity/Q29616531',
    'http://www.wikidata.org/entity/Q29616532',
    'http://www.wikidata.org/entity/Q29616533',
    'http://www.wikidata.org/entity/Q29616534',
    'http://www.wikidata.org/entity/Q29616535',
    'http://www.wikidata.org/entity/Q29616536',
    'http://www.wikidata.org/entity/Q29616537',
    'http://www.wikidata.org/entity/Q29616538',
    'http://www.wikidata.org/entity/Q29616539',
    'http://www.wikidata.org/entity/Q29616541',
    'http://www.wikidata.org/entity/Q29616543',
    'http://www.wikidata.org/entity/Q29616547',
    'http://www.wikidata.org/entity/Q29616548',
    'http://www.wikidata.org/entity/Q29616549',
    'http://www.wikidata.org/entity/Q29616550',
    'http://www.wikidata.org/entity/Q29616551',
    'http://www.wikidata.org/entity/Q29616552',
    'http://www.wikidata.org/entity/Q29616553',
    'http://www.wikidata.org/entity/Q29616554',
    'http://www.wikidata.org/entity/Q29616556',
    'http://www.wikidata.org/entity/Q29616557',
    'http://www.wikidata.org/entity/Q29616558',
    'http://www.wikidata.org/entity/Q29616559',
    'http://www.wikidata.org/entity/Q29616560',
    'http://www.wikidata.org/entity/Q29616563',
    'http://www.wikidata.org/entity/Q29616564',
    'http://www.wikidata.org/entity/Q29616565',
    'http://www.wikidata.org/entity/Q29616566',
    'http://www.wikidata.org/entity/Q29616567',
    'http://www.wikidata.org/entity/Q29616568',
    'http://www.wikidata.org/entity/Q29616569',
    'http://www.wikidata.org/entity/Q29616570',
    'http://www.wikidata.org/entity/Q29616572',
    'http://www.wikidata.org/entity/Q29616575',
    'http://www.wikidata.org/entity/Q29616578',
    'http://www.wikidata.org/entity/Q29616584',
    'http://www.wikidata.org/entity/Q29616585',
    'http://www.wikidata.org/entity/Q29616586',
    'http://www.wikidata.org/entity/Q29616587',
    'http://www.wikidata.org/entity/Q29616589',
    'http://www.wikidata.org/entity/Q29616590',
    'http://www.wikidata.org/entity/Q29616591',
    'http://www.wikidata.org/entity/Q29616592',
    'http://www.wikidata.org/entity/Q29616593',
    'http://www.wikidata.org/entity/Q29616594',
    'http://www.wikidata.org/entity/Q29616595',
    'http://www.wikidata.org/entity/Q29616597',
    'http://www.wikidata.org/entity/Q29616598',
    'http://www.wikidata.org/entity/Q29616599',
    'http://www.wikidata.org/entity/Q29616600',
    'http://www.wikidata.org/entity/Q29616601',
    'http://www.wikidata.org/entity/Q29616602',
    'http://www.wikidata.org/entity/Q29616603',
    'http://www.wikidata.org/entity/Q29616604',
    'http://www.wikidata.org/entity/Q29616607',
    'http://www.wikidata.org/entity/Q29616609',
    'http://www.wikidata.org/entity/Q29616610',
    'http://www.wikidata.org/entity/Q29616612',
    'http://www.wikidata.org/entity/Q29616613',
    'http://www.wikidata.org/entity/Q29616614',
    'http://www.wikidata.org/entity/Q29616615',
    'http://www.wikidata.org/entity/Q29616616',
    'http://www.wikidata.org/entity/Q29616617',
    'http://www.wikidata.org/entity/Q29616618',
    'http://www.wikidata.org/entity/Q29616619',
    'http://www.wikidata.org/entity/Q29616620',
    'http://www.wikidata.org/entity/Q29616621',
    'http://www.wikidata.org/entity/Q29616622',
    'http://www.wikidata.org/entity/Q29616623',
    'http://www.wikidata.org/entity/Q29616624',
    'http://www.wikidata.org/entity/Q29616625',
    'http://www.wikidata.org/entity/Q29616626',
    'http://www.wikidata.org/entity/Q29616627',
    'http://www.wikidata.org/entity/Q29616628',
    'http://www.wikidata.org/entity/Q29616632',
    'http://www.wikidata.org/entity/Q29616633',
    'http://www.wikidata.org/entity/Q29616634',
    'http://www.wikidata.org/entity/Q29616636',
    'http://www.wikidata.org/entity/Q29616640',
    'http://www.wikidata.org/entity/Q29616641',
    'http://www.wikidata.org/entity/Q29616642',
    'http://www.wikidata.org/entity/Q29616643',
    'http://www.wikidata.org/entity/Q29616644',
    'http://www.wikidata.org/entity/Q29616645',
    'http://www.wikidata.org/entity/Q29616646',
    'http://www.wikidata.org/entity/Q29616649',
    'http://www.wikidata.org/entity/Q29616650',
    'http://www.wikidata.org/entity/Q29616651',
    'http://www.wikidata.org/entity/Q29616652',
    'http://www.wikidata.org/entity/Q29616653',
    'http://www.wikidata.org/entity/Q29616655',
    'http://www.wikidata.org/entity/Q29616658',
    'http://www.wikidata.org/entity/Q29616661',
    'http://www.wikidata.org/entity/Q29616664',
    'http://www.wikidata.org/entity/Q29616667',
    'http://www.wikidata.org/entity/Q29616670',
    'http://www.wikidata.org/entity/Q29616673',
    'http://www.wikidata.org/entity/Q29616676',
    'http://www.wikidata.org/entity/Q29616679',
    'http://www.wikidata.org/entity/Q29616683',
    'http://www.wikidata.org/entity/Q29616686',
    'http://www.wikidata.org/entity/Q29616689',
    'http://www.wikidata.org/entity/Q29616694',
    'http://www.wikidata.org/entity/Q29616699',
    'http://www.wikidata.org/entity/Q29616702',
    'http://www.wikidata.org/entity/Q29616706',
    'http://www.wikidata.org/entity/Q29616709',
    'http://www.wikidata.org/entity/Q29616710',
    'http://www.wikidata.org/entity/Q29616711',
    'http://www.wikidata.org/entity/Q29616712',
    'http://www.wikidata.org/entity/Q29616715',
    'http://www.wikidata.org/entity/Q29616716',
    'http://www.wikidata.org/entity/Q29616717',
    'http://www.wikidata.org/entity/Q29616718',
    'http://www.wikidata.org/entity/Q29616719',
    'http://www.wikidata.org/entity/Q29616722',
    'http://www.wikidata.org/entity/Q29616723',
    'http://www.wikidata.org/entity/Q29616724',
    'http://www.wikidata.org/entity/Q29616725',
    'http://www.wikidata.org/entity/Q29616726',
    'http://www.wikidata.org/entity/Q29616727',
    'http://www.wikidata.org/entity/Q29616728',
    'http://www.wikidata.org/entity/Q29616729',
    'http://www.wikidata.org/entity/Q29616732',
    'http://www.wikidata.org/entity/Q29616734',
    'http://www.wikidata.org/entity/Q29616735',
    'http://www.wikidata.org/entity/Q29616736',
    'http://www.wikidata.org/entity/Q29616737',
    'http://www.wikidata.org/entity/Q29616738',
    'http://www.wikidata.org/entity/Q29616739',
    'http://www.wikidata.org/entity/Q29616740',
    'http://www.wikidata.org/entity/Q29616741',
    'http://www.wikidata.org/entity/Q29616743',
    'http://www.wikidata.org/entity/Q29616744',
    'http://www.wikidata.org/entity/Q29616745',
    'http://www.wikidata.org/entity/Q29616746',
    'http://www.wikidata.org/entity/Q29616748',
    'http://www.wikidata.org/entity/Q29616749',
    'http://www.wikidata.org/entity/Q29616750',
    'http://www.wikidata.org/entity/Q29616751',
    'http://www.wikidata.org/entity/Q29616752',
    'http://www.wikidata.org/entity/Q29616753',
    'http://www.wikidata.org/entity/Q29616754',
    'http://www.wikidata.org/entity/Q29616755',
    'http://www.wikidata.org/entity/Q29616757',
    'http://www.wikidata.org/entity/Q29616758',
    'http://www.wikidata.org/entity/Q29616759',
    'http://www.wikidata.org/entity/Q29616761',
    'http://www.wikidata.org/entity/Q29616762',
    'http://www.wikidata.org/entity/Q29616763',
    'http://www.wikidata.org/entity/Q29616765',
    'http://www.wikidata.org/entity/Q29616766',
    'http://www.wikidata.org/entity/Q29616767',
    'http://www.wikidata.org/entity/Q29616768',
    'http://www.wikidata.org/entity/Q29616769',
    'http://www.wikidata.org/entity/Q29616770',
    'http://www.wikidata.org/entity/Q29616771',
    'http://www.wikidata.org/entity/Q29616772',
    'http://www.wikidata.org/entity/Q29616774',
    'http://www.wikidata.org/entity/Q29616776',
    'http://www.wikidata.org/entity/Q29616777',
    'http://www.wikidata.org/entity/Q29616778',
    'http://www.wikidata.org/entity/Q29616779',
    'http://www.wikidata.org/entity/Q29616780',
    'http://www.wikidata.org/entity/Q29616781',
    'http://www.wikidata.org/entity/Q29616782',
    'http://www.wikidata.org/entity/Q29616783',
    'http://www.wikidata.org/entity/Q29616784',
    'http://www.wikidata.org/entity/Q29616787',
    'http://www.wikidata.org/entity/Q29616788',
    'http://www.wikidata.org/entity/Q29616789',
    'http://www.wikidata.org/entity/Q29616790',
    'http://www.wikidata.org/entity/Q29616791',
    'http://www.wikidata.org/entity/Q29616792',
    'http://www.wikidata.org/entity/Q29616793',
    'http://www.wikidata.org/entity/Q29616794',
    'http://www.wikidata.org/entity/Q29616795',
    'http://www.wikidata.org/entity/Q29616796',
    'http://www.wikidata.org/entity/Q29616797',
    'http://www.wikidata.org/entity/Q29616798',
    'http://www.wikidata.org/entity/Q29616799',
    'http://www.wikidata.org/entity/Q29616800',
    'http://www.wikidata.org/entity/Q29616801',
    'http://www.wikidata.org/entity/Q29616802',
    'http://www.wikidata.org/entity/Q29616803',
    'http://www.wikidata.org/entity/Q29616804',
    'http://www.wikidata.org/entity/Q29616805',
    'http://www.wikidata.org/entity/Q29616806',
    'http://www.wikidata.org/entity/Q29616807',
    'http://www.wikidata.org/entity/Q29616808',
    'http://www.wikidata.org/entity/Q29616809',
    'http://www.wikidata.org/entity/Q29616810',
    'http://www.wikidata.org/entity/Q29616811',
    'http://www.wikidata.org/entity/Q29616812',
    'http://www.wikidata.org/entity/Q29616814',
    'http://www.wikidata.org/entity/Q29616815',
    'http://www.wikidata.org/entity/Q29616816',
    'http://www.wikidata.org/entity/Q29616817',
    'http://www.wikidata.org/entity/Q29616818',
    'http://www.wikidata.org/entity/Q29616819',
    'http://www.wikidata.org/entity/Q29616820',
    'http://www.wikidata.org/entity/Q29616822',
    'http://www.wikidata.org/entity/Q29616823',
    'http://www.wikidata.org/entity/Q29616824',
    'http://www.wikidata.org/entity/Q29616825',
    'http://www.wikidata.org/entity/Q29616826',
    'http://www.wikidata.org/entity/Q29616827',
    'http://www.wikidata.org/entity/Q29616830',
    'http://www.wikidata.org/entity/Q29616831',
    'http://www.wikidata.org/entity/Q29616832',
    'http://www.wikidata.org/entity/Q29616833',
    'http://www.wikidata.org/entity/Q29616834',
    'http://www.wikidata.org/entity/Q29616835',
    'http://www.wikidata.org/entity/Q29616836',
    'http://www.wikidata.org/entity/Q29616838',
    'http://www.wikidata.org/entity/Q29616839',
    'http://www.wikidata.org/entity/Q29616840',
    'http://www.wikidata.org/entity/Q29616841',
    'http://www.wikidata.org/entity/Q29616842',
    'http://www.wikidata.org/entity/Q29616843',
    'http://www.wikidata.org/entity/Q29616844',
    'http://www.wikidata.org/entity/Q29616845',
    'http://www.wikidata.org/entity/Q29616846',
    'http://www.wikidata.org/entity/Q29616847',
    'http://www.wikidata.org/entity/Q29616848',
    'http://www.wikidata.org/entity/Q29616849',
    'http://www.wikidata.org/entity/Q29616851',
    'http://www.wikidata.org/entity/Q29616852',
    'http://www.wikidata.org/entity/Q29616853',
    'http://www.wikidata.org/entity/Q29616854',
    'http://www.wikidata.org/entity/Q29616855',
    'http://www.wikidata.org/entity/Q29616857',
    'http://www.wikidata.org/entity/Q29616858',
    'http://www.wikidata.org/entity/Q29616859',
    'http://www.wikidata.org/entity/Q29616860',
    'http://www.wikidata.org/entity/Q29616861',
    'http://www.wikidata.org/entity/Q29616862',
    'http://www.wikidata.org/entity/Q29616863',
    'http://www.wikidata.org/entity/Q29616864',
    'http://www.wikidata.org/entity/Q29616865',
    'http://www.wikidata.org/entity/Q29616866',
    'http://www.wikidata.org/entity/Q29617035',
    'http://www.wikidata.org/entity/Q29617037',
    'http://www.wikidata.org/entity/Q29617038',
    'http://www.wikidata.org/entity/Q29617039',
    'http://www.wikidata.org/entity/Q29617040',
    'http://www.wikidata.org/entity/Q29617042',
    'http://www.wikidata.org/entity/Q29617043',
    'http://www.wikidata.org/entity/Q29617044',
    'http://www.wikidata.org/entity/Q29617045',
    'http://www.wikidata.org/entity/Q29617046',
    'http://www.wikidata.org/entity/Q29617047',
    'http://www.wikidata.org/entity/Q29617048',
    'http://www.wikidata.org/entity/Q29617049',
    'http://www.wikidata.org/entity/Q29617050',
    'http://www.wikidata.org/entity/Q29617052',
    'http://www.wikidata.org/entity/Q29617054',
    'http://www.wikidata.org/entity/Q29617057',
    'http://www.wikidata.org/entity/Q29617058',
    'http://www.wikidata.org/entity/Q29617059',
    'http://www.wikidata.org/entity/Q29617060',
    'http://www.wikidata.org/entity/Q29617062',
    'http://www.wikidata.org/entity/Q29617063',
    'http://www.wikidata.org/entity/Q29617064',
    'http://www.wikidata.org/entity/Q29617065',
    'http://www.wikidata.org/entity/Q29617066',
    'http://www.wikidata.org/entity/Q29617072',
    'http://www.wikidata.org/entity/Q29617073',
    'http://www.wikidata.org/entity/Q29617074',
    'http://www.wikidata.org/entity/Q29617076',
    'http://www.wikidata.org/entity/Q29617079',
    'http://www.wikidata.org/entity/Q29617080',
    'http://www.wikidata.org/entity/Q29617081',
    'http://www.wikidata.org/entity/Q29617082',
    'http://www.wikidata.org/entity/Q29617083',
    'http://www.wikidata.org/entity/Q29617084',
    'http://www.wikidata.org/entity/Q29617085',
    'http://www.wikidata.org/entity/Q29617086',
    'http://www.wikidata.org/entity/Q29617088',
    'http://www.wikidata.org/entity/Q29617090',
    'http://www.wikidata.org/entity/Q29617091',
    'http://www.wikidata.org/entity/Q29617092',
    'http://www.wikidata.org/entity/Q29617095',
    'http://www.wikidata.org/entity/Q29617097',
    'http://www.wikidata.org/entity/Q29617098',
    'http://www.wikidata.org/entity/Q29617099',
    'http://www.wikidata.org/entity/Q29617100',
    'http://www.wikidata.org/entity/Q29617101',
    'http://www.wikidata.org/entity/Q29617105',
    'http://www.wikidata.org/entity/Q29617107',
    'http://www.wikidata.org/entity/Q29617111',
    'http://www.wikidata.org/entity/Q29617115',
    'http://www.wikidata.org/entity/Q29617118',
    'http://www.wikidata.org/entity/Q29617123',
    'http://www.wikidata.org/entity/Q29617127',
    'http://www.wikidata.org/entity/Q29617131',
    'http://www.wikidata.org/entity/Q29617135',
    'http://www.wikidata.org/entity/Q29617139',
    'http://www.wikidata.org/entity/Q29617144',
    'http://www.wikidata.org/entity/Q29617149',
    'http://www.wikidata.org/entity/Q29617153',
    'http://www.wikidata.org/entity/Q29617157',
    'http://www.wikidata.org/entity/Q29617161',
    'http://www.wikidata.org/entity/Q29617165',
    'http://www.wikidata.org/entity/Q29617170',
    'http://www.wikidata.org/entity/Q29617179',
    'http://www.wikidata.org/entity/Q29617184',
    'http://www.wikidata.org/entity/Q29617188',
    'http://www.wikidata.org/entity/Q29617192',
    'http://www.wikidata.org/entity/Q29617196',
    'http://www.wikidata.org/entity/Q29617201',
    'http://www.wikidata.org/entity/Q29617209',
    'http://www.wikidata.org/entity/Q29617213',
    'http://www.wikidata.org/entity/Q29617214',
    'http://www.wikidata.org/entity/Q29617215',
    'http://www.wikidata.org/entity/Q29617216',
    'http://www.wikidata.org/entity/Q29617217',
    'http://www.wikidata.org/entity/Q29617218',
    'http://www.wikidata.org/entity/Q29617219',
    'http://www.wikidata.org/entity/Q29617220',
    'http://www.wikidata.org/entity/Q29617221',
    'http://www.wikidata.org/entity/Q29617222',
    'http://www.wikidata.org/entity/Q29617224',
    'http://www.wikidata.org/entity/Q29617227',
    'http://www.wikidata.org/entity/Q29617228',
    'http://www.wikidata.org/entity/Q29617229',
    'http://www.wikidata.org/entity/Q29617230',
    'http://www.wikidata.org/entity/Q29617231',
    'http://www.wikidata.org/entity/Q29617232',
    'http://www.wikidata.org/entity/Q29617233',
    'http://www.wikidata.org/entity/Q29617236',
    'http://www.wikidata.org/entity/Q29617238',
    'http://www.wikidata.org/entity/Q29617239',
    'http://www.wikidata.org/entity/Q29617240',
    'http://www.wikidata.org/entity/Q29617241',
    'http://www.wikidata.org/entity/Q29617243',
    'http://www.wikidata.org/entity/Q29617244',
    'http://www.wikidata.org/entity/Q29617247',
    'http://www.wikidata.org/entity/Q29617248',
    'http://www.wikidata.org/entity/Q29617249',
    'http://www.wikidata.org/entity/Q29617250',
    'http://www.wikidata.org/entity/Q29617251',
    'http://www.wikidata.org/entity/Q29617252',
    'http://www.wikidata.org/entity/Q29617253',
    'http://www.wikidata.org/entity/Q29617255',
    'http://www.wikidata.org/entity/Q29617256',
    'http://www.wikidata.org/entity/Q29617257',
    'http://www.wikidata.org/entity/Q29617258',
    'http://www.wikidata.org/entity/Q29617259',
    'http://www.wikidata.org/entity/Q29617261',
    'http://www.wikidata.org/entity/Q29617262',
    'http://www.wikidata.org/entity/Q29617263',
    'http://www.wikidata.org/entity/Q29617265',
    'http://www.wikidata.org/entity/Q29617267',
    'http://www.wikidata.org/entity/Q29617269',
    'http://www.wikidata.org/entity/Q29617271',
    'http://www.wikidata.org/entity/Q29617272',
    'http://www.wikidata.org/entity/Q29617273',
    'http://www.wikidata.org/entity/Q29617274',
    'http://www.wikidata.org/entity/Q29617275',
    'http://www.wikidata.org/entity/Q29617276',
    'http://www.wikidata.org/entity/Q29617277',
    'http://www.wikidata.org/entity/Q29617278',
    'http://www.wikidata.org/entity/Q29617280',
    'http://www.wikidata.org/entity/Q29617281',
    'http://www.wikidata.org/entity/Q29617283',
    'http://www.wikidata.org/entity/Q29617284',
    'http://www.wikidata.org/entity/Q29617285',
    'http://www.wikidata.org/entity/Q29617286',
    'http://www.wikidata.org/entity/Q29617288',
    'http://www.wikidata.org/entity/Q29617289',
    'http://www.wikidata.org/entity/Q29617291',
    'http://www.wikidata.org/entity/Q29617292',
    'http://www.wikidata.org/entity/Q29617293',
    'http://www.wikidata.org/entity/Q29617294',
    'http://www.wikidata.org/entity/Q29617295',
    'http://www.wikidata.org/entity/Q29617297',
    'http://www.wikidata.org/entity/Q29617298',
    'http://www.wikidata.org/entity/Q29617299',
    'http://www.wikidata.org/entity/Q29617300',
    'http://www.wikidata.org/entity/Q29617301',
    'http://www.wikidata.org/entity/Q29617302',
    'http://www.wikidata.org/entity/Q29617304',
    'http://www.wikidata.org/entity/Q29617305',
    'http://www.wikidata.org/entity/Q29617306',
    'http://www.wikidata.org/entity/Q29617307',
    'http://www.wikidata.org/entity/Q29617308',
    'http://www.wikidata.org/entity/Q29617309',
    'http://www.wikidata.org/entity/Q29617310',
    'http://www.wikidata.org/entity/Q29617311',
    'http://www.wikidata.org/entity/Q29617312',
    'http://www.wikidata.org/entity/Q29617313',
    'http://www.wikidata.org/entity/Q29617317',
    'http://www.wikidata.org/entity/Q29617318',
    'http://www.wikidata.org/entity/Q29617319',
    'http://www.wikidata.org/entity/Q29617321',
    'http://www.wikidata.org/entity/Q29617322',
    'http://www.wikidata.org/entity/Q29617324',
    'http://www.wikidata.org/entity/Q29617325',
    'http://www.wikidata.org/entity/Q29617326',
    'http://www.wikidata.org/entity/Q29617328',
    'http://www.wikidata.org/entity/Q29617329',
    'http://www.wikidata.org/entity/Q29617330',
    'http://www.wikidata.org/entity/Q29617331',
    'http://www.wikidata.org/entity/Q29617332',
    'http://www.wikidata.org/entity/Q29617333',
    'http://www.wikidata.org/entity/Q29617334',
    'http://www.wikidata.org/entity/Q29617335',
    'http://www.wikidata.org/entity/Q29617337',
    'http://www.wikidata.org/entity/Q29617338',
    'http://www.wikidata.org/entity/Q29617340',
    'http://www.wikidata.org/entity/Q29617341',
    'http://www.wikidata.org/entity/Q29617342',
    'http://www.wikidata.org/entity/Q29617343',
    'http://www.wikidata.org/entity/Q29617345',
    'http://www.wikidata.org/entity/Q29617347',
    'http://www.wikidata.org/entity/Q29617348',
    'http://www.wikidata.org/entity/Q29617350',
    'http://www.wikidata.org/entity/Q29617352',
    'http://www.wikidata.org/entity/Q29617353',
    'http://www.wikidata.org/entity/Q29617354',
    'http://www.wikidata.org/entity/Q29617355',
    'http://www.wikidata.org/entity/Q29617356',
    'http://www.wikidata.org/entity/Q29617358',
    'http://www.wikidata.org/entity/Q29617359',
    'http://www.wikidata.org/entity/Q29617360',
    'http://www.wikidata.org/entity/Q29617361',
    'http://www.wikidata.org/entity/Q29617362',
    'http://www.wikidata.org/entity/Q29617363',
    'http://www.wikidata.org/entity/Q29617365',
    'http://www.wikidata.org/entity/Q29617366',
    'http://www.wikidata.org/entity/Q29617367',
    'http://www.wikidata.org/entity/Q29617369',
    'http://www.wikidata.org/entity/Q29617370',
    'http://www.wikidata.org/entity/Q29617372',
    'http://www.wikidata.org/entity/Q29617373',
    'http://www.wikidata.org/entity/Q29617374',
    'http://www.wikidata.org/entity/Q29617375',
    'http://www.wikidata.org/entity/Q29617377',
    'http://www.wikidata.org/entity/Q29617378',
    'http://www.wikidata.org/entity/Q29617380',
    'http://www.wikidata.org/entity/Q29617381',
    'http://www.wikidata.org/entity/Q29617382',
    'http://www.wikidata.org/entity/Q29617383',
    'http://www.wikidata.org/entity/Q29617384',
    'http://www.wikidata.org/entity/Q29617385',
    'http://www.wikidata.org/entity/Q29617386',
    'http://www.wikidata.org/entity/Q29617388',
    'http://www.wikidata.org/entity/Q29617393',
    'http://www.wikidata.org/entity/Q29617395',
    'http://www.wikidata.org/entity/Q29617396',
    'http://www.wikidata.org/entity/Q29617398',
    'http://www.wikidata.org/entity/Q29617399',
    'http://www.wikidata.org/entity/Q29617400',
    'http://www.wikidata.org/entity/Q29617401',
    'http://www.wikidata.org/entity/Q29617402',
    'http://www.wikidata.org/entity/Q29617403',
    'http://www.wikidata.org/entity/Q29617404',
    'http://www.wikidata.org/entity/Q29617405',
    'http://www.wikidata.org/entity/Q29617406',
    'http://www.wikidata.org/entity/Q29617407',
    'http://www.wikidata.org/entity/Q29617408',
    'http://www.wikidata.org/entity/Q29617409',
    'http://www.wikidata.org/entity/Q29617410',
    'http://www.wikidata.org/entity/Q29617411',
    'http://www.wikidata.org/entity/Q29617412',
    'http://www.wikidata.org/entity/Q29617413',
    'http://www.wikidata.org/entity/Q29617415',
    'http://www.wikidata.org/entity/Q29617416',
    'http://www.wikidata.org/entity/Q29617418',
    'http://www.wikidata.org/entity/Q29617419',
    'http://www.wikidata.org/entity/Q29617420',
    'http://www.wikidata.org/entity/Q29617421',
    'http://www.wikidata.org/entity/Q29617422',
    'http://www.wikidata.org/entity/Q29617423',
    'http://www.wikidata.org/entity/Q29617424',
    'http://www.wikidata.org/entity/Q29617425',
    'http://www.wikidata.org/entity/Q29617426',
    'http://www.wikidata.org/entity/Q29617428',
    'http://www.wikidata.org/entity/Q29617429',
    'http://www.wikidata.org/entity/Q29617430',
    'http://www.wikidata.org/entity/Q29617432',
    'http://www.wikidata.org/entity/Q29617435',
    'http://www.wikidata.org/entity/Q29617436',
    'http://www.wikidata.org/entity/Q29617438',
    'http://www.wikidata.org/entity/Q29617440',
    'http://www.wikidata.org/entity/Q29617441',
    'http://www.wikidata.org/entity/Q29617443',
    'http://www.wikidata.org/entity/Q29617446',
    'http://www.wikidata.org/entity/Q29617447',
    'http://www.wikidata.org/entity/Q29617448',
    'http://www.wikidata.org/entity/Q29617449',
    'http://www.wikidata.org/entity/Q29617450',
    'http://www.wikidata.org/entity/Q29617451',
    'http://www.wikidata.org/entity/Q29617453',
    'http://www.wikidata.org/entity/Q29617454',
    'http://www.wikidata.org/entity/Q29617457',
    'http://www.wikidata.org/entity/Q29617458',
    'http://www.wikidata.org/entity/Q29617459',
    'http://www.wikidata.org/entity/Q29617460',
    'http://www.wikidata.org/entity/Q29617461',
    'http://www.wikidata.org/entity/Q29617462',
    'http://www.wikidata.org/entity/Q29617463',
    'http://www.wikidata.org/entity/Q29617464',
    'http://www.wikidata.org/entity/Q29617465',
    'http://www.wikidata.org/entity/Q29617466',
    'http://www.wikidata.org/entity/Q29617467',
    'http://www.wikidata.org/entity/Q29617468',
    'http://www.wikidata.org/entity/Q29617469',
    'http://www.wikidata.org/entity/Q29617470',
    'http://www.wikidata.org/entity/Q29617472',
    'http://www.wikidata.org/entity/Q29617473',
    'http://www.wikidata.org/entity/Q29617475',
    'http://www.wikidata.org/entity/Q29617476',
    'http://www.wikidata.org/entity/Q29617477',
    'http://www.wikidata.org/entity/Q29617478',
    'http://www.wikidata.org/entity/Q29617479',
    'http://www.wikidata.org/entity/Q29617480',
    'http://www.wikidata.org/entity/Q29617481',
    'http://www.wikidata.org/entity/Q29617482',
    'http://www.wikidata.org/entity/Q29617483',
    'http://www.wikidata.org/entity/Q29617485',
    'http://www.wikidata.org/entity/Q29617486',
    'http://www.wikidata.org/entity/Q29617487',
    'http://www.wikidata.org/entity/Q29617488',
    'http://www.wikidata.org/entity/Q29617490',
    'http://www.wikidata.org/entity/Q29617492',
    'http://www.wikidata.org/entity/Q29617493',
    'http://www.wikidata.org/entity/Q29617495',
    'http://www.wikidata.org/entity/Q29617496',
    'http://www.wikidata.org/entity/Q29617497',
    'http://www.wikidata.org/entity/Q29617501',
    'http://www.wikidata.org/entity/Q29617502',
    'http://www.wikidata.org/entity/Q29617504',
    'http://www.wikidata.org/entity/Q29617505',
    'http://www.wikidata.org/entity/Q29617506',
    'http://www.wikidata.org/entity/Q29617508',
    'http://www.wikidata.org/entity/Q29617510',
    'http://www.wikidata.org/entity/Q29617511',
    'http://www.wikidata.org/entity/Q29617512',
    'http://www.wikidata.org/entity/Q29617513',
    'http://www.wikidata.org/entity/Q29617514',
    'http://www.wikidata.org/entity/Q29617515',
    'http://www.wikidata.org/entity/Q29617516',
    'http://www.wikidata.org/entity/Q29617517',
    'http://www.wikidata.org/entity/Q29617519',
    'http://www.wikidata.org/entity/Q29617520',
    'http://www.wikidata.org/entity/Q29617521',
    'http://www.wikidata.org/entity/Q29617522',
    'http://www.wikidata.org/entity/Q29617524',
    'http://www.wikidata.org/entity/Q29617527',
    'http://www.wikidata.org/entity/Q29617529',
    'http://www.wikidata.org/entity/Q29617530',
    'http://www.wikidata.org/entity/Q29617531',
    'http://www.wikidata.org/entity/Q29617534',
    'http://www.wikidata.org/entity/Q29617535',
    'http://www.wikidata.org/entity/Q29617537',
    'http://www.wikidata.org/entity/Q29617538',
    'http://www.wikidata.org/entity/Q29617539',
    'http://www.wikidata.org/entity/Q29617540',
    'http://www.wikidata.org/entity/Q29617541',
    'http://www.wikidata.org/entity/Q29617543',
    'http://www.wikidata.org/entity/Q29617545',
    'http://www.wikidata.org/entity/Q29617546',
    'http://www.wikidata.org/entity/Q29617547',
    'http://www.wikidata.org/entity/Q29617549',
    'http://www.wikidata.org/entity/Q29617550',
    'http://www.wikidata.org/entity/Q29617551',
    'http://www.wikidata.org/entity/Q29617552',
    'http://www.wikidata.org/entity/Q29617553',
    'http://www.wikidata.org/entity/Q29617554',
    'http://www.wikidata.org/entity/Q29617555',
    'http://www.wikidata.org/entity/Q29617556',
    'http://www.wikidata.org/entity/Q29617557',
    'http://www.wikidata.org/entity/Q29617560',
    'http://www.wikidata.org/entity/Q29617561',
    'http://www.wikidata.org/entity/Q29617562',
    'http://www.wikidata.org/entity/Q29617563',
    'http://www.wikidata.org/entity/Q29617565',
    'http://www.wikidata.org/entity/Q29617566',
    'http://www.wikidata.org/entity/Q29617567',
    'http://www.wikidata.org/entity/Q29617568',
    'http://www.wikidata.org/entity/Q29617569',
    'http://www.wikidata.org/entity/Q29617570',
    'http://www.wikidata.org/entity/Q29617572',
    'http://www.wikidata.org/entity/Q29617573',
    'http://www.wikidata.org/entity/Q29617574',
    'http://www.wikidata.org/entity/Q29617575',
    'http://www.wikidata.org/entity/Q29617576',
    'http://www.wikidata.org/entity/Q29617577',
    'http://www.wikidata.org/entity/Q29617578',
    'http://www.wikidata.org/entity/Q29617579',
    'http://www.wikidata.org/entity/Q29617580',
    'http://www.wikidata.org/entity/Q29617581',
    'http://www.wikidata.org/entity/Q29617583',
    'http://www.wikidata.org/entity/Q29617584',
    'http://www.wikidata.org/entity/Q29617585',
    'http://www.wikidata.org/entity/Q29617586',
    'http://www.wikidata.org/entity/Q29617587',
    'http://www.wikidata.org/entity/Q29617588',
    'http://www.wikidata.org/