# coding: utf-8

"""
    Pure Storage FlashBlade REST 1.12 Python SDK

    Pure Storage FlashBlade REST 1.12 Python SDK. Compatible with REST API versions 1.0 - 1.12. Developed by [Pure Storage, Inc](http://www.purestorage.com/). Documentations can be found at [purity-fb.readthedocs.io](http://purity-fb.readthedocs.io/).

    OpenAPI spec version: 1.12
    Contact: info@purestorage.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ActiveDirectoryPatch(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

#BEGIN_CUSTOM
    # IR-51527: Prevent Pytest from attempting to collect this class based on name.
    __test__ = False
#END_CUSTOM

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'directory_servers': 'list[str]',
        'encryption_types': 'list[str]',
        'fqdns': 'list[str]',
        'join_ou': 'str',
        'kerberos_servers': 'list[str]',
        'service_principal_names': 'list[str]'
    }

    attribute_map = {
        'directory_servers': 'directory_servers',
        'encryption_types': 'encryption_types',
        'fqdns': 'fqdns',
        'join_ou': 'join_ou',
        'kerberos_servers': 'kerberos_servers',
        'service_principal_names': 'service_principal_names'
    }

    def __init__(self, directory_servers=None, encryption_types=None, fqdns=None, join_ou=None, kerberos_servers=None, service_principal_names=None):  # noqa: E501
        """ActiveDirectoryPatch - a model defined in Swagger"""  # noqa: E501

        self._directory_servers = None
        self._encryption_types = None
        self._fqdns = None
        self._join_ou = None
        self._kerberos_servers = None
        self._service_principal_names = None
        self.discriminator = None

        if directory_servers is not None:
            self.directory_servers = directory_servers
        if encryption_types is not None:
            self.encryption_types = encryption_types
        if fqdns is not None:
            self.fqdns = fqdns
        if join_ou is not None:
            self.join_ou = join_ou
        if kerberos_servers is not None:
            self.kerberos_servers = kerberos_servers
        if service_principal_names is not None:
            self.service_principal_names = service_principal_names

    @property
    def directory_servers(self):
        """Gets the directory_servers of this ActiveDirectoryPatch.  # noqa: E501

        A list of directory servers that will be used for lookups related to user authorization. Accepted server formats are IP address and DNS name. All specified servers must be registered to the domain appropriately in the array's configured DNS and will only be communicated with over the secure LDAP (LDAPS) protocol. If not specified, servers are resolved for the domain in DNS. The specified list can have a maximum length of 5.  # noqa: E501

        :return: The directory_servers of this ActiveDirectoryPatch.  # noqa: E501
        :rtype: list[str]
        """
        return self._directory_servers

    @directory_servers.setter
    def directory_servers(self, directory_servers):
        """Sets the directory_servers of this ActiveDirectoryPatch.

        A list of directory servers that will be used for lookups related to user authorization. Accepted server formats are IP address and DNS name. All specified servers must be registered to the domain appropriately in the array's configured DNS and will only be communicated with over the secure LDAP (LDAPS) protocol. If not specified, servers are resolved for the domain in DNS. The specified list can have a maximum length of 5.  # noqa: E501

        :param directory_servers: The directory_servers of this ActiveDirectoryPatch.  # noqa: E501
        :type: list[str]
        """

        self._directory_servers = directory_servers

    @property
    def encryption_types(self):
        """Gets the encryption_types of this ActiveDirectoryPatch.  # noqa: E501

        The encryption types that will be supported for use by clients for Kerberos authentication. Valid values include `aes256-cts-hmac-sha1-96`, `aes128-cts-hmac-sha1-96`, and `arcfour-hmac`.  # noqa: E501

        :return: The encryption_types of this ActiveDirectoryPatch.  # noqa: E501
        :rtype: list[str]
        """
        return self._encryption_types

    @encryption_types.setter
    def encryption_types(self, encryption_types):
        """Sets the encryption_types of this ActiveDirectoryPatch.

        The encryption types that will be supported for use by clients for Kerberos authentication. Valid values include `aes256-cts-hmac-sha1-96`, `aes128-cts-hmac-sha1-96`, and `arcfour-hmac`.  # noqa: E501

        :param encryption_types: The encryption_types of this ActiveDirectoryPatch.  # noqa: E501
        :type: list[str]
        """

        self._encryption_types = encryption_types

    @property
    def fqdns(self):
        """Gets the fqdns of this ActiveDirectoryPatch.  # noqa: E501

        A list of fully qualified domain names to use to register service principal names for the machine account. If specified, every service principal that is supported by the array will be registered for each fully qualified domain name specified. If neither `fqdns` nor `service_principal_names` is specified, the default `service_principal_names` are constructed using the `computer_name` and `domain` fields. Cannot be provided in combination with `service_principal_names`.  # noqa: E501

        :return: The fqdns of this ActiveDirectoryPatch.  # noqa: E501
        :rtype: list[str]
        """
        return self._fqdns

    @fqdns.setter
    def fqdns(self, fqdns):
        """Sets the fqdns of this ActiveDirectoryPatch.

        A list of fully qualified domain names to use to register service principal names for the machine account. If specified, every service principal that is supported by the array will be registered for each fully qualified domain name specified. If neither `fqdns` nor `service_principal_names` is specified, the default `service_principal_names` are constructed using the `computer_name` and `domain` fields. Cannot be provided in combination with `service_principal_names`.  # noqa: E501

        :param fqdns: The fqdns of this ActiveDirectoryPatch.  # noqa: E501
        :type: list[str]
        """

        self._fqdns = fqdns

    @property
    def join_ou(self):
        """Gets the join_ou of this ActiveDirectoryPatch.  # noqa: E501

        The relative distinguished name of the organizational unit in which the computer account should be created when joining the domain.  # noqa: E501

        :return: The join_ou of this ActiveDirectoryPatch.  # noqa: E501
        :rtype: str
        """
        return self._join_ou

    @join_ou.setter
    def join_ou(self, join_ou):
        """Sets the join_ou of this ActiveDirectoryPatch.

        The relative distinguished name of the organizational unit in which the computer account should be created when joining the domain.  # noqa: E501

        :param join_ou: The join_ou of this ActiveDirectoryPatch.  # noqa: E501
        :type: str
        """

        self._join_ou = join_ou

    @property
    def kerberos_servers(self):
        """Gets the kerberos_servers of this ActiveDirectoryPatch.  # noqa: E501

        A list of key distribution servers to use for Kerberos protocol. Accepted server formats are IP address and DNS name. All specified servers must be registered to the domain appropriately in the array's configured DNS. If not specified, servers are resolved for the domain in DNS. The specified list can have a maximum length of 5.  # noqa: E501

        :return: The kerberos_servers of this ActiveDirectoryPatch.  # noqa: E501
        :rtype: list[str]
        """
        return self._kerberos_servers

    @kerberos_servers.setter
    def kerberos_servers(self, kerberos_servers):
        """Sets the kerberos_servers of this ActiveDirectoryPatch.

        A list of key distribution servers to use for Kerberos protocol. Accepted server formats are IP address and DNS name. All specified servers must be registered to the domain appropriately in the array's configured DNS. If not specified, servers are resolved for the domain in DNS. The specified list can have a maximum length of 5.  # noqa: E501

        :param kerberos_servers: The kerberos_servers of this ActiveDirectoryPatch.  # noqa: E501
        :type: list[str]
        """

        self._kerberos_servers = kerberos_servers

    @property
    def service_principal_names(self):
        """Gets the service_principal_names of this ActiveDirectoryPatch.  # noqa: E501

        A list of service principal names to register for the machine account, which can be used for the creation of keys for Kerberos authentication. If neither `service_principal_names` nor `fqdns` is specified, the default `service_principal_names` are constructed using the `computer_name` and `domain` fields. Cannot be provided in combination with `fqdns`.  # noqa: E501

        :return: The service_principal_names of this ActiveDirectoryPatch.  # noqa: E501
        :rtype: list[str]
        """
        return self._service_principal_names

    @service_principal_names.setter
    def service_principal_names(self, service_principal_names):
        """Sets the service_principal_names of this ActiveDirectoryPatch.

        A list of service principal names to register for the machine account, which can be used for the creation of keys for Kerberos authentication. If neither `service_principal_names` nor `fqdns` is specified, the default `service_principal_names` are constructed using the `computer_name` and `domain` fields. Cannot be provided in combination with `fqdns`.  # noqa: E501

        :param service_principal_names: The service_principal_names of this ActiveDirectoryPatch.  # noqa: E501
        :type: list[str]
        """

        self._service_principal_names = service_principal_names

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ActiveDirectoryPatch, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ActiveDirectoryPatch):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
