# -*- coding:utf-8 -*-
# DFA算法
class DFAFilter:
    def __init__(self, sensitive_words: str) -> None:
        self.keyword_chains = {}
        self.delimit = '\x00'
        self.sensitive_words = sensitive_words

    def add(self, keyword: str):
        keyword = keyword.lower()
        chars = keyword.strip()
        if not chars:
            return
        level = self.keyword_chains
        for i in range(len(chars)):
            if chars[i] in level:
                level = level[chars[i]]
            else:
                if not isinstance(level, dict):
                    break
                for j in range(i, len(chars)):
                    level[chars[j]] = {}
                    last_level, last_char = level, chars[j]
                    level = level[chars[j]]
                last_level[last_char] = {self.delimit: 0}
                break
        if i == len(chars) - 1:
            level[self.delimit] = 0

    def parse(self):
        with open(self.sensitive_words, encoding='utf-8') as f:
            for keyword in f: self.add(str(keyword).strip())

    def filter(self, message: str, repl: str="*")->str:
        # 解析文本文件中的数据
        try:
            self.parse()
        except Exception as e:
            return str(e)
        message = message.lower()
        ret = []
        start = 0
        while start < len(message):
            level = self.keyword_chains
            step_ins = 0
            for char in message[start:]:
                if char in level:
                    step_ins += 1
                    if self.delimit not in level[char]:
                        level = level[char]
                    else:
                        ret.append(repl * step_ins)
                        start += step_ins - 1
                        break
                else:
                    ret.append(message[start])
                    break
            else:
                ret.append(message[start])
            start += 1
        return ''.join(ret)


