from marshmallow import fields, EXCLUDE, post_load

from cc_py_commons.schemas.camel_case_schema import CamelCaseSchema
from cc_py_commons.transactions.equipment_clas_schema import EquipmentClassSchema
from cc_py_commons.transactions.transaction import Transaction

class TransactionSchema(CamelCaseSchema):
	class Meta:
		unknown = EXCLUDE

	client_id = fields.UUID()
	reference_number = fields.String()
	pickup_date = fields.Date()
	delivery_date = fields.Date()
	origin_city= fields.String()
	origin_state= fields.String()
	origin_postcode= fields.String()    
	destination_city= fields.String()
	destination_state= fields.String()
	destination_postcode= fields.String()    
	equipment= fields.String()
	equipment_class = fields.Nested(EquipmentClassSchema)
	all_in_cost = fields.Integer()
	contact_id = fields.UUID(allow_none=True)
	carrier_id = fields.UUID(allow_none=True)
	booking_date= fields.Date(allow_none=True)
	pickup_appointment_window= fields.Integer(allow_none=True)
	num_pickups= fields.Integer(allow_none=True)
	num_dropoffs= fields.Integer(allow_none=True)
	origin_country = fields.String(allow_none=True)
	origin_latitude = fields.Float(allow_none=True)
	origin_longitude = fields.Float(allow_none=True)
	destination_country = fields.String(allow_none=True)
	destination_latitude = fields.Float(allow_none=True)
	destination_longitude = fields.Float(allow_none=True)
	miles= fields.Integer(allow_none=True)
	line_haul_cost= fields.Integer(allow_none=True)
	fuel_portion= fields.Integer(allow_none=True)
	price_to_shipper= fields.Integer(allow_none=True)
	weight= fields.Integer(allow_none=True)
	commodity = fields.String(allow_none=True)
	comments = fields.String(allow_none=True)
	import_stats_id = fields.UUID(allow_none=True)
	#   import_stats = relationship("ImportStats", back_populates="loads", lazy='subquery')
	pickup_appointment_required = fields.Boolean(allow_none=True)
	delivery_appointment_required = fields.Boolean(allow_none=True)
	team_service = fields.Boolean(allow_none=True)
	hand_loading = fields.Boolean(allow_none=True)
	driver_assist_loading = fields.Boolean(allow_none=True)
	driver_assist_unloading = fields.Boolean(allow_none=True)
	drop_trailer = fields.Boolean(allow_none=True)
	hazmat = fields.Boolean(allow_none=True)
	lift_gate_required = fields.Boolean(allow_none=True)
	blanket_wrap = fields.Boolean(allow_none=True)
	white_glove = fields.Boolean(allow_none=True)
	home_delivery = fields.Boolean(allow_none=True)
	etrack_load_stabilization = fields.Boolean(allow_none=True)
	contract = fields.Boolean(allow_none=True)    
	straps_required = fields.Boolean(allow_none=True)
	tarps_required = fields.Boolean(allow_none=True)
	frozen = fields.Boolean(allow_none=True)
	origin_hub_weight = fields.Float(allow_none=True)
	destination_hub_weight = fields.Float(allow_none=True)
	calculated_miles= fields.Integer(allow_none=True)
	mileage_mismatch = fields.Boolean(allow_none=True)
	holiday = fields.Boolean(allow_none=True)
	accessorials_included= fields.Integer(allow_none=True)
	client_shipper_id = fields.String(allow_none=True)
	client_receiver_id = fields.String(allow_none=True)
	load_source_type = fields.String(allow_none=True)
	predicted_price= fields.Integer(allow_none=True)
	carrier_code = fields.String(allow_none=True)
	customer_code = fields.String(allow_none=True)
	customer_name = fields.String(allow_none=True)
	customer_id = fields.UUID(allow_none=True)
	account_exec_id = fields.UUID(allow_none=True)
	#   account_exec = relationship("AccountExec", lazy='subquery')
	carrier_rep_id = fields.UUID(allow_none=True)
	#   carrier_rep = relationship("CarrierRep", lazy='subquery')
	excluded = fields.Boolean(allow_none=True)
	lane_id = fields.UUID(allow_none=True)
	multi_stop = fields.Integer(default=1)
	margin = fields.Integer(allow_none=True)
	rate_type = fields.String(allow_none=True)
	provider = fields.String(allow_none=True)
	target_pay = fields.Integer(allow_none=True)
	max_buy = fields.Integer(allow_none=True)
	pieces = fields.Integer(allow_none=True)
	max_temperature = fields.Float(allow_none=True)
	min_temperature = fields.Float(allow_none=True)
	origin_pallets_required = fields.Boolean(allow_none=True)
	destination_pallets_required = fields.Boolean(allow_none=True)
	hazmat = fields.Boolean(allow_none=True)
	origin_location_id = fields.String(allow_none=None)
	origin_location_name = fields.String(allow_none=None)
	destination_location_id = fields.String(allow_none=None)
	destination_location_name = fields.String(allow_none=None)
	delivery_open_time = fields.Time(allow_none=True)
	delivery_close_time = fields.Time(allow_none=True)
	pickup_open_time = fields.Time(allow_none=True)
	pickup_close_time = fields.Time(allow_none=True)
	freight_hub_load_id = fields.UUID(allow_none=True)
	partial_load = fields.Boolean(allow_none=True)
	linear_feet = fields.Integer(allow_none=True)

	@post_load
	def classify(self, data, **kwargs):
		print(f"post_load - {data}")
		return Transaction(**data)
