import logging


class Formatter(logging.Formatter):
    """Logging Formatter to add colors and count warning / errors"""

    grey = "\x1b[38;21m"
    yellow = "\x1b[33;21m"
    red = "\x1b[31;21m"
    bold_red = "\x1b[31;1m"
    reset = "\x1b[0m"
    format_classic = "%(asctime)s - %(name)s - %(levelname)s - %(message)s"
    format_debug = (
        "%(asctime)s - %(name)s - %(levelname)s - %(message)s (%(filename)s:%(lineno)d)"
    )

    FORMATS = {
        logging.DEBUG: grey + format_debug + reset,
        logging.INFO: grey + format_classic + reset,
        logging.WARNING: yellow + format_classic + reset,
        logging.ERROR: red + format_classic + reset,
        logging.CRITICAL: bold_red + format_debug + reset,
    }

    def format(self, record):
        log_fmt = self.FORMATS.get(record.levelno)
        formatter = logging.Formatter(log_fmt)
        return formatter.format(record)