"""Exports from bareUtils"""

from .streaming import (
    text_reader,
    text_writer,
    bytes_reader,
    bytes_writer
)

from .compression import (
    make_gzip_compressobj,
    make_deflate_compressobj,
    make_compress_compressobj,
    compression_writer_adapter,
    compression_writer,
    make_compress_decompressobj,
    make_deflate_decompressobj,
    make_gzip_decompressobj,
    CompressionMiddleware,
    make_default_compression_middleware
)

from .responses import (
    bytes_response,
    text_response,
    json_response
)

from .cookies import (
    encode_set_cookie,
    decode_set_cookie,
    encode_cookies,
    decode_cookies
)

__all__ = [
    "text_writer",
    "text_reader",
    "bytes_writer",
    "bytes_reader",

    'make_gzip_compressobj',
    'make_deflate_compressobj',
    'make_compress_compressobj',
    'compression_writer_adapter',
    'compression_writer',
    'make_compress_decompressobj',
    'make_deflate_decompressobj',
    'make_gzip_decompressobj',
    'CompressionMiddleware',
    'make_default_compression_middleware',

    "bytes_response",
    "text_response",
    "json_response",

    "encode_set_cookie",
    "decode_set_cookie",
    "encode_cookies",
    "decode_cookies"
]
