# Generated by Django 3.2.3 on 2022-01-24 18:19

from django.db import migrations, models
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='EmailConfiguration',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('Subject', models.CharField(default='OpenLXP Conformance Alerts', max_length=200)),
                ('Email_Content', models.TextField(blank=True, max_length=200, null=True)),
                ('Signature', models.TextField(max_length=200)),
                ('Email_Us', models.EmailField(help_text='Enter email address', max_length=254)),
                ('FAQ_URL', models.CharField(max_length=200)),
                ('Unsubscribe_Email_ID', models.EmailField(help_text='Enter email address', max_length=254)),
                ('Logs_Type', models.CharField(choices=[('attachment', 'ATTACHMENT'), ('message', 'MESSAGE')], help_text='Check readme files of the components before choosing the  log type', max_length=200)),
                ('HTML_File', models.FileField(help_text='Check sample HTML files in the readme files of the components', upload_to='HTML_Files')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ReceiverEmailConfiguration',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('email_address', models.EmailField(help_text='Enter email personas addresses to send log data', max_length=254, unique=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SenderEmailConfiguration',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('sender_email_address', models.EmailField(help_text='Enter sender email address to send log data from', max_length=254)),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
