/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm;

import java.io.IOException;
import java.io.PrintStream;
import java.util.regex.Pattern;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.cyclopsgroup.jmxterm.JavaProcess;
import org.cyclopsgroup.jmxterm.JavaProcessManager;

public final class SyntaxUtils {
    public static final String NULL = "null";
    public static final PrintStream NULL_PRINT_STREAM = new PrintStream(new NullOutputStream(), true);
    private static final Pattern PATTERN_HOST_PORT = Pattern.compile("^(\\w|\\.|\\-)+\\:\\d+$");

    public static JMXServiceURL getUrl(String url, JavaProcessManager jpm) throws IOException {
        if (StringUtils.isEmpty(url)) {
            throw new IllegalArgumentException("Empty URL is not allowed");
        }
        if (NumberUtils.isDigits(url) && jpm != null) {
            Integer pid = Integer.parseInt(url);
            JavaProcess p = jpm.get(pid);
            if (p == null) {
                throw new NullPointerException("No such PID " + pid);
            }
            if (!p.isManageable()) {
                p.startManagementAgent();
                if (!p.isManageable()) {
                    throw new IllegalStateException("Managed agent for PID " + pid + " couldn't start. PID " + pid + " is not manageable");
                }
            }
            return new JMXServiceURL(p.toUrl());
        }
        if (PATTERN_HOST_PORT.matcher(url).find()) {
            return new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + url + "/jmxrmi");
        }
        return new JMXServiceURL(url);
    }

    public static boolean isNull(String s) {
        return StringUtils.equalsIgnoreCase(NULL, s) || StringUtils.equals("*", s);
    }

    public static Object parse(String expression, String type) {
        Class<?> c;
        if (expression == null || StringUtils.equalsIgnoreCase(NULL, expression)) {
            return null;
        }
        try {
            c = ClassUtils.getClass(type);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Type " + type + " isn't valid", e);
        }
        if (c == String.class) {
            return expression;
        }
        if (StringUtils.isEmpty(expression)) {
            return null;
        }
        return ConvertUtils.convert(expression, c);
    }

    private SyntaxUtils() {
    }
}

