/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm;

import java.io.IOException;
import java.util.List;
import javax.management.JMException;
import org.apache.commons.lang3.Validate;
import org.cyclopsgroup.jcli.AutoCompletable;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jmxterm.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Command
implements AutoCompletable {
    private static final Logger LOG = LoggerFactory.getLogger(Command.class);
    private boolean help;
    private Session session;

    protected List<String> doSuggestArgument() throws IOException, JMException {
        return null;
    }

    protected List<String> doSuggestOption(String optionName) throws IOException, JMException {
        return null;
    }

    public abstract void execute() throws IOException, JMException;

    public final Session getSession() {
        return this.session;
    }

    public final boolean isHelp() {
        return this.help;
    }

    @Option(name="h", longName="help", description="Display usage")
    public final void setHelp(boolean help) {
        this.help = help;
    }

    public final void setSession(Session session) {
        Validate.notNull(session, "Session can't be NULL", new Object[0]);
        this.session = session;
    }

    @Override
    public final List<String> suggestArgument(String partialArg) {
        if (partialArg != null) {
            return null;
        }
        try {
            return this.doSuggestArgument();
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Couldn't suggest option", e);
            }
            return null;
        }
        catch (JMException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Couldn't suggest option", e);
            }
            return null;
        }
    }

    @Override
    public final List<String> suggestOption(String name, String partialValue) {
        if (partialValue != null) {
            return null;
        }
        try {
            return this.doSuggestOption(name);
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Couldn't suggest option", e);
            }
            return null;
        }
        catch (JMException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Couldn't suggest option", e);
            }
            return null;
        }
    }
}

