/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jcli.jline;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.cyclopsgroup.jcli.jline.ArgumentsInspectorState;
import org.cyclopsgroup.jcli.spi.Option;
import org.cyclopsgroup.jcli.spi.ParsingContext;

class ArgumentsInspector {
    private final ParsingContext context;
    private Option currentOption;
    private String currentValue;
    private final Set<Option> remainingOptions;
    private ArgumentsInspectorState state = ArgumentsInspectorState.READY;

    ArgumentsInspector(ParsingContext context) {
        this.context = context;
        this.remainingOptions = new HashSet<Option>(context.options());
    }

    void consume(String argument) {
        if (argument.startsWith("--")) {
            this.state = ArgumentsInspectorState.LONG_OPTION;
        } else if (argument.startsWith("-")) {
            this.state = ArgumentsInspectorState.OPTION;
        } else {
            switch (this.state) {
                case READY: {
                    this.state = ArgumentsInspectorState.ARGUMENT;
                    break;
                }
                case OPTION: {
                    this.currentOption = this.context.optionWithShortName(this.currentValue.substring(1));
                }
                case LONG_OPTION: {
                    if (this.state == ArgumentsInspectorState.LONG_OPTION) {
                        this.currentOption = this.context.optionWithLongName(this.currentValue.substring(2));
                    }
                    if (this.currentOption != null && !this.currentOption.isMultiValue()) {
                        this.remainingOptions.remove(this.currentOption);
                    }
                    if (this.currentOption == null || this.currentOption.isFlag()) {
                        this.state = ArgumentsInspectorState.ARGUMENT;
                        break;
                    }
                    this.state = ArgumentsInspectorState.OPTION_VALUE;
                    break;
                }
                case OPTION_VALUE: 
                case ARGUMENT: {
                    this.state = ArgumentsInspectorState.ARGUMENT;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        this.currentValue = argument;
    }

    void end() {
        switch (this.state) {
            case OPTION: {
                this.currentOption = this.context.optionWithShortName(this.currentValue.substring(1));
            }
            case LONG_OPTION: {
                if (this.state == ArgumentsInspectorState.LONG_OPTION) {
                    this.currentOption = this.context.optionWithLongName(this.currentValue.substring(2));
                }
                if (this.currentOption != null && !this.currentOption.isMultiValue()) {
                    this.remainingOptions.remove(this.currentOption);
                }
                if (this.currentOption == null || this.currentOption.isFlag()) {
                    this.state = ArgumentsInspectorState.ARGUMENT;
                    break;
                }
                this.state = ArgumentsInspectorState.OPTION_VALUE;
                break;
            }
            default: {
                this.state = ArgumentsInspectorState.READY;
            }
        }
        this.currentValue = null;
    }

    Option getCurrentOption() {
        return this.currentOption;
    }

    String getCurrentValue() {
        return this.currentValue;
    }

    Set<Option> getRemainingOptions() {
        return Collections.unmodifiableSet(this.remainingOptions);
    }

    ArgumentsInspectorState getState() {
        return this.state;
    }
}

