/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jcli.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.cyclopsgroup.jcli.ArgumentProcessor;
import org.cyclopsgroup.jcli.ValidationResult;
import org.cyclopsgroup.jcli.impl.AnnotationParsingContext;
import org.cyclopsgroup.jcli.impl.DefaultBeanProcessor;
import org.cyclopsgroup.jcli.impl.DefaultHelpPrinter;
import org.cyclopsgroup.jcli.impl.MultiValueReference;
import org.cyclopsgroup.jcli.impl.ParsingContextBuilder;
import org.cyclopsgroup.jcli.impl.Reference;
import org.cyclopsgroup.jcli.impl.SingleValueReference;
import org.cyclopsgroup.jcli.spi.CommandLineParser;
import org.cyclopsgroup.jcli.spi.Option;
import org.cyclopsgroup.jcli.spi.ParsingContext;

class DefaultArgumentProcessor<T>
extends ArgumentProcessor<T> {
    static final String ARGUMENT_REFERNCE_NAME = "----arguments----";
    private final Class<? extends T> beanType;
    private final CommandLineParser parser;

    DefaultArgumentProcessor(Class<? extends T> beanType, CommandLineParser parser) {
        this.parser = parser;
        this.beanType = beanType;
    }

    @Override
    public ParsingContext createParsingContext() {
        return this.createParsingContextInternal();
    }

    private AnnotationParsingContext<T> createParsingContextInternal() {
        return new ParsingContextBuilder<T>(this.beanType).build();
    }

    @Override
    public void printHelp(PrintWriter out) throws IOException {
        DefaultHelpPrinter.printHelp(this.createParsingContextInternal(), out);
    }

    @Override
    public T process(List<String> arguments, T bean) {
        DefaultBeanProcessor.process(this.createParsingContextInternal(), arguments, bean, this.parser);
        return bean;
    }

    @Override
    public T processProperties(Properties props, T bean) {
        AnnotationParsingContext<T> context = this.createParsingContextInternal();
        HashMap<String, Option> optionByName = new HashMap<String, Option>();
        for (Option option : context.options()) {
            if (!option.getName().isEmpty()) {
                optionByName.put(option.getName(), option);
            }
            if (option.getLongName().isEmpty()) continue;
            optionByName.put(option.getLongName(), option);
        }
        for (Map.Entry entry : props.entrySet()) {
            String key = (String)entry.getKey();
            Option option = (Option)optionByName.get(key);
            if (option == null) continue;
            String value = (String)entry.getValue();
            Reference<T> ref = context.lookupReference(option.getLongName(), true);
            if (ref instanceof SingleValueReference) {
                ((SingleValueReference)ref).setValue(bean, value);
                continue;
            }
            if (!(ref instanceof MultiValueReference)) continue;
            ((MultiValueReference)ref).setValues(bean, Arrays.asList(value));
        }
        return bean;
    }

    @Override
    public ValidationResult validate(String[] arguments) {
        return null;
    }
}

