/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jcli.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.cyclopsgroup.jcli.impl.AnnotationArgument;
import org.cyclopsgroup.jcli.impl.AnnotationCli;
import org.cyclopsgroup.jcli.impl.AnnotationOption;
import org.cyclopsgroup.jcli.impl.Reference;
import org.cyclopsgroup.jcli.spi.Argument;
import org.cyclopsgroup.jcli.spi.Cli;
import org.cyclopsgroup.jcli.spi.Option;
import org.cyclopsgroup.jcli.spi.ParsingContext;

class AnnotationParsingContext<T>
implements ParsingContext {
    private final AnnotationArgument argument;
    private final AnnotationCli cli;
    private final List<AnnotationOption> options;
    private final Map<String, Reference<T>> referenceMap;

    AnnotationParsingContext(Map<String, Reference<T>> referenceMap, List<AnnotationOption> options, AnnotationCli cli, AnnotationArgument argument) {
        this.options = options;
        this.referenceMap = referenceMap;
        this.cli = cli;
        this.argument = argument;
    }

    @Override
    public Argument argument() {
        return this.argument;
    }

    @Override
    public Cli cli() {
        return this.cli;
    }

    Reference<T> lookupReference(String name, boolean isLongName) {
        if (isLongName) {
            for (Reference<T> r : this.referenceMap.values()) {
                if (!r.longName.equals(name)) continue;
                return r;
            }
            return null;
        }
        return this.referenceMap.get(name);
    }

    @Override
    public List<Option> options() {
        return Arrays.asList(this.options.toArray(new Option[0]));
    }

    @Override
    public Option optionWithLongName(String longName) {
        for (Option option : this.options) {
            if (!option.getLongName().equals(longName)) continue;
            return option;
        }
        return null;
    }

    @Override
    public Option optionWithShortName(String shortName) {
        for (Option option : this.options) {
            if (!option.getName().equals(shortName)) continue;
            return option;
        }
        return null;
    }
}

