/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.util;

public final class ByteUtils {
    private ByteUtils() {
    }

    public static void writeLong(long value, byte[] dest, int offset) throws IllegalArgumentException {
        if (dest.length < offset + 8) {
            throw new IllegalArgumentException("Destination byte array does not have enough space to write long from offset " + offset);
        }
        long t = value;
        for (int i = offset; i < offset + 8; ++i) {
            dest[i] = (byte)(t & 0xFFL);
            t >>= 8;
        }
    }

    public static long readLong(byte[] src, int offset) throws IllegalArgumentException {
        if (src.length < offset) {
            throw new IllegalArgumentException("There's nothing to read in src from offset " + offset);
        }
        long r = 0L;
        int i = offset;
        for (int j = 0; i < src.length && j < 64; ++i, j += 8) {
            r += ((long)src[i] & 0xFFL) << j;
        }
        return r;
    }
}

