/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.ref;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.cyclopsgroup.caff.ref.ValueReference;

public class ValueReferenceScanner<T> {
    private final Class<T> beanType;

    public ValueReferenceScanner(Class<T> beanType) {
        if (beanType == null) {
            throw new NullPointerException("Given bean type can't be NULL");
        }
        this.beanType = beanType;
    }

    private <H extends Annotation> AccessibleObject findAnnotatedAccess(PropertyDescriptor desc, Class<H> expectedAnnotation) {
        Field field;
        try {
            field = this.beanType.getClass().getField(desc.getName());
        }
        catch (Throwable e) {
            field = null;
        }
        List<AccessibleObject> accesses = Arrays.asList(desc.getReadMethod(), desc.getWriteMethod(), field);
        for (AccessibleObject access : accesses) {
            if (access == null || !access.isAnnotationPresent(expectedAnnotation)) continue;
            return access;
        }
        return null;
    }

    public <H extends Annotation> void scanForAnnotation(Class<H> expectedAnnotation, Listener<T, H> listener) {
        ValueReference reference;
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(this.beanType);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Can't get bean info of " + this.beanType);
        }
        for (PropertyDescriptor desc : beanInfo.getPropertyDescriptors()) {
            AccessibleObject access = this.findAnnotatedAccess(desc, expectedAnnotation);
            if (access == null) continue;
            reference = access instanceof Field ? ValueReference.instanceOf((Field)access) : ValueReference.instanceOf(desc);
            listener.handleReference(reference, access.getAnnotation(expectedAnnotation), access);
        }
        for (Field field : this.beanType.getFields()) {
            H annotation = field.getAnnotation(expectedAnnotation);
            if (annotation == null) continue;
            reference = ValueReference.instanceOf(field);
            listener.handleReference(reference, annotation, field);
        }
    }

    public static interface Listener<T, H> {
        public void handleReference(ValueReference<T> var1, H var2, AccessibleObject var3);
    }
}

