# IndicatorManagement

A library to help management of fully customized indicators.

# Features

This library provides management of mathematical/financial indicators, without having any problem on large amount of series data.

If you can grab all your data on the memory at once, then you can select famous alternative libraries like [TA-Lib](https://github.com/mrjbq7/ta-lib).
However, if **amount of data is too large or it's hard to immediately prepare all data at once**, then this library is for you.

For following animated graph, the source data is generated by this library. (Source code for this example will be available soon)
The source data is not fully loaded at once, instead the library calculates and load the data whenever it is needed.

![Imgur](https://i.imgur.com/34E2mWA.gif)

Of course, you can perform any mathematical/statistical operation based on indicators.
Currently I've implemented basic arithmetic operations, and few statistical operations.
I am planning to support some more operations like trigonometric functions, logarithm, [RSI](https://www.investopedia.com/terms/r/rsi.asp), etc.

# Dependencies

- Python 3.10+

I am planning to support lower Python version like 3.7.

# Installation

This module is available at [PyPI](https://pypi.org/project/indicator-management/), so you can download it via pip;

```
pip install indicator-management
```

# Usage

Please have a look at `examples` folder.

# Planned Future Features

- Implement more financial indicators including MACD, RSI, etc
- Implement matplotlib integration
