"""
Methods sub-package is composed of DC-Resistivity, EM, and hydro-geological 
methods for prediction parameter computations as well as exporting filtering 
tensors for 1D/2D modeling purpose.
"""
from .electrical import (
    ResistivityProfiling ,
    VerticalSounding, 
    DCProfiling, 
    DCSounding,
)

from .em import ( 
    EM, 
    Processing,
    ZC, 
    )
from .erp import ( 
    ERPCollection ,
    ERP 
    )
from .hydro import ( 
    Hydrogeology, 
    AqGroup, 
    AqSection, 
    MXS, 
    Logging, 
    )

__all__=[
    "EM", 
    "ResistivityProfiling" ,
    "VerticalSounding", 
    "DCProfiling", 
    "DCSounding",
    "Processing", 
    "ZC", 
    "ERPCollection", 
    "ERP", 
    "Hydrogeology", 
    "AqGroup", 
    "AqSection", 
    "MXS", 
    "Logging", 
    ]