# Реализовать дескриптор для класса серверного сокета, а в нем — проверку номера порта. Это должно
# быть целое число (>=0). Значение порта по умолчанию равняется 7777. Дескриптор надо создать в
# отдельном классе. Его экземпляр добавить в пределах класса серверного сокета. Номер порта передается
# в экземпляр дескриптора при запуске сервера.

import logging
import sys

log_server = logging.getLogger('server')


class PortServer:
    '''Класс дескриптор проверки корректности номера порта сервера'''

    def __set__(self, instance, list_port):
        if not 1023 < list_port < 65536:
            log_server.critical(
                f'Попытка запуска сервера с указанием неподходящего порта {list_port}. Допустимы адреса с 1024 '
                f'до 65535.', stacklevel=2)
            sys.exit(1)
        instance.__dict__[self.name] = list_port

    def __set_name__(self, owner, name):
        self.name = name
