# -*- coding: utf-8 -*-
# Generated by Django 1.11.4 on 2017-08-29 14:58
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import jsonfield.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('labeler', '0009_auto_20170824_1704'),
    ]

    operations = [
        migrations.CreateModel(
            name='ImageLabel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('updated_date', models.DateTimeField(auto_now=True, verbose_name='Datetime the label was assigned to the image.')),
                ('created_date', models.DateTimeField(auto_now_add=True, verbose_name='Datetime the label was assigned to the image.')),
            ],
        ),
        migrations.CreateModel(
            name='Label',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.CharField(default=None, max_length=256, null=True)),
                ('category', models.CharField(default='animal', max_length=256, null=True)),
                ('updated_date', models.DateTimeField(auto_now=True, verbose_name='Datetime the label was changed or updated.')),
                ('created_date', models.DateTimeField(auto_now_add=True, verbose_name='Datetime the label was created in the database.')),
                ('created_by', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.RemoveField(
            model_name='userlabel',
            name='user',
        ),
        migrations.AddField(
            model_name='image',
            name='description',
            field=models.TextField(blank=True, default='', max_length=512, verbose_name='Description of the image, where and when it was taken, who/what is in it, etc'),
        ),
        migrations.AlterField(
            model_name='image',
            name='caption',
            field=models.CharField(blank=True, default='', max_length=512, verbose_name='Description of the image, where and when it was taken, who/what is in it, etc'),
        ),
        migrations.AlterField(
            model_name='image',
            name='info',
            field=jsonfield.fields.JSONField(blank=True, default=None, null=True, verbose_name='Metadata about the image (usually from the EXIF header)'),
        ),
        migrations.AlterField(
            model_name='image',
            name='taken_date',
            field=models.DateTimeField(blank=True, default=None, null=True, verbose_name='Date photo was taken.'),
        ),
        migrations.AlterField(
            model_name='image',
            name='uploaded_by',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.DeleteModel(
            name='UserLabel',
        ),
        migrations.AddField(
            model_name='imagelabel',
            name='image',
            field=models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to='labeler.Image'),
        ),
        migrations.AddField(
            model_name='imagelabel',
            name='label',
            field=models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to='labeler.Label'),
        ),
        migrations.AddField(
            model_name='imagelabel',
            name='user',
            field=models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='image',
            name='label',
            field=models.ManyToManyField(blank=True, through='labeler.ImageLabel', to='labeler.Label'),
        ),
    ]
