"""Stream type classes for tap-partnerize."""

from __future__ import annotations
from singer_sdk import typing as th  # JSON Schema typing helpers
from tap_partnerize.client import PartnerizeStream


class ConversionItemsStream(PartnerizeStream):
    """Accesses conversion report for items."""

    name = "conversion_items"
    path = "/reporting/export/export/conversion_item.csv"

    primary_keys = ["conversion_id", "conversion_item_id"]
    replication_key = "last_update"
    schema = th.PropertiesList(
        th.Property(
            "meta_item_vertical",
            th.StringType,
        ),
        th.Property(
            "meta_item_ship",
            th.StringType,
        ),
        th.Property(
            "meta_item_promo_used",
            th.StringType,
        ),
        th.Property(
            "meta_item_product_type",
            th.StringType,
        ),
        th.Property(
            "meta_item_vertical",
            th.StringType,
        ),
        th.Property(
            "meta_item_vertical",
            th.StringType,
        ),
        th.Property(
            "meta_item_product_name",
            th.StringType,
        ),
        th.Property(
            "meta_item_prescription",
            th.StringType
        ),
        th.Property(
            "meta_item_markdown",
            th.BooleanType,
        ),
        th.Property(
            "meta_item_id",
            th.StringType,
        ),
        th.Property(
            "meta_item_eip",
            th.BooleanType,
        ),
        th.Property(
            "meta_item_size",
            th.StringType,
        ),
        th.Property(
            "meta_item_size_name",
            th.StringType,
        ),
        th.Property(
            "meta_item_designer",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_sale_flag",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_purchase_country",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_gross_value",
            th.NumberType,
        ),
        th.Property(
            "meta_conversion_file_source",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_device_os",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_app_sale",
            th.BooleanType,
        ),
        th.Property(
            "click_date",
            th.DateType,
            description = "%E4Y-%m-%d",
        ),
        th.Property(
            "meta_conversion_advertiser_id",
            th.StringType,
        ),
        th.Property(
            "meta_item_name",
            th.StringType,
        ),
        th.Property(
            "ref_conversion_metric",
            th.StringType,
        ),
        th.Property(
            "meta_item_product_id",
            th.StringType,
        ),
        th.Property(
            "ref_user_context",
            th.StringType,
        ),
        th.Property(
            "meta_item_cookie_status",
            th.StringType,
        ),
        th.Property(
            "voucher_codes",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_device_model",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_delivery_type",
            th.StringType,
        ),
        th.Property(
            "payable",
            th.BooleanType,
        ),
        th.Property(
            "last_update",
            th.DateTimeType,
            description="bq-datetime",
    ),
        th.Property(
            "meta_item_subscription",
            th.StringType,
        ),
        th.Property(
            "conversion_id",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_container_version",
            th.IntegerType,
        ),
        th.Property(
            "clickref",
            th.StringType,
        ),
        th.Property(
            "country",
            th.StringType,
        ),
        th.Property(
            "reject_reason",
            th.StringType,
        ),
        th.Property(
            "category",
            th.StringType,
        ),
        th.Property(
            "publisher_self_bill_id",
            th.StringType,
        ),
        th.Property(
            "item_status",
            th.StringType,
        ),
        th.Property(
            "item_value",
            th.NumberType,
        ),
        th.Property(
            "conversion_item_id",
            th.StringType,
        ),
        th.Property(
            "meta_item_brand",
            th.StringType,
        ),
        th.Property(
            "conversion_lag",
            th.IntegerType,
        ),
        th.Property(
            "conversion_status",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_delivery_cost",
            th.NumberType,
        ),
        th.Property(
            "ref_traffic_source",
            th.StringType,
        ),
        th.Property(
            "ref_partnership_model",
            th.StringType,
        ),
        th.Property(
            "conversion_date",
            th.DateType,
            description="%E4Y-%m-%d",
        ),
        th.Property(
            "campaign_id",
            th.StringType,
        ),
        th.Property(
            "creative_type",
            th.IntegerType,
        ),
        th.Property(
            "source_referer",
            th.StringType,
        ),
        th.Property(
            "meta_item_productname",
            th.StringType,
        ),
        th.Property(
            "publisher_reference",
            th.StringType,
        ),
        th.Property(
            "advertiser_reference",
            th.StringType,
        ),
        th.Property(
            "item_publisher_commission",
            th.NumberType,
        ),
        th.Property(
            "publisher_commission",
            th.NumberType,
        ),
        th.Property(
            "click_date_time",
            th.DateTimeType,
            description="bq-datetime",
        ),
        th.Property(
            "publisher_name",
            th.StringType,
        ),
        th.Property(
            "conversion_reference",
            th.StringType,
        ),
        th.Property(
            "click_time",
            th.TimeType,
        ),
        th.Property(
            "creative_id",
            th.StringType,
        ),
        th.Property(
            "meta_item_file_source",
            th.StringType,
        ),
        th.Property(
            "conversion_date_time",
            th.DateTimeType,
            description="bq-datetime",
        ),
        th.Property(
            "ref_device",
            th.StringType,
        ),
        th.Property(
            "campaign_title",
            th.StringType,
        ),
        th.Property(
            "meta_item_colour",
            th.StringType,
        ),
        th.Property(
            "conversion_time",
            th.TimeType,
        ),
        th.Property(
            "currency",
            th.StringType,
        ),
        th.Property(
            "sku",
            th.StringType,
        ),
        th.Property(
            "value",
            th.NumberType,
        ),
        th.Property(
            "specific_creative_id",
            th.StringType,
        ),
        th.Property(
            "publisher_id",
            th.StringType,
        ),
        th.Property(
            "customer_type",
            th.StringType,
        ),
        th.Property(
            "quantity",
            th.IntegerType,
        ),
        th.Property(
            "ref_origin",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_customer_type",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_total_revenue",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_vip",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_app_os_device",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_app_os_device_version",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_app_sdk",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_app_sdk_version",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_app_transaction",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_app_version",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_application_name",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_clickip_country",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_context",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_creditcard_type",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_customer_classification",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_device",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_discounted",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_eip",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_fb_content_id",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_fb_content_type",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_invoiceid",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_original_booked_date",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_original_currency",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_p_id",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_saletype",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_session",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_shipping_total",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_subaffiliatedomain",
            th.StringType,
        ),
        th.Property(
            "meta_conversion_vat",
            th.StringType,
        ),
        th.Property(
            "meta_item_customer_type",
            th.StringType,
        ),
        th.Property(
            "meta_item_large",
            th.StringType,
        ),
        th.Property(
            "meta_item_medium",
            th.StringType,
        ),
        th.Property(
            "meta_item_small",
            th.StringType,
        ),
        th.Property(
            "meta_item_total_revenue",
            th.StringType,
        ),
        th.Property(
            "meta_item_vip",
            th.StringType,
        ),
        th.Property(
            "meta_item_x_large",
            th.StringType,
        ),
        th.Property(
            "meta_item_app_os_device",
            th.StringType,
        ),
        th.Property(
            "meta_item_app_os_device_version",
            th.StringType,
        ),
        th.Property(
            "meta_item_app_sdk",
            th.StringType,
        ),
        th.Property(
            "meta_item_app_sdk_version",
            th.StringType,
        ),
        th.Property(
            "meta_item_app_transaction",
            th.StringType,
        ),
        th.Property(
            "meta_item_app_version",
            th.StringType,
        ),
        th.Property(
            "meta_item_context",
            th.StringType,
        ),
        th.Property(
            "meta_item_coupon",
            th.StringType,
        ),
        th.Property(
            "meta_item_delivery_cost",
            th.StringType,
        ),
        th.Property(
            "meta_item_delivery_type",
            th.StringType,
        ),
        th.Property(
            "meta_item_description",
            th.StringType,
        ),
        th.Property(
            "meta_item_device",
            th.StringType,
        ),
        th.Property(
            "meta_item_discount_rate",
            th.StringType,
        ),
        th.Property(
            "meta_item_discount_type",
            th.StringType,
        ),
        th.Property(
            "meta_item_discount_value",
            th.StringType,
        ),
        th.Property(
            "meta_item_event_category",
            th.StringType,
        ),
        th.Property(
            "meta_item_event_country",
            th.StringType,
        ),
        th.Property(
            "meta_item_event_date",
            th.StringType,
        ),
        th.Property(
            "meta_item_event_group",
            th.StringType,
        ),
        th.Property(
            "meta_item_event_location",
            th.StringType,
        ),
        th.Property(
            "meta_item_event_name",
            th.StringType,
        ),
        th.Property(
            "meta_item_event_performer",
            th.StringType,
        ),
        th.Property(
            "meta_item_event_state",
            th.StringType,
        ),
        th.Property(
            "meta_item_fb_content_id",
            th.StringType,
        ),
        th.Property(
            "meta_item_fb_content_type",
            th.StringType,
        ),
        th.Property(
            "meta_item_gender",
            th.StringType,
        ),
        th.Property(
            "meta_item_gross_item_value",
            th.StringType,
        ),
        th.Property(
            "meta_item_is_house_brand",
            th.StringType,
        ),
        th.Property(
            "meta_item_order",
            th.StringType,
        ),
        th.Property(
            "meta_item_original_value",
            th.StringType,
        ),
        th.Property(
            "meta_item_out_of_stock",
            th.StringType,
        ),
        th.Property(
            "meta_item_platform",
            th.StringType,
        ),
        th.Property(
            "meta_item_product_category_2",
            th.StringType,
        ),
        th.Property(
            "meta_item_product_color_name",
            th.StringType,
        ),
        th.Property(
            "meta_item_product_product_category_unified_ids",
            th.StringType,
        ),
        th.Property(
            "meta_item_promotion_flag",
            th.StringType,
        ),
        th.Property(
            "meta_item_ref_conversion_metric_id",
            th.StringType,
        ),
        th.Property(
            "meta_item_route_path",
            th.StringType,
        ),
        th.Property(
            "meta_item_sale_item_flag",
            th.StringType,
        ),
        th.Property(
            "meta_item_saletype",
            th.StringType,
        ),
        th.Property(
            "meta_item_session",
            th.StringType,
        ),
        th.Property(
            "meta_item_sub_category",
            th.StringType,
        ),
        th.Property(
            "meta_item_subaffiliatedomain",
            th.StringType,
        ),
        th.Property(
            "meta_item_subtotal",
            th.StringType,
        ),
        th.Property(
            "meta_item_variant",
            th.StringType,
        ),
    ).to_dict()
