
 

// This file is autogenerated. DO NOT EDIT

#pragma once
#include <robotpy_build.h>


#include <../../_impl/include/frc/controller/ControlAffinePlantInversionFeedforward.h>





namespace rpygen {

using namespace frc;


template <int States, int Inputs>
struct bind_frc__ControlAffinePlantInversionFeedforward {

    

    py::class_<typename frc::ControlAffinePlantInversionFeedforward<States, Inputs>> cls_ControlAffinePlantInversionFeedforward;




    py::module &m;
    std::string clsName;

bind_frc__ControlAffinePlantInversionFeedforward(py::module &m, const char * clsName) :
    cls_ControlAffinePlantInversionFeedforward(m, clsName),



    m(m),
    clsName(clsName)
{
    
}

void finish(const char * set_doc = NULL, const char * add_doc = NULL) {

    cls_ControlAffinePlantInversionFeedforward.doc() =
    "Constructs a control-affine plant inversion model-based feedforward from\n"
"given model dynamics.\n"
"\n"
"If given the vector valued function as f(x, u) where x is the state\n"
"vector and u is the input vector, the B matrix(continuous input matrix)\n"
"is calculated through a NumericalJacobian. In this case f has to be\n"
"control-affine (of the form f(x) + Bu).\n"
"\n"
"The feedforward is calculated as\n"
":strong:` u_ff = B:sup:`+` (rDot - f(x)) `, where :strong:`\n"
"B:sup:`+` ` is the pseudoinverse of B.\n"
"\n"
"This feedforward does not account for a dynamic B matrix, B is either\n"
"determined or supplied when the feedforward is created and remains constant.\n"
"\n"
"For more on the underlying math, read\n"
"https://file.tavsys.net/control/controls-engineering-in-frc.pdf.\n"
"\n"
"@tparam States The number of states.\n"
"@tparam Inputs the number of inputs.";

  cls_ControlAffinePlantInversionFeedforward
      .def(py::init<std::function<Eigen::Vector<double, States> ( const Eigen::Vector<double, States> &, const Eigen::Vector<double, Inputs> & )>, units::second_t>(),
      py::arg("f"), py::arg("dt"), release_gil(), py::doc(
    "Constructs a feedforward with given model dynamics as a function\n"
"of state and input.\n"
"\n"
":param f:  A vector-valued function of x, the state, and\n"
"           u, the input, that returns the derivative of\n"
"           the state vector. HAS to be control-affine\n"
"           (of the form f(x) + Bu).\n"
":param dt: The timestep between calls of calculate().")
  )
    
      .def(py::init<std::function<Eigen::Vector<double, States> ( const Eigen::Vector<double, States> & )>, const Eigen::Matrix<double, States, Inputs>&, units::second_t>(),
      py::arg("f"), py::arg("B"), py::arg("dt"), release_gil()    , py::keep_alive<1, 3>(), py::doc(
    "Constructs a feedforward with given model dynamics as a function of state,\n"
"and the plant's B matrix(continuous input matrix).\n"
"\n"
":param f:  A vector-valued function of x, the state,\n"
"           that returns the derivative of the state vector.\n"
":param B:  Continuous input matrix of the plant being controlled.\n"
":param dt: The timestep between calls of calculate().")
  )
    
      .def("uff", static_cast<const Eigen::Vector<double, Inputs> & (frc::ControlAffinePlantInversionFeedforward<States, Inputs>::*)() const>(
&frc::ControlAffinePlantInversionFeedforward<States, Inputs>::Uff), release_gil(), py::doc(
    "Returns the previously calculated feedforward as an input vector.\n"
"\n"
":returns: The calculated feedforward.")
  )
    
      .def("uff", static_cast<double (frc::ControlAffinePlantInversionFeedforward<States, Inputs>::*)(int) const>(
&frc::ControlAffinePlantInversionFeedforward<States, Inputs>::Uff),
      py::arg("i"), release_gil(), py::doc(
    "Returns an element of the previously calculated feedforward.\n"
"\n"
":param i: Row of uff.\n"
"\n"
":returns: The row of the calculated feedforward.")
  )
    
      .def("R", static_cast<const Eigen::Vector<double, States> & (frc::ControlAffinePlantInversionFeedforward<States, Inputs>::*)() const>(
&frc::ControlAffinePlantInversionFeedforward<States, Inputs>::R), release_gil(), py::doc(
    "Returns the current reference vector r.\n"
"\n"
":returns: The current reference vector.")
  )
    
      .def("R", static_cast<double (frc::ControlAffinePlantInversionFeedforward<States, Inputs>::*)(int) const>(
&frc::ControlAffinePlantInversionFeedforward<States, Inputs>::R),
      py::arg("i"), release_gil(), py::doc(
    "Returns an element of the reference vector r.\n"
"\n"
":param i: Row of r.\n"
"\n"
":returns: The row of the current reference vector.")
  )
    
      .def("reset", static_cast<void (frc::ControlAffinePlantInversionFeedforward<States, Inputs>::*)(const Eigen::Vector<double, States>&)>(
&frc::ControlAffinePlantInversionFeedforward<States, Inputs>::Reset),
      py::arg("initialState"), release_gil(), py::doc(
    "Resets the feedforward with a specified initial state vector.\n"
"\n"
":param initialState: The initial state vector.")
  )
    
      .def("reset", static_cast<void (frc::ControlAffinePlantInversionFeedforward<States, Inputs>::*)()>(
&frc::ControlAffinePlantInversionFeedforward<States, Inputs>::Reset), release_gil(), py::doc(
    "Resets the feedforward with a zero initial state vector.")
  )
    
      .def("calculate", static_cast<Eigen::Vector<double, Inputs > (frc::ControlAffinePlantInversionFeedforward<States, Inputs>::*)(const Eigen::Vector<double, States>&)>(
&frc::ControlAffinePlantInversionFeedforward<States, Inputs>::Calculate),
      py::arg("nextR"), release_gil(), py::doc(
    "Calculate the feedforward with only the desired\n"
"future reference. This uses the internally stored \"current\"\n"
"reference.\n"
"\n"
"If this method is used the initial state of the system is the one set using\n"
"Reset(const Eigen::Vector<double, States>&). If the initial state is not\n"
"set it defaults to a zero vector.\n"
"\n"
":param nextR: The reference state of the future timestep (k + dt).\n"
"\n"
":returns: The calculated feedforward.")
  )
    
      .def("calculate", static_cast<Eigen::Vector<double, Inputs > (frc::ControlAffinePlantInversionFeedforward<States, Inputs>::*)(const Eigen::Vector<double, States>&, const Eigen::Vector<double, States>&)>(
&frc::ControlAffinePlantInversionFeedforward<States, Inputs>::Calculate),
      py::arg("r"), py::arg("nextR"), release_gil(), py::doc(
    "Calculate the feedforward with current and future reference vectors.\n"
"\n"
":param r:     The reference state of the current timestep (k).\n"
":param nextR: The reference state of the future timestep (k + dt).\n"
"\n"
":returns: The calculated feedforward.")
  )
    
;

  

    if (set_doc) {
        cls_ControlAffinePlantInversionFeedforward.doc() = set_doc;
    }
    if (add_doc) {
        cls_ControlAffinePlantInversionFeedforward.doc() = py::cast<std::string>(cls_ControlAffinePlantInversionFeedforward.doc()) + add_doc;
    }

    
}

}; // struct bind_frc__ControlAffinePlantInversionFeedforward

}; // namespace rpygen