import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HashicupsProviderConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/hashicups#host HashicupsProvider#host}
    */
    readonly host?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/hashicups#password HashicupsProvider#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/hashicups#username HashicupsProvider#username}
    */
    readonly username?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/hashicups#alias HashicupsProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/hashicups hashicups}
*/
export declare class HashicupsProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "hashicups";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/hashicups hashicups} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HashicupsProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: HashicupsProviderConfig);
    private _host?;
    get host(): string | undefined;
    set host(value: string | undefined);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _password?;
    get password(): string | undefined;
    set password(value: string | undefined);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string | undefined;
    set username(value: string | undefined);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
