"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LaunchTemplate = exports.LaunchTemplateSpecialVersions = exports.SpotRequestType = exports.SpotInstanceInterruption = exports.InstanceInitiatedShutdownBehavior = exports.CpuCredits = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const _1 = require(".");
const connections_1 = require("./connections");
const ec2_generated_1 = require("./ec2.generated");
const ebs_util_1 = require("./private/ebs-util");
/**
 * Name tag constant
 */
const NAME_TAG = 'Name';
/**
 * Provides the options for specifying the CPU credit type for burstable EC2 instance types (T2, T3, T3a, etc).
 *
 * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances-how-to.html
 */
// dev-note: This could be used in the Instance L2
var CpuCredits;
(function (CpuCredits) {
    /**
     * Standard bursting mode.
     * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances-standard-mode.html
     */
    CpuCredits["STANDARD"] = "standard";
    /**
     * Unlimited bursting mode.
     * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances-unlimited-mode.html
     */
    CpuCredits["UNLIMITED"] = "unlimited";
})(CpuCredits = exports.CpuCredits || (exports.CpuCredits = {}));
;
/**
 * Provides the options for specifying the instance initiated shutdown behavior.
 *
 * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior
 */
// dev-note: This could be used in the Instance L2
var InstanceInitiatedShutdownBehavior;
(function (InstanceInitiatedShutdownBehavior) {
    /**
     * The instance will stop when it initiates a shutdown.
     */
    InstanceInitiatedShutdownBehavior["STOP"] = "stop";
    /**
     * The instance will be terminated when it initiates a shutdown.
     */
    InstanceInitiatedShutdownBehavior["TERMINATE"] = "terminate";
})(InstanceInitiatedShutdownBehavior = exports.InstanceInitiatedShutdownBehavior || (exports.InstanceInitiatedShutdownBehavior = {}));
;
/**
 * Provides the options for the types of interruption for spot instances.
 */
// dev-note: This could be used in a SpotFleet L2 if one gets developed.
var SpotInstanceInterruption;
(function (SpotInstanceInterruption) {
    /**
     * The instance will stop when interrupted.
     */
    SpotInstanceInterruption["STOP"] = "stop";
    /**
     * The instance will be terminated when interrupted.
     */
    SpotInstanceInterruption["TERMINATE"] = "terminate";
    /**
     * The instance will hibernate when interrupted.
     */
    SpotInstanceInterruption["HIBERNATE"] = "hibernate";
})(SpotInstanceInterruption = exports.SpotInstanceInterruption || (exports.SpotInstanceInterruption = {}));
/**
 * The Spot Instance request type.
 *
 * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html
 */
var SpotRequestType;
(function (SpotRequestType) {
    /**
     * A one-time Spot Instance request remains active until Amazon EC2 launches the Spot Instance,
     * the request expires, or you cancel the request. If the Spot price exceeds your maximum price
     * or capacity is not available, your Spot Instance is terminated and the Spot Instance request
     * is closed.
     */
    SpotRequestType["ONE_TIME"] = "one-time";
    /**
     * A persistent Spot Instance request remains active until it expires or you cancel it, even if
     * the request is fulfilled. If the Spot price exceeds your maximum price or capacity is not available,
     * your Spot Instance is interrupted. After your instance is interrupted, when your maximum price exceeds
     * the Spot price or capacity becomes available again, the Spot Instance is started if stopped or resumed
     * if hibernated.
     */
    SpotRequestType["PERSISTENT"] = "persistent";
})(SpotRequestType = exports.SpotRequestType || (exports.SpotRequestType = {}));
;
/**
 * A class that provides convenient access to special version tokens for LaunchTemplate
 * versions.
 */
class LaunchTemplateSpecialVersions {
}
exports.LaunchTemplateSpecialVersions = LaunchTemplateSpecialVersions;
_a = JSII_RTTI_SYMBOL_1;
LaunchTemplateSpecialVersions[_a] = { fqn: "@aws-cdk/aws-ec2.LaunchTemplateSpecialVersions", version: "1.159.0" };
/**
 * The special value that denotes that users of a Launch Template should
 * reference the LATEST version of the template.
 */
LaunchTemplateSpecialVersions.LATEST_VERSION = '$Latest';
/**
 * The special value that denotes that users of a Launch Template should
 * reference the DEFAULT version of the template.
 */
LaunchTemplateSpecialVersions.DEFAULT_VERSION = '$Default';
/**
 * This represents an EC2 LaunchTemplate.
 *
 * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html
 */
class LaunchTemplate extends core_1.Resource {
    // =============================================
    constructor(scope, id, props = {}) {
        var _c, _d, _e, _f, _g, _h;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ec2_LaunchTemplateProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        // Basic validation of the provided spot block duration
        const spotDuration = (_d = (_c = props === null || props === void 0 ? void 0 : props.spotOptions) === null || _c === void 0 ? void 0 : _c.blockDuration) === null || _d === void 0 ? void 0 : _d.toHours({ integral: true });
        if (spotDuration !== undefined && (spotDuration < 1 || spotDuration > 6)) {
            // See: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html#fixed-duration-spot-instances
            core_1.Annotations.of(this).addError('Spot block duration must be exactly 1, 2, 3, 4, 5, or 6 hours.');
        }
        this.role = props.role;
        this._grantPrincipal = this.role;
        const iamProfile = this.role ? new iam.CfnInstanceProfile(this, 'Profile', {
            roles: [this.role.roleName],
        }) : undefined;
        if (props.securityGroup) {
            this._connections = new connections_1.Connections({ securityGroups: [props.securityGroup] });
        }
        const securityGroupsToken = core_1.Lazy.list({
            produce: () => {
                if (this._connections && this._connections.securityGroups.length > 0) {
                    return this._connections.securityGroups.map(sg => sg.securityGroupId);
                }
                return undefined;
            },
        });
        if (props.userData) {
            this.userData = props.userData;
        }
        const userDataToken = core_1.Lazy.string({
            produce: () => {
                if (this.userData) {
                    return core_1.Fn.base64(this.userData.render());
                }
                return undefined;
            },
        });
        const imageConfig = (_e = props.machineImage) === null || _e === void 0 ? void 0 : _e.getImage(this);
        if (imageConfig) {
            this.osType = imageConfig.osType;
            this.imageId = imageConfig.imageId;
        }
        this.instanceType = props.instanceType;
        let marketOptions = undefined;
        if (props === null || props === void 0 ? void 0 : props.spotOptions) {
            marketOptions = {
                marketType: 'spot',
                spotOptions: {
                    blockDurationMinutes: spotDuration !== undefined ? spotDuration * 60 : undefined,
                    instanceInterruptionBehavior: props.spotOptions.interruptionBehavior,
                    maxPrice: (_f = props.spotOptions.maxPrice) === null || _f === void 0 ? void 0 : _f.toString(),
                    spotInstanceType: props.spotOptions.requestType,
                    validUntil: (_g = props.spotOptions.validUntil) === null || _g === void 0 ? void 0 : _g.date.toUTCString(),
                },
            };
            // Remove SpotOptions if there are none.
            if (Object.keys(marketOptions.spotOptions).filter(k => marketOptions.spotOptions[k]).length == 0) {
                marketOptions.spotOptions = undefined;
            }
        }
        this.tags = new core_1.TagManager(core_1.TagType.KEY_VALUE, 'AWS::EC2::LaunchTemplate');
        const tagsToken = core_1.Lazy.any({
            produce: () => {
                if (this.tags.hasTags()) {
                    const renderedTags = this.tags.renderTags();
                    const lowerCaseRenderedTags = renderedTags.map((tag) => {
                        return {
                            key: tag.Key,
                            value: tag.Value,
                        };
                    });
                    return [
                        {
                            resourceType: 'instance',
                            tags: lowerCaseRenderedTags,
                        },
                        {
                            resourceType: 'volume',
                            tags: lowerCaseRenderedTags,
                        },
                    ];
                }
                return undefined;
            },
        });
        const resource = new ec2_generated_1.CfnLaunchTemplate(this, 'Resource', {
            launchTemplateName: props === null || props === void 0 ? void 0 : props.launchTemplateName,
            launchTemplateData: {
                blockDeviceMappings: (props === null || props === void 0 ? void 0 : props.blockDevices) !== undefined ? ebs_util_1.launchTemplateBlockDeviceMappings(this, props.blockDevices) : undefined,
                creditSpecification: (props === null || props === void 0 ? void 0 : props.cpuCredits) !== undefined ? {
                    cpuCredits: props.cpuCredits,
                } : undefined,
                disableApiTermination: props === null || props === void 0 ? void 0 : props.disableApiTermination,
                ebsOptimized: props === null || props === void 0 ? void 0 : props.ebsOptimized,
                enclaveOptions: (props === null || props === void 0 ? void 0 : props.nitroEnclaveEnabled) !== undefined ? {
                    enabled: props.nitroEnclaveEnabled,
                } : undefined,
                hibernationOptions: (props === null || props === void 0 ? void 0 : props.hibernationConfigured) !== undefined ? {
                    configured: props.hibernationConfigured,
                } : undefined,
                iamInstanceProfile: iamProfile !== undefined ? {
                    arn: iamProfile.getAtt('Arn').toString(),
                } : undefined,
                imageId: imageConfig === null || imageConfig === void 0 ? void 0 : imageConfig.imageId,
                instanceType: (_h = props === null || props === void 0 ? void 0 : props.instanceType) === null || _h === void 0 ? void 0 : _h.toString(),
                instanceInitiatedShutdownBehavior: props === null || props === void 0 ? void 0 : props.instanceInitiatedShutdownBehavior,
                instanceMarketOptions: marketOptions,
                keyName: props === null || props === void 0 ? void 0 : props.keyName,
                monitoring: (props === null || props === void 0 ? void 0 : props.detailedMonitoring) !== undefined ? {
                    enabled: props.detailedMonitoring,
                } : undefined,
                securityGroupIds: securityGroupsToken,
                tagSpecifications: tagsToken,
                userData: userDataToken,
            },
        });
        core_1.Tags.of(this).add(NAME_TAG, this.node.path);
        this.defaultVersionNumber = resource.attrDefaultVersionNumber;
        this.latestVersionNumber = resource.attrLatestVersionNumber;
        this.launchTemplateId = resource.ref;
        this.versionNumber = core_1.Token.asString(resource.getAtt('LatestVersionNumber'));
        if (props.requireImdsv2) {
            core_1.Aspects.of(this).add(new _1.LaunchTemplateRequireImdsv2Aspect());
        }
    }
    /**
     * Import an existing LaunchTemplate.
     */
    static fromLaunchTemplateAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ec2_LaunchTemplateAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromLaunchTemplateAttributes);
            }
            throw error;
        }
        const haveId = Boolean(attrs.launchTemplateId);
        const haveName = Boolean(attrs.launchTemplateName);
        if (haveId == haveName) {
            throw new Error('LaunchTemplate.fromLaunchTemplateAttributes() requires exactly one of launchTemplateId or launchTemplateName be provided.');
        }
        class Import extends core_1.Resource {
            constructor() {
                var _c;
                super(...arguments);
                this.versionNumber = (_c = attrs.versionNumber) !== null && _c !== void 0 ? _c : LaunchTemplateSpecialVersions.DEFAULT_VERSION;
                this.launchTemplateId = attrs.launchTemplateId;
                this.launchTemplateName = attrs.launchTemplateName;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Allows specifying security group connections for the instance.
     *
     * @note Only available if you provide a securityGroup when constructing the LaunchTemplate.
     */
    get connections() {
        if (!this._connections) {
            throw new Error('LaunchTemplate can only be used as IConnectable if a securityGroup is provided when constructing it.');
        }
        return this._connections;
    }
    /**
     * Principal to grant permissions to.
     *
     * @note Only available if you provide a role when constructing the LaunchTemplate.
     */
    get grantPrincipal() {
        if (!this._grantPrincipal) {
            throw new Error('LaunchTemplate can only be used as IGrantable if a role is provided when constructing it.');
        }
        return this._grantPrincipal;
    }
}
exports.LaunchTemplate = LaunchTemplate;
_b = JSII_RTTI_SYMBOL_1;
LaunchTemplate[_b] = { fqn: "@aws-cdk/aws-ec2.LaunchTemplate", version: "1.159.0" };
//# sourceMappingURL=data:application/json;base64,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