/**
 * (experimental) Available log levels for Flink applications.
 *
 * @experimental
 */
export declare enum LogLevel {
    /**
     * (experimental) Debug level logging.
     *
     * @experimental
     */
    DEBUG = "DEBUG",
    /**
     * (experimental) Info level logging.
     *
     * @experimental
     */
    INFO = "INFO",
    /**
     * (experimental) Warn level logging.
     *
     * @experimental
     */
    WARN = "WARN",
    /**
     * (experimental) Error level logging.
     *
     * @experimental
     */
    ERROR = "ERROR"
}
/**
 * (experimental) Granularity of metrics sent to CloudWatch.
 *
 * @experimental
 */
export declare enum MetricsLevel {
    /**
     * (experimental) Application sends the least metrics to CloudWatch.
     *
     * @experimental
     */
    APPLICATION = "APPLICATION",
    /**
     * (experimental) Task includes task-level metrics sent to CloudWatch.
     *
     * @experimental
     */
    TASK = "TASK",
    /**
     * (experimental) Operator includes task-level and operator-level metrics sent to CloudWatch.
     *
     * @experimental
     */
    OPERATOR = "OPERATOR",
    /**
     * (experimental) Send all metrics including metrics per task thread.
     *
     * @experimental
     */
    PARALLELISM = "PARALLELISM"
}
/**
 * (experimental) Interface for building AWS::KinesisAnalyticsV2::Application PropertyGroup configuration.
 *
 * @experimental
 */
export interface PropertyGroups {
    readonly [propertyId: string]: {
        [mapKey: string]: string;
    };
}
/**
 * (experimental) Available Flink runtimes for Kinesis Analytics.
 *
 * @experimental
 */
export declare class Runtime {
    /**
     * (experimental) Flink Version 1.6.
     *
     * @experimental
     */
    static readonly FLINK_1_6: Runtime;
    /**
     * (experimental) Flink Version 1.8.
     *
     * @experimental
     */
    static readonly FLINK_1_8: Runtime;
    /**
     * (experimental) Flink Version 1.11.
     *
     * @experimental
     */
    static readonly FLINK_1_11: Runtime;
    /**
     * (experimental) Flink Version 1.13.
     *
     * @experimental
     */
    static readonly FLINK_1_13: Runtime;
    /**
     * (experimental) Create a new Runtime with with an arbitrary Flink version string.
     *
     * @experimental
     */
    static of(value: string): Runtime;
    /**
     * (experimental) The Cfn string that represents a version of Flink.
     *
     * @experimental
     */
    readonly value: string;
    private constructor();
}
