# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))
import pkg_resources  # part of setuptools

# -- Project information -----------------------------------------------------

project = "linopy"
copyright = "2021, Fabian Hofmann"
author = "Fabian Hofmann"

# The full version, including alpha/beta/rc tags
version = pkg_resources.get_distribution("linopy").version
release = "master" if "dev" in version else version

# For some reason is this needed, otherwise autosummary does fail on RTD but not locally
import linopy  # noqa

# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",  # Core Sphinx library for auto html doc generation from docstrings
    "sphinx.ext.autosummary",  # Create neat summary tables for modules/classes/methods etc
    "sphinx.ext.intersphinx",
    "sphinx.ext.napoleon",
    "sphinx.ext.mathjax",
    "nbsphinx",
    "nbsphinx_link",
    "sphinx.ext.imgconverter",  # for SVG conversion
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = "en"

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ["_build", "Thumbs.db", ".DS_Store", "**.ipynb_checkpoints"]


source_suffix = {
    ".rst": "restructuredtext",
    ".txt": "markdown",
    ".md": "markdown",
}

# Autosummary

autosummary_generate = True
autodoc_typehints = "none"

# Napoleon configurations

napoleon_google_docstring = False
napoleon_numpy_docstring = True
napoleon_use_param = False
napoleon_use_rtype = False
napoleon_preprocess_types = True


# -- Options for nbsphinx -------------------------------------------------
nbsphinx_prolog = """
{% set docname = env.doc2path(env.docname, base=None).replace("nblink","ipynb") %}
.. note::

    You can `download <https://github.com/pypsa/linopy/tree/v{{ env.config.release|e }}/examples/{{ docname }}>`_ this example as a Jupyter notebook
    or start it `in interactive mode <https://mybinder.org/v2/gh/PyPSA/linopy/v{{ env.config.release|e }}?filepath=examples/{{ docname|e }}>`_.

"""

nbsphinx_allow_errors = False

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = "sphinx_book_theme"

html_title = "Linopy: Optimization with n-dimensional labeled variables"


# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
html_theme_options = {
    "repository_url": "https://github.com/pypsa/linopy",
    "use_repository_button": True,
}


# These folders are copied to the documentation's HTML output
html_static_path = ["_static"]
html_logo = "logo.png"


# These paths are either relative to html_static_path
# or fully qualified paths (eg. https://...)
html_css_files = ["theme_overrides.css"]
