from .base_model import *


class HltTap(BaseModel):
    """
    Талон амбулаторного пациента
    """
    id = models.AutoField(db_column='TAPID', primary_key=True)
    uuid = models.CharField(db_column='UGUID', max_length=36, unique=True, default=uuid.uuid4)
    mkab = models.ForeignKey('HltMkab', models.DO_NOTHING, db_column='rf_MKABID', related_name='taps')
    katl = models.IntegerField(db_column='rf_KATLID')
    mkb = models.ForeignKey('OmsMkb', db_column='rf_MKBID', **FK_DEFAULT)
    mkb2 = models.ForeignKey('OmsMkb', db_column='rf_MKB2ID', **FK_DEFAULT)
    reason_care = models.ForeignKey('HltReasonCare', db_column='rf_ReasonCareID', **FK_DEFAULT)
    care_person_sex = models.BooleanField(db_column='CarePersonSex')
    care_person_age = models.IntegerField(db_column='CarePersonAge')
    date_tap = models.DateTimeField(db_column='DateTAP')
    inv = models.IntegerField(db_column='rf_INVID')
    not_work_doc_status = models.IntegerField(db_column='rf_NotWorkDocStatusID')
    date_close = models.DateTimeField(db_column='DateClose')
    lpu_doctor = models.ForeignKey('HltLpuDoctor', db_column='rf_LPUDoctorID', **FK_DEFAULT)
    lpu_doctor_s = models.ForeignKey('HltLpuDoctor', db_column='rf_LPUDoctor_SID', **FK_DEFAULT)
    smo = models.ForeignKey('OmsSmo', db_column='rf_SMOID', **FK_DEFAULT)
    other_smo = models.ForeignKey('OmsSmo', db_column='rf_OtherSMOID', **FK_DEFAULT)
    s_pol = models.CharField(db_column='S_POL', max_length=50)
    n_pol = models.CharField(db_column='N_POL', max_length=50)
    is_closed = models.BooleanField(db_column='IsClosed')
    is_worker = models.BooleanField(db_column='isWorker')
    spec_event_cert_id = models.IntegerField(db_column='rf_SpecEventCertID')
    care_begin = models.DateTimeField(db_column='CareBegin')
    care_end = models.DateTimeField(db_column='CareEnd')
    family = models.CharField(db_column='FAMILY', max_length=40)
    mkab_sheet_final_ds = models.IntegerField(db_column='rf_MKABSheetFinalDSID')
    direction_id = models.IntegerField(db_column='rf_DirectionID')
    outcome_visit_id = models.IntegerField(db_column='rf_OutcomeVisitID')
    description = models.CharField(db_column='Description', max_length=1000)
    profit_type = models.ForeignKey('OmsKlProfitType', db_column='rf_kl_ProfitTypeID', **FK_DEFAULT)
    disp_reg_state_id = models.IntegerField(db_column='rf_kl_DispRegStateID')
    disp_reg_state2_id = models.IntegerField(db_column='rf_kl_DispRegState2ID')
    disease_type = models.ForeignKey('OmsKlDiseaseType', db_column='rf_kl_DiseaseTypeID', **FK_DEFAULT)
    disease_type2 = models.ForeignKey('OmsKlDiseaseType', db_column='rf_kl_DiseaseType2ID', **FK_DEFAULT)
    trauma_type_id = models.IntegerField(db_column='rf_kl_TraumaTypeID')
    sick_list_reason = models.IntegerField(db_column='rf_kl_SickListReasonID')
    visit_result = models.ForeignKey('OmsKlVisitResult', db_column='rf_kl_VisitResultID', **FK_DEFAULT)
    registration_end_reason_id = models.IntegerField(db_column='rf_kl_RegistrationEndReasonID')
    registration_end_reason2_id = models.IntegerField(db_column='rf_kl_RegistrationEndReason2ID')
    health_group_id = models.IntegerField(db_column='rf_kl_HealthGroupID')
    visit_place = models.ForeignKey('OmsKlVisitPlace', db_column='rf_kl_VisitPlaceID', **FK_DEFAULT)
    reason_type = models.ForeignKey('OmsKlReasonType', db_column='rf_kl_ReasonTypeID', **FK_DEFAULT)
    department = models.ForeignKey('OmsDepartment', db_column='rf_DepartmentID', **FK_DEFAULT)
    soc_status = models.ForeignKey('OmsKlSocStatus', db_column='rf_kl_SocStatusID', **FK_DEFAULT)
    create_username = models.CharField(db_column='CreateUserName', max_length=255)
    edit_username = models.CharField(db_column='EditUserName', max_length=255)
    flag_bill = models.BooleanField(db_column='FlagBill')
    flag_statist = models.BooleanField(db_column='FlagStatist')
    create_user = models.ForeignKey('XUser', db_column='rf_CreateUserID', **FK_DEFAULT)
    edit_user = models.ForeignKey('XUser', db_column='rf_EditUserID', **FK_DEFAULT)
    stat_cure_result = models.ForeignKey('OmsKlStatCureResult', db_column='rf_kl_StatCureResultID', **FK_DEFAULT)
    polis_mkab_id = models.IntegerField(db_column='rf_PolisMKABID')
    type_tap_id = models.IntegerField(db_column='rf_TypeTAPID')
    registr_patient_id = models.IntegerField(db_column='rf_RegistrPatientID')
    doc_prvd = models.ForeignKey('HltDocPrvd', db_column='rf_DocPRVDID', **FK_DEFAULT)
    mkp_card = models.UUIDField(db_column='rf_mkp_CardGUID')
    date_create_tap = models.DateTimeField(db_column='DateCreateTAP')
    num_in_other_system = models.CharField(db_column='NumInOtherSystem', max_length=50)
    is_dvn_closed = models.BooleanField(db_column='isDVNClosed')
    med_care_type = models.ForeignKey('OmsKlMedCareType', db_column='rf_kl_MedCareTypeID', **FK_DEFAULT)
    disability_status = models.IntegerField(db_column='DisabilityStatus')
    reason_inv_id = models.IntegerField(db_column='rf_kl_ReasonInvID')
    mkb_external = models.ForeignKey('OmsMkb', db_column='rf_MKBExternalID', **FK_DEFAULT)
    sanitation_id = models.IntegerField(db_column='rf_kl_SanitationID')
    patient_status_id = models.IntegerField(db_column='rf_kl_PatientStatusID')
    onco_sign_id = models.IntegerField(db_column='rf_onco_SignID')
    dd_service = models.ForeignKey('OmsKlDDService', db_column='rf_kl_DDServiceID', **FK_DEFAULT)
    tip_oms = models.ForeignKey('OmsKlTipOms', db_column='rf_kl_TipOMSID', **FK_DEFAULT)
    num = models.IntegerField(db_column='Num')

    flags = models.IntegerField(db_column='Flags')

    class Meta:
        managed = False
        db_table = 'hlt_TAP'
