# django-static-fontawesome

Django application contain font-awesome static files

## Install

    pip install django-static-fontawesome

## Fontawesome License

- All resource files of static\fontawesome are unzip from fontawesome-free-xx.xx.xx-web.zip which download from https://fontawesome.com without any changes.
- All resource files of static\fontawesome obey Font Awesome Pro License, see details at https://fontawesome.com/license.
- We don't guarantee the latest fontawesome version.

## Settings

**pro/settings.py**

```python
    INSTALLED_APPS = [
        ...
        "django_static_fontawesome",
        ...
    ]
```

## Use static files

**page.html**

```python
    {% load staticfiles %}

    {% block style %}
        <link rel="stylesheet" type="text/css" href="{% static "fontawesome/css/all.min.css" %}" />
    {% endblock %}

    <i class="far fa-home"></i> Home
```

## Use demo page

**pro/urls.py**

```python
from django.urls import path, include

urlpatterns = [
    path('fontawesome/', include("django_static_fontawesome.urls")),
]
```

- Start test server by command: python manage.py runserver
- Visit demo page: http://127.0.0.1:8000/fontawesome/demo.

## About releases

- The first three number is the same with fontawesome project's version.
- The fourth number is our release number, it's optional.

## Releases


### v5.12.1.2 2020/03/07

- Fix setup.py.

### v5.12.1.1 2020/02/26

- App rename to django_static_fontawesome.

### v5.12.1 2020/02/11

- Upgrade fontawesome static files to version 5.12.1.
- Add demo page.

### v5.10.2 2019/09/07

- Use fontawesome 5.10.2.

### v5.0.8.1 2018/03/27

- Use fontawesome 5.0.8.

### v5.0.2 2017/10/21

- First release.
