"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const apigateway = require("aws-cdk-lib/aws-apigateway");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const lambda_invocation_1 = require("../lambda-invocation");
const base_1 = require("./base");
/** Defines an AWS Lambda integration. */
class LambdaIntegration extends base_1.Integration {
    /**
     * Defines an AWS Lambda integration.
     *
     * @example
     * '/message': {
     *    'POST': new openapix.LambdaIntegration(this, fn),
     * },
     */
    constructor(scope, fn, props) {
        const lambdaInvocation = new lambda_invocation_1.LambdaInvocation(scope, fn);
        const integration = {
            type: LambdaIntegration.selectIntegrationType(props?.proxy),
            uri: lambdaInvocation.uri,
            integrationHttpMethod: 'POST',
            options: props,
        };
        const config = {
            type: base_1.InternalIntegrationType.LAMBDA,
            validator: props?.validator,
        };
        super(integration, config);
        this.fn = fn;
    }
    /**
     * Selects the Lambda integration type.
     *
     * @default
     * 'AWS_PROXY'
     */
    static selectIntegrationType(proxy) {
        if (proxy === false) {
            return apigateway.IntegrationType.AWS;
        }
        // default to proxy as CDK does
        return apigateway.IntegrationType.AWS_PROXY;
    }
    /** Allow Lambda invoke action to be performed by given identity. */
    grantFunctionInvoke(scope, executeApiArn) {
        /**
         * using Lambda-constructs grant-functions cause circular dependencies if they are defined in different stacks
         */
        new aws_lambda_1.CfnPermission(scope, `InvokePermissionFor${this.fn.node.id}`, {
            principal: 'apigateway.amazonaws.com',
            action: 'lambda:InvokeFunction',
            functionName: this.fn.functionName,
            sourceArn: executeApiArn,
        });
    }
}
exports.LambdaIntegration = LambdaIntegration;
_a = JSII_RTTI_SYMBOL_1;
LambdaIntegration[_a] = { fqn: "@alma-cdk/openapix.LambdaIntegration", version: "0.0.50" };
//# sourceMappingURL=data:application/json;base64,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