"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaAuthorizer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
const lambda_invocation_1 = require("../lambda-invocation");
// implements AuthorizerConfig ... JSII doesn't like
class LambdaAuthorizer extends constructs_1.Construct {
    constructor(scope, id, props) {
        const { fn, identitySource, type, authType: authtype, resultsCacheTtl } = props;
        super(scope, id);
        this.id = id;
        this.fn = fn;
        this.xAmazonApigatewayAuthtype = authtype;
        this.xAmazonApigatewayAuthorizer = {
            type,
            authorizerUri: new lambda_invocation_1.LambdaInvocation(scope, fn).uri,
            identitySource,
            authorizerResultTtlInSeconds: (function () {
                if (typeof resultsCacheTtl !== 'undefined') {
                    return resultsCacheTtl.toSeconds();
                }
                return undefined;
            }()),
        };
    }
    /**
     * Allow Lambda invoke action to be performed by given identity.
     *
     * The ARN format for authorizers is different compared to integrations when granting permissions,
     * ex. arn:aws:execute-api:us-east-1:123456789012:api-id/authorizers/authorizer-id
    */
    grantFunctionInvoke(api) {
        const authorizerArn = aws_cdk_lib_1.Stack.of(this).formatArn({
            service: 'execute-api',
            resource: api.restApiId,
            resourceName: 'authorizers/*',
        });
        /**
         * using Lambda-constructs grant-functions cause circular dependencies if they are defined in different stacks
         */
        new aws_lambda_1.CfnPermission(api, `InvokePermissionForAuthorizer${this.fn.node.id}`, {
            principal: 'apigateway.amazonaws.com',
            action: 'lambda:InvokeFunction',
            functionName: this.fn.functionName,
            sourceArn: authorizerArn,
        });
    }
}
exports.LambdaAuthorizer = LambdaAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
LambdaAuthorizer[_a] = { fqn: "@alma-cdk/openapix.LambdaAuthorizer", version: "0.0.50" };
//# sourceMappingURL=data:application/json;base64,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