"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Api = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
const authorizers_1 = require("../authorizers");
const base_1 = require("../integration/base");
const definition_1 = require("./definition");
/**
 * AWS API Gateway REST API defined with OpenApi v3 schema.
 */
class Api extends aws_apigateway_1.SpecRestApi {
    /**
     * Define a new API Gateway REST API using OpenApi v3 Schema definition.
     *
     * @example
     * const fn: IFunction;
     *
     * new openapix.Api(this, 'MyApi', {
     *   source: './schema.yaml',
     *   paths: {
     *     '/foo': {
     *       get: new openapix.MockIntegration(this),
     *     },
     *     '/bar': {
     *       post: new openapix.LambdaIntegration(this, fn),
     *     },
     *   }
     * })
     *
     */
    constructor(scope, id, props) {
        const apiDefinition = new definition_1.ApiDefinition(scope, {
            source: props.source,
            upload: props.upload === true,
            paths: props.paths || {},
            authorizers: props.authorizers || [],
            validators: props.validators || {},
            defaultCors: props.defaultCors,
            injections: props.injections || {},
            rejections: props.rejections || [],
            rejectionsDeep: props.rejectionsDeep || [],
            defaultIntegration: props.defaultIntegration,
        });
        super(scope, id, {
            apiDefinition: apiDefinition,
            endpointTypes: [aws_apigateway_1.EndpointType.REGIONAL],
            ...props.restApiProps,
        });
        // Allow the API Gateway to invoke given Lambda function integrations
        this.grantLambdaInvokes(props.paths);
        // Allow the API Gateway to invoke given Lambda authorizer integrations
        this.grantLambdaAuthorizerInvokes(props.authorizers);
        // Expose the processed OpenApi v3 document.
        // Mainly used for testing.
        this.document = apiDefinition.document;
    }
    /** Allow Lambda invocations to API Gateway instance principal */
    grantLambdaInvokes(paths = {}) {
        // get unique integration functions
        const integrations = [...new Map(Object.values(paths)
                .reduce((acc, val) => val ? [...acc, ...Object.values(val)] : acc, [])
                .filter((val) => !!val && this.isLambdaIntegration(val) && !val.xAmazonApigatewayIntegration.credentials)
                .map(val => [val.fn.functionArn, val])).values()];
        integrations.forEach((integration) => {
            integration.grantFunctionInvoke(this, this.arnForExecuteApi());
        });
    }
    /** Allow Lambda authorizer invocations to API Gateway instance principal */
    grantLambdaAuthorizerInvokes(authorizers) {
        if (!authorizers) {
            return;
        }
        // filter duplicate authorizers
        const uniqueLambdaAuthorizers = [...new Map(Object.values(authorizers)
                .filter((val) => {
                return val instanceof authorizers_1.LambdaAuthorizer && !val.xAmazonApigatewayAuthorizer.authorizerCredentials;
            })
                .map(val => [val.fn.functionArn, val])).values()];
        uniqueLambdaAuthorizers.forEach(authorizer => {
            authorizer.grantFunctionInvoke(this);
        });
    }
    /** Determine if the integration internal type is `LAMBDA`. */
    isLambdaIntegration(integration) {
        return integration.type === base_1.InternalIntegrationType.LAMBDA;
    }
}
exports.Api = Api;
_a = JSII_RTTI_SYMBOL_1;
Api[_a] = { fqn: "@alma-cdk/openapix.Api", version: "0.0.50" };
//# sourceMappingURL=data:application/json;base64,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