import { SpecRestApi } from 'aws-cdk-lib/aws-apigateway';
import { Construct } from 'constructs';
import { IDocument } from '../schema';
import { ApiProps } from './props';
/**
 * AWS API Gateway REST API defined with OpenApi v3 schema.
 */
export declare class Api extends SpecRestApi {
    /**
     * The final OpenApi v3 document used to generate the AWS API Gateway.
     */
    readonly document: IDocument;
    /**
     * Define a new API Gateway REST API using OpenApi v3 Schema definition.
     *
     * @example
     * const fn: IFunction;
     *
     * new openapix.Api(this, 'MyApi', {
     *   source: './schema.yaml',
     *   paths: {
     *     '/foo': {
     *       get: new openapix.MockIntegration(this),
     *     },
     *     '/bar': {
     *       post: new openapix.LambdaIntegration(this, fn),
     *     },
     *   }
     * })
     *
     */
    constructor(scope: Construct, id: string, props: ApiProps);
    /** Allow Lambda invocations to API Gateway instance principal */
    private grantLambdaInvokes;
    /** Allow Lambda authorizer invocations to API Gateway instance principal */
    private grantLambdaAuthorizerInvokes;
    /** Determine if the integration internal type is `LAMBDA`. */
    private isLambdaIntegration;
}
