"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const client_s3_1 = require("@aws-sdk/client-s3");
const s3Client = new client_s3_1.S3Client({});
async function handler(event) {
    const request = event.Records[0].cf.request;
    try {
        const s3Origin = request.origin?.s3;
        if (!s3Origin) {
            throw new Error('No S3 origin');
        }
        const bucket = s3Origin.domainName.replace(new RegExp(`.s3.${s3Origin.region}.amazonaws.com$`), '');
        const key = request.uri.substring(1); // remove first slash
        const data = await s3Client.send(new client_s3_1.GetObjectCommand({
            Bucket: bucket,
            Key: key,
        }));
        if (!data.Body) {
            throw new Error('No body');
        }
        const redirect = JSON.parse(data.Body.toString());
        return {
            status: '301',
            statusDescription: 'Moved Permanently',
            headers: {
                location: [{
                        key: 'Location',
                        value: redirect.url,
                    }],
            },
        };
    }
    catch (err) {
        console.log(err);
        return {
            status: '404',
            statusDescription: 'Not Found',
        };
    }
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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