"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const client_cloudformation_1 = require("@aws-sdk/client-cloudformation");
const cloudFormationClient = new client_cloudformation_1.CloudFormationClient({});
async function handler(stackName) {
    const template = await cloudFormationClient.send(new client_cloudformation_1.GetTemplateCommand({
        StackName: stackName,
    }));
    if (!template.TemplateBody) {
        return [];
    }
    const hashes = template.TemplateBody.match(/[a-f0-9]{64}/g);
    return [...new Set(hashes)];
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXh0cmFjdC10ZW1wbGF0ZS1oYXNoZXMubGFtYmRhLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3Rvb2xraXQtY2xlYW5lci9leHRyYWN0LXRlbXBsYXRlLWhhc2hlcy5sYW1iZGEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsMEVBQTBGO0FBRTFGLE1BQU0sb0JBQW9CLEdBQUcsSUFBSSw0Q0FBb0IsQ0FBQyxFQUFFLENBQUMsQ0FBQztBQUVuRCxLQUFLLFVBQVUsT0FBTyxDQUFDLFNBQWlCO0lBQzdDLE1BQU0sUUFBUSxHQUFHLE1BQU0sb0JBQW9CLENBQUMsSUFBSSxDQUFDLElBQUksMENBQWtCLENBQUM7UUFDdEUsU0FBUyxFQUFFLFNBQVM7S0FDckIsQ0FBQyxDQUFDLENBQUM7SUFFSixJQUFJLENBQUMsUUFBUSxDQUFDLFlBQVksRUFBRTtRQUMxQixPQUFPLEVBQUUsQ0FBQztLQUNYO0lBRUQsTUFBTSxNQUFNLEdBQUcsUUFBUSxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsZUFBZSxDQUFDLENBQUM7SUFFNUQsT0FBTyxDQUFDLEdBQUcsSUFBSSxHQUFHLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztBQUM5QixDQUFDO0FBWkQsMEJBWUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDbG91ZEZvcm1hdGlvbkNsaWVudCwgR2V0VGVtcGxhdGVDb21tYW5kIH0gZnJvbSAnQGF3cy1zZGsvY2xpZW50LWNsb3VkZm9ybWF0aW9uJztcblxuY29uc3QgY2xvdWRGb3JtYXRpb25DbGllbnQgPSBuZXcgQ2xvdWRGb3JtYXRpb25DbGllbnQoe30pO1xuXG5leHBvcnQgYXN5bmMgZnVuY3Rpb24gaGFuZGxlcihzdGFja05hbWU6IHN0cmluZykge1xuICBjb25zdCB0ZW1wbGF0ZSA9IGF3YWl0IGNsb3VkRm9ybWF0aW9uQ2xpZW50LnNlbmQobmV3IEdldFRlbXBsYXRlQ29tbWFuZCh7XG4gICAgU3RhY2tOYW1lOiBzdGFja05hbWUsXG4gIH0pKTtcblxuICBpZiAoIXRlbXBsYXRlLlRlbXBsYXRlQm9keSkge1xuICAgIHJldHVybiBbXTtcbiAgfVxuXG4gIGNvbnN0IGhhc2hlcyA9IHRlbXBsYXRlLlRlbXBsYXRlQm9keS5tYXRjaCgvW2EtZjAtOV17NjR9L2cpO1xuXG4gIHJldHVybiBbLi4ubmV3IFNldChoYXNoZXMpXTtcbn1cbiJdfQ==