"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const path = require("path");
const client_s3_1 = require("@aws-sdk/client-s3");
const s3Client = new client_s3_1.S3Client({});
async function handler(assetHashes) {
    if (!process.env.BUCKET_NAME) {
        throw new Error('Missing BUCKET_NAME');
    }
    let deleted = 0;
    let reclaimed = 0;
    let nextKeyMarker;
    let finished = false;
    while (!finished) {
        const response = await s3Client.send(new client_s3_1.ListObjectVersionsCommand({
            Bucket: process.env.BUCKET_NAME,
            KeyMarker: nextKeyMarker,
        }));
        const toDelete = response.Versions?.filter(v => {
            if (!v.Key) {
                return false;
            }
            const hash = path.basename(v.Key, path.extname(v.Key));
            let pred = !assetHashes.includes(hash);
            if (process.env.RETAIN_MILLISECONDS) {
                if (!v.LastModified) {
                    return false;
                }
                const limitDate = new Date(Date.now() - parseInt(process.env.RETAIN_MILLISECONDS));
                pred = pred && v.LastModified < limitDate;
            }
            return pred;
        });
        if (toDelete && toDelete.length !== 0) {
            if (process.env.RUN) {
                await s3Client.send(new client_s3_1.DeleteObjectsCommand({
                    Bucket: process.env.BUCKET_NAME,
                    Delete: {
                        Objects: toDelete.map(v => ({ Key: v.Key, VersionId: v.VersionId })),
                    },
                }));
            }
            deleted += toDelete.length;
            reclaimed += toDelete.reduce((acc, x) => acc + (x.Size ?? 0), 0);
        }
        nextKeyMarker = response.NextKeyMarker;
        if (nextKeyMarker === undefined) {
            finished = true;
        }
    }
    return {
        Deleted: deleted,
        Reclaimed: reclaimed,
    };
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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